# pylint:disable=line-too-long
import logging

from ...sim_type import SimTypeFunction,     SimTypeShort, SimTypeInt, SimTypeLong, SimTypeLongLong, SimTypeDouble, SimTypeFloat,     SimTypePointer,     SimTypeChar,     SimStruct,     SimTypeFixedSizeArray,     SimTypeBottom,     SimUnion,     SimTypeBool
from ...calling_conventions import SimCCStdcall, SimCCMicrosoftAMD64
from .. import SIM_PROCEDURES as P
from . import SimLibrary


_l = logging.getLogger(name=__name__)


lib = SimLibrary()
lib.set_default_cc('X86', SimCCStdcall)
lib.set_default_cc('AMD64', SimCCMicrosoftAMD64)
lib.set_library_names("advapi32.dll")
prototypes = \
    {
        # 
        'IsTextUnicode': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=False, label="IS_TEXT_UNICODE_RESULT"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpv", "iSize", "lpiResult"]),
        # 
        'LsaFreeMemory': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Buffer"]),
        # 
        'LsaClose': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ObjectHandle"]),
        # 
        'LsaOpenPolicy': SimTypeFunction([SimTypePointer(SimStruct({"Length": SimTypeShort(signed=False, label="UInt16"), "MaximumLength": SimTypeShort(signed=False, label="UInt16"), "Buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="UNICODE_STRING", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Length": SimTypeInt(signed=False, label="UInt32"), "RootDirectory": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ObjectName": SimTypePointer(SimStruct({"Length": SimTypeShort(signed=False, label="UInt16"), "MaximumLength": SimTypeShort(signed=False, label="UInt16"), "Buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="UNICODE_STRING", pack=False, align=None), offset=0), "Attributes": SimTypeInt(signed=False, label="UInt32"), "SecurityDescriptor": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SecurityQualityOfService": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="OBJECT_ATTRIBUTES", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["SystemName", "ObjectAttributes", "DesiredAccess", "PolicyHandle"]),
        # 
        'LsaSetCAPs': SimTypeFunction([SimTypePointer(SimStruct({"Length": SimTypeShort(signed=False, label="UInt16"), "MaximumLength": SimTypeShort(signed=False, label="UInt16"), "Buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="UNICODE_STRING", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["CAPDNs", "CAPDNCount", "Flags"]),
        # 
        'LsaGetAppliedCAPIDs': SimTypeFunction([SimTypePointer(SimStruct({"Length": SimTypeShort(signed=False, label="UInt16"), "MaximumLength": SimTypeShort(signed=False, label="UInt16"), "Buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="UNICODE_STRING", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["SystemName", "CAPIDs", "CAPIDCount"]),
        # 
        'LsaQueryCAPs': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"CAPID": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Name": SimTypeBottom(label="UNICODE_STRING"), "Description": SimTypeBottom(label="UNICODE_STRING"), "ChangeId": SimTypeBottom(label="UNICODE_STRING"), "Flags": SimTypeInt(signed=False, label="UInt32"), "CAPECount": SimTypeInt(signed=False, label="UInt32"), "CAPEs": SimTypePointer(SimTypePointer(SimStruct({"Name": SimTypeBottom(label="UNICODE_STRING"), "Description": SimTypeBottom(label="UNICODE_STRING"), "ChangeId": SimTypeBottom(label="UNICODE_STRING"), "LengthAppliesTo": SimTypeInt(signed=False, label="UInt32"), "AppliesTo": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "LengthSD": SimTypeInt(signed=False, label="UInt32"), "SD": SimTypePointer(SimTypeBottom(label="SECURITY_DESCRIPTOR"), offset=0), "LengthStagedSD": SimTypeInt(signed=False, label="UInt32"), "StagedSD": SimTypePointer(SimTypeBottom(label="SECURITY_DESCRIPTOR"), offset=0), "Flags": SimTypeInt(signed=False, label="UInt32")}, name="CENTRAL_ACCESS_POLICY_ENTRY", pack=False, align=None), offset=0), offset=0)}, name="CENTRAL_ACCESS_POLICY", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["CAPIDs", "CAPIDCount", "CAPs", "CAPCount"]),
        # 
        'LsaQueryInformationPolicy': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="POLICY_INFORMATION_CLASS"), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["PolicyHandle", "InformationClass", "Buffer"]),
        # 
        'LsaSetInformationPolicy': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="POLICY_INFORMATION_CLASS"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["PolicyHandle", "InformationClass", "Buffer"]),
        # 
        'LsaQueryDomainInformationPolicy': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="POLICY_DOMAIN_INFORMATION_CLASS"), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["PolicyHandle", "InformationClass", "Buffer"]),
        # 
        'LsaSetDomainInformationPolicy': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="POLICY_DOMAIN_INFORMATION_CLASS"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["PolicyHandle", "InformationClass", "Buffer"]),
        # 
        'LsaEnumerateTrustedDomains': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["PolicyHandle", "EnumerationContext", "Buffer", "PreferedMaximumLength", "CountReturned"]),
        # 
        'LsaLookupNames': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Length": SimTypeShort(signed=False, label="UInt16"), "MaximumLength": SimTypeShort(signed=False, label="UInt16"), "Buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="UNICODE_STRING", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimStruct({"Entries": SimTypeInt(signed=False, label="UInt32"), "Domains": SimTypePointer(SimStruct({"Name": SimTypeBottom(label="UNICODE_STRING"), "Sid": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="LSA_TRUST_INFORMATION", pack=False, align=None), offset=0)}, name="LSA_REFERENCED_DOMAIN_LIST", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypePointer(SimStruct({"Use": SimTypeBottom(label="SID_NAME_USE"), "RelativeId": SimTypeInt(signed=False, label="UInt32"), "DomainIndex": SimTypeInt(signed=True, label="Int32")}, name="LSA_TRANSLATED_SID", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["PolicyHandle", "Count", "Names", "ReferencedDomains", "Sids"]),
        # 
        'LsaLookupNames2': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Length": SimTypeShort(signed=False, label="UInt16"), "MaximumLength": SimTypeShort(signed=False, label="UInt16"), "Buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="UNICODE_STRING", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimStruct({"Entries": SimTypeInt(signed=False, label="UInt32"), "Domains": SimTypePointer(SimStruct({"Name": SimTypeBottom(label="UNICODE_STRING"), "Sid": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="LSA_TRUST_INFORMATION", pack=False, align=None), offset=0)}, name="LSA_REFERENCED_DOMAIN_LIST", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypePointer(SimStruct({"Use": SimTypeBottom(label="SID_NAME_USE"), "Sid": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "DomainIndex": SimTypeInt(signed=True, label="Int32"), "Flags": SimTypeInt(signed=False, label="UInt32")}, name="LSA_TRANSLATED_SID2", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["PolicyHandle", "Flags", "Count", "Names", "ReferencedDomains", "Sids"]),
        # 
        'LsaLookupSids': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypePointer(SimTypePointer(SimStruct({"Entries": SimTypeInt(signed=False, label="UInt32"), "Domains": SimTypePointer(SimStruct({"Name": SimTypeBottom(label="UNICODE_STRING"), "Sid": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="LSA_TRUST_INFORMATION", pack=False, align=None), offset=0)}, name="LSA_REFERENCED_DOMAIN_LIST", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypePointer(SimStruct({"Use": SimTypeBottom(label="SID_NAME_USE"), "Name": SimTypeBottom(label="UNICODE_STRING"), "DomainIndex": SimTypeInt(signed=True, label="Int32")}, name="LSA_TRANSLATED_NAME", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["PolicyHandle", "Count", "Sids", "ReferencedDomains", "Names"]),
        # 
        'LsaLookupSids2': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypePointer(SimTypePointer(SimStruct({"Entries": SimTypeInt(signed=False, label="UInt32"), "Domains": SimTypePointer(SimStruct({"Name": SimTypeBottom(label="UNICODE_STRING"), "Sid": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="LSA_TRUST_INFORMATION", pack=False, align=None), offset=0)}, name="LSA_REFERENCED_DOMAIN_LIST", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypePointer(SimStruct({"Use": SimTypeBottom(label="SID_NAME_USE"), "Name": SimTypeBottom(label="UNICODE_STRING"), "DomainIndex": SimTypeInt(signed=True, label="Int32")}, name="LSA_TRANSLATED_NAME", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["PolicyHandle", "LookupOptions", "Count", "Sids", "ReferencedDomains", "Names"]),
        # 
        'LsaEnumerateAccountsWithUserRight': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"Length": SimTypeShort(signed=False, label="UInt16"), "MaximumLength": SimTypeShort(signed=False, label="UInt16"), "Buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="UNICODE_STRING", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["PolicyHandle", "UserRight", "Buffer", "CountReturned"]),
        # 
        'LsaEnumerateAccountRights': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypePointer(SimStruct({"Length": SimTypeShort(signed=False, label="UInt16"), "MaximumLength": SimTypeShort(signed=False, label="UInt16"), "Buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="UNICODE_STRING", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["PolicyHandle", "AccountSid", "UserRights", "CountOfRights"]),
        # 
        'LsaAddAccountRights': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"Length": SimTypeShort(signed=False, label="UInt16"), "MaximumLength": SimTypeShort(signed=False, label="UInt16"), "Buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="UNICODE_STRING", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["PolicyHandle", "AccountSid", "UserRights", "CountOfRights"]),
        # 
        'LsaRemoveAccountRights': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeChar(label="Byte"), SimTypePointer(SimStruct({"Length": SimTypeShort(signed=False, label="UInt16"), "MaximumLength": SimTypeShort(signed=False, label="UInt16"), "Buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="UNICODE_STRING", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["PolicyHandle", "AccountSid", "AllRights", "UserRights", "CountOfRights"]),
        # 
        'LsaOpenTrustedDomainByName': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"Length": SimTypeShort(signed=False, label="UInt16"), "MaximumLength": SimTypeShort(signed=False, label="UInt16"), "Buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="UNICODE_STRING", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["PolicyHandle", "TrustedDomainName", "DesiredAccess", "TrustedDomainHandle"]),
        # 
        'LsaQueryTrustedDomainInfo': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="TRUSTED_INFORMATION_CLASS"), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["PolicyHandle", "TrustedDomainSid", "InformationClass", "Buffer"]),
        # 
        'LsaSetTrustedDomainInformation': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="TRUSTED_INFORMATION_CLASS"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["PolicyHandle", "TrustedDomainSid", "InformationClass", "Buffer"]),
        # 
        'LsaDeleteTrustedDomain': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["PolicyHandle", "TrustedDomainSid"]),
        # 
        'LsaQueryTrustedDomainInfoByName': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"Length": SimTypeShort(signed=False, label="UInt16"), "MaximumLength": SimTypeShort(signed=False, label="UInt16"), "Buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="UNICODE_STRING", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="TRUSTED_INFORMATION_CLASS"), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["PolicyHandle", "TrustedDomainName", "InformationClass", "Buffer"]),
        # 
        'LsaSetTrustedDomainInfoByName': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"Length": SimTypeShort(signed=False, label="UInt16"), "MaximumLength": SimTypeShort(signed=False, label="UInt16"), "Buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="UNICODE_STRING", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="TRUSTED_INFORMATION_CLASS"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["PolicyHandle", "TrustedDomainName", "InformationClass", "Buffer"]),
        # 
        'LsaEnumerateTrustedDomainsEx': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["PolicyHandle", "EnumerationContext", "Buffer", "PreferedMaximumLength", "CountReturned"]),
        # 
        'LsaCreateTrustedDomainEx': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"Name": SimTypeBottom(label="UNICODE_STRING"), "FlatName": SimTypeBottom(label="UNICODE_STRING"), "Sid": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "TrustDirection": SimTypeInt(signed=False, label="TRUSTED_DOMAIN_TRUST_DIRECTION"), "TrustType": SimTypeInt(signed=False, label="TRUSTED_DOMAIN_TRUST_TYPE"), "TrustAttributes": SimTypeInt(signed=False, label="TRUSTED_DOMAIN_TRUST_ATTRIBUTES")}, name="TRUSTED_DOMAIN_INFORMATION_EX", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"IncomingAuthInfos": SimTypeInt(signed=False, label="UInt32"), "IncomingAuthenticationInformation": SimTypePointer(SimStruct({"LastUpdateTime": SimTypeBottom(label="LARGE_INTEGER"), "AuthType": SimTypeInt(signed=False, label="LSA_AUTH_INFORMATION_AUTH_TYPE"), "AuthInfoLength": SimTypeInt(signed=False, label="UInt32"), "AuthInfo": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="LSA_AUTH_INFORMATION", pack=False, align=None), offset=0), "IncomingPreviousAuthenticationInformation": SimTypePointer(SimStruct({"LastUpdateTime": SimTypeBottom(label="LARGE_INTEGER"), "AuthType": SimTypeInt(signed=False, label="LSA_AUTH_INFORMATION_AUTH_TYPE"), "AuthInfoLength": SimTypeInt(signed=False, label="UInt32"), "AuthInfo": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="LSA_AUTH_INFORMATION", pack=False, align=None), offset=0), "OutgoingAuthInfos": SimTypeInt(signed=False, label="UInt32"), "OutgoingAuthenticationInformation": SimTypePointer(SimStruct({"LastUpdateTime": SimTypeBottom(label="LARGE_INTEGER"), "AuthType": SimTypeInt(signed=False, label="LSA_AUTH_INFORMATION_AUTH_TYPE"), "AuthInfoLength": SimTypeInt(signed=False, label="UInt32"), "AuthInfo": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="LSA_AUTH_INFORMATION", pack=False, align=None), offset=0), "OutgoingPreviousAuthenticationInformation": SimTypePointer(SimStruct({"LastUpdateTime": SimTypeBottom(label="LARGE_INTEGER"), "AuthType": SimTypeInt(signed=False, label="LSA_AUTH_INFORMATION_AUTH_TYPE"), "AuthInfoLength": SimTypeInt(signed=False, label="UInt32"), "AuthInfo": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="LSA_AUTH_INFORMATION", pack=False, align=None), offset=0)}, name="TRUSTED_DOMAIN_AUTH_INFORMATION", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["PolicyHandle", "TrustedDomainInformation", "AuthenticationInformation", "DesiredAccess", "TrustedDomainHandle"]),
        # 
        'LsaQueryForestTrustInformation': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"Length": SimTypeShort(signed=False, label="UInt16"), "MaximumLength": SimTypeShort(signed=False, label="UInt16"), "Buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="UNICODE_STRING", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimStruct({"RecordCount": SimTypeInt(signed=False, label="UInt32"), "Entries": SimTypePointer(SimTypePointer(SimStruct({"Flags": SimTypeInt(signed=False, label="UInt32"), "ForestTrustType": SimTypeInt(signed=False, label="LSA_FOREST_TRUST_RECORD_TYPE"), "Time": SimTypeBottom(label="LARGE_INTEGER"), "ForestTrustData": SimUnion({"TopLevelName": SimTypeBottom(label="UNICODE_STRING"), "DomainInfo": SimStruct({"Sid": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "DnsName": SimTypeBottom(label="UNICODE_STRING"), "NetbiosName": SimTypeBottom(label="UNICODE_STRING")}, name="LSA_FOREST_TRUST_DOMAIN_INFO", pack=False, align=None), "Data": SimStruct({"Length": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="LSA_FOREST_TRUST_BINARY_DATA", pack=False, align=None)}, name="<anon>", label="None")}, name="LSA_FOREST_TRUST_RECORD", pack=False, align=None), offset=0), offset=0)}, name="LSA_FOREST_TRUST_INFORMATION", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["PolicyHandle", "TrustedDomainName", "ForestTrustInfo"]),
        # 
        'LsaSetForestTrustInformation': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"Length": SimTypeShort(signed=False, label="UInt16"), "MaximumLength": SimTypeShort(signed=False, label="UInt16"), "Buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="UNICODE_STRING", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"RecordCount": SimTypeInt(signed=False, label="UInt32"), "Entries": SimTypePointer(SimTypePointer(SimStruct({"Flags": SimTypeInt(signed=False, label="UInt32"), "ForestTrustType": SimTypeInt(signed=False, label="LSA_FOREST_TRUST_RECORD_TYPE"), "Time": SimTypeBottom(label="LARGE_INTEGER"), "ForestTrustData": SimUnion({"TopLevelName": SimTypeBottom(label="UNICODE_STRING"), "DomainInfo": SimStruct({"Sid": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "DnsName": SimTypeBottom(label="UNICODE_STRING"), "NetbiosName": SimTypeBottom(label="UNICODE_STRING")}, name="LSA_FOREST_TRUST_DOMAIN_INFO", pack=False, align=None), "Data": SimStruct({"Length": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="LSA_FOREST_TRUST_BINARY_DATA", pack=False, align=None)}, name="<anon>", label="None")}, name="LSA_FOREST_TRUST_RECORD", pack=False, align=None), offset=0), offset=0)}, name="LSA_FOREST_TRUST_INFORMATION", pack=False, align=None), offset=0), SimTypeChar(label="Byte"), SimTypePointer(SimTypePointer(SimStruct({"RecordCount": SimTypeInt(signed=False, label="UInt32"), "Entries": SimTypePointer(SimTypePointer(SimStruct({"Index": SimTypeInt(signed=False, label="UInt32"), "Type": SimTypeInt(signed=False, label="LSA_FOREST_TRUST_COLLISION_RECORD_TYPE"), "Flags": SimTypeInt(signed=False, label="UInt32"), "Name": SimTypeBottom(label="UNICODE_STRING")}, name="LSA_FOREST_TRUST_COLLISION_RECORD", pack=False, align=None), offset=0), offset=0)}, name="LSA_FOREST_TRUST_COLLISION_INFORMATION", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["PolicyHandle", "TrustedDomainName", "ForestTrustInfo", "CheckOnly", "CollisionInfo"]),
        # 
        'LsaStorePrivateData': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"Length": SimTypeShort(signed=False, label="UInt16"), "MaximumLength": SimTypeShort(signed=False, label="UInt16"), "Buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="UNICODE_STRING", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Length": SimTypeShort(signed=False, label="UInt16"), "MaximumLength": SimTypeShort(signed=False, label="UInt16"), "Buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="UNICODE_STRING", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["PolicyHandle", "KeyName", "PrivateData"]),
        # 
        'LsaRetrievePrivateData': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"Length": SimTypeShort(signed=False, label="UInt16"), "MaximumLength": SimTypeShort(signed=False, label="UInt16"), "Buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="UNICODE_STRING", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimStruct({"Length": SimTypeShort(signed=False, label="UInt16"), "MaximumLength": SimTypeShort(signed=False, label="UInt16"), "Buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="UNICODE_STRING", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["PolicyHandle", "KeyName", "PrivateData"]),
        # 
        'LsaNtStatusToWinError': SimTypeFunction([SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["Status"]),
        # 
        'SystemFunction036': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeChar(label="Byte"), arg_names=["RandomBuffer", "RandomBufferLength"]),
        # 
        'SystemFunction040': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["Memory", "MemorySize", "OptionFlags"]),
        # 
        'SystemFunction041': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["Memory", "MemorySize", "OptionFlags"]),
        # 
        'AuditSetSystemPolicy': SimTypeFunction([SimTypePointer(SimStruct({"AuditSubCategoryGuid": SimTypeBottom(label="Guid"), "AuditingInformation": SimTypeInt(signed=False, label="UInt32"), "AuditCategoryGuid": SimTypeBottom(label="Guid")}, name="AUDIT_POLICY_INFORMATION", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeChar(label="Byte"), arg_names=["pAuditPolicy", "dwPolicyCount"]),
        # 
        'AuditSetPerUserPolicy': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"AuditSubCategoryGuid": SimTypeBottom(label="Guid"), "AuditingInformation": SimTypeInt(signed=False, label="UInt32"), "AuditCategoryGuid": SimTypeBottom(label="Guid")}, name="AUDIT_POLICY_INFORMATION", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeChar(label="Byte"), arg_names=["pSid", "pAuditPolicy", "dwPolicyCount"]),
        # 
        'AuditQuerySystemPolicy': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"AuditSubCategoryGuid": SimTypeBottom(label="Guid"), "AuditingInformation": SimTypeInt(signed=False, label="UInt32"), "AuditCategoryGuid": SimTypeBottom(label="Guid")}, name="AUDIT_POLICY_INFORMATION", pack=False, align=None), offset=0), offset=0)], SimTypeChar(label="Byte"), arg_names=["pSubCategoryGuids", "dwPolicyCount", "ppAuditPolicy"]),
        # 
        'AuditQueryPerUserPolicy': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"AuditSubCategoryGuid": SimTypeBottom(label="Guid"), "AuditingInformation": SimTypeInt(signed=False, label="UInt32"), "AuditCategoryGuid": SimTypeBottom(label="Guid")}, name="AUDIT_POLICY_INFORMATION", pack=False, align=None), offset=0), offset=0)], SimTypeChar(label="Byte"), arg_names=["pSid", "pSubCategoryGuids", "dwPolicyCount", "ppAuditPolicy"]),
        # 
        'AuditEnumeratePerUserPolicy': SimTypeFunction([SimTypePointer(SimTypePointer(SimStruct({"UsersCount": SimTypeInt(signed=False, label="UInt32"), "UserSidArray": SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)}, name="POLICY_AUDIT_SID_ARRAY", pack=False, align=None), offset=0), offset=0)], SimTypeChar(label="Byte"), arg_names=["ppAuditSidArray"]),
        # 
        'AuditComputeEffectivePolicyBySid': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"AuditSubCategoryGuid": SimTypeBottom(label="Guid"), "AuditingInformation": SimTypeInt(signed=False, label="UInt32"), "AuditCategoryGuid": SimTypeBottom(label="Guid")}, name="AUDIT_POLICY_INFORMATION", pack=False, align=None), offset=0), offset=0)], SimTypeChar(label="Byte"), arg_names=["pSid", "pSubCategoryGuids", "dwPolicyCount", "ppAuditPolicy"]),
        # 
        'AuditComputeEffectivePolicyByToken': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"AuditSubCategoryGuid": SimTypeBottom(label="Guid"), "AuditingInformation": SimTypeInt(signed=False, label="UInt32"), "AuditCategoryGuid": SimTypeBottom(label="Guid")}, name="AUDIT_POLICY_INFORMATION", pack=False, align=None), offset=0), offset=0)], SimTypeChar(label="Byte"), arg_names=["hTokenHandle", "pSubCategoryGuids", "dwPolicyCount", "ppAuditPolicy"]),
        # 
        'AuditEnumerateCategories': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeBottom(label="Guid"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeChar(label="Byte"), arg_names=["ppAuditCategoriesArray", "pdwCountReturned"]),
        # 
        'AuditEnumerateSubCategories': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeChar(label="Byte"), SimTypePointer(SimTypePointer(SimTypeBottom(label="Guid"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeChar(label="Byte"), arg_names=["pAuditCategoryGuid", "bRetrieveAllSubCategories", "ppAuditSubCategoriesArray", "pdwCountReturned"]),
        # 
        'AuditLookupCategoryNameW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)], SimTypeChar(label="Byte"), arg_names=["pAuditCategoryGuid", "ppszCategoryName"]),
        # 
        'AuditLookupCategoryNameA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)], SimTypeChar(label="Byte"), arg_names=["pAuditCategoryGuid", "ppszCategoryName"]),
        # 
        'AuditLookupSubCategoryNameW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)], SimTypeChar(label="Byte"), arg_names=["pAuditSubCategoryGuid", "ppszSubCategoryName"]),
        # 
        'AuditLookupSubCategoryNameA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)], SimTypeChar(label="Byte"), arg_names=["pAuditSubCategoryGuid", "ppszSubCategoryName"]),
        # 
        'AuditLookupCategoryIdFromCategoryGuid': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="POLICY_AUDIT_EVENT_TYPE"), offset=0)], SimTypeChar(label="Byte"), arg_names=["pAuditCategoryGuid", "pAuditCategoryId"]),
        # 
        'AuditLookupCategoryGuidFromCategoryId': SimTypeFunction([SimTypeInt(signed=False, label="POLICY_AUDIT_EVENT_TYPE"), SimTypePointer(SimTypeBottom(label="Guid"), offset=0)], SimTypeChar(label="Byte"), arg_names=["AuditCategoryId", "pAuditCategoryGuid"]),
        # 
        'AuditSetSecurity': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0)], SimTypeChar(label="Byte"), arg_names=["SecurityInformation", "pSecurityDescriptor"]),
        # 
        'AuditQuerySecurity': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), offset=0)], SimTypeChar(label="Byte"), arg_names=["SecurityInformation", "ppSecurityDescriptor"]),
        # 
        'AuditSetGlobalSaclW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)], SimTypeChar(label="Byte"), arg_names=["ObjectTypeName", "Acl"]),
        # 
        'AuditSetGlobalSaclA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)], SimTypeChar(label="Byte"), arg_names=["ObjectTypeName", "Acl"]),
        # 
        'AuditQueryGlobalSaclW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), offset=0)], SimTypeChar(label="Byte"), arg_names=["ObjectTypeName", "Acl"]),
        # 
        'AuditQueryGlobalSaclA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), offset=0)], SimTypeChar(label="Byte"), arg_names=["ObjectTypeName", "Acl"]),
        # 
        'AuditFree': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["Buffer"]),
        # 
        'SetEntriesInAclA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"grfAccessPermissions": SimTypeInt(signed=False, label="UInt32"), "grfAccessMode": SimTypeInt(signed=False, label="ACCESS_MODE"), "grfInheritance": SimTypeBottom(label="ACE_FLAGS"), "Trustee": SimStruct({"pMultipleTrustee": SimTypePointer(SimTypeBottom(label="TRUSTEE_A"), offset=0), "MultipleTrusteeOperation": SimTypeInt(signed=False, label="MULTIPLE_TRUSTEE_OPERATION"), "TrusteeForm": SimTypeInt(signed=False, label="TRUSTEE_FORM"), "TrusteeType": SimTypeInt(signed=False, label="TRUSTEE_TYPE"), "ptstrName": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="TRUSTEE_A", pack=False, align=None)}, name="EXPLICIT_ACCESS_A", pack=False, align=None), label="LPArray", offset=0), SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["cCountOfExplicitEntries", "pListOfExplicitEntries", "OldAcl", "NewAcl"]),
        # 
        'SetEntriesInAclW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"grfAccessPermissions": SimTypeInt(signed=False, label="UInt32"), "grfAccessMode": SimTypeInt(signed=False, label="ACCESS_MODE"), "grfInheritance": SimTypeBottom(label="ACE_FLAGS"), "Trustee": SimStruct({"pMultipleTrustee": SimTypePointer(SimTypeBottom(label="TRUSTEE_W"), offset=0), "MultipleTrusteeOperation": SimTypeInt(signed=False, label="MULTIPLE_TRUSTEE_OPERATION"), "TrusteeForm": SimTypeInt(signed=False, label="TRUSTEE_FORM"), "TrusteeType": SimTypeInt(signed=False, label="TRUSTEE_TYPE"), "ptstrName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="TRUSTEE_W", pack=False, align=None)}, name="EXPLICIT_ACCESS_W", pack=False, align=None), label="LPArray", offset=0), SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["cCountOfExplicitEntries", "pListOfExplicitEntries", "OldAcl", "NewAcl"]),
        # 
        'GetExplicitEntriesFromAclA': SimTypeFunction([SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"grfAccessPermissions": SimTypeInt(signed=False, label="UInt32"), "grfAccessMode": SimTypeInt(signed=False, label="ACCESS_MODE"), "grfInheritance": SimTypeBottom(label="ACE_FLAGS"), "Trustee": SimStruct({"pMultipleTrustee": SimTypePointer(SimTypeBottom(label="TRUSTEE_A"), offset=0), "MultipleTrusteeOperation": SimTypeInt(signed=False, label="MULTIPLE_TRUSTEE_OPERATION"), "TrusteeForm": SimTypeInt(signed=False, label="TRUSTEE_FORM"), "TrusteeType": SimTypeInt(signed=False, label="TRUSTEE_TYPE"), "ptstrName": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="TRUSTEE_A", pack=False, align=None)}, name="EXPLICIT_ACCESS_A", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pacl", "pcCountOfExplicitEntries", "pListOfExplicitEntries"]),
        # 
        'GetExplicitEntriesFromAclW': SimTypeFunction([SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"grfAccessPermissions": SimTypeInt(signed=False, label="UInt32"), "grfAccessMode": SimTypeInt(signed=False, label="ACCESS_MODE"), "grfInheritance": SimTypeBottom(label="ACE_FLAGS"), "Trustee": SimStruct({"pMultipleTrustee": SimTypePointer(SimTypeBottom(label="TRUSTEE_W"), offset=0), "MultipleTrusteeOperation": SimTypeInt(signed=False, label="MULTIPLE_TRUSTEE_OPERATION"), "TrusteeForm": SimTypeInt(signed=False, label="TRUSTEE_FORM"), "TrusteeType": SimTypeInt(signed=False, label="TRUSTEE_TYPE"), "ptstrName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="TRUSTEE_W", pack=False, align=None)}, name="EXPLICIT_ACCESS_W", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pacl", "pcCountOfExplicitEntries", "pListOfExplicitEntries"]),
        # 
        'GetEffectiveRightsFromAclA': SimTypeFunction([SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"pMultipleTrustee": SimTypePointer(SimTypeBottom(label="TRUSTEE_A"), offset=0), "MultipleTrusteeOperation": SimTypeInt(signed=False, label="MULTIPLE_TRUSTEE_OPERATION"), "TrusteeForm": SimTypeInt(signed=False, label="TRUSTEE_FORM"), "TrusteeType": SimTypeInt(signed=False, label="TRUSTEE_TYPE"), "ptstrName": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="TRUSTEE_A", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pacl", "pTrustee", "pAccessRights"]),
        # 
        'GetEffectiveRightsFromAclW': SimTypeFunction([SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"pMultipleTrustee": SimTypePointer(SimTypeBottom(label="TRUSTEE_W"), offset=0), "MultipleTrusteeOperation": SimTypeInt(signed=False, label="MULTIPLE_TRUSTEE_OPERATION"), "TrusteeForm": SimTypeInt(signed=False, label="TRUSTEE_FORM"), "TrusteeType": SimTypeInt(signed=False, label="TRUSTEE_TYPE"), "ptstrName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="TRUSTEE_W", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pacl", "pTrustee", "pAccessRights"]),
        # 
        'GetAuditedPermissionsFromAclA': SimTypeFunction([SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"pMultipleTrustee": SimTypePointer(SimTypeBottom(label="TRUSTEE_A"), offset=0), "MultipleTrusteeOperation": SimTypeInt(signed=False, label="MULTIPLE_TRUSTEE_OPERATION"), "TrusteeForm": SimTypeInt(signed=False, label="TRUSTEE_FORM"), "TrusteeType": SimTypeInt(signed=False, label="TRUSTEE_TYPE"), "ptstrName": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="TRUSTEE_A", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pacl", "pTrustee", "pSuccessfulAuditedRights", "pFailedAuditRights"]),
        # 
        'GetAuditedPermissionsFromAclW': SimTypeFunction([SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"pMultipleTrustee": SimTypePointer(SimTypeBottom(label="TRUSTEE_W"), offset=0), "MultipleTrusteeOperation": SimTypeInt(signed=False, label="MULTIPLE_TRUSTEE_OPERATION"), "TrusteeForm": SimTypeInt(signed=False, label="TRUSTEE_FORM"), "TrusteeType": SimTypeInt(signed=False, label="TRUSTEE_TYPE"), "ptstrName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="TRUSTEE_W", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pacl", "pTrustee", "pSuccessfulAuditedRights", "pFailedAuditRights"]),
        # 
        'GetNamedSecurityInfoA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="SE_OBJECT_TYPE"), SimTypeInt(signed=False, label="OBJECT_SECURITY_INFORMATION"), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypePointer(SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pObjectName", "ObjectType", "SecurityInfo", "ppsidOwner", "ppsidGroup", "ppDacl", "ppSacl", "ppSecurityDescriptor"]),
        # 
        'GetNamedSecurityInfoW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="SE_OBJECT_TYPE"), SimTypeInt(signed=False, label="OBJECT_SECURITY_INFORMATION"), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypePointer(SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pObjectName", "ObjectType", "SecurityInfo", "ppsidOwner", "ppsidGroup", "ppDacl", "ppSacl", "ppSecurityDescriptor"]),
        # 
        'GetSecurityInfo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="SE_OBJECT_TYPE"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypePointer(SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["handle", "ObjectType", "SecurityInfo", "ppsidOwner", "ppsidGroup", "ppDacl", "ppSacl", "ppSecurityDescriptor"]),
        # 
        'SetNamedSecurityInfoA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="SE_OBJECT_TYPE"), SimTypeInt(signed=False, label="OBJECT_SECURITY_INFORMATION"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pObjectName", "ObjectType", "SecurityInfo", "psidOwner", "psidGroup", "pDacl", "pSacl"]),
        # 
        'SetNamedSecurityInfoW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="SE_OBJECT_TYPE"), SimTypeInt(signed=False, label="OBJECT_SECURITY_INFORMATION"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pObjectName", "ObjectType", "SecurityInfo", "psidOwner", "psidGroup", "pDacl", "pSacl"]),
        # 
        'SetSecurityInfo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="SE_OBJECT_TYPE"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["handle", "ObjectType", "SecurityInfo", "psidOwner", "psidGroup", "pDacl", "pSacl"]),
        # 
        'GetInheritanceSourceA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="SE_OBJECT_TYPE"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypePointer(SimTypeBottom(label="Guid"), offset=0), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Placeholder": SimTypeInt(signed=False, label="UInt32")}, name="FN_OBJECT_MGR_FUNCTIONS", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"GenericRead": SimTypeInt(signed=False, label="UInt32"), "GenericWrite": SimTypeInt(signed=False, label="UInt32"), "GenericExecute": SimTypeInt(signed=False, label="UInt32"), "GenericAll": SimTypeInt(signed=False, label="UInt32")}, name="GENERIC_MAPPING", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"GenerationGap": SimTypeInt(signed=True, label="Int32"), "AncestorName": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="INHERITED_FROMA", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pObjectName", "ObjectType", "SecurityInfo", "Container", "pObjectClassGuids", "GuidCount", "pAcl", "pfnArray", "pGenericMapping", "pInheritArray"]),
        # 
        'GetInheritanceSourceW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="SE_OBJECT_TYPE"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypePointer(SimTypeBottom(label="Guid"), offset=0), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Placeholder": SimTypeInt(signed=False, label="UInt32")}, name="FN_OBJECT_MGR_FUNCTIONS", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"GenericRead": SimTypeInt(signed=False, label="UInt32"), "GenericWrite": SimTypeInt(signed=False, label="UInt32"), "GenericExecute": SimTypeInt(signed=False, label="UInt32"), "GenericAll": SimTypeInt(signed=False, label="UInt32")}, name="GENERIC_MAPPING", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"GenerationGap": SimTypeInt(signed=True, label="Int32"), "AncestorName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="INHERITED_FROMW", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pObjectName", "ObjectType", "SecurityInfo", "Container", "pObjectClassGuids", "GuidCount", "pAcl", "pfnArray", "pGenericMapping", "pInheritArray"]),
        # 
        'FreeInheritedFromArray': SimTypeFunction([SimTypePointer(SimStruct({"GenerationGap": SimTypeInt(signed=True, label="Int32"), "AncestorName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="INHERITED_FROMW", pack=False, align=None), label="LPArray", offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimStruct({"Placeholder": SimTypeInt(signed=False, label="UInt32")}, name="FN_OBJECT_MGR_FUNCTIONS", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pInheritArray", "AceCnt", "pfnArray"]),
        # 
        'TreeResetNamedSecurityInfoA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="SE_OBJECT_TYPE"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="PROG_INVOKE_SETTING"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeBottom(label="Void"), arg_names=["pObjectName", "Status", "pInvokeSetting", "Args", "SecuritySet"]), offset=0), SimTypeInt(signed=False, label="PROG_INVOKE_SETTING"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pObjectName", "ObjectType", "SecurityInfo", "pOwner", "pGroup", "pDacl", "pSacl", "KeepExplicit", "fnProgress", "ProgressInvokeSetting", "Args"]),
        # 
        'TreeResetNamedSecurityInfoW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="SE_OBJECT_TYPE"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="PROG_INVOKE_SETTING"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeBottom(label="Void"), arg_names=["pObjectName", "Status", "pInvokeSetting", "Args", "SecuritySet"]), offset=0), SimTypeInt(signed=False, label="PROG_INVOKE_SETTING"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pObjectName", "ObjectType", "SecurityInfo", "pOwner", "pGroup", "pDacl", "pSacl", "KeepExplicit", "fnProgress", "ProgressInvokeSetting", "Args"]),
        # 
        'TreeSetNamedSecurityInfoA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="SE_OBJECT_TYPE"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="TREE_SEC_INFO"), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="PROG_INVOKE_SETTING"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeBottom(label="Void"), arg_names=["pObjectName", "Status", "pInvokeSetting", "Args", "SecuritySet"]), offset=0), SimTypeInt(signed=False, label="PROG_INVOKE_SETTING"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pObjectName", "ObjectType", "SecurityInfo", "pOwner", "pGroup", "pDacl", "pSacl", "dwAction", "fnProgress", "ProgressInvokeSetting", "Args"]),
        # 
        'TreeSetNamedSecurityInfoW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="SE_OBJECT_TYPE"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="TREE_SEC_INFO"), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="PROG_INVOKE_SETTING"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeBottom(label="Void"), arg_names=["pObjectName", "Status", "pInvokeSetting", "Args", "SecuritySet"]), offset=0), SimTypeInt(signed=False, label="PROG_INVOKE_SETTING"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pObjectName", "ObjectType", "SecurityInfo", "pOwner", "pGroup", "pDacl", "pSacl", "dwAction", "fnProgress", "ProgressInvokeSetting", "Args"]),
        # 
        'BuildSecurityDescriptorA': SimTypeFunction([SimTypePointer(SimStruct({"pMultipleTrustee": SimTypePointer(SimTypeBottom(label="TRUSTEE_A"), offset=0), "MultipleTrusteeOperation": SimTypeInt(signed=False, label="MULTIPLE_TRUSTEE_OPERATION"), "TrusteeForm": SimTypeInt(signed=False, label="TRUSTEE_FORM"), "TrusteeType": SimTypeInt(signed=False, label="TRUSTEE_TYPE"), "ptstrName": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="TRUSTEE_A", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"pMultipleTrustee": SimTypePointer(SimTypeBottom(label="TRUSTEE_A"), offset=0), "MultipleTrusteeOperation": SimTypeInt(signed=False, label="MULTIPLE_TRUSTEE_OPERATION"), "TrusteeForm": SimTypeInt(signed=False, label="TRUSTEE_FORM"), "TrusteeType": SimTypeInt(signed=False, label="TRUSTEE_TYPE"), "ptstrName": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="TRUSTEE_A", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"grfAccessPermissions": SimTypeInt(signed=False, label="UInt32"), "grfAccessMode": SimTypeInt(signed=False, label="ACCESS_MODE"), "grfInheritance": SimTypeBottom(label="ACE_FLAGS"), "Trustee": SimStruct({"pMultipleTrustee": SimTypePointer(SimTypeBottom(label="TRUSTEE_A"), offset=0), "MultipleTrusteeOperation": SimTypeInt(signed=False, label="MULTIPLE_TRUSTEE_OPERATION"), "TrusteeForm": SimTypeInt(signed=False, label="TRUSTEE_FORM"), "TrusteeType": SimTypeInt(signed=False, label="TRUSTEE_TYPE"), "ptstrName": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="TRUSTEE_A", pack=False, align=None)}, name="EXPLICIT_ACCESS_A", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"grfAccessPermissions": SimTypeInt(signed=False, label="UInt32"), "grfAccessMode": SimTypeInt(signed=False, label="ACCESS_MODE"), "grfInheritance": SimTypeBottom(label="ACE_FLAGS"), "Trustee": SimStruct({"pMultipleTrustee": SimTypePointer(SimTypeBottom(label="TRUSTEE_A"), offset=0), "MultipleTrusteeOperation": SimTypeInt(signed=False, label="MULTIPLE_TRUSTEE_OPERATION"), "TrusteeForm": SimTypeInt(signed=False, label="TRUSTEE_FORM"), "TrusteeType": SimTypeInt(signed=False, label="TRUSTEE_TYPE"), "ptstrName": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="TRUSTEE_A", pack=False, align=None)}, name="EXPLICIT_ACCESS_A", pack=False, align=None), label="LPArray", offset=0), SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pOwner", "pGroup", "cCountOfAccessEntries", "pListOfAccessEntries", "cCountOfAuditEntries", "pListOfAuditEntries", "pOldSD", "pSizeNewSD", "pNewSD"]),
        # 
        'BuildSecurityDescriptorW': SimTypeFunction([SimTypePointer(SimStruct({"pMultipleTrustee": SimTypePointer(SimTypeBottom(label="TRUSTEE_W"), offset=0), "MultipleTrusteeOperation": SimTypeInt(signed=False, label="MULTIPLE_TRUSTEE_OPERATION"), "TrusteeForm": SimTypeInt(signed=False, label="TRUSTEE_FORM"), "TrusteeType": SimTypeInt(signed=False, label="TRUSTEE_TYPE"), "ptstrName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="TRUSTEE_W", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"pMultipleTrustee": SimTypePointer(SimTypeBottom(label="TRUSTEE_W"), offset=0), "MultipleTrusteeOperation": SimTypeInt(signed=False, label="MULTIPLE_TRUSTEE_OPERATION"), "TrusteeForm": SimTypeInt(signed=False, label="TRUSTEE_FORM"), "TrusteeType": SimTypeInt(signed=False, label="TRUSTEE_TYPE"), "ptstrName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="TRUSTEE_W", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"grfAccessPermissions": SimTypeInt(signed=False, label="UInt32"), "grfAccessMode": SimTypeInt(signed=False, label="ACCESS_MODE"), "grfInheritance": SimTypeBottom(label="ACE_FLAGS"), "Trustee": SimStruct({"pMultipleTrustee": SimTypePointer(SimTypeBottom(label="TRUSTEE_W"), offset=0), "MultipleTrusteeOperation": SimTypeInt(signed=False, label="MULTIPLE_TRUSTEE_OPERATION"), "TrusteeForm": SimTypeInt(signed=False, label="TRUSTEE_FORM"), "TrusteeType": SimTypeInt(signed=False, label="TRUSTEE_TYPE"), "ptstrName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="TRUSTEE_W", pack=False, align=None)}, name="EXPLICIT_ACCESS_W", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"grfAccessPermissions": SimTypeInt(signed=False, label="UInt32"), "grfAccessMode": SimTypeInt(signed=False, label="ACCESS_MODE"), "grfInheritance": SimTypeBottom(label="ACE_FLAGS"), "Trustee": SimStruct({"pMultipleTrustee": SimTypePointer(SimTypeBottom(label="TRUSTEE_W"), offset=0), "MultipleTrusteeOperation": SimTypeInt(signed=False, label="MULTIPLE_TRUSTEE_OPERATION"), "TrusteeForm": SimTypeInt(signed=False, label="TRUSTEE_FORM"), "TrusteeType": SimTypeInt(signed=False, label="TRUSTEE_TYPE"), "ptstrName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="TRUSTEE_W", pack=False, align=None)}, name="EXPLICIT_ACCESS_W", pack=False, align=None), label="LPArray", offset=0), SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pOwner", "pGroup", "cCountOfAccessEntries", "pListOfAccessEntries", "cCountOfAuditEntries", "pListOfAuditEntries", "pOldSD", "pSizeNewSD", "pNewSD"]),
        # 
        'LookupSecurityDescriptorPartsA': SimTypeFunction([SimTypePointer(SimTypePointer(SimStruct({"pMultipleTrustee": SimTypePointer(SimTypeBottom(label="TRUSTEE_A"), offset=0), "MultipleTrusteeOperation": SimTypeInt(signed=False, label="MULTIPLE_TRUSTEE_OPERATION"), "TrusteeForm": SimTypeInt(signed=False, label="TRUSTEE_FORM"), "TrusteeType": SimTypeInt(signed=False, label="TRUSTEE_TYPE"), "ptstrName": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="TRUSTEE_A", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypePointer(SimStruct({"pMultipleTrustee": SimTypePointer(SimTypeBottom(label="TRUSTEE_A"), offset=0), "MultipleTrusteeOperation": SimTypeInt(signed=False, label="MULTIPLE_TRUSTEE_OPERATION"), "TrusteeForm": SimTypeInt(signed=False, label="TRUSTEE_FORM"), "TrusteeType": SimTypeInt(signed=False, label="TRUSTEE_TYPE"), "ptstrName": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="TRUSTEE_A", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"grfAccessPermissions": SimTypeInt(signed=False, label="UInt32"), "grfAccessMode": SimTypeInt(signed=False, label="ACCESS_MODE"), "grfInheritance": SimTypeBottom(label="ACE_FLAGS"), "Trustee": SimStruct({"pMultipleTrustee": SimTypePointer(SimTypeBottom(label="TRUSTEE_A"), offset=0), "MultipleTrusteeOperation": SimTypeInt(signed=False, label="MULTIPLE_TRUSTEE_OPERATION"), "TrusteeForm": SimTypeInt(signed=False, label="TRUSTEE_FORM"), "TrusteeType": SimTypeInt(signed=False, label="TRUSTEE_TYPE"), "ptstrName": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="TRUSTEE_A", pack=False, align=None)}, name="EXPLICIT_ACCESS_A", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"grfAccessPermissions": SimTypeInt(signed=False, label="UInt32"), "grfAccessMode": SimTypeInt(signed=False, label="ACCESS_MODE"), "grfInheritance": SimTypeBottom(label="ACE_FLAGS"), "Trustee": SimStruct({"pMultipleTrustee": SimTypePointer(SimTypeBottom(label="TRUSTEE_A"), offset=0), "MultipleTrusteeOperation": SimTypeInt(signed=False, label="MULTIPLE_TRUSTEE_OPERATION"), "TrusteeForm": SimTypeInt(signed=False, label="TRUSTEE_FORM"), "TrusteeType": SimTypeInt(signed=False, label="TRUSTEE_TYPE"), "ptstrName": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="TRUSTEE_A", pack=False, align=None)}, name="EXPLICIT_ACCESS_A", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ppOwner", "ppGroup", "pcCountOfAccessEntries", "ppListOfAccessEntries", "pcCountOfAuditEntries", "ppListOfAuditEntries", "pSD"]),
        # 
        'LookupSecurityDescriptorPartsW': SimTypeFunction([SimTypePointer(SimTypePointer(SimStruct({"pMultipleTrustee": SimTypePointer(SimTypeBottom(label="TRUSTEE_W"), offset=0), "MultipleTrusteeOperation": SimTypeInt(signed=False, label="MULTIPLE_TRUSTEE_OPERATION"), "TrusteeForm": SimTypeInt(signed=False, label="TRUSTEE_FORM"), "TrusteeType": SimTypeInt(signed=False, label="TRUSTEE_TYPE"), "ptstrName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="TRUSTEE_W", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypePointer(SimStruct({"pMultipleTrustee": SimTypePointer(SimTypeBottom(label="TRUSTEE_W"), offset=0), "MultipleTrusteeOperation": SimTypeInt(signed=False, label="MULTIPLE_TRUSTEE_OPERATION"), "TrusteeForm": SimTypeInt(signed=False, label="TRUSTEE_FORM"), "TrusteeType": SimTypeInt(signed=False, label="TRUSTEE_TYPE"), "ptstrName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="TRUSTEE_W", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"grfAccessPermissions": SimTypeInt(signed=False, label="UInt32"), "grfAccessMode": SimTypeInt(signed=False, label="ACCESS_MODE"), "grfInheritance": SimTypeBottom(label="ACE_FLAGS"), "Trustee": SimStruct({"pMultipleTrustee": SimTypePointer(SimTypeBottom(label="TRUSTEE_W"), offset=0), "MultipleTrusteeOperation": SimTypeInt(signed=False, label="MULTIPLE_TRUSTEE_OPERATION"), "TrusteeForm": SimTypeInt(signed=False, label="TRUSTEE_FORM"), "TrusteeType": SimTypeInt(signed=False, label="TRUSTEE_TYPE"), "ptstrName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="TRUSTEE_W", pack=False, align=None)}, name="EXPLICIT_ACCESS_W", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"grfAccessPermissions": SimTypeInt(signed=False, label="UInt32"), "grfAccessMode": SimTypeInt(signed=False, label="ACCESS_MODE"), "grfInheritance": SimTypeBottom(label="ACE_FLAGS"), "Trustee": SimStruct({"pMultipleTrustee": SimTypePointer(SimTypeBottom(label="TRUSTEE_W"), offset=0), "MultipleTrusteeOperation": SimTypeInt(signed=False, label="MULTIPLE_TRUSTEE_OPERATION"), "TrusteeForm": SimTypeInt(signed=False, label="TRUSTEE_FORM"), "TrusteeType": SimTypeInt(signed=False, label="TRUSTEE_TYPE"), "ptstrName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="TRUSTEE_W", pack=False, align=None)}, name="EXPLICIT_ACCESS_W", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ppOwner", "ppGroup", "pcCountOfAccessEntries", "ppListOfAccessEntries", "pcCountOfAuditEntries", "ppListOfAuditEntries", "pSD"]),
        # 
        'BuildExplicitAccessWithNameA': SimTypeFunction([SimTypePointer(SimStruct({"grfAccessPermissions": SimTypeInt(signed=False, label="UInt32"), "grfAccessMode": SimTypeInt(signed=False, label="ACCESS_MODE"), "grfInheritance": SimTypeBottom(label="ACE_FLAGS"), "Trustee": SimStruct({"pMultipleTrustee": SimTypePointer(SimTypeBottom(label="TRUSTEE_A"), offset=0), "MultipleTrusteeOperation": SimTypeInt(signed=False, label="MULTIPLE_TRUSTEE_OPERATION"), "TrusteeForm": SimTypeInt(signed=False, label="TRUSTEE_FORM"), "TrusteeType": SimTypeInt(signed=False, label="TRUSTEE_TYPE"), "ptstrName": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="TRUSTEE_A", pack=False, align=None)}, name="EXPLICIT_ACCESS_A", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="ACCESS_MODE"), SimTypeInt(signed=False, label="ACE_FLAGS")], SimTypeBottom(label="Void"), arg_names=["pExplicitAccess", "pTrusteeName", "AccessPermissions", "AccessMode", "Inheritance"]),
        # 
        'BuildExplicitAccessWithNameW': SimTypeFunction([SimTypePointer(SimStruct({"grfAccessPermissions": SimTypeInt(signed=False, label="UInt32"), "grfAccessMode": SimTypeInt(signed=False, label="ACCESS_MODE"), "grfInheritance": SimTypeBottom(label="ACE_FLAGS"), "Trustee": SimStruct({"pMultipleTrustee": SimTypePointer(SimTypeBottom(label="TRUSTEE_W"), offset=0), "MultipleTrusteeOperation": SimTypeInt(signed=False, label="MULTIPLE_TRUSTEE_OPERATION"), "TrusteeForm": SimTypeInt(signed=False, label="TRUSTEE_FORM"), "TrusteeType": SimTypeInt(signed=False, label="TRUSTEE_TYPE"), "ptstrName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="TRUSTEE_W", pack=False, align=None)}, name="EXPLICIT_ACCESS_W", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="ACCESS_MODE"), SimTypeInt(signed=False, label="ACE_FLAGS")], SimTypeBottom(label="Void"), arg_names=["pExplicitAccess", "pTrusteeName", "AccessPermissions", "AccessMode", "Inheritance"]),
        # 
        'BuildImpersonateExplicitAccessWithNameA': SimTypeFunction([SimTypePointer(SimStruct({"grfAccessPermissions": SimTypeInt(signed=False, label="UInt32"), "grfAccessMode": SimTypeInt(signed=False, label="ACCESS_MODE"), "grfInheritance": SimTypeBottom(label="ACE_FLAGS"), "Trustee": SimStruct({"pMultipleTrustee": SimTypePointer(SimTypeBottom(label="TRUSTEE_A"), offset=0), "MultipleTrusteeOperation": SimTypeInt(signed=False, label="MULTIPLE_TRUSTEE_OPERATION"), "TrusteeForm": SimTypeInt(signed=False, label="TRUSTEE_FORM"), "TrusteeType": SimTypeInt(signed=False, label="TRUSTEE_TYPE"), "ptstrName": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="TRUSTEE_A", pack=False, align=None)}, name="EXPLICIT_ACCESS_A", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"pMultipleTrustee": SimTypePointer(SimTypeBottom(label="TRUSTEE_A"), offset=0), "MultipleTrusteeOperation": SimTypeInt(signed=False, label="MULTIPLE_TRUSTEE_OPERATION"), "TrusteeForm": SimTypeInt(signed=False, label="TRUSTEE_FORM"), "TrusteeType": SimTypeInt(signed=False, label="TRUSTEE_TYPE"), "ptstrName": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="TRUSTEE_A", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="ACCESS_MODE"), SimTypeInt(signed=False, label="UInt32")], SimTypeBottom(label="Void"), arg_names=["pExplicitAccess", "pTrusteeName", "pTrustee", "AccessPermissions", "AccessMode", "Inheritance"]),
        # 
        'BuildImpersonateExplicitAccessWithNameW': SimTypeFunction([SimTypePointer(SimStruct({"grfAccessPermissions": SimTypeInt(signed=False, label="UInt32"), "grfAccessMode": SimTypeInt(signed=False, label="ACCESS_MODE"), "grfInheritance": SimTypeBottom(label="ACE_FLAGS"), "Trustee": SimStruct({"pMultipleTrustee": SimTypePointer(SimTypeBottom(label="TRUSTEE_W"), offset=0), "MultipleTrusteeOperation": SimTypeInt(signed=False, label="MULTIPLE_TRUSTEE_OPERATION"), "TrusteeForm": SimTypeInt(signed=False, label="TRUSTEE_FORM"), "TrusteeType": SimTypeInt(signed=False, label="TRUSTEE_TYPE"), "ptstrName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="TRUSTEE_W", pack=False, align=None)}, name="EXPLICIT_ACCESS_W", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"pMultipleTrustee": SimTypePointer(SimTypeBottom(label="TRUSTEE_W"), offset=0), "MultipleTrusteeOperation": SimTypeInt(signed=False, label="MULTIPLE_TRUSTEE_OPERATION"), "TrusteeForm": SimTypeInt(signed=False, label="TRUSTEE_FORM"), "TrusteeType": SimTypeInt(signed=False, label="TRUSTEE_TYPE"), "ptstrName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="TRUSTEE_W", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="ACCESS_MODE"), SimTypeInt(signed=False, label="UInt32")], SimTypeBottom(label="Void"), arg_names=["pExplicitAccess", "pTrusteeName", "pTrustee", "AccessPermissions", "AccessMode", "Inheritance"]),
        # 
        'BuildTrusteeWithNameA': SimTypeFunction([SimTypePointer(SimStruct({"pMultipleTrustee": SimTypePointer(SimTypeBottom(label="TRUSTEE_A"), offset=0), "MultipleTrusteeOperation": SimTypeInt(signed=False, label="MULTIPLE_TRUSTEE_OPERATION"), "TrusteeForm": SimTypeInt(signed=False, label="TRUSTEE_FORM"), "TrusteeType": SimTypeInt(signed=False, label="TRUSTEE_TYPE"), "ptstrName": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="TRUSTEE_A", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pTrustee", "pName"]),
        # 
        'BuildTrusteeWithNameW': SimTypeFunction([SimTypePointer(SimStruct({"pMultipleTrustee": SimTypePointer(SimTypeBottom(label="TRUSTEE_W"), offset=0), "MultipleTrusteeOperation": SimTypeInt(signed=False, label="MULTIPLE_TRUSTEE_OPERATION"), "TrusteeForm": SimTypeInt(signed=False, label="TRUSTEE_FORM"), "TrusteeType": SimTypeInt(signed=False, label="TRUSTEE_TYPE"), "ptstrName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="TRUSTEE_W", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pTrustee", "pName"]),
        # 
        'BuildImpersonateTrusteeA': SimTypeFunction([SimTypePointer(SimStruct({"pMultipleTrustee": SimTypePointer(SimTypeBottom(label="TRUSTEE_A"), offset=0), "MultipleTrusteeOperation": SimTypeInt(signed=False, label="MULTIPLE_TRUSTEE_OPERATION"), "TrusteeForm": SimTypeInt(signed=False, label="TRUSTEE_FORM"), "TrusteeType": SimTypeInt(signed=False, label="TRUSTEE_TYPE"), "ptstrName": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="TRUSTEE_A", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"pMultipleTrustee": SimTypePointer(SimTypeBottom(label="TRUSTEE_A"), offset=0), "MultipleTrusteeOperation": SimTypeInt(signed=False, label="MULTIPLE_TRUSTEE_OPERATION"), "TrusteeForm": SimTypeInt(signed=False, label="TRUSTEE_FORM"), "TrusteeType": SimTypeInt(signed=False, label="TRUSTEE_TYPE"), "ptstrName": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="TRUSTEE_A", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["pTrustee", "pImpersonateTrustee"]),
        # 
        'BuildImpersonateTrusteeW': SimTypeFunction([SimTypePointer(SimStruct({"pMultipleTrustee": SimTypePointer(SimTypeBottom(label="TRUSTEE_W"), offset=0), "MultipleTrusteeOperation": SimTypeInt(signed=False, label="MULTIPLE_TRUSTEE_OPERATION"), "TrusteeForm": SimTypeInt(signed=False, label="TRUSTEE_FORM"), "TrusteeType": SimTypeInt(signed=False, label="TRUSTEE_TYPE"), "ptstrName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="TRUSTEE_W", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"pMultipleTrustee": SimTypePointer(SimTypeBottom(label="TRUSTEE_W"), offset=0), "MultipleTrusteeOperation": SimTypeInt(signed=False, label="MULTIPLE_TRUSTEE_OPERATION"), "TrusteeForm": SimTypeInt(signed=False, label="TRUSTEE_FORM"), "TrusteeType": SimTypeInt(signed=False, label="TRUSTEE_TYPE"), "ptstrName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="TRUSTEE_W", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["pTrustee", "pImpersonateTrustee"]),
        # 
        'BuildTrusteeWithSidA': SimTypeFunction([SimTypePointer(SimStruct({"pMultipleTrustee": SimTypePointer(SimTypeBottom(label="TRUSTEE_A"), offset=0), "MultipleTrusteeOperation": SimTypeInt(signed=False, label="MULTIPLE_TRUSTEE_OPERATION"), "TrusteeForm": SimTypeInt(signed=False, label="TRUSTEE_FORM"), "TrusteeType": SimTypeInt(signed=False, label="TRUSTEE_TYPE"), "ptstrName": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="TRUSTEE_A", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeBottom(label="Void"), arg_names=["pTrustee", "pSid"]),
        # 
        'BuildTrusteeWithSidW': SimTypeFunction([SimTypePointer(SimStruct({"pMultipleTrustee": SimTypePointer(SimTypeBottom(label="TRUSTEE_W"), offset=0), "MultipleTrusteeOperation": SimTypeInt(signed=False, label="MULTIPLE_TRUSTEE_OPERATION"), "TrusteeForm": SimTypeInt(signed=False, label="TRUSTEE_FORM"), "TrusteeType": SimTypeInt(signed=False, label="TRUSTEE_TYPE"), "ptstrName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="TRUSTEE_W", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeBottom(label="Void"), arg_names=["pTrustee", "pSid"]),
        # 
        'BuildTrusteeWithObjectsAndSidA': SimTypeFunction([SimTypePointer(SimStruct({"pMultipleTrustee": SimTypePointer(SimTypeBottom(label="TRUSTEE_A"), offset=0), "MultipleTrusteeOperation": SimTypeInt(signed=False, label="MULTIPLE_TRUSTEE_OPERATION"), "TrusteeForm": SimTypeInt(signed=False, label="TRUSTEE_FORM"), "TrusteeType": SimTypeInt(signed=False, label="TRUSTEE_TYPE"), "ptstrName": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="TRUSTEE_A", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"ObjectsPresent": SimTypeBottom(label="SYSTEM_AUDIT_OBJECT_ACE_FLAGS"), "ObjectTypeGuid": SimTypeBottom(label="Guid"), "InheritedObjectTypeGuid": SimTypeBottom(label="Guid"), "pSid": SimTypePointer(SimTypeBottom(label="SID"), offset=0)}, name="OBJECTS_AND_SID", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeBottom(label="Void"), arg_names=["pTrustee", "pObjSid", "pObjectGuid", "pInheritedObjectGuid", "pSid"]),
        # 
        'BuildTrusteeWithObjectsAndSidW': SimTypeFunction([SimTypePointer(SimStruct({"pMultipleTrustee": SimTypePointer(SimTypeBottom(label="TRUSTEE_W"), offset=0), "MultipleTrusteeOperation": SimTypeInt(signed=False, label="MULTIPLE_TRUSTEE_OPERATION"), "TrusteeForm": SimTypeInt(signed=False, label="TRUSTEE_FORM"), "TrusteeType": SimTypeInt(signed=False, label="TRUSTEE_TYPE"), "ptstrName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="TRUSTEE_W", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"ObjectsPresent": SimTypeBottom(label="SYSTEM_AUDIT_OBJECT_ACE_FLAGS"), "ObjectTypeGuid": SimTypeBottom(label="Guid"), "InheritedObjectTypeGuid": SimTypeBottom(label="Guid"), "pSid": SimTypePointer(SimTypeBottom(label="SID"), offset=0)}, name="OBJECTS_AND_SID", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeBottom(label="Void"), arg_names=["pTrustee", "pObjSid", "pObjectGuid", "pInheritedObjectGuid", "pSid"]),
        # 
        'BuildTrusteeWithObjectsAndNameA': SimTypeFunction([SimTypePointer(SimStruct({"pMultipleTrustee": SimTypePointer(SimTypeBottom(label="TRUSTEE_A"), offset=0), "MultipleTrusteeOperation": SimTypeInt(signed=False, label="MULTIPLE_TRUSTEE_OPERATION"), "TrusteeForm": SimTypeInt(signed=False, label="TRUSTEE_FORM"), "TrusteeType": SimTypeInt(signed=False, label="TRUSTEE_TYPE"), "ptstrName": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="TRUSTEE_A", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"ObjectsPresent": SimTypeBottom(label="SYSTEM_AUDIT_OBJECT_ACE_FLAGS"), "ObjectType": SimTypeInt(signed=False, label="SE_OBJECT_TYPE"), "ObjectTypeName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "InheritedObjectTypeName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "ptstrName": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="OBJECTS_AND_NAME_A", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="SE_OBJECT_TYPE"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pTrustee", "pObjName", "ObjectType", "ObjectTypeName", "InheritedObjectTypeName", "Name"]),
        # 
        'BuildTrusteeWithObjectsAndNameW': SimTypeFunction([SimTypePointer(SimStruct({"pMultipleTrustee": SimTypePointer(SimTypeBottom(label="TRUSTEE_W"), offset=0), "MultipleTrusteeOperation": SimTypeInt(signed=False, label="MULTIPLE_TRUSTEE_OPERATION"), "TrusteeForm": SimTypeInt(signed=False, label="TRUSTEE_FORM"), "TrusteeType": SimTypeInt(signed=False, label="TRUSTEE_TYPE"), "ptstrName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="TRUSTEE_W", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"ObjectsPresent": SimTypeBottom(label="SYSTEM_AUDIT_OBJECT_ACE_FLAGS"), "ObjectType": SimTypeInt(signed=False, label="SE_OBJECT_TYPE"), "ObjectTypeName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "InheritedObjectTypeName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ptstrName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="OBJECTS_AND_NAME_W", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="SE_OBJECT_TYPE"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pTrustee", "pObjName", "ObjectType", "ObjectTypeName", "InheritedObjectTypeName", "Name"]),
        # 
        'GetTrusteeNameA': SimTypeFunction([SimTypePointer(SimStruct({"pMultipleTrustee": SimTypePointer(SimTypeBottom(label="TRUSTEE_A"), offset=0), "MultipleTrusteeOperation": SimTypeInt(signed=False, label="MULTIPLE_TRUSTEE_OPERATION"), "TrusteeForm": SimTypeInt(signed=False, label="TRUSTEE_FORM"), "TrusteeType": SimTypeInt(signed=False, label="TRUSTEE_TYPE"), "ptstrName": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="TRUSTEE_A", pack=False, align=None), offset=0)], SimTypePointer(SimTypeChar(label="Byte"), offset=0), arg_names=["pTrustee"]),
        # 
        'GetTrusteeNameW': SimTypeFunction([SimTypePointer(SimStruct({"pMultipleTrustee": SimTypePointer(SimTypeBottom(label="TRUSTEE_W"), offset=0), "MultipleTrusteeOperation": SimTypeInt(signed=False, label="MULTIPLE_TRUSTEE_OPERATION"), "TrusteeForm": SimTypeInt(signed=False, label="TRUSTEE_FORM"), "TrusteeType": SimTypeInt(signed=False, label="TRUSTEE_TYPE"), "ptstrName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="TRUSTEE_W", pack=False, align=None), offset=0)], SimTypePointer(SimTypeChar(label="Char"), offset=0), arg_names=["pTrustee"]),
        # 
        'GetTrusteeTypeA': SimTypeFunction([SimTypePointer(SimStruct({"pMultipleTrustee": SimTypePointer(SimTypeBottom(label="TRUSTEE_A"), offset=0), "MultipleTrusteeOperation": SimTypeInt(signed=False, label="MULTIPLE_TRUSTEE_OPERATION"), "TrusteeForm": SimTypeInt(signed=False, label="TRUSTEE_FORM"), "TrusteeType": SimTypeInt(signed=False, label="TRUSTEE_TYPE"), "ptstrName": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="TRUSTEE_A", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="TRUSTEE_TYPE"), arg_names=["pTrustee"]),
        # 
        'GetTrusteeTypeW': SimTypeFunction([SimTypePointer(SimStruct({"pMultipleTrustee": SimTypePointer(SimTypeBottom(label="TRUSTEE_W"), offset=0), "MultipleTrusteeOperation": SimTypeInt(signed=False, label="MULTIPLE_TRUSTEE_OPERATION"), "TrusteeForm": SimTypeInt(signed=False, label="TRUSTEE_FORM"), "TrusteeType": SimTypeInt(signed=False, label="TRUSTEE_TYPE"), "ptstrName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="TRUSTEE_W", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="TRUSTEE_TYPE"), arg_names=["pTrustee"]),
        # 
        'GetTrusteeFormA': SimTypeFunction([SimTypePointer(SimStruct({"pMultipleTrustee": SimTypePointer(SimTypeBottom(label="TRUSTEE_A"), offset=0), "MultipleTrusteeOperation": SimTypeInt(signed=False, label="MULTIPLE_TRUSTEE_OPERATION"), "TrusteeForm": SimTypeInt(signed=False, label="TRUSTEE_FORM"), "TrusteeType": SimTypeInt(signed=False, label="TRUSTEE_TYPE"), "ptstrName": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="TRUSTEE_A", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="TRUSTEE_FORM"), arg_names=["pTrustee"]),
        # 
        'GetTrusteeFormW': SimTypeFunction([SimTypePointer(SimStruct({"pMultipleTrustee": SimTypePointer(SimTypeBottom(label="TRUSTEE_W"), offset=0), "MultipleTrusteeOperation": SimTypeInt(signed=False, label="MULTIPLE_TRUSTEE_OPERATION"), "TrusteeForm": SimTypeInt(signed=False, label="TRUSTEE_FORM"), "TrusteeType": SimTypeInt(signed=False, label="TRUSTEE_TYPE"), "ptstrName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="TRUSTEE_W", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="TRUSTEE_FORM"), arg_names=["pTrustee"]),
        # 
        'GetMultipleTrusteeOperationA': SimTypeFunction([SimTypePointer(SimStruct({"pMultipleTrustee": SimTypePointer(SimTypeBottom(label="TRUSTEE_A"), offset=0), "MultipleTrusteeOperation": SimTypeInt(signed=False, label="MULTIPLE_TRUSTEE_OPERATION"), "TrusteeForm": SimTypeInt(signed=False, label="TRUSTEE_FORM"), "TrusteeType": SimTypeInt(signed=False, label="TRUSTEE_TYPE"), "ptstrName": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="TRUSTEE_A", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="MULTIPLE_TRUSTEE_OPERATION"), arg_names=["pTrustee"]),
        # 
        'GetMultipleTrusteeOperationW': SimTypeFunction([SimTypePointer(SimStruct({"pMultipleTrustee": SimTypePointer(SimTypeBottom(label="TRUSTEE_W"), offset=0), "MultipleTrusteeOperation": SimTypeInt(signed=False, label="MULTIPLE_TRUSTEE_OPERATION"), "TrusteeForm": SimTypeInt(signed=False, label="TRUSTEE_FORM"), "TrusteeType": SimTypeInt(signed=False, label="TRUSTEE_TYPE"), "ptstrName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="TRUSTEE_W", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="MULTIPLE_TRUSTEE_OPERATION"), arg_names=["pTrustee"]),
        # 
        'GetMultipleTrusteeA': SimTypeFunction([SimTypePointer(SimStruct({"pMultipleTrustee": SimTypePointer(SimTypeBottom(label="TRUSTEE_A"), offset=0), "MultipleTrusteeOperation": SimTypeInt(signed=False, label="MULTIPLE_TRUSTEE_OPERATION"), "TrusteeForm": SimTypeInt(signed=False, label="TRUSTEE_FORM"), "TrusteeType": SimTypeInt(signed=False, label="TRUSTEE_TYPE"), "ptstrName": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="TRUSTEE_A", pack=False, align=None), offset=0)], SimTypePointer(SimStruct({"pMultipleTrustee": SimTypePointer(SimTypeBottom(label="TRUSTEE_A"), offset=0), "MultipleTrusteeOperation": SimTypeInt(signed=False, label="MULTIPLE_TRUSTEE_OPERATION"), "TrusteeForm": SimTypeInt(signed=False, label="TRUSTEE_FORM"), "TrusteeType": SimTypeInt(signed=False, label="TRUSTEE_TYPE"), "ptstrName": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="TRUSTEE_A", pack=False, align=None), offset=0), arg_names=["pTrustee"]),
        # 
        'GetMultipleTrusteeW': SimTypeFunction([SimTypePointer(SimStruct({"pMultipleTrustee": SimTypePointer(SimTypeBottom(label="TRUSTEE_W"), offset=0), "MultipleTrusteeOperation": SimTypeInt(signed=False, label="MULTIPLE_TRUSTEE_OPERATION"), "TrusteeForm": SimTypeInt(signed=False, label="TRUSTEE_FORM"), "TrusteeType": SimTypeInt(signed=False, label="TRUSTEE_TYPE"), "ptstrName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="TRUSTEE_W", pack=False, align=None), offset=0)], SimTypePointer(SimStruct({"pMultipleTrustee": SimTypePointer(SimTypeBottom(label="TRUSTEE_W"), offset=0), "MultipleTrusteeOperation": SimTypeInt(signed=False, label="MULTIPLE_TRUSTEE_OPERATION"), "TrusteeForm": SimTypeInt(signed=False, label="TRUSTEE_FORM"), "TrusteeType": SimTypeInt(signed=False, label="TRUSTEE_TYPE"), "ptstrName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="TRUSTEE_W", pack=False, align=None), offset=0), arg_names=["pTrustee"]),
        # 
        'ConvertSidToStringSidA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Sid", "StringSid"]),
        # 
        'ConvertSidToStringSidW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Sid", "StringSid"]),
        # 
        'ConvertStringSidToSidA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["StringSid", "Sid"]),
        # 
        'ConvertStringSidToSidW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["StringSid", "Sid"]),
        # 
        'ConvertStringSecurityDescriptorToSecurityDescriptorA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["StringSecurityDescriptor", "StringSDRevision", "SecurityDescriptor", "SecurityDescriptorSize"]),
        # 
        'ConvertStringSecurityDescriptorToSecurityDescriptorW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["StringSecurityDescriptor", "StringSDRevision", "SecurityDescriptor", "SecurityDescriptorSize"]),
        # 
        'ConvertSecurityDescriptorToStringSecurityDescriptorA': SimTypeFunction([SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["SecurityDescriptor", "RequestedStringSDRevision", "SecurityInformation", "StringSecurityDescriptor", "StringSecurityDescriptorLen"]),
        # 
        'ConvertSecurityDescriptorToStringSecurityDescriptorW': SimTypeFunction([SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["SecurityDescriptor", "RequestedStringSDRevision", "SecurityInformation", "StringSecurityDescriptor", "StringSecurityDescriptorLen"]),
        # 
        'CredWriteW': SimTypeFunction([SimTypePointer(SimStruct({"Flags": SimTypeInt(signed=False, label="CRED_FLAGS"), "Type": SimTypeInt(signed=False, label="CRED_TYPE"), "TargetName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Comment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "LastWritten": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "CredentialBlobSize": SimTypeInt(signed=False, label="UInt32"), "CredentialBlob": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Persist": SimTypeInt(signed=False, label="CRED_PERSIST"), "AttributeCount": SimTypeInt(signed=False, label="UInt32"), "Attributes": SimTypePointer(SimStruct({"Keyword": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Flags": SimTypeInt(signed=False, label="UInt32"), "ValueSize": SimTypeInt(signed=False, label="UInt32"), "Value": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CREDENTIAL_ATTRIBUTEW", pack=False, align=None), offset=0), "TargetAlias": SimTypePointer(SimTypeChar(label="Char"), offset=0), "UserName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="CREDENTIALW", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["Credential", "Flags"]),
        # 
        'CredWriteA': SimTypeFunction([SimTypePointer(SimStruct({"Flags": SimTypeInt(signed=False, label="CRED_FLAGS"), "Type": SimTypeInt(signed=False, label="CRED_TYPE"), "TargetName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Comment": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "LastWritten": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "CredentialBlobSize": SimTypeInt(signed=False, label="UInt32"), "CredentialBlob": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Persist": SimTypeInt(signed=False, label="CRED_PERSIST"), "AttributeCount": SimTypeInt(signed=False, label="UInt32"), "Attributes": SimTypePointer(SimStruct({"Keyword": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Flags": SimTypeInt(signed=False, label="UInt32"), "ValueSize": SimTypeInt(signed=False, label="UInt32"), "Value": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CREDENTIAL_ATTRIBUTEA", pack=False, align=None), offset=0), "TargetAlias": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "UserName": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CREDENTIALA", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["Credential", "Flags"]),
        # 
        'CredReadW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"Flags": SimTypeInt(signed=False, label="CRED_FLAGS"), "Type": SimTypeInt(signed=False, label="CRED_TYPE"), "TargetName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Comment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "LastWritten": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "CredentialBlobSize": SimTypeInt(signed=False, label="UInt32"), "CredentialBlob": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Persist": SimTypeInt(signed=False, label="CRED_PERSIST"), "AttributeCount": SimTypeInt(signed=False, label="UInt32"), "Attributes": SimTypePointer(SimStruct({"Keyword": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Flags": SimTypeInt(signed=False, label="UInt32"), "ValueSize": SimTypeInt(signed=False, label="UInt32"), "Value": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CREDENTIAL_ATTRIBUTEW", pack=False, align=None), offset=0), "TargetAlias": SimTypePointer(SimTypeChar(label="Char"), offset=0), "UserName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="CREDENTIALW", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["TargetName", "Type", "Flags", "Credential"]),
        # 
        'CredReadA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"Flags": SimTypeInt(signed=False, label="CRED_FLAGS"), "Type": SimTypeInt(signed=False, label="CRED_TYPE"), "TargetName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Comment": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "LastWritten": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "CredentialBlobSize": SimTypeInt(signed=False, label="UInt32"), "CredentialBlob": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Persist": SimTypeInt(signed=False, label="CRED_PERSIST"), "AttributeCount": SimTypeInt(signed=False, label="UInt32"), "Attributes": SimTypePointer(SimStruct({"Keyword": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Flags": SimTypeInt(signed=False, label="UInt32"), "ValueSize": SimTypeInt(signed=False, label="UInt32"), "Value": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CREDENTIAL_ATTRIBUTEA", pack=False, align=None), offset=0), "TargetAlias": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "UserName": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CREDENTIALA", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["TargetName", "Type", "Flags", "Credential"]),
        # 
        'CredEnumerateW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="CRED_ENUMERATE_FLAGS"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimTypePointer(SimStruct({"Flags": SimTypeInt(signed=False, label="CRED_FLAGS"), "Type": SimTypeInt(signed=False, label="CRED_TYPE"), "TargetName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Comment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "LastWritten": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "CredentialBlobSize": SimTypeInt(signed=False, label="UInt32"), "CredentialBlob": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Persist": SimTypeInt(signed=False, label="CRED_PERSIST"), "AttributeCount": SimTypeInt(signed=False, label="UInt32"), "Attributes": SimTypePointer(SimStruct({"Keyword": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Flags": SimTypeInt(signed=False, label="UInt32"), "ValueSize": SimTypeInt(signed=False, label="UInt32"), "Value": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CREDENTIAL_ATTRIBUTEW", pack=False, align=None), offset=0), "TargetAlias": SimTypePointer(SimTypeChar(label="Char"), offset=0), "UserName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="CREDENTIALW", pack=False, align=None), offset=0), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Filter", "Flags", "Count", "Credential"]),
        # 
        'CredEnumerateA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="CRED_ENUMERATE_FLAGS"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimTypePointer(SimStruct({"Flags": SimTypeInt(signed=False, label="CRED_FLAGS"), "Type": SimTypeInt(signed=False, label="CRED_TYPE"), "TargetName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Comment": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "LastWritten": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "CredentialBlobSize": SimTypeInt(signed=False, label="UInt32"), "CredentialBlob": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Persist": SimTypeInt(signed=False, label="CRED_PERSIST"), "AttributeCount": SimTypeInt(signed=False, label="UInt32"), "Attributes": SimTypePointer(SimStruct({"Keyword": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Flags": SimTypeInt(signed=False, label="UInt32"), "ValueSize": SimTypeInt(signed=False, label="UInt32"), "Value": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CREDENTIAL_ATTRIBUTEA", pack=False, align=None), offset=0), "TargetAlias": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "UserName": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CREDENTIALA", pack=False, align=None), offset=0), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Filter", "Flags", "Count", "Credential"]),
        # 
        'CredWriteDomainCredentialsW': SimTypeFunction([SimTypePointer(SimStruct({"TargetName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "NetbiosServerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "DnsServerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "NetbiosDomainName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "DnsDomainName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "DnsTreeName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "PackageName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Flags": SimTypeInt(signed=False, label="UInt32"), "CredTypeCount": SimTypeInt(signed=False, label="UInt32"), "CredTypes": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="CREDENTIAL_TARGET_INFORMATIONW", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Flags": SimTypeInt(signed=False, label="CRED_FLAGS"), "Type": SimTypeInt(signed=False, label="CRED_TYPE"), "TargetName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Comment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "LastWritten": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "CredentialBlobSize": SimTypeInt(signed=False, label="UInt32"), "CredentialBlob": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Persist": SimTypeInt(signed=False, label="CRED_PERSIST"), "AttributeCount": SimTypeInt(signed=False, label="UInt32"), "Attributes": SimTypePointer(SimStruct({"Keyword": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Flags": SimTypeInt(signed=False, label="UInt32"), "ValueSize": SimTypeInt(signed=False, label="UInt32"), "Value": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CREDENTIAL_ATTRIBUTEW", pack=False, align=None), offset=0), "TargetAlias": SimTypePointer(SimTypeChar(label="Char"), offset=0), "UserName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="CREDENTIALW", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["TargetInfo", "Credential", "Flags"]),
        # 
        'CredWriteDomainCredentialsA': SimTypeFunction([SimTypePointer(SimStruct({"TargetName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "NetbiosServerName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "DnsServerName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "NetbiosDomainName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "DnsDomainName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "DnsTreeName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "PackageName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Flags": SimTypeInt(signed=False, label="UInt32"), "CredTypeCount": SimTypeInt(signed=False, label="UInt32"), "CredTypes": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="CREDENTIAL_TARGET_INFORMATIONA", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Flags": SimTypeInt(signed=False, label="CRED_FLAGS"), "Type": SimTypeInt(signed=False, label="CRED_TYPE"), "TargetName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Comment": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "LastWritten": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "CredentialBlobSize": SimTypeInt(signed=False, label="UInt32"), "CredentialBlob": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Persist": SimTypeInt(signed=False, label="CRED_PERSIST"), "AttributeCount": SimTypeInt(signed=False, label="UInt32"), "Attributes": SimTypePointer(SimStruct({"Keyword": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Flags": SimTypeInt(signed=False, label="UInt32"), "ValueSize": SimTypeInt(signed=False, label="UInt32"), "Value": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CREDENTIAL_ATTRIBUTEA", pack=False, align=None), offset=0), "TargetAlias": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "UserName": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CREDENTIALA", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["TargetInfo", "Credential", "Flags"]),
        # 
        'CredReadDomainCredentialsW': SimTypeFunction([SimTypePointer(SimStruct({"TargetName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "NetbiosServerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "DnsServerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "NetbiosDomainName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "DnsDomainName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "DnsTreeName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "PackageName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Flags": SimTypeInt(signed=False, label="UInt32"), "CredTypeCount": SimTypeInt(signed=False, label="UInt32"), "CredTypes": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="CREDENTIAL_TARGET_INFORMATIONW", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimTypePointer(SimStruct({"Flags": SimTypeInt(signed=False, label="CRED_FLAGS"), "Type": SimTypeInt(signed=False, label="CRED_TYPE"), "TargetName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Comment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "LastWritten": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "CredentialBlobSize": SimTypeInt(signed=False, label="UInt32"), "CredentialBlob": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Persist": SimTypeInt(signed=False, label="CRED_PERSIST"), "AttributeCount": SimTypeInt(signed=False, label="UInt32"), "Attributes": SimTypePointer(SimStruct({"Keyword": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Flags": SimTypeInt(signed=False, label="UInt32"), "ValueSize": SimTypeInt(signed=False, label="UInt32"), "Value": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CREDENTIAL_ATTRIBUTEW", pack=False, align=None), offset=0), "TargetAlias": SimTypePointer(SimTypeChar(label="Char"), offset=0), "UserName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="CREDENTIALW", pack=False, align=None), offset=0), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["TargetInfo", "Flags", "Count", "Credential"]),
        # 
        'CredReadDomainCredentialsA': SimTypeFunction([SimTypePointer(SimStruct({"TargetName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "NetbiosServerName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "DnsServerName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "NetbiosDomainName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "DnsDomainName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "DnsTreeName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "PackageName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Flags": SimTypeInt(signed=False, label="UInt32"), "CredTypeCount": SimTypeInt(signed=False, label="UInt32"), "CredTypes": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="CREDENTIAL_TARGET_INFORMATIONA", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimTypePointer(SimStruct({"Flags": SimTypeInt(signed=False, label="CRED_FLAGS"), "Type": SimTypeInt(signed=False, label="CRED_TYPE"), "TargetName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Comment": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "LastWritten": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "CredentialBlobSize": SimTypeInt(signed=False, label="UInt32"), "CredentialBlob": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Persist": SimTypeInt(signed=False, label="CRED_PERSIST"), "AttributeCount": SimTypeInt(signed=False, label="UInt32"), "Attributes": SimTypePointer(SimStruct({"Keyword": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Flags": SimTypeInt(signed=False, label="UInt32"), "ValueSize": SimTypeInt(signed=False, label="UInt32"), "Value": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CREDENTIAL_ATTRIBUTEA", pack=False, align=None), offset=0), "TargetAlias": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "UserName": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CREDENTIALA", pack=False, align=None), offset=0), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["TargetInfo", "Flags", "Count", "Credential"]),
        # 
        'CredDeleteW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["TargetName", "Type", "Flags"]),
        # 
        'CredDeleteA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["TargetName", "Type", "Flags"]),
        # 
        'CredRenameW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["OldTargetName", "NewTargetName", "Type", "Flags"]),
        # 
        'CredRenameA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["OldTargetName", "NewTargetName", "Type", "Flags"]),
        # 
        'CredGetTargetInfoW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"TargetName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "NetbiosServerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "DnsServerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "NetbiosDomainName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "DnsDomainName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "DnsTreeName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "PackageName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Flags": SimTypeInt(signed=False, label="UInt32"), "CredTypeCount": SimTypeInt(signed=False, label="UInt32"), "CredTypes": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="CREDENTIAL_TARGET_INFORMATIONW", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["TargetName", "Flags", "TargetInfo"]),
        # 
        'CredGetTargetInfoA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"TargetName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "NetbiosServerName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "DnsServerName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "NetbiosDomainName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "DnsDomainName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "DnsTreeName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "PackageName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Flags": SimTypeInt(signed=False, label="UInt32"), "CredTypeCount": SimTypeInt(signed=False, label="UInt32"), "CredTypes": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="CREDENTIAL_TARGET_INFORMATIONA", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["TargetName", "Flags", "TargetInfo"]),
        # 
        'CredMarshalCredentialW': SimTypeFunction([SimTypeInt(signed=False, label="CRED_MARSHAL_TYPE"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["CredType", "Credential", "MarshaledCredential"]),
        # 
        'CredMarshalCredentialA': SimTypeFunction([SimTypeInt(signed=False, label="CRED_MARSHAL_TYPE"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["CredType", "Credential", "MarshaledCredential"]),
        # 
        'CredUnmarshalCredentialW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="CRED_MARSHAL_TYPE"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["MarshaledCredential", "CredType", "Credential"]),
        # 
        'CredUnmarshalCredentialA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="CRED_MARSHAL_TYPE"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["MarshaledCredential", "CredType", "Credential"]),
        # 
        'CredIsMarshaledCredentialW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["MarshaledCredential"]),
        # 
        'CredIsMarshaledCredentialA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["MarshaledCredential"]),
        # 
        'CredProtectW': SimTypeFunction([SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="CRED_PROTECTION_TYPE"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["fAsSelf", "pszCredentials", "cchCredentials", "pszProtectedCredentials", "pcchMaxChars", "ProtectionType"]),
        # 
        'CredProtectA': SimTypeFunction([SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="CRED_PROTECTION_TYPE"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["fAsSelf", "pszCredentials", "cchCredentials", "pszProtectedCredentials", "pcchMaxChars", "ProtectionType"]),
        # 
        'CredUnprotectW': SimTypeFunction([SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["fAsSelf", "pszProtectedCredentials", "cchProtectedCredentials", "pszCredentials", "pcchMaxChars"]),
        # 
        'CredUnprotectA': SimTypeFunction([SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["fAsSelf", "pszProtectedCredentials", "cchProtectedCredentials", "pszCredentials", "pcchMaxChars"]),
        # 
        'CredIsProtectedW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="CRED_PROTECTION_TYPE"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszProtectedCredentials", "pProtectionType"]),
        # 
        'CredIsProtectedA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="CRED_PROTECTION_TYPE"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszProtectedCredentials", "pProtectionType"]),
        # 
        'CredFindBestCredentialW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"Flags": SimTypeInt(signed=False, label="CRED_FLAGS"), "Type": SimTypeInt(signed=False, label="CRED_TYPE"), "TargetName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Comment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "LastWritten": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "CredentialBlobSize": SimTypeInt(signed=False, label="UInt32"), "CredentialBlob": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Persist": SimTypeInt(signed=False, label="CRED_PERSIST"), "AttributeCount": SimTypeInt(signed=False, label="UInt32"), "Attributes": SimTypePointer(SimStruct({"Keyword": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Flags": SimTypeInt(signed=False, label="UInt32"), "ValueSize": SimTypeInt(signed=False, label="UInt32"), "Value": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CREDENTIAL_ATTRIBUTEW", pack=False, align=None), offset=0), "TargetAlias": SimTypePointer(SimTypeChar(label="Char"), offset=0), "UserName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="CREDENTIALW", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["TargetName", "Type", "Flags", "Credential"]),
        # 
        'CredFindBestCredentialA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"Flags": SimTypeInt(signed=False, label="CRED_FLAGS"), "Type": SimTypeInt(signed=False, label="CRED_TYPE"), "TargetName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Comment": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "LastWritten": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "CredentialBlobSize": SimTypeInt(signed=False, label="UInt32"), "CredentialBlob": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Persist": SimTypeInt(signed=False, label="CRED_PERSIST"), "AttributeCount": SimTypeInt(signed=False, label="UInt32"), "Attributes": SimTypePointer(SimStruct({"Keyword": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Flags": SimTypeInt(signed=False, label="UInt32"), "ValueSize": SimTypeInt(signed=False, label="UInt32"), "Value": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CREDENTIAL_ATTRIBUTEA", pack=False, align=None), offset=0), "TargetAlias": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "UserName": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CREDENTIALA", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["TargetName", "Type", "Flags", "Credential"]),
        # 
        'CredGetSessionTypes': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), label="LPArray", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["MaximumPersistCount", "MaximumPersist"]),
        # 
        'CredFree': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["Buffer"]),
        # 
        'CryptAcquireContextA': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["phProv", "szContainer", "szProvider", "dwProvType", "dwFlags"]),
        # 
        'CryptAcquireContextW': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["phProv", "szContainer", "szProvider", "dwProvType", "dwFlags"]),
        # 
        'CryptReleaseContext': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hProv", "dwFlags"]),
        # 
        'CryptGenKey': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="CRYPT_KEY_FLAGS"), SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProv", "Algid", "dwFlags", "phKey"]),
        # 
        'CryptDeriveKey': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProv", "Algid", "hBaseData", "dwFlags", "phKey"]),
        # 
        'CryptDestroyKey': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey"]),
        # 
        'CryptSetKeyParam': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="CRYPT_KEY_PARAM_ID"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "dwParam", "pbData", "dwFlags"]),
        # 
        'CryptGetKeyParam': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="CRYPT_KEY_PARAM_ID"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "dwParam", "pbData", "pdwDataLen", "dwFlags"]),
        # 
        'CryptSetHashParam': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="CRYPT_SET_HASH_PARAM"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hHash", "dwParam", "pbData", "dwFlags"]),
        # 
        'CryptGetHashParam': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hHash", "dwParam", "pbData", "pdwDataLen", "dwFlags"]),
        # 
        'CryptSetProvParam': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="CRYPT_SET_PROV_PARAM_ID"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hProv", "dwParam", "pbData", "dwFlags"]),
        # 
        'CryptGetProvParam': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hProv", "dwParam", "pbData", "pdwDataLen", "dwFlags"]),
        # 
        'CryptGenRandom': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProv", "dwLen", "pbBuffer"]),
        # 
        'CryptGetUserKey': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProv", "dwKeySpec", "phUserKey"]),
        # 
        'CryptExportKey': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="CRYPT_KEY_FLAGS"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "hExpKey", "dwBlobType", "dwFlags", "pbData", "pdwDataLen"]),
        # 
        'CryptImportKey': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="CRYPT_KEY_FLAGS"), SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProv", "pbData", "dwDataLen", "hPubKey", "dwFlags", "phKey"]),
        # 
        'CryptEncrypt': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "hHash", "Final", "dwFlags", "pbData", "pdwDataLen", "dwBufLen"]),
        # 
        'CryptDecrypt': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "hHash", "Final", "dwFlags", "pbData", "pdwDataLen"]),
        # 
        'CryptCreateHash': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProv", "Algid", "hKey", "dwFlags", "phHash"]),
        # 
        'CryptHashData': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hHash", "pbData", "dwDataLen", "dwFlags"]),
        # 
        'CryptHashSessionKey': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hHash", "hKey", "dwFlags"]),
        # 
        'CryptDestroyHash': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hHash"]),
        # 
        'CryptSignHashA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hHash", "dwKeySpec", "szDescription", "dwFlags", "pbSignature", "pdwSigLen"]),
        # 
        'CryptSignHashW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hHash", "dwKeySpec", "szDescription", "dwFlags", "pbSignature", "pdwSigLen"]),
        # 
        'CryptVerifySignatureA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hHash", "pbSignature", "dwSigLen", "hPubKey", "szDescription", "dwFlags"]),
        # 
        'CryptVerifySignatureW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hHash", "pbSignature", "dwSigLen", "hPubKey", "szDescription", "dwFlags"]),
        # 
        'CryptSetProviderA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pszProvName", "dwProvType"]),
        # 
        'CryptSetProviderW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pszProvName", "dwProvType"]),
        # 
        'CryptSetProviderExA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pszProvName", "dwProvType", "pdwReserved", "dwFlags"]),
        # 
        'CryptSetProviderExW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pszProvName", "dwProvType", "pdwReserved", "dwFlags"]),
        # 
        'CryptGetDefaultProviderA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwProvType", "pdwReserved", "dwFlags", "pszProvName", "pcbProvName"]),
        # 
        'CryptGetDefaultProviderW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwProvType", "pdwReserved", "dwFlags", "pszProvName", "pcbProvName"]),
        # 
        'CryptEnumProviderTypesA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwIndex", "pdwReserved", "dwFlags", "pdwProvType", "szTypeName", "pcbTypeName"]),
        # 
        'CryptEnumProviderTypesW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwIndex", "pdwReserved", "dwFlags", "pdwProvType", "szTypeName", "pcbTypeName"]),
        # 
        'CryptEnumProvidersA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwIndex", "pdwReserved", "dwFlags", "pdwProvType", "szProvName", "pcbProvName"]),
        # 
        'CryptEnumProvidersW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwIndex", "pdwReserved", "dwFlags", "pdwProvType", "szProvName", "pcbProvName"]),
        # 
        'CryptContextAddRef': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hProv", "pdwReserved", "dwFlags"]),
        # 
        'CryptDuplicateKey': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "pdwReserved", "dwFlags", "phKey"]),
        # 
        'CryptDuplicateHash': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hHash", "pdwReserved", "dwFlags", "phHash"]),
        # 
        'AccessCheck': SimTypeFunction([SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"GenericRead": SimTypeInt(signed=False, label="UInt32"), "GenericWrite": SimTypeInt(signed=False, label="UInt32"), "GenericExecute": SimTypeInt(signed=False, label="UInt32"), "GenericAll": SimTypeInt(signed=False, label="UInt32")}, name="GENERIC_MAPPING", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"PrivilegeCount": SimTypeInt(signed=False, label="UInt32"), "Control": SimTypeInt(signed=False, label="UInt32"), "Privilege": SimTypePointer(SimStruct({"Luid": SimTypeBottom(label="LUID"), "Attributes": SimTypeInt(signed=False, label="TOKEN_PRIVILEGES_ATTRIBUTES")}, name="LUID_AND_ATTRIBUTES", pack=False, align=None), offset=0)}, name="PRIVILEGE_SET", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pSecurityDescriptor", "ClientToken", "DesiredAccess", "GenericMapping", "PrivilegeSet", "PrivilegeSetLength", "GrantedAccess", "AccessStatus"]),
        # 
        'AccessCheckAndAuditAlarmW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"GenericRead": SimTypeInt(signed=False, label="UInt32"), "GenericWrite": SimTypeInt(signed=False, label="UInt32"), "GenericExecute": SimTypeInt(signed=False, label="UInt32"), "GenericAll": SimTypeInt(signed=False, label="UInt32")}, name="GENERIC_MAPPING", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["SubsystemName", "HandleId", "ObjectTypeName", "ObjectName", "SecurityDescriptor", "DesiredAccess", "GenericMapping", "ObjectCreation", "GrantedAccess", "AccessStatus", "pfGenerateOnClose"]),
        # 
        'AccessCheckByType': SimTypeFunction([SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Level": SimTypeShort(signed=False, label="UInt16"), "Sbz": SimTypeShort(signed=False, label="UInt16"), "ObjectType": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="OBJECT_TYPE_LIST", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"GenericRead": SimTypeInt(signed=False, label="UInt32"), "GenericWrite": SimTypeInt(signed=False, label="UInt32"), "GenericExecute": SimTypeInt(signed=False, label="UInt32"), "GenericAll": SimTypeInt(signed=False, label="UInt32")}, name="GENERIC_MAPPING", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"PrivilegeCount": SimTypeInt(signed=False, label="UInt32"), "Control": SimTypeInt(signed=False, label="UInt32"), "Privilege": SimTypePointer(SimStruct({"Luid": SimTypeBottom(label="LUID"), "Attributes": SimTypeInt(signed=False, label="TOKEN_PRIVILEGES_ATTRIBUTES")}, name="LUID_AND_ATTRIBUTES", pack=False, align=None), offset=0)}, name="PRIVILEGE_SET", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pSecurityDescriptor", "PrincipalSelfSid", "ClientToken", "DesiredAccess", "ObjectTypeList", "ObjectTypeListLength", "GenericMapping", "PrivilegeSet", "PrivilegeSetLength", "GrantedAccess", "AccessStatus"]),
        # 
        'AccessCheckByTypeResultList': SimTypeFunction([SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Level": SimTypeShort(signed=False, label="UInt16"), "Sbz": SimTypeShort(signed=False, label="UInt16"), "ObjectType": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="OBJECT_TYPE_LIST", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"GenericRead": SimTypeInt(signed=False, label="UInt32"), "GenericWrite": SimTypeInt(signed=False, label="UInt32"), "GenericExecute": SimTypeInt(signed=False, label="UInt32"), "GenericAll": SimTypeInt(signed=False, label="UInt32")}, name="GENERIC_MAPPING", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"PrivilegeCount": SimTypeInt(signed=False, label="UInt32"), "Control": SimTypeInt(signed=False, label="UInt32"), "Privilege": SimTypePointer(SimStruct({"Luid": SimTypeBottom(label="LUID"), "Attributes": SimTypeInt(signed=False, label="TOKEN_PRIVILEGES_ATTRIBUTES")}, name="LUID_AND_ATTRIBUTES", pack=False, align=None), offset=0)}, name="PRIVILEGE_SET", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), label="LPArray", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pSecurityDescriptor", "PrincipalSelfSid", "ClientToken", "DesiredAccess", "ObjectTypeList", "ObjectTypeListLength", "GenericMapping", "PrivilegeSet", "PrivilegeSetLength", "GrantedAccessList", "AccessStatusList"]),
        # 
        'AccessCheckByTypeAndAuditAlarmW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="AUDIT_EVENT_TYPE"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Level": SimTypeShort(signed=False, label="UInt16"), "Sbz": SimTypeShort(signed=False, label="UInt16"), "ObjectType": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="OBJECT_TYPE_LIST", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"GenericRead": SimTypeInt(signed=False, label="UInt32"), "GenericWrite": SimTypeInt(signed=False, label="UInt32"), "GenericExecute": SimTypeInt(signed=False, label="UInt32"), "GenericAll": SimTypeInt(signed=False, label="UInt32")}, name="GENERIC_MAPPING", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["SubsystemName", "HandleId", "ObjectTypeName", "ObjectName", "SecurityDescriptor", "PrincipalSelfSid", "DesiredAccess", "AuditType", "Flags", "ObjectTypeList", "ObjectTypeListLength", "GenericMapping", "ObjectCreation", "GrantedAccess", "AccessStatus", "pfGenerateOnClose"]),
        # 
        'AccessCheckByTypeResultListAndAuditAlarmW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="AUDIT_EVENT_TYPE"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Level": SimTypeShort(signed=False, label="UInt16"), "Sbz": SimTypeShort(signed=False, label="UInt16"), "ObjectType": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="OBJECT_TYPE_LIST", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"GenericRead": SimTypeInt(signed=False, label="UInt32"), "GenericWrite": SimTypeInt(signed=False, label="UInt32"), "GenericExecute": SimTypeInt(signed=False, label="UInt32"), "GenericAll": SimTypeInt(signed=False, label="UInt32")}, name="GENERIC_MAPPING", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["SubsystemName", "HandleId", "ObjectTypeName", "ObjectName", "SecurityDescriptor", "PrincipalSelfSid", "DesiredAccess", "AuditType", "Flags", "ObjectTypeList", "ObjectTypeListLength", "GenericMapping", "ObjectCreation", "GrantedAccessList", "AccessStatusList", "pfGenerateOnClose"]),
        # 
        'AccessCheckByTypeResultListAndAuditAlarmByHandleW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="AUDIT_EVENT_TYPE"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Level": SimTypeShort(signed=False, label="UInt16"), "Sbz": SimTypeShort(signed=False, label="UInt16"), "ObjectType": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="OBJECT_TYPE_LIST", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"GenericRead": SimTypeInt(signed=False, label="UInt32"), "GenericWrite": SimTypeInt(signed=False, label="UInt32"), "GenericExecute": SimTypeInt(signed=False, label="UInt32"), "GenericAll": SimTypeInt(signed=False, label="UInt32")}, name="GENERIC_MAPPING", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["SubsystemName", "HandleId", "ClientToken", "ObjectTypeName", "ObjectName", "SecurityDescriptor", "PrincipalSelfSid", "DesiredAccess", "AuditType", "Flags", "ObjectTypeList", "ObjectTypeListLength", "GenericMapping", "ObjectCreation", "GrantedAccessList", "AccessStatusList", "pfGenerateOnClose"]),
        # 
        'AddAccessAllowedAce': SimTypeFunction([SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pAcl", "dwAceRevision", "AccessMask", "pSid"]),
        # 
        'AddAccessAllowedAceEx': SimTypeFunction([SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="ACE_FLAGS"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pAcl", "dwAceRevision", "AceFlags", "AccessMask", "pSid"]),
        # 
        'AddAccessAllowedObjectAce': SimTypeFunction([SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="ACE_FLAGS"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pAcl", "dwAceRevision", "AceFlags", "AccessMask", "ObjectTypeGuid", "InheritedObjectTypeGuid", "pSid"]),
        # 
        'AddAccessDeniedAce': SimTypeFunction([SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pAcl", "dwAceRevision", "AccessMask", "pSid"]),
        # 
        'AddAccessDeniedAceEx': SimTypeFunction([SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="ACE_FLAGS"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pAcl", "dwAceRevision", "AceFlags", "AccessMask", "pSid"]),
        # 
        'AddAccessDeniedObjectAce': SimTypeFunction([SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="ACE_FLAGS"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pAcl", "dwAceRevision", "AceFlags", "AccessMask", "ObjectTypeGuid", "InheritedObjectTypeGuid", "pSid"]),
        # 
        'AddAce': SimTypeFunction([SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pAcl", "dwAceRevision", "dwStartingAceIndex", "pAceList", "nAceListLength"]),
        # 
        'AddAuditAccessAce': SimTypeFunction([SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pAcl", "dwAceRevision", "dwAccessMask", "pSid", "bAuditSuccess", "bAuditFailure"]),
        # 
        'AddAuditAccessAceEx': SimTypeFunction([SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="ACE_FLAGS"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pAcl", "dwAceRevision", "AceFlags", "dwAccessMask", "pSid", "bAuditSuccess", "bAuditFailure"]),
        # 
        'AddAuditAccessObjectAce': SimTypeFunction([SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="ACE_FLAGS"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pAcl", "dwAceRevision", "AceFlags", "AccessMask", "ObjectTypeGuid", "InheritedObjectTypeGuid", "pSid", "bAuditSuccess", "bAuditFailure"]),
        # 
        'AddMandatoryAce': SimTypeFunction([SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="ACE_REVISION"), SimTypeInt(signed=False, label="ACE_FLAGS"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pAcl", "dwAceRevision", "AceFlags", "MandatoryPolicy", "pLabelSid"]),
        # 
        'AdjustTokenGroups': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimStruct({"GroupCount": SimTypeInt(signed=False, label="UInt32"), "Groups": SimTypePointer(SimStruct({"Sid": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Attributes": SimTypeInt(signed=False, label="UInt32")}, name="SID_AND_ATTRIBUTES", pack=False, align=None), offset=0)}, name="TOKEN_GROUPS", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"GroupCount": SimTypeInt(signed=False, label="UInt32"), "Groups": SimTypePointer(SimStruct({"Sid": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Attributes": SimTypeInt(signed=False, label="UInt32")}, name="SID_AND_ATTRIBUTES", pack=False, align=None), offset=0)}, name="TOKEN_GROUPS", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["TokenHandle", "ResetToDefault", "NewState", "BufferLength", "PreviousState", "ReturnLength"]),
        # 
        'AdjustTokenPrivileges': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimStruct({"PrivilegeCount": SimTypeInt(signed=False, label="UInt32"), "Privileges": SimTypePointer(SimStruct({"Luid": SimTypeBottom(label="LUID"), "Attributes": SimTypeInt(signed=False, label="TOKEN_PRIVILEGES_ATTRIBUTES")}, name="LUID_AND_ATTRIBUTES", pack=False, align=None), offset=0)}, name="TOKEN_PRIVILEGES", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"PrivilegeCount": SimTypeInt(signed=False, label="UInt32"), "Privileges": SimTypePointer(SimStruct({"Luid": SimTypeBottom(label="LUID"), "Attributes": SimTypeInt(signed=False, label="TOKEN_PRIVILEGES_ATTRIBUTES")}, name="LUID_AND_ATTRIBUTES", pack=False, align=None), offset=0)}, name="TOKEN_PRIVILEGES", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["TokenHandle", "DisableAllPrivileges", "NewState", "BufferLength", "PreviousState", "ReturnLength"]),
        # 
        'AllocateAndInitializeSid': SimTypeFunction([SimTypePointer(SimStruct({"Value": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 6)}, name="SID_IDENTIFIER_AUTHORITY", pack=False, align=None), offset=0), SimTypeChar(label="Byte"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pIdentifierAuthority", "nSubAuthorityCount", "nSubAuthority0", "nSubAuthority1", "nSubAuthority2", "nSubAuthority3", "nSubAuthority4", "nSubAuthority5", "nSubAuthority6", "nSubAuthority7", "pSid"]),
        # 
        'AllocateLocallyUniqueId': SimTypeFunction([SimTypePointer(SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=True, label="Int32")}, name="LUID", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Luid"]),
        # 
        'AreAllAccessesGranted': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["GrantedAccess", "DesiredAccess"]),
        # 
        'AreAnyAccessesGranted': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["GrantedAccess", "DesiredAccess"]),
        # 
        'CheckTokenMembership': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["TokenHandle", "SidToCheck", "IsMember"]),
        # 
        'ConvertToAutoInheritPrivateObjectSecurity': SimTypeFunction([SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeChar(label="Byte"), SimTypePointer(SimStruct({"GenericRead": SimTypeInt(signed=False, label="UInt32"), "GenericWrite": SimTypeInt(signed=False, label="UInt32"), "GenericExecute": SimTypeInt(signed=False, label="UInt32"), "GenericAll": SimTypeInt(signed=False, label="UInt32")}, name="GENERIC_MAPPING", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ParentDescriptor", "CurrentSecurityDescriptor", "NewSecurityDescriptor", "ObjectType", "IsDirectoryObject", "GenericMapping"]),
        # 
        'CopySid': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["nDestinationSidLength", "pDestinationSid", "pSourceSid"]),
        # 
        'CreatePrivateObjectSecurity': SimTypeFunction([SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"GenericRead": SimTypeInt(signed=False, label="UInt32"), "GenericWrite": SimTypeInt(signed=False, label="UInt32"), "GenericExecute": SimTypeInt(signed=False, label="UInt32"), "GenericAll": SimTypeInt(signed=False, label="UInt32")}, name="GENERIC_MAPPING", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ParentDescriptor", "CreatorDescriptor", "NewDescriptor", "IsDirectoryObject", "Token", "GenericMapping"]),
        # 
        'CreatePrivateObjectSecurityEx': SimTypeFunction([SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="SECURITY_AUTO_INHERIT_FLAGS"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"GenericRead": SimTypeInt(signed=False, label="UInt32"), "GenericWrite": SimTypeInt(signed=False, label="UInt32"), "GenericExecute": SimTypeInt(signed=False, label="UInt32"), "GenericAll": SimTypeInt(signed=False, label="UInt32")}, name="GENERIC_MAPPING", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ParentDescriptor", "CreatorDescriptor", "NewDescriptor", "ObjectType", "IsContainerObject", "AutoInheritFlags", "Token", "GenericMapping"]),
        # 
        'CreatePrivateObjectSecurityWithMultipleInheritance': SimTypeFunction([SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Guid"), offset=0), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="SECURITY_AUTO_INHERIT_FLAGS"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"GenericRead": SimTypeInt(signed=False, label="UInt32"), "GenericWrite": SimTypeInt(signed=False, label="UInt32"), "GenericExecute": SimTypeInt(signed=False, label="UInt32"), "GenericAll": SimTypeInt(signed=False, label="UInt32")}, name="GENERIC_MAPPING", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ParentDescriptor", "CreatorDescriptor", "NewDescriptor", "ObjectTypes", "GuidCount", "IsContainerObject", "AutoInheritFlags", "Token", "GenericMapping"]),
        # 
        'CreateRestrictedToken': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="CREATE_RESTRICTED_TOKEN_FLAGS"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Sid": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Attributes": SimTypeInt(signed=False, label="UInt32")}, name="SID_AND_ATTRIBUTES", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Luid": SimTypeBottom(label="LUID"), "Attributes": SimTypeInt(signed=False, label="TOKEN_PRIVILEGES_ATTRIBUTES")}, name="LUID_AND_ATTRIBUTES", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Sid": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Attributes": SimTypeInt(signed=False, label="UInt32")}, name="SID_AND_ATTRIBUTES", pack=False, align=None), label="LPArray", offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ExistingTokenHandle", "Flags", "DisableSidCount", "SidsToDisable", "DeletePrivilegeCount", "PrivilegesToDelete", "RestrictedSidCount", "SidsToRestrict", "NewTokenHandle"]),
        # 
        'CreateWellKnownSid': SimTypeFunction([SimTypeInt(signed=False, label="WELL_KNOWN_SID_TYPE"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["WellKnownSidType", "DomainSid", "pSid", "cbSid"]),
        # 
        'EqualDomainSid': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pSid1", "pSid2", "pfEqual"]),
        # 
        'DeleteAce': SimTypeFunction([SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pAcl", "dwAceIndex"]),
        # 
        'DestroyPrivateObjectSecurity': SimTypeFunction([SimTypePointer(SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ObjectDescriptor"]),
        # 
        'DuplicateToken': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="SECURITY_IMPERSONATION_LEVEL"), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ExistingTokenHandle", "ImpersonationLevel", "DuplicateTokenHandle"]),
        # 
        'DuplicateTokenEx': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="TOKEN_ACCESS_MASK"), SimTypePointer(SimStruct({"nLength": SimTypeInt(signed=False, label="UInt32"), "lpSecurityDescriptor": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "bInheritHandle": SimTypeInt(signed=True, label="Int32")}, name="SECURITY_ATTRIBUTES", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="SECURITY_IMPERSONATION_LEVEL"), SimTypeInt(signed=False, label="TOKEN_TYPE"), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hExistingToken", "dwDesiredAccess", "lpTokenAttributes", "ImpersonationLevel", "TokenType", "phNewToken"]),
        # 
        'EqualPrefixSid': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pSid1", "pSid2"]),
        # 
        'EqualSid': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pSid1", "pSid2"]),
        # 
        'FindFirstFreeAce': SimTypeFunction([SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pAcl", "pAce"]),
        # 
        'FreeSid': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["pSid"]),
        # 
        'GetAce': SimTypeFunction([SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pAcl", "dwAceIndex", "pAce"]),
        # 
        'GetAclInformation': SimTypeFunction([SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="ACL_INFORMATION_CLASS")], SimTypeInt(signed=True, label="Int32"), arg_names=["pAcl", "pAclInformation", "nAclInformationLength", "dwAclInformationClass"]),
        # 
        'GetFileSecurityW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpFileName", "RequestedInformation", "pSecurityDescriptor", "nLength", "lpnLengthNeeded"]),
        # 
        'GetKernelObjectSecurity': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Handle", "RequestedInformation", "pSecurityDescriptor", "nLength", "lpnLengthNeeded"]),
        # 
        'GetLengthSid': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pSid"]),
        # 
        'GetPrivateObjectSecurity': SimTypeFunction([SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ObjectDescriptor", "SecurityInformation", "ResultantDescriptor", "DescriptorLength", "ReturnLength"]),
        # 
        'GetSecurityDescriptorControl': SimTypeFunction([SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pSecurityDescriptor", "pControl", "lpdwRevision"]),
        # 
        'GetSecurityDescriptorDacl': SimTypeFunction([SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pSecurityDescriptor", "lpbDaclPresent", "pDacl", "lpbDaclDefaulted"]),
        # 
        'GetSecurityDescriptorGroup': SimTypeFunction([SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pSecurityDescriptor", "pGroup", "lpbGroupDefaulted"]),
        # 
        'GetSecurityDescriptorLength': SimTypeFunction([SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pSecurityDescriptor"]),
        # 
        'GetSecurityDescriptorOwner': SimTypeFunction([SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pSecurityDescriptor", "pOwner", "lpbOwnerDefaulted"]),
        # 
        'GetSecurityDescriptorRMControl': SimTypeFunction([SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["SecurityDescriptor", "RMControl"]),
        # 
        'GetSecurityDescriptorSacl': SimTypeFunction([SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pSecurityDescriptor", "lpbSaclPresent", "pSacl", "lpbSaclDefaulted"]),
        # 
        'GetSidIdentifierAuthority': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimStruct({"Value": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 6)}, name="SID_IDENTIFIER_AUTHORITY", pack=False, align=None), offset=0), arg_names=["pSid"]),
        # 
        'GetSidLengthRequired': SimTypeFunction([SimTypeChar(label="Byte")], SimTypeInt(signed=False, label="UInt32"), arg_names=["nSubAuthorityCount"]),
        # 
        'GetSidSubAuthority': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), arg_names=["pSid", "nSubAuthority"]),
        # 
        'GetSidSubAuthorityCount': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeChar(label="Byte"), offset=0), arg_names=["pSid"]),
        # 
        'GetTokenInformation': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="TOKEN_INFORMATION_CLASS"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["TokenHandle", "TokenInformationClass", "TokenInformation", "TokenInformationLength", "ReturnLength"]),
        # 
        'GetWindowsAccountDomainSid': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pSid", "pDomainSid", "cbDomainSid"]),
        # 
        'ImpersonateAnonymousToken': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ThreadHandle"]),
        # 
        'ImpersonateLoggedOnUser': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hToken"]),
        # 
        'ImpersonateSelf': SimTypeFunction([SimTypeInt(signed=False, label="SECURITY_IMPERSONATION_LEVEL")], SimTypeInt(signed=True, label="Int32"), arg_names=["ImpersonationLevel"]),
        # 
        'InitializeAcl': SimTypeFunction([SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pAcl", "nAclLength", "dwAclRevision"]),
        # 
        'InitializeSecurityDescriptor': SimTypeFunction([SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pSecurityDescriptor", "dwRevision"]),
        # 
        'InitializeSid': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"Value": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 6)}, name="SID_IDENTIFIER_AUTHORITY", pack=False, align=None), offset=0), SimTypeChar(label="Byte")], SimTypeInt(signed=True, label="Int32"), arg_names=["Sid", "pIdentifierAuthority", "nSubAuthorityCount"]),
        # 
        'IsTokenRestricted': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["TokenHandle"]),
        # 
        'IsValidAcl': SimTypeFunction([SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pAcl"]),
        # 
        'IsValidSecurityDescriptor': SimTypeFunction([SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pSecurityDescriptor"]),
        # 
        'IsValidSid': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pSid"]),
        # 
        'IsWellKnownSid': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="WELL_KNOWN_SID_TYPE")], SimTypeInt(signed=True, label="Int32"), arg_names=["pSid", "WellKnownSidType"]),
        # 
        'MakeAbsoluteSD': SimTypeFunction([SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pSelfRelativeSecurityDescriptor", "pAbsoluteSecurityDescriptor", "lpdwAbsoluteSecurityDescriptorSize", "pDacl", "lpdwDaclSize", "pSacl", "lpdwSaclSize", "pOwner", "lpdwOwnerSize", "pPrimaryGroup", "lpdwPrimaryGroupSize"]),
        # 
        'MakeSelfRelativeSD': SimTypeFunction([SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pAbsoluteSecurityDescriptor", "pSelfRelativeSecurityDescriptor", "lpdwBufferLength"]),
        # 
        'MapGenericMask': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"GenericRead": SimTypeInt(signed=False, label="UInt32"), "GenericWrite": SimTypeInt(signed=False, label="UInt32"), "GenericExecute": SimTypeInt(signed=False, label="UInt32"), "GenericAll": SimTypeInt(signed=False, label="UInt32")}, name="GENERIC_MAPPING", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["AccessMask", "GenericMapping"]),
        # 
        'ObjectCloseAuditAlarmW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["SubsystemName", "HandleId", "GenerateOnClose"]),
        # 
        'ObjectDeleteAuditAlarmW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["SubsystemName", "HandleId", "GenerateOnClose"]),
        # 
        'ObjectOpenAuditAlarmW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"PrivilegeCount": SimTypeInt(signed=False, label="UInt32"), "Control": SimTypeInt(signed=False, label="UInt32"), "Privilege": SimTypePointer(SimStruct({"Luid": SimTypeBottom(label="LUID"), "Attributes": SimTypeInt(signed=False, label="TOKEN_PRIVILEGES_ATTRIBUTES")}, name="LUID_AND_ATTRIBUTES", pack=False, align=None), offset=0)}, name="PRIVILEGE_SET", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["SubsystemName", "HandleId", "ObjectTypeName", "ObjectName", "pSecurityDescriptor", "ClientToken", "DesiredAccess", "GrantedAccess", "Privileges", "ObjectCreation", "AccessGranted", "GenerateOnClose"]),
        # 
        'ObjectPrivilegeAuditAlarmW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"PrivilegeCount": SimTypeInt(signed=False, label="UInt32"), "Control": SimTypeInt(signed=False, label="UInt32"), "Privilege": SimTypePointer(SimStruct({"Luid": SimTypeBottom(label="LUID"), "Attributes": SimTypeInt(signed=False, label="TOKEN_PRIVILEGES_ATTRIBUTES")}, name="LUID_AND_ATTRIBUTES", pack=False, align=None), offset=0)}, name="PRIVILEGE_SET", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["SubsystemName", "HandleId", "ClientToken", "DesiredAccess", "Privileges", "AccessGranted"]),
        # 
        'PrivilegeCheck': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"PrivilegeCount": SimTypeInt(signed=False, label="UInt32"), "Control": SimTypeInt(signed=False, label="UInt32"), "Privilege": SimTypePointer(SimStruct({"Luid": SimTypeBottom(label="LUID"), "Attributes": SimTypeInt(signed=False, label="TOKEN_PRIVILEGES_ATTRIBUTES")}, name="LUID_AND_ATTRIBUTES", pack=False, align=None), offset=0)}, name="PRIVILEGE_SET", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ClientToken", "RequiredPrivileges", "pfResult"]),
        # 
        'PrivilegedServiceAuditAlarmW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"PrivilegeCount": SimTypeInt(signed=False, label="UInt32"), "Control": SimTypeInt(signed=False, label="UInt32"), "Privilege": SimTypePointer(SimStruct({"Luid": SimTypeBottom(label="LUID"), "Attributes": SimTypeInt(signed=False, label="TOKEN_PRIVILEGES_ATTRIBUTES")}, name="LUID_AND_ATTRIBUTES", pack=False, align=None), offset=0)}, name="PRIVILEGE_SET", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["SubsystemName", "ServiceName", "ClientToken", "Privileges", "AccessGranted"]),
        # 
        'QuerySecurityAccessMask': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeBottom(label="Void"), arg_names=["SecurityInformation", "DesiredAccess"]),
        # 
        'RevertToSelf': SimTypeFunction([], SimTypeInt(signed=True, label="Int32")),
        # 
        'SetAclInformation': SimTypeFunction([SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="ACL_INFORMATION_CLASS")], SimTypeInt(signed=True, label="Int32"), arg_names=["pAcl", "pAclInformation", "nAclInformationLength", "dwAclInformationClass"]),
        # 
        'SetFileSecurityW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpFileName", "SecurityInformation", "pSecurityDescriptor"]),
        # 
        'SetKernelObjectSecurity': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Handle", "SecurityInformation", "SecurityDescriptor"]),
        # 
        'SetPrivateObjectSecurity': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimStruct({"GenericRead": SimTypeInt(signed=False, label="UInt32"), "GenericWrite": SimTypeInt(signed=False, label="UInt32"), "GenericExecute": SimTypeInt(signed=False, label="UInt32"), "GenericAll": SimTypeInt(signed=False, label="UInt32")}, name="GENERIC_MAPPING", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["SecurityInformation", "ModificationDescriptor", "ObjectsSecurityDescriptor", "GenericMapping", "Token"]),
        # 
        'SetPrivateObjectSecurityEx': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), offset=0), SimTypeInt(signed=False, label="SECURITY_AUTO_INHERIT_FLAGS"), SimTypePointer(SimStruct({"GenericRead": SimTypeInt(signed=False, label="UInt32"), "GenericWrite": SimTypeInt(signed=False, label="UInt32"), "GenericExecute": SimTypeInt(signed=False, label="UInt32"), "GenericAll": SimTypeInt(signed=False, label="UInt32")}, name="GENERIC_MAPPING", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["SecurityInformation", "ModificationDescriptor", "ObjectsSecurityDescriptor", "AutoInheritFlags", "GenericMapping", "Token"]),
        # 
        'SetSecurityAccessMask': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeBottom(label="Void"), arg_names=["SecurityInformation", "DesiredAccess"]),
        # 
        'SetSecurityDescriptorControl': SimTypeFunction([SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypeShort(signed=False, label="UInt16")], SimTypeInt(signed=True, label="Int32"), arg_names=["pSecurityDescriptor", "ControlBitsOfInterest", "ControlBitsToSet"]),
        # 
        'SetSecurityDescriptorDacl': SimTypeFunction([SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pSecurityDescriptor", "bDaclPresent", "pDacl", "bDaclDefaulted"]),
        # 
        'SetSecurityDescriptorGroup': SimTypeFunction([SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pSecurityDescriptor", "pGroup", "bGroupDefaulted"]),
        # 
        'SetSecurityDescriptorOwner': SimTypeFunction([SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pSecurityDescriptor", "pOwner", "bOwnerDefaulted"]),
        # 
        'SetSecurityDescriptorRMControl': SimTypeFunction([SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["SecurityDescriptor", "RMControl"]),
        # 
        'SetSecurityDescriptorSacl': SimTypeFunction([SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pSecurityDescriptor", "bSaclPresent", "pSacl", "bSaclDefaulted"]),
        # 
        'SetTokenInformation': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="TOKEN_INFORMATION_CLASS"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["TokenHandle", "TokenInformationClass", "TokenInformation", "TokenInformationLength"]),
        # 
        'SaferGetPolicyInformation': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="SAFER_POLICY_INFO_CLASS"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwScopeId", "SaferPolicyInfoClass", "InfoBufferSize", "InfoBuffer", "InfoBufferRetSize", "lpReserved"]),
        # 
        'SaferSetPolicyInformation': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="SAFER_POLICY_INFO_CLASS"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwScopeId", "SaferPolicyInfoClass", "InfoBufferSize", "InfoBuffer", "lpReserved"]),
        # 
        'SaferCreateLevel': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwScopeId", "dwLevelId", "OpenFlags", "pLevelHandle", "lpReserved"]),
        # 
        'SaferCloseLevel': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLevelHandle"]),
        # 
        'SaferIdentifyLevel': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "dwCheckFlags": SimTypeInt(signed=False, label="UInt32"), "ImagePath": SimTypePointer(SimTypeChar(label="Char"), offset=0), "hImageFileHandle": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "UrlZoneId": SimTypeInt(signed=False, label="UInt32"), "ImageHash": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 64), "dwImageHashSize": SimTypeInt(signed=False, label="UInt32"), "ImageSize": SimTypeBottom(label="LARGE_INTEGER"), "HashAlgorithm": SimTypeInt(signed=False, label="UInt32"), "pByteBlock": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "hWndParent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "dwWVTUIChoice": SimTypeInt(signed=False, label="UInt32"), "PackageMoniker": SimTypePointer(SimTypeChar(label="Char"), offset=0), "PackagePublisher": SimTypePointer(SimTypeChar(label="Char"), offset=0), "PackageName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "PackageVersion": SimTypeLongLong(signed=False, label="UInt64"), "PackageIsFramework": SimTypeInt(signed=True, label="Int32")}, name="SAFER_CODE_PROPERTIES_V2", pack=False, align=None), label="LPArray", offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwNumProperties", "pCodeProperties", "pLevelHandle", "lpReserved"]),
        # 
        'SaferComputeTokenFromLevel': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypeInt(signed=False, label="SAFER_COMPUTE_TOKEN_FROM_LEVEL_FLAGS"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["LevelHandle", "InAccessToken", "OutAccessToken", "dwFlags", "lpReserved"]),
        # 
        'SaferGetLevelInformation': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="SAFER_OBJECT_INFO_CLASS"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["LevelHandle", "dwInfoType", "lpQueryBuffer", "dwInBufferSize", "lpdwOutBufferSize"]),
        # 
        'SaferSetLevelInformation': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="SAFER_OBJECT_INFO_CLASS"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["LevelHandle", "dwInfoType", "lpQueryBuffer", "dwInBufferSize"]),
        # 
        'SaferRecordEventLogEntry': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLevel", "szTargetPath", "lpReserved"]),
        # 
        'SaferiIsExecutableFileType': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeChar(label="Byte")], SimTypeInt(signed=True, label="Int32"), arg_names=["szFullPathname", "bFromShellExecute"]),
        # 
        'AccessCheckAndAuditAlarmA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"GenericRead": SimTypeInt(signed=False, label="UInt32"), "GenericWrite": SimTypeInt(signed=False, label="UInt32"), "GenericExecute": SimTypeInt(signed=False, label="UInt32"), "GenericAll": SimTypeInt(signed=False, label="UInt32")}, name="GENERIC_MAPPING", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["SubsystemName", "HandleId", "ObjectTypeName", "ObjectName", "SecurityDescriptor", "DesiredAccess", "GenericMapping", "ObjectCreation", "GrantedAccess", "AccessStatus", "pfGenerateOnClose"]),
        # 
        'AccessCheckByTypeAndAuditAlarmA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="AUDIT_EVENT_TYPE"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Level": SimTypeShort(signed=False, label="UInt16"), "Sbz": SimTypeShort(signed=False, label="UInt16"), "ObjectType": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="OBJECT_TYPE_LIST", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"GenericRead": SimTypeInt(signed=False, label="UInt32"), "GenericWrite": SimTypeInt(signed=False, label="UInt32"), "GenericExecute": SimTypeInt(signed=False, label="UInt32"), "GenericAll": SimTypeInt(signed=False, label="UInt32")}, name="GENERIC_MAPPING", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["SubsystemName", "HandleId", "ObjectTypeName", "ObjectName", "SecurityDescriptor", "PrincipalSelfSid", "DesiredAccess", "AuditType", "Flags", "ObjectTypeList", "ObjectTypeListLength", "GenericMapping", "ObjectCreation", "GrantedAccess", "AccessStatus", "pfGenerateOnClose"]),
        # 
        'AccessCheckByTypeResultListAndAuditAlarmA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="AUDIT_EVENT_TYPE"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Level": SimTypeShort(signed=False, label="UInt16"), "Sbz": SimTypeShort(signed=False, label="UInt16"), "ObjectType": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="OBJECT_TYPE_LIST", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"GenericRead": SimTypeInt(signed=False, label="UInt32"), "GenericWrite": SimTypeInt(signed=False, label="UInt32"), "GenericExecute": SimTypeInt(signed=False, label="UInt32"), "GenericAll": SimTypeInt(signed=False, label="UInt32")}, name="GENERIC_MAPPING", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["SubsystemName", "HandleId", "ObjectTypeName", "ObjectName", "SecurityDescriptor", "PrincipalSelfSid", "DesiredAccess", "AuditType", "Flags", "ObjectTypeList", "ObjectTypeListLength", "GenericMapping", "ObjectCreation", "GrantedAccess", "AccessStatusList", "pfGenerateOnClose"]),
        # 
        'AccessCheckByTypeResultListAndAuditAlarmByHandleA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="AUDIT_EVENT_TYPE"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Level": SimTypeShort(signed=False, label="UInt16"), "Sbz": SimTypeShort(signed=False, label="UInt16"), "ObjectType": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="OBJECT_TYPE_LIST", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"GenericRead": SimTypeInt(signed=False, label="UInt32"), "GenericWrite": SimTypeInt(signed=False, label="UInt32"), "GenericExecute": SimTypeInt(signed=False, label="UInt32"), "GenericAll": SimTypeInt(signed=False, label="UInt32")}, name="GENERIC_MAPPING", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["SubsystemName", "HandleId", "ClientToken", "ObjectTypeName", "ObjectName", "SecurityDescriptor", "PrincipalSelfSid", "DesiredAccess", "AuditType", "Flags", "ObjectTypeList", "ObjectTypeListLength", "GenericMapping", "ObjectCreation", "GrantedAccess", "AccessStatusList", "pfGenerateOnClose"]),
        # 
        'ObjectOpenAuditAlarmA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"PrivilegeCount": SimTypeInt(signed=False, label="UInt32"), "Control": SimTypeInt(signed=False, label="UInt32"), "Privilege": SimTypePointer(SimStruct({"Luid": SimTypeBottom(label="LUID"), "Attributes": SimTypeInt(signed=False, label="TOKEN_PRIVILEGES_ATTRIBUTES")}, name="LUID_AND_ATTRIBUTES", pack=False, align=None), offset=0)}, name="PRIVILEGE_SET", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["SubsystemName", "HandleId", "ObjectTypeName", "ObjectName", "pSecurityDescriptor", "ClientToken", "DesiredAccess", "GrantedAccess", "Privileges", "ObjectCreation", "AccessGranted", "GenerateOnClose"]),
        # 
        'ObjectPrivilegeAuditAlarmA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"PrivilegeCount": SimTypeInt(signed=False, label="UInt32"), "Control": SimTypeInt(signed=False, label="UInt32"), "Privilege": SimTypePointer(SimStruct({"Luid": SimTypeBottom(label="LUID"), "Attributes": SimTypeInt(signed=False, label="TOKEN_PRIVILEGES_ATTRIBUTES")}, name="LUID_AND_ATTRIBUTES", pack=False, align=None), offset=0)}, name="PRIVILEGE_SET", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["SubsystemName", "HandleId", "ClientToken", "DesiredAccess", "Privileges", "AccessGranted"]),
        # 
        'ObjectCloseAuditAlarmA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["SubsystemName", "HandleId", "GenerateOnClose"]),
        # 
        'ObjectDeleteAuditAlarmA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["SubsystemName", "HandleId", "GenerateOnClose"]),
        # 
        'PrivilegedServiceAuditAlarmA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"PrivilegeCount": SimTypeInt(signed=False, label="UInt32"), "Control": SimTypeInt(signed=False, label="UInt32"), "Privilege": SimTypePointer(SimStruct({"Luid": SimTypeBottom(label="LUID"), "Attributes": SimTypeInt(signed=False, label="TOKEN_PRIVILEGES_ATTRIBUTES")}, name="LUID_AND_ATTRIBUTES", pack=False, align=None), offset=0)}, name="PRIVILEGE_SET", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["SubsystemName", "ServiceName", "ClientToken", "Privileges", "AccessGranted"]),
        # 
        'AddConditionalAce': SimTypeFunction([SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="ACE_FLAGS"), SimTypeChar(label="Byte"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pAcl", "dwAceRevision", "AceFlags", "AceType", "AccessMask", "pSid", "ConditionStr", "ReturnLength"]),
        # 
        'SetFileSecurityA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpFileName", "SecurityInformation", "pSecurityDescriptor"]),
        # 
        'GetFileSecurityA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpFileName", "RequestedInformation", "pSecurityDescriptor", "nLength", "lpnLengthNeeded"]),
        # 
        'LookupAccountSidA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="SID_NAME_USE"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpSystemName", "Sid", "Name", "cchName", "ReferencedDomainName", "cchReferencedDomainName", "peUse"]),
        # 
        'LookupAccountSidW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="SID_NAME_USE"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpSystemName", "Sid", "Name", "cchName", "ReferencedDomainName", "cchReferencedDomainName", "peUse"]),
        # 
        'LookupAccountNameA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="SID_NAME_USE"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpSystemName", "lpAccountName", "Sid", "cbSid", "ReferencedDomainName", "cchReferencedDomainName", "peUse"]),
        # 
        'LookupAccountNameW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="SID_NAME_USE"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpSystemName", "lpAccountName", "Sid", "cbSid", "ReferencedDomainName", "cchReferencedDomainName", "peUse"]),
        # 
        'LookupPrivilegeValueA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=True, label="Int32")}, name="LUID", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpSystemName", "lpName", "lpLuid"]),
        # 
        'LookupPrivilegeValueW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=True, label="Int32")}, name="LUID", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpSystemName", "lpName", "lpLuid"]),
        # 
        'LookupPrivilegeNameA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=True, label="Int32")}, name="LUID", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpSystemName", "lpLuid", "lpName", "cchName"]),
        # 
        'LookupPrivilegeNameW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=True, label="Int32")}, name="LUID", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpSystemName", "lpLuid", "lpName", "cchName"]),
        # 
        'LookupPrivilegeDisplayNameA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpSystemName", "lpName", "lpDisplayName", "cchDisplayName", "lpLanguageId"]),
        # 
        'LookupPrivilegeDisplayNameW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpSystemName", "lpName", "lpDisplayName", "cchDisplayName", "lpLanguageId"]),
        # 
        'LogonUserA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="LOGON32_LOGON"), SimTypeInt(signed=False, label="LOGON32_PROVIDER"), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszUsername", "lpszDomain", "lpszPassword", "dwLogonType", "dwLogonProvider", "phToken"]),
        # 
        'LogonUserW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="LOGON32_LOGON"), SimTypeInt(signed=False, label="LOGON32_PROVIDER"), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszUsername", "lpszDomain", "lpszPassword", "dwLogonType", "dwLogonProvider", "phToken"]),
        # 
        'LogonUserExA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="LOGON32_LOGON"), SimTypeInt(signed=False, label="LOGON32_PROVIDER"), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"PagedPoolLimit": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "NonPagedPoolLimit": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "MinimumWorkingSetSize": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "MaximumWorkingSetSize": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "PagefileLimit": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "TimeLimit": SimTypeBottom(label="LARGE_INTEGER")}, name="QUOTA_LIMITS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszUsername", "lpszDomain", "lpszPassword", "dwLogonType", "dwLogonProvider", "phToken", "ppLogonSid", "ppProfileBuffer", "pdwProfileLength", "pQuotaLimits"]),
        # 
        'LogonUserExW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="LOGON32_LOGON"), SimTypeInt(signed=False, label="LOGON32_PROVIDER"), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"PagedPoolLimit": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "NonPagedPoolLimit": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "MinimumWorkingSetSize": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "MaximumWorkingSetSize": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "PagefileLimit": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "TimeLimit": SimTypeBottom(label="LARGE_INTEGER")}, name="QUOTA_LIMITS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszUsername", "lpszDomain", "lpszPassword", "dwLogonType", "dwLogonProvider", "phToken", "ppLogonSid", "ppProfileBuffer", "pdwProfileLength", "pQuotaLimits"]),
        # 
        'QueryUsersOnEncryptedFile': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"nCert_Hash": SimTypeInt(signed=False, label="UInt32"), "pUsers": SimTypePointer(SimTypePointer(SimStruct({"cbTotalLength": SimTypeInt(signed=False, label="UInt32"), "pUserSid": SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "SubAuthorityCount": SimTypeChar(label="Byte"), "IdentifierAuthority": SimStruct({"Value": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 6)}, name="SID_IDENTIFIER_AUTHORITY", pack=False, align=None), "SubAuthority": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="SID", pack=False, align=None), offset=0), "pHash": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="EFS_HASH_BLOB", pack=False, align=None), offset=0), "lpDisplayInformation": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="ENCRYPTION_CERTIFICATE_HASH", pack=False, align=None), offset=0), offset=0)}, name="ENCRYPTION_CERTIFICATE_HASH_LIST", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["lpFileName", "pUsers"]),
        # 
        'QueryRecoveryAgentsOnEncryptedFile': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"nCert_Hash": SimTypeInt(signed=False, label="UInt32"), "pUsers": SimTypePointer(SimTypePointer(SimStruct({"cbTotalLength": SimTypeInt(signed=False, label="UInt32"), "pUserSid": SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "SubAuthorityCount": SimTypeChar(label="Byte"), "IdentifierAuthority": SimStruct({"Value": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 6)}, name="SID_IDENTIFIER_AUTHORITY", pack=False, align=None), "SubAuthority": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="SID", pack=False, align=None), offset=0), "pHash": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="EFS_HASH_BLOB", pack=False, align=None), offset=0), "lpDisplayInformation": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="ENCRYPTION_CERTIFICATE_HASH", pack=False, align=None), offset=0), offset=0)}, name="ENCRYPTION_CERTIFICATE_HASH_LIST", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["lpFileName", "pRecoveryAgents"]),
        # 
        'RemoveUsersFromEncryptedFile': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"nCert_Hash": SimTypeInt(signed=False, label="UInt32"), "pUsers": SimTypePointer(SimTypePointer(SimStruct({"cbTotalLength": SimTypeInt(signed=False, label="UInt32"), "pUserSid": SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "SubAuthorityCount": SimTypeChar(label="Byte"), "IdentifierAuthority": SimStruct({"Value": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 6)}, name="SID_IDENTIFIER_AUTHORITY", pack=False, align=None), "SubAuthority": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="SID", pack=False, align=None), offset=0), "pHash": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="EFS_HASH_BLOB", pack=False, align=None), offset=0), "lpDisplayInformation": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="ENCRYPTION_CERTIFICATE_HASH", pack=False, align=None), offset=0), offset=0)}, name="ENCRYPTION_CERTIFICATE_HASH_LIST", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["lpFileName", "pHashes"]),
        # 
        'AddUsersToEncryptedFile': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"nUsers": SimTypeInt(signed=False, label="UInt32"), "pUsers": SimTypePointer(SimTypePointer(SimStruct({"cbTotalLength": SimTypeInt(signed=False, label="UInt32"), "pUserSid": SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "SubAuthorityCount": SimTypeChar(label="Byte"), "IdentifierAuthority": SimStruct({"Value": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 6)}, name="SID_IDENTIFIER_AUTHORITY", pack=False, align=None), "SubAuthority": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="SID", pack=False, align=None), offset=0), "pCertBlob": SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="EFS_CERTIFICATE_BLOB", pack=False, align=None), offset=0)}, name="ENCRYPTION_CERTIFICATE", pack=False, align=None), offset=0), offset=0)}, name="ENCRYPTION_CERTIFICATE_LIST", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["lpFileName", "pEncryptionCertificates"]),
        # 
        'SetUserFileEncryptionKey': SimTypeFunction([SimTypePointer(SimStruct({"cbTotalLength": SimTypeInt(signed=False, label="UInt32"), "pUserSid": SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "SubAuthorityCount": SimTypeChar(label="Byte"), "IdentifierAuthority": SimStruct({"Value": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 6)}, name="SID_IDENTIFIER_AUTHORITY", pack=False, align=None), "SubAuthority": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="SID", pack=False, align=None), offset=0), "pCertBlob": SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="EFS_CERTIFICATE_BLOB", pack=False, align=None), offset=0)}, name="ENCRYPTION_CERTIFICATE", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pEncryptionCertificate"]),
        # 
        'SetUserFileEncryptionKeyEx': SimTypeFunction([SimTypePointer(SimStruct({"cbTotalLength": SimTypeInt(signed=False, label="UInt32"), "pUserSid": SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "SubAuthorityCount": SimTypeChar(label="Byte"), "IdentifierAuthority": SimStruct({"Value": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 6)}, name="SID_IDENTIFIER_AUTHORITY", pack=False, align=None), "SubAuthority": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="SID", pack=False, align=None), offset=0), "pCertBlob": SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="EFS_CERTIFICATE_BLOB", pack=False, align=None), offset=0)}, name="ENCRYPTION_CERTIFICATE", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pEncryptionCertificate", "dwCapabilities", "dwFlags", "pvReserved"]),
        # 
        'FreeEncryptionCertificateHashList': SimTypeFunction([SimTypePointer(SimStruct({"nCert_Hash": SimTypeInt(signed=False, label="UInt32"), "pUsers": SimTypePointer(SimTypePointer(SimStruct({"cbTotalLength": SimTypeInt(signed=False, label="UInt32"), "pUserSid": SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "SubAuthorityCount": SimTypeChar(label="Byte"), "IdentifierAuthority": SimStruct({"Value": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 6)}, name="SID_IDENTIFIER_AUTHORITY", pack=False, align=None), "SubAuthority": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="SID", pack=False, align=None), offset=0), "pHash": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="EFS_HASH_BLOB", pack=False, align=None), offset=0), "lpDisplayInformation": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="ENCRYPTION_CERTIFICATE_HASH", pack=False, align=None), offset=0), offset=0)}, name="ENCRYPTION_CERTIFICATE_HASH_LIST", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["pUsers"]),
        # 
        'EncryptionDisable': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["DirPath", "Disable"]),
        # 
        'DuplicateEncryptionInfoFile': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"nLength": SimTypeInt(signed=False, label="UInt32"), "lpSecurityDescriptor": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "bInheritHandle": SimTypeInt(signed=True, label="Int32")}, name="SECURITY_ATTRIBUTES", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["SrcFileName", "DstFileName", "dwCreationDistribution", "dwAttributes", "lpSecurityAttributes"]),
        # 
        'GetEncryptedFileMetadata': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["lpFileName", "pcbMetadata", "ppbMetadata"]),
        # 
        'SetEncryptedFileMetadata': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"cbTotalLength": SimTypeInt(signed=False, label="UInt32"), "pUserSid": SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "SubAuthorityCount": SimTypeChar(label="Byte"), "IdentifierAuthority": SimStruct({"Value": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 6)}, name="SID_IDENTIFIER_AUTHORITY", pack=False, align=None), "SubAuthority": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="SID", pack=False, align=None), offset=0), "pHash": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="EFS_HASH_BLOB", pack=False, align=None), offset=0), "lpDisplayInformation": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="ENCRYPTION_CERTIFICATE_HASH", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"nCert_Hash": SimTypeInt(signed=False, label="UInt32"), "pUsers": SimTypePointer(SimTypePointer(SimStruct({"cbTotalLength": SimTypeInt(signed=False, label="UInt32"), "pUserSid": SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "SubAuthorityCount": SimTypeChar(label="Byte"), "IdentifierAuthority": SimStruct({"Value": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 6)}, name="SID_IDENTIFIER_AUTHORITY", pack=False, align=None), "SubAuthority": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="SID", pack=False, align=None), offset=0), "pHash": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="EFS_HASH_BLOB", pack=False, align=None), offset=0), "lpDisplayInformation": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="ENCRYPTION_CERTIFICATE_HASH", pack=False, align=None), offset=0), offset=0)}, name="ENCRYPTION_CERTIFICATE_HASH_LIST", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["lpFileName", "pbOldMetadata", "pbNewMetadata", "pOwnerHash", "dwOperation", "pCertificatesAdded"]),
        # 
        'FreeEncryptedFileMetadata': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pbMetadata"]),
        # 
        'EncryptFileA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpFileName"]),
        # 
        'EncryptFileW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpFileName"]),
        # 
        'DecryptFileA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["lpFileName", "dwReserved"]),
        # 
        'DecryptFileW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["lpFileName", "dwReserved"]),
        # 
        'FileEncryptionStatusA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpFileName", "lpStatus"]),
        # 
        'FileEncryptionStatusW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpFileName", "lpStatus"]),
        # 
        'OpenEncryptedFileRawA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["lpFileName", "ulFlags", "pvContext"]),
        # 
        'OpenEncryptedFileRawW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["lpFileName", "ulFlags", "pvContext"]),
        # 
        'ReadEncryptedFileRaw': SimTypeFunction([SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["pbData", "pvCallbackContext", "ulLength"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pfExportCallback", "pvCallbackContext", "pvContext"]),
        # 
        'WriteEncryptedFileRaw': SimTypeFunction([SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pbData", "pvCallbackContext", "ulLength"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pfImportCallback", "pvCallbackContext", "pvContext"]),
        # 
        'CloseEncryptedFileRaw': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pvContext"]),
        # 
        'OperationStart': SimTypeFunction([SimTypePointer(SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "OperationId": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="OPERATION_START_FLAGS")}, name="OPERATION_START_PARAMETERS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["OperationStartParams"]),
        # 
        'OperationEnd': SimTypeFunction([SimTypePointer(SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "OperationId": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="OPERATION_END_PARAMETERS_FLAGS")}, name="OPERATION_END_PARAMETERS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["OperationEndParams"]),
        # 
        'OpenThreadWaitChainSession': SimTypeFunction([SimTypeInt(signed=False, label="OPEN_THREAD_WAIT_CHAIN_SESSION_FLAGS"), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"ObjectType": SimTypeInt(signed=False, label="WCT_OBJECT_TYPE"), "ObjectStatus": SimTypeInt(signed=False, label="WCT_OBJECT_STATUS"), "Anonymous": SimUnion({"LockObject": SimStruct({"ObjectName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 128), "Timeout": SimTypeBottom(label="LARGE_INTEGER"), "Alertable": SimTypeInt(signed=True, label="Int32")}, name="_LockObject_e__Struct", pack=False, align=None), "ThreadObject": SimStruct({"ProcessId": SimTypeInt(signed=False, label="UInt32"), "ThreadId": SimTypeInt(signed=False, label="UInt32"), "WaitTime": SimTypeInt(signed=False, label="UInt32"), "ContextSwitches": SimTypeInt(signed=False, label="UInt32")}, name="_ThreadObject_e__Struct", pack=False, align=None)}, name="<anon>", label="None")}, name="WAITCHAIN_NODE_INFO", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeBottom(label="Void"), arg_names=["WctHandle", "Context", "CallbackStatus", "NodeCount", "NodeInfoArray", "IsCycle"]), offset=0)], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["Flags", "callback"]),
        # 
        'CloseThreadWaitChainSession': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["WctHandle"]),
        # 
        'GetThreadWaitChain': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="WAIT_CHAIN_THREAD_OPTIONS"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"ObjectType": SimTypeInt(signed=False, label="WCT_OBJECT_TYPE"), "ObjectStatus": SimTypeInt(signed=False, label="WCT_OBJECT_STATUS"), "Anonymous": SimUnion({"LockObject": SimStruct({"ObjectName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 128), "Timeout": SimTypeBottom(label="LARGE_INTEGER"), "Alertable": SimTypeInt(signed=True, label="Int32")}, name="_LockObject_e__Struct", pack=False, align=None), "ThreadObject": SimStruct({"ProcessId": SimTypeInt(signed=False, label="UInt32"), "ThreadId": SimTypeInt(signed=False, label="UInt32"), "WaitTime": SimTypeInt(signed=False, label="UInt32"), "ContextSwitches": SimTypeInt(signed=False, label="UInt32")}, name="_ThreadObject_e__Struct", pack=False, align=None)}, name="<anon>", label="None")}, name="WAITCHAIN_NODE_INFO", pack=False, align=None), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["WctHandle", "Context", "Flags", "ThreadId", "NodeCount", "NodeInfoArray", "IsCycle"]),
        # 
        'RegisterWaitChainCOMCallback': SimTypeFunction([SimTypePointer(SimTypeFunction([SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1"]), offset=0), SimTypePointer(SimTypeFunction([SimTypeBottom(label="Guid"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1", "param2"]), offset=0)], SimTypeBottom(label="Void"), arg_names=["CallStateCallback", "ActivationStateCallback"]),
        # 
        'StartTraceW': SimTypeFunction([SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"Wnode": SimStruct({"BufferSize": SimTypeInt(signed=False, label="UInt32"), "ProviderId": SimTypeInt(signed=False, label="UInt32"), "Anonymous1": SimUnion({"HistoricalContext": SimTypeLongLong(signed=False, label="UInt64"), "Anonymous": SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "Linkage": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "Anonymous2": SimUnion({"CountLost": SimTypeInt(signed=False, label="UInt32"), "KernelHandle": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "TimeStamp": SimTypeBottom(label="LARGE_INTEGER")}, name="<anon>", label="None"), "Guid": SimTypeBottom(label="Guid"), "ClientContext": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="UInt32")}, name="WNODE_HEADER", pack=False, align=None), "BufferSize": SimTypeInt(signed=False, label="UInt32"), "MinimumBuffers": SimTypeInt(signed=False, label="UInt32"), "MaximumBuffers": SimTypeInt(signed=False, label="UInt32"), "MaximumFileSize": SimTypeInt(signed=False, label="UInt32"), "LogFileMode": SimTypeInt(signed=False, label="UInt32"), "FlushTimer": SimTypeInt(signed=False, label="UInt32"), "EnableFlags": SimTypeInt(signed=False, label="EVENT_TRACE_FLAG"), "Anonymous": SimUnion({"AgeLimit": SimTypeInt(signed=True, label="Int32"), "FlushThreshold": SimTypeInt(signed=True, label="Int32")}, name="<anon>", label="None"), "NumberOfBuffers": SimTypeInt(signed=False, label="UInt32"), "FreeBuffers": SimTypeInt(signed=False, label="UInt32"), "EventsLost": SimTypeInt(signed=False, label="UInt32"), "BuffersWritten": SimTypeInt(signed=False, label="UInt32"), "LogBuffersLost": SimTypeInt(signed=False, label="UInt32"), "RealTimeBuffersLost": SimTypeInt(signed=False, label="UInt32"), "LoggerThreadId": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "LogFileNameOffset": SimTypeInt(signed=False, label="UInt32"), "LoggerNameOffset": SimTypeInt(signed=False, label="UInt32")}, name="EVENT_TRACE_PROPERTIES", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["TraceHandle", "InstanceName", "Properties"]),
        # 
        'StartTraceA': SimTypeFunction([SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"Wnode": SimStruct({"BufferSize": SimTypeInt(signed=False, label="UInt32"), "ProviderId": SimTypeInt(signed=False, label="UInt32"), "Anonymous1": SimUnion({"HistoricalContext": SimTypeLongLong(signed=False, label="UInt64"), "Anonymous": SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "Linkage": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "Anonymous2": SimUnion({"CountLost": SimTypeInt(signed=False, label="UInt32"), "KernelHandle": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "TimeStamp": SimTypeBottom(label="LARGE_INTEGER")}, name="<anon>", label="None"), "Guid": SimTypeBottom(label="Guid"), "ClientContext": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="UInt32")}, name="WNODE_HEADER", pack=False, align=None), "BufferSize": SimTypeInt(signed=False, label="UInt32"), "MinimumBuffers": SimTypeInt(signed=False, label="UInt32"), "MaximumBuffers": SimTypeInt(signed=False, label="UInt32"), "MaximumFileSize": SimTypeInt(signed=False, label="UInt32"), "LogFileMode": SimTypeInt(signed=False, label="UInt32"), "FlushTimer": SimTypeInt(signed=False, label="UInt32"), "EnableFlags": SimTypeInt(signed=False, label="EVENT_TRACE_FLAG"), "Anonymous": SimUnion({"AgeLimit": SimTypeInt(signed=True, label="Int32"), "FlushThreshold": SimTypeInt(signed=True, label="Int32")}, name="<anon>", label="None"), "NumberOfBuffers": SimTypeInt(signed=False, label="UInt32"), "FreeBuffers": SimTypeInt(signed=False, label="UInt32"), "EventsLost": SimTypeInt(signed=False, label="UInt32"), "BuffersWritten": SimTypeInt(signed=False, label="UInt32"), "LogBuffersLost": SimTypeInt(signed=False, label="UInt32"), "RealTimeBuffersLost": SimTypeInt(signed=False, label="UInt32"), "LoggerThreadId": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "LogFileNameOffset": SimTypeInt(signed=False, label="UInt32"), "LoggerNameOffset": SimTypeInt(signed=False, label="UInt32")}, name="EVENT_TRACE_PROPERTIES", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["TraceHandle", "InstanceName", "Properties"]),
        # 
        'StopTraceW': SimTypeFunction([SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"Wnode": SimStruct({"BufferSize": SimTypeInt(signed=False, label="UInt32"), "ProviderId": SimTypeInt(signed=False, label="UInt32"), "Anonymous1": SimUnion({"HistoricalContext": SimTypeLongLong(signed=False, label="UInt64"), "Anonymous": SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "Linkage": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "Anonymous2": SimUnion({"CountLost": SimTypeInt(signed=False, label="UInt32"), "KernelHandle": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "TimeStamp": SimTypeBottom(label="LARGE_INTEGER")}, name="<anon>", label="None"), "Guid": SimTypeBottom(label="Guid"), "ClientContext": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="UInt32")}, name="WNODE_HEADER", pack=False, align=None), "BufferSize": SimTypeInt(signed=False, label="UInt32"), "MinimumBuffers": SimTypeInt(signed=False, label="UInt32"), "MaximumBuffers": SimTypeInt(signed=False, label="UInt32"), "MaximumFileSize": SimTypeInt(signed=False, label="UInt32"), "LogFileMode": SimTypeInt(signed=False, label="UInt32"), "FlushTimer": SimTypeInt(signed=False, label="UInt32"), "EnableFlags": SimTypeInt(signed=False, label="EVENT_TRACE_FLAG"), "Anonymous": SimUnion({"AgeLimit": SimTypeInt(signed=True, label="Int32"), "FlushThreshold": SimTypeInt(signed=True, label="Int32")}, name="<anon>", label="None"), "NumberOfBuffers": SimTypeInt(signed=False, label="UInt32"), "FreeBuffers": SimTypeInt(signed=False, label="UInt32"), "EventsLost": SimTypeInt(signed=False, label="UInt32"), "BuffersWritten": SimTypeInt(signed=False, label="UInt32"), "LogBuffersLost": SimTypeInt(signed=False, label="UInt32"), "RealTimeBuffersLost": SimTypeInt(signed=False, label="UInt32"), "LoggerThreadId": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "LogFileNameOffset": SimTypeInt(signed=False, label="UInt32"), "LoggerNameOffset": SimTypeInt(signed=False, label="UInt32")}, name="EVENT_TRACE_PROPERTIES", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["TraceHandle", "InstanceName", "Properties"]),
        # 
        'StopTraceA': SimTypeFunction([SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"Wnode": SimStruct({"BufferSize": SimTypeInt(signed=False, label="UInt32"), "ProviderId": SimTypeInt(signed=False, label="UInt32"), "Anonymous1": SimUnion({"HistoricalContext": SimTypeLongLong(signed=False, label="UInt64"), "Anonymous": SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "Linkage": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "Anonymous2": SimUnion({"CountLost": SimTypeInt(signed=False, label="UInt32"), "KernelHandle": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "TimeStamp": SimTypeBottom(label="LARGE_INTEGER")}, name="<anon>", label="None"), "Guid": SimTypeBottom(label="Guid"), "ClientContext": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="UInt32")}, name="WNODE_HEADER", pack=False, align=None), "BufferSize": SimTypeInt(signed=False, label="UInt32"), "MinimumBuffers": SimTypeInt(signed=False, label="UInt32"), "MaximumBuffers": SimTypeInt(signed=False, label="UInt32"), "MaximumFileSize": SimTypeInt(signed=False, label="UInt32"), "LogFileMode": SimTypeInt(signed=False, label="UInt32"), "FlushTimer": SimTypeInt(signed=False, label="UInt32"), "EnableFlags": SimTypeInt(signed=False, label="EVENT_TRACE_FLAG"), "Anonymous": SimUnion({"AgeLimit": SimTypeInt(signed=True, label="Int32"), "FlushThreshold": SimTypeInt(signed=True, label="Int32")}, name="<anon>", label="None"), "NumberOfBuffers": SimTypeInt(signed=False, label="UInt32"), "FreeBuffers": SimTypeInt(signed=False, label="UInt32"), "EventsLost": SimTypeInt(signed=False, label="UInt32"), "BuffersWritten": SimTypeInt(signed=False, label="UInt32"), "LogBuffersLost": SimTypeInt(signed=False, label="UInt32"), "RealTimeBuffersLost": SimTypeInt(signed=False, label="UInt32"), "LoggerThreadId": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "LogFileNameOffset": SimTypeInt(signed=False, label="UInt32"), "LoggerNameOffset": SimTypeInt(signed=False, label="UInt32")}, name="EVENT_TRACE_PROPERTIES", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["TraceHandle", "InstanceName", "Properties"]),
        # 
        'QueryTraceW': SimTypeFunction([SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"Wnode": SimStruct({"BufferSize": SimTypeInt(signed=False, label="UInt32"), "ProviderId": SimTypeInt(signed=False, label="UInt32"), "Anonymous1": SimUnion({"HistoricalContext": SimTypeLongLong(signed=False, label="UInt64"), "Anonymous": SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "Linkage": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "Anonymous2": SimUnion({"CountLost": SimTypeInt(signed=False, label="UInt32"), "KernelHandle": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "TimeStamp": SimTypeBottom(label="LARGE_INTEGER")}, name="<anon>", label="None"), "Guid": SimTypeBottom(label="Guid"), "ClientContext": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="UInt32")}, name="WNODE_HEADER", pack=False, align=None), "BufferSize": SimTypeInt(signed=False, label="UInt32"), "MinimumBuffers": SimTypeInt(signed=False, label="UInt32"), "MaximumBuffers": SimTypeInt(signed=False, label="UInt32"), "MaximumFileSize": SimTypeInt(signed=False, label="UInt32"), "LogFileMode": SimTypeInt(signed=False, label="UInt32"), "FlushTimer": SimTypeInt(signed=False, label="UInt32"), "EnableFlags": SimTypeInt(signed=False, label="EVENT_TRACE_FLAG"), "Anonymous": SimUnion({"AgeLimit": SimTypeInt(signed=True, label="Int32"), "FlushThreshold": SimTypeInt(signed=True, label="Int32")}, name="<anon>", label="None"), "NumberOfBuffers": SimTypeInt(signed=False, label="UInt32"), "FreeBuffers": SimTypeInt(signed=False, label="UInt32"), "EventsLost": SimTypeInt(signed=False, label="UInt32"), "BuffersWritten": SimTypeInt(signed=False, label="UInt32"), "LogBuffersLost": SimTypeInt(signed=False, label="UInt32"), "RealTimeBuffersLost": SimTypeInt(signed=False, label="UInt32"), "LoggerThreadId": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "LogFileNameOffset": SimTypeInt(signed=False, label="UInt32"), "LoggerNameOffset": SimTypeInt(signed=False, label="UInt32")}, name="EVENT_TRACE_PROPERTIES", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["TraceHandle", "InstanceName", "Properties"]),
        # 
        'QueryTraceA': SimTypeFunction([SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"Wnode": SimStruct({"BufferSize": SimTypeInt(signed=False, label="UInt32"), "ProviderId": SimTypeInt(signed=False, label="UInt32"), "Anonymous1": SimUnion({"HistoricalContext": SimTypeLongLong(signed=False, label="UInt64"), "Anonymous": SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "Linkage": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "Anonymous2": SimUnion({"CountLost": SimTypeInt(signed=False, label="UInt32"), "KernelHandle": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "TimeStamp": SimTypeBottom(label="LARGE_INTEGER")}, name="<anon>", label="None"), "Guid": SimTypeBottom(label="Guid"), "ClientContext": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="UInt32")}, name="WNODE_HEADER", pack=False, align=None), "BufferSize": SimTypeInt(signed=False, label="UInt32"), "MinimumBuffers": SimTypeInt(signed=False, label="UInt32"), "MaximumBuffers": SimTypeInt(signed=False, label="UInt32"), "MaximumFileSize": SimTypeInt(signed=False, label="UInt32"), "LogFileMode": SimTypeInt(signed=False, label="UInt32"), "FlushTimer": SimTypeInt(signed=False, label="UInt32"), "EnableFlags": SimTypeInt(signed=False, label="EVENT_TRACE_FLAG"), "Anonymous": SimUnion({"AgeLimit": SimTypeInt(signed=True, label="Int32"), "FlushThreshold": SimTypeInt(signed=True, label="Int32")}, name="<anon>", label="None"), "NumberOfBuffers": SimTypeInt(signed=False, label="UInt32"), "FreeBuffers": SimTypeInt(signed=False, label="UInt32"), "EventsLost": SimTypeInt(signed=False, label="UInt32"), "BuffersWritten": SimTypeInt(signed=False, label="UInt32"), "LogBuffersLost": SimTypeInt(signed=False, label="UInt32"), "RealTimeBuffersLost": SimTypeInt(signed=False, label="UInt32"), "LoggerThreadId": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "LogFileNameOffset": SimTypeInt(signed=False, label="UInt32"), "LoggerNameOffset": SimTypeInt(signed=False, label="UInt32")}, name="EVENT_TRACE_PROPERTIES", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["TraceHandle", "InstanceName", "Properties"]),
        # 
        'UpdateTraceW': SimTypeFunction([SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"Wnode": SimStruct({"BufferSize": SimTypeInt(signed=False, label="UInt32"), "ProviderId": SimTypeInt(signed=False, label="UInt32"), "Anonymous1": SimUnion({"HistoricalContext": SimTypeLongLong(signed=False, label="UInt64"), "Anonymous": SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "Linkage": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "Anonymous2": SimUnion({"CountLost": SimTypeInt(signed=False, label="UInt32"), "KernelHandle": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "TimeStamp": SimTypeBottom(label="LARGE_INTEGER")}, name="<anon>", label="None"), "Guid": SimTypeBottom(label="Guid"), "ClientContext": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="UInt32")}, name="WNODE_HEADER", pack=False, align=None), "BufferSize": SimTypeInt(signed=False, label="UInt32"), "MinimumBuffers": SimTypeInt(signed=False, label="UInt32"), "MaximumBuffers": SimTypeInt(signed=False, label="UInt32"), "MaximumFileSize": SimTypeInt(signed=False, label="UInt32"), "LogFileMode": SimTypeInt(signed=False, label="UInt32"), "FlushTimer": SimTypeInt(signed=False, label="UInt32"), "EnableFlags": SimTypeInt(signed=False, label="EVENT_TRACE_FLAG"), "Anonymous": SimUnion({"AgeLimit": SimTypeInt(signed=True, label="Int32"), "FlushThreshold": SimTypeInt(signed=True, label="Int32")}, name="<anon>", label="None"), "NumberOfBuffers": SimTypeInt(signed=False, label="UInt32"), "FreeBuffers": SimTypeInt(signed=False, label="UInt32"), "EventsLost": SimTypeInt(signed=False, label="UInt32"), "BuffersWritten": SimTypeInt(signed=False, label="UInt32"), "LogBuffersLost": SimTypeInt(signed=False, label="UInt32"), "RealTimeBuffersLost": SimTypeInt(signed=False, label="UInt32"), "LoggerThreadId": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "LogFileNameOffset": SimTypeInt(signed=False, label="UInt32"), "LoggerNameOffset": SimTypeInt(signed=False, label="UInt32")}, name="EVENT_TRACE_PROPERTIES", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["TraceHandle", "InstanceName", "Properties"]),
        # 
        'UpdateTraceA': SimTypeFunction([SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"Wnode": SimStruct({"BufferSize": SimTypeInt(signed=False, label="UInt32"), "ProviderId": SimTypeInt(signed=False, label="UInt32"), "Anonymous1": SimUnion({"HistoricalContext": SimTypeLongLong(signed=False, label="UInt64"), "Anonymous": SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "Linkage": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "Anonymous2": SimUnion({"CountLost": SimTypeInt(signed=False, label="UInt32"), "KernelHandle": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "TimeStamp": SimTypeBottom(label="LARGE_INTEGER")}, name="<anon>", label="None"), "Guid": SimTypeBottom(label="Guid"), "ClientContext": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="UInt32")}, name="WNODE_HEADER", pack=False, align=None), "BufferSize": SimTypeInt(signed=False, label="UInt32"), "MinimumBuffers": SimTypeInt(signed=False, label="UInt32"), "MaximumBuffers": SimTypeInt(signed=False, label="UInt32"), "MaximumFileSize": SimTypeInt(signed=False, label="UInt32"), "LogFileMode": SimTypeInt(signed=False, label="UInt32"), "FlushTimer": SimTypeInt(signed=False, label="UInt32"), "EnableFlags": SimTypeInt(signed=False, label="EVENT_TRACE_FLAG"), "Anonymous": SimUnion({"AgeLimit": SimTypeInt(signed=True, label="Int32"), "FlushThreshold": SimTypeInt(signed=True, label="Int32")}, name="<anon>", label="None"), "NumberOfBuffers": SimTypeInt(signed=False, label="UInt32"), "FreeBuffers": SimTypeInt(signed=False, label="UInt32"), "EventsLost": SimTypeInt(signed=False, label="UInt32"), "BuffersWritten": SimTypeInt(signed=False, label="UInt32"), "LogBuffersLost": SimTypeInt(signed=False, label="UInt32"), "RealTimeBuffersLost": SimTypeInt(signed=False, label="UInt32"), "LoggerThreadId": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "LogFileNameOffset": SimTypeInt(signed=False, label="UInt32"), "LoggerNameOffset": SimTypeInt(signed=False, label="UInt32")}, name="EVENT_TRACE_PROPERTIES", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["TraceHandle", "InstanceName", "Properties"]),
        # 
        'FlushTraceW': SimTypeFunction([SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"Wnode": SimStruct({"BufferSize": SimTypeInt(signed=False, label="UInt32"), "ProviderId": SimTypeInt(signed=False, label="UInt32"), "Anonymous1": SimUnion({"HistoricalContext": SimTypeLongLong(signed=False, label="UInt64"), "Anonymous": SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "Linkage": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "Anonymous2": SimUnion({"CountLost": SimTypeInt(signed=False, label="UInt32"), "KernelHandle": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "TimeStamp": SimTypeBottom(label="LARGE_INTEGER")}, name="<anon>", label="None"), "Guid": SimTypeBottom(label="Guid"), "ClientContext": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="UInt32")}, name="WNODE_HEADER", pack=False, align=None), "BufferSize": SimTypeInt(signed=False, label="UInt32"), "MinimumBuffers": SimTypeInt(signed=False, label="UInt32"), "MaximumBuffers": SimTypeInt(signed=False, label="UInt32"), "MaximumFileSize": SimTypeInt(signed=False, label="UInt32"), "LogFileMode": SimTypeInt(signed=False, label="UInt32"), "FlushTimer": SimTypeInt(signed=False, label="UInt32"), "EnableFlags": SimTypeInt(signed=False, label="EVENT_TRACE_FLAG"), "Anonymous": SimUnion({"AgeLimit": SimTypeInt(signed=True, label="Int32"), "FlushThreshold": SimTypeInt(signed=True, label="Int32")}, name="<anon>", label="None"), "NumberOfBuffers": SimTypeInt(signed=False, label="UInt32"), "FreeBuffers": SimTypeInt(signed=False, label="UInt32"), "EventsLost": SimTypeInt(signed=False, label="UInt32"), "BuffersWritten": SimTypeInt(signed=False, label="UInt32"), "LogBuffersLost": SimTypeInt(signed=False, label="UInt32"), "RealTimeBuffersLost": SimTypeInt(signed=False, label="UInt32"), "LoggerThreadId": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "LogFileNameOffset": SimTypeInt(signed=False, label="UInt32"), "LoggerNameOffset": SimTypeInt(signed=False, label="UInt32")}, name="EVENT_TRACE_PROPERTIES", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["TraceHandle", "InstanceName", "Properties"]),
        # 
        'FlushTraceA': SimTypeFunction([SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"Wnode": SimStruct({"BufferSize": SimTypeInt(signed=False, label="UInt32"), "ProviderId": SimTypeInt(signed=False, label="UInt32"), "Anonymous1": SimUnion({"HistoricalContext": SimTypeLongLong(signed=False, label="UInt64"), "Anonymous": SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "Linkage": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "Anonymous2": SimUnion({"CountLost": SimTypeInt(signed=False, label="UInt32"), "KernelHandle": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "TimeStamp": SimTypeBottom(label="LARGE_INTEGER")}, name="<anon>", label="None"), "Guid": SimTypeBottom(label="Guid"), "ClientContext": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="UInt32")}, name="WNODE_HEADER", pack=False, align=None), "BufferSize": SimTypeInt(signed=False, label="UInt32"), "MinimumBuffers": SimTypeInt(signed=False, label="UInt32"), "MaximumBuffers": SimTypeInt(signed=False, label="UInt32"), "MaximumFileSize": SimTypeInt(signed=False, label="UInt32"), "LogFileMode": SimTypeInt(signed=False, label="UInt32"), "FlushTimer": SimTypeInt(signed=False, label="UInt32"), "EnableFlags": SimTypeInt(signed=False, label="EVENT_TRACE_FLAG"), "Anonymous": SimUnion({"AgeLimit": SimTypeInt(signed=True, label="Int32"), "FlushThreshold": SimTypeInt(signed=True, label="Int32")}, name="<anon>", label="None"), "NumberOfBuffers": SimTypeInt(signed=False, label="UInt32"), "FreeBuffers": SimTypeInt(signed=False, label="UInt32"), "EventsLost": SimTypeInt(signed=False, label="UInt32"), "BuffersWritten": SimTypeInt(signed=False, label="UInt32"), "LogBuffersLost": SimTypeInt(signed=False, label="UInt32"), "RealTimeBuffersLost": SimTypeInt(signed=False, label="UInt32"), "LoggerThreadId": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "LogFileNameOffset": SimTypeInt(signed=False, label="UInt32"), "LoggerNameOffset": SimTypeInt(signed=False, label="UInt32")}, name="EVENT_TRACE_PROPERTIES", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["TraceHandle", "InstanceName", "Properties"]),
        # 
        'ControlTraceW': SimTypeFunction([SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"Wnode": SimStruct({"BufferSize": SimTypeInt(signed=False, label="UInt32"), "ProviderId": SimTypeInt(signed=False, label="UInt32"), "Anonymous1": SimUnion({"HistoricalContext": SimTypeLongLong(signed=False, label="UInt64"), "Anonymous": SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "Linkage": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "Anonymous2": SimUnion({"CountLost": SimTypeInt(signed=False, label="UInt32"), "KernelHandle": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "TimeStamp": SimTypeBottom(label="LARGE_INTEGER")}, name="<anon>", label="None"), "Guid": SimTypeBottom(label="Guid"), "ClientContext": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="UInt32")}, name="WNODE_HEADER", pack=False, align=None), "BufferSize": SimTypeInt(signed=False, label="UInt32"), "MinimumBuffers": SimTypeInt(signed=False, label="UInt32"), "MaximumBuffers": SimTypeInt(signed=False, label="UInt32"), "MaximumFileSize": SimTypeInt(signed=False, label="UInt32"), "LogFileMode": SimTypeInt(signed=False, label="UInt32"), "FlushTimer": SimTypeInt(signed=False, label="UInt32"), "EnableFlags": SimTypeInt(signed=False, label="EVENT_TRACE_FLAG"), "Anonymous": SimUnion({"AgeLimit": SimTypeInt(signed=True, label="Int32"), "FlushThreshold": SimTypeInt(signed=True, label="Int32")}, name="<anon>", label="None"), "NumberOfBuffers": SimTypeInt(signed=False, label="UInt32"), "FreeBuffers": SimTypeInt(signed=False, label="UInt32"), "EventsLost": SimTypeInt(signed=False, label="UInt32"), "BuffersWritten": SimTypeInt(signed=False, label="UInt32"), "LogBuffersLost": SimTypeInt(signed=False, label="UInt32"), "RealTimeBuffersLost": SimTypeInt(signed=False, label="UInt32"), "LoggerThreadId": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "LogFileNameOffset": SimTypeInt(signed=False, label="UInt32"), "LoggerNameOffset": SimTypeInt(signed=False, label="UInt32")}, name="EVENT_TRACE_PROPERTIES", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="EVENT_TRACE_CONTROL")], SimTypeInt(signed=False, label="UInt32"), arg_names=["TraceHandle", "InstanceName", "Properties", "ControlCode"]),
        # 
        'ControlTraceA': SimTypeFunction([SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"Wnode": SimStruct({"BufferSize": SimTypeInt(signed=False, label="UInt32"), "ProviderId": SimTypeInt(signed=False, label="UInt32"), "Anonymous1": SimUnion({"HistoricalContext": SimTypeLongLong(signed=False, label="UInt64"), "Anonymous": SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "Linkage": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "Anonymous2": SimUnion({"CountLost": SimTypeInt(signed=False, label="UInt32"), "KernelHandle": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "TimeStamp": SimTypeBottom(label="LARGE_INTEGER")}, name="<anon>", label="None"), "Guid": SimTypeBottom(label="Guid"), "ClientContext": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="UInt32")}, name="WNODE_HEADER", pack=False, align=None), "BufferSize": SimTypeInt(signed=False, label="UInt32"), "MinimumBuffers": SimTypeInt(signed=False, label="UInt32"), "MaximumBuffers": SimTypeInt(signed=False, label="UInt32"), "MaximumFileSize": SimTypeInt(signed=False, label="UInt32"), "LogFileMode": SimTypeInt(signed=False, label="UInt32"), "FlushTimer": SimTypeInt(signed=False, label="UInt32"), "EnableFlags": SimTypeInt(signed=False, label="EVENT_TRACE_FLAG"), "Anonymous": SimUnion({"AgeLimit": SimTypeInt(signed=True, label="Int32"), "FlushThreshold": SimTypeInt(signed=True, label="Int32")}, name="<anon>", label="None"), "NumberOfBuffers": SimTypeInt(signed=False, label="UInt32"), "FreeBuffers": SimTypeInt(signed=False, label="UInt32"), "EventsLost": SimTypeInt(signed=False, label="UInt32"), "BuffersWritten": SimTypeInt(signed=False, label="UInt32"), "LogBuffersLost": SimTypeInt(signed=False, label="UInt32"), "RealTimeBuffersLost": SimTypeInt(signed=False, label="UInt32"), "LoggerThreadId": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "LogFileNameOffset": SimTypeInt(signed=False, label="UInt32"), "LoggerNameOffset": SimTypeInt(signed=False, label="UInt32")}, name="EVENT_TRACE_PROPERTIES", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="EVENT_TRACE_CONTROL")], SimTypeInt(signed=False, label="UInt32"), arg_names=["TraceHandle", "InstanceName", "Properties", "ControlCode"]),
        # 
        'QueryAllTracesW': SimTypeFunction([SimTypePointer(SimTypePointer(SimStruct({"Wnode": SimStruct({"BufferSize": SimTypeInt(signed=False, label="UInt32"), "ProviderId": SimTypeInt(signed=False, label="UInt32"), "Anonymous1": SimUnion({"HistoricalContext": SimTypeLongLong(signed=False, label="UInt64"), "Anonymous": SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "Linkage": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "Anonymous2": SimUnion({"CountLost": SimTypeInt(signed=False, label="UInt32"), "KernelHandle": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "TimeStamp": SimTypeBottom(label="LARGE_INTEGER")}, name="<anon>", label="None"), "Guid": SimTypeBottom(label="Guid"), "ClientContext": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="UInt32")}, name="WNODE_HEADER", pack=False, align=None), "BufferSize": SimTypeInt(signed=False, label="UInt32"), "MinimumBuffers": SimTypeInt(signed=False, label="UInt32"), "MaximumBuffers": SimTypeInt(signed=False, label="UInt32"), "MaximumFileSize": SimTypeInt(signed=False, label="UInt32"), "LogFileMode": SimTypeInt(signed=False, label="UInt32"), "FlushTimer": SimTypeInt(signed=False, label="UInt32"), "EnableFlags": SimTypeInt(signed=False, label="EVENT_TRACE_FLAG"), "Anonymous": SimUnion({"AgeLimit": SimTypeInt(signed=True, label="Int32"), "FlushThreshold": SimTypeInt(signed=True, label="Int32")}, name="<anon>", label="None"), "NumberOfBuffers": SimTypeInt(signed=False, label="UInt32"), "FreeBuffers": SimTypeInt(signed=False, label="UInt32"), "EventsLost": SimTypeInt(signed=False, label="UInt32"), "BuffersWritten": SimTypeInt(signed=False, label="UInt32"), "LogBuffersLost": SimTypeInt(signed=False, label="UInt32"), "RealTimeBuffersLost": SimTypeInt(signed=False, label="UInt32"), "LoggerThreadId": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "LogFileNameOffset": SimTypeInt(signed=False, label="UInt32"), "LoggerNameOffset": SimTypeInt(signed=False, label="UInt32")}, name="EVENT_TRACE_PROPERTIES", pack=False, align=None), offset=0), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["PropertyArray", "PropertyArrayCount", "LoggerCount"]),
        # 
        'QueryAllTracesA': SimTypeFunction([SimTypePointer(SimTypePointer(SimStruct({"Wnode": SimStruct({"BufferSize": SimTypeInt(signed=False, label="UInt32"), "ProviderId": SimTypeInt(signed=False, label="UInt32"), "Anonymous1": SimUnion({"HistoricalContext": SimTypeLongLong(signed=False, label="UInt64"), "Anonymous": SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "Linkage": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "Anonymous2": SimUnion({"CountLost": SimTypeInt(signed=False, label="UInt32"), "KernelHandle": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "TimeStamp": SimTypeBottom(label="LARGE_INTEGER")}, name="<anon>", label="None"), "Guid": SimTypeBottom(label="Guid"), "ClientContext": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="UInt32")}, name="WNODE_HEADER", pack=False, align=None), "BufferSize": SimTypeInt(signed=False, label="UInt32"), "MinimumBuffers": SimTypeInt(signed=False, label="UInt32"), "MaximumBuffers": SimTypeInt(signed=False, label="UInt32"), "MaximumFileSize": SimTypeInt(signed=False, label="UInt32"), "LogFileMode": SimTypeInt(signed=False, label="UInt32"), "FlushTimer": SimTypeInt(signed=False, label="UInt32"), "EnableFlags": SimTypeInt(signed=False, label="EVENT_TRACE_FLAG"), "Anonymous": SimUnion({"AgeLimit": SimTypeInt(signed=True, label="Int32"), "FlushThreshold": SimTypeInt(signed=True, label="Int32")}, name="<anon>", label="None"), "NumberOfBuffers": SimTypeInt(signed=False, label="UInt32"), "FreeBuffers": SimTypeInt(signed=False, label="UInt32"), "EventsLost": SimTypeInt(signed=False, label="UInt32"), "BuffersWritten": SimTypeInt(signed=False, label="UInt32"), "LogBuffersLost": SimTypeInt(signed=False, label="UInt32"), "RealTimeBuffersLost": SimTypeInt(signed=False, label="UInt32"), "LoggerThreadId": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "LogFileNameOffset": SimTypeInt(signed=False, label="UInt32"), "LoggerNameOffset": SimTypeInt(signed=False, label="UInt32")}, name="EVENT_TRACE_PROPERTIES", pack=False, align=None), offset=0), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["PropertyArray", "PropertyArrayCount", "LoggerCount"]),
        # 
        'EnableTrace': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeLongLong(signed=False, label="UInt64")], SimTypeInt(signed=False, label="UInt32"), arg_names=["Enable", "EnableFlag", "EnableLevel", "ControlGuid", "TraceHandle"]),
        # 
        'EnableTraceEx': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypeInt(signed=False, label="UInt32"), SimTypeChar(label="Byte"), SimTypeLongLong(signed=False, label="UInt64"), SimTypeLongLong(signed=False, label="UInt64"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Ptr": SimTypeLongLong(signed=False, label="UInt64"), "Size": SimTypeInt(signed=False, label="UInt32"), "Type": SimTypeInt(signed=False, label="UInt32")}, name="EVENT_FILTER_DESCRIPTOR", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ProviderId", "SourceId", "TraceHandle", "IsEnabled", "Level", "MatchAnyKeyword", "MatchAllKeyword", "EnableProperty", "EnableFilterDesc"]),
        # 
        'EnableTraceEx2': SimTypeFunction([SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeChar(label="Byte"), SimTypeLongLong(signed=False, label="UInt64"), SimTypeLongLong(signed=False, label="UInt64"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "EnableProperty": SimTypeInt(signed=False, label="UInt32"), "ControlFlags": SimTypeInt(signed=False, label="UInt32"), "SourceId": SimTypeBottom(label="Guid"), "EnableFilterDesc": SimTypePointer(SimTypeBottom(label="EVENT_FILTER_DESCRIPTOR"), offset=0), "FilterDescCount": SimTypeInt(signed=False, label="UInt32")}, name="ENABLE_TRACE_PARAMETERS", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["TraceHandle", "ProviderId", "ControlCode", "Level", "MatchAnyKeyword", "MatchAllKeyword", "Timeout", "EnableParameters"]),
        # 
        'EnumerateTraceGuidsEx': SimTypeFunction([SimTypeInt(signed=False, label="TRACE_QUERY_INFO_CLASS"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["TraceQueryInfoClass", "InBuffer", "InBufferSize", "OutBuffer", "OutBufferSize", "ReturnLength"]),
        # 
        'TraceSetInformation': SimTypeFunction([SimTypeLongLong(signed=False, label="UInt64"), SimTypeInt(signed=False, label="TRACE_QUERY_INFO_CLASS"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["SessionHandle", "InformationClass", "TraceInformation", "InformationLength"]),
        # 
        'TraceQueryInformation': SimTypeFunction([SimTypeLongLong(signed=False, label="UInt64"), SimTypeInt(signed=False, label="TRACE_QUERY_INFO_CLASS"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["SessionHandle", "InformationClass", "TraceInformation", "InformationLength", "ReturnLength"]),
        # 
        'CreateTraceInstanceId': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"RegHandle": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "InstanceId": SimTypeInt(signed=False, label="UInt32")}, name="EVENT_INSTANCE_INFO", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RegHandle", "InstInfo"]),
        # 
        'TraceEvent': SimTypeFunction([SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimStruct({"Size": SimTypeShort(signed=False, label="UInt16"), "Anonymous1": SimUnion({"FieldTypeFlags": SimTypeShort(signed=False, label="UInt16"), "Anonymous": SimStruct({"HeaderType": SimTypeChar(label="Byte"), "MarkerFlags": SimTypeChar(label="Byte")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "Anonymous2": SimUnion({"Version": SimTypeInt(signed=False, label="UInt32"), "Class": SimStruct({"Type": SimTypeChar(label="Byte"), "Level": SimTypeChar(label="Byte"), "Version": SimTypeShort(signed=False, label="UInt16")}, name="_Class_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "ThreadId": SimTypeInt(signed=False, label="UInt32"), "ProcessId": SimTypeInt(signed=False, label="UInt32"), "TimeStamp": SimTypeBottom(label="LARGE_INTEGER"), "Anonymous3": SimUnion({"Guid": SimTypeBottom(label="Guid"), "GuidPtr": SimTypeLongLong(signed=False, label="UInt64")}, name="<anon>", label="None"), "Anonymous4": SimUnion({"Anonymous1": SimStruct({"KernelTime": SimTypeInt(signed=False, label="UInt32"), "UserTime": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous1_e__Struct", pack=False, align=None), "ProcessorTime": SimTypeLongLong(signed=False, label="UInt64"), "Anonymous2": SimStruct({"ClientContext": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous2_e__Struct", pack=False, align=None)}, name="<anon>", label="None")}, name="EVENT_TRACE_HEADER", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["TraceHandle", "EventTrace"]),
        # 
        'TraceEventInstance': SimTypeFunction([SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimStruct({"Size": SimTypeShort(signed=False, label="UInt16"), "Anonymous1": SimUnion({"FieldTypeFlags": SimTypeShort(signed=False, label="UInt16"), "Anonymous": SimStruct({"HeaderType": SimTypeChar(label="Byte"), "MarkerFlags": SimTypeChar(label="Byte")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "Anonymous2": SimUnion({"Version": SimTypeInt(signed=False, label="UInt32"), "Class": SimStruct({"Type": SimTypeChar(label="Byte"), "Level": SimTypeChar(label="Byte"), "Version": SimTypeShort(signed=False, label="UInt16")}, name="_Class_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "ThreadId": SimTypeInt(signed=False, label="UInt32"), "ProcessId": SimTypeInt(signed=False, label="UInt32"), "TimeStamp": SimTypeBottom(label="LARGE_INTEGER"), "RegHandle": SimTypeLongLong(signed=False, label="UInt64"), "InstanceId": SimTypeInt(signed=False, label="UInt32"), "ParentInstanceId": SimTypeInt(signed=False, label="UInt32"), "Anonymous3": SimUnion({"Anonymous1": SimStruct({"KernelTime": SimTypeInt(signed=False, label="UInt32"), "UserTime": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous1_e__Struct", pack=False, align=None), "ProcessorTime": SimTypeLongLong(signed=False, label="UInt64"), "Anonymous2": SimStruct({"EventId": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous2_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "ParentRegHandle": SimTypeLongLong(signed=False, label="UInt64")}, name="EVENT_INSTANCE_HEADER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"RegHandle": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "InstanceId": SimTypeInt(signed=False, label="UInt32")}, name="EVENT_INSTANCE_INFO", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"RegHandle": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "InstanceId": SimTypeInt(signed=False, label="UInt32")}, name="EVENT_INSTANCE_INFO", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["TraceHandle", "EventTrace", "InstInfo", "ParentInstInfo"]),
        # 
        'RegisterTraceGuidsW': SimTypeFunction([SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="WMIDPREQUESTCODE"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RequestCode", "RequestContext", "BufferSize", "Buffer"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Guid": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "RegHandle": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="TRACE_GUID_REGISTRATION", pack=False, align=None), label="LPArray", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RequestAddress", "RequestContext", "ControlGuid", "GuidCount", "TraceGuidReg", "MofImagePath", "MofResourceName", "RegistrationHandle"]),
        # 
        'RegisterTraceGuidsA': SimTypeFunction([SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="WMIDPREQUESTCODE"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RequestCode", "RequestContext", "BufferSize", "Buffer"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Guid": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "RegHandle": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="TRACE_GUID_REGISTRATION", pack=False, align=None), label="LPArray", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RequestAddress", "RequestContext", "ControlGuid", "GuidCount", "TraceGuidReg", "MofImagePath", "MofResourceName", "RegistrationHandle"]),
        # 
        'EnumerateTraceGuids': SimTypeFunction([SimTypePointer(SimTypePointer(SimStruct({"Guid": SimTypeBottom(label="Guid"), "GuidType": SimTypeInt(signed=False, label="UInt32"), "LoggerId": SimTypeInt(signed=False, label="UInt32"), "EnableLevel": SimTypeInt(signed=False, label="UInt32"), "EnableFlags": SimTypeInt(signed=False, label="UInt32"), "IsEnable": SimTypeChar(label="Byte")}, name="TRACE_GUID_PROPERTIES", pack=False, align=None), offset=0), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["GuidPropertiesArray", "PropertyArrayCount", "GuidCount"]),
        # 
        'UnregisterTraceGuids': SimTypeFunction([SimTypeLongLong(signed=False, label="UInt64")], SimTypeInt(signed=False, label="UInt32"), arg_names=["RegistrationHandle"]),
        # 
        'GetTraceLoggerHandle': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeLongLong(signed=False, label="UInt64"), arg_names=["Buffer"]),
        # 
        'GetTraceEnableLevel': SimTypeFunction([SimTypeLongLong(signed=False, label="UInt64")], SimTypeChar(label="Byte"), arg_names=["TraceHandle"]),
        # 
        'GetTraceEnableFlags': SimTypeFunction([SimTypeLongLong(signed=False, label="UInt64")], SimTypeInt(signed=False, label="UInt32"), arg_names=["TraceHandle"]),
        # 
        'OpenTraceW': SimTypeFunction([SimTypePointer(SimStruct({"LogFileName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "LoggerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "CurrentTime": SimTypeLongLong(signed=True, label="Int64"), "BuffersRead": SimTypeInt(signed=False, label="UInt32"), "Anonymous1": SimUnion({"LogFileMode": SimTypeInt(signed=False, label="UInt32"), "ProcessTraceMode": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None"), "CurrentEvent": SimStruct({"Header": SimStruct({"Size": SimTypeShort(signed=False, label="UInt16"), "Anonymous1": SimUnion({"FieldTypeFlags": SimTypeShort(signed=False, label="UInt16"), "Anonymous": SimStruct({"HeaderType": SimTypeChar(label="Byte"), "MarkerFlags": SimTypeChar(label="Byte")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "Anonymous2": SimUnion({"Version": SimTypeInt(signed=False, label="UInt32"), "Class": SimStruct({"Type": SimTypeChar(label="Byte"), "Level": SimTypeChar(label="Byte"), "Version": SimTypeShort(signed=False, label="UInt16")}, name="_Class_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "ThreadId": SimTypeInt(signed=False, label="UInt32"), "ProcessId": SimTypeInt(signed=False, label="UInt32"), "TimeStamp": SimTypeBottom(label="LARGE_INTEGER"), "Anonymous3": SimUnion({"Guid": SimTypeBottom(label="Guid"), "GuidPtr": SimTypeLongLong(signed=False, label="UInt64")}, name="<anon>", label="None"), "Anonymous4": SimUnion({"Anonymous1": SimStruct({"KernelTime": SimTypeInt(signed=False, label="UInt32"), "UserTime": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous1_e__Struct", pack=False, align=None), "ProcessorTime": SimTypeLongLong(signed=False, label="UInt64"), "Anonymous2": SimStruct({"ClientContext": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous2_e__Struct", pack=False, align=None)}, name="<anon>", label="None")}, name="EVENT_TRACE_HEADER", pack=False, align=None), "InstanceId": SimTypeInt(signed=False, label="UInt32"), "ParentInstanceId": SimTypeInt(signed=False, label="UInt32"), "ParentGuid": SimTypeBottom(label="Guid"), "MofData": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "MofLength": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"ClientContext": SimTypeInt(signed=False, label="UInt32"), "BufferContext": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"ProcessorNumber": SimTypeChar(label="Byte"), "Alignment": SimTypeChar(label="Byte")}, name="_Anonymous_e__Struct", pack=False, align=None), "ProcessorIndex": SimTypeShort(signed=False, label="UInt16")}, name="<anon>", label="None"), "LoggerId": SimTypeShort(signed=False, label="UInt16")}, name="ETW_BUFFER_CONTEXT", pack=False, align=None)}, name="<anon>", label="None")}, name="EVENT_TRACE", pack=False, align=None), "LogfileHeader": SimStruct({"BufferSize": SimTypeInt(signed=False, label="UInt32"), "Anonymous1": SimUnion({"Version": SimTypeInt(signed=False, label="UInt32"), "VersionDetail": SimStruct({"MajorVersion": SimTypeChar(label="Byte"), "MinorVersion": SimTypeChar(label="Byte"), "SubVersion": SimTypeChar(label="Byte"), "SubMinorVersion": SimTypeChar(label="Byte")}, name="_VersionDetail_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "ProviderVersion": SimTypeInt(signed=False, label="UInt32"), "NumberOfProcessors": SimTypeInt(signed=False, label="UInt32"), "EndTime": SimTypeBottom(label="LARGE_INTEGER"), "TimerResolution": SimTypeInt(signed=False, label="UInt32"), "MaximumFileSize": SimTypeInt(signed=False, label="UInt32"), "LogFileMode": SimTypeInt(signed=False, label="UInt32"), "BuffersWritten": SimTypeInt(signed=False, label="UInt32"), "Anonymous2": SimUnion({"LogInstanceGuid": SimTypeBottom(label="Guid"), "Anonymous": SimStruct({"StartBuffers": SimTypeInt(signed=False, label="UInt32"), "PointerSize": SimTypeInt(signed=False, label="UInt32"), "EventsLost": SimTypeInt(signed=False, label="UInt32"), "CpuSpeedInMHz": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "LoggerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "LogFileName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "TimeZone": SimTypeBottom(label="TIME_ZONE_INFORMATION"), "BootTime": SimTypeBottom(label="LARGE_INTEGER"), "PerfFreq": SimTypeBottom(label="LARGE_INTEGER"), "StartTime": SimTypeBottom(label="LARGE_INTEGER"), "ReservedFlags": SimTypeInt(signed=False, label="UInt32"), "BuffersLost": SimTypeInt(signed=False, label="UInt32")}, name="TRACE_LOGFILE_HEADER", pack=False, align=None), "BufferCallback": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="EVENT_TRACE_LOGFILEW"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["Logfile"]), offset=0), "BufferSize": SimTypeInt(signed=False, label="UInt32"), "Filled": SimTypeInt(signed=False, label="UInt32"), "EventsLost": SimTypeInt(signed=False, label="UInt32"), "Anonymous2": SimUnion({"EventCallback": SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"Header": SimStruct({"Size": SimTypeShort(signed=False, label="UInt16"), "Anonymous1": SimUnion({"FieldTypeFlags": SimTypeShort(signed=False, label="UInt16"), "Anonymous": SimStruct({"HeaderType": SimTypeChar(label="Byte"), "MarkerFlags": SimTypeChar(label="Byte")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "Anonymous2": SimUnion({"Version": SimTypeInt(signed=False, label="UInt32"), "Class": SimStruct({"Type": SimTypeChar(label="Byte"), "Level": SimTypeChar(label="Byte"), "Version": SimTypeShort(signed=False, label="UInt16")}, name="_Class_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "ThreadId": SimTypeInt(signed=False, label="UInt32"), "ProcessId": SimTypeInt(signed=False, label="UInt32"), "TimeStamp": SimTypeBottom(label="LARGE_INTEGER"), "Anonymous3": SimUnion({"Guid": SimTypeBottom(label="Guid"), "GuidPtr": SimTypeLongLong(signed=False, label="UInt64")}, name="<anon>", label="None"), "Anonymous4": SimUnion({"Anonymous1": SimStruct({"KernelTime": SimTypeInt(signed=False, label="UInt32"), "UserTime": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous1_e__Struct", pack=False, align=None), "ProcessorTime": SimTypeLongLong(signed=False, label="UInt64"), "Anonymous2": SimStruct({"ClientContext": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous2_e__Struct", pack=False, align=None)}, name="<anon>", label="None")}, name="EVENT_TRACE_HEADER", pack=False, align=None), "InstanceId": SimTypeInt(signed=False, label="UInt32"), "ParentInstanceId": SimTypeInt(signed=False, label="UInt32"), "ParentGuid": SimTypeBottom(label="Guid"), "MofData": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "MofLength": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"ClientContext": SimTypeInt(signed=False, label="UInt32"), "BufferContext": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"ProcessorNumber": SimTypeChar(label="Byte"), "Alignment": SimTypeChar(label="Byte")}, name="_Anonymous_e__Struct", pack=False, align=None), "ProcessorIndex": SimTypeShort(signed=False, label="UInt16")}, name="<anon>", label="None"), "LoggerId": SimTypeShort(signed=False, label="UInt16")}, name="ETW_BUFFER_CONTEXT", pack=False, align=None)}, name="<anon>", label="None")}, name="EVENT_TRACE", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["pEvent"]), offset=0), "EventRecordCallback": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="EVENT_RECORD"), offset=0)], SimTypeBottom(label="Void"), arg_names=["EventRecord"]), offset=0)}, name="<anon>", label="None"), "IsKernelTrace": SimTypeInt(signed=False, label="UInt32"), "Context": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="EVENT_TRACE_LOGFILEW", pack=False, align=None), offset=0)], SimTypeLongLong(signed=False, label="UInt64"), arg_names=["Logfile"]),
        # 
        'ProcessTrace': SimTypeFunction([SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["HandleArray", "HandleCount", "StartTime", "EndTime"]),
        # 
        'CloseTrace': SimTypeFunction([SimTypeLongLong(signed=False, label="UInt64")], SimTypeInt(signed=False, label="UInt32"), arg_names=["TraceHandle"]),
        # 
        'QueryTraceProcessingHandle': SimTypeFunction([SimTypeLongLong(signed=False, label="UInt64"), SimTypeInt(signed=False, label="ETW_PROCESS_HANDLE_INFO_TYPE"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ProcessingHandle", "InformationClass", "InBuffer", "InBufferSize", "OutBuffer", "OutBufferSize", "ReturnLength"]),
        # 
        'OpenTraceA': SimTypeFunction([SimTypePointer(SimStruct({"LogFileName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "LoggerName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CurrentTime": SimTypeLongLong(signed=True, label="Int64"), "BuffersRead": SimTypeInt(signed=False, label="UInt32"), "Anonymous1": SimUnion({"LogFileMode": SimTypeInt(signed=False, label="UInt32"), "ProcessTraceMode": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None"), "CurrentEvent": SimStruct({"Header": SimStruct({"Size": SimTypeShort(signed=False, label="UInt16"), "Anonymous1": SimUnion({"FieldTypeFlags": SimTypeShort(signed=False, label="UInt16"), "Anonymous": SimStruct({"HeaderType": SimTypeChar(label="Byte"), "MarkerFlags": SimTypeChar(label="Byte")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "Anonymous2": SimUnion({"Version": SimTypeInt(signed=False, label="UInt32"), "Class": SimStruct({"Type": SimTypeChar(label="Byte"), "Level": SimTypeChar(label="Byte"), "Version": SimTypeShort(signed=False, label="UInt16")}, name="_Class_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "ThreadId": SimTypeInt(signed=False, label="UInt32"), "ProcessId": SimTypeInt(signed=False, label="UInt32"), "TimeStamp": SimTypeBottom(label="LARGE_INTEGER"), "Anonymous3": SimUnion({"Guid": SimTypeBottom(label="Guid"), "GuidPtr": SimTypeLongLong(signed=False, label="UInt64")}, name="<anon>", label="None"), "Anonymous4": SimUnion({"Anonymous1": SimStruct({"KernelTime": SimTypeInt(signed=False, label="UInt32"), "UserTime": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous1_e__Struct", pack=False, align=None), "ProcessorTime": SimTypeLongLong(signed=False, label="UInt64"), "Anonymous2": SimStruct({"ClientContext": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous2_e__Struct", pack=False, align=None)}, name="<anon>", label="None")}, name="EVENT_TRACE_HEADER", pack=False, align=None), "InstanceId": SimTypeInt(signed=False, label="UInt32"), "ParentInstanceId": SimTypeInt(signed=False, label="UInt32"), "ParentGuid": SimTypeBottom(label="Guid"), "MofData": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "MofLength": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"ClientContext": SimTypeInt(signed=False, label="UInt32"), "BufferContext": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"ProcessorNumber": SimTypeChar(label="Byte"), "Alignment": SimTypeChar(label="Byte")}, name="_Anonymous_e__Struct", pack=False, align=None), "ProcessorIndex": SimTypeShort(signed=False, label="UInt16")}, name="<anon>", label="None"), "LoggerId": SimTypeShort(signed=False, label="UInt16")}, name="ETW_BUFFER_CONTEXT", pack=False, align=None)}, name="<anon>", label="None")}, name="EVENT_TRACE", pack=False, align=None), "LogfileHeader": SimStruct({"BufferSize": SimTypeInt(signed=False, label="UInt32"), "Anonymous1": SimUnion({"Version": SimTypeInt(signed=False, label="UInt32"), "VersionDetail": SimStruct({"MajorVersion": SimTypeChar(label="Byte"), "MinorVersion": SimTypeChar(label="Byte"), "SubVersion": SimTypeChar(label="Byte"), "SubMinorVersion": SimTypeChar(label="Byte")}, name="_VersionDetail_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "ProviderVersion": SimTypeInt(signed=False, label="UInt32"), "NumberOfProcessors": SimTypeInt(signed=False, label="UInt32"), "EndTime": SimTypeBottom(label="LARGE_INTEGER"), "TimerResolution": SimTypeInt(signed=False, label="UInt32"), "MaximumFileSize": SimTypeInt(signed=False, label="UInt32"), "LogFileMode": SimTypeInt(signed=False, label="UInt32"), "BuffersWritten": SimTypeInt(signed=False, label="UInt32"), "Anonymous2": SimUnion({"LogInstanceGuid": SimTypeBottom(label="Guid"), "Anonymous": SimStruct({"StartBuffers": SimTypeInt(signed=False, label="UInt32"), "PointerSize": SimTypeInt(signed=False, label="UInt32"), "EventsLost": SimTypeInt(signed=False, label="UInt32"), "CpuSpeedInMHz": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "LoggerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "LogFileName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "TimeZone": SimTypeBottom(label="TIME_ZONE_INFORMATION"), "BootTime": SimTypeBottom(label="LARGE_INTEGER"), "PerfFreq": SimTypeBottom(label="LARGE_INTEGER"), "StartTime": SimTypeBottom(label="LARGE_INTEGER"), "ReservedFlags": SimTypeInt(signed=False, label="UInt32"), "BuffersLost": SimTypeInt(signed=False, label="UInt32")}, name="TRACE_LOGFILE_HEADER", pack=False, align=None), "BufferCallback": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="EVENT_TRACE_LOGFILEA"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["Logfile"]), offset=0), "BufferSize": SimTypeInt(signed=False, label="UInt32"), "Filled": SimTypeInt(signed=False, label="UInt32"), "EventsLost": SimTypeInt(signed=False, label="UInt32"), "Anonymous2": SimUnion({"EventCallback": SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"Header": SimStruct({"Size": SimTypeShort(signed=False, label="UInt16"), "Anonymous1": SimUnion({"FieldTypeFlags": SimTypeShort(signed=False, label="UInt16"), "Anonymous": SimStruct({"HeaderType": SimTypeChar(label="Byte"), "MarkerFlags": SimTypeChar(label="Byte")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "Anonymous2": SimUnion({"Version": SimTypeInt(signed=False, label="UInt32"), "Class": SimStruct({"Type": SimTypeChar(label="Byte"), "Level": SimTypeChar(label="Byte"), "Version": SimTypeShort(signed=False, label="UInt16")}, name="_Class_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "ThreadId": SimTypeInt(signed=False, label="UInt32"), "ProcessId": SimTypeInt(signed=False, label="UInt32"), "TimeStamp": SimTypeBottom(label="LARGE_INTEGER"), "Anonymous3": SimUnion({"Guid": SimTypeBottom(label="Guid"), "GuidPtr": SimTypeLongLong(signed=False, label="UInt64")}, name="<anon>", label="None"), "Anonymous4": SimUnion({"Anonymous1": SimStruct({"KernelTime": SimTypeInt(signed=False, label="UInt32"), "UserTime": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous1_e__Struct", pack=False, align=None), "ProcessorTime": SimTypeLongLong(signed=False, label="UInt64"), "Anonymous2": SimStruct({"ClientContext": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous2_e__Struct", pack=False, align=None)}, name="<anon>", label="None")}, name="EVENT_TRACE_HEADER", pack=False, align=None), "InstanceId": SimTypeInt(signed=False, label="UInt32"), "ParentInstanceId": SimTypeInt(signed=False, label="UInt32"), "ParentGuid": SimTypeBottom(label="Guid"), "MofData": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "MofLength": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"ClientContext": SimTypeInt(signed=False, label="UInt32"), "BufferContext": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"ProcessorNumber": SimTypeChar(label="Byte"), "Alignment": SimTypeChar(label="Byte")}, name="_Anonymous_e__Struct", pack=False, align=None), "ProcessorIndex": SimTypeShort(signed=False, label="UInt16")}, name="<anon>", label="None"), "LoggerId": SimTypeShort(signed=False, label="UInt16")}, name="ETW_BUFFER_CONTEXT", pack=False, align=None)}, name="<anon>", label="None")}, name="EVENT_TRACE", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["pEvent"]), offset=0), "EventRecordCallback": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="EVENT_RECORD"), offset=0)], SimTypeBottom(label="Void"), arg_names=["EventRecord"]), offset=0)}, name="<anon>", label="None"), "IsKernelTrace": SimTypeInt(signed=False, label="UInt32"), "Context": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="EVENT_TRACE_LOGFILEA", pack=False, align=None), offset=0)], SimTypeLongLong(signed=False, label="UInt64"), arg_names=["Logfile"]),
        # 
        'SetTraceCallback': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"Header": SimStruct({"Size": SimTypeShort(signed=False, label="UInt16"), "Anonymous1": SimUnion({"FieldTypeFlags": SimTypeShort(signed=False, label="UInt16"), "Anonymous": SimStruct({"HeaderType": SimTypeChar(label="Byte"), "MarkerFlags": SimTypeChar(label="Byte")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "Anonymous2": SimUnion({"Version": SimTypeInt(signed=False, label="UInt32"), "Class": SimStruct({"Type": SimTypeChar(label="Byte"), "Level": SimTypeChar(label="Byte"), "Version": SimTypeShort(signed=False, label="UInt16")}, name="_Class_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "ThreadId": SimTypeInt(signed=False, label="UInt32"), "ProcessId": SimTypeInt(signed=False, label="UInt32"), "TimeStamp": SimTypeBottom(label="LARGE_INTEGER"), "Anonymous3": SimUnion({"Guid": SimTypeBottom(label="Guid"), "GuidPtr": SimTypeLongLong(signed=False, label="UInt64")}, name="<anon>", label="None"), "Anonymous4": SimUnion({"Anonymous1": SimStruct({"KernelTime": SimTypeInt(signed=False, label="UInt32"), "UserTime": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous1_e__Struct", pack=False, align=None), "ProcessorTime": SimTypeLongLong(signed=False, label="UInt64"), "Anonymous2": SimStruct({"ClientContext": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous2_e__Struct", pack=False, align=None)}, name="<anon>", label="None")}, name="EVENT_TRACE_HEADER", pack=False, align=None), "InstanceId": SimTypeInt(signed=False, label="UInt32"), "ParentInstanceId": SimTypeInt(signed=False, label="UInt32"), "ParentGuid": SimTypeBottom(label="Guid"), "MofData": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "MofLength": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"ClientContext": SimTypeInt(signed=False, label="UInt32"), "BufferContext": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"ProcessorNumber": SimTypeChar(label="Byte"), "Alignment": SimTypeChar(label="Byte")}, name="_Anonymous_e__Struct", pack=False, align=None), "ProcessorIndex": SimTypeShort(signed=False, label="UInt16")}, name="<anon>", label="None"), "LoggerId": SimTypeShort(signed=False, label="UInt16")}, name="ETW_BUFFER_CONTEXT", pack=False, align=None)}, name="<anon>", label="None")}, name="EVENT_TRACE", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["pEvent"]), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pGuid", "EventCallback"]),
        # 
        'RemoveTraceCallback': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pGuid"]),
        # 
        'TraceMessage': SimTypeFunction([SimTypeLongLong(signed=False, label="UInt64"), SimTypeInt(signed=False, label="TRACE_MESSAGE_FLAGS"), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeShort(signed=False, label="UInt16")], SimTypeInt(signed=False, label="UInt32"), arg_names=["LoggerHandle", "MessageFlags", "MessageGuid", "MessageNumber"]),
        # 
        'TraceMessageVa': SimTypeFunction([SimTypeLongLong(signed=False, label="UInt64"), SimTypeInt(signed=False, label="TRACE_MESSAGE_FLAGS"), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypeChar(label="SByte"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["LoggerHandle", "MessageFlags", "MessageGuid", "MessageNumber", "MessageArgList"]),
        # 
        'EventRegister': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="ENABLECALLBACK_ENABLED_STATE"), SimTypeChar(label="Byte"), SimTypeLongLong(signed=False, label="UInt64"), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimStruct({"Ptr": SimTypeLongLong(signed=False, label="UInt64"), "Size": SimTypeInt(signed=False, label="UInt32"), "Type": SimTypeInt(signed=False, label="UInt32")}, name="EVENT_FILTER_DESCRIPTOR", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["SourceId", "IsEnabled", "Level", "MatchAnyKeyword", "MatchAllKeyword", "FilterData", "CallbackContext"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ProviderId", "EnableCallback", "CallbackContext", "RegHandle"]),
        # 
        'EventUnregister': SimTypeFunction([SimTypeLongLong(signed=False, label="UInt64")], SimTypeInt(signed=False, label="UInt32"), arg_names=["RegHandle"]),
        # 
        'EventSetInformation': SimTypeFunction([SimTypeLongLong(signed=False, label="UInt64"), SimTypeInt(signed=False, label="EVENT_INFO_CLASS"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["RegHandle", "InformationClass", "EventInformation", "InformationLength"]),
        # 
        'EventEnabled': SimTypeFunction([SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimStruct({"Id": SimTypeShort(signed=False, label="UInt16"), "Version": SimTypeChar(label="Byte"), "Channel": SimTypeChar(label="Byte"), "Level": SimTypeChar(label="Byte"), "Opcode": SimTypeChar(label="Byte"), "Task": SimTypeShort(signed=False, label="UInt16"), "Keyword": SimTypeLongLong(signed=False, label="UInt64")}, name="EVENT_DESCRIPTOR", pack=False, align=None), offset=0)], SimTypeChar(label="Byte"), arg_names=["RegHandle", "EventDescriptor"]),
        # 
        'EventProviderEnabled': SimTypeFunction([SimTypeLongLong(signed=False, label="UInt64"), SimTypeChar(label="Byte"), SimTypeLongLong(signed=False, label="UInt64")], SimTypeChar(label="Byte"), arg_names=["RegHandle", "Level", "Keyword"]),
        # 
        'EventWrite': SimTypeFunction([SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimStruct({"Id": SimTypeShort(signed=False, label="UInt16"), "Version": SimTypeChar(label="Byte"), "Channel": SimTypeChar(label="Byte"), "Level": SimTypeChar(label="Byte"), "Opcode": SimTypeChar(label="Byte"), "Task": SimTypeShort(signed=False, label="UInt16"), "Keyword": SimTypeLongLong(signed=False, label="UInt64")}, name="EVENT_DESCRIPTOR", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Ptr": SimTypeLongLong(signed=False, label="UInt64"), "Size": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"Reserved": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimStruct({"Type": SimTypeChar(label="Byte"), "Reserved1": SimTypeChar(label="Byte"), "Reserved2": SimTypeShort(signed=False, label="UInt16")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None")}, name="EVENT_DATA_DESCRIPTOR", pack=False, align=None), label="LPArray", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RegHandle", "EventDescriptor", "UserDataCount", "UserData"]),
        # 
        'EventWriteTransfer': SimTypeFunction([SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimStruct({"Id": SimTypeShort(signed=False, label="UInt16"), "Version": SimTypeChar(label="Byte"), "Channel": SimTypeChar(label="Byte"), "Level": SimTypeChar(label="Byte"), "Opcode": SimTypeChar(label="Byte"), "Task": SimTypeShort(signed=False, label="UInt16"), "Keyword": SimTypeLongLong(signed=False, label="UInt64")}, name="EVENT_DESCRIPTOR", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Ptr": SimTypeLongLong(signed=False, label="UInt64"), "Size": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"Reserved": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimStruct({"Type": SimTypeChar(label="Byte"), "Reserved1": SimTypeChar(label="Byte"), "Reserved2": SimTypeShort(signed=False, label="UInt16")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None")}, name="EVENT_DATA_DESCRIPTOR", pack=False, align=None), label="LPArray", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RegHandle", "EventDescriptor", "ActivityId", "RelatedActivityId", "UserDataCount", "UserData"]),
        # 
        'EventWriteEx': SimTypeFunction([SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimStruct({"Id": SimTypeShort(signed=False, label="UInt16"), "Version": SimTypeChar(label="Byte"), "Channel": SimTypeChar(label="Byte"), "Level": SimTypeChar(label="Byte"), "Opcode": SimTypeChar(label="Byte"), "Task": SimTypeShort(signed=False, label="UInt16"), "Keyword": SimTypeLongLong(signed=False, label="UInt64")}, name="EVENT_DESCRIPTOR", pack=False, align=None), offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Ptr": SimTypeLongLong(signed=False, label="UInt64"), "Size": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"Reserved": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimStruct({"Type": SimTypeChar(label="Byte"), "Reserved1": SimTypeChar(label="Byte"), "Reserved2": SimTypeShort(signed=False, label="UInt16")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None")}, name="EVENT_DATA_DESCRIPTOR", pack=False, align=None), label="LPArray", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RegHandle", "EventDescriptor", "Filter", "Flags", "ActivityId", "RelatedActivityId", "UserDataCount", "UserData"]),
        # 
        'EventWriteString': SimTypeFunction([SimTypeLongLong(signed=False, label="UInt64"), SimTypeChar(label="Byte"), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RegHandle", "Level", "Keyword", "String"]),
        # 
        'EventActivityIdControl': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Guid"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ControlCode", "ActivityId"]),
        # 
        'EventAccessControl': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeChar(label="Byte")], SimTypeInt(signed=False, label="UInt32"), arg_names=["Guid", "Operation", "Sid", "Rights", "AllowOrDeny"]),
        # 
        'EventAccessQuery': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["Guid", "Buffer", "BufferSize"]),
        # 
        'EventAccessRemove': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["Guid"]),
        # 
        'CveEventWrite': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["CveId", "AdditionalDetails"]),
        # 
        'ClearEventLogA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hEventLog", "lpBackupFileName"]),
        # 
        'ClearEventLogW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hEventLog", "lpBackupFileName"]),
        # 
        'BackupEventLogA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hEventLog", "lpBackupFileName"]),
        # 
        'BackupEventLogW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hEventLog", "lpBackupFileName"]),
        # 
        'CloseEventLog': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hEventLog"]),
        # 
        'DeregisterEventSource': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hEventLog"]),
        # 
        'NotifyChangeEventLog': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hEventLog", "hEvent"]),
        # 
        'GetNumberOfEventLogRecords': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hEventLog", "NumberOfRecords"]),
        # 
        'GetOldestEventLogRecord': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hEventLog", "OldestRecord"]),
        # 
        'OpenEventLogA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["lpUNCServerName", "lpSourceName"]),
        # 
        'OpenEventLogW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["lpUNCServerName", "lpSourceName"]),
        # 
        'RegisterEventSourceA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["lpUNCServerName", "lpSourceName"]),
        # 
        'RegisterEventSourceW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["lpUNCServerName", "lpSourceName"]),
        # 
        'OpenBackupEventLogA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["lpUNCServerName", "lpFileName"]),
        # 
        'OpenBackupEventLogW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["lpUNCServerName", "lpFileName"]),
        # 
        'ReadEventLogA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="READ_EVENT_LOG_READ_FLAGS"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hEventLog", "dwReadFlags", "dwRecordOffset", "lpBuffer", "nNumberOfBytesToRead", "pnBytesRead", "pnMinNumberOfBytesNeeded"]),
        # 
        'ReadEventLogW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="READ_EVENT_LOG_READ_FLAGS"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hEventLog", "dwReadFlags", "dwRecordOffset", "lpBuffer", "nNumberOfBytesToRead", "pnBytesRead", "pnMinNumberOfBytesNeeded"]),
        # 
        'ReportEventA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="REPORT_EVENT_TYPE"), SimTypeShort(signed=False, label="UInt16"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), label="LPArray", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hEventLog", "wType", "wCategory", "dwEventID", "lpUserSid", "wNumStrings", "dwDataSize", "lpStrings", "lpRawData"]),
        # 
        'ReportEventW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="REPORT_EVENT_TYPE"), SimTypeShort(signed=False, label="UInt16"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), label="LPArray", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hEventLog", "wType", "wCategory", "dwEventID", "lpUserSid", "wNumStrings", "dwDataSize", "lpStrings", "lpRawData"]),
        # 
        'GetEventLogInformation': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hEventLog", "dwInfoLevel", "lpBuffer", "cbBufSize", "pcbBytesNeeded"]),
        # 
        'InstallApplication': SimTypeFunction([SimTypePointer(SimStruct({"Type": SimTypeInt(signed=False, label="INSTALLSPECTYPE"), "Spec": SimUnion({"AppName": SimStruct({"Name": SimTypePointer(SimTypeChar(label="Char"), offset=0), "GPOId": SimTypeBottom(label="Guid")}, name="_AppName_e__Struct", pack=False, align=None), "FileExt": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ProgId": SimTypePointer(SimTypeChar(label="Char"), offset=0), "COMClass": SimStruct({"Clsid": SimTypeBottom(label="Guid"), "ClsCtx": SimTypeInt(signed=False, label="UInt32")}, name="_COMClass_e__Struct", pack=False, align=None)}, name="<anon>", label="None")}, name="INSTALLDATA", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pInstallInfo"]),
        # 
        'UninstallApplication': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["ProductCode", "dwStatus"]),
        # 
        'CommandLineFromMsiDescriptor': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["Descriptor", "CommandLine", "CommandLineLength"]),
        # 
        'GetManagedApplications': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"pszPackageName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pszPublisher": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwVersionHi": SimTypeInt(signed=False, label="UInt32"), "dwVersionLo": SimTypeInt(signed=False, label="UInt32"), "dwRevision": SimTypeInt(signed=False, label="UInt32"), "GpoId": SimTypeBottom(label="Guid"), "pszPolicyName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ProductId": SimTypeBottom(label="Guid"), "Language": SimTypeShort(signed=False, label="UInt16"), "pszOwner": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pszCompany": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pszComments": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pszContact": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pszSupportUrl": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwPathType": SimTypeInt(signed=False, label="UInt32"), "bInstalled": SimTypeInt(signed=True, label="Int32")}, name="MANAGEDAPPLICATION", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pCategory", "dwQueryFlags", "dwInfoLevel", "pdwApps", "prgManagedApps"]),
        # 
        'GetLocalManagedApplications': SimTypeFunction([SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"pszDeploymentName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pszPolicyName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pszProductId": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwState": SimTypeInt(signed=False, label="UInt32")}, name="LOCALMANAGEDAPPLICATION", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["bUserApps", "pdwApps", "prgLocalApps"]),
        # 
        'GetLocalManagedApplicationData': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)], SimTypeBottom(label="Void"), arg_names=["ProductCode", "DisplayName", "SupportUrl"]),
        # 
        'GetManagedApplicationCategories': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"cCategory": SimTypeInt(signed=False, label="UInt32"), "pCategoryInfo": SimTypePointer(SimStruct({"Locale": SimTypeInt(signed=False, label="UInt32"), "pszDescription": SimTypePointer(SimTypeChar(label="Char"), offset=0), "AppCategoryId": SimTypeBottom(label="Guid")}, name="APPCATEGORYINFO", pack=False, align=None), offset=0)}, name="APPCATEGORYINFOLIST", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["dwReserved", "pAppCategory"]),
        # 
        'MSChapSrvChangePassword': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeChar(label="Byte"), SimTypePointer(SimStruct({"data": SimTypeFixedSizeArray(SimStruct({"data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 8)}, name="CYPHER_BLOCK", pack=False, align=None), 2)}, name="LM_OWF_PASSWORD", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"data": SimTypeFixedSizeArray(SimStruct({"data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 8)}, name="CYPHER_BLOCK", pack=False, align=None), 2)}, name="LM_OWF_PASSWORD", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"data": SimTypeFixedSizeArray(SimStruct({"data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 8)}, name="CYPHER_BLOCK", pack=False, align=None), 2)}, name="LM_OWF_PASSWORD", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"data": SimTypeFixedSizeArray(SimStruct({"data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 8)}, name="CYPHER_BLOCK", pack=False, align=None), 2)}, name="LM_OWF_PASSWORD", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerName", "UserName", "LmOldPresent", "LmOldOwfPassword", "LmNewOwfPassword", "NtOldOwfPassword", "NtNewOwfPassword"]),
        # 
        'MSChapSrvChangePassword2': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"Buffer": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 516)}, name="SAMPR_ENCRYPTED_USER_PASSWORD", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"data": SimTypeFixedSizeArray(SimStruct({"data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 8)}, name="CYPHER_BLOCK", pack=False, align=None), 2)}, name="ENCRYPTED_LM_OWF_PASSWORD", pack=False, align=None), offset=0), SimTypeChar(label="Byte"), SimTypePointer(SimStruct({"Buffer": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 516)}, name="SAMPR_ENCRYPTED_USER_PASSWORD", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"data": SimTypeFixedSizeArray(SimStruct({"data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 8)}, name="CYPHER_BLOCK", pack=False, align=None), 2)}, name="ENCRYPTED_LM_OWF_PASSWORD", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ServerName", "UserName", "NewPasswordEncryptedWithOldNt", "OldNtOwfPasswordEncryptedWithNewNt", "LmPresent", "NewPasswordEncryptedWithOldLm", "OldLmOwfPasswordEncryptedWithNewLmOrNt"]),
        # 
        'PerfStartProvider': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["RequestCode", "Buffer", "BufferSize"]), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ProviderGuid", "ControlCallback", "phProvider"]),
        # 
        'PerfStartProviderEx': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimStruct({"ContextSize": SimTypeInt(signed=False, label="UInt32"), "Reserved": SimTypeInt(signed=False, label="UInt32"), "ControlCallback": SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["RequestCode", "Buffer", "BufferSize"]), offset=0), "MemAllocRoutine": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["AllocSize", "pContext"]), offset=0), "MemFreeRoutine": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pBuffer", "pContext"]), offset=0), "pMemContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="PERF_PROVIDER_CONTEXT", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ProviderGuid", "ProviderContext", "Provider"]),
        # 
        'PerfStopProvider': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ProviderHandle"]),
        # 
        'PerfSetCounterSetInfo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"CounterSetGuid": SimTypeBottom(label="Guid"), "ProviderGuid": SimTypeBottom(label="Guid"), "NumCounters": SimTypeInt(signed=False, label="UInt32"), "InstanceType": SimTypeInt(signed=False, label="UInt32")}, name="PERF_COUNTERSET_INFO", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["ProviderHandle", "Template", "TemplateSize"]),
        # 
        'PerfCreateInstance': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimStruct({"CounterSetGuid": SimTypeBottom(label="Guid"), "dwSize": SimTypeInt(signed=False, label="UInt32"), "InstanceId": SimTypeInt(signed=False, label="UInt32"), "InstanceNameOffset": SimTypeInt(signed=False, label="UInt32"), "InstanceNameSize": SimTypeInt(signed=False, label="UInt32")}, name="PERF_COUNTERSET_INSTANCE", pack=False, align=None), offset=0), arg_names=["ProviderHandle", "CounterSetGuid", "Name", "Id"]),
        # 
        'PerfDeleteInstance': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"CounterSetGuid": SimTypeBottom(label="Guid"), "dwSize": SimTypeInt(signed=False, label="UInt32"), "InstanceId": SimTypeInt(signed=False, label="UInt32"), "InstanceNameOffset": SimTypeInt(signed=False, label="UInt32"), "InstanceNameSize": SimTypeInt(signed=False, label="UInt32")}, name="PERF_COUNTERSET_INSTANCE", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["Provider", "InstanceBlock"]),
        # 
        'PerfQueryInstance': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimStruct({"CounterSetGuid": SimTypeBottom(label="Guid"), "dwSize": SimTypeInt(signed=False, label="UInt32"), "InstanceId": SimTypeInt(signed=False, label="UInt32"), "InstanceNameOffset": SimTypeInt(signed=False, label="UInt32"), "InstanceNameSize": SimTypeInt(signed=False, label="UInt32")}, name="PERF_COUNTERSET_INSTANCE", pack=False, align=None), offset=0), arg_names=["ProviderHandle", "CounterSetGuid", "Name", "Id"]),
        # 
        'PerfSetCounterRefValue': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"CounterSetGuid": SimTypeBottom(label="Guid"), "dwSize": SimTypeInt(signed=False, label="UInt32"), "InstanceId": SimTypeInt(signed=False, label="UInt32"), "InstanceNameOffset": SimTypeInt(signed=False, label="UInt32"), "InstanceNameSize": SimTypeInt(signed=False, label="UInt32")}, name="PERF_COUNTERSET_INSTANCE", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["Provider", "Instance", "CounterId", "Address"]),
        # 
        'PerfSetULongCounterValue': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"CounterSetGuid": SimTypeBottom(label="Guid"), "dwSize": SimTypeInt(signed=False, label="UInt32"), "InstanceId": SimTypeInt(signed=False, label="UInt32"), "InstanceNameOffset": SimTypeInt(signed=False, label="UInt32"), "InstanceNameSize": SimTypeInt(signed=False, label="UInt32")}, name="PERF_COUNTERSET_INSTANCE", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["Provider", "Instance", "CounterId", "Value"]),
        # 
        'PerfSetULongLongCounterValue': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"CounterSetGuid": SimTypeBottom(label="Guid"), "dwSize": SimTypeInt(signed=False, label="UInt32"), "InstanceId": SimTypeInt(signed=False, label="UInt32"), "InstanceNameOffset": SimTypeInt(signed=False, label="UInt32"), "InstanceNameSize": SimTypeInt(signed=False, label="UInt32")}, name="PERF_COUNTERSET_INSTANCE", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeLongLong(signed=False, label="UInt64")], SimTypeInt(signed=False, label="UInt32"), arg_names=["Provider", "Instance", "CounterId", "Value"]),
        # 
        'PerfIncrementULongCounterValue': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"CounterSetGuid": SimTypeBottom(label="Guid"), "dwSize": SimTypeInt(signed=False, label="UInt32"), "InstanceId": SimTypeInt(signed=False, label="UInt32"), "InstanceNameOffset": SimTypeInt(signed=False, label="UInt32"), "InstanceNameSize": SimTypeInt(signed=False, label="UInt32")}, name="PERF_COUNTERSET_INSTANCE", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["Provider", "Instance", "CounterId", "Value"]),
        # 
        'PerfIncrementULongLongCounterValue': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"CounterSetGuid": SimTypeBottom(label="Guid"), "dwSize": SimTypeInt(signed=False, label="UInt32"), "InstanceId": SimTypeInt(signed=False, label="UInt32"), "InstanceNameOffset": SimTypeInt(signed=False, label="UInt32"), "InstanceNameSize": SimTypeInt(signed=False, label="UInt32")}, name="PERF_COUNTERSET_INSTANCE", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeLongLong(signed=False, label="UInt64")], SimTypeInt(signed=False, label="UInt32"), arg_names=["Provider", "Instance", "CounterId", "Value"]),
        # 
        'PerfDecrementULongCounterValue': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"CounterSetGuid": SimTypeBottom(label="Guid"), "dwSize": SimTypeInt(signed=False, label="UInt32"), "InstanceId": SimTypeInt(signed=False, label="UInt32"), "InstanceNameOffset": SimTypeInt(signed=False, label="UInt32"), "InstanceNameSize": SimTypeInt(signed=False, label="UInt32")}, name="PERF_COUNTERSET_INSTANCE", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["Provider", "Instance", "CounterId", "Value"]),
        # 
        'PerfDecrementULongLongCounterValue': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"CounterSetGuid": SimTypeBottom(label="Guid"), "dwSize": SimTypeInt(signed=False, label="UInt32"), "InstanceId": SimTypeInt(signed=False, label="UInt32"), "InstanceNameOffset": SimTypeInt(signed=False, label="UInt32"), "InstanceNameSize": SimTypeInt(signed=False, label="UInt32")}, name="PERF_COUNTERSET_INSTANCE", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeLongLong(signed=False, label="UInt64")], SimTypeInt(signed=False, label="UInt32"), arg_names=["Provider", "Instance", "CounterId", "Value"]),
        # 
        'PerfEnumerateCounterSet': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["szMachine", "pCounterSetIds", "cCounterSetIds", "pcCounterSetIdsActual"]),
        # 
        'PerfEnumerateCounterSetInstances': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimStruct({"Size": SimTypeInt(signed=False, label="UInt32"), "InstanceId": SimTypeInt(signed=False, label="UInt32")}, name="PERF_INSTANCE_HEADER", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["szMachine", "pCounterSetId", "pInstances", "cbInstances", "pcbInstancesActual"]),
        # 
        'PerfQueryCounterSetRegistrationInfo': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="PerfRegInfoType"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["szMachine", "pCounterSetId", "requestCode", "requestLangId", "pbRegInfo", "cbRegInfo", "pcbRegInfoActual"]),
        # 
        'PerfOpenQueryHandle': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["szMachine", "phQuery"]),
        # 
        'PerfCloseQueryHandle': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hQuery"]),
        # 
        'PerfQueryCounterInfo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"CounterSetGuid": SimTypeBottom(label="Guid"), "Status": SimTypeInt(signed=False, label="UInt32"), "Size": SimTypeInt(signed=False, label="UInt32"), "CounterId": SimTypeInt(signed=False, label="UInt32"), "InstanceId": SimTypeInt(signed=False, label="UInt32"), "Index": SimTypeInt(signed=False, label="UInt32"), "Reserved": SimTypeInt(signed=False, label="UInt32")}, name="PERF_COUNTER_IDENTIFIER", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hQuery", "pCounters", "cbCounters", "pcbCountersActual"]),
        # 
        'PerfQueryCounterData': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNumCounters": SimTypeInt(signed=False, label="UInt32"), "PerfTimeStamp": SimTypeLongLong(signed=True, label="Int64"), "PerfTime100NSec": SimTypeLongLong(signed=True, label="Int64"), "PerfFreq": SimTypeLongLong(signed=True, label="Int64"), "SystemTime": SimStruct({"wYear": SimTypeShort(signed=False, label="UInt16"), "wMonth": SimTypeShort(signed=False, label="UInt16"), "wDayOfWeek": SimTypeShort(signed=False, label="UInt16"), "wDay": SimTypeShort(signed=False, label="UInt16"), "wHour": SimTypeShort(signed=False, label="UInt16"), "wMinute": SimTypeShort(signed=False, label="UInt16"), "wSecond": SimTypeShort(signed=False, label="UInt16"), "wMilliseconds": SimTypeShort(signed=False, label="UInt16")}, name="SYSTEMTIME", pack=False, align=None)}, name="PERF_DATA_HEADER", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hQuery", "pCounterBlock", "cbCounterBlock", "pcbCounterBlockActual"]),
        # 
        'PerfAddCounters': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"CounterSetGuid": SimTypeBottom(label="Guid"), "Status": SimTypeInt(signed=False, label="UInt32"), "Size": SimTypeInt(signed=False, label="UInt32"), "CounterId": SimTypeInt(signed=False, label="UInt32"), "InstanceId": SimTypeInt(signed=False, label="UInt32"), "Index": SimTypeInt(signed=False, label="UInt32"), "Reserved": SimTypeInt(signed=False, label="UInt32")}, name="PERF_COUNTER_IDENTIFIER", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hQuery", "pCounters", "cbCounters"]),
        # 
        'PerfDeleteCounters': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"CounterSetGuid": SimTypeBottom(label="Guid"), "Status": SimTypeInt(signed=False, label="UInt32"), "Size": SimTypeInt(signed=False, label="UInt32"), "CounterId": SimTypeInt(signed=False, label="UInt32"), "InstanceId": SimTypeInt(signed=False, label="UInt32"), "Index": SimTypeInt(signed=False, label="UInt32"), "Reserved": SimTypeInt(signed=False, label="UInt32")}, name="PERF_COUNTER_IDENTIFIER", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hQuery", "pCounters", "cbCounters"]),
        # 
        'ImpersonateNamedPipeClient': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hNamedPipe"]),
        # 
        'RegCloseKey': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey"]),
        # 
        'RegOverridePredefKey': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "hNewHKey"]),
        # 
        'RegOpenUserClassesRoot': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hToken", "dwOptions", "samDesired", "phkResult"]),
        # 
        'RegOpenCurrentUser': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["samDesired", "phkResult"]),
        # 
        'RegDisablePredefinedCache': SimTypeFunction([], SimTypeInt(signed=True, label="Int32")),
        # 
        'RegDisablePredefinedCacheEx': SimTypeFunction([], SimTypeInt(signed=True, label="Int32")),
        # 
        'RegConnectRegistryA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpMachineName", "hKey", "phkResult"]),
        # 
        'RegConnectRegistryW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpMachineName", "hKey", "phkResult"]),
        # 
        'RegConnectRegistryExA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpMachineName", "hKey", "Flags", "phkResult"]),
        # 
        'RegConnectRegistryExW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpMachineName", "hKey", "Flags", "phkResult"]),
        # 
        'RegCreateKeyA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "lpSubKey", "phkResult"]),
        # 
        'RegCreateKeyW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "lpSubKey", "phkResult"]),
        # 
        'RegCreateKeyExA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="REG_OPEN_CREATE_OPTIONS"), SimTypeInt(signed=False, label="REG_SAM_FLAGS"), SimTypePointer(SimStruct({"nLength": SimTypeInt(signed=False, label="UInt32"), "lpSecurityDescriptor": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "bInheritHandle": SimTypeInt(signed=True, label="Int32")}, name="SECURITY_ATTRIBUTES", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="REG_CREATE_KEY_DISPOSITION"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "lpSubKey", "Reserved", "lpClass", "dwOptions", "samDesired", "lpSecurityAttributes", "phkResult", "lpdwDisposition"]),
        # 
        'RegCreateKeyExW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="REG_OPEN_CREATE_OPTIONS"), SimTypeInt(signed=False, label="REG_SAM_FLAGS"), SimTypePointer(SimStruct({"nLength": SimTypeInt(signed=False, label="UInt32"), "lpSecurityDescriptor": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "bInheritHandle": SimTypeInt(signed=True, label="Int32")}, name="SECURITY_ATTRIBUTES", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="REG_CREATE_KEY_DISPOSITION"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "lpSubKey", "Reserved", "lpClass", "dwOptions", "samDesired", "lpSecurityAttributes", "phkResult", "lpdwDisposition"]),
        # 
        'RegCreateKeyTransactedA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="REG_OPEN_CREATE_OPTIONS"), SimTypeInt(signed=False, label="REG_SAM_FLAGS"), SimTypePointer(SimStruct({"nLength": SimTypeInt(signed=False, label="UInt32"), "lpSecurityDescriptor": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "bInheritHandle": SimTypeInt(signed=True, label="Int32")}, name="SECURITY_ATTRIBUTES", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="REG_CREATE_KEY_DISPOSITION"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "lpSubKey", "Reserved", "lpClass", "dwOptions", "samDesired", "lpSecurityAttributes", "phkResult", "lpdwDisposition", "hTransaction", "pExtendedParemeter"]),
        # 
        'RegCreateKeyTransactedW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="REG_OPEN_CREATE_OPTIONS"), SimTypeInt(signed=False, label="REG_SAM_FLAGS"), SimTypePointer(SimStruct({"nLength": SimTypeInt(signed=False, label="UInt32"), "lpSecurityDescriptor": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "bInheritHandle": SimTypeInt(signed=True, label="Int32")}, name="SECURITY_ATTRIBUTES", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="REG_CREATE_KEY_DISPOSITION"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "lpSubKey", "Reserved", "lpClass", "dwOptions", "samDesired", "lpSecurityAttributes", "phkResult", "lpdwDisposition", "hTransaction", "pExtendedParemeter"]),
        # 
        'RegDeleteKeyA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "lpSubKey"]),
        # 
        'RegDeleteKeyW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "lpSubKey"]),
        # 
        'RegDeleteKeyExA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "lpSubKey", "samDesired", "Reserved"]),
        # 
        'RegDeleteKeyExW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "lpSubKey", "samDesired", "Reserved"]),
        # 
        'RegDeleteKeyTransactedA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "lpSubKey", "samDesired", "Reserved", "hTransaction", "pExtendedParameter"]),
        # 
        'RegDeleteKeyTransactedW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "lpSubKey", "samDesired", "Reserved", "hTransaction", "pExtendedParameter"]),
        # 
        'RegDisableReflectionKey': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hBase"]),
        # 
        'RegEnableReflectionKey': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hBase"]),
        # 
        'RegQueryReflectionKey': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hBase", "bIsReflectionDisabled"]),
        # 
        'RegDeleteValueA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "lpValueName"]),
        # 
        'RegDeleteValueW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "lpValueName"]),
        # 
        'RegEnumKeyA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "dwIndex", "lpName", "cchName"]),
        # 
        'RegEnumKeyW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "dwIndex", "lpName", "cchName"]),
        # 
        'RegEnumKeyExA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "dwIndex", "lpName", "lpcchName", "lpReserved", "lpClass", "lpcchClass", "lpftLastWriteTime"]),
        # 
        'RegEnumKeyExW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "dwIndex", "lpName", "lpcchName", "lpReserved", "lpClass", "lpcchClass", "lpftLastWriteTime"]),
        # 
        'RegEnumValueA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "dwIndex", "lpValueName", "lpcchValueName", "lpReserved", "lpType", "lpData", "lpcbData"]),
        # 
        'RegEnumValueW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "dwIndex", "lpValueName", "lpcchValueName", "lpReserved", "lpType", "lpData", "lpcbData"]),
        # 
        'RegFlushKey': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey"]),
        # 
        'RegGetKeySecurity': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "SecurityInformation", "pSecurityDescriptor", "lpcbSecurityDescriptor"]),
        # 
        'RegLoadKeyA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "lpSubKey", "lpFile"]),
        # 
        'RegLoadKeyW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "lpSubKey", "lpFile"]),
        # 
        'RegNotifyChangeKeyValue': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="REG_NOTIFY_FILTER"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "bWatchSubtree", "dwNotifyFilter", "hEvent", "fAsynchronous"]),
        # 
        'RegOpenKeyA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "lpSubKey", "phkResult"]),
        # 
        'RegOpenKeyW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "lpSubKey", "phkResult"]),
        # 
        'RegOpenKeyExA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="REG_SAM_FLAGS"), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "lpSubKey", "ulOptions", "samDesired", "phkResult"]),
        # 
        'RegOpenKeyExW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="REG_SAM_FLAGS"), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "lpSubKey", "ulOptions", "samDesired", "phkResult"]),
        # 
        'RegOpenKeyTransactedA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="REG_SAM_FLAGS"), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "lpSubKey", "ulOptions", "samDesired", "phkResult", "hTransaction", "pExtendedParemeter"]),
        # 
        'RegOpenKeyTransactedW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="REG_SAM_FLAGS"), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "lpSubKey", "ulOptions", "samDesired", "phkResult", "hTransaction", "pExtendedParemeter"]),
        # 
        'RegQueryInfoKeyA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "lpClass", "lpcchClass", "lpReserved", "lpcSubKeys", "lpcbMaxSubKeyLen", "lpcbMaxClassLen", "lpcValues", "lpcbMaxValueNameLen", "lpcbMaxValueLen", "lpcbSecurityDescriptor", "lpftLastWriteTime"]),
        # 
        'RegQueryInfoKeyW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "lpClass", "lpcchClass", "lpReserved", "lpcSubKeys", "lpcbMaxSubKeyLen", "lpcbMaxClassLen", "lpcValues", "lpcbMaxValueNameLen", "lpcbMaxValueLen", "lpcbSecurityDescriptor", "lpftLastWriteTime"]),
        # 
        'RegQueryValueA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "lpSubKey", "lpData", "lpcbData"]),
        # 
        'RegQueryValueW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "lpSubKey", "lpData", "lpcbData"]),
        # 
        'RegQueryMultipleValuesA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"ve_valuename": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "ve_valuelen": SimTypeInt(signed=False, label="UInt32"), "ve_valueptr": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "ve_type": SimTypeInt(signed=False, label="REG_VALUE_TYPE")}, name="VALENTA", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "val_list", "num_vals", "lpValueBuf", "ldwTotsize"]),
        # 
        'RegQueryMultipleValuesW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"ve_valuename": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ve_valuelen": SimTypeInt(signed=False, label="UInt32"), "ve_valueptr": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "ve_type": SimTypeInt(signed=False, label="REG_VALUE_TYPE")}, name="VALENTW", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "val_list", "num_vals", "lpValueBuf", "ldwTotsize"]),
        # 
        'RegQueryValueExA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="REG_VALUE_TYPE"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "lpValueName", "lpReserved", "lpType", "lpData", "lpcbData"]),
        # 
        'RegQueryValueExW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="REG_VALUE_TYPE"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "lpValueName", "lpReserved", "lpType", "lpData", "lpcbData"]),
        # 
        'RegReplaceKeyA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "lpSubKey", "lpNewFile", "lpOldFile"]),
        # 
        'RegReplaceKeyW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "lpSubKey", "lpNewFile", "lpOldFile"]),
        # 
        'RegRestoreKeyA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="REG_RESTORE_KEY_FLAGS")], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "lpFile", "dwFlags"]),
        # 
        'RegRestoreKeyW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="REG_RESTORE_KEY_FLAGS")], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "lpFile", "dwFlags"]),
        # 
        'RegRenameKey': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "lpSubKeyName", "lpNewKeyName"]),
        # 
        'RegSaveKeyA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"nLength": SimTypeInt(signed=False, label="UInt32"), "lpSecurityDescriptor": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "bInheritHandle": SimTypeInt(signed=True, label="Int32")}, name="SECURITY_ATTRIBUTES", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "lpFile", "lpSecurityAttributes"]),
        # 
        'RegSaveKeyW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"nLength": SimTypeInt(signed=False, label="UInt32"), "lpSecurityDescriptor": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "bInheritHandle": SimTypeInt(signed=True, label="Int32")}, name="SECURITY_ATTRIBUTES", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "lpFile", "lpSecurityAttributes"]),
        # 
        'RegSetKeySecurity': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "SecurityInformation", "pSecurityDescriptor"]),
        # 
        'RegSetValueA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="REG_VALUE_TYPE"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "lpSubKey", "dwType", "lpData", "cbData"]),
        # 
        'RegSetValueW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="REG_VALUE_TYPE"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "lpSubKey", "dwType", "lpData", "cbData"]),
        # 
        'RegSetValueExA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="REG_VALUE_TYPE"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "lpValueName", "Reserved", "dwType", "lpData", "cbData"]),
        # 
        'RegSetValueExW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="REG_VALUE_TYPE"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "lpValueName", "Reserved", "dwType", "lpData", "cbData"]),
        # 
        'RegUnLoadKeyA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "lpSubKey"]),
        # 
        'RegUnLoadKeyW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "lpSubKey"]),
        # 
        'RegDeleteKeyValueA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "lpSubKey", "lpValueName"]),
        # 
        'RegDeleteKeyValueW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "lpSubKey", "lpValueName"]),
        # 
        'RegSetKeyValueA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "lpSubKey", "lpValueName", "dwType", "lpData", "cbData"]),
        # 
        'RegSetKeyValueW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "lpSubKey", "lpValueName", "dwType", "lpData", "cbData"]),
        # 
        'RegDeleteTreeA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "lpSubKey"]),
        # 
        'RegDeleteTreeW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "lpSubKey"]),
        # 
        'RegCopyTreeA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hKeySrc", "lpSubKey", "hKeyDest"]),
        # 
        'RegGetValueA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="RRF_RT"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hkey", "lpSubKey", "lpValue", "dwFlags", "pdwType", "pvData", "pcbData"]),
        # 
        'RegGetValueW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="RRF_RT"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hkey", "lpSubKey", "lpValue", "dwFlags", "pdwType", "pvData", "pcbData"]),
        # 
        'RegCopyTreeW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hKeySrc", "lpSubKey", "hKeyDest"]),
        # 
        'RegLoadMUIStringA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "pszValue", "pszOutBuf", "cbOutBuf", "pcbData", "Flags", "pszDirectory"]),
        # 
        'RegLoadMUIStringW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "pszValue", "pszOutBuf", "cbOutBuf", "pcbData", "Flags", "pszDirectory"]),
        # 
        'RegLoadAppKeyA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["lpFile", "phkResult", "samDesired", "dwOptions", "Reserved"]),
        # 
        'RegLoadAppKeyW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["lpFile", "phkResult", "samDesired", "dwOptions", "Reserved"]),
        # 
        'RegSaveKeyExA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"nLength": SimTypeInt(signed=False, label="UInt32"), "lpSecurityDescriptor": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "bInheritHandle": SimTypeInt(signed=True, label="Int32")}, name="SECURITY_ATTRIBUTES", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="REG_SAVE_FORMAT")], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "lpFile", "lpSecurityAttributes", "Flags"]),
        # 
        'RegSaveKeyExW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"nLength": SimTypeInt(signed=False, label="UInt32"), "lpSecurityDescriptor": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "bInheritHandle": SimTypeInt(signed=True, label="Int32")}, name="SECURITY_ATTRIBUTES", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="REG_SAVE_FORMAT")], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "lpFile", "lpSecurityAttributes", "Flags"]),
        # 
        'SetServiceBits': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hServiceStatus", "dwServiceBits", "bSetBitsOn", "bUpdateImmediately"]),
        # 
        'ChangeServiceConfigA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="SERVICE_START_TYPE"), SimTypeInt(signed=False, label="SERVICE_ERROR"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hService", "dwServiceType", "dwStartType", "dwErrorControl", "lpBinaryPathName", "lpLoadOrderGroup", "lpdwTagId", "lpDependencies", "lpServiceStartName", "lpPassword", "lpDisplayName"]),
        # 
        'ChangeServiceConfigW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="SERVICE_START_TYPE"), SimTypeInt(signed=False, label="SERVICE_ERROR"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hService", "dwServiceType", "dwStartType", "dwErrorControl", "lpBinaryPathName", "lpLoadOrderGroup", "lpdwTagId", "lpDependencies", "lpServiceStartName", "lpPassword", "lpDisplayName"]),
        # 
        'ChangeServiceConfig2A': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="SERVICE_CONFIG"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hService", "dwInfoLevel", "lpInfo"]),
        # 
        'ChangeServiceConfig2W': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="SERVICE_CONFIG"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hService", "dwInfoLevel", "lpInfo"]),
        # 
        'CloseServiceHandle': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hSCObject"]),
        # 
        'ControlService': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwServiceType": SimTypeInt(signed=False, label="ENUM_SERVICE_TYPE"), "dwCurrentState": SimTypeInt(signed=False, label="SERVICE_STATUS_CURRENT_STATE"), "dwControlsAccepted": SimTypeInt(signed=False, label="UInt32"), "dwWin32ExitCode": SimTypeInt(signed=False, label="UInt32"), "dwServiceSpecificExitCode": SimTypeInt(signed=False, label="UInt32"), "dwCheckPoint": SimTypeInt(signed=False, label="UInt32"), "dwWaitHint": SimTypeInt(signed=False, label="UInt32")}, name="SERVICE_STATUS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hService", "dwControl", "lpServiceStatus"]),
        # 
        'CreateServiceA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="ENUM_SERVICE_TYPE"), SimTypeInt(signed=False, label="SERVICE_START_TYPE"), SimTypeInt(signed=False, label="SERVICE_ERROR"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hSCManager", "lpServiceName", "lpDisplayName", "dwDesiredAccess", "dwServiceType", "dwStartType", "dwErrorControl", "lpBinaryPathName", "lpLoadOrderGroup", "lpdwTagId", "lpDependencies", "lpServiceStartName", "lpPassword"]),
        # 
        'CreateServiceW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="ENUM_SERVICE_TYPE"), SimTypeInt(signed=False, label="SERVICE_START_TYPE"), SimTypeInt(signed=False, label="SERVICE_ERROR"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hSCManager", "lpServiceName", "lpDisplayName", "dwDesiredAccess", "dwServiceType", "dwStartType", "dwErrorControl", "lpBinaryPathName", "lpLoadOrderGroup", "lpdwTagId", "lpDependencies", "lpServiceStartName", "lpPassword"]),
        # 
        'DeleteService': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hService"]),
        # 
        'EnumDependentServicesA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="ENUM_SERVICE_STATE"), SimTypePointer(SimStruct({"lpServiceName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "lpDisplayName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "ServiceStatus": SimStruct({"dwServiceType": SimTypeInt(signed=False, label="ENUM_SERVICE_TYPE"), "dwCurrentState": SimTypeInt(signed=False, label="SERVICE_STATUS_CURRENT_STATE"), "dwControlsAccepted": SimTypeInt(signed=False, label="UInt32"), "dwWin32ExitCode": SimTypeInt(signed=False, label="UInt32"), "dwServiceSpecificExitCode": SimTypeInt(signed=False, label="UInt32"), "dwCheckPoint": SimTypeInt(signed=False, label="UInt32"), "dwWaitHint": SimTypeInt(signed=False, label="UInt32")}, name="SERVICE_STATUS", pack=False, align=None)}, name="ENUM_SERVICE_STATUSA", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hService", "dwServiceState", "lpServices", "cbBufSize", "pcbBytesNeeded", "lpServicesReturned"]),
        # 
        'EnumDependentServicesW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="ENUM_SERVICE_STATE"), SimTypePointer(SimStruct({"lpServiceName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "lpDisplayName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ServiceStatus": SimStruct({"dwServiceType": SimTypeInt(signed=False, label="ENUM_SERVICE_TYPE"), "dwCurrentState": SimTypeInt(signed=False, label="SERVICE_STATUS_CURRENT_STATE"), "dwControlsAccepted": SimTypeInt(signed=False, label="UInt32"), "dwWin32ExitCode": SimTypeInt(signed=False, label="UInt32"), "dwServiceSpecificExitCode": SimTypeInt(signed=False, label="UInt32"), "dwCheckPoint": SimTypeInt(signed=False, label="UInt32"), "dwWaitHint": SimTypeInt(signed=False, label="UInt32")}, name="SERVICE_STATUS", pack=False, align=None)}, name="ENUM_SERVICE_STATUSW", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hService", "dwServiceState", "lpServices", "cbBufSize", "pcbBytesNeeded", "lpServicesReturned"]),
        # 
        'EnumServicesStatusA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="ENUM_SERVICE_TYPE"), SimTypeInt(signed=False, label="ENUM_SERVICE_STATE"), SimTypePointer(SimStruct({"lpServiceName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "lpDisplayName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "ServiceStatus": SimStruct({"dwServiceType": SimTypeInt(signed=False, label="ENUM_SERVICE_TYPE"), "dwCurrentState": SimTypeInt(signed=False, label="SERVICE_STATUS_CURRENT_STATE"), "dwControlsAccepted": SimTypeInt(signed=False, label="UInt32"), "dwWin32ExitCode": SimTypeInt(signed=False, label="UInt32"), "dwServiceSpecificExitCode": SimTypeInt(signed=False, label="UInt32"), "dwCheckPoint": SimTypeInt(signed=False, label="UInt32"), "dwWaitHint": SimTypeInt(signed=False, label="UInt32")}, name="SERVICE_STATUS", pack=False, align=None)}, name="ENUM_SERVICE_STATUSA", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hSCManager", "dwServiceType", "dwServiceState", "lpServices", "cbBufSize", "pcbBytesNeeded", "lpServicesReturned", "lpResumeHandle"]),
        # 
        'EnumServicesStatusW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="ENUM_SERVICE_TYPE"), SimTypeInt(signed=False, label="ENUM_SERVICE_STATE"), SimTypePointer(SimStruct({"lpServiceName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "lpDisplayName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ServiceStatus": SimStruct({"dwServiceType": SimTypeInt(signed=False, label="ENUM_SERVICE_TYPE"), "dwCurrentState": SimTypeInt(signed=False, label="SERVICE_STATUS_CURRENT_STATE"), "dwControlsAccepted": SimTypeInt(signed=False, label="UInt32"), "dwWin32ExitCode": SimTypeInt(signed=False, label="UInt32"), "dwServiceSpecificExitCode": SimTypeInt(signed=False, label="UInt32"), "dwCheckPoint": SimTypeInt(signed=False, label="UInt32"), "dwWaitHint": SimTypeInt(signed=False, label="UInt32")}, name="SERVICE_STATUS", pack=False, align=None)}, name="ENUM_SERVICE_STATUSW", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hSCManager", "dwServiceType", "dwServiceState", "lpServices", "cbBufSize", "pcbBytesNeeded", "lpServicesReturned", "lpResumeHandle"]),
        # 
        'EnumServicesStatusExA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="SC_ENUM_TYPE"), SimTypeInt(signed=False, label="ENUM_SERVICE_TYPE"), SimTypeInt(signed=False, label="ENUM_SERVICE_STATE"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hSCManager", "InfoLevel", "dwServiceType", "dwServiceState", "lpServices", "cbBufSize", "pcbBytesNeeded", "lpServicesReturned", "lpResumeHandle", "pszGroupName"]),
        # 
        'EnumServicesStatusExW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="SC_ENUM_TYPE"), SimTypeInt(signed=False, label="ENUM_SERVICE_TYPE"), SimTypeInt(signed=False, label="ENUM_SERVICE_STATE"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hSCManager", "InfoLevel", "dwServiceType", "dwServiceState", "lpServices", "cbBufSize", "pcbBytesNeeded", "lpServicesReturned", "lpResumeHandle", "pszGroupName"]),
        # 
        'GetServiceKeyNameA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hSCManager", "lpDisplayName", "lpServiceName", "lpcchBuffer"]),
        # 
        'GetServiceKeyNameW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hSCManager", "lpDisplayName", "lpServiceName", "lpcchBuffer"]),
        # 
        'GetServiceDisplayNameA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hSCManager", "lpServiceName", "lpDisplayName", "lpcchBuffer"]),
        # 
        'GetServiceDisplayNameW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hSCManager", "lpServiceName", "lpDisplayName", "lpcchBuffer"]),
        # 
        'LockServiceDatabase': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["hSCManager"]),
        # 
        'NotifyBootConfigStatus': SimTypeFunction([SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["BootAcceptable"]),
        # 
        'OpenSCManagerA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["lpMachineName", "lpDatabaseName", "dwDesiredAccess"]),
        # 
        'OpenSCManagerW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["lpMachineName", "lpDatabaseName", "dwDesiredAccess"]),
        # 
        'OpenServiceA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hSCManager", "lpServiceName", "dwDesiredAccess"]),
        # 
        'OpenServiceW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hSCManager", "lpServiceName", "dwDesiredAccess"]),
        # 
        'QueryServiceConfigA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"dwServiceType": SimTypeInt(signed=False, label="ENUM_SERVICE_TYPE"), "dwStartType": SimTypeInt(signed=False, label="SERVICE_START_TYPE"), "dwErrorControl": SimTypeInt(signed=False, label="SERVICE_ERROR"), "lpBinaryPathName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "lpLoadOrderGroup": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwTagId": SimTypeInt(signed=False, label="UInt32"), "lpDependencies": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "lpServiceStartName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "lpDisplayName": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="QUERY_SERVICE_CONFIGA", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hService", "lpServiceConfig", "cbBufSize", "pcbBytesNeeded"]),
        # 
        'QueryServiceConfigW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"dwServiceType": SimTypeInt(signed=False, label="ENUM_SERVICE_TYPE"), "dwStartType": SimTypeInt(signed=False, label="SERVICE_START_TYPE"), "dwErrorControl": SimTypeInt(signed=False, label="SERVICE_ERROR"), "lpBinaryPathName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "lpLoadOrderGroup": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwTagId": SimTypeInt(signed=False, label="UInt32"), "lpDependencies": SimTypePointer(SimTypeChar(label="Char"), offset=0), "lpServiceStartName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "lpDisplayName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="QUERY_SERVICE_CONFIGW", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hService", "lpServiceConfig", "cbBufSize", "pcbBytesNeeded"]),
        # 
        'QueryServiceConfig2A': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="SERVICE_CONFIG"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hService", "dwInfoLevel", "lpBuffer", "cbBufSize", "pcbBytesNeeded"]),
        # 
        'QueryServiceConfig2W': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="SERVICE_CONFIG"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hService", "dwInfoLevel", "lpBuffer", "cbBufSize", "pcbBytesNeeded"]),
        # 
        'QueryServiceLockStatusA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"fIsLocked": SimTypeInt(signed=False, label="UInt32"), "lpLockOwner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwLockDuration": SimTypeInt(signed=False, label="UInt32")}, name="QUERY_SERVICE_LOCK_STATUSA", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hSCManager", "lpLockStatus", "cbBufSize", "pcbBytesNeeded"]),
        # 
        'QueryServiceLockStatusW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"fIsLocked": SimTypeInt(signed=False, label="UInt32"), "lpLockOwner": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwLockDuration": SimTypeInt(signed=False, label="UInt32")}, name="QUERY_SERVICE_LOCK_STATUSW", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hSCManager", "lpLockStatus", "cbBufSize", "pcbBytesNeeded"]),
        # 
        'QueryServiceObjectSecurity': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hService", "dwSecurityInformation", "lpSecurityDescriptor", "cbBufSize", "pcbBytesNeeded"]),
        # 
        'QueryServiceStatus': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"dwServiceType": SimTypeInt(signed=False, label="ENUM_SERVICE_TYPE"), "dwCurrentState": SimTypeInt(signed=False, label="SERVICE_STATUS_CURRENT_STATE"), "dwControlsAccepted": SimTypeInt(signed=False, label="UInt32"), "dwWin32ExitCode": SimTypeInt(signed=False, label="UInt32"), "dwServiceSpecificExitCode": SimTypeInt(signed=False, label="UInt32"), "dwCheckPoint": SimTypeInt(signed=False, label="UInt32"), "dwWaitHint": SimTypeInt(signed=False, label="UInt32")}, name="SERVICE_STATUS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hService", "lpServiceStatus"]),
        # 
        'QueryServiceStatusEx': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="SC_STATUS_TYPE"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hService", "InfoLevel", "lpBuffer", "cbBufSize", "pcbBytesNeeded"]),
        # 
        'RegisterServiceCtrlHandlerA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypeBottom(label="Void"), arg_names=["dwControl"]), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["lpServiceName", "lpHandlerProc"]),
        # 
        'RegisterServiceCtrlHandlerW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypeBottom(label="Void"), arg_names=["dwControl"]), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["lpServiceName", "lpHandlerProc"]),
        # 
        'RegisterServiceCtrlHandlerExA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["dwControl", "dwEventType", "lpEventData", "lpContext"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["lpServiceName", "lpHandlerProc", "lpContext"]),
        # 
        'RegisterServiceCtrlHandlerExW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["dwControl", "dwEventType", "lpEventData", "lpContext"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["lpServiceName", "lpHandlerProc", "lpContext"]),
        # 
        'SetServiceObjectSecurity': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="OBJECT_SECURITY_INFORMATION"), SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hService", "dwSecurityInformation", "lpSecurityDescriptor"]),
        # 
        'SetServiceStatus': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"dwServiceType": SimTypeInt(signed=False, label="ENUM_SERVICE_TYPE"), "dwCurrentState": SimTypeInt(signed=False, label="SERVICE_STATUS_CURRENT_STATE"), "dwControlsAccepted": SimTypeInt(signed=False, label="UInt32"), "dwWin32ExitCode": SimTypeInt(signed=False, label="UInt32"), "dwServiceSpecificExitCode": SimTypeInt(signed=False, label="UInt32"), "dwCheckPoint": SimTypeInt(signed=False, label="UInt32"), "dwWaitHint": SimTypeInt(signed=False, label="UInt32")}, name="SERVICE_STATUS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hServiceStatus", "lpServiceStatus"]),
        # 
        'StartServiceCtrlDispatcherA': SimTypeFunction([SimTypePointer(SimStruct({"lpServiceName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "lpServiceProc": SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)], SimTypeBottom(label="Void"), arg_names=["dwNumServicesArgs", "lpServiceArgVectors"]), offset=0)}, name="SERVICE_TABLE_ENTRYA", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpServiceStartTable"]),
        # 
        'StartServiceCtrlDispatcherW': SimTypeFunction([SimTypePointer(SimStruct({"lpServiceName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "lpServiceProc": SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)], SimTypeBottom(label="Void"), arg_names=["dwNumServicesArgs", "lpServiceArgVectors"]), offset=0)}, name="SERVICE_TABLE_ENTRYW", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpServiceStartTable"]),
        # 
        'StartServiceA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), label="LPArray", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hService", "dwNumServiceArgs", "lpServiceArgVectors"]),
        # 
        'StartServiceW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), label="LPArray", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hService", "dwNumServiceArgs", "lpServiceArgVectors"]),
        # 
        'UnlockServiceDatabase': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ScLock"]),
        # 
        'NotifyServiceStatusChangeA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="SERVICE_NOTIFY"), SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "pfnNotifyCallback": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pParameter"]), offset=0), "pContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwNotificationStatus": SimTypeInt(signed=False, label="UInt32"), "ServiceStatus": SimStruct({"dwServiceType": SimTypeInt(signed=False, label="ENUM_SERVICE_TYPE"), "dwCurrentState": SimTypeInt(signed=False, label="SERVICE_STATUS_CURRENT_STATE"), "dwControlsAccepted": SimTypeInt(signed=False, label="UInt32"), "dwWin32ExitCode": SimTypeInt(signed=False, label="UInt32"), "dwServiceSpecificExitCode": SimTypeInt(signed=False, label="UInt32"), "dwCheckPoint": SimTypeInt(signed=False, label="UInt32"), "dwWaitHint": SimTypeInt(signed=False, label="UInt32"), "dwProcessId": SimTypeInt(signed=False, label="UInt32"), "dwServiceFlags": SimTypeInt(signed=False, label="SERVICE_RUNS_IN_PROCESS")}, name="SERVICE_STATUS_PROCESS", pack=False, align=None), "dwNotificationTriggered": SimTypeInt(signed=False, label="UInt32"), "pszServiceNames": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SERVICE_NOTIFY_2A", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hService", "dwNotifyMask", "pNotifyBuffer"]),
        # 
        'NotifyServiceStatusChangeW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="SERVICE_NOTIFY"), SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "pfnNotifyCallback": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pParameter"]), offset=0), "pContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwNotificationStatus": SimTypeInt(signed=False, label="UInt32"), "ServiceStatus": SimStruct({"dwServiceType": SimTypeInt(signed=False, label="ENUM_SERVICE_TYPE"), "dwCurrentState": SimTypeInt(signed=False, label="SERVICE_STATUS_CURRENT_STATE"), "dwControlsAccepted": SimTypeInt(signed=False, label="UInt32"), "dwWin32ExitCode": SimTypeInt(signed=False, label="UInt32"), "dwServiceSpecificExitCode": SimTypeInt(signed=False, label="UInt32"), "dwCheckPoint": SimTypeInt(signed=False, label="UInt32"), "dwWaitHint": SimTypeInt(signed=False, label="UInt32"), "dwProcessId": SimTypeInt(signed=False, label="UInt32"), "dwServiceFlags": SimTypeInt(signed=False, label="SERVICE_RUNS_IN_PROCESS")}, name="SERVICE_STATUS_PROCESS", pack=False, align=None), "dwNotificationTriggered": SimTypeInt(signed=False, label="UInt32"), "pszServiceNames": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="SERVICE_NOTIFY_2W", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hService", "dwNotifyMask", "pNotifyBuffer"]),
        # 
        'ControlServiceExA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hService", "dwControl", "dwInfoLevel", "pControlParams"]),
        # 
        'ControlServiceExW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hService", "dwControl", "dwInfoLevel", "pControlParams"]),
        # 
        'QueryServiceDynamicInformation': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hServiceStatus", "dwInfoLevel", "ppDynamicInfo"]),
        # 
        'WaitServiceState': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hService", "dwNotify", "dwTimeout", "hCancelEvent"]),
        # 
        'InitiateSystemShutdownA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["lpMachineName", "lpMessage", "dwTimeout", "bForceAppsClosed", "bRebootAfterShutdown"]),
        # 
        'InitiateSystemShutdownW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["lpMachineName", "lpMessage", "dwTimeout", "bForceAppsClosed", "bRebootAfterShutdown"]),
        # 
        'AbortSystemShutdownA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpMachineName"]),
        # 
        'AbortSystemShutdownW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpMachineName"]),
        # 
        'InitiateSystemShutdownExA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="SHUTDOWN_REASON")], SimTypeInt(signed=True, label="Int32"), arg_names=["lpMachineName", "lpMessage", "dwTimeout", "bForceAppsClosed", "bRebootAfterShutdown", "dwReason"]),
        # 
        'InitiateSystemShutdownExW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="SHUTDOWN_REASON")], SimTypeInt(signed=True, label="Int32"), arg_names=["lpMachineName", "lpMessage", "dwTimeout", "bForceAppsClosed", "bRebootAfterShutdown", "dwReason"]),
        # 
        'InitiateShutdownA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="SHUTDOWN_FLAGS"), SimTypeInt(signed=False, label="SHUTDOWN_REASON")], SimTypeInt(signed=False, label="UInt32"), arg_names=["lpMachineName", "lpMessage", "dwGracePeriod", "dwShutdownFlags", "dwReason"]),
        # 
        'InitiateShutdownW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="SHUTDOWN_FLAGS"), SimTypeInt(signed=False, label="SHUTDOWN_REASON")], SimTypeInt(signed=False, label="UInt32"), arg_names=["lpMachineName", "lpMessage", "dwGracePeriod", "dwShutdownFlags", "dwReason"]),
        # 
        'CheckForHiberboot': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeChar(label="Byte")], SimTypeInt(signed=False, label="UInt32"), arg_names=["pHiberboot", "bClearFlag"]),
        # 
        'CreateProcessAsUserW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"nLength": SimTypeInt(signed=False, label="UInt32"), "lpSecurityDescriptor": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "bInheritHandle": SimTypeInt(signed=True, label="Int32")}, name="SECURITY_ATTRIBUTES", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"nLength": SimTypeInt(signed=False, label="UInt32"), "lpSecurityDescriptor": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "bInheritHandle": SimTypeInt(signed=True, label="Int32")}, name="SECURITY_ATTRIBUTES", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"cb": SimTypeInt(signed=False, label="UInt32"), "lpReserved": SimTypePointer(SimTypeChar(label="Char"), offset=0), "lpDesktop": SimTypePointer(SimTypeChar(label="Char"), offset=0), "lpTitle": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwX": SimTypeInt(signed=False, label="UInt32"), "dwY": SimTypeInt(signed=False, label="UInt32"), "dwXSize": SimTypeInt(signed=False, label="UInt32"), "dwYSize": SimTypeInt(signed=False, label="UInt32"), "dwXCountChars": SimTypeInt(signed=False, label="UInt32"), "dwYCountChars": SimTypeInt(signed=False, label="UInt32"), "dwFillAttribute": SimTypeInt(signed=False, label="UInt32"), "dwFlags": SimTypeInt(signed=False, label="STARTUPINFOW_FLAGS"), "wShowWindow": SimTypeShort(signed=False, label="UInt16"), "cbReserved2": SimTypeShort(signed=False, label="UInt16"), "lpReserved2": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "hStdInput": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hStdOutput": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hStdError": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="STARTUPINFOW", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"hProcess": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hThread": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "dwProcessId": SimTypeInt(signed=False, label="UInt32"), "dwThreadId": SimTypeInt(signed=False, label="UInt32")}, name="PROCESS_INFORMATION", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hToken", "lpApplicationName", "lpCommandLine", "lpProcessAttributes", "lpThreadAttributes", "bInheritHandles", "dwCreationFlags", "lpEnvironment", "lpCurrentDirectory", "lpStartupInfo", "lpProcessInformation"]),
        # 
        'SetThreadToken': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Thread", "Token"]),
        # 
        'OpenProcessToken': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="TOKEN_ACCESS_MASK"), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ProcessHandle", "DesiredAccess", "TokenHandle"]),
        # 
        'OpenThreadToken': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="TOKEN_ACCESS_MASK"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ThreadHandle", "DesiredAccess", "OpenAsSelf", "TokenHandle"]),
        # 
        'CreateProcessAsUserA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"nLength": SimTypeInt(signed=False, label="UInt32"), "lpSecurityDescriptor": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "bInheritHandle": SimTypeInt(signed=True, label="Int32")}, name="SECURITY_ATTRIBUTES", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"nLength": SimTypeInt(signed=False, label="UInt32"), "lpSecurityDescriptor": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "bInheritHandle": SimTypeInt(signed=True, label="Int32")}, name="SECURITY_ATTRIBUTES", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"cb": SimTypeInt(signed=False, label="UInt32"), "lpReserved": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "lpDesktop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "lpTitle": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwX": SimTypeInt(signed=False, label="UInt32"), "dwY": SimTypeInt(signed=False, label="UInt32"), "dwXSize": SimTypeInt(signed=False, label="UInt32"), "dwYSize": SimTypeInt(signed=False, label="UInt32"), "dwXCountChars": SimTypeInt(signed=False, label="UInt32"), "dwYCountChars": SimTypeInt(signed=False, label="UInt32"), "dwFillAttribute": SimTypeInt(signed=False, label="UInt32"), "dwFlags": SimTypeInt(signed=False, label="STARTUPINFOW_FLAGS"), "wShowWindow": SimTypeShort(signed=False, label="UInt16"), "cbReserved2": SimTypeShort(signed=False, label="UInt16"), "lpReserved2": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "hStdInput": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hStdOutput": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hStdError": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="STARTUPINFOA", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"hProcess": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hThread": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "dwProcessId": SimTypeInt(signed=False, label="UInt32"), "dwThreadId": SimTypeInt(signed=False, label="UInt32")}, name="PROCESS_INFORMATION", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hToken", "lpApplicationName", "lpCommandLine", "lpProcessAttributes", "lpThreadAttributes", "bInheritHandles", "dwCreationFlags", "lpEnvironment", "lpCurrentDirectory", "lpStartupInfo", "lpProcessInformation"]),
        # 
        'CreateProcessWithLogonW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="CREATE_PROCESS_LOGON_FLAGS"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"cb": SimTypeInt(signed=False, label="UInt32"), "lpReserved": SimTypePointer(SimTypeChar(label="Char"), offset=0), "lpDesktop": SimTypePointer(SimTypeChar(label="Char"), offset=0), "lpTitle": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwX": SimTypeInt(signed=False, label="UInt32"), "dwY": SimTypeInt(signed=False, label="UInt32"), "dwXSize": SimTypeInt(signed=False, label="UInt32"), "dwYSize": SimTypeInt(signed=False, label="UInt32"), "dwXCountChars": SimTypeInt(signed=False, label="UInt32"), "dwYCountChars": SimTypeInt(signed=False, label="UInt32"), "dwFillAttribute": SimTypeInt(signed=False, label="UInt32"), "dwFlags": SimTypeInt(signed=False, label="STARTUPINFOW_FLAGS"), "wShowWindow": SimTypeShort(signed=False, label="UInt16"), "cbReserved2": SimTypeShort(signed=False, label="UInt16"), "lpReserved2": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "hStdInput": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hStdOutput": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hStdError": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="STARTUPINFOW", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"hProcess": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hThread": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "dwProcessId": SimTypeInt(signed=False, label="UInt32"), "dwThreadId": SimTypeInt(signed=False, label="UInt32")}, name="PROCESS_INFORMATION", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpUsername", "lpDomain", "lpPassword", "dwLogonFlags", "lpApplicationName", "lpCommandLine", "dwCreationFlags", "lpEnvironment", "lpCurrentDirectory", "lpStartupInfo", "lpProcessInformation"]),
        # 
        'CreateProcessWithTokenW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="CREATE_PROCESS_LOGON_FLAGS"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"cb": SimTypeInt(signed=False, label="UInt32"), "lpReserved": SimTypePointer(SimTypeChar(label="Char"), offset=0), "lpDesktop": SimTypePointer(SimTypeChar(label="Char"), offset=0), "lpTitle": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwX": SimTypeInt(signed=False, label="UInt32"), "dwY": SimTypeInt(signed=False, label="UInt32"), "dwXSize": SimTypeInt(signed=False, label="UInt32"), "dwYSize": SimTypeInt(signed=False, label="UInt32"), "dwXCountChars": SimTypeInt(signed=False, label="UInt32"), "dwYCountChars": SimTypeInt(signed=False, label="UInt32"), "dwFillAttribute": SimTypeInt(signed=False, label="UInt32"), "dwFlags": SimTypeInt(signed=False, label="STARTUPINFOW_FLAGS"), "wShowWindow": SimTypeShort(signed=False, label="UInt16"), "cbReserved2": SimTypeShort(signed=False, label="UInt16"), "lpReserved2": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "hStdInput": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hStdOutput": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hStdError": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="STARTUPINFOW", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"hProcess": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hThread": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "dwProcessId": SimTypeInt(signed=False, label="UInt32"), "dwThreadId": SimTypeInt(signed=False, label="UInt32")}, name="PROCESS_INFORMATION", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hToken", "dwLogonFlags", "lpApplicationName", "lpCommandLine", "dwCreationFlags", "lpEnvironment", "lpCurrentDirectory", "lpStartupInfo", "lpProcessInformation"]),
        # 
        'EnumDynamicTimeZoneInformation': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Bias": SimTypeInt(signed=True, label="Int32"), "StandardName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 32), "StandardDate": SimStruct({"wYear": SimTypeShort(signed=False, label="UInt16"), "wMonth": SimTypeShort(signed=False, label="UInt16"), "wDayOfWeek": SimTypeShort(signed=False, label="UInt16"), "wDay": SimTypeShort(signed=False, label="UInt16"), "wHour": SimTypeShort(signed=False, label="UInt16"), "wMinute": SimTypeShort(signed=False, label="UInt16"), "wSecond": SimTypeShort(signed=False, label="UInt16"), "wMilliseconds": SimTypeShort(signed=False, label="UInt16")}, name="SYSTEMTIME", pack=False, align=None), "StandardBias": SimTypeInt(signed=True, label="Int32"), "DaylightName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 32), "DaylightDate": SimStruct({"wYear": SimTypeShort(signed=False, label="UInt16"), "wMonth": SimTypeShort(signed=False, label="UInt16"), "wDayOfWeek": SimTypeShort(signed=False, label="UInt16"), "wDay": SimTypeShort(signed=False, label="UInt16"), "wHour": SimTypeShort(signed=False, label="UInt16"), "wMinute": SimTypeShort(signed=False, label="UInt16"), "wSecond": SimTypeShort(signed=False, label="UInt16"), "wMilliseconds": SimTypeShort(signed=False, label="UInt16")}, name="SYSTEMTIME", pack=False, align=None), "DaylightBias": SimTypeInt(signed=True, label="Int32"), "TimeZoneKeyName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 128), "DynamicDaylightTimeDisabled": SimTypeChar(label="Byte")}, name="DYNAMIC_TIME_ZONE_INFORMATION", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["dwIndex", "lpTimeZoneInformation"]),
        # 
        'GetDynamicTimeZoneInformationEffectiveYears': SimTypeFunction([SimTypePointer(SimStruct({"Bias": SimTypeInt(signed=True, label="Int32"), "StandardName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 32), "StandardDate": SimStruct({"wYear": SimTypeShort(signed=False, label="UInt16"), "wMonth": SimTypeShort(signed=False, label="UInt16"), "wDayOfWeek": SimTypeShort(signed=False, label="UInt16"), "wDay": SimTypeShort(signed=False, label="UInt16"), "wHour": SimTypeShort(signed=False, label="UInt16"), "wMinute": SimTypeShort(signed=False, label="UInt16"), "wSecond": SimTypeShort(signed=False, label="UInt16"), "wMilliseconds": SimTypeShort(signed=False, label="UInt16")}, name="SYSTEMTIME", pack=False, align=None), "StandardBias": SimTypeInt(signed=True, label="Int32"), "DaylightName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 32), "DaylightDate": SimStruct({"wYear": SimTypeShort(signed=False, label="UInt16"), "wMonth": SimTypeShort(signed=False, label="UInt16"), "wDayOfWeek": SimTypeShort(signed=False, label="UInt16"), "wDay": SimTypeShort(signed=False, label="UInt16"), "wHour": SimTypeShort(signed=False, label="UInt16"), "wMinute": SimTypeShort(signed=False, label="UInt16"), "wSecond": SimTypeShort(signed=False, label="UInt16"), "wMilliseconds": SimTypeShort(signed=False, label="UInt16")}, name="SYSTEMTIME", pack=False, align=None), "DaylightBias": SimTypeInt(signed=True, label="Int32"), "TimeZoneKeyName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 128), "DynamicDaylightTimeDisabled": SimTypeChar(label="Byte")}, name="DYNAMIC_TIME_ZONE_INFORMATION", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["lpTimeZoneInformation", "FirstYear", "LastYear"]),
        # 
        'GetUserNameA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpBuffer", "pcbBuffer"]),
        # 
        'GetUserNameW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpBuffer", "pcbBuffer"]),
        # 
        'IsTokenUntrusted': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["TokenHandle"]),
        # 
        'GetCurrentHwProfileA': SimTypeFunction([SimTypePointer(SimStruct({"dwDockInfo": SimTypeInt(signed=False, label="UInt32"), "szHwProfileGuid": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 39), "szHwProfileName": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 80)}, name="HW_PROFILE_INFOA", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpHwProfileInfo"]),
        # 
        'GetCurrentHwProfileW': SimTypeFunction([SimTypePointer(SimStruct({"dwDockInfo": SimTypeInt(signed=False, label="UInt32"), "szHwProfileGuid": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 39), "szHwProfileName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 80)}, name="HW_PROFILE_INFOW", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpHwProfileInfo"]),
        # 
        'GetInformationCodeAuthzLevelW': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'WmiFreeBuffer': SimTypeFunction([SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'GetNamedSecurityInfoExW': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'WmiQuerySingleInstanceMultipleA': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'ConvertSecurityDescriptorToAccessA': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'CredProfileLoaded': SimTypeFunction([], SimTypeLong(signed=True)),
        # 
        'WmiExecuteMethodW': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'ProcessIdleTasksW': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'MD4Final': SimTypeFunction([SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'SystemFunction013': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'CredpConvertOneCredentialSize': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'EncryptedFileKeyInfo': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'ElfBackupEventLogFileW': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'MD4Update': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'CloseCodeAuthzLevel': SimTypeFunction([SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'EnumServiceGroupW': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'GetSecurityInfoExA': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'ElfReportEventA': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'SystemFunction027': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'LsaEnumeratePrivilegesOfAccount': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'SystemFunction024': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'ConvertAccessToSecurityDescriptorW': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'WmiDevInstToInstanceNameA': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'WmiEnumerateGuids': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'SaferiRegisterExtensionDll': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'LsaCreateSecret': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'ElfOpenEventLogW': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'ElfOpenEventLogA': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'LsaGetUserName': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'A_SHAInit': SimTypeFunction([SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'LsaOpenPolicySce': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'ElfChangeNotify': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'I_ScSetServiceBitsA': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'WmiOpenBlock': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'GetAccessPermissionsForObjectA': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'LsaICLookupNames': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'UnregisterIdleTask': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'SystemFunction025': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'ElfRegisterEventSourceA': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'SystemFunction010': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'WmiMofEnumerateResourcesA': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'ConvertSDToStringSDRootDomainW': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'A_SHAFinal': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'LsaSetSecurityObject': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'LsaSetSystemAccessAccount': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'WmiFileHandleToInstanceNameA': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'FreeEncryptedFileKeyInfo': SimTypeFunction([SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'LsaGetRemoteUserName': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'EventWriteStartScenario': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'SystemFunction014': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'AddUsersToEncryptedFileEx': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'ElfRegisterEventSourceW': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'CredEncryptAndMarshalBinaryBlob': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'SaferiPopulateDefaultsInRegistry': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'SaferiSearchMatchingHashRules': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'LsaGetSystemAccessAccount': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'ElfReadEventLogW': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'WmiExecuteMethodA': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'WmiSetSingleInstanceA': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'LsaLookupPrivilegeValue': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'WmiSetSingleItemW': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'WmiQueryAllDataA': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'CredBackupCredentials': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'ConvertStringSDToSDRootDomainW': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'LsaCreateTrustedDomain': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'GetAccessPermissionsForObjectW': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'ElfReportEventW': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'SetSecurityInfoExW': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'SystemFunction015': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'ElfCloseEventLog': SimTypeFunction([SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'UsePinForEncryptedFilesW': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'LsaManageSidNameMapping': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'CredProfileUnloaded': SimTypeFunction([], SimTypeLong(signed=True)),
        # 
        'SystemFunction007': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'WmiSetSingleItemA': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'GetNamedSecurityInfoExA': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'WmiFileHandleToInstanceNameW': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'SaferiChangeRegistryScope': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'MD5Init': SimTypeFunction([SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'I_ScPnPGetServiceName': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'CredpConvertTargetInfo': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'GetSecurityInfoExW': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'IsValidRelativeSecurityDescriptor': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'CredpDecodeCredential': SimTypeFunction([SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'I_ScSetServiceBitsW': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'RegisterIdleTask': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'SystemFunction017': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'SystemFunction033': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'CancelOverlappedAccess': SimTypeFunction([SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'TrusteeAccessToObjectW': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'LsaOpenSecret': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'EventWriteEndScenario': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'ComputeAccessTokenFromCodeAuthzLevel': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'LsaGetQuotasForAccount': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'I_ScIsSecurityProcess': SimTypeFunction([], SimTypeLong(signed=True)),
        # 
        'SetNamedSecurityInfoExA': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'SystemFunction019': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'WmiQueryAllDataMultipleW': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'ElfDeregisterEventSource': SimTypeFunction([SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'ElfClearEventLogFileA': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'ConvertAccessToSecurityDescriptorA': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'SystemFunction016': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'WmiMofEnumerateResourcesW': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'WmiNotificationRegistrationA': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'LsaAddPrivilegesToAccount': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'SystemFunction003': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'SystemFunction020': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'SystemFunction006': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'ConvertStringSDToSDRootDomainA': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'ConvertStringSDToSDDomainW': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'ConvertSecurityDescriptorToAccessNamedA': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'LsaRemovePrivilegesFromAccount': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'WmiQuerySingleInstanceW': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'ProcessIdleTasks': SimTypeFunction([], SimTypeLong(signed=True)),
        # 
        'ConvertStringSDToSDDomainA': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'SetEntriesInAuditListA': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'NotifyServiceStatusChange': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'LsaQuerySecurityObject': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'ElfBackupEventLogFileA': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'SystemFunction018': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'SaferiIsDllAllowed': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'WmiCloseBlock': SimTypeFunction([SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'SystemFunction035': SimTypeFunction([SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'WmiSetSingleInstanceW': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'CredpEncodeCredential': SimTypeFunction([SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'WmiQueryAllDataMultipleA': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'SystemFunction030': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'LsaOpenTrustedDomain': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'SystemFunction005': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'SystemFunction012': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'SystemFunction031': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'SetEntriesInAuditListW': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'I_ScGetCurrentGroupStateW': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'SetNamedSecurityInfoExW': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'ElfNumberOfRecords': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'LsaClearAuditLog': SimTypeFunction([SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'CreateCodeAuthzLevel': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'MD5Update': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'ElfFlushEventLog': SimTypeFunction([SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'MakeAbsoluteSD2': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'SaferiCompareTokenLevels': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'SetEntriesInAccessListA': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'SystemFunction008': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'FlushEfsCache': SimTypeFunction([SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'ConvertSecurityDescriptorToAccessNamedW': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'LsaCreateAccount': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'LsaEnumerateAccounts': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'WmiQueryGuidInformation': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'I_QueryTagInformation': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'SetInformationCodeAuthzLevelW': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'LsaQueryInfoTrustedDomain': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'SystemFunction028': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'WmiQuerySingleInstanceMultipleW': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'WmiReceiveNotificationsW': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'LsaSetInformationTrustedDomain': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'I_ScValidatePnPService': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'ElfReportEventAndSourceW': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'ConvertSDToStringSDRootDomainA': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'TrusteeAccessToObjectA': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'MD4Init': SimTypeFunction([SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'GetOverlappedAccessResults': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'LogonUserExExW': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'LsaLookupPrivilegeName': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'LsaOpenAccount': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'CredRestoreCredentials': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'I_ScSendTSMessage': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'LsaLookupPrivilegeDisplayName': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'I_ScSendPnPMessage': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'LsaICLookupSids': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'SystemFunction034': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'SaferiRecordEventLogEntry': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'SystemFunction026': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'ElfOpenBackupEventLogA': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'SystemFunction029': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'LsaSetSecret': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'ElfReadEventLogA': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'CredpConvertCredential': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'ConvertSecurityDescriptorToAccessW': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'LsaICLookupSidsWithCreds': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'SetSecurityInfoExA': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'SystemFunction001': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'UsePinForEncryptedFilesA': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'LsaQuerySecret': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'LsaEnumeratePrivileges': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'SystemFunction032': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'GetInformationCodeAuthzPolicyW': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'CredpEncodeSecret': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'ElfOpenBackupEventLogW': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'IdentifyCodeAuthzLevelW': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'SystemFunction009': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'A_SHAUpdate': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'LsaDelete': SimTypeFunction([SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'ElfClearEventLogFileW': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'SetInformationCodeAuthzPolicyW': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'I_ScQueryServiceConfig': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'WmiDevInstToInstanceNameW': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'SystemFunction022': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'WmiQueryAllDataW': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'WmiQuerySingleInstanceA': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'ElfOldestRecord': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'SystemFunction002': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'SetEntriesInAccessListW': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'LsaSetQuotasForAccount': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'CredReadByTokenHandle': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'SystemFunction004': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'LsaICLookupNamesWithCreds': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'SystemFunction023': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'SystemFunction011': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'WmiNotificationRegistrationW': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'SystemFunction021': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'WmiReceiveNotificationsA': SimTypeFunction([SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True), SimTypeLong(signed=True)], SimTypeLong(signed=True)),
        # 
        'MD5Final': SimTypeFunction([SimTypeLong(signed=True)], SimTypeLong(signed=True)),
    }

lib.set_prototypes(prototypes)
