# pylint:disable=line-too-long
import logging

from ...sim_type import SimTypeFunction,     SimTypeShort, SimTypeInt, SimTypeLong, SimTypeLongLong, SimTypeDouble, SimTypeFloat,     SimTypePointer,     SimTypeChar,     SimStruct,     SimTypeFixedSizeArray,     SimTypeBottom,     SimUnion,     SimTypeBool
from ...calling_conventions import SimCCStdcall, SimCCMicrosoftAMD64
from .. import SIM_PROCEDURES as P
from . import SimLibrary


_l = logging.getLogger(name=__name__)


lib = SimLibrary()
lib.set_default_cc('X86', SimCCStdcall)
lib.set_default_cc('AMD64', SimCCMicrosoftAMD64)
lib.set_library_names("comdlg32.dll")
prototypes = \
    {
        # 
        'GetOpenFileNameA': SimTypeFunction([SimTypePointer(SimStruct({"lStructSize": SimTypeInt(signed=False, label="UInt32"), "hwndOwner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hInstance": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "lpstrFilter": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "lpstrCustomFilter": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "nMaxCustFilter": SimTypeInt(signed=False, label="UInt32"), "nFilterIndex": SimTypeInt(signed=False, label="UInt32"), "lpstrFile": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "nMaxFile": SimTypeInt(signed=False, label="UInt32"), "lpstrFileTitle": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "nMaxFileTitle": SimTypeInt(signed=False, label="UInt32"), "lpstrInitialDir": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "lpstrTitle": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Flags": SimTypeInt(signed=False, label="OPEN_FILENAME_FLAGS"), "nFileOffset": SimTypeShort(signed=False, label="UInt16"), "nFileExtension": SimTypeShort(signed=False, label="UInt16"), "lpstrDefExt": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "lCustData": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "lpfnHook": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), arg_names=["param0", "param1", "param2", "param3"]), offset=0), "lpTemplateName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pvReserved": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwReserved": SimTypeInt(signed=False, label="UInt32"), "FlagsEx": SimTypeInt(signed=False, label="OPEN_FILENAME_FLAGS_EX")}, name="OPENFILENAMEA", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0"]),
        # 
        'GetOpenFileNameW': SimTypeFunction([SimTypePointer(SimStruct({"lStructSize": SimTypeInt(signed=False, label="UInt32"), "hwndOwner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hInstance": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "lpstrFilter": SimTypePointer(SimTypeChar(label="Char"), offset=0), "lpstrCustomFilter": SimTypePointer(SimTypeChar(label="Char"), offset=0), "nMaxCustFilter": SimTypeInt(signed=False, label="UInt32"), "nFilterIndex": SimTypeInt(signed=False, label="UInt32"), "lpstrFile": SimTypePointer(SimTypeChar(label="Char"), offset=0), "nMaxFile": SimTypeInt(signed=False, label="UInt32"), "lpstrFileTitle": SimTypePointer(SimTypeChar(label="Char"), offset=0), "nMaxFileTitle": SimTypeInt(signed=False, label="UInt32"), "lpstrInitialDir": SimTypePointer(SimTypeChar(label="Char"), offset=0), "lpstrTitle": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Flags": SimTypeInt(signed=False, label="OPEN_FILENAME_FLAGS"), "nFileOffset": SimTypeShort(signed=False, label="UInt16"), "nFileExtension": SimTypeShort(signed=False, label="UInt16"), "lpstrDefExt": SimTypePointer(SimTypeChar(label="Char"), offset=0), "lCustData": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "lpfnHook": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), arg_names=["param0", "param1", "param2", "param3"]), offset=0), "lpTemplateName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pvReserved": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwReserved": SimTypeInt(signed=False, label="UInt32"), "FlagsEx": SimTypeInt(signed=False, label="OPEN_FILENAME_FLAGS_EX")}, name="OPENFILENAMEW", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0"]),
        # 
        'GetSaveFileNameA': SimTypeFunction([SimTypePointer(SimStruct({"lStructSize": SimTypeInt(signed=False, label="UInt32"), "hwndOwner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hInstance": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "lpstrFilter": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "lpstrCustomFilter": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "nMaxCustFilter": SimTypeInt(signed=False, label="UInt32"), "nFilterIndex": SimTypeInt(signed=False, label="UInt32"), "lpstrFile": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "nMaxFile": SimTypeInt(signed=False, label="UInt32"), "lpstrFileTitle": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "nMaxFileTitle": SimTypeInt(signed=False, label="UInt32"), "lpstrInitialDir": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "lpstrTitle": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Flags": SimTypeInt(signed=False, label="OPEN_FILENAME_FLAGS"), "nFileOffset": SimTypeShort(signed=False, label="UInt16"), "nFileExtension": SimTypeShort(signed=False, label="UInt16"), "lpstrDefExt": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "lCustData": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "lpfnHook": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), arg_names=["param0", "param1", "param2", "param3"]), offset=0), "lpTemplateName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pvReserved": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwReserved": SimTypeInt(signed=False, label="UInt32"), "FlagsEx": SimTypeInt(signed=False, label="OPEN_FILENAME_FLAGS_EX")}, name="OPENFILENAMEA", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0"]),
        # 
        'GetSaveFileNameW': SimTypeFunction([SimTypePointer(SimStruct({"lStructSize": SimTypeInt(signed=False, label="UInt32"), "hwndOwner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hInstance": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "lpstrFilter": SimTypePointer(SimTypeChar(label="Char"), offset=0), "lpstrCustomFilter": SimTypePointer(SimTypeChar(label="Char"), offset=0), "nMaxCustFilter": SimTypeInt(signed=False, label="UInt32"), "nFilterIndex": SimTypeInt(signed=False, label="UInt32"), "lpstrFile": SimTypePointer(SimTypeChar(label="Char"), offset=0), "nMaxFile": SimTypeInt(signed=False, label="UInt32"), "lpstrFileTitle": SimTypePointer(SimTypeChar(label="Char"), offset=0), "nMaxFileTitle": SimTypeInt(signed=False, label="UInt32"), "lpstrInitialDir": SimTypePointer(SimTypeChar(label="Char"), offset=0), "lpstrTitle": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Flags": SimTypeInt(signed=False, label="OPEN_FILENAME_FLAGS"), "nFileOffset": SimTypeShort(signed=False, label="UInt16"), "nFileExtension": SimTypeShort(signed=False, label="UInt16"), "lpstrDefExt": SimTypePointer(SimTypeChar(label="Char"), offset=0), "lCustData": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "lpfnHook": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), arg_names=["param0", "param1", "param2", "param3"]), offset=0), "lpTemplateName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pvReserved": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwReserved": SimTypeInt(signed=False, label="UInt32"), "FlagsEx": SimTypeInt(signed=False, label="OPEN_FILENAME_FLAGS_EX")}, name="OPENFILENAMEW", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0"]),
        # 
        'GetFileTitleA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=False, label="UInt16")], SimTypeShort(signed=True, label="Int16"), arg_names=["param0", "Buf", "cchSize"]),
        # 
        'GetFileTitleW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeShort(signed=False, label="UInt16")], SimTypeShort(signed=True, label="Int16"), arg_names=["param0", "Buf", "cchSize"]),
        # 
        'ChooseColorA': SimTypeFunction([SimTypePointer(SimStruct({"lStructSize": SimTypeInt(signed=False, label="UInt32"), "hwndOwner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hInstance": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "rgbResult": SimTypeInt(signed=False, label="UInt32"), "lpCustColors": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "Flags": SimTypeInt(signed=False, label="UInt32"), "lCustData": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "lpfnHook": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), arg_names=["param0", "param1", "param2", "param3"]), offset=0), "lpTemplateName": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CHOOSECOLORA", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0"]),
        # 
        'ChooseColorW': SimTypeFunction([SimTypePointer(SimStruct({"lStructSize": SimTypeInt(signed=False, label="UInt32"), "hwndOwner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hInstance": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "rgbResult": SimTypeInt(signed=False, label="UInt32"), "lpCustColors": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "Flags": SimTypeInt(signed=False, label="UInt32"), "lCustData": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "lpfnHook": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), arg_names=["param0", "param1", "param2", "param3"]), offset=0), "lpTemplateName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="CHOOSECOLORW", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0"]),
        # 
        'FindTextA': SimTypeFunction([SimTypePointer(SimStruct({"lStructSize": SimTypeInt(signed=False, label="UInt32"), "hwndOwner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hInstance": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Flags": SimTypeInt(signed=False, label="FINDREPLACE_FLAGS"), "lpstrFindWhat": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "lpstrReplaceWith": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wFindWhatLen": SimTypeShort(signed=False, label="UInt16"), "wReplaceWithLen": SimTypeShort(signed=False, label="UInt16"), "lCustData": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "lpfnHook": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), arg_names=["param0", "param1", "param2", "param3"]), offset=0), "lpTemplateName": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FINDREPLACEA", pack=False, align=None), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["param0"]),
        # 
        'FindTextW': SimTypeFunction([SimTypePointer(SimStruct({"lStructSize": SimTypeInt(signed=False, label="UInt32"), "hwndOwner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hInstance": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Flags": SimTypeInt(signed=False, label="FINDREPLACE_FLAGS"), "lpstrFindWhat": SimTypePointer(SimTypeChar(label="Char"), offset=0), "lpstrReplaceWith": SimTypePointer(SimTypeChar(label="Char"), offset=0), "wFindWhatLen": SimTypeShort(signed=False, label="UInt16"), "wReplaceWithLen": SimTypeShort(signed=False, label="UInt16"), "lCustData": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "lpfnHook": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), arg_names=["param0", "param1", "param2", "param3"]), offset=0), "lpTemplateName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="FINDREPLACEW", pack=False, align=None), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["param0"]),
        # 
        'ReplaceTextA': SimTypeFunction([SimTypePointer(SimStruct({"lStructSize": SimTypeInt(signed=False, label="UInt32"), "hwndOwner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hInstance": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Flags": SimTypeInt(signed=False, label="FINDREPLACE_FLAGS"), "lpstrFindWhat": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "lpstrReplaceWith": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wFindWhatLen": SimTypeShort(signed=False, label="UInt16"), "wReplaceWithLen": SimTypeShort(signed=False, label="UInt16"), "lCustData": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "lpfnHook": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), arg_names=["param0", "param1", "param2", "param3"]), offset=0), "lpTemplateName": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FINDREPLACEA", pack=False, align=None), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["param0"]),
        # 
        'ReplaceTextW': SimTypeFunction([SimTypePointer(SimStruct({"lStructSize": SimTypeInt(signed=False, label="UInt32"), "hwndOwner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hInstance": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Flags": SimTypeInt(signed=False, label="FINDREPLACE_FLAGS"), "lpstrFindWhat": SimTypePointer(SimTypeChar(label="Char"), offset=0), "lpstrReplaceWith": SimTypePointer(SimTypeChar(label="Char"), offset=0), "wFindWhatLen": SimTypeShort(signed=False, label="UInt16"), "wReplaceWithLen": SimTypeShort(signed=False, label="UInt16"), "lCustData": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "lpfnHook": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), arg_names=["param0", "param1", "param2", "param3"]), offset=0), "lpTemplateName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="FINDREPLACEW", pack=False, align=None), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["param0"]),
        # 
        'ChooseFontA': SimTypeFunction([SimTypePointer(SimStruct({"lStructSize": SimTypeInt(signed=False, label="UInt32"), "hwndOwner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hDC": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "lpLogFont": SimTypePointer(SimStruct({"lfHeight": SimTypeInt(signed=True, label="Int32"), "lfWidth": SimTypeInt(signed=True, label="Int32"), "lfEscapement": SimTypeInt(signed=True, label="Int32"), "lfOrientation": SimTypeInt(signed=True, label="Int32"), "lfWeight": SimTypeInt(signed=True, label="Int32"), "lfItalic": SimTypeChar(label="Byte"), "lfUnderline": SimTypeChar(label="Byte"), "lfStrikeOut": SimTypeChar(label="Byte"), "lfCharSet": SimTypeChar(label="Byte"), "lfOutPrecision": SimTypeChar(label="Byte"), "lfClipPrecision": SimTypeChar(label="Byte"), "lfQuality": SimTypeChar(label="Byte"), "lfPitchAndFamily": SimTypeChar(label="Byte"), "lfFaceName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 32)}, name="LOGFONTA", pack=False, align=None), offset=0), "iPointSize": SimTypeInt(signed=True, label="Int32"), "Flags": SimTypeInt(signed=False, label="CHOOSEFONT_FLAGS"), "rgbColors": SimTypeInt(signed=False, label="UInt32"), "lCustData": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "lpfnHook": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), arg_names=["param0", "param1", "param2", "param3"]), offset=0), "lpTemplateName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "hInstance": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "lpszStyle": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "nFontType": SimTypeInt(signed=False, label="CHOOSEFONT_FONT_TYPE"), "___MISSING_ALIGNMENT__": SimTypeShort(signed=False, label="UInt16"), "nSizeMin": SimTypeInt(signed=True, label="Int32"), "nSizeMax": SimTypeInt(signed=True, label="Int32")}, name="CHOOSEFONTA", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0"]),
        # 
        'ChooseFontW': SimTypeFunction([SimTypePointer(SimStruct({"lStructSize": SimTypeInt(signed=False, label="UInt32"), "hwndOwner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hDC": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "lpLogFont": SimTypePointer(SimStruct({"lfHeight": SimTypeInt(signed=True, label="Int32"), "lfWidth": SimTypeInt(signed=True, label="Int32"), "lfEscapement": SimTypeInt(signed=True, label="Int32"), "lfOrientation": SimTypeInt(signed=True, label="Int32"), "lfWeight": SimTypeInt(signed=True, label="Int32"), "lfItalic": SimTypeChar(label="Byte"), "lfUnderline": SimTypeChar(label="Byte"), "lfStrikeOut": SimTypeChar(label="Byte"), "lfCharSet": SimTypeChar(label="Byte"), "lfOutPrecision": SimTypeChar(label="Byte"), "lfClipPrecision": SimTypeChar(label="Byte"), "lfQuality": SimTypeChar(label="Byte"), "lfPitchAndFamily": SimTypeChar(label="Byte"), "lfFaceName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 32)}, name="LOGFONTW", pack=False, align=None), offset=0), "iPointSize": SimTypeInt(signed=True, label="Int32"), "Flags": SimTypeInt(signed=False, label="CHOOSEFONT_FLAGS"), "rgbColors": SimTypeInt(signed=False, label="UInt32"), "lCustData": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "lpfnHook": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), arg_names=["param0", "param1", "param2", "param3"]), offset=0), "lpTemplateName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "hInstance": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "lpszStyle": SimTypePointer(SimTypeChar(label="Char"), offset=0), "nFontType": SimTypeInt(signed=False, label="CHOOSEFONT_FONT_TYPE"), "___MISSING_ALIGNMENT__": SimTypeShort(signed=False, label="UInt16"), "nSizeMin": SimTypeInt(signed=True, label="Int32"), "nSizeMax": SimTypeInt(signed=True, label="Int32")}, name="CHOOSEFONTW", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0"]),
        # 
        'PrintDlgA': SimTypeFunction([SimTypePointer(SimStruct({"lStructSize": SimTypeInt(signed=False, label="UInt32"), "hwndOwner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hDevMode": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hDevNames": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hDC": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Flags": SimTypeInt(signed=False, label="PRINTDLGEX_FLAGS"), "nFromPage": SimTypeShort(signed=False, label="UInt16"), "nToPage": SimTypeShort(signed=False, label="UInt16"), "nMinPage": SimTypeShort(signed=False, label="UInt16"), "nMaxPage": SimTypeShort(signed=False, label="UInt16"), "nCopies": SimTypeShort(signed=False, label="UInt16"), "hInstance": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "lCustData": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "lpfnPrintHook": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), arg_names=["param0", "param1", "param2", "param3"]), offset=0), "lpfnSetupHook": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), arg_names=["param0", "param1", "param2", "param3"]), offset=0), "lpPrintTemplateName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "lpSetupTemplateName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "hPrintTemplate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hSetupTemplate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="PRINTDLGA", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pPD"]),
        # 
        'PrintDlgW': SimTypeFunction([SimTypePointer(SimStruct({"lStructSize": SimTypeInt(signed=False, label="UInt32"), "hwndOwner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hDevMode": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hDevNames": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hDC": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Flags": SimTypeInt(signed=False, label="PRINTDLGEX_FLAGS"), "nFromPage": SimTypeShort(signed=False, label="UInt16"), "nToPage": SimTypeShort(signed=False, label="UInt16"), "nMinPage": SimTypeShort(signed=False, label="UInt16"), "nMaxPage": SimTypeShort(signed=False, label="UInt16"), "nCopies": SimTypeShort(signed=False, label="UInt16"), "hInstance": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "lCustData": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "lpfnPrintHook": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), arg_names=["param0", "param1", "param2", "param3"]), offset=0), "lpfnSetupHook": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), arg_names=["param0", "param1", "param2", "param3"]), offset=0), "lpPrintTemplateName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "lpSetupTemplateName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "hPrintTemplate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hSetupTemplate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="PRINTDLGW", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pPD"]),
        # 
        'PrintDlgExA': SimTypeFunction([SimTypePointer(SimStruct({"lStructSize": SimTypeInt(signed=False, label="UInt32"), "hwndOwner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hDevMode": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hDevNames": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hDC": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Flags": SimTypeInt(signed=False, label="PRINTDLGEX_FLAGS"), "Flags2": SimTypeInt(signed=False, label="UInt32"), "ExclusionFlags": SimTypeInt(signed=False, label="UInt32"), "nPageRanges": SimTypeInt(signed=False, label="UInt32"), "nMaxPageRanges": SimTypeInt(signed=False, label="UInt32"), "lpPageRanges": SimTypePointer(SimStruct({"nFromPage": SimTypeInt(signed=False, label="UInt32"), "nToPage": SimTypeInt(signed=False, label="UInt32")}, name="PRINTPAGERANGE", pack=False, align=None), offset=0), "nMinPage": SimTypeInt(signed=False, label="UInt32"), "nMaxPage": SimTypeInt(signed=False, label="UInt32"), "nCopies": SimTypeInt(signed=False, label="UInt32"), "hInstance": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "lpPrintTemplateName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "lpCallback": SimTypeBottom(label="IUnknown"), "nPropertyPages": SimTypeInt(signed=False, label="UInt32"), "lphPropertyPages": SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), "nStartPage": SimTypeInt(signed=False, label="UInt32"), "dwResultAction": SimTypeInt(signed=False, label="UInt32")}, name="PRINTDLGEXA", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pPD"]),
        # 
        'PrintDlgExW': SimTypeFunction([SimTypePointer(SimStruct({"lStructSize": SimTypeInt(signed=False, label="UInt32"), "hwndOwner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hDevMode": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hDevNames": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hDC": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Flags": SimTypeInt(signed=False, label="PRINTDLGEX_FLAGS"), "Flags2": SimTypeInt(signed=False, label="UInt32"), "ExclusionFlags": SimTypeInt(signed=False, label="UInt32"), "nPageRanges": SimTypeInt(signed=False, label="UInt32"), "nMaxPageRanges": SimTypeInt(signed=False, label="UInt32"), "lpPageRanges": SimTypePointer(SimStruct({"nFromPage": SimTypeInt(signed=False, label="UInt32"), "nToPage": SimTypeInt(signed=False, label="UInt32")}, name="PRINTPAGERANGE", pack=False, align=None), offset=0), "nMinPage": SimTypeInt(signed=False, label="UInt32"), "nMaxPage": SimTypeInt(signed=False, label="UInt32"), "nCopies": SimTypeInt(signed=False, label="UInt32"), "hInstance": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "lpPrintTemplateName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "lpCallback": SimTypeBottom(label="IUnknown"), "nPropertyPages": SimTypeInt(signed=False, label="UInt32"), "lphPropertyPages": SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), "nStartPage": SimTypeInt(signed=False, label="UInt32"), "dwResultAction": SimTypeInt(signed=False, label="UInt32")}, name="PRINTDLGEXW", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pPD"]),
        # 
        'CommDlgExtendedError': SimTypeFunction([], SimTypeInt(signed=False, label="UInt32")),
        # 
        'PageSetupDlgA': SimTypeFunction([SimTypePointer(SimStruct({"lStructSize": SimTypeInt(signed=False, label="UInt32"), "hwndOwner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hDevMode": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hDevNames": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Flags": SimTypeInt(signed=False, label="PAGESETUPDLG_FLAGS"), "ptPaperSize": SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINT", pack=False, align=None), "rtMinMargin": SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECT", pack=False, align=None), "rtMargin": SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECT", pack=False, align=None), "hInstance": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "lCustData": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "lpfnPageSetupHook": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), arg_names=["param0", "param1", "param2", "param3"]), offset=0), "lpfnPagePaintHook": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), arg_names=["param0", "param1", "param2", "param3"]), offset=0), "lpPageSetupTemplateName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "hPageSetupTemplate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="PAGESETUPDLGA", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0"]),
        # 
        'PageSetupDlgW': SimTypeFunction([SimTypePointer(SimStruct({"lStructSize": SimTypeInt(signed=False, label="UInt32"), "hwndOwner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hDevMode": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hDevNames": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Flags": SimTypeInt(signed=False, label="PAGESETUPDLG_FLAGS"), "ptPaperSize": SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINT", pack=False, align=None), "rtMinMargin": SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECT", pack=False, align=None), "rtMargin": SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECT", pack=False, align=None), "hInstance": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "lCustData": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "lpfnPageSetupHook": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), arg_names=["param0", "param1", "param2", "param3"]), offset=0), "lpfnPagePaintHook": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), arg_names=["param0", "param1", "param2", "param3"]), offset=0), "lpPageSetupTemplateName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "hPageSetupTemplate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="PAGESETUPDLGW", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0"]),
    }

lib.set_prototypes(prototypes)
