# pylint:disable=line-too-long
import logging

from ...sim_type import SimTypeFunction,     SimTypeShort, SimTypeInt, SimTypeLong, SimTypeLongLong, SimTypeDouble, SimTypeFloat,     SimTypePointer,     SimTypeChar,     SimStruct,     SimTypeFixedSizeArray,     SimTypeBottom,     SimUnion,     SimTypeBool
from ...calling_conventions import SimCCStdcall, SimCCMicrosoftAMD64
from .. import SIM_PROCEDURES as P
from . import SimLibrary


_l = logging.getLogger(name=__name__)


lib = SimLibrary()
lib.set_default_cc('X86', SimCCStdcall)
lib.set_default_cc('AMD64', SimCCMicrosoftAMD64)
lib.set_library_names("dbghelp.dll")
prototypes = \
    {
        # 
        'ImageNtHeader': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypePointer(SimStruct({"Signature": SimTypeInt(signed=False, label="UInt32"), "FileHeader": SimStruct({"Machine": SimTypeInt(signed=False, label="IMAGE_FILE_MACHINE"), "NumberOfSections": SimTypeShort(signed=False, label="UInt16"), "TimeDateStamp": SimTypeInt(signed=False, label="UInt32"), "PointerToSymbolTable": SimTypeInt(signed=False, label="UInt32"), "NumberOfSymbols": SimTypeInt(signed=False, label="UInt32"), "SizeOfOptionalHeader": SimTypeShort(signed=False, label="UInt16"), "Characteristics": SimTypeInt(signed=False, label="IMAGE_FILE_CHARACTERISTICS")}, name="IMAGE_FILE_HEADER", pack=False, align=None), "OptionalHeader": SimStruct({"Magic": SimTypeInt(signed=False, label="IMAGE_OPTIONAL_HEADER_MAGIC"), "MajorLinkerVersion": SimTypeChar(label="Byte"), "MinorLinkerVersion": SimTypeChar(label="Byte"), "SizeOfCode": SimTypeInt(signed=False, label="UInt32"), "SizeOfInitializedData": SimTypeInt(signed=False, label="UInt32"), "SizeOfUninitializedData": SimTypeInt(signed=False, label="UInt32"), "AddressOfEntryPoint": SimTypeInt(signed=False, label="UInt32"), "BaseOfCode": SimTypeInt(signed=False, label="UInt32"), "ImageBase": SimTypeLongLong(signed=False, label="UInt64"), "SectionAlignment": SimTypeInt(signed=False, label="UInt32"), "FileAlignment": SimTypeInt(signed=False, label="UInt32"), "MajorOperatingSystemVersion": SimTypeShort(signed=False, label="UInt16"), "MinorOperatingSystemVersion": SimTypeShort(signed=False, label="UInt16"), "MajorImageVersion": SimTypeShort(signed=False, label="UInt16"), "MinorImageVersion": SimTypeShort(signed=False, label="UInt16"), "MajorSubsystemVersion": SimTypeShort(signed=False, label="UInt16"), "MinorSubsystemVersion": SimTypeShort(signed=False, label="UInt16"), "Win32VersionValue": SimTypeInt(signed=False, label="UInt32"), "SizeOfImage": SimTypeInt(signed=False, label="UInt32"), "SizeOfHeaders": SimTypeInt(signed=False, label="UInt32"), "CheckSum": SimTypeInt(signed=False, label="UInt32"), "Subsystem": SimTypeInt(signed=False, label="IMAGE_SUBSYSTEM"), "DllCharacteristics": SimTypeInt(signed=False, label="IMAGE_DLL_CHARACTERISTICS"), "SizeOfStackReserve": SimTypeLongLong(signed=False, label="UInt64"), "SizeOfStackCommit": SimTypeLongLong(signed=False, label="UInt64"), "SizeOfHeapReserve": SimTypeLongLong(signed=False, label="UInt64"), "SizeOfHeapCommit": SimTypeLongLong(signed=False, label="UInt64"), "LoaderFlags": SimTypeInt(signed=False, label="UInt32"), "NumberOfRvaAndSizes": SimTypeInt(signed=False, label="UInt32"), "DataDirectory": SimTypeFixedSizeArray(SimStruct({"VirtualAddress": SimTypeInt(signed=False, label="UInt32"), "Size": SimTypeInt(signed=False, label="UInt32")}, name="IMAGE_DATA_DIRECTORY", pack=False, align=None), 16)}, name="IMAGE_OPTIONAL_HEADER64", pack=False, align=None)}, name="IMAGE_NT_HEADERS64", pack=False, align=None), offset=0), arg_names=["Base"]),
        # 
        'ImageRvaToSection': SimTypeFunction([SimTypePointer(SimStruct({"Signature": SimTypeInt(signed=False, label="UInt32"), "FileHeader": SimStruct({"Machine": SimTypeInt(signed=False, label="IMAGE_FILE_MACHINE"), "NumberOfSections": SimTypeShort(signed=False, label="UInt16"), "TimeDateStamp": SimTypeInt(signed=False, label="UInt32"), "PointerToSymbolTable": SimTypeInt(signed=False, label="UInt32"), "NumberOfSymbols": SimTypeInt(signed=False, label="UInt32"), "SizeOfOptionalHeader": SimTypeShort(signed=False, label="UInt16"), "Characteristics": SimTypeInt(signed=False, label="IMAGE_FILE_CHARACTERISTICS")}, name="IMAGE_FILE_HEADER", pack=False, align=None), "OptionalHeader": SimStruct({"Magic": SimTypeInt(signed=False, label="IMAGE_OPTIONAL_HEADER_MAGIC"), "MajorLinkerVersion": SimTypeChar(label="Byte"), "MinorLinkerVersion": SimTypeChar(label="Byte"), "SizeOfCode": SimTypeInt(signed=False, label="UInt32"), "SizeOfInitializedData": SimTypeInt(signed=False, label="UInt32"), "SizeOfUninitializedData": SimTypeInt(signed=False, label="UInt32"), "AddressOfEntryPoint": SimTypeInt(signed=False, label="UInt32"), "BaseOfCode": SimTypeInt(signed=False, label="UInt32"), "ImageBase": SimTypeLongLong(signed=False, label="UInt64"), "SectionAlignment": SimTypeInt(signed=False, label="UInt32"), "FileAlignment": SimTypeInt(signed=False, label="UInt32"), "MajorOperatingSystemVersion": SimTypeShort(signed=False, label="UInt16"), "MinorOperatingSystemVersion": SimTypeShort(signed=False, label="UInt16"), "MajorImageVersion": SimTypeShort(signed=False, label="UInt16"), "MinorImageVersion": SimTypeShort(signed=False, label="UInt16"), "MajorSubsystemVersion": SimTypeShort(signed=False, label="UInt16"), "MinorSubsystemVersion": SimTypeShort(signed=False, label="UInt16"), "Win32VersionValue": SimTypeInt(signed=False, label="UInt32"), "SizeOfImage": SimTypeInt(signed=False, label="UInt32"), "SizeOfHeaders": SimTypeInt(signed=False, label="UInt32"), "CheckSum": SimTypeInt(signed=False, label="UInt32"), "Subsystem": SimTypeInt(signed=False, label="IMAGE_SUBSYSTEM"), "DllCharacteristics": SimTypeInt(signed=False, label="IMAGE_DLL_CHARACTERISTICS"), "SizeOfStackReserve": SimTypeLongLong(signed=False, label="UInt64"), "SizeOfStackCommit": SimTypeLongLong(signed=False, label="UInt64"), "SizeOfHeapReserve": SimTypeLongLong(signed=False, label="UInt64"), "SizeOfHeapCommit": SimTypeLongLong(signed=False, label="UInt64"), "LoaderFlags": SimTypeInt(signed=False, label="UInt32"), "NumberOfRvaAndSizes": SimTypeInt(signed=False, label="UInt32"), "DataDirectory": SimTypeFixedSizeArray(SimStruct({"VirtualAddress": SimTypeInt(signed=False, label="UInt32"), "Size": SimTypeInt(signed=False, label="UInt32")}, name="IMAGE_DATA_DIRECTORY", pack=False, align=None), 16)}, name="IMAGE_OPTIONAL_HEADER64", pack=False, align=None)}, name="IMAGE_NT_HEADERS64", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimStruct({"Name": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 8), "Misc": SimUnion({"PhysicalAddress": SimTypeInt(signed=False, label="UInt32"), "VirtualSize": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None"), "VirtualAddress": SimTypeInt(signed=False, label="UInt32"), "SizeOfRawData": SimTypeInt(signed=False, label="UInt32"), "PointerToRawData": SimTypeInt(signed=False, label="UInt32"), "PointerToRelocations": SimTypeInt(signed=False, label="UInt32"), "PointerToLinenumbers": SimTypeInt(signed=False, label="UInt32"), "NumberOfRelocations": SimTypeShort(signed=False, label="UInt16"), "NumberOfLinenumbers": SimTypeShort(signed=False, label="UInt16"), "Characteristics": SimTypeInt(signed=False, label="IMAGE_SECTION_CHARACTERISTICS")}, name="IMAGE_SECTION_HEADER", pack=False, align=None), offset=0), arg_names=["NtHeaders", "Base", "Rva"]),
        # 
        'ImageRvaToVa': SimTypeFunction([SimTypePointer(SimStruct({"Signature": SimTypeInt(signed=False, label="UInt32"), "FileHeader": SimStruct({"Machine": SimTypeInt(signed=False, label="IMAGE_FILE_MACHINE"), "NumberOfSections": SimTypeShort(signed=False, label="UInt16"), "TimeDateStamp": SimTypeInt(signed=False, label="UInt32"), "PointerToSymbolTable": SimTypeInt(signed=False, label="UInt32"), "NumberOfSymbols": SimTypeInt(signed=False, label="UInt32"), "SizeOfOptionalHeader": SimTypeShort(signed=False, label="UInt16"), "Characteristics": SimTypeInt(signed=False, label="IMAGE_FILE_CHARACTERISTICS")}, name="IMAGE_FILE_HEADER", pack=False, align=None), "OptionalHeader": SimStruct({"Magic": SimTypeInt(signed=False, label="IMAGE_OPTIONAL_HEADER_MAGIC"), "MajorLinkerVersion": SimTypeChar(label="Byte"), "MinorLinkerVersion": SimTypeChar(label="Byte"), "SizeOfCode": SimTypeInt(signed=False, label="UInt32"), "SizeOfInitializedData": SimTypeInt(signed=False, label="UInt32"), "SizeOfUninitializedData": SimTypeInt(signed=False, label="UInt32"), "AddressOfEntryPoint": SimTypeInt(signed=False, label="UInt32"), "BaseOfCode": SimTypeInt(signed=False, label="UInt32"), "ImageBase": SimTypeLongLong(signed=False, label="UInt64"), "SectionAlignment": SimTypeInt(signed=False, label="UInt32"), "FileAlignment": SimTypeInt(signed=False, label="UInt32"), "MajorOperatingSystemVersion": SimTypeShort(signed=False, label="UInt16"), "MinorOperatingSystemVersion": SimTypeShort(signed=False, label="UInt16"), "MajorImageVersion": SimTypeShort(signed=False, label="UInt16"), "MinorImageVersion": SimTypeShort(signed=False, label="UInt16"), "MajorSubsystemVersion": SimTypeShort(signed=False, label="UInt16"), "MinorSubsystemVersion": SimTypeShort(signed=False, label="UInt16"), "Win32VersionValue": SimTypeInt(signed=False, label="UInt32"), "SizeOfImage": SimTypeInt(signed=False, label="UInt32"), "SizeOfHeaders": SimTypeInt(signed=False, label="UInt32"), "CheckSum": SimTypeInt(signed=False, label="UInt32"), "Subsystem": SimTypeInt(signed=False, label="IMAGE_SUBSYSTEM"), "DllCharacteristics": SimTypeInt(signed=False, label="IMAGE_DLL_CHARACTERISTICS"), "SizeOfStackReserve": SimTypeLongLong(signed=False, label="UInt64"), "SizeOfStackCommit": SimTypeLongLong(signed=False, label="UInt64"), "SizeOfHeapReserve": SimTypeLongLong(signed=False, label="UInt64"), "SizeOfHeapCommit": SimTypeLongLong(signed=False, label="UInt64"), "LoaderFlags": SimTypeInt(signed=False, label="UInt32"), "NumberOfRvaAndSizes": SimTypeInt(signed=False, label="UInt32"), "DataDirectory": SimTypeFixedSizeArray(SimStruct({"VirtualAddress": SimTypeInt(signed=False, label="UInt32"), "Size": SimTypeInt(signed=False, label="UInt32")}, name="IMAGE_DATA_DIRECTORY", pack=False, align=None), 16)}, name="IMAGE_OPTIONAL_HEADER64", pack=False, align=None)}, name="IMAGE_NT_HEADERS64", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"Name": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 8), "Misc": SimUnion({"PhysicalAddress": SimTypeInt(signed=False, label="UInt32"), "VirtualSize": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None"), "VirtualAddress": SimTypeInt(signed=False, label="UInt32"), "SizeOfRawData": SimTypeInt(signed=False, label="UInt32"), "PointerToRawData": SimTypeInt(signed=False, label="UInt32"), "PointerToRelocations": SimTypeInt(signed=False, label="UInt32"), "PointerToLinenumbers": SimTypeInt(signed=False, label="UInt32"), "NumberOfRelocations": SimTypeShort(signed=False, label="UInt16"), "NumberOfLinenumbers": SimTypeShort(signed=False, label="UInt16"), "Characteristics": SimTypeInt(signed=False, label="IMAGE_SECTION_CHARACTERISTICS")}, name="IMAGE_SECTION_HEADER", pack=False, align=None), offset=0), offset=0)], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["NtHeaders", "Base", "Rva", "LastRvaSection"]),
        # 
        'MiniDumpWriteDump': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="MINIDUMP_TYPE"), SimTypePointer(SimStruct({"ThreadId": SimTypeInt(signed=False, label="UInt32"), "ExceptionPointers": SimTypePointer(SimStruct({"ExceptionRecord": SimTypePointer(SimStruct({"ExceptionCode": SimTypeInt(signed=True, label="Int32"), "ExceptionFlags": SimTypeInt(signed=False, label="UInt32"), "ExceptionRecord": SimTypePointer(SimTypeBottom(label="EXCEPTION_RECORD"), offset=0), "ExceptionAddress": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "NumberParameters": SimTypeInt(signed=False, label="UInt32"), "ExceptionInformation": SimTypeFixedSizeArray(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), 15)}, name="EXCEPTION_RECORD", pack=False, align=None), offset=0), "ContextRecord": SimTypePointer(SimStruct({"P1Home": SimTypeLongLong(signed=False, label="UInt64"), "P2Home": SimTypeLongLong(signed=False, label="UInt64"), "P3Home": SimTypeLongLong(signed=False, label="UInt64"), "P4Home": SimTypeLongLong(signed=False, label="UInt64"), "P5Home": SimTypeLongLong(signed=False, label="UInt64"), "P6Home": SimTypeLongLong(signed=False, label="UInt64"), "ContextFlags": SimTypeInt(signed=False, label="UInt32"), "MxCsr": SimTypeInt(signed=False, label="UInt32"), "SegCs": SimTypeShort(signed=False, label="UInt16"), "SegDs": SimTypeShort(signed=False, label="UInt16"), "SegEs": SimTypeShort(signed=False, label="UInt16"), "SegFs": SimTypeShort(signed=False, label="UInt16"), "SegGs": SimTypeShort(signed=False, label="UInt16"), "SegSs": SimTypeShort(signed=False, label="UInt16"), "EFlags": SimTypeInt(signed=False, label="UInt32"), "Dr0": SimTypeLongLong(signed=False, label="UInt64"), "Dr1": SimTypeLongLong(signed=False, label="UInt64"), "Dr2": SimTypeLongLong(signed=False, label="UInt64"), "Dr3": SimTypeLongLong(signed=False, label="UInt64"), "Dr6": SimTypeLongLong(signed=False, label="UInt64"), "Dr7": SimTypeLongLong(signed=False, label="UInt64"), "Rax": SimTypeLongLong(signed=False, label="UInt64"), "Rcx": SimTypeLongLong(signed=False, label="UInt64"), "Rdx": SimTypeLongLong(signed=False, label="UInt64"), "Rbx": SimTypeLongLong(signed=False, label="UInt64"), "Rsp": SimTypeLongLong(signed=False, label="UInt64"), "Rbp": SimTypeLongLong(signed=False, label="UInt64"), "Rsi": SimTypeLongLong(signed=False, label="UInt64"), "Rdi": SimTypeLongLong(signed=False, label="UInt64"), "R8": SimTypeLongLong(signed=False, label="UInt64"), "R9": SimTypeLongLong(signed=False, label="UInt64"), "R10": SimTypeLongLong(signed=False, label="UInt64"), "R11": SimTypeLongLong(signed=False, label="UInt64"), "R12": SimTypeLongLong(signed=False, label="UInt64"), "R13": SimTypeLongLong(signed=False, label="UInt64"), "R14": SimTypeLongLong(signed=False, label="UInt64"), "R15": SimTypeLongLong(signed=False, label="UInt64"), "Rip": SimTypeLongLong(signed=False, label="UInt64"), "Anonymous": SimUnion({"FltSave": SimTypeBottom(label="XSAVE_FORMAT"), "Anonymous": SimStruct({"Header": SimTypeFixedSizeArray(SimTypeBottom(label="M128A"), 2), "Legacy": SimTypeFixedSizeArray(SimTypeBottom(label="M128A"), 8), "Xmm0": SimTypeBottom(label="M128A"), "Xmm1": SimTypeBottom(label="M128A"), "Xmm2": SimTypeBottom(label="M128A"), "Xmm3": SimTypeBottom(label="M128A"), "Xmm4": SimTypeBottom(label="M128A"), "Xmm5": SimTypeBottom(label="M128A"), "Xmm6": SimTypeBottom(label="M128A"), "Xmm7": SimTypeBottom(label="M128A"), "Xmm8": SimTypeBottom(label="M128A"), "Xmm9": SimTypeBottom(label="M128A"), "Xmm10": SimTypeBottom(label="M128A"), "Xmm11": SimTypeBottom(label="M128A"), "Xmm12": SimTypeBottom(label="M128A"), "Xmm13": SimTypeBottom(label="M128A"), "Xmm14": SimTypeBottom(label="M128A"), "Xmm15": SimTypeBottom(label="M128A")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "VectorRegister": SimTypeFixedSizeArray(SimTypeBottom(label="M128A"), 26), "VectorControl": SimTypeLongLong(signed=False, label="UInt64"), "DebugControl": SimTypeLongLong(signed=False, label="UInt64"), "LastBranchToRip": SimTypeLongLong(signed=False, label="UInt64"), "LastBranchFromRip": SimTypeLongLong(signed=False, label="UInt64"), "LastExceptionToRip": SimTypeLongLong(signed=False, label="UInt64"), "LastExceptionFromRip": SimTypeLongLong(signed=False, label="UInt64")}, name="CONTEXT", pack=False, align=None), offset=0)}, name="EXCEPTION_POINTERS", pack=False, align=None), offset=0), "ClientPointers": SimTypeInt(signed=True, label="Int32")}, name="MINIDUMP_EXCEPTION_INFORMATION", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"UserStreamCount": SimTypeInt(signed=False, label="UInt32"), "UserStreamArray": SimTypePointer(SimStruct({"Type": SimTypeInt(signed=False, label="UInt32"), "BufferSize": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="MINIDUMP_USER_STREAM", pack=False, align=None), offset=0)}, name="MINIDUMP_USER_STREAM_INFORMATION", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"CallbackRoutine": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"ProcessId": SimTypeInt(signed=False, label="UInt32"), "ProcessHandle": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "CallbackType": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"Status": SimTypeInt(signed=True, label="Int32"), "Thread": SimStruct({"ThreadId": SimTypeInt(signed=False, label="UInt32"), "ThreadHandle": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Context": SimStruct({"P1Home": SimTypeLongLong(signed=False, label="UInt64"), "P2Home": SimTypeLongLong(signed=False, label="UInt64"), "P3Home": SimTypeLongLong(signed=False, label="UInt64"), "P4Home": SimTypeLongLong(signed=False, label="UInt64"), "P5Home": SimTypeLongLong(signed=False, label="UInt64"), "P6Home": SimTypeLongLong(signed=False, label="UInt64"), "ContextFlags": SimTypeInt(signed=False, label="UInt32"), "MxCsr": SimTypeInt(signed=False, label="UInt32"), "SegCs": SimTypeShort(signed=False, label="UInt16"), "SegDs": SimTypeShort(signed=False, label="UInt16"), "SegEs": SimTypeShort(signed=False, label="UInt16"), "SegFs": SimTypeShort(signed=False, label="UInt16"), "SegGs": SimTypeShort(signed=False, label="UInt16"), "SegSs": SimTypeShort(signed=False, label="UInt16"), "EFlags": SimTypeInt(signed=False, label="UInt32"), "Dr0": SimTypeLongLong(signed=False, label="UInt64"), "Dr1": SimTypeLongLong(signed=False, label="UInt64"), "Dr2": SimTypeLongLong(signed=False, label="UInt64"), "Dr3": SimTypeLongLong(signed=False, label="UInt64"), "Dr6": SimTypeLongLong(signed=False, label="UInt64"), "Dr7": SimTypeLongLong(signed=False, label="UInt64"), "Rax": SimTypeLongLong(signed=False, label="UInt64"), "Rcx": SimTypeLongLong(signed=False, label="UInt64"), "Rdx": SimTypeLongLong(signed=False, label="UInt64"), "Rbx": SimTypeLongLong(signed=False, label="UInt64"), "Rsp": SimTypeLongLong(signed=False, label="UInt64"), "Rbp": SimTypeLongLong(signed=False, label="UInt64"), "Rsi": SimTypeLongLong(signed=False, label="UInt64"), "Rdi": SimTypeLongLong(signed=False, label="UInt64"), "R8": SimTypeLongLong(signed=False, label="UInt64"), "R9": SimTypeLongLong(signed=False, label="UInt64"), "R10": SimTypeLongLong(signed=False, label="UInt64"), "R11": SimTypeLongLong(signed=False, label="UInt64"), "R12": SimTypeLongLong(signed=False, label="UInt64"), "R13": SimTypeLongLong(signed=False, label="UInt64"), "R14": SimTypeLongLong(signed=False, label="UInt64"), "R15": SimTypeLongLong(signed=False, label="UInt64"), "Rip": SimTypeLongLong(signed=False, label="UInt64"), "Anonymous": SimUnion({"FltSave": SimTypeBottom(label="XSAVE_FORMAT"), "Anonymous": SimStruct({"Header": SimTypeFixedSizeArray(SimTypeBottom(label="M128A"), 2), "Legacy": SimTypeFixedSizeArray(SimTypeBottom(label="M128A"), 8), "Xmm0": SimTypeBottom(label="M128A"), "Xmm1": SimTypeBottom(label="M128A"), "Xmm2": SimTypeBottom(label="M128A"), "Xmm3": SimTypeBottom(label="M128A"), "Xmm4": SimTypeBottom(label="M128A"), "Xmm5": SimTypeBottom(label="M128A"), "Xmm6": SimTypeBottom(label="M128A"), "Xmm7": SimTypeBottom(label="M128A"), "Xmm8": SimTypeBottom(label="M128A"), "Xmm9": SimTypeBottom(label="M128A"), "Xmm10": SimTypeBottom(label="M128A"), "Xmm11": SimTypeBottom(label="M128A"), "Xmm12": SimTypeBottom(label="M128A"), "Xmm13": SimTypeBottom(label="M128A"), "Xmm14": SimTypeBottom(label="M128A"), "Xmm15": SimTypeBottom(label="M128A")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "VectorRegister": SimTypeFixedSizeArray(SimTypeBottom(label="M128A"), 26), "VectorControl": SimTypeLongLong(signed=False, label="UInt64"), "DebugControl": SimTypeLongLong(signed=False, label="UInt64"), "LastBranchToRip": SimTypeLongLong(signed=False, label="UInt64"), "LastBranchFromRip": SimTypeLongLong(signed=False, label="UInt64"), "LastExceptionToRip": SimTypeLongLong(signed=False, label="UInt64"), "LastExceptionFromRip": SimTypeLongLong(signed=False, label="UInt64")}, name="CONTEXT", pack=False, align=None), "SizeOfContext": SimTypeInt(signed=False, label="UInt32"), "StackBase": SimTypeLongLong(signed=False, label="UInt64"), "StackEnd": SimTypeLongLong(signed=False, label="UInt64")}, name="MINIDUMP_THREAD_CALLBACK", pack=False, align=None), "ThreadEx": SimStruct({"ThreadId": SimTypeInt(signed=False, label="UInt32"), "ThreadHandle": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Context": SimStruct({"P1Home": SimTypeLongLong(signed=False, label="UInt64"), "P2Home": SimTypeLongLong(signed=False, label="UInt64"), "P3Home": SimTypeLongLong(signed=False, label="UInt64"), "P4Home": SimTypeLongLong(signed=False, label="UInt64"), "P5Home": SimTypeLongLong(signed=False, label="UInt64"), "P6Home": SimTypeLongLong(signed=False, label="UInt64"), "ContextFlags": SimTypeInt(signed=False, label="UInt32"), "MxCsr": SimTypeInt(signed=False, label="UInt32"), "SegCs": SimTypeShort(signed=False, label="UInt16"), "SegDs": SimTypeShort(signed=False, label="UInt16"), "SegEs": SimTypeShort(signed=False, label="UInt16"), "SegFs": SimTypeShort(signed=False, label="UInt16"), "SegGs": SimTypeShort(signed=False, label="UInt16"), "SegSs": SimTypeShort(signed=False, label="UInt16"), "EFlags": SimTypeInt(signed=False, label="UInt32"), "Dr0": SimTypeLongLong(signed=False, label="UInt64"), "Dr1": SimTypeLongLong(signed=False, label="UInt64"), "Dr2": SimTypeLongLong(signed=False, label="UInt64"), "Dr3": SimTypeLongLong(signed=False, label="UInt64"), "Dr6": SimTypeLongLong(signed=False, label="UInt64"), "Dr7": SimTypeLongLong(signed=False, label="UInt64"), "Rax": SimTypeLongLong(signed=False, label="UInt64"), "Rcx": SimTypeLongLong(signed=False, label="UInt64"), "Rdx": SimTypeLongLong(signed=False, label="UInt64"), "Rbx": SimTypeLongLong(signed=False, label="UInt64"), "Rsp": SimTypeLongLong(signed=False, label="UInt64"), "Rbp": SimTypeLongLong(signed=False, label="UInt64"), "Rsi": SimTypeLongLong(signed=False, label="UInt64"), "Rdi": SimTypeLongLong(signed=False, label="UInt64"), "R8": SimTypeLongLong(signed=False, label="UInt64"), "R9": SimTypeLongLong(signed=False, label="UInt64"), "R10": SimTypeLongLong(signed=False, label="UInt64"), "R11": SimTypeLongLong(signed=False, label="UInt64"), "R12": SimTypeLongLong(signed=False, label="UInt64"), "R13": SimTypeLongLong(signed=False, label="UInt64"), "R14": SimTypeLongLong(signed=False, label="UInt64"), "R15": SimTypeLongLong(signed=False, label="UInt64"), "Rip": SimTypeLongLong(signed=False, label="UInt64"), "Anonymous": SimUnion({"FltSave": SimTypeBottom(label="XSAVE_FORMAT"), "Anonymous": SimStruct({"Header": SimTypeFixedSizeArray(SimTypeBottom(label="M128A"), 2), "Legacy": SimTypeFixedSizeArray(SimTypeBottom(label="M128A"), 8), "Xmm0": SimTypeBottom(label="M128A"), "Xmm1": SimTypeBottom(label="M128A"), "Xmm2": SimTypeBottom(label="M128A"), "Xmm3": SimTypeBottom(label="M128A"), "Xmm4": SimTypeBottom(label="M128A"), "Xmm5": SimTypeBottom(label="M128A"), "Xmm6": SimTypeBottom(label="M128A"), "Xmm7": SimTypeBottom(label="M128A"), "Xmm8": SimTypeBottom(label="M128A"), "Xmm9": SimTypeBottom(label="M128A"), "Xmm10": SimTypeBottom(label="M128A"), "Xmm11": SimTypeBottom(label="M128A"), "Xmm12": SimTypeBottom(label="M128A"), "Xmm13": SimTypeBottom(label="M128A"), "Xmm14": SimTypeBottom(label="M128A"), "Xmm15": SimTypeBottom(label="M128A")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "VectorRegister": SimTypeFixedSizeArray(SimTypeBottom(label="M128A"), 26), "VectorControl": SimTypeLongLong(signed=False, label="UInt64"), "DebugControl": SimTypeLongLong(signed=False, label="UInt64"), "LastBranchToRip": SimTypeLongLong(signed=False, label="UInt64"), "LastBranchFromRip": SimTypeLongLong(signed=False, label="UInt64"), "LastExceptionToRip": SimTypeLongLong(signed=False, label="UInt64"), "LastExceptionFromRip": SimTypeLongLong(signed=False, label="UInt64")}, name="CONTEXT", pack=False, align=None), "SizeOfContext": SimTypeInt(signed=False, label="UInt32"), "StackBase": SimTypeLongLong(signed=False, label="UInt64"), "StackEnd": SimTypeLongLong(signed=False, label="UInt64"), "BackingStoreBase": SimTypeLongLong(signed=False, label="UInt64"), "BackingStoreEnd": SimTypeLongLong(signed=False, label="UInt64")}, name="MINIDUMP_THREAD_EX_CALLBACK", pack=False, align=None), "Module": SimStruct({"FullPath": SimTypePointer(SimTypeChar(label="Char"), offset=0), "BaseOfImage": SimTypeLongLong(signed=False, label="UInt64"), "SizeOfImage": SimTypeInt(signed=False, label="UInt32"), "CheckSum": SimTypeInt(signed=False, label="UInt32"), "TimeDateStamp": SimTypeInt(signed=False, label="UInt32"), "VersionInfo": SimStruct({"dwSignature": SimTypeInt(signed=False, label="UInt32"), "dwStrucVersion": SimTypeInt(signed=False, label="UInt32"), "dwFileVersionMS": SimTypeInt(signed=False, label="UInt32"), "dwFileVersionLS": SimTypeInt(signed=False, label="UInt32"), "dwProductVersionMS": SimTypeInt(signed=False, label="UInt32"), "dwProductVersionLS": SimTypeInt(signed=False, label="UInt32"), "dwFileFlagsMask": SimTypeInt(signed=False, label="UInt32"), "dwFileFlags": SimTypeInt(signed=False, label="VS_FIXEDFILEINFO_FILE_FLAGS"), "dwFileOS": SimTypeInt(signed=False, label="VS_FIXEDFILEINFO_FILE_OS"), "dwFileType": SimTypeInt(signed=False, label="VS_FIXEDFILEINFO_FILE_TYPE"), "dwFileSubtype": SimTypeInt(signed=False, label="VS_FIXEDFILEINFO_FILE_SUBTYPE"), "dwFileDateMS": SimTypeInt(signed=False, label="UInt32"), "dwFileDateLS": SimTypeInt(signed=False, label="UInt32")}, name="VS_FIXEDFILEINFO", pack=False, align=None), "CvRecord": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SizeOfCvRecord": SimTypeInt(signed=False, label="UInt32"), "MiscRecord": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SizeOfMiscRecord": SimTypeInt(signed=False, label="UInt32")}, name="MINIDUMP_MODULE_CALLBACK", pack=False, align=None), "IncludeThread": SimStruct({"ThreadId": SimTypeInt(signed=False, label="UInt32")}, name="MINIDUMP_INCLUDE_THREAD_CALLBACK", pack=False, align=None), "IncludeModule": SimStruct({"BaseOfImage": SimTypeLongLong(signed=False, label="UInt64")}, name="MINIDUMP_INCLUDE_MODULE_CALLBACK", pack=False, align=None), "Io": SimStruct({"Handle": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Offset": SimTypeLongLong(signed=False, label="UInt64"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferBytes": SimTypeInt(signed=False, label="UInt32")}, name="MINIDUMP_IO_CALLBACK", pack=False, align=None), "ReadMemoryFailure": SimStruct({"Offset": SimTypeLongLong(signed=False, label="UInt64"), "Bytes": SimTypeInt(signed=False, label="UInt32"), "FailureStatus": SimTypeInt(signed=True, label="Int32")}, name="MINIDUMP_READ_MEMORY_FAILURE_CALLBACK", pack=False, align=None), "SecondaryFlags": SimTypeInt(signed=False, label="UInt32"), "VmQuery": SimStruct({"Offset": SimTypeLongLong(signed=False, label="UInt64")}, name="MINIDUMP_VM_QUERY_CALLBACK", pack=False, align=None), "VmPreRead": SimStruct({"Offset": SimTypeLongLong(signed=False, label="UInt64"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Size": SimTypeInt(signed=False, label="UInt32")}, name="MINIDUMP_VM_PRE_READ_CALLBACK", pack=False, align=None), "VmPostRead": SimStruct({"Offset": SimTypeLongLong(signed=False, label="UInt64"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Size": SimTypeInt(signed=False, label="UInt32"), "Completed": SimTypeInt(signed=False, label="UInt32"), "Status": SimTypeInt(signed=True, label="Int32")}, name="MINIDUMP_VM_POST_READ_CALLBACK", pack=False, align=None)}, name="<anon>", label="None")}, name="MINIDUMP_CALLBACK_INPUT", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Anonymous": SimUnion({"ModuleWriteFlags": SimTypeInt(signed=False, label="UInt32"), "ThreadWriteFlags": SimTypeInt(signed=False, label="UInt32"), "SecondaryFlags": SimTypeInt(signed=False, label="UInt32"), "Anonymous1": SimStruct({"MemoryBase": SimTypeLongLong(signed=False, label="UInt64"), "MemorySize": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"CheckCancel": SimTypeInt(signed=True, label="Int32"), "Cancel": SimTypeInt(signed=True, label="Int32")}, name="_Anonymous2_e__Struct", pack=False, align=None), "Handle": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Anonymous3": SimStruct({"VmRegion": SimStruct({"BaseAddress": SimTypeLongLong(signed=False, label="UInt64"), "AllocationBase": SimTypeLongLong(signed=False, label="UInt64"), "AllocationProtect": SimTypeInt(signed=False, label="UInt32"), "__alignment1": SimTypeInt(signed=False, label="UInt32"), "RegionSize": SimTypeLongLong(signed=False, label="UInt64"), "State": SimTypeBottom(label="VIRTUAL_ALLOCATION_TYPE"), "Protect": SimTypeInt(signed=False, label="UInt32"), "Type": SimTypeInt(signed=False, label="UInt32"), "__alignment2": SimTypeInt(signed=False, label="UInt32")}, name="MINIDUMP_MEMORY_INFO", pack=False, align=None), "Continue": SimTypeInt(signed=True, label="Int32")}, name="_Anonymous3_e__Struct", pack=False, align=None), "Anonymous4": SimStruct({"VmQueryStatus": SimTypeInt(signed=True, label="Int32"), "VmQueryResult": SimStruct({"BaseAddress": SimTypeLongLong(signed=False, label="UInt64"), "AllocationBase": SimTypeLongLong(signed=False, label="UInt64"), "AllocationProtect": SimTypeInt(signed=False, label="UInt32"), "__alignment1": SimTypeInt(signed=False, label="UInt32"), "RegionSize": SimTypeLongLong(signed=False, label="UInt64"), "State": SimTypeBottom(label="VIRTUAL_ALLOCATION_TYPE"), "Protect": SimTypeInt(signed=False, label="UInt32"), "Type": SimTypeInt(signed=False, label="UInt32"), "__alignment2": SimTypeInt(signed=False, label="UInt32")}, name="MINIDUMP_MEMORY_INFO", pack=False, align=None)}, name="_Anonymous4_e__Struct", pack=False, align=None), "Anonymous5": SimStruct({"VmReadStatus": SimTypeInt(signed=True, label="Int32"), "VmReadBytesCompleted": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous5_e__Struct", pack=False, align=None), "Status": SimTypeInt(signed=True, label="Int32")}, name="<anon>", label="None")}, name="MINIDUMP_CALLBACK_OUTPUT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["CallbackParam", "CallbackInput", "CallbackOutput"]), offset=0), "CallbackParam": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="MINIDUMP_CALLBACK_INFORMATION", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "ProcessId", "hFile", "DumpType", "ExceptionParam", "UserStreamParam", "CallbackParam"]),
        # 
        'MiniDumpReadDumpStream': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"StreamType": SimTypeInt(signed=False, label="UInt32"), "Location": SimStruct({"DataSize": SimTypeInt(signed=False, label="UInt32"), "Rva": SimTypeInt(signed=False, label="UInt32")}, name="MINIDUMP_LOCATION_DESCRIPTOR", pack=False, align=None)}, name="MINIDUMP_DIRECTORY", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["BaseOfDump", "StreamNumber", "Dir", "StreamPointer", "StreamSize"]),
        # 
        'SymFindDebugInfoFile': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["FileHandle", "FileName", "CallerData"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hProcess", "FileName", "DebugFilePath", "Callback", "CallerData"]),
        # 
        'SymFindDebugInfoFileW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["FileHandle", "FileName", "CallerData"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hProcess", "FileName", "DebugFilePath", "Callback", "CallerData"]),
        # 
        'FindDebugInfoFile': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["FileName", "SymbolPath", "DebugFilePath"]),
        # 
        'FindDebugInfoFileEx': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["FileHandle", "FileName", "CallerData"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["FileName", "SymbolPath", "DebugFilePath", "Callback", "CallerData"]),
        # 
        'FindDebugInfoFileExW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["FileHandle", "FileName", "CallerData"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["FileName", "SymbolPath", "DebugFilePath", "Callback", "CallerData"]),
        # 
        'SymFindFileInPath': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="SYM_FIND_ID_OPTION"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["filename", "context"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hprocess", "SearchPathA", "FileName", "id", "two", "three", "flags", "FoundFile", "callback", "context"]),
        # 
        'SymFindFileInPathW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="SYM_FIND_ID_OPTION"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["filename", "context"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hprocess", "SearchPathA", "FileName", "id", "two", "three", "flags", "FoundFile", "callback", "context"]),
        # 
        'SymFindExecutableImage': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["FileHandle", "FileName", "CallerData"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hProcess", "FileName", "ImageFilePath", "Callback", "CallerData"]),
        # 
        'SymFindExecutableImageW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["FileHandle", "FileName", "CallerData"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hProcess", "FileName", "ImageFilePath", "Callback", "CallerData"]),
        # 
        'FindExecutableImage': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["FileName", "SymbolPath", "ImageFilePath"]),
        # 
        'FindExecutableImageEx': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["FileHandle", "FileName", "CallerData"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["FileName", "SymbolPath", "ImageFilePath", "Callback", "CallerData"]),
        # 
        'FindExecutableImageExW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["FileHandle", "FileName", "CallerData"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["FileName", "SymbolPath", "ImageFilePath", "Callback", "CallerData"]),
        # 
        'ImageDirectoryEntryToDataEx': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeChar(label="Byte"), SimTypeInt(signed=False, label="IMAGE_DIRECTORY_ENTRY"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"Name": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 8), "Misc": SimUnion({"PhysicalAddress": SimTypeInt(signed=False, label="UInt32"), "VirtualSize": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None"), "VirtualAddress": SimTypeInt(signed=False, label="UInt32"), "SizeOfRawData": SimTypeInt(signed=False, label="UInt32"), "PointerToRawData": SimTypeInt(signed=False, label="UInt32"), "PointerToRelocations": SimTypeInt(signed=False, label="UInt32"), "PointerToLinenumbers": SimTypeInt(signed=False, label="UInt32"), "NumberOfRelocations": SimTypeShort(signed=False, label="UInt16"), "NumberOfLinenumbers": SimTypeShort(signed=False, label="UInt16"), "Characteristics": SimTypeInt(signed=False, label="IMAGE_SECTION_CHARACTERISTICS")}, name="IMAGE_SECTION_HEADER", pack=False, align=None), offset=0), offset=0)], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["Base", "MappedAsImage", "DirectoryEntry", "Size", "FoundHeader"]),
        # 
        'ImageDirectoryEntryToData': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeChar(label="Byte"), SimTypeInt(signed=False, label="IMAGE_DIRECTORY_ENTRY"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["Base", "MappedAsImage", "DirectoryEntry", "Size"]),
        # 
        'SearchTreeForFile': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["RootPath", "InputPathName", "OutputPathBuffer"]),
        # 
        'SearchTreeForFileW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["RootPath", "InputPathName", "OutputPathBuffer"]),
        # 
        'EnumDirTree': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["FilePath", "CallerData"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "RootPath", "InputPathName", "OutputPathBuffer", "cb", "data"]),
        # 
        'EnumDirTreeW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["FilePath", "CallerData"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "RootPath", "InputPathName", "OutputPathBuffer", "cb", "data"]),
        # 
        'MakeSureDirectoryPathExists': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["DirPath"]),
        # 
        'UnDecorateSymbolName': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["name", "outputString", "maxStringLength", "flags"]),
        # 
        'UnDecorateSymbolNameW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["name", "outputString", "maxStringLength", "flags"]),
        # 
        'StackWalk64': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"AddrPC": SimStruct({"Offset": SimTypeLongLong(signed=False, label="UInt64"), "Segment": SimTypeShort(signed=False, label="UInt16"), "Mode": SimTypeInt(signed=False, label="ADDRESS_MODE")}, name="ADDRESS64", pack=False, align=None), "AddrReturn": SimStruct({"Offset": SimTypeLongLong(signed=False, label="UInt64"), "Segment": SimTypeShort(signed=False, label="UInt16"), "Mode": SimTypeInt(signed=False, label="ADDRESS_MODE")}, name="ADDRESS64", pack=False, align=None), "AddrFrame": SimStruct({"Offset": SimTypeLongLong(signed=False, label="UInt64"), "Segment": SimTypeShort(signed=False, label="UInt16"), "Mode": SimTypeInt(signed=False, label="ADDRESS_MODE")}, name="ADDRESS64", pack=False, align=None), "AddrStack": SimStruct({"Offset": SimTypeLongLong(signed=False, label="UInt64"), "Segment": SimTypeShort(signed=False, label="UInt16"), "Mode": SimTypeInt(signed=False, label="ADDRESS_MODE")}, name="ADDRESS64", pack=False, align=None), "AddrBStore": SimStruct({"Offset": SimTypeLongLong(signed=False, label="UInt64"), "Segment": SimTypeShort(signed=False, label="UInt16"), "Mode": SimTypeInt(signed=False, label="ADDRESS_MODE")}, name="ADDRESS64", pack=False, align=None), "FuncTableEntry": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Params": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 4), "Far": SimTypeInt(signed=True, label="Int32"), "Virtual": SimTypeInt(signed=True, label="Int32"), "Reserved": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 3), "KdHelp": SimStruct({"Thread": SimTypeLongLong(signed=False, label="UInt64"), "ThCallbackStack": SimTypeInt(signed=False, label="UInt32"), "ThCallbackBStore": SimTypeInt(signed=False, label="UInt32"), "NextCallback": SimTypeInt(signed=False, label="UInt32"), "FramePointer": SimTypeInt(signed=False, label="UInt32"), "KiCallUserMode": SimTypeLongLong(signed=False, label="UInt64"), "KeUserCallbackDispatcher": SimTypeLongLong(signed=False, label="UInt64"), "SystemRangeStart": SimTypeLongLong(signed=False, label="UInt64"), "KiUserExceptionDispatcher": SimTypeLongLong(signed=False, label="UInt64"), "StackBase": SimTypeLongLong(signed=False, label="UInt64"), "StackLimit": SimTypeLongLong(signed=False, label="UInt64"), "BuildVersion": SimTypeInt(signed=False, label="UInt32"), "RetpolineStubFunctionTableSize": SimTypeInt(signed=False, label="UInt32"), "RetpolineStubFunctionTable": SimTypeLongLong(signed=False, label="UInt64"), "RetpolineStubOffset": SimTypeInt(signed=False, label="UInt32"), "RetpolineStubSize": SimTypeInt(signed=False, label="UInt32"), "Reserved0": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 2)}, name="KDHELP64", pack=False, align=None)}, name="STACKFRAME64", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "qwBaseAddress", "lpBuffer", "nSize", "lpNumberOfBytesRead"]), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64")], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["ahProcess", "AddrBase"]), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64")], SimTypeLongLong(signed=False, label="UInt64"), arg_names=["hProcess", "Address"]), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"Offset": SimTypeLongLong(signed=False, label="UInt64"), "Segment": SimTypeShort(signed=False, label="UInt16"), "Mode": SimTypeInt(signed=False, label="ADDRESS_MODE")}, name="ADDRESS64", pack=False, align=None), offset=0)], SimTypeLongLong(signed=False, label="UInt64"), arg_names=["hProcess", "hThread", "lpaddr"]), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["MachineType", "hProcess", "hThread", "StackFrame", "ContextRecord", "ReadMemoryRoutine", "FunctionTableAccessRoutine", "GetModuleBaseRoutine", "TranslateAddress"]),
        # 
        'StackWalkEx': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"AddrPC": SimStruct({"Offset": SimTypeLongLong(signed=False, label="UInt64"), "Segment": SimTypeShort(signed=False, label="UInt16"), "Mode": SimTypeInt(signed=False, label="ADDRESS_MODE")}, name="ADDRESS64", pack=False, align=None), "AddrReturn": SimStruct({"Offset": SimTypeLongLong(signed=False, label="UInt64"), "Segment": SimTypeShort(signed=False, label="UInt16"), "Mode": SimTypeInt(signed=False, label="ADDRESS_MODE")}, name="ADDRESS64", pack=False, align=None), "AddrFrame": SimStruct({"Offset": SimTypeLongLong(signed=False, label="UInt64"), "Segment": SimTypeShort(signed=False, label="UInt16"), "Mode": SimTypeInt(signed=False, label="ADDRESS_MODE")}, name="ADDRESS64", pack=False, align=None), "AddrStack": SimStruct({"Offset": SimTypeLongLong(signed=False, label="UInt64"), "Segment": SimTypeShort(signed=False, label="UInt16"), "Mode": SimTypeInt(signed=False, label="ADDRESS_MODE")}, name="ADDRESS64", pack=False, align=None), "AddrBStore": SimStruct({"Offset": SimTypeLongLong(signed=False, label="UInt64"), "Segment": SimTypeShort(signed=False, label="UInt16"), "Mode": SimTypeInt(signed=False, label="ADDRESS_MODE")}, name="ADDRESS64", pack=False, align=None), "FuncTableEntry": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Params": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 4), "Far": SimTypeInt(signed=True, label="Int32"), "Virtual": SimTypeInt(signed=True, label="Int32"), "Reserved": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 3), "KdHelp": SimStruct({"Thread": SimTypeLongLong(signed=False, label="UInt64"), "ThCallbackStack": SimTypeInt(signed=False, label="UInt32"), "ThCallbackBStore": SimTypeInt(signed=False, label="UInt32"), "NextCallback": SimTypeInt(signed=False, label="UInt32"), "FramePointer": SimTypeInt(signed=False, label="UInt32"), "KiCallUserMode": SimTypeLongLong(signed=False, label="UInt64"), "KeUserCallbackDispatcher": SimTypeLongLong(signed=False, label="UInt64"), "SystemRangeStart": SimTypeLongLong(signed=False, label="UInt64"), "KiUserExceptionDispatcher": SimTypeLongLong(signed=False, label="UInt64"), "StackBase": SimTypeLongLong(signed=False, label="UInt64"), "StackLimit": SimTypeLongLong(signed=False, label="UInt64"), "BuildVersion": SimTypeInt(signed=False, label="UInt32"), "RetpolineStubFunctionTableSize": SimTypeInt(signed=False, label="UInt32"), "RetpolineStubFunctionTable": SimTypeLongLong(signed=False, label="UInt64"), "RetpolineStubOffset": SimTypeInt(signed=False, label="UInt32"), "RetpolineStubSize": SimTypeInt(signed=False, label="UInt32"), "Reserved0": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 2)}, name="KDHELP64", pack=False, align=None), "StackFrameSize": SimTypeInt(signed=False, label="UInt32"), "InlineFrameContext": SimTypeInt(signed=False, label="UInt32")}, name="STACKFRAME_EX", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "qwBaseAddress", "lpBuffer", "nSize", "lpNumberOfBytesRead"]), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64")], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["ahProcess", "AddrBase"]), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64")], SimTypeLongLong(signed=False, label="UInt64"), arg_names=["hProcess", "Address"]), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"Offset": SimTypeLongLong(signed=False, label="UInt64"), "Segment": SimTypeShort(signed=False, label="UInt16"), "Mode": SimTypeInt(signed=False, label="ADDRESS_MODE")}, name="ADDRESS64", pack=False, align=None), offset=0)], SimTypeLongLong(signed=False, label="UInt64"), arg_names=["hProcess", "hThread", "lpaddr"]), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["MachineType", "hProcess", "hThread", "StackFrame", "ContextRecord", "ReadMemoryRoutine", "FunctionTableAccessRoutine", "GetModuleBaseRoutine", "TranslateAddress", "Flags"]),
        # 
        'ImagehlpApiVersion': SimTypeFunction([], SimTypePointer(SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16"), "Revision": SimTypeShort(signed=False, label="UInt16"), "Reserved": SimTypeShort(signed=False, label="UInt16")}, name="API_VERSION", pack=False, align=None), offset=0)),
        # 
        'ImagehlpApiVersionEx': SimTypeFunction([SimTypePointer(SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16"), "Revision": SimTypeShort(signed=False, label="UInt16"), "Reserved": SimTypeShort(signed=False, label="UInt16")}, name="API_VERSION", pack=False, align=None), offset=0)], SimTypePointer(SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16"), "Revision": SimTypeShort(signed=False, label="UInt16"), "Reserved": SimTypeShort(signed=False, label="UInt16")}, name="API_VERSION", pack=False, align=None), offset=0), arg_names=["AppVersion"]),
        # 
        'GetTimestampForLoadedLibrary': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["Module"]),
        # 
        'SymSetParentWindow': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hwnd"]),
        # 
        'SymSetHomeDirectory': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypePointer(SimTypeChar(label="Byte"), offset=0), arg_names=["hProcess", "dir"]),
        # 
        'SymSetHomeDirectoryW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypePointer(SimTypeChar(label="Char"), offset=0), arg_names=["hProcess", "dir"]),
        # 
        'SymGetHomeDirectory': SimTypeFunction([SimTypeInt(signed=False, label="IMAGEHLP_HD_TYPE"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypePointer(SimTypeChar(label="Byte"), offset=0), arg_names=["type", "dir", "size"]),
        # 
        'SymGetHomeDirectoryW': SimTypeFunction([SimTypeInt(signed=False, label="IMAGEHLP_HD_TYPE"), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypePointer(SimTypeChar(label="Char"), offset=0), arg_names=["type", "dir", "size"]),
        # 
        'SymGetOmaps': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypePointer(SimStruct({"rva": SimTypeInt(signed=False, label="UInt32"), "rvaTo": SimTypeInt(signed=False, label="UInt32")}, name="OMAP", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"rva": SimTypeInt(signed=False, label="UInt32"), "rvaTo": SimTypeInt(signed=False, label="UInt32")}, name="OMAP", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "BaseOfDll", "OmapTo", "cOmapTo", "OmapFrom", "cOmapFrom"]),
        # 
        'SymSetOptions': SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["SymOptions"]),
        # 
        'SymGetOptions': SimTypeFunction([], SimTypeInt(signed=False, label="UInt32")),
        # 
        'SymCleanup': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess"]),
        # 
        'SymGetExtendedOption': SimTypeFunction([SimTypeInt(signed=False, label="IMAGEHLP_EXTENDED_OPTIONS")], SimTypeInt(signed=True, label="Int32"), arg_names=["option"]),
        # 
        'SymSetExtendedOption': SimTypeFunction([SimTypeInt(signed=False, label="IMAGEHLP_EXTENDED_OPTIONS"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["option", "value"]),
        # 
        'SymMatchString': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["string", "expression", "fCase"]),
        # 
        'SymMatchStringA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["string", "expression", "fCase"]),
        # 
        'SymMatchStringW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["string", "expression", "fCase"]),
        # 
        'SymEnumSourceFiles': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"ModBase": SimTypeLongLong(signed=False, label="UInt64"), "FileName": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SOURCEFILE", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pSourceFile", "UserContext"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "ModBase", "Mask", "cbSrcFiles", "UserContext"]),
        # 
        'SymEnumSourceFilesW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"ModBase": SimTypeLongLong(signed=False, label="UInt64"), "FileName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="SOURCEFILEW", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pSourceFile", "UserContext"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "ModBase", "Mask", "cbSrcFiles", "UserContext"]),
        # 
        'SymEnumerateModules64': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ModuleName", "BaseOfDll", "UserContext"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "EnumModulesCallback", "UserContext"]),
        # 
        'SymEnumerateModulesW64': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ModuleName", "BaseOfDll", "UserContext"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "EnumModulesCallback", "UserContext"]),
        # 
        'EnumerateLoadedModulesEx': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ModuleName", "ModuleBase", "ModuleSize", "UserContext"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "EnumLoadedModulesCallback", "UserContext"]),
        # 
        'EnumerateLoadedModulesExW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ModuleName", "ModuleBase", "ModuleSize", "UserContext"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "EnumLoadedModulesCallback", "UserContext"]),
        # 
        'EnumerateLoadedModules64': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ModuleName", "ModuleBase", "ModuleSize", "UserContext"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "EnumLoadedModulesCallback", "UserContext"]),
        # 
        'EnumerateLoadedModulesW64': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ModuleName", "ModuleBase", "ModuleSize", "UserContext"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "EnumLoadedModulesCallback", "UserContext"]),
        # 
        'SymFunctionTableAccess64': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64")], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["hProcess", "AddrBase"]),
        # 
        'SymFunctionTableAccess64AccessRoutines': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "qwBaseAddress", "lpBuffer", "nSize", "lpNumberOfBytesRead"]), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64")], SimTypeLongLong(signed=False, label="UInt64"), arg_names=["hProcess", "Address"]), offset=0)], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["hProcess", "AddrBase", "ReadMemoryRoutine", "GetModuleBaseRoutine"]),
        # 
        'SymGetUnwindInfo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "Address", "Buffer", "Size"]),
        # 
        'SymGetModuleInfo64': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "BaseOfImage": SimTypeLongLong(signed=False, label="UInt64"), "ImageSize": SimTypeInt(signed=False, label="UInt32"), "TimeDateStamp": SimTypeInt(signed=False, label="UInt32"), "CheckSum": SimTypeInt(signed=False, label="UInt32"), "NumSyms": SimTypeInt(signed=False, label="UInt32"), "SymType": SimTypeInt(signed=False, label="SYM_TYPE"), "ModuleName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 32), "ImageName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 256), "LoadedImageName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 256), "LoadedPdbName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 256), "CVSig": SimTypeInt(signed=False, label="UInt32"), "CVData": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 780), "PdbSig": SimTypeInt(signed=False, label="UInt32"), "PdbSig70": SimTypeBottom(label="Guid"), "PdbAge": SimTypeInt(signed=False, label="UInt32"), "PdbUnmatched": SimTypeInt(signed=True, label="Int32"), "DbgUnmatched": SimTypeInt(signed=True, label="Int32"), "LineNumbers": SimTypeInt(signed=True, label="Int32"), "GlobalSymbols": SimTypeInt(signed=True, label="Int32"), "TypeInfo": SimTypeInt(signed=True, label="Int32"), "SourceIndexed": SimTypeInt(signed=True, label="Int32"), "Publics": SimTypeInt(signed=True, label="Int32"), "MachineType": SimTypeInt(signed=False, label="UInt32"), "Reserved": SimTypeInt(signed=False, label="UInt32")}, name="IMAGEHLP_MODULE64", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "qwAddr", "ModuleInfo"]),
        # 
        'SymGetModuleInfoW64': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "BaseOfImage": SimTypeLongLong(signed=False, label="UInt64"), "ImageSize": SimTypeInt(signed=False, label="UInt32"), "TimeDateStamp": SimTypeInt(signed=False, label="UInt32"), "CheckSum": SimTypeInt(signed=False, label="UInt32"), "NumSyms": SimTypeInt(signed=False, label="UInt32"), "SymType": SimTypeInt(signed=False, label="SYM_TYPE"), "ModuleName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 32), "ImageName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 256), "LoadedImageName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 256), "LoadedPdbName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 256), "CVSig": SimTypeInt(signed=False, label="UInt32"), "CVData": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 780), "PdbSig": SimTypeInt(signed=False, label="UInt32"), "PdbSig70": SimTypeBottom(label="Guid"), "PdbAge": SimTypeInt(signed=False, label="UInt32"), "PdbUnmatched": SimTypeInt(signed=True, label="Int32"), "DbgUnmatched": SimTypeInt(signed=True, label="Int32"), "LineNumbers": SimTypeInt(signed=True, label="Int32"), "GlobalSymbols": SimTypeInt(signed=True, label="Int32"), "TypeInfo": SimTypeInt(signed=True, label="Int32"), "SourceIndexed": SimTypeInt(signed=True, label="Int32"), "Publics": SimTypeInt(signed=True, label="Int32"), "MachineType": SimTypeInt(signed=False, label="UInt32"), "Reserved": SimTypeInt(signed=False, label="UInt32")}, name="IMAGEHLP_MODULEW64", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "qwAddr", "ModuleInfo"]),
        # 
        'SymGetModuleBase64': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64")], SimTypeLongLong(signed=False, label="UInt64"), arg_names=["hProcess", "qwAddr"]),
        # 
        'SymEnumLines': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "Key": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ModBase": SimTypeLongLong(signed=False, label="UInt64"), "Obj": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 261), "FileName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 261), "LineNumber": SimTypeInt(signed=False, label="UInt32"), "Address": SimTypeLongLong(signed=False, label="UInt64")}, name="SRCCODEINFO", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["LineInfo", "UserContext"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "Base", "Obj", "File", "EnumLinesCallback", "UserContext"]),
        # 
        'SymEnumLinesW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "Key": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ModBase": SimTypeLongLong(signed=False, label="UInt64"), "Obj": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 261), "FileName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 261), "LineNumber": SimTypeInt(signed=False, label="UInt32"), "Address": SimTypeLongLong(signed=False, label="UInt64")}, name="SRCCODEINFOW", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["LineInfo", "UserContext"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "Base", "Obj", "File", "EnumLinesCallback", "UserContext"]),
        # 
        'SymGetLineFromAddr64': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "Key": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "LineNumber": SimTypeInt(signed=False, label="UInt32"), "FileName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Address": SimTypeLongLong(signed=False, label="UInt64")}, name="IMAGEHLP_LINE64", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "qwAddr", "pdwDisplacement", "Line64"]),
        # 
        'SymGetLineFromAddrW64': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "Key": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "LineNumber": SimTypeInt(signed=False, label="UInt32"), "FileName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Address": SimTypeLongLong(signed=False, label="UInt64")}, name="IMAGEHLP_LINEW64", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "dwAddr", "pdwDisplacement", "Line"]),
        # 
        'SymGetLineFromInlineContext': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypeInt(signed=False, label="UInt32"), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "Key": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "LineNumber": SimTypeInt(signed=False, label="UInt32"), "FileName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Address": SimTypeLongLong(signed=False, label="UInt64")}, name="IMAGEHLP_LINE64", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "qwAddr", "InlineContext", "qwModuleBaseAddress", "pdwDisplacement", "Line64"]),
        # 
        'SymGetLineFromInlineContextW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypeInt(signed=False, label="UInt32"), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "Key": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "LineNumber": SimTypeInt(signed=False, label="UInt32"), "FileName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Address": SimTypeLongLong(signed=False, label="UInt64")}, name="IMAGEHLP_LINEW64", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "dwAddr", "InlineContext", "qwModuleBaseAddress", "pdwDisplacement", "Line"]),
        # 
        'SymEnumSourceLines': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "Key": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ModBase": SimTypeLongLong(signed=False, label="UInt64"), "Obj": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 261), "FileName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 261), "LineNumber": SimTypeInt(signed=False, label="UInt32"), "Address": SimTypeLongLong(signed=False, label="UInt64")}, name="SRCCODEINFO", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["LineInfo", "UserContext"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "Base", "Obj", "File", "Line", "Flags", "EnumLinesCallback", "UserContext"]),
        # 
        'SymEnumSourceLinesW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "Key": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ModBase": SimTypeLongLong(signed=False, label="UInt64"), "Obj": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 261), "FileName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 261), "LineNumber": SimTypeInt(signed=False, label="UInt32"), "Address": SimTypeLongLong(signed=False, label="UInt64")}, name="SRCCODEINFOW", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["LineInfo", "UserContext"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "Base", "Obj", "File", "Line", "Flags", "EnumLinesCallback", "UserContext"]),
        # 
        'SymAddrIncludeInlineTrace': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hProcess", "Address"]),
        # 
        'SymCompareInlineTrace': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypeInt(signed=False, label="UInt32"), SimTypeLongLong(signed=False, label="UInt64"), SimTypeLongLong(signed=False, label="UInt64"), SimTypeLongLong(signed=False, label="UInt64")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hProcess", "Address1", "InlineContext1", "RetAddress1", "Address2", "RetAddress2"]),
        # 
        'SymQueryInlineTrace': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypeInt(signed=False, label="UInt32"), SimTypeLongLong(signed=False, label="UInt64"), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "StartAddress", "StartContext", "StartRetAddress", "CurAddress", "CurContext", "CurFrameIndex"]),
        # 
        'SymGetLineFromName64': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "Key": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "LineNumber": SimTypeInt(signed=False, label="UInt32"), "FileName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Address": SimTypeLongLong(signed=False, label="UInt64")}, name="IMAGEHLP_LINE64", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "ModuleName", "FileName", "dwLineNumber", "plDisplacement", "Line"]),
        # 
        'SymGetLineFromNameW64': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "Key": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "LineNumber": SimTypeInt(signed=False, label="UInt32"), "FileName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Address": SimTypeLongLong(signed=False, label="UInt64")}, name="IMAGEHLP_LINEW64", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "ModuleName", "FileName", "dwLineNumber", "plDisplacement", "Line"]),
        # 
        'SymGetLineNext64': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "Key": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "LineNumber": SimTypeInt(signed=False, label="UInt32"), "FileName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Address": SimTypeLongLong(signed=False, label="UInt64")}, name="IMAGEHLP_LINE64", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "Line"]),
        # 
        'SymGetLineNextW64': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "Key": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "LineNumber": SimTypeInt(signed=False, label="UInt32"), "FileName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Address": SimTypeLongLong(signed=False, label="UInt64")}, name="IMAGEHLP_LINEW64", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "Line"]),
        # 
        'SymGetLinePrev64': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "Key": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "LineNumber": SimTypeInt(signed=False, label="UInt32"), "FileName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Address": SimTypeLongLong(signed=False, label="UInt64")}, name="IMAGEHLP_LINE64", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "Line"]),
        # 
        'SymGetLinePrevW64': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "Key": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "LineNumber": SimTypeInt(signed=False, label="UInt32"), "FileName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Address": SimTypeLongLong(signed=False, label="UInt64")}, name="IMAGEHLP_LINEW64", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "Line"]),
        # 
        'SymGetFileLineOffsets64': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hProcess", "ModuleName", "FileName", "Buffer", "BufferLines"]),
        # 
        'SymMatchFileName': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["FileName", "Match", "FileNameStop", "MatchStop"]),
        # 
        'SymMatchFileNameW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["FileName", "Match", "FileNameStop", "MatchStop"]),
        # 
        'SymGetSourceFile': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "Base", "Params", "FileSpec", "FilePath", "Size"]),
        # 
        'SymGetSourceFileW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "Base", "Params", "FileSpec", "FilePath", "Size"]),
        # 
        'SymGetSourceFileToken': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "Base", "FileSpec", "Token", "Size"]),
        # 
        'SymGetSourceFileChecksumW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "Base", "FileSpec", "pCheckSumType", "pChecksum", "checksumSize", "pActualBytesWritten"]),
        # 
        'SymGetSourceFileChecksum': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "Base", "FileSpec", "pCheckSumType", "pChecksum", "checksumSize", "pActualBytesWritten"]),
        # 
        'SymGetSourceFileTokenW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "Base", "FileSpec", "Token", "Size"]),
        # 
        'SymGetSourceFileFromToken': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "Token", "Params", "FilePath", "Size"]),
        # 
        'SymGetSourceFileFromTokenW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "Token", "Params", "FilePath", "Size"]),
        # 
        'SymGetSourceVarFromToken': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "Token", "Params", "VarName", "Value", "Size"]),
        # 
        'SymGetSourceVarFromTokenW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "Token", "Params", "VarName", "Value", "Size"]),
        # 
        'SymEnumSourceFileTokens': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["token", "size"]), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "Base", "Callback"]),
        # 
        'SymInitialize': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "UserSearchPath", "fInvadeProcess"]),
        # 
        'SymInitializeW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "UserSearchPath", "fInvadeProcess"]),
        # 
        'SymGetSearchPath': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "SearchPathA", "SearchPathLength"]),
        # 
        'SymGetSearchPathW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "SearchPathA", "SearchPathLength"]),
        # 
        'SymSetSearchPath': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "SearchPathA"]),
        # 
        'SymSetSearchPathW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "SearchPathA"]),
        # 
        'SymLoadModuleEx': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"ssize": SimTypeInt(signed=False, label="UInt32"), "ssig": SimTypeInt(signed=False, label="MODLOAD_DATA_TYPE"), "data": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "size": SimTypeInt(signed=False, label="UInt32"), "flags": SimTypeInt(signed=False, label="UInt32")}, name="MODLOAD_DATA", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="SYM_LOAD_FLAGS")], SimTypeLongLong(signed=False, label="UInt64"), arg_names=["hProcess", "hFile", "ImageName", "ModuleName", "BaseOfDll", "DllSize", "Data", "Flags"]),
        # 
        'SymLoadModuleExW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"ssize": SimTypeInt(signed=False, label="UInt32"), "ssig": SimTypeInt(signed=False, label="MODLOAD_DATA_TYPE"), "data": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "size": SimTypeInt(signed=False, label="UInt32"), "flags": SimTypeInt(signed=False, label="UInt32")}, name="MODLOAD_DATA", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="SYM_LOAD_FLAGS")], SimTypeLongLong(signed=False, label="UInt64"), arg_names=["hProcess", "hFile", "ImageName", "ModuleName", "BaseOfDll", "DllSize", "Data", "Flags"]),
        # 
        'SymUnloadModule64': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64")], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "BaseOfDll"]),
        # 
        'SymUnDName64': SimTypeFunction([SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "Address": SimTypeLongLong(signed=False, label="UInt64"), "Size": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="UInt32"), "MaxNameLength": SimTypeInt(signed=False, label="UInt32"), "Name": SimTypePointer(SimTypeBottom(label="CHAR"), offset=0)}, name="IMAGEHLP_SYMBOL64", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sym", "UnDecName", "UnDecNameLength"]),
        # 
        'SymRegisterCallback64': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeLongLong(signed=False, label="UInt64"), SimTypeLongLong(signed=False, label="UInt64")], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "ActionCode", "CallbackData", "UserContext"]), offset=0), SimTypeLongLong(signed=False, label="UInt64")], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "CallbackFunction", "UserContext"]),
        # 
        'SymRegisterCallbackW64': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeLongLong(signed=False, label="UInt64"), SimTypeLongLong(signed=False, label="UInt64")], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "ActionCode", "CallbackData", "UserContext"]), offset=0), SimTypeLongLong(signed=False, label="UInt64")], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "CallbackFunction", "UserContext"]),
        # 
        'SymRegisterFunctionEntryCallback64': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypeLongLong(signed=False, label="UInt64")], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["hProcess", "AddrBase", "UserContext"]), offset=0), SimTypeLongLong(signed=False, label="UInt64")], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "CallbackFunction", "UserContext"]),
        # 
        'SymSetContext': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"InstructionOffset": SimTypeLongLong(signed=False, label="UInt64"), "ReturnOffset": SimTypeLongLong(signed=False, label="UInt64"), "FrameOffset": SimTypeLongLong(signed=False, label="UInt64"), "StackOffset": SimTypeLongLong(signed=False, label="UInt64"), "BackingStoreOffset": SimTypeLongLong(signed=False, label="UInt64"), "FuncTableEntry": SimTypeLongLong(signed=False, label="UInt64"), "Params": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 4), "Reserved": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 5), "Virtual": SimTypeInt(signed=True, label="Int32"), "Reserved2": SimTypeInt(signed=False, label="UInt32")}, name="IMAGEHLP_STACK_FRAME", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "StackFrame", "Context"]),
        # 
        'SymSetScopeFromAddr': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64")], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "Address"]),
        # 
        'SymSetScopeFromInlineContext': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "Address", "InlineContext"]),
        # 
        'SymSetScopeFromIndex': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "BaseOfDll", "Index"]),
        # 
        'SymEnumProcesses': SimTypeFunction([SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "UserContext"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["EnumProcessesCallback", "UserContext"]),
        # 
        'SymFromAddr': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0), SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "TypeIndex": SimTypeInt(signed=False, label="UInt32"), "Reserved": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 2), "Index": SimTypeInt(signed=False, label="UInt32"), "Size": SimTypeInt(signed=False, label="UInt32"), "ModBase": SimTypeLongLong(signed=False, label="UInt64"), "Flags": SimTypeInt(signed=False, label="SYMBOL_INFO_FLAGS"), "Value": SimTypeLongLong(signed=False, label="UInt64"), "Address": SimTypeLongLong(signed=False, label="UInt64"), "Register": SimTypeInt(signed=False, label="UInt32"), "Scope": SimTypeInt(signed=False, label="UInt32"), "Tag": SimTypeInt(signed=False, label="UInt32"), "NameLen": SimTypeInt(signed=False, label="UInt32"), "MaxNameLen": SimTypeInt(signed=False, label="UInt32"), "Name": SimTypePointer(SimTypeBottom(label="CHAR"), offset=0)}, name="SYMBOL_INFO", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "Address", "Displacement", "Symbol"]),
        # 
        'SymFromAddrW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0), SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "TypeIndex": SimTypeInt(signed=False, label="UInt32"), "Reserved": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 2), "Index": SimTypeInt(signed=False, label="UInt32"), "Size": SimTypeInt(signed=False, label="UInt32"), "ModBase": SimTypeLongLong(signed=False, label="UInt64"), "Flags": SimTypeInt(signed=False, label="SYMBOL_INFO_FLAGS"), "Value": SimTypeLongLong(signed=False, label="UInt64"), "Address": SimTypeLongLong(signed=False, label="UInt64"), "Register": SimTypeInt(signed=False, label="UInt32"), "Scope": SimTypeInt(signed=False, label="UInt32"), "Tag": SimTypeInt(signed=False, label="UInt32"), "NameLen": SimTypeInt(signed=False, label="UInt32"), "MaxNameLen": SimTypeInt(signed=False, label="UInt32"), "Name": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="SYMBOL_INFOW", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "Address", "Displacement", "Symbol"]),
        # 
        'SymFromInlineContext': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0), SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "TypeIndex": SimTypeInt(signed=False, label="UInt32"), "Reserved": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 2), "Index": SimTypeInt(signed=False, label="UInt32"), "Size": SimTypeInt(signed=False, label="UInt32"), "ModBase": SimTypeLongLong(signed=False, label="UInt64"), "Flags": SimTypeInt(signed=False, label="SYMBOL_INFO_FLAGS"), "Value": SimTypeLongLong(signed=False, label="UInt64"), "Address": SimTypeLongLong(signed=False, label="UInt64"), "Register": SimTypeInt(signed=False, label="UInt32"), "Scope": SimTypeInt(signed=False, label="UInt32"), "Tag": SimTypeInt(signed=False, label="UInt32"), "NameLen": SimTypeInt(signed=False, label="UInt32"), "MaxNameLen": SimTypeInt(signed=False, label="UInt32"), "Name": SimTypePointer(SimTypeBottom(label="CHAR"), offset=0)}, name="SYMBOL_INFO", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "Address", "InlineContext", "Displacement", "Symbol"]),
        # 
        'SymFromInlineContextW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0), SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "TypeIndex": SimTypeInt(signed=False, label="UInt32"), "Reserved": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 2), "Index": SimTypeInt(signed=False, label="UInt32"), "Size": SimTypeInt(signed=False, label="UInt32"), "ModBase": SimTypeLongLong(signed=False, label="UInt64"), "Flags": SimTypeInt(signed=False, label="SYMBOL_INFO_FLAGS"), "Value": SimTypeLongLong(signed=False, label="UInt64"), "Address": SimTypeLongLong(signed=False, label="UInt64"), "Register": SimTypeInt(signed=False, label="UInt32"), "Scope": SimTypeInt(signed=False, label="UInt32"), "Tag": SimTypeInt(signed=False, label="UInt32"), "NameLen": SimTypeInt(signed=False, label="UInt32"), "MaxNameLen": SimTypeInt(signed=False, label="UInt32"), "Name": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="SYMBOL_INFOW", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "Address", "InlineContext", "Displacement", "Symbol"]),
        # 
        'SymFromToken': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "TypeIndex": SimTypeInt(signed=False, label="UInt32"), "Reserved": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 2), "Index": SimTypeInt(signed=False, label="UInt32"), "Size": SimTypeInt(signed=False, label="UInt32"), "ModBase": SimTypeLongLong(signed=False, label="UInt64"), "Flags": SimTypeInt(signed=False, label="SYMBOL_INFO_FLAGS"), "Value": SimTypeLongLong(signed=False, label="UInt64"), "Address": SimTypeLongLong(signed=False, label="UInt64"), "Register": SimTypeInt(signed=False, label="UInt32"), "Scope": SimTypeInt(signed=False, label="UInt32"), "Tag": SimTypeInt(signed=False, label="UInt32"), "NameLen": SimTypeInt(signed=False, label="UInt32"), "MaxNameLen": SimTypeInt(signed=False, label="UInt32"), "Name": SimTypePointer(SimTypeBottom(label="CHAR"), offset=0)}, name="SYMBOL_INFO", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "Base", "Token", "Symbol"]),
        # 
        'SymFromTokenW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "TypeIndex": SimTypeInt(signed=False, label="UInt32"), "Reserved": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 2), "Index": SimTypeInt(signed=False, label="UInt32"), "Size": SimTypeInt(signed=False, label="UInt32"), "ModBase": SimTypeLongLong(signed=False, label="UInt64"), "Flags": SimTypeInt(signed=False, label="SYMBOL_INFO_FLAGS"), "Value": SimTypeLongLong(signed=False, label="UInt64"), "Address": SimTypeLongLong(signed=False, label="UInt64"), "Register": SimTypeInt(signed=False, label="UInt32"), "Scope": SimTypeInt(signed=False, label="UInt32"), "Tag": SimTypeInt(signed=False, label="UInt32"), "NameLen": SimTypeInt(signed=False, label="UInt32"), "MaxNameLen": SimTypeInt(signed=False, label="UInt32"), "Name": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="SYMBOL_INFOW", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "Base", "Token", "Symbol"]),
        # 
        'SymNext': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "TypeIndex": SimTypeInt(signed=False, label="UInt32"), "Reserved": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 2), "Index": SimTypeInt(signed=False, label="UInt32"), "Size": SimTypeInt(signed=False, label="UInt32"), "ModBase": SimTypeLongLong(signed=False, label="UInt64"), "Flags": SimTypeInt(signed=False, label="SYMBOL_INFO_FLAGS"), "Value": SimTypeLongLong(signed=False, label="UInt64"), "Address": SimTypeLongLong(signed=False, label="UInt64"), "Register": SimTypeInt(signed=False, label="UInt32"), "Scope": SimTypeInt(signed=False, label="UInt32"), "Tag": SimTypeInt(signed=False, label="UInt32"), "NameLen": SimTypeInt(signed=False, label="UInt32"), "MaxNameLen": SimTypeInt(signed=False, label="UInt32"), "Name": SimTypePointer(SimTypeBottom(label="CHAR"), offset=0)}, name="SYMBOL_INFO", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "si"]),
        # 
        'SymNextW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "TypeIndex": SimTypeInt(signed=False, label="UInt32"), "Reserved": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 2), "Index": SimTypeInt(signed=False, label="UInt32"), "Size": SimTypeInt(signed=False, label="UInt32"), "ModBase": SimTypeLongLong(signed=False, label="UInt64"), "Flags": SimTypeInt(signed=False, label="SYMBOL_INFO_FLAGS"), "Value": SimTypeLongLong(signed=False, label="UInt64"), "Address": SimTypeLongLong(signed=False, label="UInt64"), "Register": SimTypeInt(signed=False, label="UInt32"), "Scope": SimTypeInt(signed=False, label="UInt32"), "Tag": SimTypeInt(signed=False, label="UInt32"), "NameLen": SimTypeInt(signed=False, label="UInt32"), "MaxNameLen": SimTypeInt(signed=False, label="UInt32"), "Name": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="SYMBOL_INFOW", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "siw"]),
        # 
        'SymPrev': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "TypeIndex": SimTypeInt(signed=False, label="UInt32"), "Reserved": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 2), "Index": SimTypeInt(signed=False, label="UInt32"), "Size": SimTypeInt(signed=False, label="UInt32"), "ModBase": SimTypeLongLong(signed=False, label="UInt64"), "Flags": SimTypeInt(signed=False, label="SYMBOL_INFO_FLAGS"), "Value": SimTypeLongLong(signed=False, label="UInt64"), "Address": SimTypeLongLong(signed=False, label="UInt64"), "Register": SimTypeInt(signed=False, label="UInt32"), "Scope": SimTypeInt(signed=False, label="UInt32"), "Tag": SimTypeInt(signed=False, label="UInt32"), "NameLen": SimTypeInt(signed=False, label="UInt32"), "MaxNameLen": SimTypeInt(signed=False, label="UInt32"), "Name": SimTypePointer(SimTypeBottom(label="CHAR"), offset=0)}, name="SYMBOL_INFO", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "si"]),
        # 
        'SymPrevW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "TypeIndex": SimTypeInt(signed=False, label="UInt32"), "Reserved": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 2), "Index": SimTypeInt(signed=False, label="UInt32"), "Size": SimTypeInt(signed=False, label="UInt32"), "ModBase": SimTypeLongLong(signed=False, label="UInt64"), "Flags": SimTypeInt(signed=False, label="SYMBOL_INFO_FLAGS"), "Value": SimTypeLongLong(signed=False, label="UInt64"), "Address": SimTypeLongLong(signed=False, label="UInt64"), "Register": SimTypeInt(signed=False, label="UInt32"), "Scope": SimTypeInt(signed=False, label="UInt32"), "Tag": SimTypeInt(signed=False, label="UInt32"), "NameLen": SimTypeInt(signed=False, label="UInt32"), "MaxNameLen": SimTypeInt(signed=False, label="UInt32"), "Name": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="SYMBOL_INFOW", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "siw"]),
        # 
        'SymFromName': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "TypeIndex": SimTypeInt(signed=False, label="UInt32"), "Reserved": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 2), "Index": SimTypeInt(signed=False, label="UInt32"), "Size": SimTypeInt(signed=False, label="UInt32"), "ModBase": SimTypeLongLong(signed=False, label="UInt64"), "Flags": SimTypeInt(signed=False, label="SYMBOL_INFO_FLAGS"), "Value": SimTypeLongLong(signed=False, label="UInt64"), "Address": SimTypeLongLong(signed=False, label="UInt64"), "Register": SimTypeInt(signed=False, label="UInt32"), "Scope": SimTypeInt(signed=False, label="UInt32"), "Tag": SimTypeInt(signed=False, label="UInt32"), "NameLen": SimTypeInt(signed=False, label="UInt32"), "MaxNameLen": SimTypeInt(signed=False, label="UInt32"), "Name": SimTypePointer(SimTypeBottom(label="CHAR"), offset=0)}, name="SYMBOL_INFO", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "Name", "Symbol"]),
        # 
        'SymFromNameW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "TypeIndex": SimTypeInt(signed=False, label="UInt32"), "Reserved": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 2), "Index": SimTypeInt(signed=False, label="UInt32"), "Size": SimTypeInt(signed=False, label="UInt32"), "ModBase": SimTypeLongLong(signed=False, label="UInt64"), "Flags": SimTypeInt(signed=False, label="SYMBOL_INFO_FLAGS"), "Value": SimTypeLongLong(signed=False, label="UInt64"), "Address": SimTypeLongLong(signed=False, label="UInt64"), "Register": SimTypeInt(signed=False, label="UInt32"), "Scope": SimTypeInt(signed=False, label="UInt32"), "Tag": SimTypeInt(signed=False, label="UInt32"), "NameLen": SimTypeInt(signed=False, label="UInt32"), "MaxNameLen": SimTypeInt(signed=False, label="UInt32"), "Name": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="SYMBOL_INFOW", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "Name", "Symbol"]),
        # 
        'SymEnumSymbols': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "TypeIndex": SimTypeInt(signed=False, label="UInt32"), "Reserved": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 2), "Index": SimTypeInt(signed=False, label="UInt32"), "Size": SimTypeInt(signed=False, label="UInt32"), "ModBase": SimTypeLongLong(signed=False, label="UInt64"), "Flags": SimTypeInt(signed=False, label="SYMBOL_INFO_FLAGS"), "Value": SimTypeLongLong(signed=False, label="UInt64"), "Address": SimTypeLongLong(signed=False, label="UInt64"), "Register": SimTypeInt(signed=False, label="UInt32"), "Scope": SimTypeInt(signed=False, label="UInt32"), "Tag": SimTypeInt(signed=False, label="UInt32"), "NameLen": SimTypeInt(signed=False, label="UInt32"), "MaxNameLen": SimTypeInt(signed=False, label="UInt32"), "Name": SimTypePointer(SimTypeBottom(label="CHAR"), offset=0)}, name="SYMBOL_INFO", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pSymInfo", "SymbolSize", "UserContext"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "BaseOfDll", "Mask", "EnumSymbolsCallback", "UserContext"]),
        # 
        'SymEnumSymbolsEx': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "TypeIndex": SimTypeInt(signed=False, label="UInt32"), "Reserved": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 2), "Index": SimTypeInt(signed=False, label="UInt32"), "Size": SimTypeInt(signed=False, label="UInt32"), "ModBase": SimTypeLongLong(signed=False, label="UInt64"), "Flags": SimTypeInt(signed=False, label="SYMBOL_INFO_FLAGS"), "Value": SimTypeLongLong(signed=False, label="UInt64"), "Address": SimTypeLongLong(signed=False, label="UInt64"), "Register": SimTypeInt(signed=False, label="UInt32"), "Scope": SimTypeInt(signed=False, label="UInt32"), "Tag": SimTypeInt(signed=False, label="UInt32"), "NameLen": SimTypeInt(signed=False, label="UInt32"), "MaxNameLen": SimTypeInt(signed=False, label="UInt32"), "Name": SimTypePointer(SimTypeBottom(label="CHAR"), offset=0)}, name="SYMBOL_INFO", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pSymInfo", "SymbolSize", "UserContext"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "BaseOfDll", "Mask", "EnumSymbolsCallback", "UserContext", "Options"]),
        # 
        'SymEnumSymbolsW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "TypeIndex": SimTypeInt(signed=False, label="UInt32"), "Reserved": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 2), "Index": SimTypeInt(signed=False, label="UInt32"), "Size": SimTypeInt(signed=False, label="UInt32"), "ModBase": SimTypeLongLong(signed=False, label="UInt64"), "Flags": SimTypeInt(signed=False, label="SYMBOL_INFO_FLAGS"), "Value": SimTypeLongLong(signed=False, label="UInt64"), "Address": SimTypeLongLong(signed=False, label="UInt64"), "Register": SimTypeInt(signed=False, label="UInt32"), "Scope": SimTypeInt(signed=False, label="UInt32"), "Tag": SimTypeInt(signed=False, label="UInt32"), "NameLen": SimTypeInt(signed=False, label="UInt32"), "MaxNameLen": SimTypeInt(signed=False, label="UInt32"), "Name": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="SYMBOL_INFOW", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pSymInfo", "SymbolSize", "UserContext"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "BaseOfDll", "Mask", "EnumSymbolsCallback", "UserContext"]),
        # 
        'SymEnumSymbolsExW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "TypeIndex": SimTypeInt(signed=False, label="UInt32"), "Reserved": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 2), "Index": SimTypeInt(signed=False, label="UInt32"), "Size": SimTypeInt(signed=False, label="UInt32"), "ModBase": SimTypeLongLong(signed=False, label="UInt64"), "Flags": SimTypeInt(signed=False, label="SYMBOL_INFO_FLAGS"), "Value": SimTypeLongLong(signed=False, label="UInt64"), "Address": SimTypeLongLong(signed=False, label="UInt64"), "Register": SimTypeInt(signed=False, label="UInt32"), "Scope": SimTypeInt(signed=False, label="UInt32"), "Tag": SimTypeInt(signed=False, label="UInt32"), "NameLen": SimTypeInt(signed=False, label="UInt32"), "MaxNameLen": SimTypeInt(signed=False, label="UInt32"), "Name": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="SYMBOL_INFOW", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pSymInfo", "SymbolSize", "UserContext"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "BaseOfDll", "Mask", "EnumSymbolsCallback", "UserContext", "Options"]),
        # 
        'SymEnumSymbolsForAddr': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "TypeIndex": SimTypeInt(signed=False, label="UInt32"), "Reserved": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 2), "Index": SimTypeInt(signed=False, label="UInt32"), "Size": SimTypeInt(signed=False, label="UInt32"), "ModBase": SimTypeLongLong(signed=False, label="UInt64"), "Flags": SimTypeInt(signed=False, label="SYMBOL_INFO_FLAGS"), "Value": SimTypeLongLong(signed=False, label="UInt64"), "Address": SimTypeLongLong(signed=False, label="UInt64"), "Register": SimTypeInt(signed=False, label="UInt32"), "Scope": SimTypeInt(signed=False, label="UInt32"), "Tag": SimTypeInt(signed=False, label="UInt32"), "NameLen": SimTypeInt(signed=False, label="UInt32"), "MaxNameLen": SimTypeInt(signed=False, label="UInt32"), "Name": SimTypePointer(SimTypeBottom(label="CHAR"), offset=0)}, name="SYMBOL_INFO", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pSymInfo", "SymbolSize", "UserContext"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "Address", "EnumSymbolsCallback", "UserContext"]),
        # 
        'SymEnumSymbolsForAddrW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "TypeIndex": SimTypeInt(signed=False, label="UInt32"), "Reserved": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 2), "Index": SimTypeInt(signed=False, label="UInt32"), "Size": SimTypeInt(signed=False, label="UInt32"), "ModBase": SimTypeLongLong(signed=False, label="UInt64"), "Flags": SimTypeInt(signed=False, label="SYMBOL_INFO_FLAGS"), "Value": SimTypeLongLong(signed=False, label="UInt64"), "Address": SimTypeLongLong(signed=False, label="UInt64"), "Register": SimTypeInt(signed=False, label="UInt32"), "Scope": SimTypeInt(signed=False, label="UInt32"), "Tag": SimTypeInt(signed=False, label="UInt32"), "NameLen": SimTypeInt(signed=False, label="UInt32"), "MaxNameLen": SimTypeInt(signed=False, label="UInt32"), "Name": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="SYMBOL_INFOW", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pSymInfo", "SymbolSize", "UserContext"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "Address", "EnumSymbolsCallback", "UserContext"]),
        # 
        'SymSearch': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "TypeIndex": SimTypeInt(signed=False, label="UInt32"), "Reserved": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 2), "Index": SimTypeInt(signed=False, label="UInt32"), "Size": SimTypeInt(signed=False, label="UInt32"), "ModBase": SimTypeLongLong(signed=False, label="UInt64"), "Flags": SimTypeInt(signed=False, label="SYMBOL_INFO_FLAGS"), "Value": SimTypeLongLong(signed=False, label="UInt64"), "Address": SimTypeLongLong(signed=False, label="UInt64"), "Register": SimTypeInt(signed=False, label="UInt32"), "Scope": SimTypeInt(signed=False, label="UInt32"), "Tag": SimTypeInt(signed=False, label="UInt32"), "NameLen": SimTypeInt(signed=False, label="UInt32"), "MaxNameLen": SimTypeInt(signed=False, label="UInt32"), "Name": SimTypePointer(SimTypeBottom(label="CHAR"), offset=0)}, name="SYMBOL_INFO", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pSymInfo", "SymbolSize", "UserContext"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "BaseOfDll", "Index", "SymTag", "Mask", "Address", "EnumSymbolsCallback", "UserContext", "Options"]),
        # 
        'SymSearchW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "TypeIndex": SimTypeInt(signed=False, label="UInt32"), "Reserved": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 2), "Index": SimTypeInt(signed=False, label="UInt32"), "Size": SimTypeInt(signed=False, label="UInt32"), "ModBase": SimTypeLongLong(signed=False, label="UInt64"), "Flags": SimTypeInt(signed=False, label="SYMBOL_INFO_FLAGS"), "Value": SimTypeLongLong(signed=False, label="UInt64"), "Address": SimTypeLongLong(signed=False, label="UInt64"), "Register": SimTypeInt(signed=False, label="UInt32"), "Scope": SimTypeInt(signed=False, label="UInt32"), "Tag": SimTypeInt(signed=False, label="UInt32"), "NameLen": SimTypeInt(signed=False, label="UInt32"), "MaxNameLen": SimTypeInt(signed=False, label="UInt32"), "Name": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="SYMBOL_INFOW", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pSymInfo", "SymbolSize", "UserContext"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "BaseOfDll", "Index", "SymTag", "Mask", "Address", "EnumSymbolsCallback", "UserContext", "Options"]),
        # 
        'SymGetScope': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "TypeIndex": SimTypeInt(signed=False, label="UInt32"), "Reserved": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 2), "Index": SimTypeInt(signed=False, label="UInt32"), "Size": SimTypeInt(signed=False, label="UInt32"), "ModBase": SimTypeLongLong(signed=False, label="UInt64"), "Flags": SimTypeInt(signed=False, label="SYMBOL_INFO_FLAGS"), "Value": SimTypeLongLong(signed=False, label="UInt64"), "Address": SimTypeLongLong(signed=False, label="UInt64"), "Register": SimTypeInt(signed=False, label="UInt32"), "Scope": SimTypeInt(signed=False, label="UInt32"), "Tag": SimTypeInt(signed=False, label="UInt32"), "NameLen": SimTypeInt(signed=False, label="UInt32"), "MaxNameLen": SimTypeInt(signed=False, label="UInt32"), "Name": SimTypePointer(SimTypeBottom(label="CHAR"), offset=0)}, name="SYMBOL_INFO", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "BaseOfDll", "Index", "Symbol"]),
        # 
        'SymGetScopeW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "TypeIndex": SimTypeInt(signed=False, label="UInt32"), "Reserved": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 2), "Index": SimTypeInt(signed=False, label="UInt32"), "Size": SimTypeInt(signed=False, label="UInt32"), "ModBase": SimTypeLongLong(signed=False, label="UInt64"), "Flags": SimTypeInt(signed=False, label="SYMBOL_INFO_FLAGS"), "Value": SimTypeLongLong(signed=False, label="UInt64"), "Address": SimTypeLongLong(signed=False, label="UInt64"), "Register": SimTypeInt(signed=False, label="UInt32"), "Scope": SimTypeInt(signed=False, label="UInt32"), "Tag": SimTypeInt(signed=False, label="UInt32"), "NameLen": SimTypeInt(signed=False, label="UInt32"), "MaxNameLen": SimTypeInt(signed=False, label="UInt32"), "Name": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="SYMBOL_INFOW", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "BaseOfDll", "Index", "Symbol"]),
        # 
        'SymFromIndex': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "TypeIndex": SimTypeInt(signed=False, label="UInt32"), "Reserved": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 2), "Index": SimTypeInt(signed=False, label="UInt32"), "Size": SimTypeInt(signed=False, label="UInt32"), "ModBase": SimTypeLongLong(signed=False, label="UInt64"), "Flags": SimTypeInt(signed=False, label="SYMBOL_INFO_FLAGS"), "Value": SimTypeLongLong(signed=False, label="UInt64"), "Address": SimTypeLongLong(signed=False, label="UInt64"), "Register": SimTypeInt(signed=False, label="UInt32"), "Scope": SimTypeInt(signed=False, label="UInt32"), "Tag": SimTypeInt(signed=False, label="UInt32"), "NameLen": SimTypeInt(signed=False, label="UInt32"), "MaxNameLen": SimTypeInt(signed=False, label="UInt32"), "Name": SimTypePointer(SimTypeBottom(label="CHAR"), offset=0)}, name="SYMBOL_INFO", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "BaseOfDll", "Index", "Symbol"]),
        # 
        'SymFromIndexW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "TypeIndex": SimTypeInt(signed=False, label="UInt32"), "Reserved": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 2), "Index": SimTypeInt(signed=False, label="UInt32"), "Size": SimTypeInt(signed=False, label="UInt32"), "ModBase": SimTypeLongLong(signed=False, label="UInt64"), "Flags": SimTypeInt(signed=False, label="SYMBOL_INFO_FLAGS"), "Value": SimTypeLongLong(signed=False, label="UInt64"), "Address": SimTypeLongLong(signed=False, label="UInt64"), "Register": SimTypeInt(signed=False, label="UInt32"), "Scope": SimTypeInt(signed=False, label="UInt32"), "Tag": SimTypeInt(signed=False, label="UInt32"), "NameLen": SimTypeInt(signed=False, label="UInt32"), "MaxNameLen": SimTypeInt(signed=False, label="UInt32"), "Name": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="SYMBOL_INFOW", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "BaseOfDll", "Index", "Symbol"]),
        # 
        'SymGetTypeInfo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="IMAGEHLP_SYMBOL_TYPE_INFO"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "ModBase", "TypeId", "GetType", "pInfo"]),
        # 
        'SymGetTypeInfoEx': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="IMAGEHLP_GET_TYPE_INFO_FLAGS"), "NumIds": SimTypeInt(signed=False, label="UInt32"), "TypeIds": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "TagFilter": SimTypeLongLong(signed=False, label="UInt64"), "NumReqs": SimTypeInt(signed=False, label="UInt32"), "ReqKinds": SimTypePointer(SimTypeInt(signed=False, label="IMAGEHLP_SYMBOL_TYPE_INFO"), offset=0), "ReqOffsets": SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0), "ReqSizes": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ReqStride": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "BufferSize": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "EntriesMatched": SimTypeInt(signed=False, label="UInt32"), "EntriesFilled": SimTypeInt(signed=False, label="UInt32"), "TagsFound": SimTypeLongLong(signed=False, label="UInt64"), "AllReqsValid": SimTypeLongLong(signed=False, label="UInt64"), "NumReqsValid": SimTypeInt(signed=False, label="UInt32"), "ReqsValid": SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0)}, name="IMAGEHLP_GET_TYPE_INFO_PARAMS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "ModBase", "Params"]),
        # 
        'SymEnumTypes': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "TypeIndex": SimTypeInt(signed=False, label="UInt32"), "Reserved": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 2), "Index": SimTypeInt(signed=False, label="UInt32"), "Size": SimTypeInt(signed=False, label="UInt32"), "ModBase": SimTypeLongLong(signed=False, label="UInt64"), "Flags": SimTypeInt(signed=False, label="SYMBOL_INFO_FLAGS"), "Value": SimTypeLongLong(signed=False, label="UInt64"), "Address": SimTypeLongLong(signed=False, label="UInt64"), "Register": SimTypeInt(signed=False, label="UInt32"), "Scope": SimTypeInt(signed=False, label="UInt32"), "Tag": SimTypeInt(signed=False, label="UInt32"), "NameLen": SimTypeInt(signed=False, label="UInt32"), "MaxNameLen": SimTypeInt(signed=False, label="UInt32"), "Name": SimTypePointer(SimTypeBottom(label="CHAR"), offset=0)}, name="SYMBOL_INFO", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pSymInfo", "SymbolSize", "UserContext"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "BaseOfDll", "EnumSymbolsCallback", "UserContext"]),
        # 
        'SymEnumTypesW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "TypeIndex": SimTypeInt(signed=False, label="UInt32"), "Reserved": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 2), "Index": SimTypeInt(signed=False, label="UInt32"), "Size": SimTypeInt(signed=False, label="UInt32"), "ModBase": SimTypeLongLong(signed=False, label="UInt64"), "Flags": SimTypeInt(signed=False, label="SYMBOL_INFO_FLAGS"), "Value": SimTypeLongLong(signed=False, label="UInt64"), "Address": SimTypeLongLong(signed=False, label="UInt64"), "Register": SimTypeInt(signed=False, label="UInt32"), "Scope": SimTypeInt(signed=False, label="UInt32"), "Tag": SimTypeInt(signed=False, label="UInt32"), "NameLen": SimTypeInt(signed=False, label="UInt32"), "MaxNameLen": SimTypeInt(signed=False, label="UInt32"), "Name": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="SYMBOL_INFOW", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pSymInfo", "SymbolSize", "UserContext"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "BaseOfDll", "EnumSymbolsCallback", "UserContext"]),
        # 
        'SymEnumTypesByName': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "TypeIndex": SimTypeInt(signed=False, label="UInt32"), "Reserved": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 2), "Index": SimTypeInt(signed=False, label="UInt32"), "Size": SimTypeInt(signed=False, label="UInt32"), "ModBase": SimTypeLongLong(signed=False, label="UInt64"), "Flags": SimTypeInt(signed=False, label="SYMBOL_INFO_FLAGS"), "Value": SimTypeLongLong(signed=False, label="UInt64"), "Address": SimTypeLongLong(signed=False, label="UInt64"), "Register": SimTypeInt(signed=False, label="UInt32"), "Scope": SimTypeInt(signed=False, label="UInt32"), "Tag": SimTypeInt(signed=False, label="UInt32"), "NameLen": SimTypeInt(signed=False, label="UInt32"), "MaxNameLen": SimTypeInt(signed=False, label="UInt32"), "Name": SimTypePointer(SimTypeBottom(label="CHAR"), offset=0)}, name="SYMBOL_INFO", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pSymInfo", "SymbolSize", "UserContext"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "BaseOfDll", "mask", "EnumSymbolsCallback", "UserContext"]),
        # 
        'SymEnumTypesByNameW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "TypeIndex": SimTypeInt(signed=False, label="UInt32"), "Reserved": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 2), "Index": SimTypeInt(signed=False, label="UInt32"), "Size": SimTypeInt(signed=False, label="UInt32"), "ModBase": SimTypeLongLong(signed=False, label="UInt64"), "Flags": SimTypeInt(signed=False, label="SYMBOL_INFO_FLAGS"), "Value": SimTypeLongLong(signed=False, label="UInt64"), "Address": SimTypeLongLong(signed=False, label="UInt64"), "Register": SimTypeInt(signed=False, label="UInt32"), "Scope": SimTypeInt(signed=False, label="UInt32"), "Tag": SimTypeInt(signed=False, label="UInt32"), "NameLen": SimTypeInt(signed=False, label="UInt32"), "MaxNameLen": SimTypeInt(signed=False, label="UInt32"), "Name": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="SYMBOL_INFOW", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pSymInfo", "SymbolSize", "UserContext"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "BaseOfDll", "mask", "EnumSymbolsCallback", "UserContext"]),
        # 
        'SymGetTypeFromName': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "TypeIndex": SimTypeInt(signed=False, label="UInt32"), "Reserved": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 2), "Index": SimTypeInt(signed=False, label="UInt32"), "Size": SimTypeInt(signed=False, label="UInt32"), "ModBase": SimTypeLongLong(signed=False, label="UInt64"), "Flags": SimTypeInt(signed=False, label="SYMBOL_INFO_FLAGS"), "Value": SimTypeLongLong(signed=False, label="UInt64"), "Address": SimTypeLongLong(signed=False, label="UInt64"), "Register": SimTypeInt(signed=False, label="UInt32"), "Scope": SimTypeInt(signed=False, label="UInt32"), "Tag": SimTypeInt(signed=False, label="UInt32"), "NameLen": SimTypeInt(signed=False, label="UInt32"), "MaxNameLen": SimTypeInt(signed=False, label="UInt32"), "Name": SimTypePointer(SimTypeBottom(label="CHAR"), offset=0)}, name="SYMBOL_INFO", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "BaseOfDll", "Name", "Symbol"]),
        # 
        'SymGetTypeFromNameW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "TypeIndex": SimTypeInt(signed=False, label="UInt32"), "Reserved": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 2), "Index": SimTypeInt(signed=False, label="UInt32"), "Size": SimTypeInt(signed=False, label="UInt32"), "ModBase": SimTypeLongLong(signed=False, label="UInt64"), "Flags": SimTypeInt(signed=False, label="SYMBOL_INFO_FLAGS"), "Value": SimTypeLongLong(signed=False, label="UInt64"), "Address": SimTypeLongLong(signed=False, label="UInt64"), "Register": SimTypeInt(signed=False, label="UInt32"), "Scope": SimTypeInt(signed=False, label="UInt32"), "Tag": SimTypeInt(signed=False, label="UInt32"), "NameLen": SimTypeInt(signed=False, label="UInt32"), "MaxNameLen": SimTypeInt(signed=False, label="UInt32"), "Name": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="SYMBOL_INFOW", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "BaseOfDll", "Name", "Symbol"]),
        # 
        'SymAddSymbol': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "BaseOfDll", "Name", "Address", "Size", "Flags"]),
        # 
        'SymAddSymbolW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "BaseOfDll", "Name", "Address", "Size", "Flags"]),
        # 
        'SymDeleteSymbol': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "BaseOfDll", "Name", "Address", "Flags"]),
        # 
        'SymDeleteSymbolW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "BaseOfDll", "Name", "Address", "Flags"]),
        # 
        'SymRefreshModuleList': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess"]),
        # 
        'SymAddSourceStream': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "Base", "StreamFile", "Buffer", "Size"]),
        # 
        'SymAddSourceStreamA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "Base", "StreamFile", "Buffer", "Size"]),
        # 
        'SymAddSourceStreamW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "Base", "FileSpec", "Buffer", "Size"]),
        # 
        'SymSrvIsStoreW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "path"]),
        # 
        'SymSrvIsStore': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "path"]),
        # 
        'SymSrvDeltaName': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypePointer(SimTypeChar(label="Byte"), offset=0), arg_names=["hProcess", "SymPath", "Type", "File1", "File2"]),
        # 
        'SymSrvDeltaNameW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypePointer(SimTypeChar(label="Char"), offset=0), arg_names=["hProcess", "SymPath", "Type", "File1", "File2"]),
        # 
        'SymSrvGetSupplement': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypePointer(SimTypeChar(label="Byte"), offset=0), arg_names=["hProcess", "SymPath", "Node", "File"]),
        # 
        'SymSrvGetSupplementW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypePointer(SimTypeChar(label="Char"), offset=0), arg_names=["hProcess", "SymPath", "Node", "File"]),
        # 
        'SymSrvGetFileIndexes': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["File", "Id", "Val1", "Val2", "Flags"]),
        # 
        'SymSrvGetFileIndexesW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["File", "Id", "Val1", "Val2", "Flags"]),
        # 
        'SymSrvGetFileIndexStringW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "SrvPath", "File", "Index", "Size", "Flags"]),
        # 
        'SymSrvGetFileIndexString': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "SrvPath", "File", "Index", "Size", "Flags"]),
        # 
        'SymSrvGetFileIndexInfo': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"sizeofstruct": SimTypeInt(signed=False, label="UInt32"), "file": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 261), "stripped": SimTypeInt(signed=True, label="Int32"), "timestamp": SimTypeInt(signed=False, label="UInt32"), "size": SimTypeInt(signed=False, label="UInt32"), "dbgfile": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 261), "pdbfile": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 261), "guid": SimTypeBottom(label="Guid"), "sig": SimTypeInt(signed=False, label="UInt32"), "age": SimTypeInt(signed=False, label="UInt32")}, name="SYMSRV_INDEX_INFO", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["File", "Info", "Flags"]),
        # 
        'SymSrvGetFileIndexInfoW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"sizeofstruct": SimTypeInt(signed=False, label="UInt32"), "file": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 261), "stripped": SimTypeInt(signed=True, label="Int32"), "timestamp": SimTypeInt(signed=False, label="UInt32"), "size": SimTypeInt(signed=False, label="UInt32"), "dbgfile": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 261), "pdbfile": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 261), "guid": SimTypeBottom(label="Guid"), "sig": SimTypeInt(signed=False, label="UInt32"), "age": SimTypeInt(signed=False, label="UInt32")}, name="SYMSRV_INDEX_INFOW", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["File", "Info", "Flags"]),
        # 
        'SymSrvStoreSupplement': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeChar(label="Byte"), offset=0), arg_names=["hProcess", "SrvPath", "Node", "File", "Flags"]),
        # 
        'SymSrvStoreSupplementW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeChar(label="Char"), offset=0), arg_names=["hProcess", "SymPath", "Node", "File", "Flags"]),
        # 
        'SymSrvStoreFile': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="SYM_SRV_STORE_FILE_FLAGS")], SimTypePointer(SimTypeChar(label="Byte"), offset=0), arg_names=["hProcess", "SrvPath", "File", "Flags"]),
        # 
        'SymSrvStoreFileW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="SYM_SRV_STORE_FILE_FLAGS")], SimTypePointer(SimTypeChar(label="Char"), offset=0), arg_names=["hProcess", "SrvPath", "File", "Flags"]),
        # 
        'SymGetSymbolFile': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="IMAGEHLP_SF_TYPE"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "SymPath", "ImageFile", "Type", "SymbolFile", "cSymbolFile", "DbgFile", "cDbgFile"]),
        # 
        'SymGetSymbolFileW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="IMAGEHLP_SF_TYPE"), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "SymPath", "ImageFile", "Type", "SymbolFile", "cSymbolFile", "DbgFile", "cDbgFile"]),
        # 
        'DbgHelpCreateUserDump': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["DataType", "Data", "DataLength", "UserData"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["FileName", "Callback", "UserData"]),
        # 
        'DbgHelpCreateUserDumpW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["DataType", "Data", "DataLength", "UserData"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["FileName", "Callback", "UserData"]),
        # 
        'SymGetSymFromAddr64': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0), SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "Address": SimTypeLongLong(signed=False, label="UInt64"), "Size": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="UInt32"), "MaxNameLength": SimTypeInt(signed=False, label="UInt32"), "Name": SimTypePointer(SimTypeBottom(label="CHAR"), offset=0)}, name="IMAGEHLP_SYMBOL64", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "qwAddr", "pdwDisplacement", "Symbol"]),
        # 
        'SymGetSymFromName64': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "Address": SimTypeLongLong(signed=False, label="UInt64"), "Size": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="UInt32"), "MaxNameLength": SimTypeInt(signed=False, label="UInt32"), "Name": SimTypePointer(SimTypeBottom(label="CHAR"), offset=0)}, name="IMAGEHLP_SYMBOL64", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "Name", "Symbol"]),
        # 
        'FindFileInPath': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hprocess", "SearchPathA", "FileName", "id", "two", "three", "flags", "FilePath"]),
        # 
        'FindFileInSearchPath': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hprocess", "SearchPathA", "FileName", "one", "two", "three", "FilePath"]),
        # 
        'SymEnumSym': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "TypeIndex": SimTypeInt(signed=False, label="UInt32"), "Reserved": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 2), "Index": SimTypeInt(signed=False, label="UInt32"), "Size": SimTypeInt(signed=False, label="UInt32"), "ModBase": SimTypeLongLong(signed=False, label="UInt64"), "Flags": SimTypeInt(signed=False, label="SYMBOL_INFO_FLAGS"), "Value": SimTypeLongLong(signed=False, label="UInt64"), "Address": SimTypeLongLong(signed=False, label="UInt64"), "Register": SimTypeInt(signed=False, label="UInt32"), "Scope": SimTypeInt(signed=False, label="UInt32"), "Tag": SimTypeInt(signed=False, label="UInt32"), "NameLen": SimTypeInt(signed=False, label="UInt32"), "MaxNameLen": SimTypeInt(signed=False, label="UInt32"), "Name": SimTypePointer(SimTypeBottom(label="CHAR"), offset=0)}, name="SYMBOL_INFO", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pSymInfo", "SymbolSize", "UserContext"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "BaseOfDll", "EnumSymbolsCallback", "UserContext"]),
        # 
        'SymEnumerateSymbols64': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["SymbolName", "SymbolAddress", "SymbolSize", "UserContext"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "BaseOfDll", "EnumSymbolsCallback", "UserContext"]),
        # 
        'SymEnumerateSymbolsW64': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["SymbolName", "SymbolAddress", "SymbolSize", "UserContext"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "BaseOfDll", "EnumSymbolsCallback", "UserContext"]),
        # 
        'SymLoadModule64': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypeInt(signed=False, label="UInt32")], SimTypeLongLong(signed=False, label="UInt64"), arg_names=["hProcess", "hFile", "ImageName", "ModuleName", "BaseOfDll", "SizeOfDll"]),
        # 
        'SymGetSymNext64': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "Address": SimTypeLongLong(signed=False, label="UInt64"), "Size": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="UInt32"), "MaxNameLength": SimTypeInt(signed=False, label="UInt32"), "Name": SimTypePointer(SimTypeBottom(label="CHAR"), offset=0)}, name="IMAGEHLP_SYMBOL64", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "Symbol"]),
        # 
        'SymGetSymPrev64': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "Address": SimTypeLongLong(signed=False, label="UInt64"), "Size": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="UInt32"), "MaxNameLength": SimTypeInt(signed=False, label="UInt32"), "Name": SimTypePointer(SimTypeBottom(label="CHAR"), offset=0)}, name="IMAGEHLP_SYMBOL64", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "Symbol"]),
        # 
        'SetCheckUserInterruptShared': SimTypeFunction([SimTypePointer(SimTypeFunction([], SimTypeInt(signed=False, label="UInt32")), offset=0)], SimTypeBottom(label="Void"), arg_names=["lpStartAddress"]),
        # 
        'GetSymLoadError': SimTypeFunction([], SimTypeInt(signed=False, label="UInt32")),
        # 
        'SetSymLoadError': SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypeBottom(label="Void"), arg_names=["error"]),
        # 
        'ReportSymbolLoadSummary': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"pBinPathNonExist": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pSymbolPathNonExist": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="DBGHELP_DATA_REPORT_STRUCT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "pLoadModule", "pSymbolData"]),
        # 
        'RemoveInvalidModuleList': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeBottom(label="Void"), arg_names=["hProcess"]),
        # 
        'RangeMapCreate': SimTypeFunction([], SimTypePointer(SimTypeBottom(label="Void"), offset=0)),
        # 
        'RangeMapFree': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["RmapHandle"]),
        # 
        'RangeMapAddPeImageSections': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeLongLong(signed=False, label="UInt64"), SimTypeLongLong(signed=False, label="UInt64"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["RmapHandle", "ImageName", "MappedImage", "MappingBytes", "ImageBase", "UserTag", "MappingFlags"]),
        # 
        'RangeMapRemove': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeLongLong(signed=False, label="UInt64")], SimTypeInt(signed=True, label="Int32"), arg_names=["RmapHandle", "UserTag"]),
        # 
        'RangeMapRead': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["RmapHandle", "Offset", "Buffer", "RequestBytes", "Flags", "DoneBytes"]),
        # 
        'RangeMapWrite': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["RmapHandle", "Offset", "Buffer", "RequestBytes", "Flags", "DoneBytes"]),
        # 
        'ImageNtHeader': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypePointer(SimStruct({"Signature": SimTypeInt(signed=False, label="UInt32"), "FileHeader": SimStruct({"Machine": SimTypeInt(signed=False, label="IMAGE_FILE_MACHINE"), "NumberOfSections": SimTypeShort(signed=False, label="UInt16"), "TimeDateStamp": SimTypeInt(signed=False, label="UInt32"), "PointerToSymbolTable": SimTypeInt(signed=False, label="UInt32"), "NumberOfSymbols": SimTypeInt(signed=False, label="UInt32"), "SizeOfOptionalHeader": SimTypeShort(signed=False, label="UInt16"), "Characteristics": SimTypeInt(signed=False, label="IMAGE_FILE_CHARACTERISTICS")}, name="IMAGE_FILE_HEADER", pack=False, align=None), "OptionalHeader": SimStruct({"Magic": SimTypeInt(signed=False, label="IMAGE_OPTIONAL_HEADER_MAGIC"), "MajorLinkerVersion": SimTypeChar(label="Byte"), "MinorLinkerVersion": SimTypeChar(label="Byte"), "SizeOfCode": SimTypeInt(signed=False, label="UInt32"), "SizeOfInitializedData": SimTypeInt(signed=False, label="UInt32"), "SizeOfUninitializedData": SimTypeInt(signed=False, label="UInt32"), "AddressOfEntryPoint": SimTypeInt(signed=False, label="UInt32"), "BaseOfCode": SimTypeInt(signed=False, label="UInt32"), "BaseOfData": SimTypeInt(signed=False, label="UInt32"), "ImageBase": SimTypeInt(signed=False, label="UInt32"), "SectionAlignment": SimTypeInt(signed=False, label="UInt32"), "FileAlignment": SimTypeInt(signed=False, label="UInt32"), "MajorOperatingSystemVersion": SimTypeShort(signed=False, label="UInt16"), "MinorOperatingSystemVersion": SimTypeShort(signed=False, label="UInt16"), "MajorImageVersion": SimTypeShort(signed=False, label="UInt16"), "MinorImageVersion": SimTypeShort(signed=False, label="UInt16"), "MajorSubsystemVersion": SimTypeShort(signed=False, label="UInt16"), "MinorSubsystemVersion": SimTypeShort(signed=False, label="UInt16"), "Win32VersionValue": SimTypeInt(signed=False, label="UInt32"), "SizeOfImage": SimTypeInt(signed=False, label="UInt32"), "SizeOfHeaders": SimTypeInt(signed=False, label="UInt32"), "CheckSum": SimTypeInt(signed=False, label="UInt32"), "Subsystem": SimTypeInt(signed=False, label="IMAGE_SUBSYSTEM"), "DllCharacteristics": SimTypeInt(signed=False, label="IMAGE_DLL_CHARACTERISTICS"), "SizeOfStackReserve": SimTypeInt(signed=False, label="UInt32"), "SizeOfStackCommit": SimTypeInt(signed=False, label="UInt32"), "SizeOfHeapReserve": SimTypeInt(signed=False, label="UInt32"), "SizeOfHeapCommit": SimTypeInt(signed=False, label="UInt32"), "LoaderFlags": SimTypeInt(signed=False, label="UInt32"), "NumberOfRvaAndSizes": SimTypeInt(signed=False, label="UInt32"), "DataDirectory": SimTypeFixedSizeArray(SimStruct({"VirtualAddress": SimTypeInt(signed=False, label="UInt32"), "Size": SimTypeInt(signed=False, label="UInt32")}, name="IMAGE_DATA_DIRECTORY", pack=False, align=None), 16)}, name="IMAGE_OPTIONAL_HEADER32", pack=False, align=None)}, name="IMAGE_NT_HEADERS32", pack=False, align=None), offset=0), arg_names=["Base"]),
        # 
        'ImageRvaToSection': SimTypeFunction([SimTypePointer(SimStruct({"Signature": SimTypeInt(signed=False, label="UInt32"), "FileHeader": SimStruct({"Machine": SimTypeInt(signed=False, label="IMAGE_FILE_MACHINE"), "NumberOfSections": SimTypeShort(signed=False, label="UInt16"), "TimeDateStamp": SimTypeInt(signed=False, label="UInt32"), "PointerToSymbolTable": SimTypeInt(signed=False, label="UInt32"), "NumberOfSymbols": SimTypeInt(signed=False, label="UInt32"), "SizeOfOptionalHeader": SimTypeShort(signed=False, label="UInt16"), "Characteristics": SimTypeInt(signed=False, label="IMAGE_FILE_CHARACTERISTICS")}, name="IMAGE_FILE_HEADER", pack=False, align=None), "OptionalHeader": SimStruct({"Magic": SimTypeInt(signed=False, label="IMAGE_OPTIONAL_HEADER_MAGIC"), "MajorLinkerVersion": SimTypeChar(label="Byte"), "MinorLinkerVersion": SimTypeChar(label="Byte"), "SizeOfCode": SimTypeInt(signed=False, label="UInt32"), "SizeOfInitializedData": SimTypeInt(signed=False, label="UInt32"), "SizeOfUninitializedData": SimTypeInt(signed=False, label="UInt32"), "AddressOfEntryPoint": SimTypeInt(signed=False, label="UInt32"), "BaseOfCode": SimTypeInt(signed=False, label="UInt32"), "BaseOfData": SimTypeInt(signed=False, label="UInt32"), "ImageBase": SimTypeInt(signed=False, label="UInt32"), "SectionAlignment": SimTypeInt(signed=False, label="UInt32"), "FileAlignment": SimTypeInt(signed=False, label="UInt32"), "MajorOperatingSystemVersion": SimTypeShort(signed=False, label="UInt16"), "MinorOperatingSystemVersion": SimTypeShort(signed=False, label="UInt16"), "MajorImageVersion": SimTypeShort(signed=False, label="UInt16"), "MinorImageVersion": SimTypeShort(signed=False, label="UInt16"), "MajorSubsystemVersion": SimTypeShort(signed=False, label="UInt16"), "MinorSubsystemVersion": SimTypeShort(signed=False, label="UInt16"), "Win32VersionValue": SimTypeInt(signed=False, label="UInt32"), "SizeOfImage": SimTypeInt(signed=False, label="UInt32"), "SizeOfHeaders": SimTypeInt(signed=False, label="UInt32"), "CheckSum": SimTypeInt(signed=False, label="UInt32"), "Subsystem": SimTypeInt(signed=False, label="IMAGE_SUBSYSTEM"), "DllCharacteristics": SimTypeInt(signed=False, label="IMAGE_DLL_CHARACTERISTICS"), "SizeOfStackReserve": SimTypeInt(signed=False, label="UInt32"), "SizeOfStackCommit": SimTypeInt(signed=False, label="UInt32"), "SizeOfHeapReserve": SimTypeInt(signed=False, label="UInt32"), "SizeOfHeapCommit": SimTypeInt(signed=False, label="UInt32"), "LoaderFlags": SimTypeInt(signed=False, label="UInt32"), "NumberOfRvaAndSizes": SimTypeInt(signed=False, label="UInt32"), "DataDirectory": SimTypeFixedSizeArray(SimStruct({"VirtualAddress": SimTypeInt(signed=False, label="UInt32"), "Size": SimTypeInt(signed=False, label="UInt32")}, name="IMAGE_DATA_DIRECTORY", pack=False, align=None), 16)}, name="IMAGE_OPTIONAL_HEADER32", pack=False, align=None)}, name="IMAGE_NT_HEADERS32", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimStruct({"Name": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 8), "Misc": SimUnion({"PhysicalAddress": SimTypeInt(signed=False, label="UInt32"), "VirtualSize": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None"), "VirtualAddress": SimTypeInt(signed=False, label="UInt32"), "SizeOfRawData": SimTypeInt(signed=False, label="UInt32"), "PointerToRawData": SimTypeInt(signed=False, label="UInt32"), "PointerToRelocations": SimTypeInt(signed=False, label="UInt32"), "PointerToLinenumbers": SimTypeInt(signed=False, label="UInt32"), "NumberOfRelocations": SimTypeShort(signed=False, label="UInt16"), "NumberOfLinenumbers": SimTypeShort(signed=False, label="UInt16"), "Characteristics": SimTypeInt(signed=False, label="IMAGE_SECTION_CHARACTERISTICS")}, name="IMAGE_SECTION_HEADER", pack=False, align=None), offset=0), arg_names=["NtHeaders", "Base", "Rva"]),
        # 
        'ImageRvaToVa': SimTypeFunction([SimTypePointer(SimStruct({"Signature": SimTypeInt(signed=False, label="UInt32"), "FileHeader": SimStruct({"Machine": SimTypeInt(signed=False, label="IMAGE_FILE_MACHINE"), "NumberOfSections": SimTypeShort(signed=False, label="UInt16"), "TimeDateStamp": SimTypeInt(signed=False, label="UInt32"), "PointerToSymbolTable": SimTypeInt(signed=False, label="UInt32"), "NumberOfSymbols": SimTypeInt(signed=False, label="UInt32"), "SizeOfOptionalHeader": SimTypeShort(signed=False, label="UInt16"), "Characteristics": SimTypeInt(signed=False, label="IMAGE_FILE_CHARACTERISTICS")}, name="IMAGE_FILE_HEADER", pack=False, align=None), "OptionalHeader": SimStruct({"Magic": SimTypeInt(signed=False, label="IMAGE_OPTIONAL_HEADER_MAGIC"), "MajorLinkerVersion": SimTypeChar(label="Byte"), "MinorLinkerVersion": SimTypeChar(label="Byte"), "SizeOfCode": SimTypeInt(signed=False, label="UInt32"), "SizeOfInitializedData": SimTypeInt(signed=False, label="UInt32"), "SizeOfUninitializedData": SimTypeInt(signed=False, label="UInt32"), "AddressOfEntryPoint": SimTypeInt(signed=False, label="UInt32"), "BaseOfCode": SimTypeInt(signed=False, label="UInt32"), "BaseOfData": SimTypeInt(signed=False, label="UInt32"), "ImageBase": SimTypeInt(signed=False, label="UInt32"), "SectionAlignment": SimTypeInt(signed=False, label="UInt32"), "FileAlignment": SimTypeInt(signed=False, label="UInt32"), "MajorOperatingSystemVersion": SimTypeShort(signed=False, label="UInt16"), "MinorOperatingSystemVersion": SimTypeShort(signed=False, label="UInt16"), "MajorImageVersion": SimTypeShort(signed=False, label="UInt16"), "MinorImageVersion": SimTypeShort(signed=False, label="UInt16"), "MajorSubsystemVersion": SimTypeShort(signed=False, label="UInt16"), "MinorSubsystemVersion": SimTypeShort(signed=False, label="UInt16"), "Win32VersionValue": SimTypeInt(signed=False, label="UInt32"), "SizeOfImage": SimTypeInt(signed=False, label="UInt32"), "SizeOfHeaders": SimTypeInt(signed=False, label="UInt32"), "CheckSum": SimTypeInt(signed=False, label="UInt32"), "Subsystem": SimTypeInt(signed=False, label="IMAGE_SUBSYSTEM"), "DllCharacteristics": SimTypeInt(signed=False, label="IMAGE_DLL_CHARACTERISTICS"), "SizeOfStackReserve": SimTypeInt(signed=False, label="UInt32"), "SizeOfStackCommit": SimTypeInt(signed=False, label="UInt32"), "SizeOfHeapReserve": SimTypeInt(signed=False, label="UInt32"), "SizeOfHeapCommit": SimTypeInt(signed=False, label="UInt32"), "LoaderFlags": SimTypeInt(signed=False, label="UInt32"), "NumberOfRvaAndSizes": SimTypeInt(signed=False, label="UInt32"), "DataDirectory": SimTypeFixedSizeArray(SimStruct({"VirtualAddress": SimTypeInt(signed=False, label="UInt32"), "Size": SimTypeInt(signed=False, label="UInt32")}, name="IMAGE_DATA_DIRECTORY", pack=False, align=None), 16)}, name="IMAGE_OPTIONAL_HEADER32", pack=False, align=None)}, name="IMAGE_NT_HEADERS32", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"Name": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 8), "Misc": SimUnion({"PhysicalAddress": SimTypeInt(signed=False, label="UInt32"), "VirtualSize": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None"), "VirtualAddress": SimTypeInt(signed=False, label="UInt32"), "SizeOfRawData": SimTypeInt(signed=False, label="UInt32"), "PointerToRawData": SimTypeInt(signed=False, label="UInt32"), "PointerToRelocations": SimTypeInt(signed=False, label="UInt32"), "PointerToLinenumbers": SimTypeInt(signed=False, label="UInt32"), "NumberOfRelocations": SimTypeShort(signed=False, label="UInt16"), "NumberOfLinenumbers": SimTypeShort(signed=False, label="UInt16"), "Characteristics": SimTypeInt(signed=False, label="IMAGE_SECTION_CHARACTERISTICS")}, name="IMAGE_SECTION_HEADER", pack=False, align=None), offset=0), offset=0)], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["NtHeaders", "Base", "Rva", "LastRvaSection"]),
        # 
        'StackWalk': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"AddrPC": SimStruct({"Offset": SimTypeInt(signed=False, label="UInt32"), "Segment": SimTypeShort(signed=False, label="UInt16"), "Mode": SimTypeInt(signed=False, label="ADDRESS_MODE")}, name="ADDRESS", pack=False, align=None), "AddrReturn": SimStruct({"Offset": SimTypeInt(signed=False, label="UInt32"), "Segment": SimTypeShort(signed=False, label="UInt16"), "Mode": SimTypeInt(signed=False, label="ADDRESS_MODE")}, name="ADDRESS", pack=False, align=None), "AddrFrame": SimStruct({"Offset": SimTypeInt(signed=False, label="UInt32"), "Segment": SimTypeShort(signed=False, label="UInt16"), "Mode": SimTypeInt(signed=False, label="ADDRESS_MODE")}, name="ADDRESS", pack=False, align=None), "AddrStack": SimStruct({"Offset": SimTypeInt(signed=False, label="UInt32"), "Segment": SimTypeShort(signed=False, label="UInt16"), "Mode": SimTypeInt(signed=False, label="ADDRESS_MODE")}, name="ADDRESS", pack=False, align=None), "FuncTableEntry": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Params": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 4), "Far": SimTypeInt(signed=True, label="Int32"), "Virtual": SimTypeInt(signed=True, label="Int32"), "Reserved": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 3), "KdHelp": SimStruct({"Thread": SimTypeInt(signed=False, label="UInt32"), "ThCallbackStack": SimTypeInt(signed=False, label="UInt32"), "NextCallback": SimTypeInt(signed=False, label="UInt32"), "FramePointer": SimTypeInt(signed=False, label="UInt32"), "KiCallUserMode": SimTypeInt(signed=False, label="UInt32"), "KeUserCallbackDispatcher": SimTypeInt(signed=False, label="UInt32"), "SystemRangeStart": SimTypeInt(signed=False, label="UInt32"), "ThCallbackBStore": SimTypeInt(signed=False, label="UInt32"), "KiUserExceptionDispatcher": SimTypeInt(signed=False, label="UInt32"), "StackBase": SimTypeInt(signed=False, label="UInt32"), "StackLimit": SimTypeInt(signed=False, label="UInt32"), "Reserved": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 5)}, name="KDHELP", pack=False, align=None), "AddrBStore": SimStruct({"Offset": SimTypeInt(signed=False, label="UInt32"), "Segment": SimTypeShort(signed=False, label="UInt16"), "Mode": SimTypeInt(signed=False, label="ADDRESS_MODE")}, name="ADDRESS", pack=False, align=None)}, name="STACKFRAME", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "lpBaseAddress", "lpBuffer", "nSize", "lpNumberOfBytesRead"]), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["hProcess", "AddrBase"]), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hProcess", "Address"]), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"Offset": SimTypeInt(signed=False, label="UInt32"), "Segment": SimTypeShort(signed=False, label="UInt16"), "Mode": SimTypeInt(signed=False, label="ADDRESS_MODE")}, name="ADDRESS", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hProcess", "hThread", "lpaddr"]), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["MachineType", "hProcess", "hThread", "StackFrame", "ContextRecord", "ReadMemoryRoutine", "FunctionTableAccessRoutine", "GetModuleBaseRoutine", "TranslateAddress"]),
        # 
        'SymEnumerateModules': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ModuleName", "BaseOfDll", "UserContext"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "EnumModulesCallback", "UserContext"]),
        # 
        'EnumerateLoadedModules': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ModuleName", "ModuleBase", "ModuleSize", "UserContext"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "EnumLoadedModulesCallback", "UserContext"]),
        # 
        'SymFunctionTableAccess': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["hProcess", "AddrBase"]),
        # 
        'SymGetModuleInfo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "BaseOfImage": SimTypeInt(signed=False, label="UInt32"), "ImageSize": SimTypeInt(signed=False, label="UInt32"), "TimeDateStamp": SimTypeInt(signed=False, label="UInt32"), "CheckSum": SimTypeInt(signed=False, label="UInt32"), "NumSyms": SimTypeInt(signed=False, label="UInt32"), "SymType": SimTypeInt(signed=False, label="SYM_TYPE"), "ModuleName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 32), "ImageName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 256), "LoadedImageName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 256)}, name="IMAGEHLP_MODULE", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "dwAddr", "ModuleInfo"]),
        # 
        'SymGetModuleInfoW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "BaseOfImage": SimTypeInt(signed=False, label="UInt32"), "ImageSize": SimTypeInt(signed=False, label="UInt32"), "TimeDateStamp": SimTypeInt(signed=False, label="UInt32"), "CheckSum": SimTypeInt(signed=False, label="UInt32"), "NumSyms": SimTypeInt(signed=False, label="UInt32"), "SymType": SimTypeInt(signed=False, label="SYM_TYPE"), "ModuleName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 32), "ImageName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 256), "LoadedImageName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 256)}, name="IMAGEHLP_MODULEW", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "dwAddr", "ModuleInfo"]),
        # 
        'SymGetModuleBase': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hProcess", "dwAddr"]),
        # 
        'SymGetLineFromAddr': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "Key": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "LineNumber": SimTypeInt(signed=False, label="UInt32"), "FileName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Address": SimTypeInt(signed=False, label="UInt32")}, name="IMAGEHLP_LINE", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "dwAddr", "pdwDisplacement", "Line"]),
        # 
        'SymGetLineFromName': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "Key": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "LineNumber": SimTypeInt(signed=False, label="UInt32"), "FileName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Address": SimTypeInt(signed=False, label="UInt32")}, name="IMAGEHLP_LINE", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "ModuleName", "FileName", "dwLineNumber", "plDisplacement", "Line"]),
        # 
        'SymGetLineNext': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "Key": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "LineNumber": SimTypeInt(signed=False, label="UInt32"), "FileName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Address": SimTypeInt(signed=False, label="UInt32")}, name="IMAGEHLP_LINE", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "Line"]),
        # 
        'SymGetLinePrev': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "Key": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "LineNumber": SimTypeInt(signed=False, label="UInt32"), "FileName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Address": SimTypeInt(signed=False, label="UInt32")}, name="IMAGEHLP_LINE", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "Line"]),
        # 
        'SymUnloadModule': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "BaseOfDll"]),
        # 
        'SymUnDName': SimTypeFunction([SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "Address": SimTypeInt(signed=False, label="UInt32"), "Size": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="UInt32"), "MaxNameLength": SimTypeInt(signed=False, label="UInt32"), "Name": SimTypePointer(SimTypeBottom(label="CHAR"), offset=0)}, name="IMAGEHLP_SYMBOL", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["sym", "UnDecName", "UnDecNameLength"]),
        # 
        'SymRegisterCallback': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "ActionCode", "CallbackData", "UserContext"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "CallbackFunction", "UserContext"]),
        # 
        'SymRegisterFunctionEntryCallback': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["hProcess", "AddrBase", "UserContext"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "CallbackFunction", "UserContext"]),
        # 
        'SymGetSymFromAddr': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "Address": SimTypeInt(signed=False, label="UInt32"), "Size": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="UInt32"), "MaxNameLength": SimTypeInt(signed=False, label="UInt32"), "Name": SimTypePointer(SimTypeBottom(label="CHAR"), offset=0)}, name="IMAGEHLP_SYMBOL", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "dwAddr", "pdwDisplacement", "Symbol"]),
        # 
        'SymGetSymFromName': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "Address": SimTypeInt(signed=False, label="UInt32"), "Size": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="UInt32"), "MaxNameLength": SimTypeInt(signed=False, label="UInt32"), "Name": SimTypePointer(SimTypeBottom(label="CHAR"), offset=0)}, name="IMAGEHLP_SYMBOL", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "Name", "Symbol"]),
        # 
        'SymEnumerateSymbols': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["SymbolName", "SymbolAddress", "SymbolSize", "UserContext"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "BaseOfDll", "EnumSymbolsCallback", "UserContext"]),
        # 
        'SymEnumerateSymbolsW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["SymbolName", "SymbolAddress", "SymbolSize", "UserContext"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "BaseOfDll", "EnumSymbolsCallback", "UserContext"]),
        # 
        'SymLoadModule': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hProcess", "hFile", "ImageName", "ModuleName", "BaseOfDll", "SizeOfDll"]),
        # 
        'SymGetSymNext': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "Address": SimTypeInt(signed=False, label="UInt32"), "Size": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="UInt32"), "MaxNameLength": SimTypeInt(signed=False, label="UInt32"), "Name": SimTypePointer(SimTypeBottom(label="CHAR"), offset=0)}, name="IMAGEHLP_SYMBOL", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "Symbol"]),
        # 
        'SymGetSymPrev': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "Address": SimTypeInt(signed=False, label="UInt32"), "Size": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="UInt32"), "MaxNameLength": SimTypeInt(signed=False, label="UInt32"), "Name": SimTypePointer(SimTypeBottom(label="CHAR"), offset=0)}, name="IMAGEHLP_SYMBOL", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProcess", "Symbol"]),
    }

lib.set_prototypes(prototypes)
