# pylint:disable=line-too-long
import logging

from ...sim_type import SimTypeFunction,     SimTypeShort, SimTypeInt, SimTypeLong, SimTypeLongLong, SimTypeDouble, SimTypeFloat,     SimTypePointer,     SimTypeChar,     SimStruct,     SimTypeFixedSizeArray,     SimTypeBottom,     SimUnion,     SimTypeBool
from ...calling_conventions import SimCCStdcall, SimCCMicrosoftAMD64
from .. import SIM_PROCEDURES as P
from . import SimLibrary


_l = logging.getLogger(name=__name__)


lib = SimLibrary()
lib.set_default_cc('X86', SimCCStdcall)
lib.set_default_cc('AMD64', SimCCMicrosoftAMD64)
lib.set_library_names("iphlpapi.dll")
prototypes = \
    {
        # 
        'GetIfEntry2': SimTypeFunction([SimTypePointer(SimStruct({"InterfaceLuid": SimUnion({"Value": SimTypeLongLong(signed=False, label="UInt64"), "Info": SimStruct({"_bitfield": SimTypeLongLong(signed=False, label="UInt64")}, name="_Info_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "InterfaceIndex": SimTypeInt(signed=False, label="UInt32"), "InterfaceGuid": SimTypeBottom(label="Guid"), "Alias": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 257), "Description": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 257), "PhysicalAddressLength": SimTypeInt(signed=False, label="UInt32"), "PhysicalAddress": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32), "PermanentPhysicalAddress": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32), "Mtu": SimTypeInt(signed=False, label="UInt32"), "Type": SimTypeInt(signed=False, label="UInt32"), "TunnelType": SimTypeInt(signed=False, label="TUNNEL_TYPE"), "MediaType": SimTypeBottom(label="NDIS_MEDIUM"), "PhysicalMediumType": SimTypeBottom(label="NDIS_PHYSICAL_MEDIUM"), "AccessType": SimTypeInt(signed=False, label="NET_IF_ACCESS_TYPE"), "DirectionType": SimTypeInt(signed=False, label="NET_IF_DIRECTION_TYPE"), "InterfaceAndOperStatusFlags": SimStruct({"_bitfield": SimTypeChar(label="Byte")}, name="_InterfaceAndOperStatusFlags_e__Struct", pack=False, align=None), "OperStatus": SimTypeInt(signed=False, label="IF_OPER_STATUS"), "AdminStatus": SimTypeInt(signed=False, label="NET_IF_ADMIN_STATUS"), "MediaConnectState": SimTypeInt(signed=False, label="NET_IF_MEDIA_CONNECT_STATE"), "NetworkGuid": SimTypeBottom(label="Guid"), "ConnectionType": SimTypeInt(signed=False, label="NET_IF_CONNECTION_TYPE"), "TransmitLinkSpeed": SimTypeLongLong(signed=False, label="UInt64"), "ReceiveLinkSpeed": SimTypeLongLong(signed=False, label="UInt64"), "InOctets": SimTypeLongLong(signed=False, label="UInt64"), "InUcastPkts": SimTypeLongLong(signed=False, label="UInt64"), "InNUcastPkts": SimTypeLongLong(signed=False, label="UInt64"), "InDiscards": SimTypeLongLong(signed=False, label="UInt64"), "InErrors": SimTypeLongLong(signed=False, label="UInt64"), "InUnknownProtos": SimTypeLongLong(signed=False, label="UInt64"), "InUcastOctets": SimTypeLongLong(signed=False, label="UInt64"), "InMulticastOctets": SimTypeLongLong(signed=False, label="UInt64"), "InBroadcastOctets": SimTypeLongLong(signed=False, label="UInt64"), "OutOctets": SimTypeLongLong(signed=False, label="UInt64"), "OutUcastPkts": SimTypeLongLong(signed=False, label="UInt64"), "OutNUcastPkts": SimTypeLongLong(signed=False, label="UInt64"), "OutDiscards": SimTypeLongLong(signed=False, label="UInt64"), "OutErrors": SimTypeLongLong(signed=False, label="UInt64"), "OutUcastOctets": SimTypeLongLong(signed=False, label="UInt64"), "OutMulticastOctets": SimTypeLongLong(signed=False, label="UInt64"), "OutBroadcastOctets": SimTypeLongLong(signed=False, label="UInt64"), "OutQLen": SimTypeLongLong(signed=False, label="UInt64")}, name="MIB_IF_ROW2", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Row"]),
        # 
        'GetIfEntry2Ex': SimTypeFunction([SimTypeInt(signed=False, label="MIB_IF_ENTRY_LEVEL"), SimTypePointer(SimStruct({"InterfaceLuid": SimUnion({"Value": SimTypeLongLong(signed=False, label="UInt64"), "Info": SimStruct({"_bitfield": SimTypeLongLong(signed=False, label="UInt64")}, name="_Info_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "InterfaceIndex": SimTypeInt(signed=False, label="UInt32"), "InterfaceGuid": SimTypeBottom(label="Guid"), "Alias": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 257), "Description": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 257), "PhysicalAddressLength": SimTypeInt(signed=False, label="UInt32"), "PhysicalAddress": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32), "PermanentPhysicalAddress": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32), "Mtu": SimTypeInt(signed=False, label="UInt32"), "Type": SimTypeInt(signed=False, label="UInt32"), "TunnelType": SimTypeInt(signed=False, label="TUNNEL_TYPE"), "MediaType": SimTypeBottom(label="NDIS_MEDIUM"), "PhysicalMediumType": SimTypeBottom(label="NDIS_PHYSICAL_MEDIUM"), "AccessType": SimTypeInt(signed=False, label="NET_IF_ACCESS_TYPE"), "DirectionType": SimTypeInt(signed=False, label="NET_IF_DIRECTION_TYPE"), "InterfaceAndOperStatusFlags": SimStruct({"_bitfield": SimTypeChar(label="Byte")}, name="_InterfaceAndOperStatusFlags_e__Struct", pack=False, align=None), "OperStatus": SimTypeInt(signed=False, label="IF_OPER_STATUS"), "AdminStatus": SimTypeInt(signed=False, label="NET_IF_ADMIN_STATUS"), "MediaConnectState": SimTypeInt(signed=False, label="NET_IF_MEDIA_CONNECT_STATE"), "NetworkGuid": SimTypeBottom(label="Guid"), "ConnectionType": SimTypeInt(signed=False, label="NET_IF_CONNECTION_TYPE"), "TransmitLinkSpeed": SimTypeLongLong(signed=False, label="UInt64"), "ReceiveLinkSpeed": SimTypeLongLong(signed=False, label="UInt64"), "InOctets": SimTypeLongLong(signed=False, label="UInt64"), "InUcastPkts": SimTypeLongLong(signed=False, label="UInt64"), "InNUcastPkts": SimTypeLongLong(signed=False, label="UInt64"), "InDiscards": SimTypeLongLong(signed=False, label="UInt64"), "InErrors": SimTypeLongLong(signed=False, label="UInt64"), "InUnknownProtos": SimTypeLongLong(signed=False, label="UInt64"), "InUcastOctets": SimTypeLongLong(signed=False, label="UInt64"), "InMulticastOctets": SimTypeLongLong(signed=False, label="UInt64"), "InBroadcastOctets": SimTypeLongLong(signed=False, label="UInt64"), "OutOctets": SimTypeLongLong(signed=False, label="UInt64"), "OutUcastPkts": SimTypeLongLong(signed=False, label="UInt64"), "OutNUcastPkts": SimTypeLongLong(signed=False, label="UInt64"), "OutDiscards": SimTypeLongLong(signed=False, label="UInt64"), "OutErrors": SimTypeLongLong(signed=False, label="UInt64"), "OutUcastOctets": SimTypeLongLong(signed=False, label="UInt64"), "OutMulticastOctets": SimTypeLongLong(signed=False, label="UInt64"), "OutBroadcastOctets": SimTypeLongLong(signed=False, label="UInt64"), "OutQLen": SimTypeLongLong(signed=False, label="UInt64")}, name="MIB_IF_ROW2", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Level", "Row"]),
        # 
        'GetIfTable2': SimTypeFunction([SimTypePointer(SimTypePointer(SimStruct({"NumEntries": SimTypeInt(signed=False, label="UInt32"), "Table": SimTypePointer(SimStruct({"InterfaceLuid": SimUnion({"Value": SimTypeLongLong(signed=False, label="UInt64"), "Info": SimStruct({"_bitfield": SimTypeLongLong(signed=False, label="UInt64")}, name="_Info_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "InterfaceIndex": SimTypeInt(signed=False, label="UInt32"), "InterfaceGuid": SimTypeBottom(label="Guid"), "Alias": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 257), "Description": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 257), "PhysicalAddressLength": SimTypeInt(signed=False, label="UInt32"), "PhysicalAddress": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32), "PermanentPhysicalAddress": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32), "Mtu": SimTypeInt(signed=False, label="UInt32"), "Type": SimTypeInt(signed=False, label="UInt32"), "TunnelType": SimTypeInt(signed=False, label="TUNNEL_TYPE"), "MediaType": SimTypeBottom(label="NDIS_MEDIUM"), "PhysicalMediumType": SimTypeBottom(label="NDIS_PHYSICAL_MEDIUM"), "AccessType": SimTypeInt(signed=False, label="NET_IF_ACCESS_TYPE"), "DirectionType": SimTypeInt(signed=False, label="NET_IF_DIRECTION_TYPE"), "InterfaceAndOperStatusFlags": SimStruct({"_bitfield": SimTypeChar(label="Byte")}, name="_InterfaceAndOperStatusFlags_e__Struct", pack=False, align=None), "OperStatus": SimTypeInt(signed=False, label="IF_OPER_STATUS"), "AdminStatus": SimTypeInt(signed=False, label="NET_IF_ADMIN_STATUS"), "MediaConnectState": SimTypeInt(signed=False, label="NET_IF_MEDIA_CONNECT_STATE"), "NetworkGuid": SimTypeBottom(label="Guid"), "ConnectionType": SimTypeInt(signed=False, label="NET_IF_CONNECTION_TYPE"), "TransmitLinkSpeed": SimTypeLongLong(signed=False, label="UInt64"), "ReceiveLinkSpeed": SimTypeLongLong(signed=False, label="UInt64"), "InOctets": SimTypeLongLong(signed=False, label="UInt64"), "InUcastPkts": SimTypeLongLong(signed=False, label="UInt64"), "InNUcastPkts": SimTypeLongLong(signed=False, label="UInt64"), "InDiscards": SimTypeLongLong(signed=False, label="UInt64"), "InErrors": SimTypeLongLong(signed=False, label="UInt64"), "InUnknownProtos": SimTypeLongLong(signed=False, label="UInt64"), "InUcastOctets": SimTypeLongLong(signed=False, label="UInt64"), "InMulticastOctets": SimTypeLongLong(signed=False, label="UInt64"), "InBroadcastOctets": SimTypeLongLong(signed=False, label="UInt64"), "OutOctets": SimTypeLongLong(signed=False, label="UInt64"), "OutUcastPkts": SimTypeLongLong(signed=False, label="UInt64"), "OutNUcastPkts": SimTypeLongLong(signed=False, label="UInt64"), "OutDiscards": SimTypeLongLong(signed=False, label="UInt64"), "OutErrors": SimTypeLongLong(signed=False, label="UInt64"), "OutUcastOctets": SimTypeLongLong(signed=False, label="UInt64"), "OutMulticastOctets": SimTypeLongLong(signed=False, label="UInt64"), "OutBroadcastOctets": SimTypeLongLong(signed=False, label="UInt64"), "OutQLen": SimTypeLongLong(signed=False, label="UInt64")}, name="MIB_IF_ROW2", pack=False, align=None), offset=0)}, name="MIB_IF_TABLE2", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Table"]),
        # 
        'GetIfTable2Ex': SimTypeFunction([SimTypeInt(signed=False, label="MIB_IF_TABLE_LEVEL"), SimTypePointer(SimTypePointer(SimStruct({"NumEntries": SimTypeInt(signed=False, label="UInt32"), "Table": SimTypePointer(SimStruct({"InterfaceLuid": SimUnion({"Value": SimTypeLongLong(signed=False, label="UInt64"), "Info": SimStruct({"_bitfield": SimTypeLongLong(signed=False, label="UInt64")}, name="_Info_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "InterfaceIndex": SimTypeInt(signed=False, label="UInt32"), "InterfaceGuid": SimTypeBottom(label="Guid"), "Alias": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 257), "Description": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 257), "PhysicalAddressLength": SimTypeInt(signed=False, label="UInt32"), "PhysicalAddress": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32), "PermanentPhysicalAddress": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32), "Mtu": SimTypeInt(signed=False, label="UInt32"), "Type": SimTypeInt(signed=False, label="UInt32"), "TunnelType": SimTypeInt(signed=False, label="TUNNEL_TYPE"), "MediaType": SimTypeBottom(label="NDIS_MEDIUM"), "PhysicalMediumType": SimTypeBottom(label="NDIS_PHYSICAL_MEDIUM"), "AccessType": SimTypeInt(signed=False, label="NET_IF_ACCESS_TYPE"), "DirectionType": SimTypeInt(signed=False, label="NET_IF_DIRECTION_TYPE"), "InterfaceAndOperStatusFlags": SimStruct({"_bitfield": SimTypeChar(label="Byte")}, name="_InterfaceAndOperStatusFlags_e__Struct", pack=False, align=None), "OperStatus": SimTypeInt(signed=False, label="IF_OPER_STATUS"), "AdminStatus": SimTypeInt(signed=False, label="NET_IF_ADMIN_STATUS"), "MediaConnectState": SimTypeInt(signed=False, label="NET_IF_MEDIA_CONNECT_STATE"), "NetworkGuid": SimTypeBottom(label="Guid"), "ConnectionType": SimTypeInt(signed=False, label="NET_IF_CONNECTION_TYPE"), "TransmitLinkSpeed": SimTypeLongLong(signed=False, label="UInt64"), "ReceiveLinkSpeed": SimTypeLongLong(signed=False, label="UInt64"), "InOctets": SimTypeLongLong(signed=False, label="UInt64"), "InUcastPkts": SimTypeLongLong(signed=False, label="UInt64"), "InNUcastPkts": SimTypeLongLong(signed=False, label="UInt64"), "InDiscards": SimTypeLongLong(signed=False, label="UInt64"), "InErrors": SimTypeLongLong(signed=False, label="UInt64"), "InUnknownProtos": SimTypeLongLong(signed=False, label="UInt64"), "InUcastOctets": SimTypeLongLong(signed=False, label="UInt64"), "InMulticastOctets": SimTypeLongLong(signed=False, label="UInt64"), "InBroadcastOctets": SimTypeLongLong(signed=False, label="UInt64"), "OutOctets": SimTypeLongLong(signed=False, label="UInt64"), "OutUcastPkts": SimTypeLongLong(signed=False, label="UInt64"), "OutNUcastPkts": SimTypeLongLong(signed=False, label="UInt64"), "OutDiscards": SimTypeLongLong(signed=False, label="UInt64"), "OutErrors": SimTypeLongLong(signed=False, label="UInt64"), "OutUcastOctets": SimTypeLongLong(signed=False, label="UInt64"), "OutMulticastOctets": SimTypeLongLong(signed=False, label="UInt64"), "OutBroadcastOctets": SimTypeLongLong(signed=False, label="UInt64"), "OutQLen": SimTypeLongLong(signed=False, label="UInt64")}, name="MIB_IF_ROW2", pack=False, align=None), offset=0)}, name="MIB_IF_TABLE2", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Level", "Table"]),
        # 
        'GetIfStackTable': SimTypeFunction([SimTypePointer(SimTypePointer(SimStruct({"NumEntries": SimTypeInt(signed=False, label="UInt32"), "Table": SimTypePointer(SimStruct({"HigherLayerInterfaceIndex": SimTypeInt(signed=False, label="UInt32"), "LowerLayerInterfaceIndex": SimTypeInt(signed=False, label="UInt32")}, name="MIB_IFSTACK_ROW", pack=False, align=None), offset=0)}, name="MIB_IFSTACK_TABLE", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Table"]),
        # 
        'GetInvertedIfStackTable': SimTypeFunction([SimTypePointer(SimTypePointer(SimStruct({"NumEntries": SimTypeInt(signed=False, label="UInt32"), "Table": SimTypePointer(SimStruct({"LowerLayerInterfaceIndex": SimTypeInt(signed=False, label="UInt32"), "HigherLayerInterfaceIndex": SimTypeInt(signed=False, label="UInt32")}, name="MIB_INVERTEDIFSTACK_ROW", pack=False, align=None), offset=0)}, name="MIB_INVERTEDIFSTACK_TABLE", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Table"]),
        # 
        'GetIpInterfaceEntry': SimTypeFunction([SimTypePointer(SimStruct({"Family": SimTypeShort(signed=False, label="UInt16"), "InterfaceLuid": SimUnion({"Value": SimTypeLongLong(signed=False, label="UInt64"), "Info": SimStruct({"_bitfield": SimTypeLongLong(signed=False, label="UInt64")}, name="_Info_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "InterfaceIndex": SimTypeInt(signed=False, label="UInt32"), "MaxReassemblySize": SimTypeInt(signed=False, label="UInt32"), "InterfaceIdentifier": SimTypeLongLong(signed=False, label="UInt64"), "MinRouterAdvertisementInterval": SimTypeInt(signed=False, label="UInt32"), "MaxRouterAdvertisementInterval": SimTypeInt(signed=False, label="UInt32"), "AdvertisingEnabled": SimTypeChar(label="Byte"), "ForwardingEnabled": SimTypeChar(label="Byte"), "WeakHostSend": SimTypeChar(label="Byte"), "WeakHostReceive": SimTypeChar(label="Byte"), "UseAutomaticMetric": SimTypeChar(label="Byte"), "UseNeighborUnreachabilityDetection": SimTypeChar(label="Byte"), "ManagedAddressConfigurationSupported": SimTypeChar(label="Byte"), "OtherStatefulConfigurationSupported": SimTypeChar(label="Byte"), "AdvertiseDefaultRoute": SimTypeChar(label="Byte"), "RouterDiscoveryBehavior": SimTypeInt(signed=False, label="NL_ROUTER_DISCOVERY_BEHAVIOR"), "DadTransmits": SimTypeInt(signed=False, label="UInt32"), "BaseReachableTime": SimTypeInt(signed=False, label="UInt32"), "RetransmitTime": SimTypeInt(signed=False, label="UInt32"), "PathMtuDiscoveryTimeout": SimTypeInt(signed=False, label="UInt32"), "LinkLocalAddressBehavior": SimTypeInt(signed=False, label="NL_LINK_LOCAL_ADDRESS_BEHAVIOR"), "LinkLocalAddressTimeout": SimTypeInt(signed=False, label="UInt32"), "ZoneIndices": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 16), "SitePrefixLength": SimTypeInt(signed=False, label="UInt32"), "Metric": SimTypeInt(signed=False, label="UInt32"), "NlMtu": SimTypeInt(signed=False, label="UInt32"), "Connected": SimTypeChar(label="Byte"), "SupportsWakeUpPatterns": SimTypeChar(label="Byte"), "SupportsNeighborDiscovery": SimTypeChar(label="Byte"), "SupportsRouterDiscovery": SimTypeChar(label="Byte"), "ReachableTime": SimTypeInt(signed=False, label="UInt32"), "TransmitOffload": SimStruct({"_bitfield": SimTypeChar(label="Byte")}, name="NL_INTERFACE_OFFLOAD_ROD", pack=False, align=None), "ReceiveOffload": SimStruct({"_bitfield": SimTypeChar(label="Byte")}, name="NL_INTERFACE_OFFLOAD_ROD", pack=False, align=None), "DisableDefaultRoutes": SimTypeChar(label="Byte")}, name="MIB_IPINTERFACE_ROW", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Row"]),
        # 
        'GetIpInterfaceTable': SimTypeFunction([SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypePointer(SimStruct({"NumEntries": SimTypeInt(signed=False, label="UInt32"), "Table": SimTypePointer(SimStruct({"Family": SimTypeShort(signed=False, label="UInt16"), "InterfaceLuid": SimUnion({"Value": SimTypeLongLong(signed=False, label="UInt64"), "Info": SimStruct({"_bitfield": SimTypeLongLong(signed=False, label="UInt64")}, name="_Info_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "InterfaceIndex": SimTypeInt(signed=False, label="UInt32"), "MaxReassemblySize": SimTypeInt(signed=False, label="UInt32"), "InterfaceIdentifier": SimTypeLongLong(signed=False, label="UInt64"), "MinRouterAdvertisementInterval": SimTypeInt(signed=False, label="UInt32"), "MaxRouterAdvertisementInterval": SimTypeInt(signed=False, label="UInt32"), "AdvertisingEnabled": SimTypeChar(label="Byte"), "ForwardingEnabled": SimTypeChar(label="Byte"), "WeakHostSend": SimTypeChar(label="Byte"), "WeakHostReceive": SimTypeChar(label="Byte"), "UseAutomaticMetric": SimTypeChar(label="Byte"), "UseNeighborUnreachabilityDetection": SimTypeChar(label="Byte"), "ManagedAddressConfigurationSupported": SimTypeChar(label="Byte"), "OtherStatefulConfigurationSupported": SimTypeChar(label="Byte"), "AdvertiseDefaultRoute": SimTypeChar(label="Byte"), "RouterDiscoveryBehavior": SimTypeInt(signed=False, label="NL_ROUTER_DISCOVERY_BEHAVIOR"), "DadTransmits": SimTypeInt(signed=False, label="UInt32"), "BaseReachableTime": SimTypeInt(signed=False, label="UInt32"), "RetransmitTime": SimTypeInt(signed=False, label="UInt32"), "PathMtuDiscoveryTimeout": SimTypeInt(signed=False, label="UInt32"), "LinkLocalAddressBehavior": SimTypeInt(signed=False, label="NL_LINK_LOCAL_ADDRESS_BEHAVIOR"), "LinkLocalAddressTimeout": SimTypeInt(signed=False, label="UInt32"), "ZoneIndices": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 16), "SitePrefixLength": SimTypeInt(signed=False, label="UInt32"), "Metric": SimTypeInt(signed=False, label="UInt32"), "NlMtu": SimTypeInt(signed=False, label="UInt32"), "Connected": SimTypeChar(label="Byte"), "SupportsWakeUpPatterns": SimTypeChar(label="Byte"), "SupportsNeighborDiscovery": SimTypeChar(label="Byte"), "SupportsRouterDiscovery": SimTypeChar(label="Byte"), "ReachableTime": SimTypeInt(signed=False, label="UInt32"), "TransmitOffload": SimStruct({"_bitfield": SimTypeChar(label="Byte")}, name="NL_INTERFACE_OFFLOAD_ROD", pack=False, align=None), "ReceiveOffload": SimStruct({"_bitfield": SimTypeChar(label="Byte")}, name="NL_INTERFACE_OFFLOAD_ROD", pack=False, align=None), "DisableDefaultRoutes": SimTypeChar(label="Byte")}, name="MIB_IPINTERFACE_ROW", pack=False, align=None), offset=0)}, name="MIB_IPINTERFACE_TABLE", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Family", "Table"]),
        # 
        'InitializeIpInterfaceEntry': SimTypeFunction([SimTypePointer(SimStruct({"Family": SimTypeShort(signed=False, label="UInt16"), "InterfaceLuid": SimUnion({"Value": SimTypeLongLong(signed=False, label="UInt64"), "Info": SimStruct({"_bitfield": SimTypeLongLong(signed=False, label="UInt64")}, name="_Info_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "InterfaceIndex": SimTypeInt(signed=False, label="UInt32"), "MaxReassemblySize": SimTypeInt(signed=False, label="UInt32"), "InterfaceIdentifier": SimTypeLongLong(signed=False, label="UInt64"), "MinRouterAdvertisementInterval": SimTypeInt(signed=False, label="UInt32"), "MaxRouterAdvertisementInterval": SimTypeInt(signed=False, label="UInt32"), "AdvertisingEnabled": SimTypeChar(label="Byte"), "ForwardingEnabled": SimTypeChar(label="Byte"), "WeakHostSend": SimTypeChar(label="Byte"), "WeakHostReceive": SimTypeChar(label="Byte"), "UseAutomaticMetric": SimTypeChar(label="Byte"), "UseNeighborUnreachabilityDetection": SimTypeChar(label="Byte"), "ManagedAddressConfigurationSupported": SimTypeChar(label="Byte"), "OtherStatefulConfigurationSupported": SimTypeChar(label="Byte"), "AdvertiseDefaultRoute": SimTypeChar(label="Byte"), "RouterDiscoveryBehavior": SimTypeInt(signed=False, label="NL_ROUTER_DISCOVERY_BEHAVIOR"), "DadTransmits": SimTypeInt(signed=False, label="UInt32"), "BaseReachableTime": SimTypeInt(signed=False, label="UInt32"), "RetransmitTime": SimTypeInt(signed=False, label="UInt32"), "PathMtuDiscoveryTimeout": SimTypeInt(signed=False, label="UInt32"), "LinkLocalAddressBehavior": SimTypeInt(signed=False, label="NL_LINK_LOCAL_ADDRESS_BEHAVIOR"), "LinkLocalAddressTimeout": SimTypeInt(signed=False, label="UInt32"), "ZoneIndices": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 16), "SitePrefixLength": SimTypeInt(signed=False, label="UInt32"), "Metric": SimTypeInt(signed=False, label="UInt32"), "NlMtu": SimTypeInt(signed=False, label="UInt32"), "Connected": SimTypeChar(label="Byte"), "SupportsWakeUpPatterns": SimTypeChar(label="Byte"), "SupportsNeighborDiscovery": SimTypeChar(label="Byte"), "SupportsRouterDiscovery": SimTypeChar(label="Byte"), "ReachableTime": SimTypeInt(signed=False, label="UInt32"), "TransmitOffload": SimStruct({"_bitfield": SimTypeChar(label="Byte")}, name="NL_INTERFACE_OFFLOAD_ROD", pack=False, align=None), "ReceiveOffload": SimStruct({"_bitfield": SimTypeChar(label="Byte")}, name="NL_INTERFACE_OFFLOAD_ROD", pack=False, align=None), "DisableDefaultRoutes": SimTypeChar(label="Byte")}, name="MIB_IPINTERFACE_ROW", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["Row"]),
        # 
        'NotifyIpInterfaceChange': SimTypeFunction([SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"Family": SimTypeShort(signed=False, label="UInt16"), "InterfaceLuid": SimUnion({"Value": SimTypeLongLong(signed=False, label="UInt64"), "Info": SimStruct({"_bitfield": SimTypeLongLong(signed=False, label="UInt64")}, name="_Info_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "InterfaceIndex": SimTypeInt(signed=False, label="UInt32"), "MaxReassemblySize": SimTypeInt(signed=False, label="UInt32"), "InterfaceIdentifier": SimTypeLongLong(signed=False, label="UInt64"), "MinRouterAdvertisementInterval": SimTypeInt(signed=False, label="UInt32"), "MaxRouterAdvertisementInterval": SimTypeInt(signed=False, label="UInt32"), "AdvertisingEnabled": SimTypeChar(label="Byte"), "ForwardingEnabled": SimTypeChar(label="Byte"), "WeakHostSend": SimTypeChar(label="Byte"), "WeakHostReceive": SimTypeChar(label="Byte"), "UseAutomaticMetric": SimTypeChar(label="Byte"), "UseNeighborUnreachabilityDetection": SimTypeChar(label="Byte"), "ManagedAddressConfigurationSupported": SimTypeChar(label="Byte"), "OtherStatefulConfigurationSupported": SimTypeChar(label="Byte"), "AdvertiseDefaultRoute": SimTypeChar(label="Byte"), "RouterDiscoveryBehavior": SimTypeInt(signed=False, label="NL_ROUTER_DISCOVERY_BEHAVIOR"), "DadTransmits": SimTypeInt(signed=False, label="UInt32"), "BaseReachableTime": SimTypeInt(signed=False, label="UInt32"), "RetransmitTime": SimTypeInt(signed=False, label="UInt32"), "PathMtuDiscoveryTimeout": SimTypeInt(signed=False, label="UInt32"), "LinkLocalAddressBehavior": SimTypeInt(signed=False, label="NL_LINK_LOCAL_ADDRESS_BEHAVIOR"), "LinkLocalAddressTimeout": SimTypeInt(signed=False, label="UInt32"), "ZoneIndices": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 16), "SitePrefixLength": SimTypeInt(signed=False, label="UInt32"), "Metric": SimTypeInt(signed=False, label="UInt32"), "NlMtu": SimTypeInt(signed=False, label="UInt32"), "Connected": SimTypeChar(label="Byte"), "SupportsWakeUpPatterns": SimTypeChar(label="Byte"), "SupportsNeighborDiscovery": SimTypeChar(label="Byte"), "SupportsRouterDiscovery": SimTypeChar(label="Byte"), "ReachableTime": SimTypeInt(signed=False, label="UInt32"), "TransmitOffload": SimStruct({"_bitfield": SimTypeChar(label="Byte")}, name="NL_INTERFACE_OFFLOAD_ROD", pack=False, align=None), "ReceiveOffload": SimStruct({"_bitfield": SimTypeChar(label="Byte")}, name="NL_INTERFACE_OFFLOAD_ROD", pack=False, align=None), "DisableDefaultRoutes": SimTypeChar(label="Byte")}, name="MIB_IPINTERFACE_ROW", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="MIB_NOTIFICATION_TYPE")], SimTypeBottom(label="Void"), arg_names=["CallerContext", "Row", "NotificationType"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeChar(label="Byte"), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Family", "Callback", "CallerContext", "InitialNotification", "NotificationHandle"]),
        # 
        'SetIpInterfaceEntry': SimTypeFunction([SimTypePointer(SimStruct({"Family": SimTypeShort(signed=False, label="UInt16"), "InterfaceLuid": SimUnion({"Value": SimTypeLongLong(signed=False, label="UInt64"), "Info": SimStruct({"_bitfield": SimTypeLongLong(signed=False, label="UInt64")}, name="_Info_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "InterfaceIndex": SimTypeInt(signed=False, label="UInt32"), "MaxReassemblySize": SimTypeInt(signed=False, label="UInt32"), "InterfaceIdentifier": SimTypeLongLong(signed=False, label="UInt64"), "MinRouterAdvertisementInterval": SimTypeInt(signed=False, label="UInt32"), "MaxRouterAdvertisementInterval": SimTypeInt(signed=False, label="UInt32"), "AdvertisingEnabled": SimTypeChar(label="Byte"), "ForwardingEnabled": SimTypeChar(label="Byte"), "WeakHostSend": SimTypeChar(label="Byte"), "WeakHostReceive": SimTypeChar(label="Byte"), "UseAutomaticMetric": SimTypeChar(label="Byte"), "UseNeighborUnreachabilityDetection": SimTypeChar(label="Byte"), "ManagedAddressConfigurationSupported": SimTypeChar(label="Byte"), "OtherStatefulConfigurationSupported": SimTypeChar(label="Byte"), "AdvertiseDefaultRoute": SimTypeChar(label="Byte"), "RouterDiscoveryBehavior": SimTypeInt(signed=False, label="NL_ROUTER_DISCOVERY_BEHAVIOR"), "DadTransmits": SimTypeInt(signed=False, label="UInt32"), "BaseReachableTime": SimTypeInt(signed=False, label="UInt32"), "RetransmitTime": SimTypeInt(signed=False, label="UInt32"), "PathMtuDiscoveryTimeout": SimTypeInt(signed=False, label="UInt32"), "LinkLocalAddressBehavior": SimTypeInt(signed=False, label="NL_LINK_LOCAL_ADDRESS_BEHAVIOR"), "LinkLocalAddressTimeout": SimTypeInt(signed=False, label="UInt32"), "ZoneIndices": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 16), "SitePrefixLength": SimTypeInt(signed=False, label="UInt32"), "Metric": SimTypeInt(signed=False, label="UInt32"), "NlMtu": SimTypeInt(signed=False, label="UInt32"), "Connected": SimTypeChar(label="Byte"), "SupportsWakeUpPatterns": SimTypeChar(label="Byte"), "SupportsNeighborDiscovery": SimTypeChar(label="Byte"), "SupportsRouterDiscovery": SimTypeChar(label="Byte"), "ReachableTime": SimTypeInt(signed=False, label="UInt32"), "TransmitOffload": SimStruct({"_bitfield": SimTypeChar(label="Byte")}, name="NL_INTERFACE_OFFLOAD_ROD", pack=False, align=None), "ReceiveOffload": SimStruct({"_bitfield": SimTypeChar(label="Byte")}, name="NL_INTERFACE_OFFLOAD_ROD", pack=False, align=None), "DisableDefaultRoutes": SimTypeChar(label="Byte")}, name="MIB_IPINTERFACE_ROW", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Row"]),
        # 
        'GetIpNetworkConnectionBandwidthEstimates': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimStruct({"InboundBandwidthInformation": SimStruct({"Bandwidth": SimTypeLongLong(signed=False, label="UInt64"), "Instability": SimTypeLongLong(signed=False, label="UInt64"), "BandwidthPeaked": SimTypeChar(label="Byte")}, name="NL_BANDWIDTH_INFORMATION", pack=False, align=None), "OutboundBandwidthInformation": SimStruct({"Bandwidth": SimTypeLongLong(signed=False, label="UInt64"), "Instability": SimTypeLongLong(signed=False, label="UInt64"), "BandwidthPeaked": SimTypeChar(label="Byte")}, name="NL_BANDWIDTH_INFORMATION", pack=False, align=None)}, name="MIB_IP_NETWORK_CONNECTION_BANDWIDTH_ESTIMATES", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["InterfaceIndex", "AddressFamily", "BandwidthEstimates"]),
        # 
        'CreateUnicastIpAddressEntry': SimTypeFunction([SimTypePointer(SimStruct({"Address": SimUnion({"Ipv4": SimStruct({"sin_family": SimTypeShort(signed=False, label="UInt16"), "sin_port": SimTypeShort(signed=False, label="UInt16"), "sin_addr": SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), "sin_zero": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 8)}, name="SOCKADDR_IN", pack=False, align=None), "Ipv6": SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None), "si_family": SimTypeShort(signed=False, label="UInt16")}, name="<anon>", label="None"), "InterfaceLuid": SimUnion({"Value": SimTypeLongLong(signed=False, label="UInt64"), "Info": SimStruct({"_bitfield": SimTypeLongLong(signed=False, label="UInt64")}, name="_Info_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "InterfaceIndex": SimTypeInt(signed=False, label="UInt32"), "PrefixOrigin": SimTypeInt(signed=False, label="NL_PREFIX_ORIGIN"), "SuffixOrigin": SimTypeInt(signed=False, label="NL_SUFFIX_ORIGIN"), "ValidLifetime": SimTypeInt(signed=False, label="UInt32"), "PreferredLifetime": SimTypeInt(signed=False, label="UInt32"), "OnLinkPrefixLength": SimTypeChar(label="Byte"), "SkipAsSource": SimTypeChar(label="Byte"), "DadState": SimTypeInt(signed=False, label="NL_DAD_STATE"), "ScopeId": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None), "CreationTimeStamp": SimTypeBottom(label="LARGE_INTEGER")}, name="MIB_UNICASTIPADDRESS_ROW", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Row"]),
        # 
        'DeleteUnicastIpAddressEntry': SimTypeFunction([SimTypePointer(SimStruct({"Address": SimUnion({"Ipv4": SimStruct({"sin_family": SimTypeShort(signed=False, label="UInt16"), "sin_port": SimTypeShort(signed=False, label="UInt16"), "sin_addr": SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), "sin_zero": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 8)}, name="SOCKADDR_IN", pack=False, align=None), "Ipv6": SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None), "si_family": SimTypeShort(signed=False, label="UInt16")}, name="<anon>", label="None"), "InterfaceLuid": SimUnion({"Value": SimTypeLongLong(signed=False, label="UInt64"), "Info": SimStruct({"_bitfield": SimTypeLongLong(signed=False, label="UInt64")}, name="_Info_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "InterfaceIndex": SimTypeInt(signed=False, label="UInt32"), "PrefixOrigin": SimTypeInt(signed=False, label="NL_PREFIX_ORIGIN"), "SuffixOrigin": SimTypeInt(signed=False, label="NL_SUFFIX_ORIGIN"), "ValidLifetime": SimTypeInt(signed=False, label="UInt32"), "PreferredLifetime": SimTypeInt(signed=False, label="UInt32"), "OnLinkPrefixLength": SimTypeChar(label="Byte"), "SkipAsSource": SimTypeChar(label="Byte"), "DadState": SimTypeInt(signed=False, label="NL_DAD_STATE"), "ScopeId": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None), "CreationTimeStamp": SimTypeBottom(label="LARGE_INTEGER")}, name="MIB_UNICASTIPADDRESS_ROW", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Row"]),
        # 
        'GetUnicastIpAddressEntry': SimTypeFunction([SimTypePointer(SimStruct({"Address": SimUnion({"Ipv4": SimStruct({"sin_family": SimTypeShort(signed=False, label="UInt16"), "sin_port": SimTypeShort(signed=False, label="UInt16"), "sin_addr": SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), "sin_zero": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 8)}, name="SOCKADDR_IN", pack=False, align=None), "Ipv6": SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None), "si_family": SimTypeShort(signed=False, label="UInt16")}, name="<anon>", label="None"), "InterfaceLuid": SimUnion({"Value": SimTypeLongLong(signed=False, label="UInt64"), "Info": SimStruct({"_bitfield": SimTypeLongLong(signed=False, label="UInt64")}, name="_Info_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "InterfaceIndex": SimTypeInt(signed=False, label="UInt32"), "PrefixOrigin": SimTypeInt(signed=False, label="NL_PREFIX_ORIGIN"), "SuffixOrigin": SimTypeInt(signed=False, label="NL_SUFFIX_ORIGIN"), "ValidLifetime": SimTypeInt(signed=False, label="UInt32"), "PreferredLifetime": SimTypeInt(signed=False, label="UInt32"), "OnLinkPrefixLength": SimTypeChar(label="Byte"), "SkipAsSource": SimTypeChar(label="Byte"), "DadState": SimTypeInt(signed=False, label="NL_DAD_STATE"), "ScopeId": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None), "CreationTimeStamp": SimTypeBottom(label="LARGE_INTEGER")}, name="MIB_UNICASTIPADDRESS_ROW", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Row"]),
        # 
        'GetUnicastIpAddressTable': SimTypeFunction([SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypePointer(SimStruct({"NumEntries": SimTypeInt(signed=False, label="UInt32"), "Table": SimTypePointer(SimStruct({"Address": SimUnion({"Ipv4": SimStruct({"sin_family": SimTypeShort(signed=False, label="UInt16"), "sin_port": SimTypeShort(signed=False, label="UInt16"), "sin_addr": SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), "sin_zero": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 8)}, name="SOCKADDR_IN", pack=False, align=None), "Ipv6": SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None), "si_family": SimTypeShort(signed=False, label="UInt16")}, name="<anon>", label="None"), "InterfaceLuid": SimUnion({"Value": SimTypeLongLong(signed=False, label="UInt64"), "Info": SimStruct({"_bitfield": SimTypeLongLong(signed=False, label="UInt64")}, name="_Info_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "InterfaceIndex": SimTypeInt(signed=False, label="UInt32"), "PrefixOrigin": SimTypeInt(signed=False, label="NL_PREFIX_ORIGIN"), "SuffixOrigin": SimTypeInt(signed=False, label="NL_SUFFIX_ORIGIN"), "ValidLifetime": SimTypeInt(signed=False, label="UInt32"), "PreferredLifetime": SimTypeInt(signed=False, label="UInt32"), "OnLinkPrefixLength": SimTypeChar(label="Byte"), "SkipAsSource": SimTypeChar(label="Byte"), "DadState": SimTypeInt(signed=False, label="NL_DAD_STATE"), "ScopeId": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None), "CreationTimeStamp": SimTypeBottom(label="LARGE_INTEGER")}, name="MIB_UNICASTIPADDRESS_ROW", pack=False, align=None), offset=0)}, name="MIB_UNICASTIPADDRESS_TABLE", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Family", "Table"]),
        # 
        'InitializeUnicastIpAddressEntry': SimTypeFunction([SimTypePointer(SimStruct({"Address": SimUnion({"Ipv4": SimStruct({"sin_family": SimTypeShort(signed=False, label="UInt16"), "sin_port": SimTypeShort(signed=False, label="UInt16"), "sin_addr": SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), "sin_zero": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 8)}, name="SOCKADDR_IN", pack=False, align=None), "Ipv6": SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None), "si_family": SimTypeShort(signed=False, label="UInt16")}, name="<anon>", label="None"), "InterfaceLuid": SimUnion({"Value": SimTypeLongLong(signed=False, label="UInt64"), "Info": SimStruct({"_bitfield": SimTypeLongLong(signed=False, label="UInt64")}, name="_Info_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "InterfaceIndex": SimTypeInt(signed=False, label="UInt32"), "PrefixOrigin": SimTypeInt(signed=False, label="NL_PREFIX_ORIGIN"), "SuffixOrigin": SimTypeInt(signed=False, label="NL_SUFFIX_ORIGIN"), "ValidLifetime": SimTypeInt(signed=False, label="UInt32"), "PreferredLifetime": SimTypeInt(signed=False, label="UInt32"), "OnLinkPrefixLength": SimTypeChar(label="Byte"), "SkipAsSource": SimTypeChar(label="Byte"), "DadState": SimTypeInt(signed=False, label="NL_DAD_STATE"), "ScopeId": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None), "CreationTimeStamp": SimTypeBottom(label="LARGE_INTEGER")}, name="MIB_UNICASTIPADDRESS_ROW", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["Row"]),
        # 
        'NotifyUnicastIpAddressChange': SimTypeFunction([SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"Address": SimUnion({"Ipv4": SimStruct({"sin_family": SimTypeShort(signed=False, label="UInt16"), "sin_port": SimTypeShort(signed=False, label="UInt16"), "sin_addr": SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), "sin_zero": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 8)}, name="SOCKADDR_IN", pack=False, align=None), "Ipv6": SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None), "si_family": SimTypeShort(signed=False, label="UInt16")}, name="<anon>", label="None"), "InterfaceLuid": SimUnion({"Value": SimTypeLongLong(signed=False, label="UInt64"), "Info": SimStruct({"_bitfield": SimTypeLongLong(signed=False, label="UInt64")}, name="_Info_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "InterfaceIndex": SimTypeInt(signed=False, label="UInt32"), "PrefixOrigin": SimTypeInt(signed=False, label="NL_PREFIX_ORIGIN"), "SuffixOrigin": SimTypeInt(signed=False, label="NL_SUFFIX_ORIGIN"), "ValidLifetime": SimTypeInt(signed=False, label="UInt32"), "PreferredLifetime": SimTypeInt(signed=False, label="UInt32"), "OnLinkPrefixLength": SimTypeChar(label="Byte"), "SkipAsSource": SimTypeChar(label="Byte"), "DadState": SimTypeInt(signed=False, label="NL_DAD_STATE"), "ScopeId": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None), "CreationTimeStamp": SimTypeBottom(label="LARGE_INTEGER")}, name="MIB_UNICASTIPADDRESS_ROW", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="MIB_NOTIFICATION_TYPE")], SimTypeBottom(label="Void"), arg_names=["CallerContext", "Row", "NotificationType"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeChar(label="Byte"), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Family", "Callback", "CallerContext", "InitialNotification", "NotificationHandle"]),
        # 
        'NotifyStableUnicastIpAddressTable': SimTypeFunction([SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypePointer(SimStruct({"NumEntries": SimTypeInt(signed=False, label="UInt32"), "Table": SimTypePointer(SimStruct({"Address": SimUnion({"Ipv4": SimStruct({"sin_family": SimTypeShort(signed=False, label="UInt16"), "sin_port": SimTypeShort(signed=False, label="UInt16"), "sin_addr": SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), "sin_zero": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 8)}, name="SOCKADDR_IN", pack=False, align=None), "Ipv6": SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None), "si_family": SimTypeShort(signed=False, label="UInt16")}, name="<anon>", label="None"), "InterfaceLuid": SimUnion({"Value": SimTypeLongLong(signed=False, label="UInt64"), "Info": SimStruct({"_bitfield": SimTypeLongLong(signed=False, label="UInt64")}, name="_Info_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "InterfaceIndex": SimTypeInt(signed=False, label="UInt32"), "PrefixOrigin": SimTypeInt(signed=False, label="NL_PREFIX_ORIGIN"), "SuffixOrigin": SimTypeInt(signed=False, label="NL_SUFFIX_ORIGIN"), "ValidLifetime": SimTypeInt(signed=False, label="UInt32"), "PreferredLifetime": SimTypeInt(signed=False, label="UInt32"), "OnLinkPrefixLength": SimTypeChar(label="Byte"), "SkipAsSource": SimTypeChar(label="Byte"), "DadState": SimTypeInt(signed=False, label="NL_DAD_STATE"), "ScopeId": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None), "CreationTimeStamp": SimTypeBottom(label="LARGE_INTEGER")}, name="MIB_UNICASTIPADDRESS_ROW", pack=False, align=None), offset=0)}, name="MIB_UNICASTIPADDRESS_TABLE", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"NumEntries": SimTypeInt(signed=False, label="UInt32"), "Table": SimTypePointer(SimStruct({"Address": SimUnion({"Ipv4": SimStruct({"sin_family": SimTypeShort(signed=False, label="UInt16"), "sin_port": SimTypeShort(signed=False, label="UInt16"), "sin_addr": SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), "sin_zero": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 8)}, name="SOCKADDR_IN", pack=False, align=None), "Ipv6": SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None), "si_family": SimTypeShort(signed=False, label="UInt16")}, name="<anon>", label="None"), "InterfaceLuid": SimUnion({"Value": SimTypeLongLong(signed=False, label="UInt64"), "Info": SimStruct({"_bitfield": SimTypeLongLong(signed=False, label="UInt64")}, name="_Info_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "InterfaceIndex": SimTypeInt(signed=False, label="UInt32"), "PrefixOrigin": SimTypeInt(signed=False, label="NL_PREFIX_ORIGIN"), "SuffixOrigin": SimTypeInt(signed=False, label="NL_SUFFIX_ORIGIN"), "ValidLifetime": SimTypeInt(signed=False, label="UInt32"), "PreferredLifetime": SimTypeInt(signed=False, label="UInt32"), "OnLinkPrefixLength": SimTypeChar(label="Byte"), "SkipAsSource": SimTypeChar(label="Byte"), "DadState": SimTypeInt(signed=False, label="NL_DAD_STATE"), "ScopeId": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None), "CreationTimeStamp": SimTypeBottom(label="LARGE_INTEGER")}, name="MIB_UNICASTIPADDRESS_ROW", pack=False, align=None), offset=0)}, name="MIB_UNICASTIPADDRESS_TABLE", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["CallerContext", "AddressTable"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Family", "Table", "CallerCallback", "CallerContext", "NotificationHandle"]),
        # 
        'SetUnicastIpAddressEntry': SimTypeFunction([SimTypePointer(SimStruct({"Address": SimUnion({"Ipv4": SimStruct({"sin_family": SimTypeShort(signed=False, label="UInt16"), "sin_port": SimTypeShort(signed=False, label="UInt16"), "sin_addr": SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), "sin_zero": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 8)}, name="SOCKADDR_IN", pack=False, align=None), "Ipv6": SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None), "si_family": SimTypeShort(signed=False, label="UInt16")}, name="<anon>", label="None"), "InterfaceLuid": SimUnion({"Value": SimTypeLongLong(signed=False, label="UInt64"), "Info": SimStruct({"_bitfield": SimTypeLongLong(signed=False, label="UInt64")}, name="_Info_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "InterfaceIndex": SimTypeInt(signed=False, label="UInt32"), "PrefixOrigin": SimTypeInt(signed=False, label="NL_PREFIX_ORIGIN"), "SuffixOrigin": SimTypeInt(signed=False, label="NL_SUFFIX_ORIGIN"), "ValidLifetime": SimTypeInt(signed=False, label="UInt32"), "PreferredLifetime": SimTypeInt(signed=False, label="UInt32"), "OnLinkPrefixLength": SimTypeChar(label="Byte"), "SkipAsSource": SimTypeChar(label="Byte"), "DadState": SimTypeInt(signed=False, label="NL_DAD_STATE"), "ScopeId": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None), "CreationTimeStamp": SimTypeBottom(label="LARGE_INTEGER")}, name="MIB_UNICASTIPADDRESS_ROW", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Row"]),
        # 
        'CreateAnycastIpAddressEntry': SimTypeFunction([SimTypePointer(SimStruct({"Address": SimUnion({"Ipv4": SimStruct({"sin_family": SimTypeShort(signed=False, label="UInt16"), "sin_port": SimTypeShort(signed=False, label="UInt16"), "sin_addr": SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), "sin_zero": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 8)}, name="SOCKADDR_IN", pack=False, align=None), "Ipv6": SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None), "si_family": SimTypeShort(signed=False, label="UInt16")}, name="<anon>", label="None"), "InterfaceLuid": SimUnion({"Value": SimTypeLongLong(signed=False, label="UInt64"), "Info": SimStruct({"_bitfield": SimTypeLongLong(signed=False, label="UInt64")}, name="_Info_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "InterfaceIndex": SimTypeInt(signed=False, label="UInt32"), "ScopeId": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="MIB_ANYCASTIPADDRESS_ROW", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Row"]),
        # 
        'DeleteAnycastIpAddressEntry': SimTypeFunction([SimTypePointer(SimStruct({"Address": SimUnion({"Ipv4": SimStruct({"sin_family": SimTypeShort(signed=False, label="UInt16"), "sin_port": SimTypeShort(signed=False, label="UInt16"), "sin_addr": SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), "sin_zero": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 8)}, name="SOCKADDR_IN", pack=False, align=None), "Ipv6": SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None), "si_family": SimTypeShort(signed=False, label="UInt16")}, name="<anon>", label="None"), "InterfaceLuid": SimUnion({"Value": SimTypeLongLong(signed=False, label="UInt64"), "Info": SimStruct({"_bitfield": SimTypeLongLong(signed=False, label="UInt64")}, name="_Info_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "InterfaceIndex": SimTypeInt(signed=False, label="UInt32"), "ScopeId": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="MIB_ANYCASTIPADDRESS_ROW", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Row"]),
        # 
        'GetAnycastIpAddressEntry': SimTypeFunction([SimTypePointer(SimStruct({"Address": SimUnion({"Ipv4": SimStruct({"sin_family": SimTypeShort(signed=False, label="UInt16"), "sin_port": SimTypeShort(signed=False, label="UInt16"), "sin_addr": SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), "sin_zero": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 8)}, name="SOCKADDR_IN", pack=False, align=None), "Ipv6": SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None), "si_family": SimTypeShort(signed=False, label="UInt16")}, name="<anon>", label="None"), "InterfaceLuid": SimUnion({"Value": SimTypeLongLong(signed=False, label="UInt64"), "Info": SimStruct({"_bitfield": SimTypeLongLong(signed=False, label="UInt64")}, name="_Info_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "InterfaceIndex": SimTypeInt(signed=False, label="UInt32"), "ScopeId": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="MIB_ANYCASTIPADDRESS_ROW", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Row"]),
        # 
        'GetAnycastIpAddressTable': SimTypeFunction([SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypePointer(SimStruct({"NumEntries": SimTypeInt(signed=False, label="UInt32"), "Table": SimTypePointer(SimStruct({"Address": SimUnion({"Ipv4": SimStruct({"sin_family": SimTypeShort(signed=False, label="UInt16"), "sin_port": SimTypeShort(signed=False, label="UInt16"), "sin_addr": SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), "sin_zero": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 8)}, name="SOCKADDR_IN", pack=False, align=None), "Ipv6": SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None), "si_family": SimTypeShort(signed=False, label="UInt16")}, name="<anon>", label="None"), "InterfaceLuid": SimUnion({"Value": SimTypeLongLong(signed=False, label="UInt64"), "Info": SimStruct({"_bitfield": SimTypeLongLong(signed=False, label="UInt64")}, name="_Info_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "InterfaceIndex": SimTypeInt(signed=False, label="UInt32"), "ScopeId": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="MIB_ANYCASTIPADDRESS_ROW", pack=False, align=None), offset=0)}, name="MIB_ANYCASTIPADDRESS_TABLE", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Family", "Table"]),
        # 
        'GetMulticastIpAddressEntry': SimTypeFunction([SimTypePointer(SimStruct({"Address": SimUnion({"Ipv4": SimStruct({"sin_family": SimTypeShort(signed=False, label="UInt16"), "sin_port": SimTypeShort(signed=False, label="UInt16"), "sin_addr": SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), "sin_zero": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 8)}, name="SOCKADDR_IN", pack=False, align=None), "Ipv6": SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None), "si_family": SimTypeShort(signed=False, label="UInt16")}, name="<anon>", label="None"), "InterfaceIndex": SimTypeInt(signed=False, label="UInt32"), "InterfaceLuid": SimUnion({"Value": SimTypeLongLong(signed=False, label="UInt64"), "Info": SimStruct({"_bitfield": SimTypeLongLong(signed=False, label="UInt64")}, name="_Info_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "ScopeId": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="MIB_MULTICASTIPADDRESS_ROW", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Row"]),
        # 
        'GetMulticastIpAddressTable': SimTypeFunction([SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypePointer(SimStruct({"NumEntries": SimTypeInt(signed=False, label="UInt32"), "Table": SimTypePointer(SimStruct({"Address": SimUnion({"Ipv4": SimStruct({"sin_family": SimTypeShort(signed=False, label="UInt16"), "sin_port": SimTypeShort(signed=False, label="UInt16"), "sin_addr": SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), "sin_zero": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 8)}, name="SOCKADDR_IN", pack=False, align=None), "Ipv6": SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None), "si_family": SimTypeShort(signed=False, label="UInt16")}, name="<anon>", label="None"), "InterfaceIndex": SimTypeInt(signed=False, label="UInt32"), "InterfaceLuid": SimUnion({"Value": SimTypeLongLong(signed=False, label="UInt64"), "Info": SimStruct({"_bitfield": SimTypeLongLong(signed=False, label="UInt64")}, name="_Info_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "ScopeId": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="MIB_MULTICASTIPADDRESS_ROW", pack=False, align=None), offset=0)}, name="MIB_MULTICASTIPADDRESS_TABLE", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Family", "Table"]),
        # 
        'CreateIpForwardEntry2': SimTypeFunction([SimTypePointer(SimStruct({"InterfaceLuid": SimUnion({"Value": SimTypeLongLong(signed=False, label="UInt64"), "Info": SimStruct({"_bitfield": SimTypeLongLong(signed=False, label="UInt64")}, name="_Info_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "InterfaceIndex": SimTypeInt(signed=False, label="UInt32"), "DestinationPrefix": SimStruct({"Prefix": SimUnion({"Ipv4": SimStruct({"sin_family": SimTypeShort(signed=False, label="UInt16"), "sin_port": SimTypeShort(signed=False, label="UInt16"), "sin_addr": SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), "sin_zero": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 8)}, name="SOCKADDR_IN", pack=False, align=None), "Ipv6": SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None), "si_family": SimTypeShort(signed=False, label="UInt16")}, name="<anon>", label="None"), "PrefixLength": SimTypeChar(label="Byte")}, name="IP_ADDRESS_PREFIX", pack=False, align=None), "NextHop": SimUnion({"Ipv4": SimStruct({"sin_family": SimTypeShort(signed=False, label="UInt16"), "sin_port": SimTypeShort(signed=False, label="UInt16"), "sin_addr": SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), "sin_zero": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 8)}, name="SOCKADDR_IN", pack=False, align=None), "Ipv6": SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None), "si_family": SimTypeShort(signed=False, label="UInt16")}, name="<anon>", label="None"), "SitePrefixLength": SimTypeChar(label="Byte"), "ValidLifetime": SimTypeInt(signed=False, label="UInt32"), "PreferredLifetime": SimTypeInt(signed=False, label="UInt32"), "Metric": SimTypeInt(signed=False, label="UInt32"), "Protocol": SimTypeInt(signed=False, label="NL_ROUTE_PROTOCOL"), "Loopback": SimTypeChar(label="Byte"), "AutoconfigureAddress": SimTypeChar(label="Byte"), "Publish": SimTypeChar(label="Byte"), "Immortal": SimTypeChar(label="Byte"), "Age": SimTypeInt(signed=False, label="UInt32"), "Origin": SimTypeInt(signed=False, label="NL_ROUTE_ORIGIN")}, name="MIB_IPFORWARD_ROW2", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Row"]),
        # 
        'DeleteIpForwardEntry2': SimTypeFunction([SimTypePointer(SimStruct({"InterfaceLuid": SimUnion({"Value": SimTypeLongLong(signed=False, label="UInt64"), "Info": SimStruct({"_bitfield": SimTypeLongLong(signed=False, label="UInt64")}, name="_Info_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "InterfaceIndex": SimTypeInt(signed=False, label="UInt32"), "DestinationPrefix": SimStruct({"Prefix": SimUnion({"Ipv4": SimStruct({"sin_family": SimTypeShort(signed=False, label="UInt16"), "sin_port": SimTypeShort(signed=False, label="UInt16"), "sin_addr": SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), "sin_zero": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 8)}, name="SOCKADDR_IN", pack=False, align=None), "Ipv6": SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None), "si_family": SimTypeShort(signed=False, label="UInt16")}, name="<anon>", label="None"), "PrefixLength": SimTypeChar(label="Byte")}, name="IP_ADDRESS_PREFIX", pack=False, align=None), "NextHop": SimUnion({"Ipv4": SimStruct({"sin_family": SimTypeShort(signed=False, label="UInt16"), "sin_port": SimTypeShort(signed=False, label="UInt16"), "sin_addr": SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), "sin_zero": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 8)}, name="SOCKADDR_IN", pack=False, align=None), "Ipv6": SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None), "si_family": SimTypeShort(signed=False, label="UInt16")}, name="<anon>", label="None"), "SitePrefixLength": SimTypeChar(label="Byte"), "ValidLifetime": SimTypeInt(signed=False, label="UInt32"), "PreferredLifetime": SimTypeInt(signed=False, label="UInt32"), "Metric": SimTypeInt(signed=False, label="UInt32"), "Protocol": SimTypeInt(signed=False, label="NL_ROUTE_PROTOCOL"), "Loopback": SimTypeChar(label="Byte"), "AutoconfigureAddress": SimTypeChar(label="Byte"), "Publish": SimTypeChar(label="Byte"), "Immortal": SimTypeChar(label="Byte"), "Age": SimTypeInt(signed=False, label="UInt32"), "Origin": SimTypeInt(signed=False, label="NL_ROUTE_ORIGIN")}, name="MIB_IPFORWARD_ROW2", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Row"]),
        # 
        'GetBestRoute2': SimTypeFunction([SimTypePointer(SimUnion({"Value": SimTypeLongLong(signed=False, label="UInt64"), "Info": SimStruct({"_bitfield": SimTypeLongLong(signed=False, label="UInt64")}, name="_Info_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimUnion({"Ipv4": SimStruct({"sin_family": SimTypeShort(signed=False, label="UInt16"), "sin_port": SimTypeShort(signed=False, label="UInt16"), "sin_addr": SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), "sin_zero": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 8)}, name="SOCKADDR_IN", pack=False, align=None), "Ipv6": SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None), "si_family": SimTypeShort(signed=False, label="UInt16")}, name="<anon>", label="None"), offset=0), SimTypePointer(SimUnion({"Ipv4": SimStruct({"sin_family": SimTypeShort(signed=False, label="UInt16"), "sin_port": SimTypeShort(signed=False, label="UInt16"), "sin_addr": SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), "sin_zero": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 8)}, name="SOCKADDR_IN", pack=False, align=None), "Ipv6": SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None), "si_family": SimTypeShort(signed=False, label="UInt16")}, name="<anon>", label="None"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"InterfaceLuid": SimUnion({"Value": SimTypeLongLong(signed=False, label="UInt64"), "Info": SimStruct({"_bitfield": SimTypeLongLong(signed=False, label="UInt64")}, name="_Info_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "InterfaceIndex": SimTypeInt(signed=False, label="UInt32"), "DestinationPrefix": SimStruct({"Prefix": SimUnion({"Ipv4": SimStruct({"sin_family": SimTypeShort(signed=False, label="UInt16"), "sin_port": SimTypeShort(signed=False, label="UInt16"), "sin_addr": SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), "sin_zero": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 8)}, name="SOCKADDR_IN", pack=False, align=None), "Ipv6": SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None), "si_family": SimTypeShort(signed=False, label="UInt16")}, name="<anon>", label="None"), "PrefixLength": SimTypeChar(label="Byte")}, name="IP_ADDRESS_PREFIX", pack=False, align=None), "NextHop": SimUnion({"Ipv4": SimStruct({"sin_family": SimTypeShort(signed=False, label="UInt16"), "sin_port": SimTypeShort(signed=False, label="UInt16"), "sin_addr": SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), "sin_zero": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 8)}, name="SOCKADDR_IN", pack=False, align=None), "Ipv6": SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None), "si_family": SimTypeShort(signed=False, label="UInt16")}, name="<anon>", label="None"), "SitePrefixLength": SimTypeChar(label="Byte"), "ValidLifetime": SimTypeInt(signed=False, label="UInt32"), "PreferredLifetime": SimTypeInt(signed=False, label="UInt32"), "Metric": SimTypeInt(signed=False, label="UInt32"), "Protocol": SimTypeInt(signed=False, label="NL_ROUTE_PROTOCOL"), "Loopback": SimTypeChar(label="Byte"), "AutoconfigureAddress": SimTypeChar(label="Byte"), "Publish": SimTypeChar(label="Byte"), "Immortal": SimTypeChar(label="Byte"), "Age": SimTypeInt(signed=False, label="UInt32"), "Origin": SimTypeInt(signed=False, label="NL_ROUTE_ORIGIN")}, name="MIB_IPFORWARD_ROW2", pack=False, align=None), offset=0), SimTypePointer(SimUnion({"Ipv4": SimStruct({"sin_family": SimTypeShort(signed=False, label="UInt16"), "sin_port": SimTypeShort(signed=False, label="UInt16"), "sin_addr": SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), "sin_zero": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 8)}, name="SOCKADDR_IN", pack=False, align=None), "Ipv6": SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None), "si_family": SimTypeShort(signed=False, label="UInt16")}, name="<anon>", label="None"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["InterfaceLuid", "InterfaceIndex", "SourceAddress", "DestinationAddress", "AddressSortOptions", "BestRoute", "BestSourceAddress"]),
        # 
        'GetIpForwardEntry2': SimTypeFunction([SimTypePointer(SimStruct({"InterfaceLuid": SimUnion({"Value": SimTypeLongLong(signed=False, label="UInt64"), "Info": SimStruct({"_bitfield": SimTypeLongLong(signed=False, label="UInt64")}, name="_Info_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "InterfaceIndex": SimTypeInt(signed=False, label="UInt32"), "DestinationPrefix": SimStruct({"Prefix": SimUnion({"Ipv4": SimStruct({"sin_family": SimTypeShort(signed=False, label="UInt16"), "sin_port": SimTypeShort(signed=False, label="UInt16"), "sin_addr": SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), "sin_zero": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 8)}, name="SOCKADDR_IN", pack=False, align=None), "Ipv6": SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None), "si_family": SimTypeShort(signed=False, label="UInt16")}, name="<anon>", label="None"), "PrefixLength": SimTypeChar(label="Byte")}, name="IP_ADDRESS_PREFIX", pack=False, align=None), "NextHop": SimUnion({"Ipv4": SimStruct({"sin_family": SimTypeShort(signed=False, label="UInt16"), "sin_port": SimTypeShort(signed=False, label="UInt16"), "sin_addr": SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), "sin_zero": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 8)}, name="SOCKADDR_IN", pack=False, align=None), "Ipv6": SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None), "si_family": SimTypeShort(signed=False, label="UInt16")}, name="<anon>", label="None"), "SitePrefixLength": SimTypeChar(label="Byte"), "ValidLifetime": SimTypeInt(signed=False, label="UInt32"), "PreferredLifetime": SimTypeInt(signed=False, label="UInt32"), "Metric": SimTypeInt(signed=False, label="UInt32"), "Protocol": SimTypeInt(signed=False, label="NL_ROUTE_PROTOCOL"), "Loopback": SimTypeChar(label="Byte"), "AutoconfigureAddress": SimTypeChar(label="Byte"), "Publish": SimTypeChar(label="Byte"), "Immortal": SimTypeChar(label="Byte"), "Age": SimTypeInt(signed=False, label="UInt32"), "Origin": SimTypeInt(signed=False, label="NL_ROUTE_ORIGIN")}, name="MIB_IPFORWARD_ROW2", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Row"]),
        # 
        'GetIpForwardTable2': SimTypeFunction([SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypePointer(SimStruct({"NumEntries": SimTypeInt(signed=False, label="UInt32"), "Table": SimTypePointer(SimStruct({"InterfaceLuid": SimUnion({"Value": SimTypeLongLong(signed=False, label="UInt64"), "Info": SimStruct({"_bitfield": SimTypeLongLong(signed=False, label="UInt64")}, name="_Info_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "InterfaceIndex": SimTypeInt(signed=False, label="UInt32"), "DestinationPrefix": SimStruct({"Prefix": SimUnion({"Ipv4": SimStruct({"sin_family": SimTypeShort(signed=False, label="UInt16"), "sin_port": SimTypeShort(signed=False, label="UInt16"), "sin_addr": SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), "sin_zero": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 8)}, name="SOCKADDR_IN", pack=False, align=None), "Ipv6": SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None), "si_family": SimTypeShort(signed=False, label="UInt16")}, name="<anon>", label="None"), "PrefixLength": SimTypeChar(label="Byte")}, name="IP_ADDRESS_PREFIX", pack=False, align=None), "NextHop": SimUnion({"Ipv4": SimStruct({"sin_family": SimTypeShort(signed=False, label="UInt16"), "sin_port": SimTypeShort(signed=False, label="UInt16"), "sin_addr": SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), "sin_zero": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 8)}, name="SOCKADDR_IN", pack=False, align=None), "Ipv6": SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None), "si_family": SimTypeShort(signed=False, label="UInt16")}, name="<anon>", label="None"), "SitePrefixLength": SimTypeChar(label="Byte"), "ValidLifetime": SimTypeInt(signed=False, label="UInt32"), "PreferredLifetime": SimTypeInt(signed=False, label="UInt32"), "Metric": SimTypeInt(signed=False, label="UInt32"), "Protocol": SimTypeInt(signed=False, label="NL_ROUTE_PROTOCOL"), "Loopback": SimTypeChar(label="Byte"), "AutoconfigureAddress": SimTypeChar(label="Byte"), "Publish": SimTypeChar(label="Byte"), "Immortal": SimTypeChar(label="Byte"), "Age": SimTypeInt(signed=False, label="UInt32"), "Origin": SimTypeInt(signed=False, label="NL_ROUTE_ORIGIN")}, name="MIB_IPFORWARD_ROW2", pack=False, align=None), offset=0)}, name="MIB_IPFORWARD_TABLE2", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Family", "Table"]),
        # 
        'InitializeIpForwardEntry': SimTypeFunction([SimTypePointer(SimStruct({"InterfaceLuid": SimUnion({"Value": SimTypeLongLong(signed=False, label="UInt64"), "Info": SimStruct({"_bitfield": SimTypeLongLong(signed=False, label="UInt64")}, name="_Info_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "InterfaceIndex": SimTypeInt(signed=False, label="UInt32"), "DestinationPrefix": SimStruct({"Prefix": SimUnion({"Ipv4": SimStruct({"sin_family": SimTypeShort(signed=False, label="UInt16"), "sin_port": SimTypeShort(signed=False, label="UInt16"), "sin_addr": SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), "sin_zero": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 8)}, name="SOCKADDR_IN", pack=False, align=None), "Ipv6": SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None), "si_family": SimTypeShort(signed=False, label="UInt16")}, name="<anon>", label="None"), "PrefixLength": SimTypeChar(label="Byte")}, name="IP_ADDRESS_PREFIX", pack=False, align=None), "NextHop": SimUnion({"Ipv4": SimStruct({"sin_family": SimTypeShort(signed=False, label="UInt16"), "sin_port": SimTypeShort(signed=False, label="UInt16"), "sin_addr": SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), "sin_zero": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 8)}, name="SOCKADDR_IN", pack=False, align=None), "Ipv6": SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None), "si_family": SimTypeShort(signed=False, label="UInt16")}, name="<anon>", label="None"), "SitePrefixLength": SimTypeChar(label="Byte"), "ValidLifetime": SimTypeInt(signed=False, label="UInt32"), "PreferredLifetime": SimTypeInt(signed=False, label="UInt32"), "Metric": SimTypeInt(signed=False, label="UInt32"), "Protocol": SimTypeInt(signed=False, label="NL_ROUTE_PROTOCOL"), "Loopback": SimTypeChar(label="Byte"), "AutoconfigureAddress": SimTypeChar(label="Byte"), "Publish": SimTypeChar(label="Byte"), "Immortal": SimTypeChar(label="Byte"), "Age": SimTypeInt(signed=False, label="UInt32"), "Origin": SimTypeInt(signed=False, label="NL_ROUTE_ORIGIN")}, name="MIB_IPFORWARD_ROW2", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["Row"]),
        # 
        'NotifyRouteChange2': SimTypeFunction([SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"InterfaceLuid": SimUnion({"Value": SimTypeLongLong(signed=False, label="UInt64"), "Info": SimStruct({"_bitfield": SimTypeLongLong(signed=False, label="UInt64")}, name="_Info_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "InterfaceIndex": SimTypeInt(signed=False, label="UInt32"), "DestinationPrefix": SimStruct({"Prefix": SimUnion({"Ipv4": SimStruct({"sin_family": SimTypeShort(signed=False, label="UInt16"), "sin_port": SimTypeShort(signed=False, label="UInt16"), "sin_addr": SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), "sin_zero": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 8)}, name="SOCKADDR_IN", pack=False, align=None), "Ipv6": SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None), "si_family": SimTypeShort(signed=False, label="UInt16")}, name="<anon>", label="None"), "PrefixLength": SimTypeChar(label="Byte")}, name="IP_ADDRESS_PREFIX", pack=False, align=None), "NextHop": SimUnion({"Ipv4": SimStruct({"sin_family": SimTypeShort(signed=False, label="UInt16"), "sin_port": SimTypeShort(signed=False, label="UInt16"), "sin_addr": SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), "sin_zero": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 8)}, name="SOCKADDR_IN", pack=False, align=None), "Ipv6": SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None), "si_family": SimTypeShort(signed=False, label="UInt16")}, name="<anon>", label="None"), "SitePrefixLength": SimTypeChar(label="Byte"), "ValidLifetime": SimTypeInt(signed=False, label="UInt32"), "PreferredLifetime": SimTypeInt(signed=False, label="UInt32"), "Metric": SimTypeInt(signed=False, label="UInt32"), "Protocol": SimTypeInt(signed=False, label="NL_ROUTE_PROTOCOL"), "Loopback": SimTypeChar(label="Byte"), "AutoconfigureAddress": SimTypeChar(label="Byte"), "Publish": SimTypeChar(label="Byte"), "Immortal": SimTypeChar(label="Byte"), "Age": SimTypeInt(signed=False, label="UInt32"), "Origin": SimTypeInt(signed=False, label="NL_ROUTE_ORIGIN")}, name="MIB_IPFORWARD_ROW2", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="MIB_NOTIFICATION_TYPE")], SimTypeBottom(label="Void"), arg_names=["CallerContext", "Row", "NotificationType"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeChar(label="Byte"), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["AddressFamily", "Callback", "CallerContext", "InitialNotification", "NotificationHandle"]),
        # 
        'SetIpForwardEntry2': SimTypeFunction([SimTypePointer(SimStruct({"InterfaceLuid": SimUnion({"Value": SimTypeLongLong(signed=False, label="UInt64"), "Info": SimStruct({"_bitfield": SimTypeLongLong(signed=False, label="UInt64")}, name="_Info_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "InterfaceIndex": SimTypeInt(signed=False, label="UInt32"), "DestinationPrefix": SimStruct({"Prefix": SimUnion({"Ipv4": SimStruct({"sin_family": SimTypeShort(signed=False, label="UInt16"), "sin_port": SimTypeShort(signed=False, label="UInt16"), "sin_addr": SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), "sin_zero": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 8)}, name="SOCKADDR_IN", pack=False, align=None), "Ipv6": SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None), "si_family": SimTypeShort(signed=False, label="UInt16")}, name="<anon>", label="None"), "PrefixLength": SimTypeChar(label="Byte")}, name="IP_ADDRESS_PREFIX", pack=False, align=None), "NextHop": SimUnion({"Ipv4": SimStruct({"sin_family": SimTypeShort(signed=False, label="UInt16"), "sin_port": SimTypeShort(signed=False, label="UInt16"), "sin_addr": SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), "sin_zero": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 8)}, name="SOCKADDR_IN", pack=False, align=None), "Ipv6": SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None), "si_family": SimTypeShort(signed=False, label="UInt16")}, name="<anon>", label="None"), "SitePrefixLength": SimTypeChar(label="Byte"), "ValidLifetime": SimTypeInt(signed=False, label="UInt32"), "PreferredLifetime": SimTypeInt(signed=False, label="UInt32"), "Metric": SimTypeInt(signed=False, label="UInt32"), "Protocol": SimTypeInt(signed=False, label="NL_ROUTE_PROTOCOL"), "Loopback": SimTypeChar(label="Byte"), "AutoconfigureAddress": SimTypeChar(label="Byte"), "Publish": SimTypeChar(label="Byte"), "Immortal": SimTypeChar(label="Byte"), "Age": SimTypeInt(signed=False, label="UInt32"), "Origin": SimTypeInt(signed=False, label="NL_ROUTE_ORIGIN")}, name="MIB_IPFORWARD_ROW2", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Route"]),
        # 
        'FlushIpPathTable': SimTypeFunction([SimTypeShort(signed=False, label="UInt16")], SimTypeInt(signed=True, label="Int32"), arg_names=["Family"]),
        # 
        'GetIpPathEntry': SimTypeFunction([SimTypePointer(SimStruct({"Source": SimUnion({"Ipv4": SimStruct({"sin_family": SimTypeShort(signed=False, label="UInt16"), "sin_port": SimTypeShort(signed=False, label="UInt16"), "sin_addr": SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), "sin_zero": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 8)}, name="SOCKADDR_IN", pack=False, align=None), "Ipv6": SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None), "si_family": SimTypeShort(signed=False, label="UInt16")}, name="<anon>", label="None"), "Destination": SimUnion({"Ipv4": SimStruct({"sin_family": SimTypeShort(signed=False, label="UInt16"), "sin_port": SimTypeShort(signed=False, label="UInt16"), "sin_addr": SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), "sin_zero": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 8)}, name="SOCKADDR_IN", pack=False, align=None), "Ipv6": SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None), "si_family": SimTypeShort(signed=False, label="UInt16")}, name="<anon>", label="None"), "InterfaceLuid": SimUnion({"Value": SimTypeLongLong(signed=False, label="UInt64"), "Info": SimStruct({"_bitfield": SimTypeLongLong(signed=False, label="UInt64")}, name="_Info_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "InterfaceIndex": SimTypeInt(signed=False, label="UInt32"), "CurrentNextHop": SimUnion({"Ipv4": SimStruct({"sin_family": SimTypeShort(signed=False, label="UInt16"), "sin_port": SimTypeShort(signed=False, label="UInt16"), "sin_addr": SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), "sin_zero": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 8)}, name="SOCKADDR_IN", pack=False, align=None), "Ipv6": SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None), "si_family": SimTypeShort(signed=False, label="UInt16")}, name="<anon>", label="None"), "PathMtu": SimTypeInt(signed=False, label="UInt32"), "RttMean": SimTypeInt(signed=False, label="UInt32"), "RttDeviation": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"LastReachable": SimTypeInt(signed=False, label="UInt32"), "LastUnreachable": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None"), "IsReachable": SimTypeChar(label="Byte"), "LinkTransmitSpeed": SimTypeLongLong(signed=False, label="UInt64"), "LinkReceiveSpeed": SimTypeLongLong(signed=False, label="UInt64")}, name="MIB_IPPATH_ROW", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Row"]),
        # 
        'GetIpPathTable': SimTypeFunction([SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypePointer(SimStruct({"NumEntries": SimTypeInt(signed=False, label="UInt32"), "Table": SimTypePointer(SimStruct({"Source": SimUnion({"Ipv4": SimStruct({"sin_family": SimTypeShort(signed=False, label="UInt16"), "sin_port": SimTypeShort(signed=False, label="UInt16"), "sin_addr": SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), "sin_zero": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 8)}, name="SOCKADDR_IN", pack=False, align=None), "Ipv6": SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None), "si_family": SimTypeShort(signed=False, label="UInt16")}, name="<anon>", label="None"), "Destination": SimUnion({"Ipv4": SimStruct({"sin_family": SimTypeShort(signed=False, label="UInt16"), "sin_port": SimTypeShort(signed=False, label="UInt16"), "sin_addr": SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), "sin_zero": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 8)}, name="SOCKADDR_IN", pack=False, align=None), "Ipv6": SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None), "si_family": SimTypeShort(signed=False, label="UInt16")}, name="<anon>", label="None"), "InterfaceLuid": SimUnion({"Value": SimTypeLongLong(signed=False, label="UInt64"), "Info": SimStruct({"_bitfield": SimTypeLongLong(signed=False, label="UInt64")}, name="_Info_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "InterfaceIndex": SimTypeInt(signed=False, label="UInt32"), "CurrentNextHop": SimUnion({"Ipv4": SimStruct({"sin_family": SimTypeShort(signed=False, label="UInt16"), "sin_port": SimTypeShort(signed=False, label="UInt16"), "sin_addr": SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), "sin_zero": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 8)}, name="SOCKADDR_IN", pack=False, align=None), "Ipv6": SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None), "si_family": SimTypeShort(signed=False, label="UInt16")}, name="<anon>", label="None"), "PathMtu": SimTypeInt(signed=False, label="UInt32"), "RttMean": SimTypeInt(signed=False, label="UInt32"), "RttDeviation": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"LastReachable": SimTypeInt(signed=False, label="UInt32"), "LastUnreachable": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None"), "IsReachable": SimTypeChar(label="Byte"), "LinkTransmitSpeed": SimTypeLongLong(signed=False, label="UInt64"), "LinkReceiveSpeed": SimTypeLongLong(signed=False, label="UInt64")}, name="MIB_IPPATH_ROW", pack=False, align=None), offset=0)}, name="MIB_IPPATH_TABLE", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Family", "Table"]),
        # 
        'CreateIpNetEntry2': SimTypeFunction([SimTypePointer(SimStruct({"Address": SimUnion({"Ipv4": SimStruct({"sin_family": SimTypeShort(signed=False, label="UInt16"), "sin_port": SimTypeShort(signed=False, label="UInt16"), "sin_addr": SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), "sin_zero": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 8)}, name="SOCKADDR_IN", pack=False, align=None), "Ipv6": SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None), "si_family": SimTypeShort(signed=False, label="UInt16")}, name="<anon>", label="None"), "InterfaceIndex": SimTypeInt(signed=False, label="UInt32"), "InterfaceLuid": SimUnion({"Value": SimTypeLongLong(signed=False, label="UInt64"), "Info": SimStruct({"_bitfield": SimTypeLongLong(signed=False, label="UInt64")}, name="_Info_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "PhysicalAddress": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32), "PhysicalAddressLength": SimTypeInt(signed=False, label="UInt32"), "State": SimTypeInt(signed=False, label="NL_NEIGHBOR_STATE"), "Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeChar(label="Byte")}, name="_Anonymous_e__Struct", pack=False, align=None), "Flags": SimTypeChar(label="Byte")}, name="<anon>", label="None"), "ReachabilityTime": SimUnion({"LastReachable": SimTypeInt(signed=False, label="UInt32"), "LastUnreachable": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="MIB_IPNET_ROW2", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Row"]),
        # 
        'DeleteIpNetEntry2': SimTypeFunction([SimTypePointer(SimStruct({"Address": SimUnion({"Ipv4": SimStruct({"sin_family": SimTypeShort(signed=False, label="UInt16"), "sin_port": SimTypeShort(signed=False, label="UInt16"), "sin_addr": SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), "sin_zero": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 8)}, name="SOCKADDR_IN", pack=False, align=None), "Ipv6": SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None), "si_family": SimTypeShort(signed=False, label="UInt16")}, name="<anon>", label="None"), "InterfaceIndex": SimTypeInt(signed=False, label="UInt32"), "InterfaceLuid": SimUnion({"Value": SimTypeLongLong(signed=False, label="UInt64"), "Info": SimStruct({"_bitfield": SimTypeLongLong(signed=False, label="UInt64")}, name="_Info_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "PhysicalAddress": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32), "PhysicalAddressLength": SimTypeInt(signed=False, label="UInt32"), "State": SimTypeInt(signed=False, label="NL_NEIGHBOR_STATE"), "Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeChar(label="Byte")}, name="_Anonymous_e__Struct", pack=False, align=None), "Flags": SimTypeChar(label="Byte")}, name="<anon>", label="None"), "ReachabilityTime": SimUnion({"LastReachable": SimTypeInt(signed=False, label="UInt32"), "LastUnreachable": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="MIB_IPNET_ROW2", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Row"]),
        # 
        'FlushIpNetTable2': SimTypeFunction([SimTypeShort(signed=False, label="UInt16"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["Family", "InterfaceIndex"]),
        # 
        'GetIpNetEntry2': SimTypeFunction([SimTypePointer(SimStruct({"Address": SimUnion({"Ipv4": SimStruct({"sin_family": SimTypeShort(signed=False, label="UInt16"), "sin_port": SimTypeShort(signed=False, label="UInt16"), "sin_addr": SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), "sin_zero": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 8)}, name="SOCKADDR_IN", pack=False, align=None), "Ipv6": SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None), "si_family": SimTypeShort(signed=False, label="UInt16")}, name="<anon>", label="None"), "InterfaceIndex": SimTypeInt(signed=False, label="UInt32"), "InterfaceLuid": SimUnion({"Value": SimTypeLongLong(signed=False, label="UInt64"), "Info": SimStruct({"_bitfield": SimTypeLongLong(signed=False, label="UInt64")}, name="_Info_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "PhysicalAddress": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32), "PhysicalAddressLength": SimTypeInt(signed=False, label="UInt32"), "State": SimTypeInt(signed=False, label="NL_NEIGHBOR_STATE"), "Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeChar(label="Byte")}, name="_Anonymous_e__Struct", pack=False, align=None), "Flags": SimTypeChar(label="Byte")}, name="<anon>", label="None"), "ReachabilityTime": SimUnion({"LastReachable": SimTypeInt(signed=False, label="UInt32"), "LastUnreachable": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="MIB_IPNET_ROW2", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Row"]),
        # 
        'GetIpNetTable2': SimTypeFunction([SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypePointer(SimStruct({"NumEntries": SimTypeInt(signed=False, label="UInt32"), "Table": SimTypePointer(SimStruct({"Address": SimUnion({"Ipv4": SimStruct({"sin_family": SimTypeShort(signed=False, label="UInt16"), "sin_port": SimTypeShort(signed=False, label="UInt16"), "sin_addr": SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), "sin_zero": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 8)}, name="SOCKADDR_IN", pack=False, align=None), "Ipv6": SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None), "si_family": SimTypeShort(signed=False, label="UInt16")}, name="<anon>", label="None"), "InterfaceIndex": SimTypeInt(signed=False, label="UInt32"), "InterfaceLuid": SimUnion({"Value": SimTypeLongLong(signed=False, label="UInt64"), "Info": SimStruct({"_bitfield": SimTypeLongLong(signed=False, label="UInt64")}, name="_Info_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "PhysicalAddress": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32), "PhysicalAddressLength": SimTypeInt(signed=False, label="UInt32"), "State": SimTypeInt(signed=False, label="NL_NEIGHBOR_STATE"), "Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeChar(label="Byte")}, name="_Anonymous_e__Struct", pack=False, align=None), "Flags": SimTypeChar(label="Byte")}, name="<anon>", label="None"), "ReachabilityTime": SimUnion({"LastReachable": SimTypeInt(signed=False, label="UInt32"), "LastUnreachable": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="MIB_IPNET_ROW2", pack=False, align=None), offset=0)}, name="MIB_IPNET_TABLE2", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Family", "Table"]),
        # 
        'ResolveIpNetEntry2': SimTypeFunction([SimTypePointer(SimStruct({"Address": SimUnion({"Ipv4": SimStruct({"sin_family": SimTypeShort(signed=False, label="UInt16"), "sin_port": SimTypeShort(signed=False, label="UInt16"), "sin_addr": SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), "sin_zero": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 8)}, name="SOCKADDR_IN", pack=False, align=None), "Ipv6": SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None), "si_family": SimTypeShort(signed=False, label="UInt16")}, name="<anon>", label="None"), "InterfaceIndex": SimTypeInt(signed=False, label="UInt32"), "InterfaceLuid": SimUnion({"Value": SimTypeLongLong(signed=False, label="UInt64"), "Info": SimStruct({"_bitfield": SimTypeLongLong(signed=False, label="UInt64")}, name="_Info_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "PhysicalAddress": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32), "PhysicalAddressLength": SimTypeInt(signed=False, label="UInt32"), "State": SimTypeInt(signed=False, label="NL_NEIGHBOR_STATE"), "Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeChar(label="Byte")}, name="_Anonymous_e__Struct", pack=False, align=None), "Flags": SimTypeChar(label="Byte")}, name="<anon>", label="None"), "ReachabilityTime": SimUnion({"LastReachable": SimTypeInt(signed=False, label="UInt32"), "LastUnreachable": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="MIB_IPNET_ROW2", pack=False, align=None), offset=0), SimTypePointer(SimUnion({"Ipv4": SimStruct({"sin_family": SimTypeShort(signed=False, label="UInt16"), "sin_port": SimTypeShort(signed=False, label="UInt16"), "sin_addr": SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), "sin_zero": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 8)}, name="SOCKADDR_IN", pack=False, align=None), "Ipv6": SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None), "si_family": SimTypeShort(signed=False, label="UInt16")}, name="<anon>", label="None"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Row", "SourceAddress"]),
        # 
        'SetIpNetEntry2': SimTypeFunction([SimTypePointer(SimStruct({"Address": SimUnion({"Ipv4": SimStruct({"sin_family": SimTypeShort(signed=False, label="UInt16"), "sin_port": SimTypeShort(signed=False, label="UInt16"), "sin_addr": SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), "sin_zero": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 8)}, name="SOCKADDR_IN", pack=False, align=None), "Ipv6": SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None), "si_family": SimTypeShort(signed=False, label="UInt16")}, name="<anon>", label="None"), "InterfaceIndex": SimTypeInt(signed=False, label="UInt32"), "InterfaceLuid": SimUnion({"Value": SimTypeLongLong(signed=False, label="UInt64"), "Info": SimStruct({"_bitfield": SimTypeLongLong(signed=False, label="UInt64")}, name="_Info_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "PhysicalAddress": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32), "PhysicalAddressLength": SimTypeInt(signed=False, label="UInt32"), "State": SimTypeInt(signed=False, label="NL_NEIGHBOR_STATE"), "Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeChar(label="Byte")}, name="_Anonymous_e__Struct", pack=False, align=None), "Flags": SimTypeChar(label="Byte")}, name="<anon>", label="None"), "ReachabilityTime": SimUnion({"LastReachable": SimTypeInt(signed=False, label="UInt32"), "LastUnreachable": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="MIB_IPNET_ROW2", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Row"]),
        # 
        'NotifyTeredoPortChange': SimTypeFunction([SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypeInt(signed=False, label="MIB_NOTIFICATION_TYPE")], SimTypeBottom(label="Void"), arg_names=["CallerContext", "Port", "NotificationType"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeChar(label="Byte"), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Callback", "CallerContext", "InitialNotification", "NotificationHandle"]),
        # 
        'GetTeredoPort': SimTypeFunction([SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Port"]),
        # 
        'CancelMibChangeNotify2': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["NotificationHandle"]),
        # 
        'FreeMibTable': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["Memory"]),
        # 
        'CreateSortedAddressPairs': SimTypeFunction([SimTypePointer(SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"SourceAddress": SimTypePointer(SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None), offset=0), "DestinationAddress": SimTypePointer(SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None), offset=0)}, name="SOCKADDR_IN6_PAIR", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["SourceAddressList", "SourceAddressCount", "DestinationAddressList", "DestinationAddressCount", "AddressSortOptions", "SortedAddressPairList", "SortedAddressPairCount"]),
        # 
        'ConvertCompartmentGuidToId': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["CompartmentGuid", "CompartmentId"]),
        # 
        'ConvertCompartmentIdToGuid': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Guid"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["CompartmentId", "CompartmentGuid"]),
        # 
        'ConvertInterfaceNameToLuidA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimUnion({"Value": SimTypeLongLong(signed=False, label="UInt64"), "Info": SimStruct({"_bitfield": SimTypeLongLong(signed=False, label="UInt64")}, name="_Info_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["InterfaceName", "InterfaceLuid"]),
        # 
        'ConvertInterfaceNameToLuidW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimUnion({"Value": SimTypeLongLong(signed=False, label="UInt64"), "Info": SimStruct({"_bitfield": SimTypeLongLong(signed=False, label="UInt64")}, name="_Info_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["InterfaceName", "InterfaceLuid"]),
        # 
        'ConvertInterfaceLuidToNameA': SimTypeFunction([SimTypePointer(SimUnion({"Value": SimTypeLongLong(signed=False, label="UInt64"), "Info": SimStruct({"_bitfield": SimTypeLongLong(signed=False, label="UInt64")}, name="_Info_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["InterfaceLuid", "InterfaceName", "Length"]),
        # 
        'ConvertInterfaceLuidToNameW': SimTypeFunction([SimTypePointer(SimUnion({"Value": SimTypeLongLong(signed=False, label="UInt64"), "Info": SimStruct({"_bitfield": SimTypeLongLong(signed=False, label="UInt64")}, name="_Info_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["InterfaceLuid", "InterfaceName", "Length"]),
        # 
        'ConvertInterfaceLuidToIndex': SimTypeFunction([SimTypePointer(SimUnion({"Value": SimTypeLongLong(signed=False, label="UInt64"), "Info": SimStruct({"_bitfield": SimTypeLongLong(signed=False, label="UInt64")}, name="_Info_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["InterfaceLuid", "InterfaceIndex"]),
        # 
        'ConvertInterfaceIndexToLuid': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimUnion({"Value": SimTypeLongLong(signed=False, label="UInt64"), "Info": SimStruct({"_bitfield": SimTypeLongLong(signed=False, label="UInt64")}, name="_Info_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["InterfaceIndex", "InterfaceLuid"]),
        # 
        'ConvertInterfaceLuidToAlias': SimTypeFunction([SimTypePointer(SimUnion({"Value": SimTypeLongLong(signed=False, label="UInt64"), "Info": SimStruct({"_bitfield": SimTypeLongLong(signed=False, label="UInt64")}, name="_Info_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["InterfaceLuid", "InterfaceAlias", "Length"]),
        # 
        'ConvertInterfaceAliasToLuid': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimUnion({"Value": SimTypeLongLong(signed=False, label="UInt64"), "Info": SimStruct({"_bitfield": SimTypeLongLong(signed=False, label="UInt64")}, name="_Info_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["InterfaceAlias", "InterfaceLuid"]),
        # 
        'ConvertInterfaceLuidToGuid': SimTypeFunction([SimTypePointer(SimUnion({"Value": SimTypeLongLong(signed=False, label="UInt64"), "Info": SimStruct({"_bitfield": SimTypeLongLong(signed=False, label="UInt64")}, name="_Info_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["InterfaceLuid", "InterfaceGuid"]),
        # 
        'ConvertInterfaceGuidToLuid': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimUnion({"Value": SimTypeLongLong(signed=False, label="UInt64"), "Info": SimStruct({"_bitfield": SimTypeLongLong(signed=False, label="UInt64")}, name="_Info_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["InterfaceGuid", "InterfaceLuid"]),
        # 
        'if_nametoindex': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["InterfaceName"]),
        # 
        'if_indextoname': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0)], SimTypePointer(SimTypeChar(label="Byte"), offset=0), arg_names=["InterfaceIndex", "InterfaceName"]),
        # 
        'GetCurrentThreadCompartmentId': SimTypeFunction([], SimTypeInt(signed=False, label="UInt32")),
        # 
        'SetCurrentThreadCompartmentId': SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["CompartmentId"]),
        # 
        'GetCurrentThreadCompartmentScope': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeBottom(label="Void"), arg_names=["CompartmentScope", "CompartmentId"]),
        # 
        'SetCurrentThreadCompartmentScope': SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["CompartmentScope"]),
        # 
        'GetJobCompartmentId': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["JobHandle"]),
        # 
        'SetJobCompartmentId': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["JobHandle", "CompartmentId"]),
        # 
        'GetSessionCompartmentId': SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["SessionId"]),
        # 
        'SetSessionCompartmentId': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["SessionId", "CompartmentId"]),
        # 
        'GetDefaultCompartmentId': SimTypeFunction([], SimTypeInt(signed=False, label="UInt32")),
        # 
        'GetNetworkInformation': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["NetworkGuid", "CompartmentId", "SiteId", "NetworkName", "Length"]),
        # 
        'SetNetworkInformation': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["NetworkGuid", "CompartmentId", "NetworkName"]),
        # 
        'ConvertLengthToIpv4Mask': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["MaskLength", "Mask"]),
        # 
        'ConvertIpv4MaskToLength': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Mask", "MaskLength"]),
        # 
        'GetDnsSettings': SimTypeFunction([SimTypePointer(SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeLongLong(signed=False, label="UInt64"), "Hostname": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Domain": SimTypePointer(SimTypeChar(label="Char"), offset=0), "SearchList": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="DNS_SETTINGS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Settings"]),
        # 
        'FreeDnsSettings': SimTypeFunction([SimTypePointer(SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeLongLong(signed=False, label="UInt64"), "Hostname": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Domain": SimTypePointer(SimTypeChar(label="Char"), offset=0), "SearchList": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="DNS_SETTINGS", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["Settings"]),
        # 
        'SetDnsSettings': SimTypeFunction([SimTypePointer(SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeLongLong(signed=False, label="UInt64"), "Hostname": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Domain": SimTypePointer(SimTypeChar(label="Char"), offset=0), "SearchList": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="DNS_SETTINGS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Settings"]),
        # 
        'GetInterfaceDnsSettings': SimTypeFunction([SimTypeBottom(label="Guid"), SimTypePointer(SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeLongLong(signed=False, label="UInt64"), "Domain": SimTypePointer(SimTypeChar(label="Char"), offset=0), "NameServer": SimTypePointer(SimTypeChar(label="Char"), offset=0), "SearchList": SimTypePointer(SimTypeChar(label="Char"), offset=0), "RegistrationEnabled": SimTypeInt(signed=False, label="UInt32"), "RegisterAdapterName": SimTypeInt(signed=False, label="UInt32"), "EnableLLMNR": SimTypeInt(signed=False, label="UInt32"), "QueryAdapterName": SimTypeInt(signed=False, label="UInt32"), "ProfileNameServer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="DNS_INTERFACE_SETTINGS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Interface", "Settings"]),
        # 
        'FreeInterfaceDnsSettings': SimTypeFunction([SimTypePointer(SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeLongLong(signed=False, label="UInt64"), "Domain": SimTypePointer(SimTypeChar(label="Char"), offset=0), "NameServer": SimTypePointer(SimTypeChar(label="Char"), offset=0), "SearchList": SimTypePointer(SimTypeChar(label="Char"), offset=0), "RegistrationEnabled": SimTypeInt(signed=False, label="UInt32"), "RegisterAdapterName": SimTypeInt(signed=False, label="UInt32"), "EnableLLMNR": SimTypeInt(signed=False, label="UInt32"), "QueryAdapterName": SimTypeInt(signed=False, label="UInt32"), "ProfileNameServer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="DNS_INTERFACE_SETTINGS", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["Settings"]),
        # 
        'SetInterfaceDnsSettings': SimTypeFunction([SimTypeBottom(label="Guid"), SimTypePointer(SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeLongLong(signed=False, label="UInt64"), "Domain": SimTypePointer(SimTypeChar(label="Char"), offset=0), "NameServer": SimTypePointer(SimTypeChar(label="Char"), offset=0), "SearchList": SimTypePointer(SimTypeChar(label="Char"), offset=0), "RegistrationEnabled": SimTypeInt(signed=False, label="UInt32"), "RegisterAdapterName": SimTypeInt(signed=False, label="UInt32"), "EnableLLMNR": SimTypeInt(signed=False, label="UInt32"), "QueryAdapterName": SimTypeInt(signed=False, label="UInt32"), "ProfileNameServer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="DNS_INTERFACE_SETTINGS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Interface", "Settings"]),
        # 
        'GetNetworkConnectivityHint': SimTypeFunction([SimTypePointer(SimStruct({"ConnectivityLevel": SimTypeInt(signed=False, label="NL_NETWORK_CONNECTIVITY_LEVEL_HINT"), "ConnectivityCost": SimTypeInt(signed=False, label="NL_NETWORK_CONNECTIVITY_COST_HINT"), "ApproachingDataLimit": SimTypeChar(label="Byte"), "OverDataLimit": SimTypeChar(label="Byte"), "Roaming": SimTypeChar(label="Byte")}, name="NL_NETWORK_CONNECTIVITY_HINT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ConnectivityHint"]),
        # 
        'GetNetworkConnectivityHintForInterface': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"ConnectivityLevel": SimTypeInt(signed=False, label="NL_NETWORK_CONNECTIVITY_LEVEL_HINT"), "ConnectivityCost": SimTypeInt(signed=False, label="NL_NETWORK_CONNECTIVITY_COST_HINT"), "ApproachingDataLimit": SimTypeChar(label="Byte"), "OverDataLimit": SimTypeChar(label="Byte"), "Roaming": SimTypeChar(label="Byte")}, name="NL_NETWORK_CONNECTIVITY_HINT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["InterfaceIndex", "ConnectivityHint"]),
        # 
        'NotifyNetworkConnectivityHintChange': SimTypeFunction([SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimStruct({"ConnectivityLevel": SimTypeInt(signed=False, label="NL_NETWORK_CONNECTIVITY_LEVEL_HINT"), "ConnectivityCost": SimTypeInt(signed=False, label="NL_NETWORK_CONNECTIVITY_COST_HINT"), "ApproachingDataLimit": SimTypeChar(label="Byte"), "OverDataLimit": SimTypeChar(label="Byte"), "Roaming": SimTypeChar(label="Byte")}, name="NL_NETWORK_CONNECTIVITY_HINT", pack=False, align=None)], SimTypeBottom(label="Void"), arg_names=["CallerContext", "ConnectivityHint"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeChar(label="Byte"), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Callback", "CallerContext", "InitialNotification", "NotificationHandle"]),
        # 
        'IcmpCreateFile': SimTypeFunction([], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)),
        # 
        'Icmp6CreateFile': SimTypeFunction([], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)),
        # 
        'IcmpCloseHandle': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["IcmpHandle"]),
        # 
        'IcmpSendEcho': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimStruct({"Ttl": SimTypeChar(label="Byte"), "Tos": SimTypeChar(label="Byte"), "Flags": SimTypeChar(label="Byte"), "OptionsSize": SimTypeChar(label="Byte"), "OptionsData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="ip_option_information", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["IcmpHandle", "DestinationAddress", "RequestData", "RequestSize", "RequestOptions", "ReplyBuffer", "ReplySize", "Timeout"]),
        # 
        'IcmpSendEcho2': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"Anonymous": SimUnion({"Status": SimTypeInt(signed=True, label="Int32"), "Pointer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None"), "Information": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="IO_STATUS_BLOCK", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeBottom(label="Void"), arg_names=["ApcContext", "IoStatusBlock", "Reserved"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimStruct({"Ttl": SimTypeChar(label="Byte"), "Tos": SimTypeChar(label="Byte"), "Flags": SimTypeChar(label="Byte"), "OptionsSize": SimTypeChar(label="Byte"), "OptionsData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="ip_option_information", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["IcmpHandle", "Event", "ApcRoutine", "ApcContext", "DestinationAddress", "RequestData", "RequestSize", "RequestOptions", "ReplyBuffer", "ReplySize", "Timeout"]),
        # 
        'IcmpSendEcho2Ex': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"Anonymous": SimUnion({"Status": SimTypeInt(signed=True, label="Int32"), "Pointer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None"), "Information": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="IO_STATUS_BLOCK", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeBottom(label="Void"), arg_names=["ApcContext", "IoStatusBlock", "Reserved"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimStruct({"Ttl": SimTypeChar(label="Byte"), "Tos": SimTypeChar(label="Byte"), "Flags": SimTypeChar(label="Byte"), "OptionsSize": SimTypeChar(label="Byte"), "OptionsData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="ip_option_information", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["IcmpHandle", "Event", "ApcRoutine", "ApcContext", "SourceAddress", "DestinationAddress", "RequestData", "RequestSize", "RequestOptions", "ReplyBuffer", "ReplySize", "Timeout"]),
        # 
        'Icmp6SendEcho2': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"Anonymous": SimUnion({"Status": SimTypeInt(signed=True, label="Int32"), "Pointer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None"), "Information": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="IO_STATUS_BLOCK", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeBottom(label="Void"), arg_names=["ApcContext", "IoStatusBlock", "Reserved"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimStruct({"Ttl": SimTypeChar(label="Byte"), "Tos": SimTypeChar(label="Byte"), "Flags": SimTypeChar(label="Byte"), "OptionsSize": SimTypeChar(label="Byte"), "OptionsData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="ip_option_information", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["IcmpHandle", "Event", "ApcRoutine", "ApcContext", "SourceAddress", "DestinationAddress", "RequestData", "RequestSize", "RequestOptions", "ReplyBuffer", "ReplySize", "Timeout"]),
        # 
        'IcmpParseReplies': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["ReplyBuffer", "ReplySize"]),
        # 
        'Icmp6ParseReplies': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["ReplyBuffer", "ReplySize"]),
        # 
        'GetNumberOfInterfaces': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pdwNumIf"]),
        # 
        'GetIfEntry': SimTypeFunction([SimTypePointer(SimStruct({"wszName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 256), "dwIndex": SimTypeInt(signed=False, label="UInt32"), "dwType": SimTypeInt(signed=False, label="UInt32"), "dwMtu": SimTypeInt(signed=False, label="UInt32"), "dwSpeed": SimTypeInt(signed=False, label="UInt32"), "dwPhysAddrLen": SimTypeInt(signed=False, label="UInt32"), "bPhysAddr": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 8), "dwAdminStatus": SimTypeInt(signed=False, label="UInt32"), "dwOperStatus": SimTypeInt(signed=False, label="INTERNAL_IF_OPER_STATUS"), "dwLastChange": SimTypeInt(signed=False, label="UInt32"), "dwInOctets": SimTypeInt(signed=False, label="UInt32"), "dwInUcastPkts": SimTypeInt(signed=False, label="UInt32"), "dwInNUcastPkts": SimTypeInt(signed=False, label="UInt32"), "dwInDiscards": SimTypeInt(signed=False, label="UInt32"), "dwInErrors": SimTypeInt(signed=False, label="UInt32"), "dwInUnknownProtos": SimTypeInt(signed=False, label="UInt32"), "dwOutOctets": SimTypeInt(signed=False, label="UInt32"), "dwOutUcastPkts": SimTypeInt(signed=False, label="UInt32"), "dwOutNUcastPkts": SimTypeInt(signed=False, label="UInt32"), "dwOutDiscards": SimTypeInt(signed=False, label="UInt32"), "dwOutErrors": SimTypeInt(signed=False, label="UInt32"), "dwOutQLen": SimTypeInt(signed=False, label="UInt32"), "dwDescrLen": SimTypeInt(signed=False, label="UInt32"), "bDescr": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 256)}, name="MIB_IFROW", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pIfRow"]),
        # 
        'GetIfTable': SimTypeFunction([SimTypePointer(SimStruct({"dwNumEntries": SimTypeInt(signed=False, label="UInt32"), "table": SimTypePointer(SimStruct({"wszName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 256), "dwIndex": SimTypeInt(signed=False, label="UInt32"), "dwType": SimTypeInt(signed=False, label="UInt32"), "dwMtu": SimTypeInt(signed=False, label="UInt32"), "dwSpeed": SimTypeInt(signed=False, label="UInt32"), "dwPhysAddrLen": SimTypeInt(signed=False, label="UInt32"), "bPhysAddr": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 8), "dwAdminStatus": SimTypeInt(signed=False, label="UInt32"), "dwOperStatus": SimTypeInt(signed=False, label="INTERNAL_IF_OPER_STATUS"), "dwLastChange": SimTypeInt(signed=False, label="UInt32"), "dwInOctets": SimTypeInt(signed=False, label="UInt32"), "dwInUcastPkts": SimTypeInt(signed=False, label="UInt32"), "dwInNUcastPkts": SimTypeInt(signed=False, label="UInt32"), "dwInDiscards": SimTypeInt(signed=False, label="UInt32"), "dwInErrors": SimTypeInt(signed=False, label="UInt32"), "dwInUnknownProtos": SimTypeInt(signed=False, label="UInt32"), "dwOutOctets": SimTypeInt(signed=False, label="UInt32"), "dwOutUcastPkts": SimTypeInt(signed=False, label="UInt32"), "dwOutNUcastPkts": SimTypeInt(signed=False, label="UInt32"), "dwOutDiscards": SimTypeInt(signed=False, label="UInt32"), "dwOutErrors": SimTypeInt(signed=False, label="UInt32"), "dwOutQLen": SimTypeInt(signed=False, label="UInt32"), "dwDescrLen": SimTypeInt(signed=False, label="UInt32"), "bDescr": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 256)}, name="MIB_IFROW", pack=False, align=None), offset=0)}, name="MIB_IFTABLE", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["pIfTable", "pdwSize", "bOrder"]),
        # 
        'GetIpAddrTable': SimTypeFunction([SimTypePointer(SimStruct({"dwNumEntries": SimTypeInt(signed=False, label="UInt32"), "table": SimTypePointer(SimStruct({"dwAddr": SimTypeInt(signed=False, label="UInt32"), "dwIndex": SimTypeInt(signed=False, label="UInt32"), "dwMask": SimTypeInt(signed=False, label="UInt32"), "dwBCastAddr": SimTypeInt(signed=False, label="UInt32"), "dwReasmSize": SimTypeInt(signed=False, label="UInt32"), "unused1": SimTypeShort(signed=False, label="UInt16"), "wType": SimTypeShort(signed=False, label="UInt16")}, name="MIB_IPADDRROW_XP", pack=False, align=None), offset=0)}, name="MIB_IPADDRTABLE", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["pIpAddrTable", "pdwSize", "bOrder"]),
        # 
        'GetIpNetTable': SimTypeFunction([SimTypePointer(SimStruct({"dwNumEntries": SimTypeInt(signed=False, label="UInt32"), "table": SimTypePointer(SimStruct({"dwIndex": SimTypeInt(signed=False, label="UInt32"), "dwPhysAddrLen": SimTypeInt(signed=False, label="UInt32"), "bPhysAddr": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 8), "dwAddr": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"dwType": SimTypeInt(signed=False, label="UInt32"), "Type": SimTypeInt(signed=False, label="MIB_IPNET_TYPE")}, name="<anon>", label="None")}, name="MIB_IPNETROW_LH", pack=False, align=None), offset=0)}, name="MIB_IPNETTABLE", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["IpNetTable", "SizePointer", "Order"]),
        # 
        'GetIpForwardTable': SimTypeFunction([SimTypePointer(SimStruct({"dwNumEntries": SimTypeInt(signed=False, label="UInt32"), "table": SimTypePointer(SimStruct({"dwForwardDest": SimTypeInt(signed=False, label="UInt32"), "dwForwardMask": SimTypeInt(signed=False, label="UInt32"), "dwForwardPolicy": SimTypeInt(signed=False, label="UInt32"), "dwForwardNextHop": SimTypeInt(signed=False, label="UInt32"), "dwForwardIfIndex": SimTypeInt(signed=False, label="UInt32"), "Anonymous1": SimUnion({"dwForwardType": SimTypeInt(signed=False, label="UInt32"), "ForwardType": SimTypeInt(signed=False, label="MIB_IPFORWARD_TYPE")}, name="<anon>", label="None"), "Anonymous2": SimUnion({"dwForwardProto": SimTypeInt(signed=False, label="UInt32"), "ForwardProto": SimTypeInt(signed=False, label="NL_ROUTE_PROTOCOL")}, name="<anon>", label="None"), "dwForwardAge": SimTypeInt(signed=False, label="UInt32"), "dwForwardNextHopAS": SimTypeInt(signed=False, label="UInt32"), "dwForwardMetric1": SimTypeInt(signed=False, label="UInt32"), "dwForwardMetric2": SimTypeInt(signed=False, label="UInt32"), "dwForwardMetric3": SimTypeInt(signed=False, label="UInt32"), "dwForwardMetric4": SimTypeInt(signed=False, label="UInt32"), "dwForwardMetric5": SimTypeInt(signed=False, label="UInt32")}, name="MIB_IPFORWARDROW", pack=False, align=None), offset=0)}, name="MIB_IPFORWARDTABLE", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["pIpForwardTable", "pdwSize", "bOrder"]),
        # 
        'GetTcpTable': SimTypeFunction([SimTypePointer(SimStruct({"dwNumEntries": SimTypeInt(signed=False, label="UInt32"), "table": SimTypePointer(SimStruct({"Anonymous": SimUnion({"dwState": SimTypeInt(signed=False, label="UInt32"), "State": SimTypeInt(signed=False, label="MIB_TCP_STATE")}, name="<anon>", label="None"), "dwLocalAddr": SimTypeInt(signed=False, label="UInt32"), "dwLocalPort": SimTypeInt(signed=False, label="UInt32"), "dwRemoteAddr": SimTypeInt(signed=False, label="UInt32"), "dwRemotePort": SimTypeInt(signed=False, label="UInt32")}, name="MIB_TCPROW_LH", pack=False, align=None), offset=0)}, name="MIB_TCPTABLE", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["TcpTable", "SizePointer", "Order"]),
        # 
        'GetExtendedTcpTable': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="TCP_TABLE_CLASS"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["pTcpTable", "pdwSize", "bOrder", "ulAf", "TableClass", "Reserved"]),
        # 
        'GetOwnerModuleFromTcpEntry': SimTypeFunction([SimTypePointer(SimStruct({"dwState": SimTypeInt(signed=False, label="UInt32"), "dwLocalAddr": SimTypeInt(signed=False, label="UInt32"), "dwLocalPort": SimTypeInt(signed=False, label="UInt32"), "dwRemoteAddr": SimTypeInt(signed=False, label="UInt32"), "dwRemotePort": SimTypeInt(signed=False, label="UInt32"), "dwOwningPid": SimTypeInt(signed=False, label="UInt32"), "liCreateTimestamp": SimTypeBottom(label="LARGE_INTEGER"), "OwningModuleInfo": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 16)}, name="MIB_TCPROW_OWNER_MODULE", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="TCPIP_OWNER_MODULE_INFO_CLASS"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pTcpEntry", "Class", "pBuffer", "pdwSize"]),
        # 
        'GetUdpTable': SimTypeFunction([SimTypePointer(SimStruct({"dwNumEntries": SimTypeInt(signed=False, label="UInt32"), "table": SimTypePointer(SimStruct({"dwLocalAddr": SimTypeInt(signed=False, label="UInt32"), "dwLocalPort": SimTypeInt(signed=False, label="UInt32")}, name="MIB_UDPROW", pack=False, align=None), offset=0)}, name="MIB_UDPTABLE", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["UdpTable", "SizePointer", "Order"]),
        # 
        'GetExtendedUdpTable': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UDP_TABLE_CLASS"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["pUdpTable", "pdwSize", "bOrder", "ulAf", "TableClass", "Reserved"]),
        # 
        'GetOwnerModuleFromUdpEntry': SimTypeFunction([SimTypePointer(SimStruct({"dwLocalAddr": SimTypeInt(signed=False, label="UInt32"), "dwLocalPort": SimTypeInt(signed=False, label="UInt32"), "dwOwningPid": SimTypeInt(signed=False, label="UInt32"), "liCreateTimestamp": SimTypeBottom(label="LARGE_INTEGER"), "Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=True, label="Int32")}, name="_Anonymous_e__Struct", pack=False, align=None), "dwFlags": SimTypeInt(signed=True, label="Int32")}, name="<anon>", label="None"), "OwningModuleInfo": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 16)}, name="MIB_UDPROW_OWNER_MODULE", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="TCPIP_OWNER_MODULE_INFO_CLASS"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pUdpEntry", "Class", "pBuffer", "pdwSize"]),
        # 
        'GetTcpTable2': SimTypeFunction([SimTypePointer(SimStruct({"dwNumEntries": SimTypeInt(signed=False, label="UInt32"), "table": SimTypePointer(SimStruct({"dwState": SimTypeInt(signed=False, label="UInt32"), "dwLocalAddr": SimTypeInt(signed=False, label="UInt32"), "dwLocalPort": SimTypeInt(signed=False, label="UInt32"), "dwRemoteAddr": SimTypeInt(signed=False, label="UInt32"), "dwRemotePort": SimTypeInt(signed=False, label="UInt32"), "dwOwningPid": SimTypeInt(signed=False, label="UInt32"), "dwOffloadState": SimTypeInt(signed=False, label="TCP_CONNECTION_OFFLOAD_STATE")}, name="MIB_TCPROW2", pack=False, align=None), offset=0)}, name="MIB_TCPTABLE2", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["TcpTable", "SizePointer", "Order"]),
        # 
        'GetTcp6Table': SimTypeFunction([SimTypePointer(SimStruct({"dwNumEntries": SimTypeInt(signed=False, label="UInt32"), "table": SimTypePointer(SimStruct({"State": SimTypeInt(signed=False, label="MIB_TCP_STATE"), "LocalAddr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "dwLocalScopeId": SimTypeInt(signed=False, label="UInt32"), "dwLocalPort": SimTypeInt(signed=False, label="UInt32"), "RemoteAddr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "dwRemoteScopeId": SimTypeInt(signed=False, label="UInt32"), "dwRemotePort": SimTypeInt(signed=False, label="UInt32")}, name="MIB_TCP6ROW", pack=False, align=None), offset=0)}, name="MIB_TCP6TABLE", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["TcpTable", "SizePointer", "Order"]),
        # 
        'GetTcp6Table2': SimTypeFunction([SimTypePointer(SimStruct({"dwNumEntries": SimTypeInt(signed=False, label="UInt32"), "table": SimTypePointer(SimStruct({"LocalAddr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "dwLocalScopeId": SimTypeInt(signed=False, label="UInt32"), "dwLocalPort": SimTypeInt(signed=False, label="UInt32"), "RemoteAddr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "dwRemoteScopeId": SimTypeInt(signed=False, label="UInt32"), "dwRemotePort": SimTypeInt(signed=False, label="UInt32"), "State": SimTypeInt(signed=False, label="MIB_TCP_STATE"), "dwOwningPid": SimTypeInt(signed=False, label="UInt32"), "dwOffloadState": SimTypeInt(signed=False, label="TCP_CONNECTION_OFFLOAD_STATE")}, name="MIB_TCP6ROW2", pack=False, align=None), offset=0)}, name="MIB_TCP6TABLE2", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["TcpTable", "SizePointer", "Order"]),
        # 
        'GetPerTcpConnectionEStats': SimTypeFunction([SimTypePointer(SimStruct({"Anonymous": SimUnion({"dwState": SimTypeInt(signed=False, label="UInt32"), "State": SimTypeInt(signed=False, label="MIB_TCP_STATE")}, name="<anon>", label="None"), "dwLocalAddr": SimTypeInt(signed=False, label="UInt32"), "dwLocalPort": SimTypeInt(signed=False, label="UInt32"), "dwRemoteAddr": SimTypeInt(signed=False, label="UInt32"), "dwRemotePort": SimTypeInt(signed=False, label="UInt32")}, name="MIB_TCPROW_LH", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="TCP_ESTATS_TYPE"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["Row", "EstatsType", "Rw", "RwVersion", "RwSize", "Ros", "RosVersion", "RosSize", "Rod", "RodVersion", "RodSize"]),
        # 
        'SetPerTcpConnectionEStats': SimTypeFunction([SimTypePointer(SimStruct({"Anonymous": SimUnion({"dwState": SimTypeInt(signed=False, label="UInt32"), "State": SimTypeInt(signed=False, label="MIB_TCP_STATE")}, name="<anon>", label="None"), "dwLocalAddr": SimTypeInt(signed=False, label="UInt32"), "dwLocalPort": SimTypeInt(signed=False, label="UInt32"), "dwRemoteAddr": SimTypeInt(signed=False, label="UInt32"), "dwRemotePort": SimTypeInt(signed=False, label="UInt32")}, name="MIB_TCPROW_LH", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="TCP_ESTATS_TYPE"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["Row", "EstatsType", "Rw", "RwVersion", "RwSize", "Offset"]),
        # 
        'GetPerTcp6ConnectionEStats': SimTypeFunction([SimTypePointer(SimStruct({"State": SimTypeInt(signed=False, label="MIB_TCP_STATE"), "LocalAddr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "dwLocalScopeId": SimTypeInt(signed=False, label="UInt32"), "dwLocalPort": SimTypeInt(signed=False, label="UInt32"), "RemoteAddr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "dwRemoteScopeId": SimTypeInt(signed=False, label="UInt32"), "dwRemotePort": SimTypeInt(signed=False, label="UInt32")}, name="MIB_TCP6ROW", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="TCP_ESTATS_TYPE"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["Row", "EstatsType", "Rw", "RwVersion", "RwSize", "Ros", "RosVersion", "RosSize", "Rod", "RodVersion", "RodSize"]),
        # 
        'SetPerTcp6ConnectionEStats': SimTypeFunction([SimTypePointer(SimStruct({"State": SimTypeInt(signed=False, label="MIB_TCP_STATE"), "LocalAddr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "dwLocalScopeId": SimTypeInt(signed=False, label="UInt32"), "dwLocalPort": SimTypeInt(signed=False, label="UInt32"), "RemoteAddr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "dwRemoteScopeId": SimTypeInt(signed=False, label="UInt32"), "dwRemotePort": SimTypeInt(signed=False, label="UInt32")}, name="MIB_TCP6ROW", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="TCP_ESTATS_TYPE"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["Row", "EstatsType", "Rw", "RwVersion", "RwSize", "Offset"]),
        # 
        'GetOwnerModuleFromTcp6Entry': SimTypeFunction([SimTypePointer(SimStruct({"ucLocalAddr": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "dwLocalScopeId": SimTypeInt(signed=False, label="UInt32"), "dwLocalPort": SimTypeInt(signed=False, label="UInt32"), "ucRemoteAddr": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "dwRemoteScopeId": SimTypeInt(signed=False, label="UInt32"), "dwRemotePort": SimTypeInt(signed=False, label="UInt32"), "dwState": SimTypeInt(signed=False, label="UInt32"), "dwOwningPid": SimTypeInt(signed=False, label="UInt32"), "liCreateTimestamp": SimTypeBottom(label="LARGE_INTEGER"), "OwningModuleInfo": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 16)}, name="MIB_TCP6ROW_OWNER_MODULE", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="TCPIP_OWNER_MODULE_INFO_CLASS"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pTcpEntry", "Class", "pBuffer", "pdwSize"]),
        # 
        'GetUdp6Table': SimTypeFunction([SimTypePointer(SimStruct({"dwNumEntries": SimTypeInt(signed=False, label="UInt32"), "table": SimTypePointer(SimStruct({"dwLocalAddr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "dwLocalScopeId": SimTypeInt(signed=False, label="UInt32"), "dwLocalPort": SimTypeInt(signed=False, label="UInt32")}, name="MIB_UDP6ROW", pack=False, align=None), offset=0)}, name="MIB_UDP6TABLE", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["Udp6Table", "SizePointer", "Order"]),
        # 
        'GetOwnerModuleFromUdp6Entry': SimTypeFunction([SimTypePointer(SimStruct({"ucLocalAddr": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "dwLocalScopeId": SimTypeInt(signed=False, label="UInt32"), "dwLocalPort": SimTypeInt(signed=False, label="UInt32"), "dwOwningPid": SimTypeInt(signed=False, label="UInt32"), "liCreateTimestamp": SimTypeBottom(label="LARGE_INTEGER"), "Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=True, label="Int32")}, name="_Anonymous_e__Struct", pack=False, align=None), "dwFlags": SimTypeInt(signed=True, label="Int32")}, name="<anon>", label="None"), "OwningModuleInfo": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 16)}, name="MIB_UDP6ROW_OWNER_MODULE", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="TCPIP_OWNER_MODULE_INFO_CLASS"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pUdpEntry", "Class", "pBuffer", "pdwSize"]),
        # 
        'GetOwnerModuleFromPidAndInfo': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0), SimTypeInt(signed=False, label="TCPIP_OWNER_MODULE_INFO_CLASS"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ulPid", "pInfo", "Class", "pBuffer", "pdwSize"]),
        # 
        'GetIpStatistics': SimTypeFunction([SimTypePointer(SimStruct({"Anonymous": SimUnion({"dwForwarding": SimTypeInt(signed=False, label="UInt32"), "Forwarding": SimTypeInt(signed=False, label="MIB_IPSTATS_FORWARDING")}, name="<anon>", label="None"), "dwDefaultTTL": SimTypeInt(signed=False, label="UInt32"), "dwInReceives": SimTypeInt(signed=False, label="UInt32"), "dwInHdrErrors": SimTypeInt(signed=False, label="UInt32"), "dwInAddrErrors": SimTypeInt(signed=False, label="UInt32"), "dwForwDatagrams": SimTypeInt(signed=False, label="UInt32"), "dwInUnknownProtos": SimTypeInt(signed=False, label="UInt32"), "dwInDiscards": SimTypeInt(signed=False, label="UInt32"), "dwInDelivers": SimTypeInt(signed=False, label="UInt32"), "dwOutRequests": SimTypeInt(signed=False, label="UInt32"), "dwRoutingDiscards": SimTypeInt(signed=False, label="UInt32"), "dwOutDiscards": SimTypeInt(signed=False, label="UInt32"), "dwOutNoRoutes": SimTypeInt(signed=False, label="UInt32"), "dwReasmTimeout": SimTypeInt(signed=False, label="UInt32"), "dwReasmReqds": SimTypeInt(signed=False, label="UInt32"), "dwReasmOks": SimTypeInt(signed=False, label="UInt32"), "dwReasmFails": SimTypeInt(signed=False, label="UInt32"), "dwFragOks": SimTypeInt(signed=False, label="UInt32"), "dwFragFails": SimTypeInt(signed=False, label="UInt32"), "dwFragCreates": SimTypeInt(signed=False, label="UInt32"), "dwNumIf": SimTypeInt(signed=False, label="UInt32"), "dwNumAddr": SimTypeInt(signed=False, label="UInt32"), "dwNumRoutes": SimTypeInt(signed=False, label="UInt32")}, name="MIB_IPSTATS_LH", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["Statistics"]),
        # 
        'GetIcmpStatistics': SimTypeFunction([SimTypePointer(SimStruct({"stats": SimStruct({"icmpInStats": SimStruct({"dwMsgs": SimTypeInt(signed=False, label="UInt32"), "dwErrors": SimTypeInt(signed=False, label="UInt32"), "dwDestUnreachs": SimTypeInt(signed=False, label="UInt32"), "dwTimeExcds": SimTypeInt(signed=False, label="UInt32"), "dwParmProbs": SimTypeInt(signed=False, label="UInt32"), "dwSrcQuenchs": SimTypeInt(signed=False, label="UInt32"), "dwRedirects": SimTypeInt(signed=False, label="UInt32"), "dwEchos": SimTypeInt(signed=False, label="UInt32"), "dwEchoReps": SimTypeInt(signed=False, label="UInt32"), "dwTimestamps": SimTypeInt(signed=False, label="UInt32"), "dwTimestampReps": SimTypeInt(signed=False, label="UInt32"), "dwAddrMasks": SimTypeInt(signed=False, label="UInt32"), "dwAddrMaskReps": SimTypeInt(signed=False, label="UInt32")}, name="MIBICMPSTATS", pack=False, align=None), "icmpOutStats": SimStruct({"dwMsgs": SimTypeInt(signed=False, label="UInt32"), "dwErrors": SimTypeInt(signed=False, label="UInt32"), "dwDestUnreachs": SimTypeInt(signed=False, label="UInt32"), "dwTimeExcds": SimTypeInt(signed=False, label="UInt32"), "dwParmProbs": SimTypeInt(signed=False, label="UInt32"), "dwSrcQuenchs": SimTypeInt(signed=False, label="UInt32"), "dwRedirects": SimTypeInt(signed=False, label="UInt32"), "dwEchos": SimTypeInt(signed=False, label="UInt32"), "dwEchoReps": SimTypeInt(signed=False, label="UInt32"), "dwTimestamps": SimTypeInt(signed=False, label="UInt32"), "dwTimestampReps": SimTypeInt(signed=False, label="UInt32"), "dwAddrMasks": SimTypeInt(signed=False, label="UInt32"), "dwAddrMaskReps": SimTypeInt(signed=False, label="UInt32")}, name="MIBICMPSTATS", pack=False, align=None)}, name="MIBICMPINFO", pack=False, align=None)}, name="MIB_ICMP", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["Statistics"]),
        # 
        'GetTcpStatistics': SimTypeFunction([SimTypePointer(SimStruct({"Anonymous": SimUnion({"dwRtoAlgorithm": SimTypeInt(signed=False, label="UInt32"), "RtoAlgorithm": SimTypeInt(signed=False, label="TCP_RTO_ALGORITHM")}, name="<anon>", label="None"), "dwRtoMin": SimTypeInt(signed=False, label="UInt32"), "dwRtoMax": SimTypeInt(signed=False, label="UInt32"), "dwMaxConn": SimTypeInt(signed=False, label="UInt32"), "dwActiveOpens": SimTypeInt(signed=False, label="UInt32"), "dwPassiveOpens": SimTypeInt(signed=False, label="UInt32"), "dwAttemptFails": SimTypeInt(signed=False, label="UInt32"), "dwEstabResets": SimTypeInt(signed=False, label="UInt32"), "dwCurrEstab": SimTypeInt(signed=False, label="UInt32"), "dwInSegs": SimTypeInt(signed=False, label="UInt32"), "dwOutSegs": SimTypeInt(signed=False, label="UInt32"), "dwRetransSegs": SimTypeInt(signed=False, label="UInt32"), "dwInErrs": SimTypeInt(signed=False, label="UInt32"), "dwOutRsts": SimTypeInt(signed=False, label="UInt32"), "dwNumConns": SimTypeInt(signed=False, label="UInt32")}, name="MIB_TCPSTATS_LH", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["Statistics"]),
        # 
        'GetUdpStatistics': SimTypeFunction([SimTypePointer(SimStruct({"dwInDatagrams": SimTypeInt(signed=False, label="UInt32"), "dwNoPorts": SimTypeInt(signed=False, label="UInt32"), "dwInErrors": SimTypeInt(signed=False, label="UInt32"), "dwOutDatagrams": SimTypeInt(signed=False, label="UInt32"), "dwNumAddrs": SimTypeInt(signed=False, label="UInt32")}, name="MIB_UDPSTATS", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["Stats"]),
        # 
        'SetIpStatisticsEx': SimTypeFunction([SimTypePointer(SimStruct({"Anonymous": SimUnion({"dwForwarding": SimTypeInt(signed=False, label="UInt32"), "Forwarding": SimTypeInt(signed=False, label="MIB_IPSTATS_FORWARDING")}, name="<anon>", label="None"), "dwDefaultTTL": SimTypeInt(signed=False, label="UInt32"), "dwInReceives": SimTypeInt(signed=False, label="UInt32"), "dwInHdrErrors": SimTypeInt(signed=False, label="UInt32"), "dwInAddrErrors": SimTypeInt(signed=False, label="UInt32"), "dwForwDatagrams": SimTypeInt(signed=False, label="UInt32"), "dwInUnknownProtos": SimTypeInt(signed=False, label="UInt32"), "dwInDiscards": SimTypeInt(signed=False, label="UInt32"), "dwInDelivers": SimTypeInt(signed=False, label="UInt32"), "dwOutRequests": SimTypeInt(signed=False, label="UInt32"), "dwRoutingDiscards": SimTypeInt(signed=False, label="UInt32"), "dwOutDiscards": SimTypeInt(signed=False, label="UInt32"), "dwOutNoRoutes": SimTypeInt(signed=False, label="UInt32"), "dwReasmTimeout": SimTypeInt(signed=False, label="UInt32"), "dwReasmReqds": SimTypeInt(signed=False, label="UInt32"), "dwReasmOks": SimTypeInt(signed=False, label="UInt32"), "dwReasmFails": SimTypeInt(signed=False, label="UInt32"), "dwFragOks": SimTypeInt(signed=False, label="UInt32"), "dwFragFails": SimTypeInt(signed=False, label="UInt32"), "dwFragCreates": SimTypeInt(signed=False, label="UInt32"), "dwNumIf": SimTypeInt(signed=False, label="UInt32"), "dwNumAddr": SimTypeInt(signed=False, label="UInt32"), "dwNumRoutes": SimTypeInt(signed=False, label="UInt32")}, name="MIB_IPSTATS_LH", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["Statistics", "Family"]),
        # 
        'GetIpStatisticsEx': SimTypeFunction([SimTypePointer(SimStruct({"Anonymous": SimUnion({"dwForwarding": SimTypeInt(signed=False, label="UInt32"), "Forwarding": SimTypeInt(signed=False, label="MIB_IPSTATS_FORWARDING")}, name="<anon>", label="None"), "dwDefaultTTL": SimTypeInt(signed=False, label="UInt32"), "dwInReceives": SimTypeInt(signed=False, label="UInt32"), "dwInHdrErrors": SimTypeInt(signed=False, label="UInt32"), "dwInAddrErrors": SimTypeInt(signed=False, label="UInt32"), "dwForwDatagrams": SimTypeInt(signed=False, label="UInt32"), "dwInUnknownProtos": SimTypeInt(signed=False, label="UInt32"), "dwInDiscards": SimTypeInt(signed=False, label="UInt32"), "dwInDelivers": SimTypeInt(signed=False, label="UInt32"), "dwOutRequests": SimTypeInt(signed=False, label="UInt32"), "dwRoutingDiscards": SimTypeInt(signed=False, label="UInt32"), "dwOutDiscards": SimTypeInt(signed=False, label="UInt32"), "dwOutNoRoutes": SimTypeInt(signed=False, label="UInt32"), "dwReasmTimeout": SimTypeInt(signed=False, label="UInt32"), "dwReasmReqds": SimTypeInt(signed=False, label="UInt32"), "dwReasmOks": SimTypeInt(signed=False, label="UInt32"), "dwReasmFails": SimTypeInt(signed=False, label="UInt32"), "dwFragOks": SimTypeInt(signed=False, label="UInt32"), "dwFragFails": SimTypeInt(signed=False, label="UInt32"), "dwFragCreates": SimTypeInt(signed=False, label="UInt32"), "dwNumIf": SimTypeInt(signed=False, label="UInt32"), "dwNumAddr": SimTypeInt(signed=False, label="UInt32"), "dwNumRoutes": SimTypeInt(signed=False, label="UInt32")}, name="MIB_IPSTATS_LH", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="ADDRESS_FAMILY")], SimTypeInt(signed=False, label="UInt32"), arg_names=["Statistics", "Family"]),
        # 
        'GetIcmpStatisticsEx': SimTypeFunction([SimTypePointer(SimStruct({"icmpInStats": SimStruct({"dwMsgs": SimTypeInt(signed=False, label="UInt32"), "dwErrors": SimTypeInt(signed=False, label="UInt32"), "rgdwTypeCount": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 256)}, name="MIBICMPSTATS_EX_XPSP1", pack=False, align=None), "icmpOutStats": SimStruct({"dwMsgs": SimTypeInt(signed=False, label="UInt32"), "dwErrors": SimTypeInt(signed=False, label="UInt32"), "rgdwTypeCount": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 256)}, name="MIBICMPSTATS_EX_XPSP1", pack=False, align=None)}, name="MIB_ICMP_EX_XPSP1", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["Statistics", "Family"]),
        # 
        'GetTcpStatisticsEx': SimTypeFunction([SimTypePointer(SimStruct({"Anonymous": SimUnion({"dwRtoAlgorithm": SimTypeInt(signed=False, label="UInt32"), "RtoAlgorithm": SimTypeInt(signed=False, label="TCP_RTO_ALGORITHM")}, name="<anon>", label="None"), "dwRtoMin": SimTypeInt(signed=False, label="UInt32"), "dwRtoMax": SimTypeInt(signed=False, label="UInt32"), "dwMaxConn": SimTypeInt(signed=False, label="UInt32"), "dwActiveOpens": SimTypeInt(signed=False, label="UInt32"), "dwPassiveOpens": SimTypeInt(signed=False, label="UInt32"), "dwAttemptFails": SimTypeInt(signed=False, label="UInt32"), "dwEstabResets": SimTypeInt(signed=False, label="UInt32"), "dwCurrEstab": SimTypeInt(signed=False, label="UInt32"), "dwInSegs": SimTypeInt(signed=False, label="UInt32"), "dwOutSegs": SimTypeInt(signed=False, label="UInt32"), "dwRetransSegs": SimTypeInt(signed=False, label="UInt32"), "dwInErrs": SimTypeInt(signed=False, label="UInt32"), "dwOutRsts": SimTypeInt(signed=False, label="UInt32"), "dwNumConns": SimTypeInt(signed=False, label="UInt32")}, name="MIB_TCPSTATS_LH", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="ADDRESS_FAMILY")], SimTypeInt(signed=False, label="UInt32"), arg_names=["Statistics", "Family"]),
        # 
        'GetUdpStatisticsEx': SimTypeFunction([SimTypePointer(SimStruct({"dwInDatagrams": SimTypeInt(signed=False, label="UInt32"), "dwNoPorts": SimTypeInt(signed=False, label="UInt32"), "dwInErrors": SimTypeInt(signed=False, label="UInt32"), "dwOutDatagrams": SimTypeInt(signed=False, label="UInt32"), "dwNumAddrs": SimTypeInt(signed=False, label="UInt32")}, name="MIB_UDPSTATS", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="ADDRESS_FAMILY")], SimTypeInt(signed=False, label="UInt32"), arg_names=["Statistics", "Family"]),
        # 
        'GetTcpStatisticsEx2': SimTypeFunction([SimTypePointer(SimStruct({"RtoAlgorithm": SimTypeInt(signed=False, label="TCP_RTO_ALGORITHM"), "dwRtoMin": SimTypeInt(signed=False, label="UInt32"), "dwRtoMax": SimTypeInt(signed=False, label="UInt32"), "dwMaxConn": SimTypeInt(signed=False, label="UInt32"), "dwActiveOpens": SimTypeInt(signed=False, label="UInt32"), "dwPassiveOpens": SimTypeInt(signed=False, label="UInt32"), "dwAttemptFails": SimTypeInt(signed=False, label="UInt32"), "dwEstabResets": SimTypeInt(signed=False, label="UInt32"), "dwCurrEstab": SimTypeInt(signed=False, label="UInt32"), "dw64InSegs": SimTypeLongLong(signed=False, label="UInt64"), "dw64OutSegs": SimTypeLongLong(signed=False, label="UInt64"), "dwRetransSegs": SimTypeInt(signed=False, label="UInt32"), "dwInErrs": SimTypeInt(signed=False, label="UInt32"), "dwOutRsts": SimTypeInt(signed=False, label="UInt32"), "dwNumConns": SimTypeInt(signed=False, label="UInt32")}, name="MIB_TCPSTATS2", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="ADDRESS_FAMILY")], SimTypeInt(signed=False, label="UInt32"), arg_names=["Statistics", "Family"]),
        # 
        'GetUdpStatisticsEx2': SimTypeFunction([SimTypePointer(SimStruct({"dw64InDatagrams": SimTypeLongLong(signed=False, label="UInt64"), "dwNoPorts": SimTypeInt(signed=False, label="UInt32"), "dwInErrors": SimTypeInt(signed=False, label="UInt32"), "dw64OutDatagrams": SimTypeLongLong(signed=False, label="UInt64"), "dwNumAddrs": SimTypeInt(signed=False, label="UInt32")}, name="MIB_UDPSTATS2", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="ADDRESS_FAMILY")], SimTypeInt(signed=False, label="UInt32"), arg_names=["Statistics", "Family"]),
        # 
        'SetIfEntry': SimTypeFunction([SimTypePointer(SimStruct({"wszName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 256), "dwIndex": SimTypeInt(signed=False, label="UInt32"), "dwType": SimTypeInt(signed=False, label="UInt32"), "dwMtu": SimTypeInt(signed=False, label="UInt32"), "dwSpeed": SimTypeInt(signed=False, label="UInt32"), "dwPhysAddrLen": SimTypeInt(signed=False, label="UInt32"), "bPhysAddr": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 8), "dwAdminStatus": SimTypeInt(signed=False, label="UInt32"), "dwOperStatus": SimTypeInt(signed=False, label="INTERNAL_IF_OPER_STATUS"), "dwLastChange": SimTypeInt(signed=False, label="UInt32"), "dwInOctets": SimTypeInt(signed=False, label="UInt32"), "dwInUcastPkts": SimTypeInt(signed=False, label="UInt32"), "dwInNUcastPkts": SimTypeInt(signed=False, label="UInt32"), "dwInDiscards": SimTypeInt(signed=False, label="UInt32"), "dwInErrors": SimTypeInt(signed=False, label="UInt32"), "dwInUnknownProtos": SimTypeInt(signed=False, label="UInt32"), "dwOutOctets": SimTypeInt(signed=False, label="UInt32"), "dwOutUcastPkts": SimTypeInt(signed=False, label="UInt32"), "dwOutNUcastPkts": SimTypeInt(signed=False, label="UInt32"), "dwOutDiscards": SimTypeInt(signed=False, label="UInt32"), "dwOutErrors": SimTypeInt(signed=False, label="UInt32"), "dwOutQLen": SimTypeInt(signed=False, label="UInt32"), "dwDescrLen": SimTypeInt(signed=False, label="UInt32"), "bDescr": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 256)}, name="MIB_IFROW", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pIfRow"]),
        # 
        'CreateIpForwardEntry': SimTypeFunction([SimTypePointer(SimStruct({"dwForwardDest": SimTypeInt(signed=False, label="UInt32"), "dwForwardMask": SimTypeInt(signed=False, label="UInt32"), "dwForwardPolicy": SimTypeInt(signed=False, label="UInt32"), "dwForwardNextHop": SimTypeInt(signed=False, label="UInt32"), "dwForwardIfIndex": SimTypeInt(signed=False, label="UInt32"), "Anonymous1": SimUnion({"dwForwardType": SimTypeInt(signed=False, label="UInt32"), "ForwardType": SimTypeInt(signed=False, label="MIB_IPFORWARD_TYPE")}, name="<anon>", label="None"), "Anonymous2": SimUnion({"dwForwardProto": SimTypeInt(signed=False, label="UInt32"), "ForwardProto": SimTypeInt(signed=False, label="NL_ROUTE_PROTOCOL")}, name="<anon>", label="None"), "dwForwardAge": SimTypeInt(signed=False, label="UInt32"), "dwForwardNextHopAS": SimTypeInt(signed=False, label="UInt32"), "dwForwardMetric1": SimTypeInt(signed=False, label="UInt32"), "dwForwardMetric2": SimTypeInt(signed=False, label="UInt32"), "dwForwardMetric3": SimTypeInt(signed=False, label="UInt32"), "dwForwardMetric4": SimTypeInt(signed=False, label="UInt32"), "dwForwardMetric5": SimTypeInt(signed=False, label="UInt32")}, name="MIB_IPFORWARDROW", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pRoute"]),
        # 
        'SetIpForwardEntry': SimTypeFunction([SimTypePointer(SimStruct({"dwForwardDest": SimTypeInt(signed=False, label="UInt32"), "dwForwardMask": SimTypeInt(signed=False, label="UInt32"), "dwForwardPolicy": SimTypeInt(signed=False, label="UInt32"), "dwForwardNextHop": SimTypeInt(signed=False, label="UInt32"), "dwForwardIfIndex": SimTypeInt(signed=False, label="UInt32"), "Anonymous1": SimUnion({"dwForwardType": SimTypeInt(signed=False, label="UInt32"), "ForwardType": SimTypeInt(signed=False, label="MIB_IPFORWARD_TYPE")}, name="<anon>", label="None"), "Anonymous2": SimUnion({"dwForwardProto": SimTypeInt(signed=False, label="UInt32"), "ForwardProto": SimTypeInt(signed=False, label="NL_ROUTE_PROTOCOL")}, name="<anon>", label="None"), "dwForwardAge": SimTypeInt(signed=False, label="UInt32"), "dwForwardNextHopAS": SimTypeInt(signed=False, label="UInt32"), "dwForwardMetric1": SimTypeInt(signed=False, label="UInt32"), "dwForwardMetric2": SimTypeInt(signed=False, label="UInt32"), "dwForwardMetric3": SimTypeInt(signed=False, label="UInt32"), "dwForwardMetric4": SimTypeInt(signed=False, label="UInt32"), "dwForwardMetric5": SimTypeInt(signed=False, label="UInt32")}, name="MIB_IPFORWARDROW", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pRoute"]),
        # 
        'DeleteIpForwardEntry': SimTypeFunction([SimTypePointer(SimStruct({"dwForwardDest": SimTypeInt(signed=False, label="UInt32"), "dwForwardMask": SimTypeInt(signed=False, label="UInt32"), "dwForwardPolicy": SimTypeInt(signed=False, label="UInt32"), "dwForwardNextHop": SimTypeInt(signed=False, label="UInt32"), "dwForwardIfIndex": SimTypeInt(signed=False, label="UInt32"), "Anonymous1": SimUnion({"dwForwardType": SimTypeInt(signed=False, label="UInt32"), "ForwardType": SimTypeInt(signed=False, label="MIB_IPFORWARD_TYPE")}, name="<anon>", label="None"), "Anonymous2": SimUnion({"dwForwardProto": SimTypeInt(signed=False, label="UInt32"), "ForwardProto": SimTypeInt(signed=False, label="NL_ROUTE_PROTOCOL")}, name="<anon>", label="None"), "dwForwardAge": SimTypeInt(signed=False, label="UInt32"), "dwForwardNextHopAS": SimTypeInt(signed=False, label="UInt32"), "dwForwardMetric1": SimTypeInt(signed=False, label="UInt32"), "dwForwardMetric2": SimTypeInt(signed=False, label="UInt32"), "dwForwardMetric3": SimTypeInt(signed=False, label="UInt32"), "dwForwardMetric4": SimTypeInt(signed=False, label="UInt32"), "dwForwardMetric5": SimTypeInt(signed=False, label="UInt32")}, name="MIB_IPFORWARDROW", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pRoute"]),
        # 
        'SetIpStatistics': SimTypeFunction([SimTypePointer(SimStruct({"Anonymous": SimUnion({"dwForwarding": SimTypeInt(signed=False, label="UInt32"), "Forwarding": SimTypeInt(signed=False, label="MIB_IPSTATS_FORWARDING")}, name="<anon>", label="None"), "dwDefaultTTL": SimTypeInt(signed=False, label="UInt32"), "dwInReceives": SimTypeInt(signed=False, label="UInt32"), "dwInHdrErrors": SimTypeInt(signed=False, label="UInt32"), "dwInAddrErrors": SimTypeInt(signed=False, label="UInt32"), "dwForwDatagrams": SimTypeInt(signed=False, label="UInt32"), "dwInUnknownProtos": SimTypeInt(signed=False, label="UInt32"), "dwInDiscards": SimTypeInt(signed=False, label="UInt32"), "dwInDelivers": SimTypeInt(signed=False, label="UInt32"), "dwOutRequests": SimTypeInt(signed=False, label="UInt32"), "dwRoutingDiscards": SimTypeInt(signed=False, label="UInt32"), "dwOutDiscards": SimTypeInt(signed=False, label="UInt32"), "dwOutNoRoutes": SimTypeInt(signed=False, label="UInt32"), "dwReasmTimeout": SimTypeInt(signed=False, label="UInt32"), "dwReasmReqds": SimTypeInt(signed=False, label="UInt32"), "dwReasmOks": SimTypeInt(signed=False, label="UInt32"), "dwReasmFails": SimTypeInt(signed=False, label="UInt32"), "dwFragOks": SimTypeInt(signed=False, label="UInt32"), "dwFragFails": SimTypeInt(signed=False, label="UInt32"), "dwFragCreates": SimTypeInt(signed=False, label="UInt32"), "dwNumIf": SimTypeInt(signed=False, label="UInt32"), "dwNumAddr": SimTypeInt(signed=False, label="UInt32"), "dwNumRoutes": SimTypeInt(signed=False, label="UInt32")}, name="MIB_IPSTATS_LH", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pIpStats"]),
        # 
        'SetIpTTL': SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["nTTL"]),
        # 
        'CreateIpNetEntry': SimTypeFunction([SimTypePointer(SimStruct({"dwIndex": SimTypeInt(signed=False, label="UInt32"), "dwPhysAddrLen": SimTypeInt(signed=False, label="UInt32"), "bPhysAddr": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 8), "dwAddr": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"dwType": SimTypeInt(signed=False, label="UInt32"), "Type": SimTypeInt(signed=False, label="MIB_IPNET_TYPE")}, name="<anon>", label="None")}, name="MIB_IPNETROW_LH", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pArpEntry"]),
        # 
        'SetIpNetEntry': SimTypeFunction([SimTypePointer(SimStruct({"dwIndex": SimTypeInt(signed=False, label="UInt32"), "dwPhysAddrLen": SimTypeInt(signed=False, label="UInt32"), "bPhysAddr": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 8), "dwAddr": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"dwType": SimTypeInt(signed=False, label="UInt32"), "Type": SimTypeInt(signed=False, label="MIB_IPNET_TYPE")}, name="<anon>", label="None")}, name="MIB_IPNETROW_LH", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pArpEntry"]),
        # 
        'DeleteIpNetEntry': SimTypeFunction([SimTypePointer(SimStruct({"dwIndex": SimTypeInt(signed=False, label="UInt32"), "dwPhysAddrLen": SimTypeInt(signed=False, label="UInt32"), "bPhysAddr": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 8), "dwAddr": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"dwType": SimTypeInt(signed=False, label="UInt32"), "Type": SimTypeInt(signed=False, label="MIB_IPNET_TYPE")}, name="<anon>", label="None")}, name="MIB_IPNETROW_LH", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pArpEntry"]),
        # 
        'FlushIpNetTable': SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["dwIfIndex"]),
        # 
        'CreateProxyArpEntry': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["dwAddress", "dwMask", "dwIfIndex"]),
        # 
        'DeleteProxyArpEntry': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["dwAddress", "dwMask", "dwIfIndex"]),
        # 
        'SetTcpEntry': SimTypeFunction([SimTypePointer(SimStruct({"Anonymous": SimUnion({"dwState": SimTypeInt(signed=False, label="UInt32"), "State": SimTypeInt(signed=False, label="MIB_TCP_STATE")}, name="<anon>", label="None"), "dwLocalAddr": SimTypeInt(signed=False, label="UInt32"), "dwLocalPort": SimTypeInt(signed=False, label="UInt32"), "dwRemoteAddr": SimTypeInt(signed=False, label="UInt32"), "dwRemotePort": SimTypeInt(signed=False, label="UInt32")}, name="MIB_TCPROW_LH", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pTcpRow"]),
        # 
        'GetInterfaceInfo': SimTypeFunction([SimTypePointer(SimStruct({"NumAdapters": SimTypeInt(signed=True, label="Int32"), "Adapter": SimTypePointer(SimStruct({"Index": SimTypeInt(signed=False, label="UInt32"), "Name": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 128)}, name="IP_ADAPTER_INDEX_MAP", pack=False, align=None), offset=0)}, name="IP_INTERFACE_INFO", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pIfTable", "dwOutBufLen"]),
        # 
        'GetUniDirectionalAdapterInfo': SimTypeFunction([SimTypePointer(SimStruct({"NumAdapters": SimTypeInt(signed=False, label="UInt32"), "Address": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="IP_UNIDIRECTIONAL_ADAPTER_ADDRESS", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pIPIfInfo", "dwOutBufLen"]),
        # 
        'NhpAllocateAndGetInterfaceInfoFromStack': SimTypeFunction([SimTypePointer(SimTypePointer(SimStruct({"Index": SimTypeInt(signed=False, label="UInt32"), "MediaType": SimTypeInt(signed=False, label="UInt32"), "ConnectionType": SimTypeChar(label="Byte"), "AccessType": SimTypeChar(label="Byte"), "DeviceGuid": SimTypeBottom(label="Guid"), "InterfaceGuid": SimTypeBottom(label="Guid")}, name="ip_interface_name_info_w2ksp1", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["ppTable", "pdwCount", "bOrder", "hHeap", "dwFlags"]),
        # 
        'GetBestInterface': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["dwDestAddr", "pdwBestIfIndex"]),
        # 
        'GetBestInterfaceEx': SimTypeFunction([SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pDestAddr", "pdwBestIfIndex"]),
        # 
        'GetBestRoute': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwForwardDest": SimTypeInt(signed=False, label="UInt32"), "dwForwardMask": SimTypeInt(signed=False, label="UInt32"), "dwForwardPolicy": SimTypeInt(signed=False, label="UInt32"), "dwForwardNextHop": SimTypeInt(signed=False, label="UInt32"), "dwForwardIfIndex": SimTypeInt(signed=False, label="UInt32"), "Anonymous1": SimUnion({"dwForwardType": SimTypeInt(signed=False, label="UInt32"), "ForwardType": SimTypeInt(signed=False, label="MIB_IPFORWARD_TYPE")}, name="<anon>", label="None"), "Anonymous2": SimUnion({"dwForwardProto": SimTypeInt(signed=False, label="UInt32"), "ForwardProto": SimTypeInt(signed=False, label="NL_ROUTE_PROTOCOL")}, name="<anon>", label="None"), "dwForwardAge": SimTypeInt(signed=False, label="UInt32"), "dwForwardNextHopAS": SimTypeInt(signed=False, label="UInt32"), "dwForwardMetric1": SimTypeInt(signed=False, label="UInt32"), "dwForwardMetric2": SimTypeInt(signed=False, label="UInt32"), "dwForwardMetric3": SimTypeInt(signed=False, label="UInt32"), "dwForwardMetric4": SimTypeInt(signed=False, label="UInt32"), "dwForwardMetric5": SimTypeInt(signed=False, label="UInt32")}, name="MIB_IPFORWARDROW", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["dwDestAddr", "dwSourceAddr", "pBestRoute"]),
        # 
        'NotifyAddrChange': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypePointer(SimStruct({"Internal": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "InternalHigh": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Anonymous": SimUnion({"Anonymous": SimStruct({"Offset": SimTypeInt(signed=False, label="UInt32"), "OffsetHigh": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Pointer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None"), "hEvent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="OVERLAPPED", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["Handle", "overlapped"]),
        # 
        'NotifyRouteChange': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypePointer(SimStruct({"Internal": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "InternalHigh": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Anonymous": SimUnion({"Anonymous": SimStruct({"Offset": SimTypeInt(signed=False, label="UInt32"), "OffsetHigh": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Pointer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None"), "hEvent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="OVERLAPPED", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["Handle", "overlapped"]),
        # 
        'CancelIPChangeNotify': SimTypeFunction([SimTypePointer(SimStruct({"Internal": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "InternalHigh": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Anonymous": SimUnion({"Anonymous": SimStruct({"Offset": SimTypeInt(signed=False, label="UInt32"), "OffsetHigh": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Pointer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None"), "hEvent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="OVERLAPPED", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["notifyOverlapped"]),
        # 
        'GetAdapterIndex': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["AdapterName", "IfIndex"]),
        # 
        'AddIPAddress': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["Address", "IpMask", "IfIndex", "NTEContext", "NTEInstance"]),
        # 
        'DeleteIPAddress': SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["NTEContext"]),
        # 
        'GetNetworkParams': SimTypeFunction([SimTypePointer(SimStruct({"HostName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 132), "DomainName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 132), "CurrentDnsServer": SimTypePointer(SimStruct({"Next": SimTypePointer(SimTypeBottom(label="IP_ADDR_STRING"), offset=0), "IpAddress": SimStruct({"String": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 16)}, name="IP_ADDRESS_STRING", pack=False, align=None), "IpMask": SimStruct({"String": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 16)}, name="IP_ADDRESS_STRING", pack=False, align=None), "Context": SimTypeInt(signed=False, label="UInt32")}, name="IP_ADDR_STRING", pack=False, align=None), offset=0), "DnsServerList": SimStruct({"Next": SimTypePointer(SimTypeBottom(label="IP_ADDR_STRING"), offset=0), "IpAddress": SimStruct({"String": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 16)}, name="IP_ADDRESS_STRING", pack=False, align=None), "IpMask": SimStruct({"String": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 16)}, name="IP_ADDRESS_STRING", pack=False, align=None), "Context": SimTypeInt(signed=False, label="UInt32")}, name="IP_ADDR_STRING", pack=False, align=None), "NodeType": SimTypeInt(signed=False, label="UInt32"), "ScopeId": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 260), "EnableRouting": SimTypeInt(signed=False, label="UInt32"), "EnableProxy": SimTypeInt(signed=False, label="UInt32"), "EnableDns": SimTypeInt(signed=False, label="UInt32")}, name="FIXED_INFO_W2KSP1", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="WIN32_ERROR"), arg_names=["pFixedInfo", "pOutBufLen"]),
        # 
        'GetAdaptersInfo': SimTypeFunction([SimTypePointer(SimStruct({"Next": SimTypePointer(SimTypeBottom(label="IP_ADAPTER_INFO"), offset=0), "ComboIndex": SimTypeInt(signed=False, label="UInt32"), "AdapterName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 260), "Description": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 132), "AddressLength": SimTypeInt(signed=False, label="UInt32"), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 8), "Index": SimTypeInt(signed=False, label="UInt32"), "Type": SimTypeInt(signed=False, label="UInt32"), "DhcpEnabled": SimTypeInt(signed=False, label="UInt32"), "CurrentIpAddress": SimTypePointer(SimStruct({"Next": SimTypePointer(SimTypeBottom(label="IP_ADDR_STRING"), offset=0), "IpAddress": SimStruct({"String": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 16)}, name="IP_ADDRESS_STRING", pack=False, align=None), "IpMask": SimStruct({"String": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 16)}, name="IP_ADDRESS_STRING", pack=False, align=None), "Context": SimTypeInt(signed=False, label="UInt32")}, name="IP_ADDR_STRING", pack=False, align=None), offset=0), "IpAddressList": SimStruct({"Next": SimTypePointer(SimTypeBottom(label="IP_ADDR_STRING"), offset=0), "IpAddress": SimStruct({"String": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 16)}, name="IP_ADDRESS_STRING", pack=False, align=None), "IpMask": SimStruct({"String": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 16)}, name="IP_ADDRESS_STRING", pack=False, align=None), "Context": SimTypeInt(signed=False, label="UInt32")}, name="IP_ADDR_STRING", pack=False, align=None), "GatewayList": SimStruct({"Next": SimTypePointer(SimTypeBottom(label="IP_ADDR_STRING"), offset=0), "IpAddress": SimStruct({"String": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 16)}, name="IP_ADDRESS_STRING", pack=False, align=None), "IpMask": SimStruct({"String": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 16)}, name="IP_ADDRESS_STRING", pack=False, align=None), "Context": SimTypeInt(signed=False, label="UInt32")}, name="IP_ADDR_STRING", pack=False, align=None), "DhcpServer": SimStruct({"Next": SimTypePointer(SimTypeBottom(label="IP_ADDR_STRING"), offset=0), "IpAddress": SimStruct({"String": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 16)}, name="IP_ADDRESS_STRING", pack=False, align=None), "IpMask": SimStruct({"String": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 16)}, name="IP_ADDRESS_STRING", pack=False, align=None), "Context": SimTypeInt(signed=False, label="UInt32")}, name="IP_ADDR_STRING", pack=False, align=None), "HaveWins": SimTypeInt(signed=True, label="Int32"), "PrimaryWinsServer": SimStruct({"Next": SimTypePointer(SimTypeBottom(label="IP_ADDR_STRING"), offset=0), "IpAddress": SimStruct({"String": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 16)}, name="IP_ADDRESS_STRING", pack=False, align=None), "IpMask": SimStruct({"String": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 16)}, name="IP_ADDRESS_STRING", pack=False, align=None), "Context": SimTypeInt(signed=False, label="UInt32")}, name="IP_ADDR_STRING", pack=False, align=None), "SecondaryWinsServer": SimStruct({"Next": SimTypePointer(SimTypeBottom(label="IP_ADDR_STRING"), offset=0), "IpAddress": SimStruct({"String": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 16)}, name="IP_ADDRESS_STRING", pack=False, align=None), "IpMask": SimStruct({"String": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 16)}, name="IP_ADDRESS_STRING", pack=False, align=None), "Context": SimTypeInt(signed=False, label="UInt32")}, name="IP_ADDR_STRING", pack=False, align=None), "LeaseObtained": SimTypeLongLong(signed=True, label="Int64"), "LeaseExpires": SimTypeLongLong(signed=True, label="Int64")}, name="IP_ADAPTER_INFO", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["AdapterInfo", "SizePointer"]),
        # 
        'GetAdapterOrderMap': SimTypeFunction([], SimTypePointer(SimStruct({"NumAdapters": SimTypeInt(signed=False, label="UInt32"), "AdapterOrder": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="IP_ADAPTER_ORDER_MAP", pack=False, align=None), offset=0)),
        # 
        'GetAdaptersAddresses': SimTypeFunction([SimTypeInt(signed=False, label="ADDRESS_FAMILY"), SimTypeInt(signed=False, label="GET_ADAPTERS_ADDRESSES_FLAGS"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"Anonymous1": SimUnion({"Alignment": SimTypeLongLong(signed=False, label="UInt64"), "Anonymous": SimStruct({"Length": SimTypeInt(signed=False, label="UInt32"), "IfIndex": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "Next": SimTypePointer(SimTypeBottom(label="IP_ADAPTER_ADDRESSES_LH"), offset=0), "AdapterName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "FirstUnicastAddress": SimTypePointer(SimStruct({"Anonymous": SimUnion({"Alignment": SimTypeLongLong(signed=False, label="UInt64"), "Anonymous": SimStruct({"Length": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "Next": SimTypePointer(SimTypeBottom(label="IP_ADAPTER_UNICAST_ADDRESS_LH"), offset=0), "Address": SimStruct({"lpSockaddr": SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), "iSockaddrLength": SimTypeInt(signed=True, label="Int32")}, name="SOCKET_ADDRESS", pack=False, align=None), "PrefixOrigin": SimTypeInt(signed=False, label="NL_PREFIX_ORIGIN"), "SuffixOrigin": SimTypeInt(signed=False, label="NL_SUFFIX_ORIGIN"), "DadState": SimTypeInt(signed=False, label="NL_DAD_STATE"), "ValidLifetime": SimTypeInt(signed=False, label="UInt32"), "PreferredLifetime": SimTypeInt(signed=False, label="UInt32"), "LeaseLifetime": SimTypeInt(signed=False, label="UInt32"), "OnLinkPrefixLength": SimTypeChar(label="Byte")}, name="IP_ADAPTER_UNICAST_ADDRESS_LH", pack=False, align=None), offset=0), "FirstAnycastAddress": SimTypePointer(SimStruct({"Anonymous": SimUnion({"Alignment": SimTypeLongLong(signed=False, label="UInt64"), "Anonymous": SimStruct({"Length": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "Next": SimTypePointer(SimTypeBottom(label="IP_ADAPTER_ANYCAST_ADDRESS_XP"), offset=0), "Address": SimStruct({"lpSockaddr": SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), "iSockaddrLength": SimTypeInt(signed=True, label="Int32")}, name="SOCKET_ADDRESS", pack=False, align=None)}, name="IP_ADAPTER_ANYCAST_ADDRESS_XP", pack=False, align=None), offset=0), "FirstMulticastAddress": SimTypePointer(SimStruct({"Anonymous": SimUnion({"Alignment": SimTypeLongLong(signed=False, label="UInt64"), "Anonymous": SimStruct({"Length": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "Next": SimTypePointer(SimTypeBottom(label="IP_ADAPTER_MULTICAST_ADDRESS_XP"), offset=0), "Address": SimStruct({"lpSockaddr": SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), "iSockaddrLength": SimTypeInt(signed=True, label="Int32")}, name="SOCKET_ADDRESS", pack=False, align=None)}, name="IP_ADAPTER_MULTICAST_ADDRESS_XP", pack=False, align=None), offset=0), "FirstDnsServerAddress": SimTypePointer(SimStruct({"Anonymous": SimUnion({"Alignment": SimTypeLongLong(signed=False, label="UInt64"), "Anonymous": SimStruct({"Length": SimTypeInt(signed=False, label="UInt32"), "Reserved": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "Next": SimTypePointer(SimTypeBottom(label="IP_ADAPTER_DNS_SERVER_ADDRESS_XP"), offset=0), "Address": SimStruct({"lpSockaddr": SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), "iSockaddrLength": SimTypeInt(signed=True, label="Int32")}, name="SOCKET_ADDRESS", pack=False, align=None)}, name="IP_ADAPTER_DNS_SERVER_ADDRESS_XP", pack=False, align=None), offset=0), "DnsSuffix": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Description": SimTypePointer(SimTypeChar(label="Char"), offset=0), "FriendlyName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "PhysicalAddress": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 8), "PhysicalAddressLength": SimTypeInt(signed=False, label="UInt32"), "Anonymous2": SimUnion({"Flags": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "Mtu": SimTypeInt(signed=False, label="UInt32"), "IfType": SimTypeInt(signed=False, label="UInt32"), "OperStatus": SimTypeInt(signed=False, label="IF_OPER_STATUS"), "Ipv6IfIndex": SimTypeInt(signed=False, label="UInt32"), "ZoneIndices": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 16), "FirstPrefix": SimTypePointer(SimStruct({"Anonymous": SimUnion({"Alignment": SimTypeLongLong(signed=False, label="UInt64"), "Anonymous": SimStruct({"Length": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "Next": SimTypePointer(SimTypeBottom(label="IP_ADAPTER_PREFIX_XP"), offset=0), "Address": SimStruct({"lpSockaddr": SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), "iSockaddrLength": SimTypeInt(signed=True, label="Int32")}, name="SOCKET_ADDRESS", pack=False, align=None), "PrefixLength": SimTypeInt(signed=False, label="UInt32")}, name="IP_ADAPTER_PREFIX_XP", pack=False, align=None), offset=0), "TransmitLinkSpeed": SimTypeLongLong(signed=False, label="UInt64"), "ReceiveLinkSpeed": SimTypeLongLong(signed=False, label="UInt64"), "FirstWinsServerAddress": SimTypePointer(SimStruct({"Anonymous": SimUnion({"Alignment": SimTypeLongLong(signed=False, label="UInt64"), "Anonymous": SimStruct({"Length": SimTypeInt(signed=False, label="UInt32"), "Reserved": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "Next": SimTypePointer(SimTypeBottom(label="IP_ADAPTER_WINS_SERVER_ADDRESS_LH"), offset=0), "Address": SimStruct({"lpSockaddr": SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), "iSockaddrLength": SimTypeInt(signed=True, label="Int32")}, name="SOCKET_ADDRESS", pack=False, align=None)}, name="IP_ADAPTER_WINS_SERVER_ADDRESS_LH", pack=False, align=None), offset=0), "FirstGatewayAddress": SimTypePointer(SimStruct({"Anonymous": SimUnion({"Alignment": SimTypeLongLong(signed=False, label="UInt64"), "Anonymous": SimStruct({"Length": SimTypeInt(signed=False, label="UInt32"), "Reserved": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "Next": SimTypePointer(SimTypeBottom(label="IP_ADAPTER_GATEWAY_ADDRESS_LH"), offset=0), "Address": SimStruct({"lpSockaddr": SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), "iSockaddrLength": SimTypeInt(signed=True, label="Int32")}, name="SOCKET_ADDRESS", pack=False, align=None)}, name="IP_ADAPTER_GATEWAY_ADDRESS_LH", pack=False, align=None), offset=0), "Ipv4Metric": SimTypeInt(signed=False, label="UInt32"), "Ipv6Metric": SimTypeInt(signed=False, label="UInt32"), "Luid": SimUnion({"Value": SimTypeLongLong(signed=False, label="UInt64"), "Info": SimStruct({"_bitfield": SimTypeLongLong(signed=False, label="UInt64")}, name="_Info_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "Dhcpv4Server": SimStruct({"lpSockaddr": SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), "iSockaddrLength": SimTypeInt(signed=True, label="Int32")}, name="SOCKET_ADDRESS", pack=False, align=None), "CompartmentId": SimTypeInt(signed=False, label="UInt32"), "NetworkGuid": SimTypeBottom(label="Guid"), "ConnectionType": SimTypeInt(signed=False, label="NET_IF_CONNECTION_TYPE"), "TunnelType": SimTypeInt(signed=False, label="TUNNEL_TYPE"), "Dhcpv6Server": SimStruct({"lpSockaddr": SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), "iSockaddrLength": SimTypeInt(signed=True, label="Int32")}, name="SOCKET_ADDRESS", pack=False, align=None), "Dhcpv6ClientDuid": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 130), "Dhcpv6ClientDuidLength": SimTypeInt(signed=False, label="UInt32"), "Dhcpv6Iaid": SimTypeInt(signed=False, label="UInt32"), "FirstDnsSuffix": SimTypePointer(SimStruct({"Next": SimTypePointer(SimTypeBottom(label="IP_ADAPTER_DNS_SUFFIX"), offset=0), "String": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 256)}, name="IP_ADAPTER_DNS_SUFFIX", pack=False, align=None), offset=0)}, name="IP_ADAPTER_ADDRESSES_LH", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["Family", "Flags", "Reserved", "AdapterAddresses", "SizePointer"]),
        # 
        'GetPerAdapterInfo': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"AutoconfigEnabled": SimTypeInt(signed=False, label="UInt32"), "AutoconfigActive": SimTypeInt(signed=False, label="UInt32"), "CurrentDnsServer": SimTypePointer(SimStruct({"Next": SimTypePointer(SimTypeBottom(label="IP_ADDR_STRING"), offset=0), "IpAddress": SimStruct({"String": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 16)}, name="IP_ADDRESS_STRING", pack=False, align=None), "IpMask": SimStruct({"String": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 16)}, name="IP_ADDRESS_STRING", pack=False, align=None), "Context": SimTypeInt(signed=False, label="UInt32")}, name="IP_ADDR_STRING", pack=False, align=None), offset=0), "DnsServerList": SimStruct({"Next": SimTypePointer(SimTypeBottom(label="IP_ADDR_STRING"), offset=0), "IpAddress": SimStruct({"String": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 16)}, name="IP_ADDRESS_STRING", pack=False, align=None), "IpMask": SimStruct({"String": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 16)}, name="IP_ADDRESS_STRING", pack=False, align=None), "Context": SimTypeInt(signed=False, label="UInt32")}, name="IP_ADDR_STRING", pack=False, align=None)}, name="IP_PER_ADAPTER_INFO_W2KSP1", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["IfIndex", "pPerAdapterInfo", "pOutBufLen"]),
        # 
        'GetInterfaceCurrentTimestampCapabilities': SimTypeFunction([SimTypePointer(SimUnion({"Value": SimTypeLongLong(signed=False, label="UInt64"), "Info": SimStruct({"_bitfield": SimTypeLongLong(signed=False, label="UInt64")}, name="_Info_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), offset=0), SimTypePointer(SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "HardwareClockFrequencyHz": SimTypeLongLong(signed=False, label="UInt64"), "CrossTimestamp": SimTypeChar(label="Byte"), "Reserved1": SimTypeLongLong(signed=False, label="UInt64"), "Reserved2": SimTypeLongLong(signed=False, label="UInt64"), "TimestampFlags": SimStruct({"PtpV2OverUdpIPv4EventMsgReceiveHw": SimTypeChar(label="Byte"), "PtpV2OverUdpIPv4AllMsgReceiveHw": SimTypeChar(label="Byte"), "PtpV2OverUdpIPv4EventMsgTransmitHw": SimTypeChar(label="Byte"), "PtpV2OverUdpIPv4AllMsgTransmitHw": SimTypeChar(label="Byte"), "PtpV2OverUdpIPv6EventMsgReceiveHw": SimTypeChar(label="Byte"), "PtpV2OverUdpIPv6AllMsgReceiveHw": SimTypeChar(label="Byte"), "PtpV2OverUdpIPv6EventMsgTransmitHw": SimTypeChar(label="Byte"), "PtpV2OverUdpIPv6AllMsgTransmitHw": SimTypeChar(label="Byte"), "AllReceiveHw": SimTypeChar(label="Byte"), "AllTransmitHw": SimTypeChar(label="Byte"), "TaggedTransmitHw": SimTypeChar(label="Byte"), "AllReceiveSw": SimTypeChar(label="Byte"), "AllTransmitSw": SimTypeChar(label="Byte"), "TaggedTransmitSw": SimTypeChar(label="Byte")}, name="INTERFACE_TIMESTAMP_CAPABILITY_FLAGS", pack=False, align=None)}, name="INTERFACE_TIMESTAMP_CAPABILITIES", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["InterfaceLuid", "TimestampCapabilites"]),
        # 
        'GetInterfaceHardwareTimestampCapabilities': SimTypeFunction([SimTypePointer(SimUnion({"Value": SimTypeLongLong(signed=False, label="UInt64"), "Info": SimStruct({"_bitfield": SimTypeLongLong(signed=False, label="UInt64")}, name="_Info_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), offset=0), SimTypePointer(SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "HardwareClockFrequencyHz": SimTypeLongLong(signed=False, label="UInt64"), "CrossTimestamp": SimTypeChar(label="Byte"), "Reserved1": SimTypeLongLong(signed=False, label="UInt64"), "Reserved2": SimTypeLongLong(signed=False, label="UInt64"), "TimestampFlags": SimStruct({"PtpV2OverUdpIPv4EventMsgReceiveHw": SimTypeChar(label="Byte"), "PtpV2OverUdpIPv4AllMsgReceiveHw": SimTypeChar(label="Byte"), "PtpV2OverUdpIPv4EventMsgTransmitHw": SimTypeChar(label="Byte"), "PtpV2OverUdpIPv4AllMsgTransmitHw": SimTypeChar(label="Byte"), "PtpV2OverUdpIPv6EventMsgReceiveHw": SimTypeChar(label="Byte"), "PtpV2OverUdpIPv6AllMsgReceiveHw": SimTypeChar(label="Byte"), "PtpV2OverUdpIPv6EventMsgTransmitHw": SimTypeChar(label="Byte"), "PtpV2OverUdpIPv6AllMsgTransmitHw": SimTypeChar(label="Byte"), "AllReceiveHw": SimTypeChar(label="Byte"), "AllTransmitHw": SimTypeChar(label="Byte"), "TaggedTransmitHw": SimTypeChar(label="Byte"), "AllReceiveSw": SimTypeChar(label="Byte"), "AllTransmitSw": SimTypeChar(label="Byte"), "TaggedTransmitSw": SimTypeChar(label="Byte")}, name="INTERFACE_TIMESTAMP_CAPABILITY_FLAGS", pack=False, align=None)}, name="INTERFACE_TIMESTAMP_CAPABILITIES", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["InterfaceLuid", "TimestampCapabilites"]),
        # 
        'CaptureInterfaceHardwareCrossTimestamp': SimTypeFunction([SimTypePointer(SimUnion({"Value": SimTypeLongLong(signed=False, label="UInt64"), "Info": SimStruct({"_bitfield": SimTypeLongLong(signed=False, label="UInt64")}, name="_Info_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), offset=0), SimTypePointer(SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="UInt32"), "SystemTimestamp1": SimTypeLongLong(signed=False, label="UInt64"), "HardwareClockTimestamp": SimTypeLongLong(signed=False, label="UInt64"), "SystemTimestamp2": SimTypeLongLong(signed=False, label="UInt64")}, name="INTERFACE_HARDWARE_CROSSTIMESTAMP", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["InterfaceLuid", "CrossTimestamp"]),
        # 
        'NotifyIfTimestampConfigChange': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["CallerContext"]), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["CallerContext", "Callback", "NotificationHandle"]),
        # 
        'CancelIfTimestampConfigChange': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeBottom(label="Void"), arg_names=["NotificationHandle"]),
        # 
        'IpReleaseAddress': SimTypeFunction([SimTypePointer(SimStruct({"Index": SimTypeInt(signed=False, label="UInt32"), "Name": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 128)}, name="IP_ADAPTER_INDEX_MAP", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["AdapterInfo"]),
        # 
        'IpRenewAddress': SimTypeFunction([SimTypePointer(SimStruct({"Index": SimTypeInt(signed=False, label="UInt32"), "Name": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 128)}, name="IP_ADAPTER_INDEX_MAP", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["AdapterInfo"]),
        # 
        'SendARP': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["DestIP", "SrcIP", "pMacAddr", "PhyAddrLen"]),
        # 
        'GetRTTAndHopCount': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["DestIpAddress", "HopCount", "MaxHops", "RTT"]),
        # 
        'GetFriendlyIfIndex': SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["IfIndex"]),
        # 
        'EnableRouter': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypePointer(SimStruct({"Internal": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "InternalHigh": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Anonymous": SimUnion({"Anonymous": SimStruct({"Offset": SimTypeInt(signed=False, label="UInt32"), "OffsetHigh": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Pointer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None"), "hEvent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="OVERLAPPED", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pHandle", "pOverlapped"]),
        # 
        'UnenableRouter': SimTypeFunction([SimTypePointer(SimStruct({"Internal": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "InternalHigh": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Anonymous": SimUnion({"Anonymous": SimStruct({"Offset": SimTypeInt(signed=False, label="UInt32"), "OffsetHigh": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Pointer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None"), "hEvent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="OVERLAPPED", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pOverlapped", "lpdwEnableCount"]),
        # 
        'DisableMediaSense': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypePointer(SimStruct({"Internal": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "InternalHigh": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Anonymous": SimUnion({"Anonymous": SimStruct({"Offset": SimTypeInt(signed=False, label="UInt32"), "OffsetHigh": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Pointer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None"), "hEvent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="OVERLAPPED", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pHandle", "pOverLapped"]),
        # 
        'RestoreMediaSense': SimTypeFunction([SimTypePointer(SimStruct({"Internal": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "InternalHigh": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Anonymous": SimUnion({"Anonymous": SimStruct({"Offset": SimTypeInt(signed=False, label="UInt32"), "OffsetHigh": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Pointer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None"), "hEvent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="OVERLAPPED", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pOverlapped", "lpdwEnableCount"]),
        # 
        'GetIpErrorString': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ErrorCode", "Buffer", "Size"]),
        # 
        'ResolveNeighbor': SimTypeFunction([SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["NetworkAddress", "PhysicalAddress", "PhysicalAddressLength"]),
        # 
        'CreatePersistentTcpPortReservation': SimTypeFunction([SimTypeShort(signed=False, label="UInt16"), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["StartPort", "NumberOfPorts", "Token"]),
        # 
        'CreatePersistentUdpPortReservation': SimTypeFunction([SimTypeShort(signed=False, label="UInt16"), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["StartPort", "NumberOfPorts", "Token"]),
        # 
        'DeletePersistentTcpPortReservation': SimTypeFunction([SimTypeShort(signed=False, label="UInt16"), SimTypeShort(signed=False, label="UInt16")], SimTypeInt(signed=False, label="UInt32"), arg_names=["StartPort", "NumberOfPorts"]),
        # 
        'DeletePersistentUdpPortReservation': SimTypeFunction([SimTypeShort(signed=False, label="UInt16"), SimTypeShort(signed=False, label="UInt16")], SimTypeInt(signed=False, label="UInt32"), arg_names=["StartPort", "NumberOfPorts"]),
        # 
        'LookupPersistentTcpPortReservation': SimTypeFunction([SimTypeShort(signed=False, label="UInt16"), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["StartPort", "NumberOfPorts", "Token"]),
        # 
        'LookupPersistentUdpPortReservation': SimTypeFunction([SimTypeShort(signed=False, label="UInt16"), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["StartPort", "NumberOfPorts", "Token"]),
        # 
        'PfCreateInterface': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="PFFORWARD_ACTION"), SimTypeInt(signed=False, label="PFFORWARD_ACTION"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["dwName", "inAction", "outAction", "bUseLog", "bMustBeUnique", "ppInterface"]),
        # 
        'PfDeleteInterface': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pInterface"]),
        # 
        'PfAddFiltersToInterface': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwFilterFlags": SimTypeInt(signed=False, label="UInt32"), "dwRule": SimTypeInt(signed=False, label="UInt32"), "pfatType": SimTypeInt(signed=False, label="PFADDRESSTYPE"), "SrcAddr": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SrcMask": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "DstAddr": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "DstMask": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwProtocol": SimTypeInt(signed=False, label="UInt32"), "fLateBound": SimTypeInt(signed=False, label="UInt32"), "wSrcPort": SimTypeShort(signed=False, label="UInt16"), "wDstPort": SimTypeShort(signed=False, label="UInt16"), "wSrcPortHighRange": SimTypeShort(signed=False, label="UInt16"), "wDstPortHighRange": SimTypeShort(signed=False, label="UInt16")}, name="PF_FILTER_DESCRIPTOR", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwFilterFlags": SimTypeInt(signed=False, label="UInt32"), "dwRule": SimTypeInt(signed=False, label="UInt32"), "pfatType": SimTypeInt(signed=False, label="PFADDRESSTYPE"), "SrcAddr": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SrcMask": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "DstAddr": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "DstMask": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwProtocol": SimTypeInt(signed=False, label="UInt32"), "fLateBound": SimTypeInt(signed=False, label="UInt32"), "wSrcPort": SimTypeShort(signed=False, label="UInt16"), "wDstPort": SimTypeShort(signed=False, label="UInt16"), "wSrcPortHighRange": SimTypeShort(signed=False, label="UInt16"), "wDstPortHighRange": SimTypeShort(signed=False, label="UInt16")}, name="PF_FILTER_DESCRIPTOR", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ih", "cInFilters", "pfiltIn", "cOutFilters", "pfiltOut", "pfHandle"]),
        # 
        'PfRemoveFiltersFromInterface': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwFilterFlags": SimTypeInt(signed=False, label="UInt32"), "dwRule": SimTypeInt(signed=False, label="UInt32"), "pfatType": SimTypeInt(signed=False, label="PFADDRESSTYPE"), "SrcAddr": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SrcMask": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "DstAddr": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "DstMask": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwProtocol": SimTypeInt(signed=False, label="UInt32"), "fLateBound": SimTypeInt(signed=False, label="UInt32"), "wSrcPort": SimTypeShort(signed=False, label="UInt16"), "wDstPort": SimTypeShort(signed=False, label="UInt16"), "wSrcPortHighRange": SimTypeShort(signed=False, label="UInt16"), "wDstPortHighRange": SimTypeShort(signed=False, label="UInt16")}, name="PF_FILTER_DESCRIPTOR", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwFilterFlags": SimTypeInt(signed=False, label="UInt32"), "dwRule": SimTypeInt(signed=False, label="UInt32"), "pfatType": SimTypeInt(signed=False, label="PFADDRESSTYPE"), "SrcAddr": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SrcMask": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "DstAddr": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "DstMask": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwProtocol": SimTypeInt(signed=False, label="UInt32"), "fLateBound": SimTypeInt(signed=False, label="UInt32"), "wSrcPort": SimTypeShort(signed=False, label="UInt16"), "wDstPort": SimTypeShort(signed=False, label="UInt16"), "wSrcPortHighRange": SimTypeShort(signed=False, label="UInt16"), "wDstPortHighRange": SimTypeShort(signed=False, label="UInt16")}, name="PF_FILTER_DESCRIPTOR", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ih", "cInFilters", "pfiltIn", "cOutFilters", "pfiltOut"]),
        # 
        'PfRemoveFilterHandles': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pInterface", "cFilters", "pvHandles"]),
        # 
        'PfUnBindInterface': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pInterface"]),
        # 
        'PfBindInterfaceToIndex': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="PFADDRESSTYPE"), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pInterface", "dwIndex", "pfatLinkType", "LinkIPAddress"]),
        # 
        'PfBindInterfaceToIPAddress': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="PFADDRESSTYPE"), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pInterface", "pfatType", "IPAddress"]),
        # 
        'PfRebindFilters': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"SrcAddr": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "DstAddr": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Mask": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="PF_LATEBIND_INFO", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pInterface", "pLateBindInfo"]),
        # 
        'PfAddGlobalFilterToInterface': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="GLOBAL_FILTER")], SimTypeInt(signed=False, label="UInt32"), arg_names=["pInterface", "gfFilter"]),
        # 
        'PfRemoveGlobalFilterFromInterface': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="GLOBAL_FILTER")], SimTypeInt(signed=False, label="UInt32"), arg_names=["pInterface", "gfFilter"]),
        # 
        'PfMakeLog': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hEvent"]),
        # 
        'PfSetLogBuffer': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pbBuffer", "dwSize", "dwThreshold", "dwEntries", "pdwLoggedEntries", "pdwLostEntries", "pdwSizeUsed"]),
        # 
        'PfDeleteLog': SimTypeFunction([], SimTypeInt(signed=False, label="UInt32")),
        # 
        'PfGetInterfaceStatistics': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"pvDriverContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "dwInDrops": SimTypeInt(signed=False, label="UInt32"), "dwOutDrops": SimTypeInt(signed=False, label="UInt32"), "eaInAction": SimTypeInt(signed=False, label="PFFORWARD_ACTION"), "eaOutAction": SimTypeInt(signed=False, label="PFFORWARD_ACTION"), "dwNumInFilters": SimTypeInt(signed=False, label="UInt32"), "dwNumOutFilters": SimTypeInt(signed=False, label="UInt32"), "dwFrag": SimTypeInt(signed=False, label="UInt32"), "dwSpoof": SimTypeInt(signed=False, label="UInt32"), "dwReserved1": SimTypeInt(signed=False, label="UInt32"), "dwReserved2": SimTypeInt(signed=False, label="UInt32"), "liSYN": SimTypeBottom(label="LARGE_INTEGER"), "liTotalLogged": SimTypeBottom(label="LARGE_INTEGER"), "dwLostLogEntries": SimTypeInt(signed=False, label="UInt32"), "FilterInfo": SimTypePointer(SimStruct({"dwNumPacketsFiltered": SimTypeInt(signed=False, label="UInt32"), "info": SimStruct({"dwFilterFlags": SimTypeInt(signed=False, label="UInt32"), "dwRule": SimTypeInt(signed=False, label="UInt32"), "pfatType": SimTypeInt(signed=False, label="PFADDRESSTYPE"), "SrcAddr": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SrcMask": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "DstAddr": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "DstMask": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwProtocol": SimTypeInt(signed=False, label="UInt32"), "fLateBound": SimTypeInt(signed=False, label="UInt32"), "wSrcPort": SimTypeShort(signed=False, label="UInt16"), "wDstPort": SimTypeShort(signed=False, label="UInt16"), "wSrcPortHighRange": SimTypeShort(signed=False, label="UInt16"), "wDstPortHighRange": SimTypeShort(signed=False, label="UInt16")}, name="PF_FILTER_DESCRIPTOR", pack=False, align=None)}, name="PF_FILTER_STATS", pack=False, align=None), offset=0)}, name="PF_INTERFACE_STATS", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["pInterface", "ppfStats", "pdwBufferSize", "fResetCounters"]),
        # 
        'PfTestPacket': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="PFFORWARD_ACTION"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pInInterface", "pOutInterface", "cBytes", "pbPacket", "ppAction"]),
    }

lib.set_prototypes(prototypes)
