# pylint:disable=line-too-long
import logging

from ...sim_type import SimTypeFunction,     SimTypeShort, SimTypeInt, SimTypeLong, SimTypeLongLong, SimTypeDouble, SimTypeFloat,     SimTypePointer,     SimTypeChar,     SimStruct,     SimTypeFixedSizeArray,     SimTypeBottom,     SimUnion,     SimTypeBool
from ...calling_conventions import SimCCStdcall, SimCCMicrosoftAMD64
from .. import SIM_PROCEDURES as P
from . import SimLibrary


_l = logging.getLogger(name=__name__)


lib = SimLibrary()
lib.set_default_cc('X86', SimCCStdcall)
lib.set_default_cc('AMD64', SimCCMicrosoftAMD64)
lib.set_library_names("mfplat.dll")
prototypes = \
    {
        # 
        'MFSerializeAttributesToStream': SimTypeFunction([SimTypeBottom(label="IMFAttributes"), SimTypeInt(signed=False, label="UInt32"), SimTypeBottom(label="IStream")], SimTypeInt(signed=True, label="Int32"), arg_names=["pAttr", "dwOptions", "pStm"]),
        # 
        'MFDeserializeAttributesFromStream': SimTypeFunction([SimTypeBottom(label="IMFAttributes"), SimTypeInt(signed=False, label="UInt32"), SimTypeBottom(label="IStream")], SimTypeInt(signed=True, label="Int32"), arg_names=["pAttr", "dwOptions", "pStm"]),
        # 
        'MFCreateTransformActivate': SimTypeFunction([SimTypePointer(SimTypeBottom(label="IMFActivate"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ppActivate"]),
        # 
        'MFCreateSourceResolver': SimTypeFunction([SimTypePointer(SimTypeBottom(label="IMFSourceResolver"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ppISourceResolver"]),
        # 
        'CreatePropertyStore': SimTypeFunction([SimTypePointer(SimTypeBottom(label="IPropertyStore"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ppStore"]),
        # 
        'MFGetSupportedSchemes': SimTypeFunction([SimTypePointer(SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"vt": SimTypeShort(signed=False, label="UInt16"), "wReserved1": SimTypeShort(signed=False, label="UInt16"), "wReserved2": SimTypeShort(signed=False, label="UInt16"), "wReserved3": SimTypeShort(signed=False, label="UInt16"), "Anonymous": SimUnion({"cVal": SimTypeBottom(label="CHAR"), "bVal": SimTypeChar(label="Byte"), "iVal": SimTypeShort(signed=True, label="Int16"), "uiVal": SimTypeShort(signed=False, label="UInt16"), "lVal": SimTypeInt(signed=True, label="Int32"), "ulVal": SimTypeInt(signed=False, label="UInt32"), "intVal": SimTypeInt(signed=True, label="Int32"), "uintVal": SimTypeInt(signed=False, label="UInt32"), "hVal": SimTypeBottom(label="LARGE_INTEGER"), "uhVal": SimTypeBottom(label="ULARGE_INTEGER"), "fltVal": SimTypeFloat(size=32), "dblVal": SimTypeFloat(size=64), "boolVal": SimTypeShort(signed=True, label="Int16"), "__OBSOLETE__VARIANT_BOOL": SimTypeShort(signed=True, label="Int16"), "scode": SimTypeInt(signed=True, label="Int32"), "cyVal": SimTypeBottom(label="CY"), "date": SimTypeFloat(size=64), "filetime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "puuid": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "pclipdata": SimTypePointer(SimTypeBottom(label="CLIPDATA"), offset=0), "bstrVal": SimTypePointer(SimTypeChar(label="Char"), offset=0), "bstrblobVal": SimTypeBottom(label="BSTRBLOB"), "blob": SimTypeBottom(label="BLOB"), "pszVal": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pwszVal": SimTypePointer(SimTypeChar(label="Char"), offset=0), "punkVal": SimTypeBottom(label="IUnknown"), "pdispVal": SimTypeBottom(label="IDispatch"), "pStream": SimTypeBottom(label="IStream"), "pStorage": SimTypeBottom(label="IStorage"), "pVersionedStream": SimTypePointer(SimStruct({"guidVersion": SimTypeBottom(label="Guid"), "pStream": SimTypeBottom(label="IStream")}, name="VERSIONEDSTREAM", pack=False, align=None), offset=0), "parray": SimTypePointer(SimTypeBottom(label="SAFEARRAY"), offset=0), "cac": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CAC", pack=False, align=None), "caub": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CAUB", pack=False, align=None), "cai": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0)}, name="CAI", pack=False, align=None), "caui": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="CAUI", pack=False, align=None), "cal": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)}, name="CAL", pack=False, align=None), "caul": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="CAUL", pack=False, align=None), "cah": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeBottom(label="LARGE_INTEGER"), offset=0)}, name="CAH", pack=False, align=None), "cauh": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeBottom(label="ULARGE_INTEGER"), offset=0)}, name="CAUH", pack=False, align=None), "caflt": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeFloat(size=32), offset=0)}, name="CAFLT", pack=False, align=None), "cadbl": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeFloat(size=64), offset=0)}, name="CADBL", pack=False, align=None), "cabool": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0)}, name="CABOOL", pack=False, align=None), "cascode": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)}, name="CASCODE", pack=False, align=None), "cacy": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeBottom(label="CY"), offset=0)}, name="CACY", pack=False, align=None), "cadate": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeFloat(size=64), offset=0)}, name="CADATE", pack=False, align=None), "cafiletime": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), offset=0)}, name="CAFILETIME", pack=False, align=None), "cauuid": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="CACLSID", pack=False, align=None), "caclipdata": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeBottom(label="CLIPDATA"), offset=0)}, name="CACLIPDATA", pack=False, align=None), "cabstr": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)}, name="CABSTR", pack=False, align=None), "cabstrblob": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeBottom(label="BSTRBLOB"), offset=0)}, name="CABSTRBLOB", pack=False, align=None), "calpstr": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CALPSTR", pack=False, align=None), "calpwstr": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)}, name="CALPWSTR", pack=False, align=None), "capropvar": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeBottom(label="PROPVARIANT"), offset=0)}, name="CAPROPVARIANT", pack=False, align=None), "pcVal": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pbVal": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "piVal": SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), "puiVal": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "plVal": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), "pulVal": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pintVal": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), "puintVal": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pfltVal": SimTypePointer(SimTypeFloat(size=32), offset=0), "pdblVal": SimTypePointer(SimTypeFloat(size=64), offset=0), "pboolVal": SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), "pdecVal": SimTypePointer(SimTypeBottom(label="DECIMAL"), offset=0), "pscode": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), "pcyVal": SimTypePointer(SimTypeBottom(label="CY"), offset=0), "pdate": SimTypePointer(SimTypeFloat(size=64), offset=0), "pbstrVal": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), "ppunkVal": SimTypePointer(SimTypeBottom(label="IUnknown"), offset=0), "ppdispVal": SimTypePointer(SimTypeBottom(label="IDispatch"), offset=0), "pparray": SimTypePointer(SimTypePointer(SimTypeBottom(label="SAFEARRAY"), offset=0), offset=0), "pvarVal": SimTypePointer(SimTypeBottom(label="PROPVARIANT"), offset=0)}, name="<anon>", label="None")}, name="_Anonymous_e__Struct", pack=False, align=None), "decVal": SimTypeBottom(label="DECIMAL")}, name="<anon>", label="None")}, name="PROPVARIANT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pPropVarSchemeArray"]),
        # 
        'MFGetSupportedMimeTypes': SimTypeFunction([SimTypePointer(SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"vt": SimTypeShort(signed=False, label="UInt16"), "wReserved1": SimTypeShort(signed=False, label="UInt16"), "wReserved2": SimTypeShort(signed=False, label="UInt16"), "wReserved3": SimTypeShort(signed=False, label="UInt16"), "Anonymous": SimUnion({"cVal": SimTypeBottom(label="CHAR"), "bVal": SimTypeChar(label="Byte"), "iVal": SimTypeShort(signed=True, label="Int16"), "uiVal": SimTypeShort(signed=False, label="UInt16"), "lVal": SimTypeInt(signed=True, label="Int32"), "ulVal": SimTypeInt(signed=False, label="UInt32"), "intVal": SimTypeInt(signed=True, label="Int32"), "uintVal": SimTypeInt(signed=False, label="UInt32"), "hVal": SimTypeBottom(label="LARGE_INTEGER"), "uhVal": SimTypeBottom(label="ULARGE_INTEGER"), "fltVal": SimTypeFloat(size=32), "dblVal": SimTypeFloat(size=64), "boolVal": SimTypeShort(signed=True, label="Int16"), "__OBSOLETE__VARIANT_BOOL": SimTypeShort(signed=True, label="Int16"), "scode": SimTypeInt(signed=True, label="Int32"), "cyVal": SimTypeBottom(label="CY"), "date": SimTypeFloat(size=64), "filetime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "puuid": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "pclipdata": SimTypePointer(SimTypeBottom(label="CLIPDATA"), offset=0), "bstrVal": SimTypePointer(SimTypeChar(label="Char"), offset=0), "bstrblobVal": SimTypeBottom(label="BSTRBLOB"), "blob": SimTypeBottom(label="BLOB"), "pszVal": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pwszVal": SimTypePointer(SimTypeChar(label="Char"), offset=0), "punkVal": SimTypeBottom(label="IUnknown"), "pdispVal": SimTypeBottom(label="IDispatch"), "pStream": SimTypeBottom(label="IStream"), "pStorage": SimTypeBottom(label="IStorage"), "pVersionedStream": SimTypePointer(SimStruct({"guidVersion": SimTypeBottom(label="Guid"), "pStream": SimTypeBottom(label="IStream")}, name="VERSIONEDSTREAM", pack=False, align=None), offset=0), "parray": SimTypePointer(SimTypeBottom(label="SAFEARRAY"), offset=0), "cac": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CAC", pack=False, align=None), "caub": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CAUB", pack=False, align=None), "cai": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0)}, name="CAI", pack=False, align=None), "caui": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="CAUI", pack=False, align=None), "cal": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)}, name="CAL", pack=False, align=None), "caul": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="CAUL", pack=False, align=None), "cah": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeBottom(label="LARGE_INTEGER"), offset=0)}, name="CAH", pack=False, align=None), "cauh": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeBottom(label="ULARGE_INTEGER"), offset=0)}, name="CAUH", pack=False, align=None), "caflt": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeFloat(size=32), offset=0)}, name="CAFLT", pack=False, align=None), "cadbl": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeFloat(size=64), offset=0)}, name="CADBL", pack=False, align=None), "cabool": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0)}, name="CABOOL", pack=False, align=None), "cascode": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)}, name="CASCODE", pack=False, align=None), "cacy": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeBottom(label="CY"), offset=0)}, name="CACY", pack=False, align=None), "cadate": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeFloat(size=64), offset=0)}, name="CADATE", pack=False, align=None), "cafiletime": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), offset=0)}, name="CAFILETIME", pack=False, align=None), "cauuid": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="CACLSID", pack=False, align=None), "caclipdata": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeBottom(label="CLIPDATA"), offset=0)}, name="CACLIPDATA", pack=False, align=None), "cabstr": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)}, name="CABSTR", pack=False, align=None), "cabstrblob": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeBottom(label="BSTRBLOB"), offset=0)}, name="CABSTRBLOB", pack=False, align=None), "calpstr": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CALPSTR", pack=False, align=None), "calpwstr": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)}, name="CALPWSTR", pack=False, align=None), "capropvar": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeBottom(label="PROPVARIANT"), offset=0)}, name="CAPROPVARIANT", pack=False, align=None), "pcVal": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pbVal": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "piVal": SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), "puiVal": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "plVal": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), "pulVal": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pintVal": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), "puintVal": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pfltVal": SimTypePointer(SimTypeFloat(size=32), offset=0), "pdblVal": SimTypePointer(SimTypeFloat(size=64), offset=0), "pboolVal": SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), "pdecVal": SimTypePointer(SimTypeBottom(label="DECIMAL"), offset=0), "pscode": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), "pcyVal": SimTypePointer(SimTypeBottom(label="CY"), offset=0), "pdate": SimTypePointer(SimTypeFloat(size=64), offset=0), "pbstrVal": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), "ppunkVal": SimTypePointer(SimTypeBottom(label="IUnknown"), offset=0), "ppdispVal": SimTypePointer(SimTypeBottom(label="IDispatch"), offset=0), "pparray": SimTypePointer(SimTypePointer(SimTypeBottom(label="SAFEARRAY"), offset=0), offset=0), "pvarVal": SimTypePointer(SimTypeBottom(label="PROPVARIANT"), offset=0)}, name="<anon>", label="None")}, name="_Anonymous_e__Struct", pack=False, align=None), "decVal": SimTypeBottom(label="DECIMAL")}, name="<anon>", label="None")}, name="PROPVARIANT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pPropVarMimeTypeArray"]),
        # 
        'MFGetSystemTime': SimTypeFunction([], SimTypeLongLong(signed=True, label="Int64")),
        # 
        'MFCreateSystemTimeSource': SimTypeFunction([SimTypePointer(SimTypeBottom(label="IMFPresentationTimeSource"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ppSystemTimeSource"]),
        # 
        'MFCreatePresentationDescriptor': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="IMFStreamDescriptor"), label="LPArray", offset=0), SimTypePointer(SimTypeBottom(label="IMFPresentationDescriptor"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["cStreamDescriptors", "apStreamDescriptors", "ppPresentationDescriptor"]),
        # 
        'MFSerializePresentationDescriptor': SimTypeFunction([SimTypeBottom(label="IMFPresentationDescriptor"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pPD", "pcbData", "ppbData"]),
        # 
        'MFDeserializePresentationDescriptor': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypePointer(SimTypeBottom(label="IMFPresentationDescriptor"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["cbData", "pbData", "ppPD"]),
        # 
        'MFCreateStreamDescriptor': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="IMFMediaType"), label="LPArray", offset=0), SimTypePointer(SimTypeBottom(label="IMFStreamDescriptor"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwStreamIdentifier", "cMediaTypes", "apMediaTypes", "ppDescriptor"]),
        # 
        'MFCreateTrackedSample': SimTypeFunction([SimTypePointer(SimTypeBottom(label="IMFTrackedSample"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ppMFSample"]),
        # 
        'MFCreateMFByteStreamOnStream': SimTypeFunction([SimTypeBottom(label="IStream"), SimTypePointer(SimTypeBottom(label="IMFByteStream"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pStream", "ppByteStream"]),
        # 
        'MFCreateStreamOnMFByteStream': SimTypeFunction([SimTypeBottom(label="IMFByteStream"), SimTypePointer(SimTypeBottom(label="IStream"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pByteStream", "ppStream"]),
        # 
        'MFCreateMFByteStreamOnStreamEx': SimTypeFunction([SimTypeBottom(label="IUnknown"), SimTypePointer(SimTypeBottom(label="IMFByteStream"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["punkStream", "ppByteStream"]),
        # 
        'MFCreateStreamOnMFByteStreamEx': SimTypeFunction([SimTypeBottom(label="IMFByteStream"), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pByteStream", "riid", "ppv"]),
        # 
        'MFCreateMediaTypeFromProperties': SimTypeFunction([SimTypeBottom(label="IUnknown"), SimTypePointer(SimTypeBottom(label="IMFMediaType"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["punkStream", "ppMediaType"]),
        # 
        'MFCreatePropertiesFromMediaType': SimTypeFunction([SimTypeBottom(label="IMFMediaType"), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pMediaType", "riid", "ppv"]),
        # 
        'MFCreateContentProtectionDevice': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="IMFContentProtectionDevice"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ProtectionSystemId", "ContentProtectionDevice"]),
        # 
        'MFIsContentProtectionDeviceSupported': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ProtectionSystemId", "isSupported"]),
        # 
        'MFCreateContentDecryptorContext': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeBottom(label="IMFDXGIDeviceManager"), SimTypeBottom(label="IMFContentProtectionDevice"), SimTypePointer(SimTypeBottom(label="IMFContentDecryptorContext"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["guidMediaProtectionSystemId", "pD3DManager", "pContentProtectionDevice", "ppContentDecryptorContext"]),
        # 
        'MFStartup': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["Version", "dwFlags"]),
        # 
        'MFShutdown': SimTypeFunction([], SimTypeInt(signed=True, label="Int32")),
        # 
        'MFLockPlatform': SimTypeFunction([], SimTypeInt(signed=True, label="Int32")),
        # 
        'MFUnlockPlatform': SimTypeFunction([], SimTypeInt(signed=True, label="Int32")),
        # 
        'MFPutWorkItem': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeBottom(label="IMFAsyncCallback"), SimTypeBottom(label="IUnknown")], SimTypeInt(signed=True, label="Int32"), arg_names=["dwQueue", "pCallback", "pState"]),
        # 
        'MFPutWorkItem2': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=True, label="Int32"), SimTypeBottom(label="IMFAsyncCallback"), SimTypeBottom(label="IUnknown")], SimTypeInt(signed=True, label="Int32"), arg_names=["dwQueue", "Priority", "pCallback", "pState"]),
        # 
        'MFPutWorkItemEx': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeBottom(label="IMFAsyncResult")], SimTypeInt(signed=True, label="Int32"), arg_names=["dwQueue", "pResult"]),
        # 
        'MFPutWorkItemEx2': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=True, label="Int32"), SimTypeBottom(label="IMFAsyncResult")], SimTypeInt(signed=True, label="Int32"), arg_names=["dwQueue", "Priority", "pResult"]),
        # 
        'MFPutWaitingWorkItem': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeBottom(label="IMFAsyncResult"), SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hEvent", "Priority", "pResult", "pKey"]),
        # 
        'MFAllocateSerialWorkQueue': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwWorkQueue", "pdwWorkQueue"]),
        # 
        'MFScheduleWorkItemEx': SimTypeFunction([SimTypeBottom(label="IMFAsyncResult"), SimTypeLongLong(signed=True, label="Int64"), SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pResult", "Timeout", "pKey"]),
        # 
        'MFScheduleWorkItem': SimTypeFunction([SimTypeBottom(label="IMFAsyncCallback"), SimTypeBottom(label="IUnknown"), SimTypeLongLong(signed=True, label="Int64"), SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pCallback", "pState", "Timeout", "pKey"]),
        # 
        'MFCancelWorkItem': SimTypeFunction([SimTypeLongLong(signed=False, label="UInt64")], SimTypeInt(signed=True, label="Int32"), arg_names=["Key"]),
        # 
        'MFGetTimerPeriodicity': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Periodicity"]),
        # 
        'MFAddPeriodicCallback': SimTypeFunction([SimTypePointer(SimTypeFunction([SimTypeBottom(label="IUnknown")], SimTypeBottom(label="Void"), arg_names=["pContext"]), offset=0), SimTypeBottom(label="IUnknown"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Callback", "pContext", "pdwKey"]),
        # 
        'MFRemovePeriodicCallback': SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["dwKey"]),
        # 
        'MFAllocateWorkQueueEx': SimTypeFunction([SimTypeInt(signed=False, label="MFASYNC_WORKQUEUE_TYPE"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["WorkQueueType", "pdwWorkQueue"]),
        # 
        'MFAllocateWorkQueue': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pdwWorkQueue"]),
        # 
        'MFLockWorkQueue': SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["dwWorkQueue"]),
        # 
        'MFUnlockWorkQueue': SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["dwWorkQueue"]),
        # 
        'MFBeginRegisterWorkQueueWithMMCSS': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeBottom(label="IMFAsyncCallback"), SimTypeBottom(label="IUnknown")], SimTypeInt(signed=True, label="Int32"), arg_names=["dwWorkQueueId", "wszClass", "dwTaskId", "pDoneCallback", "pDoneState"]),
        # 
        'MFBeginRegisterWorkQueueWithMMCSSEx': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=True, label="Int32"), SimTypeBottom(label="IMFAsyncCallback"), SimTypeBottom(label="IUnknown")], SimTypeInt(signed=True, label="Int32"), arg_names=["dwWorkQueueId", "wszClass", "dwTaskId", "lPriority", "pDoneCallback", "pDoneState"]),
        # 
        'MFEndRegisterWorkQueueWithMMCSS': SimTypeFunction([SimTypeBottom(label="IMFAsyncResult"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pResult", "pdwTaskId"]),
        # 
        'MFBeginUnregisterWorkQueueWithMMCSS': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeBottom(label="IMFAsyncCallback"), SimTypeBottom(label="IUnknown")], SimTypeInt(signed=True, label="Int32"), arg_names=["dwWorkQueueId", "pDoneCallback", "pDoneState"]),
        # 
        'MFEndUnregisterWorkQueueWithMMCSS': SimTypeFunction([SimTypeBottom(label="IMFAsyncResult")], SimTypeInt(signed=True, label="Int32"), arg_names=["pResult"]),
        # 
        'MFGetWorkQueueMMCSSClass': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwWorkQueueId", "pwszClass", "pcchClass"]),
        # 
        'MFGetWorkQueueMMCSSTaskId': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwWorkQueueId", "pdwTaskId"]),
        # 
        'MFRegisterPlatformWithMMCSS': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["wszClass", "pdwTaskId", "lPriority"]),
        # 
        'MFUnregisterPlatformFromMMCSS': SimTypeFunction([], SimTypeInt(signed=True, label="Int32")),
        # 
        'MFLockSharedWorkQueue': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["wszClass", "BasePriority", "pdwTaskId", "pID"]),
        # 
        'MFGetWorkQueueMMCSSPriority': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwWorkQueueId", "lPriority"]),
        # 
        'MFCreateAsyncResult': SimTypeFunction([SimTypeBottom(label="IUnknown"), SimTypeBottom(label="IMFAsyncCallback"), SimTypeBottom(label="IUnknown"), SimTypePointer(SimTypeBottom(label="IMFAsyncResult"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["punkObject", "pCallback", "punkState", "ppAsyncResult"]),
        # 
        'MFInvokeCallback': SimTypeFunction([SimTypeBottom(label="IMFAsyncResult")], SimTypeInt(signed=True, label="Int32"), arg_names=["pAsyncResult"]),
        # 
        'MFCreateFile': SimTypeFunction([SimTypeInt(signed=False, label="MF_FILE_ACCESSMODE"), SimTypeInt(signed=False, label="MF_FILE_OPENMODE"), SimTypeInt(signed=False, label="MF_FILE_FLAGS"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeBottom(label="IMFByteStream"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["AccessMode", "OpenMode", "fFlags", "pwszFileURL", "ppIByteStream"]),
        # 
        'MFCreateTempFile': SimTypeFunction([SimTypeInt(signed=False, label="MF_FILE_ACCESSMODE"), SimTypeInt(signed=False, label="MF_FILE_OPENMODE"), SimTypeInt(signed=False, label="MF_FILE_FLAGS"), SimTypePointer(SimTypeBottom(label="IMFByteStream"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["AccessMode", "OpenMode", "fFlags", "ppIByteStream"]),
        # 
        'MFBeginCreateFile': SimTypeFunction([SimTypeInt(signed=False, label="MF_FILE_ACCESSMODE"), SimTypeInt(signed=False, label="MF_FILE_OPENMODE"), SimTypeInt(signed=False, label="MF_FILE_FLAGS"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeBottom(label="IMFAsyncCallback"), SimTypeBottom(label="IUnknown"), SimTypePointer(SimTypeBottom(label="IUnknown"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["AccessMode", "OpenMode", "fFlags", "pwszFilePath", "pCallback", "pState", "ppCancelCookie"]),
        # 
        'MFEndCreateFile': SimTypeFunction([SimTypeBottom(label="IMFAsyncResult"), SimTypePointer(SimTypeBottom(label="IMFByteStream"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pResult", "ppFile"]),
        # 
        'MFCancelCreateFile': SimTypeFunction([SimTypeBottom(label="IUnknown")], SimTypeInt(signed=True, label="Int32"), arg_names=["pCancelCookie"]),
        # 
        'MFCreateMemoryBuffer': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="IMFMediaBuffer"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["cbMaxLength", "ppBuffer"]),
        # 
        'MFCreateMediaBufferWrapper': SimTypeFunction([SimTypeBottom(label="IMFMediaBuffer"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="IMFMediaBuffer"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pBuffer", "cbOffset", "dwLength", "ppBuffer"]),
        # 
        'MFCreateLegacyMediaBufferOnMFMediaBuffer': SimTypeFunction([SimTypeBottom(label="IMFSample"), SimTypeBottom(label="IMFMediaBuffer"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="IMediaBuffer"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pSample", "pMFMediaBuffer", "cbOffset", "ppMediaBuffer"]),
        # 
        'MFMapDX9FormatToDXGIFormat': SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="DXGI_FORMAT"), arg_names=["dx9"]),
        # 
        'MFMapDXGIFormatToDX9Format': SimTypeFunction([SimTypeInt(signed=False, label="DXGI_FORMAT")], SimTypeInt(signed=False, label="UInt32"), arg_names=["dx11"]),
        # 
        'MFLockDXGIDeviceManager': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeBottom(label="IMFDXGIDeviceManager"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pResetToken", "ppManager"]),
        # 
        'MFUnlockDXGIDeviceManager': SimTypeFunction([], SimTypeInt(signed=True, label="Int32")),
        # 
        'MFCreateDXSurfaceBuffer': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeBottom(label="IUnknown"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeBottom(label="IMFMediaBuffer"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["riid", "punkSurface", "fBottomUpWhenLinear", "ppBuffer"]),
        # 
        'MFCreateWICBitmapBuffer': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeBottom(label="IUnknown"), SimTypePointer(SimTypeBottom(label="IMFMediaBuffer"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["riid", "punkSurface", "ppBuffer"]),
        # 
        'MFCreateDXGISurfaceBuffer': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeBottom(label="IUnknown"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeBottom(label="IMFMediaBuffer"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["riid", "punkSurface", "uSubresourceIndex", "fBottomUpWhenLinear", "ppBuffer"]),
        # 
        'MFCreateVideoSampleAllocatorEx': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["riid", "ppSampleAllocator"]),
        # 
        'MFCreateDXGIDeviceManager': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeBottom(label="IMFDXGIDeviceManager"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["resetToken", "ppDeviceManager"]),
        # 
        'MFCreateAlignedMemoryBuffer': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="IMFMediaBuffer"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["cbMaxLength", "cbAligment", "ppBuffer"]),
        # 
        'MFCreateMediaEvent': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"vt": SimTypeShort(signed=False, label="UInt16"), "wReserved1": SimTypeShort(signed=False, label="UInt16"), "wReserved2": SimTypeShort(signed=False, label="UInt16"), "wReserved3": SimTypeShort(signed=False, label="UInt16"), "Anonymous": SimUnion({"cVal": SimTypeBottom(label="CHAR"), "bVal": SimTypeChar(label="Byte"), "iVal": SimTypeShort(signed=True, label="Int16"), "uiVal": SimTypeShort(signed=False, label="UInt16"), "lVal": SimTypeInt(signed=True, label="Int32"), "ulVal": SimTypeInt(signed=False, label="UInt32"), "intVal": SimTypeInt(signed=True, label="Int32"), "uintVal": SimTypeInt(signed=False, label="UInt32"), "hVal": SimTypeBottom(label="LARGE_INTEGER"), "uhVal": SimTypeBottom(label="ULARGE_INTEGER"), "fltVal": SimTypeFloat(size=32), "dblVal": SimTypeFloat(size=64), "boolVal": SimTypeShort(signed=True, label="Int16"), "__OBSOLETE__VARIANT_BOOL": SimTypeShort(signed=True, label="Int16"), "scode": SimTypeInt(signed=True, label="Int32"), "cyVal": SimTypeBottom(label="CY"), "date": SimTypeFloat(size=64), "filetime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "puuid": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "pclipdata": SimTypePointer(SimTypeBottom(label="CLIPDATA"), offset=0), "bstrVal": SimTypePointer(SimTypeChar(label="Char"), offset=0), "bstrblobVal": SimTypeBottom(label="BSTRBLOB"), "blob": SimTypeBottom(label="BLOB"), "pszVal": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pwszVal": SimTypePointer(SimTypeChar(label="Char"), offset=0), "punkVal": SimTypeBottom(label="IUnknown"), "pdispVal": SimTypeBottom(label="IDispatch"), "pStream": SimTypeBottom(label="IStream"), "pStorage": SimTypeBottom(label="IStorage"), "pVersionedStream": SimTypePointer(SimStruct({"guidVersion": SimTypeBottom(label="Guid"), "pStream": SimTypeBottom(label="IStream")}, name="VERSIONEDSTREAM", pack=False, align=None), offset=0), "parray": SimTypePointer(SimTypeBottom(label="SAFEARRAY"), offset=0), "cac": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CAC", pack=False, align=None), "caub": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CAUB", pack=False, align=None), "cai": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0)}, name="CAI", pack=False, align=None), "caui": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="CAUI", pack=False, align=None), "cal": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)}, name="CAL", pack=False, align=None), "caul": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="CAUL", pack=False, align=None), "cah": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeBottom(label="LARGE_INTEGER"), offset=0)}, name="CAH", pack=False, align=None), "cauh": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeBottom(label="ULARGE_INTEGER"), offset=0)}, name="CAUH", pack=False, align=None), "caflt": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeFloat(size=32), offset=0)}, name="CAFLT", pack=False, align=None), "cadbl": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeFloat(size=64), offset=0)}, name="CADBL", pack=False, align=None), "cabool": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0)}, name="CABOOL", pack=False, align=None), "cascode": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)}, name="CASCODE", pack=False, align=None), "cacy": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeBottom(label="CY"), offset=0)}, name="CACY", pack=False, align=None), "cadate": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeFloat(size=64), offset=0)}, name="CADATE", pack=False, align=None), "cafiletime": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), offset=0)}, name="CAFILETIME", pack=False, align=None), "cauuid": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="CACLSID", pack=False, align=None), "caclipdata": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeBottom(label="CLIPDATA"), offset=0)}, name="CACLIPDATA", pack=False, align=None), "cabstr": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)}, name="CABSTR", pack=False, align=None), "cabstrblob": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeBottom(label="BSTRBLOB"), offset=0)}, name="CABSTRBLOB", pack=False, align=None), "calpstr": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CALPSTR", pack=False, align=None), "calpwstr": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)}, name="CALPWSTR", pack=False, align=None), "capropvar": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeBottom(label="PROPVARIANT"), offset=0)}, name="CAPROPVARIANT", pack=False, align=None), "pcVal": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pbVal": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "piVal": SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), "puiVal": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "plVal": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), "pulVal": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pintVal": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), "puintVal": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pfltVal": SimTypePointer(SimTypeFloat(size=32), offset=0), "pdblVal": SimTypePointer(SimTypeFloat(size=64), offset=0), "pboolVal": SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), "pdecVal": SimTypePointer(SimTypeBottom(label="DECIMAL"), offset=0), "pscode": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), "pcyVal": SimTypePointer(SimTypeBottom(label="CY"), offset=0), "pdate": SimTypePointer(SimTypeFloat(size=64), offset=0), "pbstrVal": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), "ppunkVal": SimTypePointer(SimTypeBottom(label="IUnknown"), offset=0), "ppdispVal": SimTypePointer(SimTypeBottom(label="IDispatch"), offset=0), "pparray": SimTypePointer(SimTypePointer(SimTypeBottom(label="SAFEARRAY"), offset=0), offset=0), "pvarVal": SimTypePointer(SimTypeBottom(label="PROPVARIANT"), offset=0)}, name="<anon>", label="None")}, name="_Anonymous_e__Struct", pack=False, align=None), "decVal": SimTypeBottom(label="DECIMAL")}, name="<anon>", label="None")}, name="PROPVARIANT", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="IMFMediaEvent"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["met", "guidExtendedType", "hrStatus", "pvValue", "ppEvent"]),
        # 
        'MFCreateEventQueue': SimTypeFunction([SimTypePointer(SimTypeBottom(label="IMFMediaEventQueue"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ppMediaEventQueue"]),
        # 
        'MFCreateSample': SimTypeFunction([SimTypePointer(SimTypeBottom(label="IMFSample"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ppIMFSample"]),
        # 
        'MFCreateAttributes': SimTypeFunction([SimTypePointer(SimTypeBottom(label="IMFAttributes"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["ppMFAttributes", "cInitialSize"]),
        # 
        'MFInitAttributesFromBlob': SimTypeFunction([SimTypeBottom(label="IMFAttributes"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pAttributes", "pBuf", "cbBufSize"]),
        # 
        'MFGetAttributesAsBlobSize': SimTypeFunction([SimTypeBottom(label="IMFAttributes"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pAttributes", "pcbBufSize"]),
        # 
        'MFGetAttributesAsBlob': SimTypeFunction([SimTypeBottom(label="IMFAttributes"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pAttributes", "pBuf", "cbBufSize"]),
        # 
        'MFTRegister': SimTypeFunction([SimTypeBottom(label="Guid"), SimTypeBottom(label="Guid"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"guidMajorType": SimTypeBottom(label="Guid"), "guidSubtype": SimTypeBottom(label="Guid")}, name="MFT_REGISTER_TYPE_INFO", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"guidMajorType": SimTypeBottom(label="Guid"), "guidSubtype": SimTypeBottom(label="Guid")}, name="MFT_REGISTER_TYPE_INFO", pack=False, align=None), label="LPArray", offset=0), SimTypeBottom(label="IMFAttributes")], SimTypeInt(signed=True, label="Int32"), arg_names=["clsidMFT", "guidCategory", "pszName", "Flags", "cInputTypes", "pInputTypes", "cOutputTypes", "pOutputTypes", "pAttributes"]),
        # 
        'MFTUnregister': SimTypeFunction([SimTypeBottom(label="Guid")], SimTypeInt(signed=True, label="Int32"), arg_names=["clsidMFT"]),
        # 
        'MFTRegisterLocal': SimTypeFunction([SimTypeBottom(label="IClassFactory"), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"guidMajorType": SimTypeBottom(label="Guid"), "guidSubtype": SimTypeBottom(label="Guid")}, name="MFT_REGISTER_TYPE_INFO", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"guidMajorType": SimTypeBottom(label="Guid"), "guidSubtype": SimTypeBottom(label="Guid")}, name="MFT_REGISTER_TYPE_INFO", pack=False, align=None), label="LPArray", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pClassFactory", "guidCategory", "pszName", "Flags", "cInputTypes", "pInputTypes", "cOutputTypes", "pOutputTypes"]),
        # 
        'MFTUnregisterLocal': SimTypeFunction([SimTypeBottom(label="IClassFactory")], SimTypeInt(signed=True, label="Int32"), arg_names=["pClassFactory"]),
        # 
        'MFTRegisterLocalByCLSID': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"guidMajorType": SimTypeBottom(label="Guid"), "guidSubtype": SimTypeBottom(label="Guid")}, name="MFT_REGISTER_TYPE_INFO", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"guidMajorType": SimTypeBottom(label="Guid"), "guidSubtype": SimTypeBottom(label="Guid")}, name="MFT_REGISTER_TYPE_INFO", pack=False, align=None), label="LPArray", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["clisdMFT", "guidCategory", "pszName", "Flags", "cInputTypes", "pInputTypes", "cOutputTypes", "pOutputTypes"]),
        # 
        'MFTUnregisterLocalByCLSID': SimTypeFunction([SimTypeBottom(label="Guid")], SimTypeInt(signed=True, label="Int32"), arg_names=["clsidMFT"]),
        # 
        'MFTEnum': SimTypeFunction([SimTypeBottom(label="Guid"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"guidMajorType": SimTypeBottom(label="Guid"), "guidSubtype": SimTypeBottom(label="Guid")}, name="MFT_REGISTER_TYPE_INFO", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"guidMajorType": SimTypeBottom(label="Guid"), "guidSubtype": SimTypeBottom(label="Guid")}, name="MFT_REGISTER_TYPE_INFO", pack=False, align=None), offset=0), SimTypeBottom(label="IMFAttributes"), SimTypePointer(SimTypePointer(SimTypeBottom(label="Guid"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["guidCategory", "Flags", "pInputType", "pOutputType", "pAttributes", "ppclsidMFT", "pcMFTs"]),
        # 
        'MFTEnumEx': SimTypeFunction([SimTypeBottom(label="Guid"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"guidMajorType": SimTypeBottom(label="Guid"), "guidSubtype": SimTypeBottom(label="Guid")}, name="MFT_REGISTER_TYPE_INFO", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"guidMajorType": SimTypeBottom(label="Guid"), "guidSubtype": SimTypeBottom(label="Guid")}, name="MFT_REGISTER_TYPE_INFO", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="IMFActivate"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["guidCategory", "Flags", "pInputType", "pOutputType", "pppMFTActivate", "pnumMFTActivate"]),
        # 
        'MFTEnum2': SimTypeFunction([SimTypeBottom(label="Guid"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"guidMajorType": SimTypeBottom(label="Guid"), "guidSubtype": SimTypeBottom(label="Guid")}, name="MFT_REGISTER_TYPE_INFO", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"guidMajorType": SimTypeBottom(label="Guid"), "guidSubtype": SimTypeBottom(label="Guid")}, name="MFT_REGISTER_TYPE_INFO", pack=False, align=None), offset=0), SimTypeBottom(label="IMFAttributes"), SimTypePointer(SimTypePointer(SimTypeBottom(label="IMFActivate"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["guidCategory", "Flags", "pInputType", "pOutputType", "pAttributes", "pppMFTActivate", "pnumMFTActivate"]),
        # 
        'MFTGetInfo': SimTypeFunction([SimTypeBottom(label="Guid"), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), SimTypePointer(SimTypePointer(SimStruct({"guidMajorType": SimTypeBottom(label="Guid"), "guidSubtype": SimTypeBottom(label="Guid")}, name="MFT_REGISTER_TYPE_INFO", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"guidMajorType": SimTypeBottom(label="Guid"), "guidSubtype": SimTypeBottom(label="Guid")}, name="MFT_REGISTER_TYPE_INFO", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeBottom(label="IMFAttributes"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["clsidMFT", "pszName", "ppInputTypes", "pcInputTypes", "ppOutputTypes", "pcOutputTypes", "ppAttributes"]),
        # 
        'MFGetPluginControl': SimTypeFunction([SimTypePointer(SimTypeBottom(label="IMFPluginControl"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ppPluginControl"]),
        # 
        'MFGetMFTMerit': SimTypeFunction([SimTypeBottom(label="IUnknown"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pMFT", "cbVerifier", "verifier", "merit"]),
        # 
        'MFRegisterLocalSchemeHandler': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeBottom(label="IMFActivate")], SimTypeInt(signed=True, label="Int32"), arg_names=["szScheme", "pActivate"]),
        # 
        'MFRegisterLocalByteStreamHandler': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeBottom(label="IMFActivate")], SimTypeInt(signed=True, label="Int32"), arg_names=["szFileExtension", "szMimeType", "pActivate"]),
        # 
        'MFCreateMFByteStreamWrapper': SimTypeFunction([SimTypeBottom(label="IMFByteStream"), SimTypePointer(SimTypeBottom(label="IMFByteStream"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pStream", "ppStreamWrapper"]),
        # 
        'MFCreateMediaExtensionActivate': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeBottom(label="IUnknown"), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["szActivatableClassId", "pConfiguration", "riid", "ppvObject"]),
        # 
        'MFCreateMuxStreamAttributes': SimTypeFunction([SimTypeBottom(label="IMFCollection"), SimTypePointer(SimTypeBottom(label="IMFAttributes"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pAttributesToMux", "ppMuxAttribs"]),
        # 
        'MFCreateMuxStreamMediaType': SimTypeFunction([SimTypeBottom(label="IMFCollection"), SimTypePointer(SimTypeBottom(label="IMFMediaType"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pMediaTypesToMux", "ppMuxMediaType"]),
        # 
        'MFCreateMuxStreamSample': SimTypeFunction([SimTypeBottom(label="IMFCollection"), SimTypePointer(SimTypeBottom(label="IMFSample"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pSamplesToMux", "ppMuxSample"]),
        # 
        'MFValidateMediaTypeSize': SimTypeFunction([SimTypeBottom(label="Guid"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["FormatType", "pBlock", "cbSize"]),
        # 
        'MFCreateMediaType': SimTypeFunction([SimTypePointer(SimTypeBottom(label="IMFMediaType"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ppMFType"]),
        # 
        'MFCreateMFVideoFormatFromMFMediaType': SimTypeFunction([SimTypeBottom(label="IMFMediaType"), SimTypePointer(SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "videoInfo": SimStruct({"dwWidth": SimTypeInt(signed=False, label="UInt32"), "dwHeight": SimTypeInt(signed=False, label="UInt32"), "PixelAspectRatio": SimStruct({"Numerator": SimTypeInt(signed=False, label="UInt32"), "Denominator": SimTypeInt(signed=False, label="UInt32")}, name="MFRatio", pack=False, align=None), "SourceChromaSubsampling": SimTypeInt(signed=False, label="MFVideoChromaSubsampling"), "InterlaceMode": SimTypeInt(signed=False, label="MFVideoInterlaceMode"), "TransferFunction": SimTypeInt(signed=False, label="MFVideoTransferFunction"), "ColorPrimaries": SimTypeInt(signed=False, label="MFVideoPrimaries"), "TransferMatrix": SimTypeInt(signed=False, label="MFVideoTransferMatrix"), "SourceLighting": SimTypeInt(signed=False, label="MFVideoLighting"), "FramesPerSecond": SimStruct({"Numerator": SimTypeInt(signed=False, label="UInt32"), "Denominator": SimTypeInt(signed=False, label="UInt32")}, name="MFRatio", pack=False, align=None), "NominalRange": SimTypeInt(signed=False, label="MFNominalRange"), "GeometricAperture": SimStruct({"OffsetX": SimStruct({"fract": SimTypeShort(signed=False, label="UInt16"), "value": SimTypeShort(signed=True, label="Int16")}, name="MFOffset", pack=False, align=None), "OffsetY": SimStruct({"fract": SimTypeShort(signed=False, label="UInt16"), "value": SimTypeShort(signed=True, label="Int16")}, name="MFOffset", pack=False, align=None), "Area": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None)}, name="MFVideoArea", pack=False, align=None), "MinimumDisplayAperture": SimStruct({"OffsetX": SimStruct({"fract": SimTypeShort(signed=False, label="UInt16"), "value": SimTypeShort(signed=True, label="Int16")}, name="MFOffset", pack=False, align=None), "OffsetY": SimStruct({"fract": SimTypeShort(signed=False, label="UInt16"), "value": SimTypeShort(signed=True, label="Int16")}, name="MFOffset", pack=False, align=None), "Area": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None)}, name="MFVideoArea", pack=False, align=None), "PanScanAperture": SimStruct({"OffsetX": SimStruct({"fract": SimTypeShort(signed=False, label="UInt16"), "value": SimTypeShort(signed=True, label="Int16")}, name="MFOffset", pack=False, align=None), "OffsetY": SimStruct({"fract": SimTypeShort(signed=False, label="UInt16"), "value": SimTypeShort(signed=True, label="Int16")}, name="MFOffset", pack=False, align=None), "Area": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None)}, name="MFVideoArea", pack=False, align=None), "VideoFlags": SimTypeLongLong(signed=False, label="UInt64")}, name="MFVideoInfo", pack=False, align=None), "guidFormat": SimTypeBottom(label="Guid"), "compressedInfo": SimStruct({"AvgBitrate": SimTypeLongLong(signed=True, label="Int64"), "AvgBitErrorRate": SimTypeLongLong(signed=True, label="Int64"), "MaxKeyFrameSpacing": SimTypeInt(signed=False, label="UInt32")}, name="MFVideoCompressedInfo", pack=False, align=None), "surfaceInfo": SimStruct({"Format": SimTypeInt(signed=False, label="UInt32"), "PaletteEntries": SimTypeInt(signed=False, label="UInt32"), "Palette": SimTypePointer(SimUnion({"ARGB": SimStruct({"rgbBlue": SimTypeChar(label="Byte"), "rgbGreen": SimTypeChar(label="Byte"), "rgbRed": SimTypeChar(label="Byte"), "rgbAlpha": SimTypeChar(label="Byte")}, name="MFARGB", pack=False, align=None), "AYCbCr": SimStruct({"bCrValue": SimTypeChar(label="Byte"), "bCbValue": SimTypeChar(label="Byte"), "bYValue": SimTypeChar(label="Byte"), "bSampleAlpha8": SimTypeChar(label="Byte")}, name="MFAYUVSample", pack=False, align=None)}, name="<anon>", label="None"), offset=0)}, name="MFVideoSurfaceInfo", pack=False, align=None)}, name="MFVIDEOFORMAT", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pMFType", "ppMFVF", "pcbSize"]),
        # 
        'MFCreateWaveFormatExFromMFMediaType': SimTypeFunction([SimTypeBottom(label="IMFMediaType"), SimTypePointer(SimTypePointer(SimStruct({"wFormatTag": SimTypeShort(signed=False, label="UInt16"), "nChannels": SimTypeShort(signed=False, label="UInt16"), "nSamplesPerSec": SimTypeInt(signed=False, label="UInt32"), "nAvgBytesPerSec": SimTypeInt(signed=False, label="UInt32"), "nBlockAlign": SimTypeShort(signed=False, label="UInt16"), "wBitsPerSample": SimTypeShort(signed=False, label="UInt16"), "cbSize": SimTypeShort(signed=False, label="UInt16")}, name="WAVEFORMATEX", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pMFType", "ppWF", "pcbSize", "Flags"]),
        # 
        'MFInitMediaTypeFromVideoInfoHeader': SimTypeFunction([SimTypeBottom(label="IMFMediaType"), SimTypePointer(SimStruct({"rcSource": SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECT", pack=False, align=None), "rcTarget": SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECT", pack=False, align=None), "dwBitRate": SimTypeInt(signed=False, label="UInt32"), "dwBitErrorRate": SimTypeInt(signed=False, label="UInt32"), "AvgTimePerFrame": SimTypeLongLong(signed=True, label="Int64"), "bmiHeader": SimTypeBottom(label="BITMAPINFOHEADER")}, name="VIDEOINFOHEADER", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Guid"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pMFType", "pVIH", "cbBufSize", "pSubtype"]),
        # 
        'MFInitMediaTypeFromVideoInfoHeader2': SimTypeFunction([SimTypeBottom(label="IMFMediaType"), SimTypePointer(SimStruct({"rcSource": SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECT", pack=False, align=None), "rcTarget": SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECT", pack=False, align=None), "dwBitRate": SimTypeInt(signed=False, label="UInt32"), "dwBitErrorRate": SimTypeInt(signed=False, label="UInt32"), "AvgTimePerFrame": SimTypeLongLong(signed=True, label="Int64"), "dwInterlaceFlags": SimTypeInt(signed=False, label="UInt32"), "dwCopyProtectFlags": SimTypeInt(signed=False, label="UInt32"), "dwPictAspectRatioX": SimTypeInt(signed=False, label="UInt32"), "dwPictAspectRatioY": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"dwControlFlags": SimTypeInt(signed=False, label="UInt32"), "dwReserved1": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None"), "dwReserved2": SimTypeInt(signed=False, label="UInt32"), "bmiHeader": SimTypeBottom(label="BITMAPINFOHEADER")}, name="VIDEOINFOHEADER2", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Guid"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pMFType", "pVIH2", "cbBufSize", "pSubtype"]),
        # 
        'MFInitMediaTypeFromMPEG1VideoInfo': SimTypeFunction([SimTypeBottom(label="IMFMediaType"), SimTypePointer(SimStruct({"hdr": SimStruct({"rcSource": SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECT", pack=False, align=None), "rcTarget": SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECT", pack=False, align=None), "dwBitRate": SimTypeInt(signed=False, label="UInt32"), "dwBitErrorRate": SimTypeInt(signed=False, label="UInt32"), "AvgTimePerFrame": SimTypeLongLong(signed=True, label="Int64"), "bmiHeader": SimTypeBottom(label="BITMAPINFOHEADER")}, name="VIDEOINFOHEADER", pack=False, align=None), "dwStartTimeCode": SimTypeInt(signed=False, label="UInt32"), "cbSequenceHeader": SimTypeInt(signed=False, label="UInt32"), "bSequenceHeader": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="MPEG1VIDEOINFO", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Guid"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pMFType", "pMP1VI", "cbBufSize", "pSubtype"]),
        # 
        'MFInitMediaTypeFromMPEG2VideoInfo': SimTypeFunction([SimTypeBottom(label="IMFMediaType"), SimTypePointer(SimStruct({"hdr": SimStruct({"rcSource": SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECT", pack=False, align=None), "rcTarget": SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECT", pack=False, align=None), "dwBitRate": SimTypeInt(signed=False, label="UInt32"), "dwBitErrorRate": SimTypeInt(signed=False, label="UInt32"), "AvgTimePerFrame": SimTypeLongLong(signed=True, label="Int64"), "dwInterlaceFlags": SimTypeInt(signed=False, label="UInt32"), "dwCopyProtectFlags": SimTypeInt(signed=False, label="UInt32"), "dwPictAspectRatioX": SimTypeInt(signed=False, label="UInt32"), "dwPictAspectRatioY": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"dwControlFlags": SimTypeInt(signed=False, label="UInt32"), "dwReserved1": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None"), "dwReserved2": SimTypeInt(signed=False, label="UInt32"), "bmiHeader": SimTypeBottom(label="BITMAPINFOHEADER")}, name="VIDEOINFOHEADER2", pack=False, align=None), "dwStartTimeCode": SimTypeInt(signed=False, label="UInt32"), "cbSequenceHeader": SimTypeInt(signed=False, label="UInt32"), "dwProfile": SimTypeInt(signed=False, label="UInt32"), "dwLevel": SimTypeInt(signed=False, label="UInt32"), "dwFlags": SimTypeInt(signed=False, label="MPEG2VIDEOINFO_FLAGS"), "dwSequenceHeader": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="MPEG2VIDEOINFO", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Guid"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pMFType", "pMP2VI", "cbBufSize", "pSubtype"]),
        # 
        'MFCalculateBitmapImageSize': SimTypeFunction([SimTypePointer(SimStruct({"biSize": SimTypeInt(signed=False, label="UInt32"), "biWidth": SimTypeInt(signed=True, label="Int32"), "biHeight": SimTypeInt(signed=True, label="Int32"), "biPlanes": SimTypeShort(signed=False, label="UInt16"), "biBitCount": SimTypeShort(signed=False, label="UInt16"), "biCompression": SimTypeInt(signed=False, label="UInt32"), "biSizeImage": SimTypeInt(signed=False, label="UInt32"), "biXPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biYPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biClrUsed": SimTypeInt(signed=False, label="UInt32"), "biClrImportant": SimTypeInt(signed=False, label="UInt32")}, name="BITMAPINFOHEADER", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pBMIH", "cbBufSize", "pcbImageSize", "pbKnown"]),
        # 
        'MFCalculateImageSize': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["guidSubtype", "unWidth", "unHeight", "pcbImageSize"]),
        # 
        'MFFrameRateToAverageTimePerFrame': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["unNumerator", "unDenominator", "punAverageTimePerFrame"]),
        # 
        'MFAverageTimePerFrameToFrameRate': SimTypeFunction([SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["unAverageTimePerFrame", "punNumerator", "punDenominator"]),
        # 
        'MFInitMediaTypeFromMFVideoFormat': SimTypeFunction([SimTypeBottom(label="IMFMediaType"), SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "videoInfo": SimStruct({"dwWidth": SimTypeInt(signed=False, label="UInt32"), "dwHeight": SimTypeInt(signed=False, label="UInt32"), "PixelAspectRatio": SimStruct({"Numerator": SimTypeInt(signed=False, label="UInt32"), "Denominator": SimTypeInt(signed=False, label="UInt32")}, name="MFRatio", pack=False, align=None), "SourceChromaSubsampling": SimTypeInt(signed=False, label="MFVideoChromaSubsampling"), "InterlaceMode": SimTypeInt(signed=False, label="MFVideoInterlaceMode"), "TransferFunction": SimTypeInt(signed=False, label="MFVideoTransferFunction"), "ColorPrimaries": SimTypeInt(signed=False, label="MFVideoPrimaries"), "TransferMatrix": SimTypeInt(signed=False, label="MFVideoTransferMatrix"), "SourceLighting": SimTypeInt(signed=False, label="MFVideoLighting"), "FramesPerSecond": SimStruct({"Numerator": SimTypeInt(signed=False, label="UInt32"), "Denominator": SimTypeInt(signed=False, label="UInt32")}, name="MFRatio", pack=False, align=None), "NominalRange": SimTypeInt(signed=False, label="MFNominalRange"), "GeometricAperture": SimStruct({"OffsetX": SimStruct({"fract": SimTypeShort(signed=False, label="UInt16"), "value": SimTypeShort(signed=True, label="Int16")}, name="MFOffset", pack=False, align=None), "OffsetY": SimStruct({"fract": SimTypeShort(signed=False, label="UInt16"), "value": SimTypeShort(signed=True, label="Int16")}, name="MFOffset", pack=False, align=None), "Area": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None)}, name="MFVideoArea", pack=False, align=None), "MinimumDisplayAperture": SimStruct({"OffsetX": SimStruct({"fract": SimTypeShort(signed=False, label="UInt16"), "value": SimTypeShort(signed=True, label="Int16")}, name="MFOffset", pack=False, align=None), "OffsetY": SimStruct({"fract": SimTypeShort(signed=False, label="UInt16"), "value": SimTypeShort(signed=True, label="Int16")}, name="MFOffset", pack=False, align=None), "Area": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None)}, name="MFVideoArea", pack=False, align=None), "PanScanAperture": SimStruct({"OffsetX": SimStruct({"fract": SimTypeShort(signed=False, label="UInt16"), "value": SimTypeShort(signed=True, label="Int16")}, name="MFOffset", pack=False, align=None), "OffsetY": SimStruct({"fract": SimTypeShort(signed=False, label="UInt16"), "value": SimTypeShort(signed=True, label="Int16")}, name="MFOffset", pack=False, align=None), "Area": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None)}, name="MFVideoArea", pack=False, align=None), "VideoFlags": SimTypeLongLong(signed=False, label="UInt64")}, name="MFVideoInfo", pack=False, align=None), "guidFormat": SimTypeBottom(label="Guid"), "compressedInfo": SimStruct({"AvgBitrate": SimTypeLongLong(signed=True, label="Int64"), "AvgBitErrorRate": SimTypeLongLong(signed=True, label="Int64"), "MaxKeyFrameSpacing": SimTypeInt(signed=False, label="UInt32")}, name="MFVideoCompressedInfo", pack=False, align=None), "surfaceInfo": SimStruct({"Format": SimTypeInt(signed=False, label="UInt32"), "PaletteEntries": SimTypeInt(signed=False, label="UInt32"), "Palette": SimTypePointer(SimUnion({"ARGB": SimStruct({"rgbBlue": SimTypeChar(label="Byte"), "rgbGreen": SimTypeChar(label="Byte"), "rgbRed": SimTypeChar(label="Byte"), "rgbAlpha": SimTypeChar(label="Byte")}, name="MFARGB", pack=False, align=None), "AYCbCr": SimStruct({"bCrValue": SimTypeChar(label="Byte"), "bCbValue": SimTypeChar(label="Byte"), "bYValue": SimTypeChar(label="Byte"), "bSampleAlpha8": SimTypeChar(label="Byte")}, name="MFAYUVSample", pack=False, align=None)}, name="<anon>", label="None"), offset=0)}, name="MFVideoSurfaceInfo", pack=False, align=None)}, name="MFVIDEOFORMAT", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pMFType", "pMFVF", "cbBufSize"]),
        # 
        'MFInitMediaTypeFromWaveFormatEx': SimTypeFunction([SimTypeBottom(label="IMFMediaType"), SimTypePointer(SimStruct({"wFormatTag": SimTypeShort(signed=False, label="UInt16"), "nChannels": SimTypeShort(signed=False, label="UInt16"), "nSamplesPerSec": SimTypeInt(signed=False, label="UInt32"), "nAvgBytesPerSec": SimTypeInt(signed=False, label="UInt32"), "nBlockAlign": SimTypeShort(signed=False, label="UInt16"), "wBitsPerSample": SimTypeShort(signed=False, label="UInt16"), "cbSize": SimTypeShort(signed=False, label="UInt16")}, name="WAVEFORMATEX", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pMFType", "pWaveFormat", "cbBufSize"]),
        # 
        'MFInitMediaTypeFromAMMediaType': SimTypeFunction([SimTypeBottom(label="IMFMediaType"), SimTypePointer(SimStruct({"majortype": SimTypeBottom(label="Guid"), "subtype": SimTypeBottom(label="Guid"), "bFixedSizeSamples": SimTypeInt(signed=True, label="Int32"), "bTemporalCompression": SimTypeInt(signed=True, label="Int32"), "lSampleSize": SimTypeInt(signed=False, label="UInt32"), "formattype": SimTypeBottom(label="Guid"), "pUnk": SimTypeBottom(label="IUnknown"), "cbFormat": SimTypeInt(signed=False, label="UInt32"), "pbFormat": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="AM_MEDIA_TYPE", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pMFType", "pAMType"]),
        # 
        'MFInitAMMediaTypeFromMFMediaType': SimTypeFunction([SimTypeBottom(label="IMFMediaType"), SimTypeBottom(label="Guid"), SimTypePointer(SimStruct({"majortype": SimTypeBottom(label="Guid"), "subtype": SimTypeBottom(label="Guid"), "bFixedSizeSamples": SimTypeInt(signed=True, label="Int32"), "bTemporalCompression": SimTypeInt(signed=True, label="Int32"), "lSampleSize": SimTypeInt(signed=False, label="UInt32"), "formattype": SimTypeBottom(label="Guid"), "pUnk": SimTypeBottom(label="IUnknown"), "cbFormat": SimTypeInt(signed=False, label="UInt32"), "pbFormat": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="AM_MEDIA_TYPE", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pMFType", "guidFormatBlockType", "pAMType"]),
        # 
        'MFCreateAMMediaTypeFromMFMediaType': SimTypeFunction([SimTypeBottom(label="IMFMediaType"), SimTypeBottom(label="Guid"), SimTypePointer(SimTypePointer(SimStruct({"majortype": SimTypeBottom(label="Guid"), "subtype": SimTypeBottom(label="Guid"), "bFixedSizeSamples": SimTypeInt(signed=True, label="Int32"), "bTemporalCompression": SimTypeInt(signed=True, label="Int32"), "lSampleSize": SimTypeInt(signed=False, label="UInt32"), "formattype": SimTypeBottom(label="Guid"), "pUnk": SimTypeBottom(label="IUnknown"), "cbFormat": SimTypeInt(signed=False, label="UInt32"), "pbFormat": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="AM_MEDIA_TYPE", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pMFType", "guidFormatBlockType", "ppAMType"]),
        # 
        'MFCompareFullToPartialMediaType': SimTypeFunction([SimTypeBottom(label="IMFMediaType"), SimTypeBottom(label="IMFMediaType")], SimTypeInt(signed=True, label="Int32"), arg_names=["pMFTypeFull", "pMFTypePartial"]),
        # 
        'MFWrapMediaType': SimTypeFunction([SimTypeBottom(label="IMFMediaType"), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="IMFMediaType"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pOrig", "MajorType", "SubType", "ppWrap"]),
        # 
        'MFUnwrapMediaType': SimTypeFunction([SimTypeBottom(label="IMFMediaType"), SimTypePointer(SimTypeBottom(label="IMFMediaType"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pWrap", "ppOrig"]),
        # 
        'MFCreateVideoMediaType': SimTypeFunction([SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "videoInfo": SimStruct({"dwWidth": SimTypeInt(signed=False, label="UInt32"), "dwHeight": SimTypeInt(signed=False, label="UInt32"), "PixelAspectRatio": SimStruct({"Numerator": SimTypeInt(signed=False, label="UInt32"), "Denominator": SimTypeInt(signed=False, label="UInt32")}, name="MFRatio", pack=False, align=None), "SourceChromaSubsampling": SimTypeInt(signed=False, label="MFVideoChromaSubsampling"), "InterlaceMode": SimTypeInt(signed=False, label="MFVideoInterlaceMode"), "TransferFunction": SimTypeInt(signed=False, label="MFVideoTransferFunction"), "ColorPrimaries": SimTypeInt(signed=False, label="MFVideoPrimaries"), "TransferMatrix": SimTypeInt(signed=False, label="MFVideoTransferMatrix"), "SourceLighting": SimTypeInt(signed=False, label="MFVideoLighting"), "FramesPerSecond": SimStruct({"Numerator": SimTypeInt(signed=False, label="UInt32"), "Denominator": SimTypeInt(signed=False, label="UInt32")}, name="MFRatio", pack=False, align=None), "NominalRange": SimTypeInt(signed=False, label="MFNominalRange"), "GeometricAperture": SimStruct({"OffsetX": SimStruct({"fract": SimTypeShort(signed=False, label="UInt16"), "value": SimTypeShort(signed=True, label="Int16")}, name="MFOffset", pack=False, align=None), "OffsetY": SimStruct({"fract": SimTypeShort(signed=False, label="UInt16"), "value": SimTypeShort(signed=True, label="Int16")}, name="MFOffset", pack=False, align=None), "Area": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None)}, name="MFVideoArea", pack=False, align=None), "MinimumDisplayAperture": SimStruct({"OffsetX": SimStruct({"fract": SimTypeShort(signed=False, label="UInt16"), "value": SimTypeShort(signed=True, label="Int16")}, name="MFOffset", pack=False, align=None), "OffsetY": SimStruct({"fract": SimTypeShort(signed=False, label="UInt16"), "value": SimTypeShort(signed=True, label="Int16")}, name="MFOffset", pack=False, align=None), "Area": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None)}, name="MFVideoArea", pack=False, align=None), "PanScanAperture": SimStruct({"OffsetX": SimStruct({"fract": SimTypeShort(signed=False, label="UInt16"), "value": SimTypeShort(signed=True, label="Int16")}, name="MFOffset", pack=False, align=None), "OffsetY": SimStruct({"fract": SimTypeShort(signed=False, label="UInt16"), "value": SimTypeShort(signed=True, label="Int16")}, name="MFOffset", pack=False, align=None), "Area": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None)}, name="MFVideoArea", pack=False, align=None), "VideoFlags": SimTypeLongLong(signed=False, label="UInt64")}, name="MFVideoInfo", pack=False, align=None), "guidFormat": SimTypeBottom(label="Guid"), "compressedInfo": SimStruct({"AvgBitrate": SimTypeLongLong(signed=True, label="Int64"), "AvgBitErrorRate": SimTypeLongLong(signed=True, label="Int64"), "MaxKeyFrameSpacing": SimTypeInt(signed=False, label="UInt32")}, name="MFVideoCompressedInfo", pack=False, align=None), "surfaceInfo": SimStruct({"Format": SimTypeInt(signed=False, label="UInt32"), "PaletteEntries": SimTypeInt(signed=False, label="UInt32"), "Palette": SimTypePointer(SimUnion({"ARGB": SimStruct({"rgbBlue": SimTypeChar(label="Byte"), "rgbGreen": SimTypeChar(label="Byte"), "rgbRed": SimTypeChar(label="Byte"), "rgbAlpha": SimTypeChar(label="Byte")}, name="MFARGB", pack=False, align=None), "AYCbCr": SimStruct({"bCrValue": SimTypeChar(label="Byte"), "bCbValue": SimTypeChar(label="Byte"), "bYValue": SimTypeChar(label="Byte"), "bSampleAlpha8": SimTypeChar(label="Byte")}, name="MFAYUVSample", pack=False, align=None)}, name="<anon>", label="None"), offset=0)}, name="MFVideoSurfaceInfo", pack=False, align=None)}, name="MFVIDEOFORMAT", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="IMFVideoMediaType"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pVideoFormat", "ppIVideoMediaType"]),
        # 
        'MFCreateVideoMediaTypeFromSubtype': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="IMFVideoMediaType"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pAMSubtype", "ppIVideoMediaType"]),
        # 
        'MFCreateVideoMediaTypeFromBitMapInfoHeader': SimTypeFunction([SimTypePointer(SimStruct({"biSize": SimTypeInt(signed=False, label="UInt32"), "biWidth": SimTypeInt(signed=True, label="Int32"), "biHeight": SimTypeInt(signed=True, label="Int32"), "biPlanes": SimTypeShort(signed=False, label="UInt16"), "biBitCount": SimTypeShort(signed=False, label="UInt16"), "biCompression": SimTypeInt(signed=False, label="UInt32"), "biSizeImage": SimTypeInt(signed=False, label="UInt32"), "biXPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biYPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biClrUsed": SimTypeInt(signed=False, label="UInt32"), "biClrImportant": SimTypeInt(signed=False, label="UInt32")}, name="BITMAPINFOHEADER", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="MFVideoInterlaceMode"), SimTypeLongLong(signed=False, label="UInt64"), SimTypeLongLong(signed=False, label="UInt64"), SimTypeLongLong(signed=False, label="UInt64"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="IMFVideoMediaType"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pbmihBitMapInfoHeader", "dwPixelAspectRatioX", "dwPixelAspectRatioY", "InterlaceMode", "VideoFlags", "qwFramesPerSecondNumerator", "qwFramesPerSecondDenominator", "dwMaxBitRate", "ppIVideoMediaType"]),
        # 
        'MFGetStrideForBitmapInfoHeader': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["format", "dwWidth", "pStride"]),
        # 
        'MFCreateVideoMediaTypeFromBitMapInfoHeaderEx': SimTypeFunction([SimTypePointer(SimStruct({"biSize": SimTypeInt(signed=False, label="UInt32"), "biWidth": SimTypeInt(signed=True, label="Int32"), "biHeight": SimTypeInt(signed=True, label="Int32"), "biPlanes": SimTypeShort(signed=False, label="UInt16"), "biBitCount": SimTypeShort(signed=False, label="UInt16"), "biCompression": SimTypeInt(signed=False, label="UInt32"), "biSizeImage": SimTypeInt(signed=False, label="UInt32"), "biXPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biYPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biClrUsed": SimTypeInt(signed=False, label="UInt32"), "biClrImportant": SimTypeInt(signed=False, label="UInt32")}, name="BITMAPINFOHEADER", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="MFVideoInterlaceMode"), SimTypeLongLong(signed=False, label="UInt64"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="IMFVideoMediaType"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pbmihBitMapInfoHeader", "cbBitMapInfoHeader", "dwPixelAspectRatioX", "dwPixelAspectRatioY", "InterlaceMode", "VideoFlags", "dwFramesPerSecondNumerator", "dwFramesPerSecondDenominator", "dwMaxBitRate", "ppIVideoMediaType"]),
        # 
        'MFCreateMediaTypeFromRepresentation': SimTypeFunction([SimTypeBottom(label="Guid"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="IMFMediaType"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["guidRepresentation", "pvRepresentation", "ppIMediaType"]),
        # 
        'MFCreateAudioMediaType': SimTypeFunction([SimTypePointer(SimStruct({"wFormatTag": SimTypeShort(signed=False, label="UInt16"), "nChannels": SimTypeShort(signed=False, label="UInt16"), "nSamplesPerSec": SimTypeInt(signed=False, label="UInt32"), "nAvgBytesPerSec": SimTypeInt(signed=False, label="UInt32"), "nBlockAlign": SimTypeShort(signed=False, label="UInt16"), "wBitsPerSample": SimTypeShort(signed=False, label="UInt16"), "cbSize": SimTypeShort(signed=False, label="UInt16")}, name="WAVEFORMATEX", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="IMFAudioMediaType"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pAudioFormat", "ppIAudioMediaType"]),
        # 
        'MFGetUncompressedVideoFormat': SimTypeFunction([SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "videoInfo": SimStruct({"dwWidth": SimTypeInt(signed=False, label="UInt32"), "dwHeight": SimTypeInt(signed=False, label="UInt32"), "PixelAspectRatio": SimStruct({"Numerator": SimTypeInt(signed=False, label="UInt32"), "Denominator": SimTypeInt(signed=False, label="UInt32")}, name="MFRatio", pack=False, align=None), "SourceChromaSubsampling": SimTypeInt(signed=False, label="MFVideoChromaSubsampling"), "InterlaceMode": SimTypeInt(signed=False, label="MFVideoInterlaceMode"), "TransferFunction": SimTypeInt(signed=False, label="MFVideoTransferFunction"), "ColorPrimaries": SimTypeInt(signed=False, label="MFVideoPrimaries"), "TransferMatrix": SimTypeInt(signed=False, label="MFVideoTransferMatrix"), "SourceLighting": SimTypeInt(signed=False, label="MFVideoLighting"), "FramesPerSecond": SimStruct({"Numerator": SimTypeInt(signed=False, label="UInt32"), "Denominator": SimTypeInt(signed=False, label="UInt32")}, name="MFRatio", pack=False, align=None), "NominalRange": SimTypeInt(signed=False, label="MFNominalRange"), "GeometricAperture": SimStruct({"OffsetX": SimStruct({"fract": SimTypeShort(signed=False, label="UInt16"), "value": SimTypeShort(signed=True, label="Int16")}, name="MFOffset", pack=False, align=None), "OffsetY": SimStruct({"fract": SimTypeShort(signed=False, label="UInt16"), "value": SimTypeShort(signed=True, label="Int16")}, name="MFOffset", pack=False, align=None), "Area": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None)}, name="MFVideoArea", pack=False, align=None), "MinimumDisplayAperture": SimStruct({"OffsetX": SimStruct({"fract": SimTypeShort(signed=False, label="UInt16"), "value": SimTypeShort(signed=True, label="Int16")}, name="MFOffset", pack=False, align=None), "OffsetY": SimStruct({"fract": SimTypeShort(signed=False, label="UInt16"), "value": SimTypeShort(signed=True, label="Int16")}, name="MFOffset", pack=False, align=None), "Area": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None)}, name="MFVideoArea", pack=False, align=None), "PanScanAperture": SimStruct({"OffsetX": SimStruct({"fract": SimTypeShort(signed=False, label="UInt16"), "value": SimTypeShort(signed=True, label="Int16")}, name="MFOffset", pack=False, align=None), "OffsetY": SimStruct({"fract": SimTypeShort(signed=False, label="UInt16"), "value": SimTypeShort(signed=True, label="Int16")}, name="MFOffset", pack=False, align=None), "Area": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None)}, name="MFVideoArea", pack=False, align=None), "VideoFlags": SimTypeLongLong(signed=False, label="UInt64")}, name="MFVideoInfo", pack=False, align=None), "guidFormat": SimTypeBottom(label="Guid"), "compressedInfo": SimStruct({"AvgBitrate": SimTypeLongLong(signed=True, label="Int64"), "AvgBitErrorRate": SimTypeLongLong(signed=True, label="Int64"), "MaxKeyFrameSpacing": SimTypeInt(signed=False, label="UInt32")}, name="MFVideoCompressedInfo", pack=False, align=None), "surfaceInfo": SimStruct({"Format": SimTypeInt(signed=False, label="UInt32"), "PaletteEntries": SimTypeInt(signed=False, label="UInt32"), "Palette": SimTypePointer(SimUnion({"ARGB": SimStruct({"rgbBlue": SimTypeChar(label="Byte"), "rgbGreen": SimTypeChar(label="Byte"), "rgbRed": SimTypeChar(label="Byte"), "rgbAlpha": SimTypeChar(label="Byte")}, name="MFARGB", pack=False, align=None), "AYCbCr": SimStruct({"bCrValue": SimTypeChar(label="Byte"), "bCbValue": SimTypeChar(label="Byte"), "bYValue": SimTypeChar(label="Byte"), "bSampleAlpha8": SimTypeChar(label="Byte")}, name="MFAYUVSample", pack=False, align=None)}, name="<anon>", label="None"), offset=0)}, name="MFVideoSurfaceInfo", pack=False, align=None)}, name="MFVIDEOFORMAT", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pVideoFormat"]),
        # 
        'MFInitVideoFormat': SimTypeFunction([SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "videoInfo": SimStruct({"dwWidth": SimTypeInt(signed=False, label="UInt32"), "dwHeight": SimTypeInt(signed=False, label="UInt32"), "PixelAspectRatio": SimStruct({"Numerator": SimTypeInt(signed=False, label="UInt32"), "Denominator": SimTypeInt(signed=False, label="UInt32")}, name="MFRatio", pack=False, align=None), "SourceChromaSubsampling": SimTypeInt(signed=False, label="MFVideoChromaSubsampling"), "InterlaceMode": SimTypeInt(signed=False, label="MFVideoInterlaceMode"), "TransferFunction": SimTypeInt(signed=False, label="MFVideoTransferFunction"), "ColorPrimaries": SimTypeInt(signed=False, label="MFVideoPrimaries"), "TransferMatrix": SimTypeInt(signed=False, label="MFVideoTransferMatrix"), "SourceLighting": SimTypeInt(signed=False, label="MFVideoLighting"), "FramesPerSecond": SimStruct({"Numerator": SimTypeInt(signed=False, label="UInt32"), "Denominator": SimTypeInt(signed=False, label="UInt32")}, name="MFRatio", pack=False, align=None), "NominalRange": SimTypeInt(signed=False, label="MFNominalRange"), "GeometricAperture": SimStruct({"OffsetX": SimStruct({"fract": SimTypeShort(signed=False, label="UInt16"), "value": SimTypeShort(signed=True, label="Int16")}, name="MFOffset", pack=False, align=None), "OffsetY": SimStruct({"fract": SimTypeShort(signed=False, label="UInt16"), "value": SimTypeShort(signed=True, label="Int16")}, name="MFOffset", pack=False, align=None), "Area": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None)}, name="MFVideoArea", pack=False, align=None), "MinimumDisplayAperture": SimStruct({"OffsetX": SimStruct({"fract": SimTypeShort(signed=False, label="UInt16"), "value": SimTypeShort(signed=True, label="Int16")}, name="MFOffset", pack=False, align=None), "OffsetY": SimStruct({"fract": SimTypeShort(signed=False, label="UInt16"), "value": SimTypeShort(signed=True, label="Int16")}, name="MFOffset", pack=False, align=None), "Area": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None)}, name="MFVideoArea", pack=False, align=None), "PanScanAperture": SimStruct({"OffsetX": SimStruct({"fract": SimTypeShort(signed=False, label="UInt16"), "value": SimTypeShort(signed=True, label="Int16")}, name="MFOffset", pack=False, align=None), "OffsetY": SimStruct({"fract": SimTypeShort(signed=False, label="UInt16"), "value": SimTypeShort(signed=True, label="Int16")}, name="MFOffset", pack=False, align=None), "Area": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None)}, name="MFVideoArea", pack=False, align=None), "VideoFlags": SimTypeLongLong(signed=False, label="UInt64")}, name="MFVideoInfo", pack=False, align=None), "guidFormat": SimTypeBottom(label="Guid"), "compressedInfo": SimStruct({"AvgBitrate": SimTypeLongLong(signed=True, label="Int64"), "AvgBitErrorRate": SimTypeLongLong(signed=True, label="Int64"), "MaxKeyFrameSpacing": SimTypeInt(signed=False, label="UInt32")}, name="MFVideoCompressedInfo", pack=False, align=None), "surfaceInfo": SimStruct({"Format": SimTypeInt(signed=False, label="UInt32"), "PaletteEntries": SimTypeInt(signed=False, label="UInt32"), "Palette": SimTypePointer(SimUnion({"ARGB": SimStruct({"rgbBlue": SimTypeChar(label="Byte"), "rgbGreen": SimTypeChar(label="Byte"), "rgbRed": SimTypeChar(label="Byte"), "rgbAlpha": SimTypeChar(label="Byte")}, name="MFARGB", pack=False, align=None), "AYCbCr": SimStruct({"bCrValue": SimTypeChar(label="Byte"), "bCbValue": SimTypeChar(label="Byte"), "bYValue": SimTypeChar(label="Byte"), "bSampleAlpha8": SimTypeChar(label="Byte")}, name="MFAYUVSample", pack=False, align=None)}, name="<anon>", label="None"), offset=0)}, name="MFVideoSurfaceInfo", pack=False, align=None)}, name="MFVIDEOFORMAT", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="MFStandardVideoFormat")], SimTypeInt(signed=True, label="Int32"), arg_names=["pVideoFormat", "type"]),
        # 
        'MFInitVideoFormat_RGB': SimTypeFunction([SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "videoInfo": SimStruct({"dwWidth": SimTypeInt(signed=False, label="UInt32"), "dwHeight": SimTypeInt(signed=False, label="UInt32"), "PixelAspectRatio": SimStruct({"Numerator": SimTypeInt(signed=False, label="UInt32"), "Denominator": SimTypeInt(signed=False, label="UInt32")}, name="MFRatio", pack=False, align=None), "SourceChromaSubsampling": SimTypeInt(signed=False, label="MFVideoChromaSubsampling"), "InterlaceMode": SimTypeInt(signed=False, label="MFVideoInterlaceMode"), "TransferFunction": SimTypeInt(signed=False, label="MFVideoTransferFunction"), "ColorPrimaries": SimTypeInt(signed=False, label="MFVideoPrimaries"), "TransferMatrix": SimTypeInt(signed=False, label="MFVideoTransferMatrix"), "SourceLighting": SimTypeInt(signed=False, label="MFVideoLighting"), "FramesPerSecond": SimStruct({"Numerator": SimTypeInt(signed=False, label="UInt32"), "Denominator": SimTypeInt(signed=False, label="UInt32")}, name="MFRatio", pack=False, align=None), "NominalRange": SimTypeInt(signed=False, label="MFNominalRange"), "GeometricAperture": SimStruct({"OffsetX": SimStruct({"fract": SimTypeShort(signed=False, label="UInt16"), "value": SimTypeShort(signed=True, label="Int16")}, name="MFOffset", pack=False, align=None), "OffsetY": SimStruct({"fract": SimTypeShort(signed=False, label="UInt16"), "value": SimTypeShort(signed=True, label="Int16")}, name="MFOffset", pack=False, align=None), "Area": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None)}, name="MFVideoArea", pack=False, align=None), "MinimumDisplayAperture": SimStruct({"OffsetX": SimStruct({"fract": SimTypeShort(signed=False, label="UInt16"), "value": SimTypeShort(signed=True, label="Int16")}, name="MFOffset", pack=False, align=None), "OffsetY": SimStruct({"fract": SimTypeShort(signed=False, label="UInt16"), "value": SimTypeShort(signed=True, label="Int16")}, name="MFOffset", pack=False, align=None), "Area": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None)}, name="MFVideoArea", pack=False, align=None), "PanScanAperture": SimStruct({"OffsetX": SimStruct({"fract": SimTypeShort(signed=False, label="UInt16"), "value": SimTypeShort(signed=True, label="Int16")}, name="MFOffset", pack=False, align=None), "OffsetY": SimStruct({"fract": SimTypeShort(signed=False, label="UInt16"), "value": SimTypeShort(signed=True, label="Int16")}, name="MFOffset", pack=False, align=None), "Area": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None)}, name="MFVideoArea", pack=False, align=None), "VideoFlags": SimTypeLongLong(signed=False, label="UInt64")}, name="MFVideoInfo", pack=False, align=None), "guidFormat": SimTypeBottom(label="Guid"), "compressedInfo": SimStruct({"AvgBitrate": SimTypeLongLong(signed=True, label="Int64"), "AvgBitErrorRate": SimTypeLongLong(signed=True, label="Int64"), "MaxKeyFrameSpacing": SimTypeInt(signed=False, label="UInt32")}, name="MFVideoCompressedInfo", pack=False, align=None), "surfaceInfo": SimStruct({"Format": SimTypeInt(signed=False, label="UInt32"), "PaletteEntries": SimTypeInt(signed=False, label="UInt32"), "Palette": SimTypePointer(SimUnion({"ARGB": SimStruct({"rgbBlue": SimTypeChar(label="Byte"), "rgbGreen": SimTypeChar(label="Byte"), "rgbRed": SimTypeChar(label="Byte"), "rgbAlpha": SimTypeChar(label="Byte")}, name="MFARGB", pack=False, align=None), "AYCbCr": SimStruct({"bCrValue": SimTypeChar(label="Byte"), "bCbValue": SimTypeChar(label="Byte"), "bYValue": SimTypeChar(label="Byte"), "bSampleAlpha8": SimTypeChar(label="Byte")}, name="MFAYUVSample", pack=False, align=None)}, name="<anon>", label="None"), offset=0)}, name="MFVideoSurfaceInfo", pack=False, align=None)}, name="MFVIDEOFORMAT", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pVideoFormat", "dwWidth", "dwHeight", "D3Dfmt"]),
        # 
        'MFConvertColorInfoToDXVA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "videoInfo": SimStruct({"dwWidth": SimTypeInt(signed=False, label="UInt32"), "dwHeight": SimTypeInt(signed=False, label="UInt32"), "PixelAspectRatio": SimStruct({"Numerator": SimTypeInt(signed=False, label="UInt32"), "Denominator": SimTypeInt(signed=False, label="UInt32")}, name="MFRatio", pack=False, align=None), "SourceChromaSubsampling": SimTypeInt(signed=False, label="MFVideoChromaSubsampling"), "InterlaceMode": SimTypeInt(signed=False, label="MFVideoInterlaceMode"), "TransferFunction": SimTypeInt(signed=False, label="MFVideoTransferFunction"), "ColorPrimaries": SimTypeInt(signed=False, label="MFVideoPrimaries"), "TransferMatrix": SimTypeInt(signed=False, label="MFVideoTransferMatrix"), "SourceLighting": SimTypeInt(signed=False, label="MFVideoLighting"), "FramesPerSecond": SimStruct({"Numerator": SimTypeInt(signed=False, label="UInt32"), "Denominator": SimTypeInt(signed=False, label="UInt32")}, name="MFRatio", pack=False, align=None), "NominalRange": SimTypeInt(signed=False, label="MFNominalRange"), "GeometricAperture": SimStruct({"OffsetX": SimStruct({"fract": SimTypeShort(signed=False, label="UInt16"), "value": SimTypeShort(signed=True, label="Int16")}, name="MFOffset", pack=False, align=None), "OffsetY": SimStruct({"fract": SimTypeShort(signed=False, label="UInt16"), "value": SimTypeShort(signed=True, label="Int16")}, name="MFOffset", pack=False, align=None), "Area": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None)}, name="MFVideoArea", pack=False, align=None), "MinimumDisplayAperture": SimStruct({"OffsetX": SimStruct({"fract": SimTypeShort(signed=False, label="UInt16"), "value": SimTypeShort(signed=True, label="Int16")}, name="MFOffset", pack=False, align=None), "OffsetY": SimStruct({"fract": SimTypeShort(signed=False, label="UInt16"), "value": SimTypeShort(signed=True, label="Int16")}, name="MFOffset", pack=False, align=None), "Area": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None)}, name="MFVideoArea", pack=False, align=None), "PanScanAperture": SimStruct({"OffsetX": SimStruct({"fract": SimTypeShort(signed=False, label="UInt16"), "value": SimTypeShort(signed=True, label="Int16")}, name="MFOffset", pack=False, align=None), "OffsetY": SimStruct({"fract": SimTypeShort(signed=False, label="UInt16"), "value": SimTypeShort(signed=True, label="Int16")}, name="MFOffset", pack=False, align=None), "Area": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None)}, name="MFVideoArea", pack=False, align=None), "VideoFlags": SimTypeLongLong(signed=False, label="UInt64")}, name="MFVideoInfo", pack=False, align=None), "guidFormat": SimTypeBottom(label="Guid"), "compressedInfo": SimStruct({"AvgBitrate": SimTypeLongLong(signed=True, label="Int64"), "AvgBitErrorRate": SimTypeLongLong(signed=True, label="Int64"), "MaxKeyFrameSpacing": SimTypeInt(signed=False, label="UInt32")}, name="MFVideoCompressedInfo", pack=False, align=None), "surfaceInfo": SimStruct({"Format": SimTypeInt(signed=False, label="UInt32"), "PaletteEntries": SimTypeInt(signed=False, label="UInt32"), "Palette": SimTypePointer(SimUnion({"ARGB": SimStruct({"rgbBlue": SimTypeChar(label="Byte"), "rgbGreen": SimTypeChar(label="Byte"), "rgbRed": SimTypeChar(label="Byte"), "rgbAlpha": SimTypeChar(label="Byte")}, name="MFARGB", pack=False, align=None), "AYCbCr": SimStruct({"bCrValue": SimTypeChar(label="Byte"), "bCbValue": SimTypeChar(label="Byte"), "bYValue": SimTypeChar(label="Byte"), "bSampleAlpha8": SimTypeChar(label="Byte")}, name="MFAYUVSample", pack=False, align=None)}, name="<anon>", label="None"), offset=0)}, name="MFVideoSurfaceInfo", pack=False, align=None)}, name="MFVIDEOFORMAT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pdwToDXVA", "pFromFormat"]),
        # 
        'MFConvertColorInfoFromDXVA': SimTypeFunction([SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "videoInfo": SimStruct({"dwWidth": SimTypeInt(signed=False, label="UInt32"), "dwHeight": SimTypeInt(signed=False, label="UInt32"), "PixelAspectRatio": SimStruct({"Numerator": SimTypeInt(signed=False, label="UInt32"), "Denominator": SimTypeInt(signed=False, label="UInt32")}, name="MFRatio", pack=False, align=None), "SourceChromaSubsampling": SimTypeInt(signed=False, label="MFVideoChromaSubsampling"), "InterlaceMode": SimTypeInt(signed=False, label="MFVideoInterlaceMode"), "TransferFunction": SimTypeInt(signed=False, label="MFVideoTransferFunction"), "ColorPrimaries": SimTypeInt(signed=False, label="MFVideoPrimaries"), "TransferMatrix": SimTypeInt(signed=False, label="MFVideoTransferMatrix"), "SourceLighting": SimTypeInt(signed=False, label="MFVideoLighting"), "FramesPerSecond": SimStruct({"Numerator": SimTypeInt(signed=False, label="UInt32"), "Denominator": SimTypeInt(signed=False, label="UInt32")}, name="MFRatio", pack=False, align=None), "NominalRange": SimTypeInt(signed=False, label="MFNominalRange"), "GeometricAperture": SimStruct({"OffsetX": SimStruct({"fract": SimTypeShort(signed=False, label="UInt16"), "value": SimTypeShort(signed=True, label="Int16")}, name="MFOffset", pack=False, align=None), "OffsetY": SimStruct({"fract": SimTypeShort(signed=False, label="UInt16"), "value": SimTypeShort(signed=True, label="Int16")}, name="MFOffset", pack=False, align=None), "Area": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None)}, name="MFVideoArea", pack=False, align=None), "MinimumDisplayAperture": SimStruct({"OffsetX": SimStruct({"fract": SimTypeShort(signed=False, label="UInt16"), "value": SimTypeShort(signed=True, label="Int16")}, name="MFOffset", pack=False, align=None), "OffsetY": SimStruct({"fract": SimTypeShort(signed=False, label="UInt16"), "value": SimTypeShort(signed=True, label="Int16")}, name="MFOffset", pack=False, align=None), "Area": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None)}, name="MFVideoArea", pack=False, align=None), "PanScanAperture": SimStruct({"OffsetX": SimStruct({"fract": SimTypeShort(signed=False, label="UInt16"), "value": SimTypeShort(signed=True, label="Int16")}, name="MFOffset", pack=False, align=None), "OffsetY": SimStruct({"fract": SimTypeShort(signed=False, label="UInt16"), "value": SimTypeShort(signed=True, label="Int16")}, name="MFOffset", pack=False, align=None), "Area": SimStruct({"cx": SimTypeInt(signed=True, label="Int32"), "cy": SimTypeInt(signed=True, label="Int32")}, name="SIZE", pack=False, align=None)}, name="MFVideoArea", pack=False, align=None), "VideoFlags": SimTypeLongLong(signed=False, label="UInt64")}, name="MFVideoInfo", pack=False, align=None), "guidFormat": SimTypeBottom(label="Guid"), "compressedInfo": SimStruct({"AvgBitrate": SimTypeLongLong(signed=True, label="Int64"), "AvgBitErrorRate": SimTypeLongLong(signed=True, label="Int64"), "MaxKeyFrameSpacing": SimTypeInt(signed=False, label="UInt32")}, name="MFVideoCompressedInfo", pack=False, align=None), "surfaceInfo": SimStruct({"Format": SimTypeInt(signed=False, label="UInt32"), "PaletteEntries": SimTypeInt(signed=False, label="UInt32"), "Palette": SimTypePointer(SimUnion({"ARGB": SimStruct({"rgbBlue": SimTypeChar(label="Byte"), "rgbGreen": SimTypeChar(label="Byte"), "rgbRed": SimTypeChar(label="Byte"), "rgbAlpha": SimTypeChar(label="Byte")}, name="MFARGB", pack=False, align=None), "AYCbCr": SimStruct({"bCrValue": SimTypeChar(label="Byte"), "bCbValue": SimTypeChar(label="Byte"), "bYValue": SimTypeChar(label="Byte"), "bSampleAlpha8": SimTypeChar(label="Byte")}, name="MFAYUVSample", pack=False, align=None)}, name="<anon>", label="None"), offset=0)}, name="MFVideoSurfaceInfo", pack=False, align=None)}, name="MFVIDEOFORMAT", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pToFormat", "dwFromDXVA"]),
        # 
        'MFCopyImage': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pDest", "lDestStride", "pSrc", "lSrcStride", "dwWidthInBytes", "dwLines"]),
        # 
        'MFConvertFromFP16Array': SimTypeFunction([SimTypePointer(SimTypeFloat(size=32), label="LPArray", offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pDest", "pSrc", "dwCount"]),
        # 
        'MFConvertToFP16Array': SimTypeFunction([SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypePointer(SimTypeFloat(size=32), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pDest", "pSrc", "dwCount"]),
        # 
        'MFCreate2DMediaBuffer': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeBottom(label="IMFMediaBuffer"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwWidth", "dwHeight", "dwFourCC", "fBottomUp", "ppBuffer"]),
        # 
        'MFCreateMediaBufferFromMediaType': SimTypeFunction([SimTypeBottom(label="IMFMediaType"), SimTypeLongLong(signed=True, label="Int64"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="IMFMediaBuffer"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pMediaType", "llDuration", "dwMinLength", "dwMinAlignment", "ppBuffer"]),
        # 
        'MFCreateCollection': SimTypeFunction([SimTypePointer(SimTypeBottom(label="IMFCollection"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ppIMFCollection"]),
        # 
        'MFHeapAlloc': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="EAllocationType")], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["nSize", "dwFlags", "pszFile", "line", "eat"]),
        # 
        'MFHeapFree': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pv"]),
        # 
        'MFllMulDiv': SimTypeFunction([SimTypeLongLong(signed=True, label="Int64"), SimTypeLongLong(signed=True, label="Int64"), SimTypeLongLong(signed=True, label="Int64"), SimTypeLongLong(signed=True, label="Int64")], SimTypeLongLong(signed=True, label="Int64"), arg_names=["a", "b", "c", "d"]),
        # 
        'MFGetContentProtectionSystemCLSID': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["guidProtectionSystemID", "pclsid"]),
        # 
        'MFCombineSamples': SimTypeFunction([SimTypeBottom(label="IMFSample"), SimTypeBottom(label="IMFSample"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pSample", "pSampleToAdd", "dwMaxMergedDurationInMS", "pMerged"]),
        # 
        'MFSplitSample': SimTypeFunction([SimTypeBottom(label="IMFSample"), SimTypePointer(SimTypeBottom(label="IMFSample"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pSample", "pOutputSamples", "dwOutputSampleMaxCount", "pdwOutputSampleCount"]),
    }

lib.set_prototypes(prototypes)
