# pylint:disable=line-too-long
import logging

from ...sim_type import SimTypeFunction,     SimTypeShort, SimTypeInt, SimTypeLong, SimTypeLongLong, SimTypeDouble, SimTypeFloat,     SimTypePointer,     SimTypeChar,     SimStruct,     SimTypeFixedSizeArray,     SimTypeBottom,     SimUnion,     SimTypeBool
from ...calling_conventions import SimCCStdcall, SimCCMicrosoftAMD64
from .. import SIM_PROCEDURES as P
from . import SimLibrary


_l = logging.getLogger(name=__name__)


lib = SimLibrary()
lib.set_default_cc('X86', SimCCStdcall)
lib.set_default_cc('AMD64', SimCCMicrosoftAMD64)
lib.set_library_names("ninput.dll")
prototypes = \
    {
        # 
        'CreateInteractionContext': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["interactionContext"]),
        # 
        'DestroyInteractionContext': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["interactionContext"]),
        # 
        'RegisterOutputCallbackInteractionContext': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"interactionId": SimTypeInt(signed=False, label="INTERACTION_ID"), "interactionFlags": SimTypeInt(signed=False, label="INTERACTION_FLAGS"), "inputType": SimTypeBottom(label="POINTER_INPUT_TYPE"), "x": SimTypeFloat(size=32), "y": SimTypeFloat(size=32), "arguments": SimUnion({"manipulation": SimStruct({"delta": SimStruct({"translationX": SimTypeFloat(size=32), "translationY": SimTypeFloat(size=32), "scale": SimTypeFloat(size=32), "expansion": SimTypeFloat(size=32), "rotation": SimTypeFloat(size=32)}, name="MANIPULATION_TRANSFORM", pack=False, align=None), "cumulative": SimStruct({"translationX": SimTypeFloat(size=32), "translationY": SimTypeFloat(size=32), "scale": SimTypeFloat(size=32), "expansion": SimTypeFloat(size=32), "rotation": SimTypeFloat(size=32)}, name="MANIPULATION_TRANSFORM", pack=False, align=None), "velocity": SimStruct({"velocityX": SimTypeFloat(size=32), "velocityY": SimTypeFloat(size=32), "velocityExpansion": SimTypeFloat(size=32), "velocityAngular": SimTypeFloat(size=32)}, name="MANIPULATION_VELOCITY", pack=False, align=None), "railsState": SimTypeInt(signed=False, label="MANIPULATION_RAILS_STATE")}, name="INTERACTION_ARGUMENTS_MANIPULATION", pack=False, align=None), "tap": SimStruct({"count": SimTypeInt(signed=False, label="UInt32")}, name="INTERACTION_ARGUMENTS_TAP", pack=False, align=None), "crossSlide": SimStruct({"flags": SimTypeInt(signed=False, label="CROSS_SLIDE_FLAGS")}, name="INTERACTION_ARGUMENTS_CROSS_SLIDE", pack=False, align=None)}, name="<anon>", label="None")}, name="INTERACTION_CONTEXT_OUTPUT", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["clientData", "output"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["interactionContext", "outputCallback", "clientData"]),
        # 
        'RegisterOutputCallbackInteractionContext2': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"interactionId": SimTypeInt(signed=False, label="INTERACTION_ID"), "interactionFlags": SimTypeInt(signed=False, label="INTERACTION_FLAGS"), "inputType": SimTypeBottom(label="POINTER_INPUT_TYPE"), "contactCount": SimTypeInt(signed=False, label="UInt32"), "currentContactCount": SimTypeInt(signed=False, label="UInt32"), "x": SimTypeFloat(size=32), "y": SimTypeFloat(size=32), "arguments": SimUnion({"manipulation": SimStruct({"delta": SimStruct({"translationX": SimTypeFloat(size=32), "translationY": SimTypeFloat(size=32), "scale": SimTypeFloat(size=32), "expansion": SimTypeFloat(size=32), "rotation": SimTypeFloat(size=32)}, name="MANIPULATION_TRANSFORM", pack=False, align=None), "cumulative": SimStruct({"translationX": SimTypeFloat(size=32), "translationY": SimTypeFloat(size=32), "scale": SimTypeFloat(size=32), "expansion": SimTypeFloat(size=32), "rotation": SimTypeFloat(size=32)}, name="MANIPULATION_TRANSFORM", pack=False, align=None), "velocity": SimStruct({"velocityX": SimTypeFloat(size=32), "velocityY": SimTypeFloat(size=32), "velocityExpansion": SimTypeFloat(size=32), "velocityAngular": SimTypeFloat(size=32)}, name="MANIPULATION_VELOCITY", pack=False, align=None), "railsState": SimTypeInt(signed=False, label="MANIPULATION_RAILS_STATE")}, name="INTERACTION_ARGUMENTS_MANIPULATION", pack=False, align=None), "tap": SimStruct({"count": SimTypeInt(signed=False, label="UInt32")}, name="INTERACTION_ARGUMENTS_TAP", pack=False, align=None), "crossSlide": SimStruct({"flags": SimTypeInt(signed=False, label="CROSS_SLIDE_FLAGS")}, name="INTERACTION_ARGUMENTS_CROSS_SLIDE", pack=False, align=None)}, name="<anon>", label="None")}, name="INTERACTION_CONTEXT_OUTPUT2", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["clientData", "output"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["interactionContext", "outputCallback", "clientData"]),
        # 
        'SetInteractionConfigurationInteractionContext': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"interactionId": SimTypeInt(signed=False, label="INTERACTION_ID"), "enable": SimTypeInt(signed=False, label="INTERACTION_CONFIGURATION_FLAGS")}, name="INTERACTION_CONTEXT_CONFIGURATION", pack=False, align=None), label="LPArray", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["interactionContext", "configurationCount", "configuration"]),
        # 
        'GetInteractionConfigurationInteractionContext': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"interactionId": SimTypeInt(signed=False, label="INTERACTION_ID"), "enable": SimTypeInt(signed=False, label="INTERACTION_CONFIGURATION_FLAGS")}, name="INTERACTION_CONTEXT_CONFIGURATION", pack=False, align=None), label="LPArray", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["interactionContext", "configurationCount", "configuration"]),
        # 
        'SetPropertyInteractionContext': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="INTERACTION_CONTEXT_PROPERTY"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["interactionContext", "contextProperty", "value"]),
        # 
        'GetPropertyInteractionContext': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="INTERACTION_CONTEXT_PROPERTY"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["interactionContext", "contextProperty", "value"]),
        # 
        'SetInertiaParameterInteractionContext': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="INERTIA_PARAMETER"), SimTypeFloat(size=32)], SimTypeInt(signed=True, label="Int32"), arg_names=["interactionContext", "inertiaParameter", "value"]),
        # 
        'GetInertiaParameterInteractionContext': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="INERTIA_PARAMETER"), SimTypePointer(SimTypeFloat(size=32), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["interactionContext", "inertiaParameter", "value"]),
        # 
        'SetCrossSlideParametersInteractionContext': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"threshold": SimTypeInt(signed=False, label="CROSS_SLIDE_THRESHOLD"), "distance": SimTypeFloat(size=32)}, name="CROSS_SLIDE_PARAMETER", pack=False, align=None), label="LPArray", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["interactionContext", "parameterCount", "crossSlideParameters"]),
        # 
        'GetCrossSlideParameterInteractionContext': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="CROSS_SLIDE_THRESHOLD"), SimTypePointer(SimTypeFloat(size=32), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["interactionContext", "threshold", "distance"]),
        # 
        'SetTapParameterInteractionContext': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="TAP_PARAMETER"), SimTypeFloat(size=32)], SimTypeInt(signed=True, label="Int32"), arg_names=["interactionContext", "parameter", "value"]),
        # 
        'GetTapParameterInteractionContext': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="TAP_PARAMETER"), SimTypePointer(SimTypeFloat(size=32), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["interactionContext", "parameter", "value"]),
        # 
        'SetHoldParameterInteractionContext': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="HOLD_PARAMETER"), SimTypeFloat(size=32)], SimTypeInt(signed=True, label="Int32"), arg_names=["interactionContext", "parameter", "value"]),
        # 
        'GetHoldParameterInteractionContext': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="HOLD_PARAMETER"), SimTypePointer(SimTypeFloat(size=32), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["interactionContext", "parameter", "value"]),
        # 
        'SetTranslationParameterInteractionContext': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="TRANSLATION_PARAMETER"), SimTypeFloat(size=32)], SimTypeInt(signed=True, label="Int32"), arg_names=["interactionContext", "parameter", "value"]),
        # 
        'GetTranslationParameterInteractionContext': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="TRANSLATION_PARAMETER"), SimTypePointer(SimTypeFloat(size=32), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["interactionContext", "parameter", "value"]),
        # 
        'SetMouseWheelParameterInteractionContext': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="MOUSE_WHEEL_PARAMETER"), SimTypeFloat(size=32)], SimTypeInt(signed=True, label="Int32"), arg_names=["interactionContext", "parameter", "value"]),
        # 
        'GetMouseWheelParameterInteractionContext': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="MOUSE_WHEEL_PARAMETER"), SimTypePointer(SimTypeFloat(size=32), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["interactionContext", "parameter", "value"]),
        # 
        'ResetInteractionContext': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["interactionContext"]),
        # 
        'GetStateInteractionContext': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"pointerType": SimTypeBottom(label="POINTER_INPUT_TYPE"), "pointerId": SimTypeInt(signed=False, label="UInt32"), "frameId": SimTypeInt(signed=False, label="UInt32"), "pointerFlags": SimTypeInt(signed=False, label="POINTER_FLAGS"), "sourceDevice": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hwndTarget": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ptPixelLocation": SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINT", pack=False, align=None), "ptHimetricLocation": SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINT", pack=False, align=None), "ptPixelLocationRaw": SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINT", pack=False, align=None), "ptHimetricLocationRaw": SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINT", pack=False, align=None), "dwTime": SimTypeInt(signed=False, label="UInt32"), "historyCount": SimTypeInt(signed=False, label="UInt32"), "InputData": SimTypeInt(signed=True, label="Int32"), "dwKeyStates": SimTypeInt(signed=False, label="UInt32"), "PerformanceCount": SimTypeLongLong(signed=False, label="UInt64"), "ButtonChangeType": SimTypeInt(signed=False, label="POINTER_BUTTON_CHANGE_TYPE")}, name="POINTER_INFO", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="INTERACTION_STATE"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["interactionContext", "pointerInfo", "state"]),
        # 
        'AddPointerInteractionContext': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["interactionContext", "pointerId"]),
        # 
        'RemovePointerInteractionContext': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["interactionContext", "pointerId"]),
        # 
        'ProcessPointerFramesInteractionContext': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"pointerType": SimTypeBottom(label="POINTER_INPUT_TYPE"), "pointerId": SimTypeInt(signed=False, label="UInt32"), "frameId": SimTypeInt(signed=False, label="UInt32"), "pointerFlags": SimTypeInt(signed=False, label="POINTER_FLAGS"), "sourceDevice": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hwndTarget": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ptPixelLocation": SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINT", pack=False, align=None), "ptHimetricLocation": SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINT", pack=False, align=None), "ptPixelLocationRaw": SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINT", pack=False, align=None), "ptHimetricLocationRaw": SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINT", pack=False, align=None), "dwTime": SimTypeInt(signed=False, label="UInt32"), "historyCount": SimTypeInt(signed=False, label="UInt32"), "InputData": SimTypeInt(signed=True, label="Int32"), "dwKeyStates": SimTypeInt(signed=False, label="UInt32"), "PerformanceCount": SimTypeLongLong(signed=False, label="UInt64"), "ButtonChangeType": SimTypeInt(signed=False, label="POINTER_BUTTON_CHANGE_TYPE")}, name="POINTER_INFO", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["interactionContext", "entriesCount", "pointerCount", "pointerInfo"]),
        # 
        'BufferPointerPacketsInteractionContext': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"pointerType": SimTypeBottom(label="POINTER_INPUT_TYPE"), "pointerId": SimTypeInt(signed=False, label="UInt32"), "frameId": SimTypeInt(signed=False, label="UInt32"), "pointerFlags": SimTypeInt(signed=False, label="POINTER_FLAGS"), "sourceDevice": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hwndTarget": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ptPixelLocation": SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINT", pack=False, align=None), "ptHimetricLocation": SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINT", pack=False, align=None), "ptPixelLocationRaw": SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINT", pack=False, align=None), "ptHimetricLocationRaw": SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINT", pack=False, align=None), "dwTime": SimTypeInt(signed=False, label="UInt32"), "historyCount": SimTypeInt(signed=False, label="UInt32"), "InputData": SimTypeInt(signed=True, label="Int32"), "dwKeyStates": SimTypeInt(signed=False, label="UInt32"), "PerformanceCount": SimTypeLongLong(signed=False, label="UInt64"), "ButtonChangeType": SimTypeInt(signed=False, label="POINTER_BUTTON_CHANGE_TYPE")}, name="POINTER_INFO", pack=False, align=None), label="LPArray", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["interactionContext", "entriesCount", "pointerInfo"]),
        # 
        'ProcessBufferedPacketsInteractionContext': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["interactionContext"]),
        # 
        'ProcessInertiaInteractionContext': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["interactionContext"]),
        # 
        'StopInteractionContext': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["interactionContext"]),
        # 
        'SetPivotInteractionContext': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeFloat(size=32), SimTypeFloat(size=32), SimTypeFloat(size=32)], SimTypeInt(signed=True, label="Int32"), arg_names=["interactionContext", "x", "y", "radius"]),
    }

lib.set_prototypes(prototypes)
