# pylint:disable=line-too-long
import logging

from ...sim_type import SimTypeFunction,     SimTypeShort, SimTypeInt, SimTypeLong, SimTypeLongLong, SimTypeDouble, SimTypeFloat,     SimTypePointer,     SimTypeChar,     SimStruct,     SimTypeFixedSizeArray,     SimTypeBottom,     SimUnion,     SimTypeBool
from ...calling_conventions import SimCCStdcall, SimCCMicrosoftAMD64
from .. import SIM_PROCEDURES as P
from . import SimLibrary


_l = logging.getLogger(name=__name__)


lib = SimLibrary()
lib.set_default_cc('X86', SimCCStdcall)
lib.set_default_cc('AMD64', SimCCMicrosoftAMD64)
lib.set_library_names("p2p.dll")
prototypes = \
    {
        # 
        'PeerFreeData': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pvData"]),
        # 
        'PeerGetItemCount': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hPeerEnum", "pCount"]),
        # 
        'PeerGetNextItem': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hPeerEnum", "pCount", "pppvItems"]),
        # 
        'PeerEndEnumeration': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hPeerEnum"]),
        # 
        'PeerGroupStartup': SimTypeFunction([SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimStruct({"wVersion": SimTypeShort(signed=False, label="UInt16"), "wHighestVersion": SimTypeShort(signed=False, label="UInt16")}, name="PEER_VERSION_DATA", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["wVersionRequested", "pVersionData"]),
        # 
        'PeerGroupShutdown': SimTypeFunction([], SimTypeInt(signed=True, label="Int32")),
        # 
        'PeerGroupCreate': SimTypeFunction([SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "pwzCloud": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzClassifier": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzGroupPeerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzCreatorPeerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzFriendlyName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ulMemberDataLifetime": SimTypeInt(signed=False, label="UInt32"), "ulPresenceLifetime": SimTypeInt(signed=False, label="UInt32"), "dwAuthenticationSchemes": SimTypeInt(signed=False, label="UInt32"), "pwzGroupPassword": SimTypePointer(SimTypeChar(label="Char"), offset=0), "groupPasswordRole": SimTypeBottom(label="Guid")}, name="PEER_GROUP_PROPERTIES", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pProperties", "phGroup"]),
        # 
        'PeerGroupOpen': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pwzIdentity", "pwzGroupPeerName", "pwzCloud", "phGroup"]),
        # 
        'PeerGroupJoin': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pwzIdentity", "pwzInvitation", "pwzCloud", "phGroup"]),
        # 
        'PeerGroupPasswordJoin': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pwzIdentity", "pwzInvitation", "pwzPassword", "pwzCloud", "phGroup"]),
        # 
        'PeerGroupConnect': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hGroup"]),
        # 
        'PeerGroupConnectByAddress': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "sin6": SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None)}, name="PEER_ADDRESS", pack=False, align=None), label="LPArray", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hGroup", "cAddresses", "pAddresses"]),
        # 
        'PeerGroupClose': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hGroup"]),
        # 
        'PeerGroupDelete': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pwzIdentity", "pwzGroupPeerName"]),
        # 
        'PeerGroupCreateInvitation': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Guid"), label="LPArray", offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hGroup", "pwzIdentityInfo", "pftExpiration", "cRoles", "pRoles", "ppwzInvitation"]),
        # 
        'PeerGroupCreatePasswordInvitation': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hGroup", "ppwzInvitation"]),
        # 
        'PeerGroupParseInvitation': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "pwzCloudName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwScope": SimTypeInt(signed=False, label="UInt32"), "dwCloudFlags": SimTypeInt(signed=False, label="UInt32"), "pwzGroupPeerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzIssuerPeerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzSubjectPeerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzGroupFriendlyName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzIssuerFriendlyName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzSubjectFriendlyName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ftValidityStart": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "ftValidityEnd": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cRoles": SimTypeInt(signed=False, label="UInt32"), "pRoles": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "cClassifiers": SimTypeInt(signed=False, label="UInt32"), "ppwzClassifiers": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), "pSubjectPublicKey": SimTypePointer(SimTypeBottom(label="CERT_PUBLIC_KEY_INFO"), offset=0), "authScheme": SimTypeInt(signed=False, label="PEER_GROUP_AUTHENTICATION_SCHEME")}, name="PEER_INVITATION_INFO", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pwzInvitation", "ppInvitationInfo"]),
        # 
        'PeerGroupGetStatus': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hGroup", "pdwStatus"]),
        # 
        'PeerGroupGetProperties': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "pwzCloud": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzClassifier": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzGroupPeerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzCreatorPeerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzFriendlyName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ulMemberDataLifetime": SimTypeInt(signed=False, label="UInt32"), "ulPresenceLifetime": SimTypeInt(signed=False, label="UInt32"), "dwAuthenticationSchemes": SimTypeInt(signed=False, label="UInt32"), "pwzGroupPassword": SimTypePointer(SimTypeChar(label="Char"), offset=0), "groupPasswordRole": SimTypeBottom(label="Guid")}, name="PEER_GROUP_PROPERTIES", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hGroup", "ppProperties"]),
        # 
        'PeerGroupSetProperties': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "pwzCloud": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzClassifier": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzGroupPeerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzCreatorPeerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzFriendlyName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ulMemberDataLifetime": SimTypeInt(signed=False, label="UInt32"), "ulPresenceLifetime": SimTypeInt(signed=False, label="UInt32"), "dwAuthenticationSchemes": SimTypeInt(signed=False, label="UInt32"), "pwzGroupPassword": SimTypePointer(SimTypeChar(label="Char"), offset=0), "groupPasswordRole": SimTypeBottom(label="Guid")}, name="PEER_GROUP_PROPERTIES", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hGroup", "pProperties"]),
        # 
        'PeerGroupEnumMembers': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hGroup", "dwFlags", "pwzIdentity", "phPeerEnum"]),
        # 
        'PeerGroupOpenDirectConnection': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "sin6": SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None)}, name="PEER_ADDRESS", pack=False, align=None), offset=0), SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hGroup", "pwzIdentity", "pAddress", "pullConnectionId"]),
        # 
        'PeerGroupCloseDirectConnection': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeLongLong(signed=False, label="UInt64")], SimTypeInt(signed=True, label="Int32"), arg_names=["hGroup", "ullConnectionId"]),
        # 
        'PeerGroupEnumConnections': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hGroup", "dwFlags", "phPeerEnum"]),
        # 
        'PeerGroupSendData': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hGroup", "ullConnectionId", "pType", "cbData", "pvData"]),
        # 
        'PeerGroupRegisterEvent': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"eventType": SimTypeInt(signed=False, label="PEER_GROUP_EVENT_TYPE"), "pType": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="PEER_GROUP_EVENT_REGISTRATION", pack=False, align=None), label="LPArray", offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hGroup", "hEvent", "cEventRegistration", "pEventRegistrations", "phPeerEvent"]),
        # 
        'PeerGroupUnregisterEvent': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hPeerEvent"]),
        # 
        'PeerGroupGetEventData': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"eventType": SimTypeInt(signed=False, label="PEER_GROUP_EVENT_TYPE"), "Anonymous": SimUnion({"dwStatus": SimTypeInt(signed=False, label="PEER_GROUP_STATUS"), "incomingData": SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "ullConnectionId": SimTypeLongLong(signed=False, label="UInt64"), "type": SimTypeBottom(label="Guid"), "data": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="PEER_DATA", pack=False, align=None)}, name="PEER_EVENT_INCOMING_DATA", pack=False, align=None), "recordChangeData": SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "changeType": SimTypeInt(signed=False, label="PEER_RECORD_CHANGE_TYPE"), "recordId": SimTypeBottom(label="Guid"), "recordType": SimTypeBottom(label="Guid")}, name="PEER_EVENT_RECORD_CHANGE_DATA", pack=False, align=None), "connectionChangeData": SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "status": SimTypeInt(signed=False, label="PEER_CONNECTION_STATUS"), "ullConnectionId": SimTypeLongLong(signed=False, label="UInt64"), "ullNodeId": SimTypeLongLong(signed=False, label="UInt64"), "ullNextConnectionId": SimTypeLongLong(signed=False, label="UInt64"), "hrConnectionFailedReason": SimTypeInt(signed=True, label="Int32")}, name="PEER_EVENT_CONNECTION_CHANGE_DATA", pack=False, align=None), "memberChangeData": SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "changeType": SimTypeInt(signed=False, label="PEER_MEMBER_CHANGE_TYPE"), "pwzIdentity": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="PEER_EVENT_MEMBER_CHANGE_DATA", pack=False, align=None), "hrConnectionFailedReason": SimTypeInt(signed=True, label="Int32")}, name="<anon>", label="None")}, name="PEER_GROUP_EVENT_DATA", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hPeerEvent", "ppEventData"]),
        # 
        'PeerGroupGetRecord': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "type": SimTypeBottom(label="Guid"), "id": SimTypeBottom(label="Guid"), "dwVersion": SimTypeInt(signed=False, label="UInt32"), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "pwzCreatorId": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzModifiedById": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzAttributes": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ftCreation": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "ftExpiration": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "ftLastModified": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "securityData": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="PEER_DATA", pack=False, align=None), "data": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="PEER_DATA", pack=False, align=None)}, name="PEER_RECORD", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hGroup", "pRecordId", "ppRecord"]),
        # 
        'PeerGroupAddRecord': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "type": SimTypeBottom(label="Guid"), "id": SimTypeBottom(label="Guid"), "dwVersion": SimTypeInt(signed=False, label="UInt32"), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "pwzCreatorId": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzModifiedById": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzAttributes": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ftCreation": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "ftExpiration": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "ftLastModified": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "securityData": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="PEER_DATA", pack=False, align=None), "data": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="PEER_DATA", pack=False, align=None)}, name="PEER_RECORD", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hGroup", "pRecord", "pRecordId"]),
        # 
        'PeerGroupUpdateRecord': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "type": SimTypeBottom(label="Guid"), "id": SimTypeBottom(label="Guid"), "dwVersion": SimTypeInt(signed=False, label="UInt32"), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "pwzCreatorId": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzModifiedById": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzAttributes": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ftCreation": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "ftExpiration": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "ftLastModified": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "securityData": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="PEER_DATA", pack=False, align=None), "data": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="PEER_DATA", pack=False, align=None)}, name="PEER_RECORD", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hGroup", "pRecord"]),
        # 
        'PeerGroupDeleteRecord': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hGroup", "pRecordId"]),
        # 
        'PeerGroupEnumRecords': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hGroup", "pRecordType", "phPeerEnum"]),
        # 
        'PeerGroupSearchRecords': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hGroup", "pwzCriteria", "phPeerEnum"]),
        # 
        'PeerGroupExportDatabase': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hGroup", "pwzFilePath"]),
        # 
        'PeerGroupImportDatabase': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hGroup", "pwzFilePath"]),
        # 
        'PeerGroupIssueCredentials': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "pwzFriendlyName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pPublicKey": SimTypePointer(SimTypeBottom(label="CERT_PUBLIC_KEY_INFO"), offset=0), "pwzIssuerPeerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzIssuerFriendlyName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ftValidityStart": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "ftValidityEnd": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cRoles": SimTypeInt(signed=False, label="UInt32"), "pRoles": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="PEER_CREDENTIAL_INFO", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hGroup", "pwzSubjectIdentity", "pCredentialInfo", "dwFlags", "ppwzInvitation"]),
        # 
        'PeerGroupExportConfig': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hGroup", "pwzPassword", "ppwzXML"]),
        # 
        'PeerGroupImportConfig': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pwzXML", "pwzPassword", "fOverwrite", "ppwzIdentity", "ppwzGroup"]),
        # 
        'PeerGroupPeerTimeToUniversalTime': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hGroup", "pftPeerTime", "pftUniversalTime"]),
        # 
        'PeerGroupUniversalTimeToPeerTime': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hGroup", "pftUniversalTime", "pftPeerTime"]),
        # 
        'PeerGroupResumePasswordAuthentication': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hGroup", "hPeerEventHandle"]),
        # 
        'PeerIdentityCreate': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pwzClassifier", "pwzFriendlyName", "hCryptProv", "ppwzIdentity"]),
        # 
        'PeerIdentityGetFriendlyName': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pwzIdentity", "ppwzFriendlyName"]),
        # 
        'PeerIdentitySetFriendlyName': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pwzIdentity", "pwzFriendlyName"]),
        # 
        'PeerIdentityGetCryptKey': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pwzIdentity", "phCryptProv"]),
        # 
        'PeerIdentityDelete': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pwzIdentity"]),
        # 
        'PeerEnumIdentities': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["phPeerEnum"]),
        # 
        'PeerEnumGroups': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pwzIdentity", "phPeerEnum"]),
        # 
        'PeerCreatePeerName': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pwzIdentity", "pwzClassifier", "ppwzPeerName"]),
        # 
        'PeerIdentityGetXML': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pwzIdentity", "ppwzIdentityXML"]),
        # 
        'PeerIdentityExport': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pwzIdentity", "pwzPassword", "ppwzExportXML"]),
        # 
        'PeerIdentityImport': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pwzImportXML", "pwzPassword", "ppwzIdentity"]),
        # 
        'PeerIdentityGetDefault': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ppwzPeerName"]),
        # 
        'PeerCollabStartup': SimTypeFunction([SimTypeShort(signed=False, label="UInt16")], SimTypeInt(signed=True, label="Int32"), arg_names=["wVersionRequested"]),
        # 
        'PeerCollabShutdown': SimTypeFunction([], SimTypeInt(signed=True, label="Int32")),
        # 
        'PeerCollabSignin': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hwndParent", "dwSigninOptions"]),
        # 
        'PeerCollabSignout': SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["dwSigninOptions"]),
        # 
        'PeerCollabGetSigninOptions': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pdwSigninOptions"]),
        # 
        'PeerCollabAsyncInviteContact': SimTypeFunction([SimTypePointer(SimStruct({"pwzPeerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzNickName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzDisplayName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzEmailAddress": SimTypePointer(SimTypeChar(label="Char"), offset=0), "fWatch": SimTypeInt(signed=True, label="Int32"), "WatcherPermissions": SimTypeInt(signed=False, label="PEER_WATCH_PERMISSION"), "credentials": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="PEER_DATA", pack=False, align=None)}, name="PEER_CONTACT", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"address": SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "sin6": SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None)}, name="PEER_ADDRESS", pack=False, align=None), "pwzEndpointName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="PEER_ENDPOINT", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"applicationId": SimTypeBottom(label="Guid"), "applicationData": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="PEER_DATA", pack=False, align=None), "pwzMessage": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="PEER_INVITATION", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pcContact", "pcEndpoint", "pcInvitation", "hEvent", "phInvitation"]),
        # 
        'PeerCollabGetInvitationResponse': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypePointer(SimStruct({"action": SimTypeInt(signed=False, label="PEER_INVITATION_RESPONSE_TYPE"), "pwzMessage": SimTypePointer(SimTypeChar(label="Char"), offset=0), "hrExtendedInfo": SimTypeInt(signed=True, label="Int32")}, name="PEER_INVITATION_RESPONSE", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hInvitation", "ppInvitationResponse"]),
        # 
        'PeerCollabCancelInvitation': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hInvitation"]),
        # 
        'PeerCollabCloseHandle': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hInvitation"]),
        # 
        'PeerCollabInviteContact': SimTypeFunction([SimTypePointer(SimStruct({"pwzPeerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzNickName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzDisplayName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzEmailAddress": SimTypePointer(SimTypeChar(label="Char"), offset=0), "fWatch": SimTypeInt(signed=True, label="Int32"), "WatcherPermissions": SimTypeInt(signed=False, label="PEER_WATCH_PERMISSION"), "credentials": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="PEER_DATA", pack=False, align=None)}, name="PEER_CONTACT", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"address": SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "sin6": SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None)}, name="PEER_ADDRESS", pack=False, align=None), "pwzEndpointName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="PEER_ENDPOINT", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"applicationId": SimTypeBottom(label="Guid"), "applicationData": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="PEER_DATA", pack=False, align=None), "pwzMessage": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="PEER_INVITATION", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimStruct({"action": SimTypeInt(signed=False, label="PEER_INVITATION_RESPONSE_TYPE"), "pwzMessage": SimTypePointer(SimTypeChar(label="Char"), offset=0), "hrExtendedInfo": SimTypeInt(signed=True, label="Int32")}, name="PEER_INVITATION_RESPONSE", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pcContact", "pcEndpoint", "pcInvitation", "ppResponse"]),
        # 
        'PeerCollabAsyncInviteEndpoint': SimTypeFunction([SimTypePointer(SimStruct({"address": SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "sin6": SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None)}, name="PEER_ADDRESS", pack=False, align=None), "pwzEndpointName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="PEER_ENDPOINT", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"applicationId": SimTypeBottom(label="Guid"), "applicationData": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="PEER_DATA", pack=False, align=None), "pwzMessage": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="PEER_INVITATION", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pcEndpoint", "pcInvitation", "hEvent", "phInvitation"]),
        # 
        'PeerCollabInviteEndpoint': SimTypeFunction([SimTypePointer(SimStruct({"address": SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "sin6": SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None)}, name="PEER_ADDRESS", pack=False, align=None), "pwzEndpointName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="PEER_ENDPOINT", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"applicationId": SimTypeBottom(label="Guid"), "applicationData": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="PEER_DATA", pack=False, align=None), "pwzMessage": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="PEER_INVITATION", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimStruct({"action": SimTypeInt(signed=False, label="PEER_INVITATION_RESPONSE_TYPE"), "pwzMessage": SimTypePointer(SimTypeChar(label="Char"), offset=0), "hrExtendedInfo": SimTypeInt(signed=True, label="Int32")}, name="PEER_INVITATION_RESPONSE", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pcEndpoint", "pcInvitation", "ppResponse"]),
        # 
        'PeerCollabGetAppLaunchInfo': SimTypeFunction([SimTypePointer(SimTypePointer(SimStruct({"pContact": SimTypePointer(SimStruct({"pwzPeerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzNickName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzDisplayName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzEmailAddress": SimTypePointer(SimTypeChar(label="Char"), offset=0), "fWatch": SimTypeInt(signed=True, label="Int32"), "WatcherPermissions": SimTypeInt(signed=False, label="PEER_WATCH_PERMISSION"), "credentials": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="PEER_DATA", pack=False, align=None)}, name="PEER_CONTACT", pack=False, align=None), offset=0), "pEndpoint": SimTypePointer(SimStruct({"address": SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "sin6": SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None)}, name="PEER_ADDRESS", pack=False, align=None), "pwzEndpointName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="PEER_ENDPOINT", pack=False, align=None), offset=0), "pInvitation": SimTypePointer(SimStruct({"applicationId": SimTypeBottom(label="Guid"), "applicationData": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="PEER_DATA", pack=False, align=None), "pwzMessage": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="PEER_INVITATION", pack=False, align=None), offset=0)}, name="PEER_APP_LAUNCH_INFO", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ppLaunchInfo"]),
        # 
        'PeerCollabRegisterApplication': SimTypeFunction([SimTypePointer(SimStruct({"application": SimStruct({"id": SimTypeBottom(label="Guid"), "data": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="PEER_DATA", pack=False, align=None), "pwzDescription": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="PEER_APPLICATION", pack=False, align=None), "pwzApplicationToLaunch": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzApplicationArguments": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwPublicationScope": SimTypeInt(signed=False, label="UInt32")}, name="PEER_APPLICATION_REGISTRATION_INFO", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="PEER_APPLICATION_REGISTRATION_TYPE")], SimTypeInt(signed=True, label="Int32"), arg_names=["pcApplication", "registrationType"]),
        # 
        'PeerCollabUnregisterApplication': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="PEER_APPLICATION_REGISTRATION_TYPE")], SimTypeInt(signed=True, label="Int32"), arg_names=["pApplicationId", "registrationType"]),
        # 
        'PeerCollabGetApplicationRegistrationInfo': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="PEER_APPLICATION_REGISTRATION_TYPE"), SimTypePointer(SimTypePointer(SimStruct({"application": SimStruct({"id": SimTypeBottom(label="Guid"), "data": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="PEER_DATA", pack=False, align=None), "pwzDescription": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="PEER_APPLICATION", pack=False, align=None), "pwzApplicationToLaunch": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzApplicationArguments": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwPublicationScope": SimTypeInt(signed=False, label="UInt32")}, name="PEER_APPLICATION_REGISTRATION_INFO", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pApplicationId", "registrationType", "ppApplication"]),
        # 
        'PeerCollabEnumApplicationRegistrationInfo': SimTypeFunction([SimTypeInt(signed=False, label="PEER_APPLICATION_REGISTRATION_TYPE"), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["registrationType", "phPeerEnum"]),
        # 
        'PeerCollabGetPresenceInfo': SimTypeFunction([SimTypePointer(SimStruct({"address": SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "sin6": SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None)}, name="PEER_ADDRESS", pack=False, align=None), "pwzEndpointName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="PEER_ENDPOINT", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimStruct({"status": SimTypeInt(signed=False, label="PEER_PRESENCE_STATUS"), "pwzDescriptiveText": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="PEER_PRESENCE_INFO", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pcEndpoint", "ppPresenceInfo"]),
        # 
        'PeerCollabEnumApplications': SimTypeFunction([SimTypePointer(SimStruct({"address": SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "sin6": SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None)}, name="PEER_ADDRESS", pack=False, align=None), "pwzEndpointName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="PEER_ENDPOINT", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pcEndpoint", "pApplicationId", "phPeerEnum"]),
        # 
        'PeerCollabEnumObjects': SimTypeFunction([SimTypePointer(SimStruct({"address": SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "sin6": SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None)}, name="PEER_ADDRESS", pack=False, align=None), "pwzEndpointName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="PEER_ENDPOINT", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pcEndpoint", "pObjectId", "phPeerEnum"]),
        # 
        'PeerCollabEnumEndpoints': SimTypeFunction([SimTypePointer(SimStruct({"pwzPeerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzNickName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzDisplayName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzEmailAddress": SimTypePointer(SimTypeChar(label="Char"), offset=0), "fWatch": SimTypeInt(signed=True, label="Int32"), "WatcherPermissions": SimTypeInt(signed=False, label="PEER_WATCH_PERMISSION"), "credentials": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="PEER_DATA", pack=False, align=None)}, name="PEER_CONTACT", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pcContact", "phPeerEnum"]),
        # 
        'PeerCollabRefreshEndpointData': SimTypeFunction([SimTypePointer(SimStruct({"address": SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "sin6": SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None)}, name="PEER_ADDRESS", pack=False, align=None), "pwzEndpointName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="PEER_ENDPOINT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pcEndpoint"]),
        # 
        'PeerCollabDeleteEndpointData': SimTypeFunction([SimTypePointer(SimStruct({"address": SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "sin6": SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None)}, name="PEER_ADDRESS", pack=False, align=None), "pwzEndpointName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="PEER_ENDPOINT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pcEndpoint"]),
        # 
        'PeerCollabQueryContactData': SimTypeFunction([SimTypePointer(SimStruct({"address": SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "sin6": SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None)}, name="PEER_ADDRESS", pack=False, align=None), "pwzEndpointName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="PEER_ENDPOINT", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pcEndpoint", "ppwzContactData"]),
        # 
        'PeerCollabSubscribeEndpointData': SimTypeFunction([SimTypePointer(SimStruct({"address": SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "sin6": SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None)}, name="PEER_ADDRESS", pack=False, align=None), "pwzEndpointName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="PEER_ENDPOINT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pcEndpoint"]),
        # 
        'PeerCollabUnsubscribeEndpointData': SimTypeFunction([SimTypePointer(SimStruct({"address": SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "sin6": SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None)}, name="PEER_ADDRESS", pack=False, align=None), "pwzEndpointName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="PEER_ENDPOINT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pcEndpoint"]),
        # 
        'PeerCollabSetPresenceInfo': SimTypeFunction([SimTypePointer(SimStruct({"status": SimTypeInt(signed=False, label="PEER_PRESENCE_STATUS"), "pwzDescriptiveText": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="PEER_PRESENCE_INFO", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pcPresenceInfo"]),
        # 
        'PeerCollabGetEndpointName': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ppwzEndpointName"]),
        # 
        'PeerCollabSetEndpointName': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pwzEndpointName"]),
        # 
        'PeerCollabSetObject': SimTypeFunction([SimTypePointer(SimStruct({"id": SimTypeBottom(label="Guid"), "data": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="PEER_DATA", pack=False, align=None), "dwPublicationScope": SimTypeInt(signed=False, label="UInt32")}, name="PEER_OBJECT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pcObject"]),
        # 
        'PeerCollabDeleteObject': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pObjectId"]),
        # 
        'PeerCollabRegisterEvent': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"eventType": SimTypeInt(signed=False, label="PEER_COLLAB_EVENT_TYPE"), "pInstance": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="PEER_COLLAB_EVENT_REGISTRATION", pack=False, align=None), label="LPArray", offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hEvent", "cEventRegistration", "pEventRegistrations", "phPeerEvent"]),
        # 
        'PeerCollabGetEventData': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"eventType": SimTypeInt(signed=False, label="PEER_COLLAB_EVENT_TYPE"), "Anonymous": SimUnion({"watchListChangedData": SimStruct({"pContact": SimTypePointer(SimStruct({"pwzPeerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzNickName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzDisplayName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzEmailAddress": SimTypePointer(SimTypeChar(label="Char"), offset=0), "fWatch": SimTypeInt(signed=True, label="Int32"), "WatcherPermissions": SimTypeInt(signed=False, label="PEER_WATCH_PERMISSION"), "credentials": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="PEER_DATA", pack=False, align=None)}, name="PEER_CONTACT", pack=False, align=None), offset=0), "changeType": SimTypeInt(signed=False, label="PEER_CHANGE_TYPE")}, name="PEER_EVENT_WATCHLIST_CHANGED_DATA", pack=False, align=None), "presenceChangedData": SimStruct({"pContact": SimTypePointer(SimStruct({"pwzPeerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzNickName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzDisplayName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzEmailAddress": SimTypePointer(SimTypeChar(label="Char"), offset=0), "fWatch": SimTypeInt(signed=True, label="Int32"), "WatcherPermissions": SimTypeInt(signed=False, label="PEER_WATCH_PERMISSION"), "credentials": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="PEER_DATA", pack=False, align=None)}, name="PEER_CONTACT", pack=False, align=None), offset=0), "pEndpoint": SimTypePointer(SimStruct({"address": SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "sin6": SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None)}, name="PEER_ADDRESS", pack=False, align=None), "pwzEndpointName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="PEER_ENDPOINT", pack=False, align=None), offset=0), "changeType": SimTypeInt(signed=False, label="PEER_CHANGE_TYPE"), "pPresenceInfo": SimTypePointer(SimStruct({"status": SimTypeInt(signed=False, label="PEER_PRESENCE_STATUS"), "pwzDescriptiveText": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="PEER_PRESENCE_INFO", pack=False, align=None), offset=0)}, name="PEER_EVENT_PRESENCE_CHANGED_DATA", pack=False, align=None), "applicationChangedData": SimStruct({"pContact": SimTypePointer(SimStruct({"pwzPeerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzNickName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzDisplayName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzEmailAddress": SimTypePointer(SimTypeChar(label="Char"), offset=0), "fWatch": SimTypeInt(signed=True, label="Int32"), "WatcherPermissions": SimTypeInt(signed=False, label="PEER_WATCH_PERMISSION"), "credentials": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="PEER_DATA", pack=False, align=None)}, name="PEER_CONTACT", pack=False, align=None), offset=0), "pEndpoint": SimTypePointer(SimStruct({"address": SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "sin6": SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None)}, name="PEER_ADDRESS", pack=False, align=None), "pwzEndpointName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="PEER_ENDPOINT", pack=False, align=None), offset=0), "changeType": SimTypeInt(signed=False, label="PEER_CHANGE_TYPE"), "pApplication": SimTypePointer(SimStruct({"id": SimTypeBottom(label="Guid"), "data": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="PEER_DATA", pack=False, align=None), "pwzDescription": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="PEER_APPLICATION", pack=False, align=None), offset=0)}, name="PEER_EVENT_APPLICATION_CHANGED_DATA", pack=False, align=None), "objectChangedData": SimStruct({"pContact": SimTypePointer(SimStruct({"pwzPeerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzNickName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzDisplayName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzEmailAddress": SimTypePointer(SimTypeChar(label="Char"), offset=0), "fWatch": SimTypeInt(signed=True, label="Int32"), "WatcherPermissions": SimTypeInt(signed=False, label="PEER_WATCH_PERMISSION"), "credentials": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="PEER_DATA", pack=False, align=None)}, name="PEER_CONTACT", pack=False, align=None), offset=0), "pEndpoint": SimTypePointer(SimStruct({"address": SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "sin6": SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None)}, name="PEER_ADDRESS", pack=False, align=None), "pwzEndpointName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="PEER_ENDPOINT", pack=False, align=None), offset=0), "changeType": SimTypeInt(signed=False, label="PEER_CHANGE_TYPE"), "pObject": SimTypePointer(SimStruct({"id": SimTypeBottom(label="Guid"), "data": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="PEER_DATA", pack=False, align=None), "dwPublicationScope": SimTypeInt(signed=False, label="UInt32")}, name="PEER_OBJECT", pack=False, align=None), offset=0)}, name="PEER_EVENT_OBJECT_CHANGED_DATA", pack=False, align=None), "endpointChangedData": SimStruct({"pContact": SimTypePointer(SimStruct({"pwzPeerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzNickName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzDisplayName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzEmailAddress": SimTypePointer(SimTypeChar(label="Char"), offset=0), "fWatch": SimTypeInt(signed=True, label="Int32"), "WatcherPermissions": SimTypeInt(signed=False, label="PEER_WATCH_PERMISSION"), "credentials": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="PEER_DATA", pack=False, align=None)}, name="PEER_CONTACT", pack=False, align=None), offset=0), "pEndpoint": SimTypePointer(SimStruct({"address": SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "sin6": SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None)}, name="PEER_ADDRESS", pack=False, align=None), "pwzEndpointName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="PEER_ENDPOINT", pack=False, align=None), offset=0)}, name="PEER_EVENT_ENDPOINT_CHANGED_DATA", pack=False, align=None), "peopleNearMeChangedData": SimStruct({"changeType": SimTypeInt(signed=False, label="PEER_CHANGE_TYPE"), "pPeopleNearMe": SimTypePointer(SimStruct({"pwzNickName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "endpoint": SimStruct({"address": SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "sin6": SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None)}, name="PEER_ADDRESS", pack=False, align=None), "pwzEndpointName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="PEER_ENDPOINT", pack=False, align=None), "id": SimTypeBottom(label="Guid")}, name="PEER_PEOPLE_NEAR_ME", pack=False, align=None), offset=0)}, name="PEER_EVENT_PEOPLE_NEAR_ME_CHANGED_DATA", pack=False, align=None), "requestStatusChangedData": SimStruct({"pEndpoint": SimTypePointer(SimStruct({"address": SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "sin6": SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None)}, name="PEER_ADDRESS", pack=False, align=None), "pwzEndpointName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="PEER_ENDPOINT", pack=False, align=None), offset=0), "hrChange": SimTypeInt(signed=True, label="Int32")}, name="PEER_EVENT_REQUEST_STATUS_CHANGED_DATA", pack=False, align=None)}, name="<anon>", label="None")}, name="PEER_COLLAB_EVENT_DATA", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hPeerEvent", "ppEventData"]),
        # 
        'PeerCollabUnregisterEvent': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hPeerEvent"]),
        # 
        'PeerCollabEnumPeopleNearMe': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["phPeerEnum"]),
        # 
        'PeerCollabAddContact': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"pwzPeerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzNickName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzDisplayName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzEmailAddress": SimTypePointer(SimTypeChar(label="Char"), offset=0), "fWatch": SimTypeInt(signed=True, label="Int32"), "WatcherPermissions": SimTypeInt(signed=False, label="PEER_WATCH_PERMISSION"), "credentials": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="PEER_DATA", pack=False, align=None)}, name="PEER_CONTACT", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pwzContactData", "ppContact"]),
        # 
        'PeerCollabDeleteContact': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pwzPeerName"]),
        # 
        'PeerCollabGetContact': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"pwzPeerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzNickName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzDisplayName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzEmailAddress": SimTypePointer(SimTypeChar(label="Char"), offset=0), "fWatch": SimTypeInt(signed=True, label="Int32"), "WatcherPermissions": SimTypeInt(signed=False, label="PEER_WATCH_PERMISSION"), "credentials": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="PEER_DATA", pack=False, align=None)}, name="PEER_CONTACT", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pwzPeerName", "ppContact"]),
        # 
        'PeerCollabUpdateContact': SimTypeFunction([SimTypePointer(SimStruct({"pwzPeerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzNickName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzDisplayName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzEmailAddress": SimTypePointer(SimTypeChar(label="Char"), offset=0), "fWatch": SimTypeInt(signed=True, label="Int32"), "WatcherPermissions": SimTypeInt(signed=False, label="PEER_WATCH_PERMISSION"), "credentials": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="PEER_DATA", pack=False, align=None)}, name="PEER_CONTACT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pContact"]),
        # 
        'PeerCollabEnumContacts': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["phPeerEnum"]),
        # 
        'PeerCollabExportContact': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pwzPeerName", "ppwzContactData"]),
        # 
        'PeerCollabParseContact': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"pwzPeerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzNickName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzDisplayName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzEmailAddress": SimTypePointer(SimTypeChar(label="Char"), offset=0), "fWatch": SimTypeInt(signed=True, label="Int32"), "WatcherPermissions": SimTypeInt(signed=False, label="PEER_WATCH_PERMISSION"), "credentials": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="PEER_DATA", pack=False, align=None)}, name="PEER_CONTACT", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pwzContactData", "ppContact"]),
        # 
        'PeerNameToPeerHostName': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pwzPeerName", "ppwzHostName"]),
        # 
        'PeerHostNameToPeerName': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pwzHostName", "ppwzPeerName"]),
        # 
        'PeerPnrpStartup': SimTypeFunction([SimTypeShort(signed=False, label="UInt16")], SimTypeInt(signed=True, label="Int32"), arg_names=["wVersionRequested"]),
        # 
        'PeerPnrpShutdown': SimTypeFunction([], SimTypeInt(signed=True, label="Int32")),
        # 
        'PeerPnrpRegister': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"pwzCloudName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzPublishingIdentity": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cAddresses": SimTypeInt(signed=False, label="UInt32"), "ppAddresses": SimTypePointer(SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), offset=0), "wPort": SimTypeShort(signed=False, label="UInt16"), "pwzComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "payload": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="PEER_DATA", pack=False, align=None)}, name="PEER_PNRP_REGISTRATION_INFO", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pcwzPeerName", "pRegistrationInfo", "phRegistration"]),
        # 
        'PeerPnrpUpdateRegistration': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"pwzCloudName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzPublishingIdentity": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cAddresses": SimTypeInt(signed=False, label="UInt32"), "ppAddresses": SimTypePointer(SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), offset=0), "wPort": SimTypeShort(signed=False, label="UInt16"), "pwzComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "payload": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="PEER_DATA", pack=False, align=None)}, name="PEER_PNRP_REGISTRATION_INFO", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hRegistration", "pRegistrationInfo"]),
        # 
        'PeerPnrpUnregister': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hRegistration"]),
        # 
        'PeerPnrpResolve': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"pwzPeerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cAddresses": SimTypeInt(signed=False, label="UInt32"), "ppAddresses": SimTypePointer(SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), offset=0), "pwzComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "payload": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="PEER_DATA", pack=False, align=None)}, name="PEER_PNRP_ENDPOINT_INFO", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pcwzPeerName", "pcwzCloudName", "pcEndpoints", "ppEndpoints"]),
        # 
        'PeerPnrpStartResolve': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pcwzPeerName", "pcwzCloudName", "cMaxEndpoints", "hEvent", "phResolve"]),
        # 
        'PeerPnrpGetCloudInfo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"pwzCloudName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwScope": SimTypeInt(signed=False, label="PNRP_SCOPE"), "dwScopeId": SimTypeInt(signed=False, label="UInt32")}, name="PEER_PNRP_CLOUD_INFO", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pcNumClouds", "ppCloudInfo"]),
        # 
        'PeerPnrpGetEndpoint': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"pwzPeerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cAddresses": SimTypeInt(signed=False, label="UInt32"), "ppAddresses": SimTypePointer(SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), offset=0), "pwzComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "payload": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="PEER_DATA", pack=False, align=None)}, name="PEER_PNRP_ENDPOINT_INFO", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hResolve", "ppEndpoint"]),
        # 
        'PeerPnrpEndResolve': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hResolve"]),
    }

lib.set_prototypes(prototypes)
