# pylint:disable=line-too-long
import logging

from ...sim_type import SimTypeFunction,     SimTypeShort, SimTypeInt, SimTypeLong, SimTypeLongLong, SimTypeDouble, SimTypeFloat,     SimTypePointer,     SimTypeChar,     SimStruct,     SimTypeFixedSizeArray,     SimTypeBottom,     SimUnion,     SimTypeBool
from ...calling_conventions import SimCCStdcall, SimCCMicrosoftAMD64
from .. import SIM_PROCEDURES as P
from . import SimLibrary


_l = logging.getLogger(name=__name__)


lib = SimLibrary()
lib.set_default_cc('X86', SimCCStdcall)
lib.set_default_cc('AMD64', SimCCMicrosoftAMD64)
lib.set_library_names("rtm.dll")
prototypes = \
    {
        # 
        'MgmRegisterMProtocol': SimTypeFunction([SimTypePointer(SimStruct({"dwCallbackFlags": SimTypeInt(signed=False, label="UInt32"), "pfnRpfCallback": SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["dwSourceAddr", "dwSourceMask", "dwGroupAddr", "dwGroupMask", "pdwInIfIndex", "pdwInIfNextHopAddr", "pdwUpStreamNbr", "dwHdrSize", "pbPacketHdr", "pbRoute"]), offset=0), "pfnCreationAlertCallback": SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwIfIndex": SimTypeInt(signed=False, label="UInt32"), "dwIfNextHopAddr": SimTypeInt(signed=False, label="UInt32"), "bIGMP": SimTypeInt(signed=True, label="Int32"), "bIsEnabled": SimTypeInt(signed=True, label="Int32")}, name="MGM_IF_ENTRY", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["dwSourceAddr", "dwSourceMask", "dwGroupAddr", "dwGroupMask", "dwInIfIndex", "dwInIfNextHopAddr", "dwIfCount", "pmieOutIfList"]), offset=0), "pfnPruneAlertCallback": SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["dwSourceAddr", "dwSourceMask", "dwGroupAddr", "dwGroupMask", "dwIfIndex", "dwIfNextHopAddr", "bMemberDelete", "pdwTimeout"]), offset=0), "pfnJoinAlertCallback": SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["dwSourceAddr", "dwSourceMask", "dwGroupAddr", "dwGroupMask", "bMemberUpdate"]), offset=0), "pfnWrongIfCallback": SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["dwSourceAddr", "dwGroupAddr", "dwIfIndex", "dwIfNextHopAddr", "dwHdrSize", "pbPacketHdr"]), offset=0), "pfnLocalJoinCallback": SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["dwSourceAddr", "dwSourceMask", "dwGroupAddr", "dwGroupMask", "dwIfIndex", "dwIfNextHopAddr"]), offset=0), "pfnLocalLeaveCallback": SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["dwSourceAddr", "dwSourceMask", "dwGroupAddr", "dwGroupMask", "dwIfIndex", "dwIfNextHopAddr"]), offset=0), "pfnDisableIgmpCallback": SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["dwIfIndex", "dwIfNextHopAddr"]), offset=0), "pfnEnableIgmpCallback": SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["dwIfIndex", "dwIfNextHopAddr"]), offset=0)}, name="ROUTING_PROTOCOL_CONFIG", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["prpiInfo", "dwProtocolId", "dwComponentId", "phProtocol"]),
        # 
        'MgmDeRegisterMProtocol': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hProtocol"]),
        # 
        'MgmTakeInterfaceOwnership': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hProtocol", "dwIfIndex", "dwIfNextHopAddr"]),
        # 
        'MgmReleaseInterfaceOwnership': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hProtocol", "dwIfIndex", "dwIfNextHopAddr"]),
        # 
        'MgmGetProtocolOnInterface': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["dwIfIndex", "dwIfNextHopAddr", "pdwIfProtocolId", "pdwIfComponentId"]),
        # 
        'MgmAddGroupMembershipEntry': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hProtocol", "dwSourceAddr", "dwSourceMask", "dwGroupAddr", "dwGroupMask", "dwIfIndex", "dwIfNextHopIPAddr", "dwFlags"]),
        # 
        'MgmDeleteGroupMembershipEntry': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hProtocol", "dwSourceAddr", "dwSourceMask", "dwGroupAddr", "dwGroupMask", "dwIfIndex", "dwIfNextHopIPAddr", "dwFlags"]),
        # 
        'MgmGetMfe': SimTypeFunction([SimTypePointer(SimStruct({"dwGroup": SimTypeInt(signed=False, label="UInt32"), "dwSource": SimTypeInt(signed=False, label="UInt32"), "dwSrcMask": SimTypeInt(signed=False, label="UInt32"), "dwUpStrmNgbr": SimTypeInt(signed=False, label="UInt32"), "dwInIfIndex": SimTypeInt(signed=False, label="UInt32"), "dwInIfProtocol": SimTypeInt(signed=False, label="UInt32"), "dwRouteProtocol": SimTypeInt(signed=False, label="UInt32"), "dwRouteNetwork": SimTypeInt(signed=False, label="UInt32"), "dwRouteMask": SimTypeInt(signed=False, label="UInt32"), "ulUpTime": SimTypeInt(signed=False, label="UInt32"), "ulExpiryTime": SimTypeInt(signed=False, label="UInt32"), "ulTimeOut": SimTypeInt(signed=False, label="UInt32"), "ulNumOutIf": SimTypeInt(signed=False, label="UInt32"), "fFlags": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeInt(signed=False, label="UInt32"), "rgmioOutInfo": SimTypePointer(SimStruct({"dwOutIfIndex": SimTypeInt(signed=False, label="UInt32"), "dwNextHopAddr": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeInt(signed=False, label="UInt32"), "dwReserved1": SimTypeInt(signed=False, label="UInt32")}, name="MIB_IPMCAST_OIF_XP", pack=False, align=None), offset=0)}, name="MIB_IPMCAST_MFE", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pimm", "pdwBufferSize", "pbBuffer"]),
        # 
        'MgmGetFirstMfe': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pdwBufferSize", "pbBuffer", "pdwNumEntries"]),
        # 
        'MgmGetNextMfe': SimTypeFunction([SimTypePointer(SimStruct({"dwGroup": SimTypeInt(signed=False, label="UInt32"), "dwSource": SimTypeInt(signed=False, label="UInt32"), "dwSrcMask": SimTypeInt(signed=False, label="UInt32"), "dwUpStrmNgbr": SimTypeInt(signed=False, label="UInt32"), "dwInIfIndex": SimTypeInt(signed=False, label="UInt32"), "dwInIfProtocol": SimTypeInt(signed=False, label="UInt32"), "dwRouteProtocol": SimTypeInt(signed=False, label="UInt32"), "dwRouteNetwork": SimTypeInt(signed=False, label="UInt32"), "dwRouteMask": SimTypeInt(signed=False, label="UInt32"), "ulUpTime": SimTypeInt(signed=False, label="UInt32"), "ulExpiryTime": SimTypeInt(signed=False, label="UInt32"), "ulTimeOut": SimTypeInt(signed=False, label="UInt32"), "ulNumOutIf": SimTypeInt(signed=False, label="UInt32"), "fFlags": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeInt(signed=False, label="UInt32"), "rgmioOutInfo": SimTypePointer(SimStruct({"dwOutIfIndex": SimTypeInt(signed=False, label="UInt32"), "dwNextHopAddr": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeInt(signed=False, label="UInt32"), "dwReserved1": SimTypeInt(signed=False, label="UInt32")}, name="MIB_IPMCAST_OIF_XP", pack=False, align=None), offset=0)}, name="MIB_IPMCAST_MFE", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pimmStart", "pdwBufferSize", "pbBuffer", "pdwNumEntries"]),
        # 
        'MgmGetMfeStats': SimTypeFunction([SimTypePointer(SimStruct({"dwGroup": SimTypeInt(signed=False, label="UInt32"), "dwSource": SimTypeInt(signed=False, label="UInt32"), "dwSrcMask": SimTypeInt(signed=False, label="UInt32"), "dwUpStrmNgbr": SimTypeInt(signed=False, label="UInt32"), "dwInIfIndex": SimTypeInt(signed=False, label="UInt32"), "dwInIfProtocol": SimTypeInt(signed=False, label="UInt32"), "dwRouteProtocol": SimTypeInt(signed=False, label="UInt32"), "dwRouteNetwork": SimTypeInt(signed=False, label="UInt32"), "dwRouteMask": SimTypeInt(signed=False, label="UInt32"), "ulUpTime": SimTypeInt(signed=False, label="UInt32"), "ulExpiryTime": SimTypeInt(signed=False, label="UInt32"), "ulTimeOut": SimTypeInt(signed=False, label="UInt32"), "ulNumOutIf": SimTypeInt(signed=False, label="UInt32"), "fFlags": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeInt(signed=False, label="UInt32"), "rgmioOutInfo": SimTypePointer(SimStruct({"dwOutIfIndex": SimTypeInt(signed=False, label="UInt32"), "dwNextHopAddr": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeInt(signed=False, label="UInt32"), "dwReserved1": SimTypeInt(signed=False, label="UInt32")}, name="MIB_IPMCAST_OIF_XP", pack=False, align=None), offset=0)}, name="MIB_IPMCAST_MFE", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["pimm", "pdwBufferSize", "pbBuffer", "dwFlags"]),
        # 
        'MgmGetFirstMfeStats': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["pdwBufferSize", "pbBuffer", "pdwNumEntries", "dwFlags"]),
        # 
        'MgmGetNextMfeStats': SimTypeFunction([SimTypePointer(SimStruct({"dwGroup": SimTypeInt(signed=False, label="UInt32"), "dwSource": SimTypeInt(signed=False, label="UInt32"), "dwSrcMask": SimTypeInt(signed=False, label="UInt32"), "dwUpStrmNgbr": SimTypeInt(signed=False, label="UInt32"), "dwInIfIndex": SimTypeInt(signed=False, label="UInt32"), "dwInIfProtocol": SimTypeInt(signed=False, label="UInt32"), "dwRouteProtocol": SimTypeInt(signed=False, label="UInt32"), "dwRouteNetwork": SimTypeInt(signed=False, label="UInt32"), "dwRouteMask": SimTypeInt(signed=False, label="UInt32"), "ulUpTime": SimTypeInt(signed=False, label="UInt32"), "ulExpiryTime": SimTypeInt(signed=False, label="UInt32"), "ulTimeOut": SimTypeInt(signed=False, label="UInt32"), "ulNumOutIf": SimTypeInt(signed=False, label="UInt32"), "fFlags": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeInt(signed=False, label="UInt32"), "rgmioOutInfo": SimTypePointer(SimStruct({"dwOutIfIndex": SimTypeInt(signed=False, label="UInt32"), "dwNextHopAddr": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeInt(signed=False, label="UInt32"), "dwReserved1": SimTypeInt(signed=False, label="UInt32")}, name="MIB_IPMCAST_OIF_XP", pack=False, align=None), offset=0)}, name="MIB_IPMCAST_MFE", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["pimmStart", "pdwBufferSize", "pbBuffer", "pdwNumEntries", "dwFlags"]),
        # 
        'MgmGroupEnumerationStart': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="MGM_ENUM_TYPES"), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hProtocol", "metEnumType", "phEnumHandle"]),
        # 
        'MgmGroupEnumerationGetNext': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hEnum", "pdwBufferSize", "pbBuffer", "pdwNumEntries"]),
        # 
        'MgmGroupEnumerationEnd': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hEnum"]),
        # 
        'RtmConvertNetAddressToIpv6AddressAndLength': SimTypeFunction([SimTypePointer(SimStruct({"AddressFamily": SimTypeShort(signed=False, label="UInt16"), "NumBits": SimTypeShort(signed=False, label="UInt16"), "AddrBits": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="RTM_NET_ADDRESS", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["pNetAddress", "pAddress", "pLength", "dwAddressSize"]),
        # 
        'RtmConvertIpv6AddressAndLengthToNetAddress': SimTypeFunction([SimTypePointer(SimStruct({"AddressFamily": SimTypeShort(signed=False, label="UInt16"), "NumBits": SimTypeShort(signed=False, label="UInt16"), "AddrBits": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="RTM_NET_ADDRESS", pack=False, align=None), offset=0), SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["pNetAddress", "Address", "dwLength", "dwAddressSize"]),
        # 
        'RtmRegisterEntity': SimTypeFunction([SimTypePointer(SimStruct({"RtmInstanceId": SimTypeShort(signed=False, label="UInt16"), "AddressFamily": SimTypeShort(signed=False, label="UInt16"), "EntityId": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"EntityProtocolId": SimTypeInt(signed=False, label="UInt32"), "EntityInstanceId": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "EntityId": SimTypeLongLong(signed=False, label="UInt64")}, name="<anon>", label="None")}, name="RTM_ENTITY_ID", pack=False, align=None)}, name="RTM_ENTITY_INFO", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"NumMethods": SimTypeInt(signed=False, label="UInt32"), "Methods": SimTypePointer(SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"MethodType": SimTypeInt(signed=False, label="UInt32"), "InputSize": SimTypeInt(signed=False, label="UInt32"), "InputData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="RTM_ENTITY_METHOD_INPUT", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"MethodType": SimTypeInt(signed=False, label="UInt32"), "MethodStatus": SimTypeInt(signed=False, label="UInt32"), "OutputSize": SimTypeInt(signed=False, label="UInt32"), "OutputData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="RTM_ENTITY_METHOD_OUTPUT", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["CallerHandle", "CalleeHandle", "Input", "Output"]), offset=0), offset=0)}, name="RTM_ENTITY_EXPORT_METHODS", pack=False, align=None), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="RTM_EVENT_TYPE"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RtmRegHandle", "EventType", "Context1", "Context2"]), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimStruct({"MaxNextHopsInRoute": SimTypeInt(signed=False, label="UInt32"), "MaxHandlesInEnum": SimTypeInt(signed=False, label="UInt32"), "ViewsSupported": SimTypeInt(signed=False, label="UInt32"), "NumberOfViews": SimTypeInt(signed=False, label="UInt32")}, name="RTM_REGN_PROFILE", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RtmEntityInfo", "ExportMethods", "EventCallback", "ReserveOpaquePointer", "RtmRegProfile", "RtmRegHandle"]),
        # 
        'RtmDeregisterEntity': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RtmRegHandle"]),
        # 
        'RtmGetRegisteredEntities': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypePointer(SimStruct({"RtmInstanceId": SimTypeShort(signed=False, label="UInt16"), "AddressFamily": SimTypeShort(signed=False, label="UInt16"), "EntityId": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"EntityProtocolId": SimTypeInt(signed=False, label="UInt32"), "EntityInstanceId": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "EntityId": SimTypeLongLong(signed=False, label="UInt64")}, name="<anon>", label="None")}, name="RTM_ENTITY_ID", pack=False, align=None)}, name="RTM_ENTITY_INFO", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RtmRegHandle", "NumEntities", "EntityHandles", "EntityInfos"]),
        # 
        'RtmReleaseEntities': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RtmRegHandle", "NumEntities", "EntityHandles"]),
        # 
        'RtmLockDestination': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["RtmRegHandle", "DestHandle", "Exclusive", "LockDest"]),
        # 
        'RtmGetOpaqueInformationPointer': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RtmRegHandle", "DestHandle", "OpaqueInfoPointer"]),
        # 
        'RtmGetEntityMethods': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"MethodType": SimTypeInt(signed=False, label="UInt32"), "InputSize": SimTypeInt(signed=False, label="UInt32"), "InputData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="RTM_ENTITY_METHOD_INPUT", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"MethodType": SimTypeInt(signed=False, label="UInt32"), "MethodStatus": SimTypeInt(signed=False, label="UInt32"), "OutputSize": SimTypeInt(signed=False, label="UInt32"), "OutputData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="RTM_ENTITY_METHOD_OUTPUT", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["CallerHandle", "CalleeHandle", "Input", "Output"]), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RtmRegHandle", "EntityHandle", "NumMethods", "ExptMethods"]),
        # 
        'RtmInvokeMethod': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"MethodType": SimTypeInt(signed=False, label="UInt32"), "InputSize": SimTypeInt(signed=False, label="UInt32"), "InputData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="RTM_ENTITY_METHOD_INPUT", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"MethodType": SimTypeInt(signed=False, label="UInt32"), "MethodStatus": SimTypeInt(signed=False, label="UInt32"), "OutputSize": SimTypeInt(signed=False, label="UInt32"), "OutputData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="RTM_ENTITY_METHOD_OUTPUT", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RtmRegHandle", "EntityHandle", "Input", "OutputSize", "Output"]),
        # 
        'RtmBlockMethods': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeChar(label="Byte"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["RtmRegHandle", "TargetHandle", "TargetType", "BlockingFlag"]),
        # 
        'RtmGetEntityInfo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"RtmInstanceId": SimTypeShort(signed=False, label="UInt16"), "AddressFamily": SimTypeShort(signed=False, label="UInt16"), "EntityId": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"EntityProtocolId": SimTypeInt(signed=False, label="UInt32"), "EntityInstanceId": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "EntityId": SimTypeLongLong(signed=False, label="UInt64")}, name="<anon>", label="None")}, name="RTM_ENTITY_ID", pack=False, align=None)}, name="RTM_ENTITY_INFO", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RtmRegHandle", "EntityHandle", "EntityInfo"]),
        # 
        'RtmGetDestInfo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"DestHandle": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "DestAddress": SimStruct({"AddressFamily": SimTypeShort(signed=False, label="UInt16"), "NumBits": SimTypeShort(signed=False, label="UInt16"), "AddrBits": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="RTM_NET_ADDRESS", pack=False, align=None), "LastChanged": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "BelongsToViews": SimTypeInt(signed=False, label="UInt32"), "NumberOfViews": SimTypeInt(signed=False, label="UInt32"), "ViewInfo": SimTypePointer(SimStruct({"ViewId": SimTypeInt(signed=True, label="Int32"), "NumRoutes": SimTypeInt(signed=False, label="UInt32"), "Route": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "DestFlags": SimTypeInt(signed=False, label="UInt32"), "HoldRoute": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), offset=0)}, name="RTM_DEST_INFO", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RtmRegHandle", "DestHandle", "ProtocolId", "TargetViews", "DestInfo"]),
        # 
        'RtmGetRouteInfo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"DestHandle": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "RouteOwner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Neighbour": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "State": SimTypeChar(label="Byte"), "Flags1": SimTypeChar(label="Byte"), "Flags": SimTypeShort(signed=False, label="UInt16"), "PrefInfo": SimStruct({"Metric": SimTypeInt(signed=False, label="UInt32"), "Preference": SimTypeInt(signed=False, label="UInt32")}, name="RTM_PREF_INFO", pack=False, align=None), "BelongsToViews": SimTypeInt(signed=False, label="UInt32"), "EntitySpecificInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "NextHopsList": SimStruct({"NumNextHops": SimTypeShort(signed=False, label="UInt16"), "NextHops": SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)}, name="RTM_NEXTHOP_LIST", pack=False, align=None)}, name="RTM_ROUTE_INFO", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"AddressFamily": SimTypeShort(signed=False, label="UInt16"), "NumBits": SimTypeShort(signed=False, label="UInt16"), "AddrBits": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="RTM_NET_ADDRESS", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RtmRegHandle", "RouteHandle", "RouteInfo", "DestAddress"]),
        # 
        'RtmGetNextHopInfo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"NextHopAddress": SimStruct({"AddressFamily": SimTypeShort(signed=False, label="UInt16"), "NumBits": SimTypeShort(signed=False, label="UInt16"), "AddrBits": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="RTM_NET_ADDRESS", pack=False, align=None), "NextHopOwner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "InterfaceIndex": SimTypeInt(signed=False, label="UInt32"), "State": SimTypeShort(signed=False, label="UInt16"), "Flags": SimTypeShort(signed=False, label="UInt16"), "EntitySpecificInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RemoteNextHop": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="RTM_NEXTHOP_INFO", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RtmRegHandle", "NextHopHandle", "NextHopInfo"]),
        # 
        'RtmReleaseEntityInfo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"RtmInstanceId": SimTypeShort(signed=False, label="UInt16"), "AddressFamily": SimTypeShort(signed=False, label="UInt16"), "EntityId": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"EntityProtocolId": SimTypeInt(signed=False, label="UInt32"), "EntityInstanceId": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "EntityId": SimTypeLongLong(signed=False, label="UInt64")}, name="<anon>", label="None")}, name="RTM_ENTITY_ID", pack=False, align=None)}, name="RTM_ENTITY_INFO", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RtmRegHandle", "EntityInfo"]),
        # 
        'RtmReleaseDestInfo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"DestHandle": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "DestAddress": SimStruct({"AddressFamily": SimTypeShort(signed=False, label="UInt16"), "NumBits": SimTypeShort(signed=False, label="UInt16"), "AddrBits": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="RTM_NET_ADDRESS", pack=False, align=None), "LastChanged": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "BelongsToViews": SimTypeInt(signed=False, label="UInt32"), "NumberOfViews": SimTypeInt(signed=False, label="UInt32"), "ViewInfo": SimTypePointer(SimStruct({"ViewId": SimTypeInt(signed=True, label="Int32"), "NumRoutes": SimTypeInt(signed=False, label="UInt32"), "Route": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "DestFlags": SimTypeInt(signed=False, label="UInt32"), "HoldRoute": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), offset=0)}, name="RTM_DEST_INFO", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RtmRegHandle", "DestInfo"]),
        # 
        'RtmReleaseRouteInfo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"DestHandle": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "RouteOwner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Neighbour": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "State": SimTypeChar(label="Byte"), "Flags1": SimTypeChar(label="Byte"), "Flags": SimTypeShort(signed=False, label="UInt16"), "PrefInfo": SimStruct({"Metric": SimTypeInt(signed=False, label="UInt32"), "Preference": SimTypeInt(signed=False, label="UInt32")}, name="RTM_PREF_INFO", pack=False, align=None), "BelongsToViews": SimTypeInt(signed=False, label="UInt32"), "EntitySpecificInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "NextHopsList": SimStruct({"NumNextHops": SimTypeShort(signed=False, label="UInt16"), "NextHops": SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)}, name="RTM_NEXTHOP_LIST", pack=False, align=None)}, name="RTM_ROUTE_INFO", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RtmRegHandle", "RouteInfo"]),
        # 
        'RtmReleaseNextHopInfo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"NextHopAddress": SimStruct({"AddressFamily": SimTypeShort(signed=False, label="UInt16"), "NumBits": SimTypeShort(signed=False, label="UInt16"), "AddrBits": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="RTM_NET_ADDRESS", pack=False, align=None), "NextHopOwner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "InterfaceIndex": SimTypeInt(signed=False, label="UInt32"), "State": SimTypeShort(signed=False, label="UInt16"), "Flags": SimTypeShort(signed=False, label="UInt16"), "EntitySpecificInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RemoteNextHop": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="RTM_NEXTHOP_INFO", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RtmRegHandle", "NextHopInfo"]),
        # 
        'RtmAddRouteToDest': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypePointer(SimStruct({"AddressFamily": SimTypeShort(signed=False, label="UInt16"), "NumBits": SimTypeShort(signed=False, label="UInt16"), "AddrBits": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="RTM_NET_ADDRESS", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"DestHandle": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "RouteOwner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Neighbour": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "State": SimTypeChar(label="Byte"), "Flags1": SimTypeChar(label="Byte"), "Flags": SimTypeShort(signed=False, label="UInt16"), "PrefInfo": SimStruct({"Metric": SimTypeInt(signed=False, label="UInt32"), "Preference": SimTypeInt(signed=False, label="UInt32")}, name="RTM_PREF_INFO", pack=False, align=None), "BelongsToViews": SimTypeInt(signed=False, label="UInt32"), "EntitySpecificInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "NextHopsList": SimStruct({"NumNextHops": SimTypeShort(signed=False, label="UInt16"), "NextHops": SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)}, name="RTM_NEXTHOP_LIST", pack=False, align=None)}, name="RTM_ROUTE_INFO", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RtmRegHandle", "RouteHandle", "DestAddress", "RouteInfo", "TimeToLive", "RouteListHandle", "NotifyType", "NotifyHandle", "ChangeFlags"]),
        # 
        'RtmDeleteRouteToDest': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RtmRegHandle", "RouteHandle", "ChangeFlags"]),
        # 
        'RtmHoldDestination': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["RtmRegHandle", "DestHandle", "TargetViews", "HoldTime"]),
        # 
        'RtmGetRoutePointer': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypePointer(SimStruct({"DestHandle": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "RouteOwner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Neighbour": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "State": SimTypeChar(label="Byte"), "Flags1": SimTypeChar(label="Byte"), "Flags": SimTypeShort(signed=False, label="UInt16"), "PrefInfo": SimStruct({"Metric": SimTypeInt(signed=False, label="UInt32"), "Preference": SimTypeInt(signed=False, label="UInt32")}, name="RTM_PREF_INFO", pack=False, align=None), "BelongsToViews": SimTypeInt(signed=False, label="UInt32"), "EntitySpecificInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "NextHopsList": SimStruct({"NumNextHops": SimTypeShort(signed=False, label="UInt16"), "NextHops": SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)}, name="RTM_NEXTHOP_LIST", pack=False, align=None)}, name="RTM_ROUTE_INFO", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RtmRegHandle", "RouteHandle", "RoutePointer"]),
        # 
        'RtmLockRoute': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypePointer(SimStruct({"DestHandle": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "RouteOwner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Neighbour": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "State": SimTypeChar(label="Byte"), "Flags1": SimTypeChar(label="Byte"), "Flags": SimTypeShort(signed=False, label="UInt16"), "PrefInfo": SimStruct({"Metric": SimTypeInt(signed=False, label="UInt32"), "Preference": SimTypeInt(signed=False, label="UInt32")}, name="RTM_PREF_INFO", pack=False, align=None), "BelongsToViews": SimTypeInt(signed=False, label="UInt32"), "EntitySpecificInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "NextHopsList": SimStruct({"NumNextHops": SimTypeShort(signed=False, label="UInt16"), "NextHops": SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)}, name="RTM_NEXTHOP_LIST", pack=False, align=None)}, name="RTM_ROUTE_INFO", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RtmRegHandle", "RouteHandle", "Exclusive", "LockRoute", "RoutePointer"]),
        # 
        'RtmUpdateAndUnlockRoute': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RtmRegHandle", "RouteHandle", "TimeToLive", "RouteListHandle", "NotifyType", "NotifyHandle", "ChangeFlags"]),
        # 
        'RtmGetExactMatchDestination': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"AddressFamily": SimTypeShort(signed=False, label="UInt16"), "NumBits": SimTypeShort(signed=False, label="UInt16"), "AddrBits": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="RTM_NET_ADDRESS", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"DestHandle": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "DestAddress": SimStruct({"AddressFamily": SimTypeShort(signed=False, label="UInt16"), "NumBits": SimTypeShort(signed=False, label="UInt16"), "AddrBits": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="RTM_NET_ADDRESS", pack=False, align=None), "LastChanged": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "BelongsToViews": SimTypeInt(signed=False, label="UInt32"), "NumberOfViews": SimTypeInt(signed=False, label="UInt32"), "ViewInfo": SimTypePointer(SimStruct({"ViewId": SimTypeInt(signed=True, label="Int32"), "NumRoutes": SimTypeInt(signed=False, label="UInt32"), "Route": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "DestFlags": SimTypeInt(signed=False, label="UInt32"), "HoldRoute": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), offset=0)}, name="RTM_DEST_INFO", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RtmRegHandle", "DestAddress", "ProtocolId", "TargetViews", "DestInfo"]),
        # 
        'RtmGetMostSpecificDestination': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"AddressFamily": SimTypeShort(signed=False, label="UInt16"), "NumBits": SimTypeShort(signed=False, label="UInt16"), "AddrBits": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="RTM_NET_ADDRESS", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"DestHandle": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "DestAddress": SimStruct({"AddressFamily": SimTypeShort(signed=False, label="UInt16"), "NumBits": SimTypeShort(signed=False, label="UInt16"), "AddrBits": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="RTM_NET_ADDRESS", pack=False, align=None), "LastChanged": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "BelongsToViews": SimTypeInt(signed=False, label="UInt32"), "NumberOfViews": SimTypeInt(signed=False, label="UInt32"), "ViewInfo": SimTypePointer(SimStruct({"ViewId": SimTypeInt(signed=True, label="Int32"), "NumRoutes": SimTypeInt(signed=False, label="UInt32"), "Route": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "DestFlags": SimTypeInt(signed=False, label="UInt32"), "HoldRoute": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), offset=0)}, name="RTM_DEST_INFO", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RtmRegHandle", "DestAddress", "ProtocolId", "TargetViews", "DestInfo"]),
        # 
        'RtmGetLessSpecificDestination': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"DestHandle": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "DestAddress": SimStruct({"AddressFamily": SimTypeShort(signed=False, label="UInt16"), "NumBits": SimTypeShort(signed=False, label="UInt16"), "AddrBits": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="RTM_NET_ADDRESS", pack=False, align=None), "LastChanged": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "BelongsToViews": SimTypeInt(signed=False, label="UInt32"), "NumberOfViews": SimTypeInt(signed=False, label="UInt32"), "ViewInfo": SimTypePointer(SimStruct({"ViewId": SimTypeInt(signed=True, label="Int32"), "NumRoutes": SimTypeInt(signed=False, label="UInt32"), "Route": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "DestFlags": SimTypeInt(signed=False, label="UInt32"), "HoldRoute": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), offset=0)}, name="RTM_DEST_INFO", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RtmRegHandle", "DestHandle", "ProtocolId", "TargetViews", "DestInfo"]),
        # 
        'RtmGetExactMatchRoute': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"AddressFamily": SimTypeShort(signed=False, label="UInt16"), "NumBits": SimTypeShort(signed=False, label="UInt16"), "AddrBits": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="RTM_NET_ADDRESS", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"DestHandle": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "RouteOwner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Neighbour": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "State": SimTypeChar(label="Byte"), "Flags1": SimTypeChar(label="Byte"), "Flags": SimTypeShort(signed=False, label="UInt16"), "PrefInfo": SimStruct({"Metric": SimTypeInt(signed=False, label="UInt32"), "Preference": SimTypeInt(signed=False, label="UInt32")}, name="RTM_PREF_INFO", pack=False, align=None), "BelongsToViews": SimTypeInt(signed=False, label="UInt32"), "EntitySpecificInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "NextHopsList": SimStruct({"NumNextHops": SimTypeShort(signed=False, label="UInt16"), "NextHops": SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)}, name="RTM_NEXTHOP_LIST", pack=False, align=None)}, name="RTM_ROUTE_INFO", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RtmRegHandle", "DestAddress", "MatchingFlags", "RouteInfo", "InterfaceIndex", "TargetViews", "RouteHandle"]),
        # 
        'RtmIsBestRoute': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RtmRegHandle", "RouteHandle", "BestInViews"]),
        # 
        'RtmAddNextHop': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"NextHopAddress": SimStruct({"AddressFamily": SimTypeShort(signed=False, label="UInt16"), "NumBits": SimTypeShort(signed=False, label="UInt16"), "AddrBits": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="RTM_NET_ADDRESS", pack=False, align=None), "NextHopOwner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "InterfaceIndex": SimTypeInt(signed=False, label="UInt32"), "State": SimTypeShort(signed=False, label="UInt16"), "Flags": SimTypeShort(signed=False, label="UInt16"), "EntitySpecificInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RemoteNextHop": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="RTM_NEXTHOP_INFO", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RtmRegHandle", "NextHopInfo", "NextHopHandle", "ChangeFlags"]),
        # 
        'RtmFindNextHop': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"NextHopAddress": SimStruct({"AddressFamily": SimTypeShort(signed=False, label="UInt16"), "NumBits": SimTypeShort(signed=False, label="UInt16"), "AddrBits": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="RTM_NET_ADDRESS", pack=False, align=None), "NextHopOwner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "InterfaceIndex": SimTypeInt(signed=False, label="UInt32"), "State": SimTypeShort(signed=False, label="UInt16"), "Flags": SimTypeShort(signed=False, label="UInt16"), "EntitySpecificInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RemoteNextHop": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="RTM_NEXTHOP_INFO", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypePointer(SimTypePointer(SimStruct({"NextHopAddress": SimStruct({"AddressFamily": SimTypeShort(signed=False, label="UInt16"), "NumBits": SimTypeShort(signed=False, label="UInt16"), "AddrBits": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="RTM_NET_ADDRESS", pack=False, align=None), "NextHopOwner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "InterfaceIndex": SimTypeInt(signed=False, label="UInt32"), "State": SimTypeShort(signed=False, label="UInt16"), "Flags": SimTypeShort(signed=False, label="UInt16"), "EntitySpecificInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RemoteNextHop": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="RTM_NEXTHOP_INFO", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RtmRegHandle", "NextHopInfo", "NextHopHandle", "NextHopPointer"]),
        # 
        'RtmDeleteNextHop': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"NextHopAddress": SimStruct({"AddressFamily": SimTypeShort(signed=False, label="UInt16"), "NumBits": SimTypeShort(signed=False, label="UInt16"), "AddrBits": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="RTM_NET_ADDRESS", pack=False, align=None), "NextHopOwner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "InterfaceIndex": SimTypeInt(signed=False, label="UInt32"), "State": SimTypeShort(signed=False, label="UInt16"), "Flags": SimTypeShort(signed=False, label="UInt16"), "EntitySpecificInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RemoteNextHop": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="RTM_NEXTHOP_INFO", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RtmRegHandle", "NextHopHandle", "NextHopInfo"]),
        # 
        'RtmGetNextHopPointer': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypePointer(SimStruct({"NextHopAddress": SimStruct({"AddressFamily": SimTypeShort(signed=False, label="UInt16"), "NumBits": SimTypeShort(signed=False, label="UInt16"), "AddrBits": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="RTM_NET_ADDRESS", pack=False, align=None), "NextHopOwner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "InterfaceIndex": SimTypeInt(signed=False, label="UInt32"), "State": SimTypeShort(signed=False, label="UInt16"), "Flags": SimTypeShort(signed=False, label="UInt16"), "EntitySpecificInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RemoteNextHop": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="RTM_NEXTHOP_INFO", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RtmRegHandle", "NextHopHandle", "NextHopPointer"]),
        # 
        'RtmLockNextHop': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypePointer(SimStruct({"NextHopAddress": SimStruct({"AddressFamily": SimTypeShort(signed=False, label="UInt16"), "NumBits": SimTypeShort(signed=False, label="UInt16"), "AddrBits": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="RTM_NET_ADDRESS", pack=False, align=None), "NextHopOwner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "InterfaceIndex": SimTypeInt(signed=False, label="UInt32"), "State": SimTypeShort(signed=False, label="UInt16"), "Flags": SimTypeShort(signed=False, label="UInt16"), "EntitySpecificInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RemoteNextHop": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="RTM_NEXTHOP_INFO", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RtmRegHandle", "NextHopHandle", "Exclusive", "LockNextHop", "NextHopPointer"]),
        # 
        'RtmCreateDestEnum': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"AddressFamily": SimTypeShort(signed=False, label="UInt16"), "NumBits": SimTypeShort(signed=False, label="UInt16"), "AddrBits": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="RTM_NET_ADDRESS", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RtmRegHandle", "TargetViews", "EnumFlags", "NetAddress", "ProtocolId", "RtmEnumHandle"]),
        # 
        'RtmGetEnumDests': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"DestHandle": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "DestAddress": SimStruct({"AddressFamily": SimTypeShort(signed=False, label="UInt16"), "NumBits": SimTypeShort(signed=False, label="UInt16"), "AddrBits": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="RTM_NET_ADDRESS", pack=False, align=None), "LastChanged": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "BelongsToViews": SimTypeInt(signed=False, label="UInt32"), "NumberOfViews": SimTypeInt(signed=False, label="UInt32"), "ViewInfo": SimTypePointer(SimStruct({"ViewId": SimTypeInt(signed=True, label="Int32"), "NumRoutes": SimTypeInt(signed=False, label="UInt32"), "Route": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "DestFlags": SimTypeInt(signed=False, label="UInt32"), "HoldRoute": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), offset=0)}, name="RTM_DEST_INFO", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RtmRegHandle", "EnumHandle", "NumDests", "DestInfos"]),
        # 
        'RtmReleaseDests': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"DestHandle": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "DestAddress": SimStruct({"AddressFamily": SimTypeShort(signed=False, label="UInt16"), "NumBits": SimTypeShort(signed=False, label="UInt16"), "AddrBits": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="RTM_NET_ADDRESS", pack=False, align=None), "LastChanged": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "BelongsToViews": SimTypeInt(signed=False, label="UInt32"), "NumberOfViews": SimTypeInt(signed=False, label="UInt32"), "ViewInfo": SimTypePointer(SimStruct({"ViewId": SimTypeInt(signed=True, label="Int32"), "NumRoutes": SimTypeInt(signed=False, label="UInt32"), "Route": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "DestFlags": SimTypeInt(signed=False, label="UInt32"), "HoldRoute": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), offset=0)}, name="RTM_DEST_INFO", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RtmRegHandle", "NumDests", "DestInfos"]),
        # 
        'RtmCreateRouteEnum': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"AddressFamily": SimTypeShort(signed=False, label="UInt16"), "NumBits": SimTypeShort(signed=False, label="UInt16"), "AddrBits": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="RTM_NET_ADDRESS", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"DestHandle": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "RouteOwner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Neighbour": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "State": SimTypeChar(label="Byte"), "Flags1": SimTypeChar(label="Byte"), "Flags": SimTypeShort(signed=False, label="UInt16"), "PrefInfo": SimStruct({"Metric": SimTypeInt(signed=False, label="UInt32"), "Preference": SimTypeInt(signed=False, label="UInt32")}, name="RTM_PREF_INFO", pack=False, align=None), "BelongsToViews": SimTypeInt(signed=False, label="UInt32"), "EntitySpecificInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "NextHopsList": SimStruct({"NumNextHops": SimTypeShort(signed=False, label="UInt16"), "NextHops": SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)}, name="RTM_NEXTHOP_LIST", pack=False, align=None)}, name="RTM_ROUTE_INFO", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RtmRegHandle", "DestHandle", "TargetViews", "EnumFlags", "StartDest", "MatchingFlags", "CriteriaRoute", "CriteriaInterface", "RtmEnumHandle"]),
        # 
        'RtmGetEnumRoutes': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RtmRegHandle", "EnumHandle", "NumRoutes", "RouteHandles"]),
        # 
        'RtmReleaseRoutes': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RtmRegHandle", "NumRoutes", "RouteHandles"]),
        # 
        'RtmCreateNextHopEnum': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"AddressFamily": SimTypeShort(signed=False, label="UInt16"), "NumBits": SimTypeShort(signed=False, label="UInt16"), "AddrBits": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="RTM_NET_ADDRESS", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RtmRegHandle", "EnumFlags", "NetAddress", "RtmEnumHandle"]),
        # 
        'RtmGetEnumNextHops': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RtmRegHandle", "EnumHandle", "NumNextHops", "NextHopHandles"]),
        # 
        'RtmReleaseNextHops': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RtmRegHandle", "NumNextHops", "NextHopHandles"]),
        # 
        'RtmDeleteEnumHandle': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RtmRegHandle", "EnumHandle"]),
        # 
        'RtmRegisterForChangeNotification': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RtmRegHandle", "TargetViews", "NotifyFlags", "NotifyContext", "NotifyHandle"]),
        # 
        'RtmGetChangedDests': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"DestHandle": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "DestAddress": SimStruct({"AddressFamily": SimTypeShort(signed=False, label="UInt16"), "NumBits": SimTypeShort(signed=False, label="UInt16"), "AddrBits": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="RTM_NET_ADDRESS", pack=False, align=None), "LastChanged": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "BelongsToViews": SimTypeInt(signed=False, label="UInt32"), "NumberOfViews": SimTypeInt(signed=False, label="UInt32"), "ViewInfo": SimTypePointer(SimStruct({"ViewId": SimTypeInt(signed=True, label="Int32"), "NumRoutes": SimTypeInt(signed=False, label="UInt32"), "Route": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "DestFlags": SimTypeInt(signed=False, label="UInt32"), "HoldRoute": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), offset=0)}, name="RTM_DEST_INFO", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RtmRegHandle", "NotifyHandle", "NumDests", "ChangedDests"]),
        # 
        'RtmReleaseChangedDests': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"DestHandle": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "DestAddress": SimStruct({"AddressFamily": SimTypeShort(signed=False, label="UInt16"), "NumBits": SimTypeShort(signed=False, label="UInt16"), "AddrBits": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="RTM_NET_ADDRESS", pack=False, align=None), "LastChanged": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "BelongsToViews": SimTypeInt(signed=False, label="UInt32"), "NumberOfViews": SimTypeInt(signed=False, label="UInt32"), "ViewInfo": SimTypePointer(SimStruct({"ViewId": SimTypeInt(signed=True, label="Int32"), "NumRoutes": SimTypeInt(signed=False, label="UInt32"), "Route": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "DestFlags": SimTypeInt(signed=False, label="UInt32"), "HoldRoute": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), offset=0)}, name="RTM_DEST_INFO", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RtmRegHandle", "NotifyHandle", "NumDests", "ChangedDests"]),
        # 
        'RtmIgnoreChangedDests': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RtmRegHandle", "NotifyHandle", "NumDests", "ChangedDests"]),
        # 
        'RtmGetChangeStatus': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RtmRegHandle", "NotifyHandle", "DestHandle", "ChangeStatus"]),
        # 
        'RtmMarkDestForChangeNotification': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["RtmRegHandle", "NotifyHandle", "DestHandle", "MarkDest"]),
        # 
        'RtmIsMarkedForChangeNotification': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RtmRegHandle", "NotifyHandle", "DestHandle", "DestMarked"]),
        # 
        'RtmDeregisterFromChangeNotification': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RtmRegHandle", "NotifyHandle"]),
        # 
        'RtmCreateRouteList': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RtmRegHandle", "RouteListHandle"]),
        # 
        'RtmInsertInRouteList': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RtmRegHandle", "RouteListHandle", "NumRoutes", "RouteHandles"]),
        # 
        'RtmCreateRouteListEnum': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RtmRegHandle", "RouteListHandle", "RtmEnumHandle"]),
        # 
        'RtmGetListEnumRoutes': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), label="LPArray", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RtmRegHandle", "EnumHandle", "NumRoutes", "RouteHandles"]),
        # 
        'RtmDeleteRouteList': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RtmRegHandle", "RouteListHandle"]),
        # 
        'RtmReferenceHandles': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RtmRegHandle", "NumHandles", "RtmHandles"]),
    }

lib.set_prototypes(prototypes)
