# pylint:disable=line-too-long
import logging

from ...sim_type import SimTypeFunction,     SimTypeShort, SimTypeInt, SimTypeLong, SimTypeLongLong, SimTypeDouble, SimTypeFloat,     SimTypePointer,     SimTypeChar,     SimStruct,     SimTypeFixedSizeArray,     SimTypeBottom,     SimUnion,     SimTypeBool
from ...calling_conventions import SimCCStdcall, SimCCMicrosoftAMD64
from .. import SIM_PROCEDURES as P
from . import SimLibrary


_l = logging.getLogger(name=__name__)


lib = SimLibrary()
lib.set_default_cc('X86', SimCCStdcall)
lib.set_default_cc('AMD64', SimCCMicrosoftAMD64)
lib.set_library_names("webservices.dll")
prototypes = \
    {
        # 
        'WsStartReaderCanonicalization': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_XML_READER", pack=False, align=None), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="WS_BYTES"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="WS_ASYNC_CONTEXT"), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["callbackState", "buffers", "count", "asyncContext", "error"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"id": SimTypeInt(signed=False, label="WS_XML_CANONICALIZATION_PROPERTY_ID"), "value": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "valueSize": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_CANONICALIZATION_PROPERTY", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["reader", "writeCallback", "writeCallbackState", "properties", "propertyCount", "error"]),
        # 
        'WsEndReaderCanonicalization': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_XML_READER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["reader", "error"]),
        # 
        'WsStartWriterCanonicalization': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_XML_WRITER", pack=False, align=None), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="WS_BYTES"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="WS_ASYNC_CONTEXT"), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["callbackState", "buffers", "count", "asyncContext", "error"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"id": SimTypeInt(signed=False, label="WS_XML_CANONICALIZATION_PROPERTY_ID"), "value": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "valueSize": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_CANONICALIZATION_PROPERTY", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["writer", "writeCallback", "writeCallbackState", "properties", "propertyCount", "error"]),
        # 
        'WsEndWriterCanonicalization': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_XML_WRITER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["writer", "error"]),
        # 
        'WsCreateXmlBuffer': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_HEAP", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"id": SimTypeInt(signed=False, label="WS_XML_BUFFER_PROPERTY_ID"), "value": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "valueSize": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_BUFFER_PROPERTY", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({}, name="WS_XML_BUFFER", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["heap", "properties", "propertyCount", "buffer", "error"]),
        # 
        'WsRemoveNode': SimTypeFunction([SimTypePointer(SimStruct({"buffer": SimTypePointer(SimStruct({}, name="WS_XML_BUFFER", pack=False, align=None), offset=0), "node": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="WS_XML_NODE_POSITION", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["nodePosition", "error"]),
        # 
        'WsCreateReader': SimTypeFunction([SimTypePointer(SimStruct({"id": SimTypeInt(signed=False, label="WS_XML_READER_PROPERTY_ID"), "value": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "valueSize": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_READER_PROPERTY", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({}, name="WS_XML_READER", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["properties", "propertyCount", "reader", "error"]),
        # 
        'WsSetInput': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_XML_READER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"encodingType": SimTypeInt(signed=False, label="WS_XML_READER_ENCODING_TYPE")}, name="WS_XML_READER_ENCODING", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"inputType": SimTypeInt(signed=False, label="WS_XML_READER_INPUT_TYPE")}, name="WS_XML_READER_INPUT", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"id": SimTypeInt(signed=False, label="WS_XML_READER_PROPERTY_ID"), "value": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "valueSize": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_READER_PROPERTY", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["reader", "encoding", "input", "properties", "propertyCount", "error"]),
        # 
        'WsSetInputToBuffer': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_XML_READER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_XML_BUFFER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"id": SimTypeInt(signed=False, label="WS_XML_READER_PROPERTY_ID"), "value": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "valueSize": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_READER_PROPERTY", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["reader", "buffer", "properties", "propertyCount", "error"]),
        # 
        'WsFreeReader': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_XML_READER", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["reader"]),
        # 
        'WsGetReaderProperty': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_XML_READER", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="WS_XML_READER_PROPERTY_ID"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["reader", "id", "value", "valueSize", "error"]),
        # 
        'WsGetReaderNode': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_XML_READER", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimStruct({"nodeType": SimTypeInt(signed=False, label="WS_XML_NODE_TYPE")}, name="WS_XML_NODE", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["xmlReader", "node", "error"]),
        # 
        'WsFillReader': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_XML_READER", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"callback": SimTypePointer(SimTypeFunction([SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="WS_CALLBACK_MODEL"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["errorCode", "callbackModel", "callbackState"]), offset=0), "callbackState": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="WS_ASYNC_CONTEXT", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["reader", "minSize", "asyncContext", "error"]),
        # 
        'WsReadStartElement': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_XML_READER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["reader", "error"]),
        # 
        'WsReadToStartElement': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_XML_READER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["reader", "localName", "ns", "found", "error"]),
        # 
        'WsReadStartAttribute': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_XML_READER", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["reader", "attributeIndex", "error"]),
        # 
        'WsReadEndAttribute': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_XML_READER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["reader", "error"]),
        # 
        'WsReadNode': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_XML_READER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["reader", "error"]),
        # 
        'WsSkipNode': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_XML_READER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["reader", "error"]),
        # 
        'WsReadEndElement': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_XML_READER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["reader", "error"]),
        # 
        'WsFindAttribute': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_XML_READER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["reader", "localName", "ns", "required", "attributeIndex", "error"]),
        # 
        'WsReadValue': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_XML_READER", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="WS_VALUE_TYPE"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["reader", "valueType", "value", "valueSize", "error"]),
        # 
        'WsReadChars': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_XML_READER", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["reader", "chars", "maxCharCount", "actualCharCount", "error"]),
        # 
        'WsReadCharsUtf8': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_XML_READER", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["reader", "bytes", "maxByteCount", "actualByteCount", "error"]),
        # 
        'WsReadBytes': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_XML_READER", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["reader", "bytes", "maxByteCount", "actualByteCount", "error"]),
        # 
        'WsReadArray': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_XML_READER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="WS_VALUE_TYPE"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["reader", "localName", "ns", "valueType", "array", "arraySize", "itemOffset", "itemCount", "actualItemCount", "error"]),
        # 
        'WsGetReaderPosition': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_XML_READER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"buffer": SimTypePointer(SimStruct({}, name="WS_XML_BUFFER", pack=False, align=None), offset=0), "node": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="WS_XML_NODE_POSITION", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["reader", "nodePosition", "error"]),
        # 
        'WsSetReaderPosition': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_XML_READER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"buffer": SimTypePointer(SimStruct({}, name="WS_XML_BUFFER", pack=False, align=None), offset=0), "node": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="WS_XML_NODE_POSITION", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["reader", "nodePosition", "error"]),
        # 
        'WsMoveReader': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_XML_READER", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="WS_MOVE_TO"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["reader", "moveTo", "found", "error"]),
        # 
        'WsCreateWriter': SimTypeFunction([SimTypePointer(SimStruct({"id": SimTypeInt(signed=False, label="WS_XML_WRITER_PROPERTY_ID"), "value": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "valueSize": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_WRITER_PROPERTY", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({}, name="WS_XML_WRITER", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["properties", "propertyCount", "writer", "error"]),
        # 
        'WsFreeWriter': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_XML_WRITER", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["writer"]),
        # 
        'WsSetOutput': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_XML_WRITER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"encodingType": SimTypeInt(signed=False, label="WS_XML_WRITER_ENCODING_TYPE")}, name="WS_XML_WRITER_ENCODING", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"outputType": SimTypeInt(signed=False, label="WS_XML_WRITER_OUTPUT_TYPE")}, name="WS_XML_WRITER_OUTPUT", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"id": SimTypeInt(signed=False, label="WS_XML_WRITER_PROPERTY_ID"), "value": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "valueSize": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_WRITER_PROPERTY", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["writer", "encoding", "output", "properties", "propertyCount", "error"]),
        # 
        'WsSetOutputToBuffer': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_XML_WRITER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_XML_BUFFER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"id": SimTypeInt(signed=False, label="WS_XML_WRITER_PROPERTY_ID"), "value": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "valueSize": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_WRITER_PROPERTY", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["writer", "buffer", "properties", "propertyCount", "error"]),
        # 
        'WsGetWriterProperty': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_XML_WRITER", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="WS_XML_WRITER_PROPERTY_ID"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["writer", "id", "value", "valueSize", "error"]),
        # 
        'WsFlushWriter': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_XML_WRITER", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"callback": SimTypePointer(SimTypeFunction([SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="WS_CALLBACK_MODEL"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["errorCode", "callbackModel", "callbackState"]), offset=0), "callbackState": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="WS_ASYNC_CONTEXT", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["writer", "minSize", "asyncContext", "error"]),
        # 
        'WsWriteStartElement': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_XML_WRITER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["writer", "prefix", "localName", "ns", "error"]),
        # 
        'WsWriteEndStartElement': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_XML_WRITER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["writer", "error"]),
        # 
        'WsWriteXmlnsAttribute': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_XML_WRITER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["writer", "prefix", "ns", "singleQuote", "error"]),
        # 
        'WsWriteStartAttribute': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_XML_WRITER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["writer", "prefix", "localName", "ns", "singleQuote", "error"]),
        # 
        'WsWriteEndAttribute': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_XML_WRITER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["writer", "error"]),
        # 
        'WsWriteValue': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_XML_WRITER", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="WS_VALUE_TYPE"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["writer", "valueType", "value", "valueSize", "error"]),
        # 
        'WsWriteXmlBuffer': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_XML_WRITER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_XML_BUFFER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["writer", "xmlBuffer", "error"]),
        # 
        'WsReadXmlBuffer': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_XML_READER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_HEAP", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimStruct({}, name="WS_XML_BUFFER", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["reader", "heap", "xmlBuffer", "error"]),
        # 
        'WsWriteXmlBufferToBytes': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_XML_WRITER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_XML_BUFFER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"encodingType": SimTypeInt(signed=False, label="WS_XML_WRITER_ENCODING_TYPE")}, name="WS_XML_WRITER_ENCODING", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"id": SimTypeInt(signed=False, label="WS_XML_WRITER_PROPERTY_ID"), "value": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "valueSize": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_WRITER_PROPERTY", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({}, name="WS_HEAP", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["writer", "xmlBuffer", "encoding", "properties", "propertyCount", "heap", "bytes", "byteCount", "error"]),
        # 
        'WsReadXmlBufferFromBytes': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_XML_READER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"encodingType": SimTypeInt(signed=False, label="WS_XML_READER_ENCODING_TYPE")}, name="WS_XML_READER_ENCODING", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"id": SimTypeInt(signed=False, label="WS_XML_READER_PROPERTY_ID"), "value": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "valueSize": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_READER_PROPERTY", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({}, name="WS_HEAP", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimStruct({}, name="WS_XML_BUFFER", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["reader", "encoding", "properties", "propertyCount", "bytes", "byteCount", "heap", "xmlBuffer", "error"]),
        # 
        'WsWriteArray': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_XML_WRITER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="WS_VALUE_TYPE"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["writer", "localName", "ns", "valueType", "array", "arraySize", "itemOffset", "itemCount", "error"]),
        # 
        'WsWriteQualifiedName': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_XML_WRITER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["writer", "prefix", "localName", "ns", "error"]),
        # 
        'WsWriteChars': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_XML_WRITER", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["writer", "chars", "charCount", "error"]),
        # 
        'WsWriteCharsUtf8': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_XML_WRITER", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["writer", "bytes", "byteCount", "error"]),
        # 
        'WsWriteBytes': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_XML_WRITER", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["writer", "bytes", "byteCount", "error"]),
        # 
        'WsPushBytes': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_XML_WRITER", pack=False, align=None), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="WS_BYTES"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="WS_ASYNC_CONTEXT"), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["callbackState", "buffers", "count", "asyncContext", "error"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="WS_ASYNC_CONTEXT"), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["callbackState", "writeCallback", "writeCallbackState", "asyncContext", "error"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["writer", "callback", "callbackState", "error"]),
        # 
        'WsPullBytes': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_XML_WRITER", pack=False, align=None), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeBottom(label="WS_ASYNC_CONTEXT"), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["callbackState", "bytes", "maxSize", "actualSize", "asyncContext", "error"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["writer", "callback", "callbackState", "error"]),
        # 
        'WsWriteEndElement': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_XML_WRITER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["writer", "error"]),
        # 
        'WsWriteText': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_XML_WRITER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"textType": SimTypeInt(signed=False, label="WS_XML_TEXT_TYPE")}, name="WS_XML_TEXT", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["writer", "text", "error"]),
        # 
        'WsWriteStartCData': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_XML_WRITER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["writer", "error"]),
        # 
        'WsWriteEndCData': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_XML_WRITER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["writer", "error"]),
        # 
        'WsWriteNode': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_XML_WRITER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"nodeType": SimTypeInt(signed=False, label="WS_XML_NODE_TYPE")}, name="WS_XML_NODE", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["writer", "node", "error"]),
        # 
        'WsGetPrefixFromNamespace': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_XML_WRITER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["writer", "ns", "required", "prefix", "error"]),
        # 
        'WsGetWriterPosition': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_XML_WRITER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"buffer": SimTypePointer(SimStruct({}, name="WS_XML_BUFFER", pack=False, align=None), offset=0), "node": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="WS_XML_NODE_POSITION", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["writer", "nodePosition", "error"]),
        # 
        'WsSetWriterPosition': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_XML_WRITER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"buffer": SimTypePointer(SimStruct({}, name="WS_XML_BUFFER", pack=False, align=None), offset=0), "node": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="WS_XML_NODE_POSITION", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["writer", "nodePosition", "error"]),
        # 
        'WsMoveWriter': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_XML_WRITER", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="WS_MOVE_TO"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["writer", "moveTo", "found", "error"]),
        # 
        'WsTrimXmlWhitespace': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["chars", "charCount", "trimmedChars", "trimmedCount", "error"]),
        # 
        'WsVerifyXmlNCName': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ncNameChars", "ncNameCharCount", "error"]),
        # 
        'WsXmlStringEquals': SimTypeFunction([SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["string1", "string2", "error"]),
        # 
        'WsGetNamespaceFromPrefix': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_XML_READER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["reader", "prefix", "required", "ns", "error"]),
        # 
        'WsReadQualifiedName': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_XML_READER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_HEAP", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["reader", "heap", "prefix", "localName", "ns", "error"]),
        # 
        'WsGetXmlAttribute': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_XML_READER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_HEAP", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["reader", "localName", "heap", "valueChars", "valueCharCount", "error"]),
        # 
        'WsCopyNode': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_XML_WRITER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_XML_READER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["writer", "reader", "error"]),
        # 
        'WsAsyncExecute': SimTypeFunction([SimTypePointer(SimStruct({"internal0": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "internal1": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "internal2": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "internal3": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "internal4": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="WS_ASYNC_STATE", pack=False, align=None), offset=0), SimTypePointer(SimTypeFunction([SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="WS_CALLBACK_MODEL"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="WS_ASYNC_OPERATION"), offset=0), SimTypePointer(SimTypeBottom(label="WS_ASYNC_CONTEXT"), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hr", "callbackModel", "callbackState", "next", "asyncContext", "error"]), offset=0), SimTypeInt(signed=False, label="WS_CALLBACK_MODEL"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"callback": SimTypePointer(SimTypeFunction([SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="WS_CALLBACK_MODEL"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["errorCode", "callbackModel", "callbackState"]), offset=0), "callbackState": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="WS_ASYNC_CONTEXT", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["asyncState", "operation", "callbackModel", "callbackState", "asyncContext", "error"]),
        # 
        'WsCreateChannel': SimTypeFunction([SimTypeInt(signed=False, label="WS_CHANNEL_TYPE"), SimTypeInt(signed=False, label="WS_CHANNEL_BINDING"), SimTypePointer(SimStruct({"id": SimTypeInt(signed=False, label="WS_CHANNEL_PROPERTY_ID"), "value": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "valueSize": SimTypeInt(signed=False, label="UInt32")}, name="WS_CHANNEL_PROPERTY", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"securityBindings": SimTypePointer(SimTypePointer(SimStruct({"bindingType": SimTypeInt(signed=False, label="WS_SECURITY_BINDING_TYPE"), "properties": SimTypePointer(SimStruct({"id": SimTypeInt(signed=False, label="WS_SECURITY_BINDING_PROPERTY_ID"), "value": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "valueSize": SimTypeInt(signed=False, label="UInt32")}, name="WS_SECURITY_BINDING_PROPERTY", pack=False, align=None), offset=0), "propertyCount": SimTypeInt(signed=False, label="UInt32")}, name="WS_SECURITY_BINDING", pack=False, align=None), offset=0), offset=0), "securityBindingCount": SimTypeInt(signed=False, label="UInt32"), "properties": SimTypePointer(SimStruct({"id": SimTypeInt(signed=False, label="WS_SECURITY_PROPERTY_ID"), "value": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "valueSize": SimTypeInt(signed=False, label="UInt32")}, name="WS_SECURITY_PROPERTY", pack=False, align=None), offset=0), "propertyCount": SimTypeInt(signed=False, label="UInt32")}, name="WS_SECURITY_DESCRIPTION", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimStruct({}, name="WS_CHANNEL", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["channelType", "channelBinding", "properties", "propertyCount", "securityDescription", "channel", "error"]),
        # 
        'WsOpenChannel': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_CHANNEL", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"url": SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "chars": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WS_STRING", pack=False, align=None), "headers": SimTypePointer(SimStruct({}, name="WS_XML_BUFFER", pack=False, align=None), offset=0), "extensions": SimTypePointer(SimStruct({}, name="WS_XML_BUFFER", pack=False, align=None), offset=0), "identity": SimTypePointer(SimStruct({"identityType": SimTypeInt(signed=False, label="WS_ENDPOINT_IDENTITY_TYPE")}, name="WS_ENDPOINT_IDENTITY", pack=False, align=None), offset=0)}, name="WS_ENDPOINT_ADDRESS", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"callback": SimTypePointer(SimTypeFunction([SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="WS_CALLBACK_MODEL"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["errorCode", "callbackModel", "callbackState"]), offset=0), "callbackState": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="WS_ASYNC_CONTEXT", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["channel", "endpointAddress", "asyncContext", "error"]),
        # 
        'WsSendMessage': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_CHANNEL", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"action": SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), "bodyElementDescription": SimTypePointer(SimStruct({"elementLocalName": SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), "elementNs": SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), "type": SimTypeInt(signed=False, label="WS_TYPE"), "typeDescription": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="WS_ELEMENT_DESCRIPTION", pack=False, align=None), offset=0)}, name="WS_MESSAGE_DESCRIPTION", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="WS_WRITE_OPTION"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"callback": SimTypePointer(SimTypeFunction([SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="WS_CALLBACK_MODEL"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["errorCode", "callbackModel", "callbackState"]), offset=0), "callbackState": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="WS_ASYNC_CONTEXT", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["channel", "message", "messageDescription", "writeOption", "bodyValue", "bodyValueSize", "asyncContext", "error"]),
        # 
        'WsReceiveMessage': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_CHANNEL", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimStruct({"action": SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), "bodyElementDescription": SimTypePointer(SimStruct({"elementLocalName": SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), "elementNs": SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), "type": SimTypeInt(signed=False, label="WS_TYPE"), "typeDescription": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="WS_ELEMENT_DESCRIPTION", pack=False, align=None), offset=0)}, name="WS_MESSAGE_DESCRIPTION", pack=False, align=None), offset=0), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="WS_RECEIVE_OPTION"), SimTypeInt(signed=False, label="WS_READ_OPTION"), SimTypePointer(SimStruct({}, name="WS_HEAP", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"callback": SimTypePointer(SimTypeFunction([SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="WS_CALLBACK_MODEL"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["errorCode", "callbackModel", "callbackState"]), offset=0), "callbackState": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="WS_ASYNC_CONTEXT", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["channel", "message", "messageDescriptions", "messageDescriptionCount", "receiveOption", "readBodyOption", "heap", "value", "valueSize", "index", "asyncContext", "error"]),
        # 
        'WsRequestReply': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_CHANNEL", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"action": SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), "bodyElementDescription": SimTypePointer(SimStruct({"elementLocalName": SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), "elementNs": SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), "type": SimTypeInt(signed=False, label="WS_TYPE"), "typeDescription": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="WS_ELEMENT_DESCRIPTION", pack=False, align=None), offset=0)}, name="WS_MESSAGE_DESCRIPTION", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="WS_WRITE_OPTION"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({}, name="WS_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"action": SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), "bodyElementDescription": SimTypePointer(SimStruct({"elementLocalName": SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), "elementNs": SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), "type": SimTypeInt(signed=False, label="WS_TYPE"), "typeDescription": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="WS_ELEMENT_DESCRIPTION", pack=False, align=None), offset=0)}, name="WS_MESSAGE_DESCRIPTION", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="WS_READ_OPTION"), SimTypePointer(SimStruct({}, name="WS_HEAP", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"callback": SimTypePointer(SimTypeFunction([SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="WS_CALLBACK_MODEL"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["errorCode", "callbackModel", "callbackState"]), offset=0), "callbackState": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="WS_ASYNC_CONTEXT", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["channel", "requestMessage", "requestMessageDescription", "writeOption", "requestBodyValue", "requestBodyValueSize", "replyMessage", "replyMessageDescription", "readOption", "heap", "value", "valueSize", "asyncContext", "error"]),
        # 
        'WsSendReplyMessage': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_CHANNEL", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"action": SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), "bodyElementDescription": SimTypePointer(SimStruct({"elementLocalName": SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), "elementNs": SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), "type": SimTypeInt(signed=False, label="WS_TYPE"), "typeDescription": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="WS_ELEMENT_DESCRIPTION", pack=False, align=None), offset=0)}, name="WS_MESSAGE_DESCRIPTION", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="WS_WRITE_OPTION"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({}, name="WS_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"callback": SimTypePointer(SimTypeFunction([SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="WS_CALLBACK_MODEL"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["errorCode", "callbackModel", "callbackState"]), offset=0), "callbackState": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="WS_ASYNC_CONTEXT", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["channel", "replyMessage", "replyMessageDescription", "writeOption", "replyBodyValue", "replyBodyValueSize", "requestMessage", "asyncContext", "error"]),
        # 
        'WsSendFaultMessageForError': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_CHANNEL", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="WS_FAULT_DISCLOSURE"), SimTypePointer(SimStruct({}, name="WS_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"callback": SimTypePointer(SimTypeFunction([SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="WS_CALLBACK_MODEL"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["errorCode", "callbackModel", "callbackState"]), offset=0), "callbackState": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="WS_ASYNC_CONTEXT", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["channel", "replyMessage", "faultError", "faultErrorCode", "faultDisclosure", "requestMessage", "asyncContext", "error"]),
        # 
        'WsGetChannelProperty': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_CHANNEL", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="WS_CHANNEL_PROPERTY_ID"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["channel", "id", "value", "valueSize", "error"]),
        # 
        'WsSetChannelProperty': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_CHANNEL", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="WS_CHANNEL_PROPERTY_ID"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["channel", "id", "value", "valueSize", "error"]),
        # 
        'WsWriteMessageStart': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_CHANNEL", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"callback": SimTypePointer(SimTypeFunction([SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="WS_CALLBACK_MODEL"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["errorCode", "callbackModel", "callbackState"]), offset=0), "callbackState": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="WS_ASYNC_CONTEXT", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["channel", "message", "asyncContext", "error"]),
        # 
        'WsWriteMessageEnd': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_CHANNEL", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"callback": SimTypePointer(SimTypeFunction([SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="WS_CALLBACK_MODEL"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["errorCode", "callbackModel", "callbackState"]), offset=0), "callbackState": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="WS_ASYNC_CONTEXT", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["channel", "message", "asyncContext", "error"]),
        # 
        'WsReadMessageStart': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_CHANNEL", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"callback": SimTypePointer(SimTypeFunction([SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="WS_CALLBACK_MODEL"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["errorCode", "callbackModel", "callbackState"]), offset=0), "callbackState": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="WS_ASYNC_CONTEXT", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["channel", "message", "asyncContext", "error"]),
        # 
        'WsReadMessageEnd': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_CHANNEL", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"callback": SimTypePointer(SimTypeFunction([SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="WS_CALLBACK_MODEL"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["errorCode", "callbackModel", "callbackState"]), offset=0), "callbackState": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="WS_ASYNC_CONTEXT", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["channel", "message", "asyncContext", "error"]),
        # 
        'WsCloseChannel': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_CHANNEL", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"callback": SimTypePointer(SimTypeFunction([SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="WS_CALLBACK_MODEL"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["errorCode", "callbackModel", "callbackState"]), offset=0), "callbackState": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="WS_ASYNC_CONTEXT", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["channel", "asyncContext", "error"]),
        # 
        'WsAbortChannel': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_CHANNEL", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["channel", "error"]),
        # 
        'WsFreeChannel': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_CHANNEL", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["channel"]),
        # 
        'WsResetChannel': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_CHANNEL", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["channel", "error"]),
        # 
        'WsAbandonMessage': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_CHANNEL", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["channel", "message", "error"]),
        # 
        'WsShutdownSessionChannel': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_CHANNEL", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"callback": SimTypePointer(SimTypeFunction([SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="WS_CALLBACK_MODEL"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["errorCode", "callbackModel", "callbackState"]), offset=0), "callbackState": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="WS_ASYNC_CONTEXT", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["channel", "asyncContext", "error"]),
        # 
        'WsGetOperationContextProperty': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_OPERATION_CONTEXT", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="WS_OPERATION_CONTEXT_PROPERTY_ID"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["context", "id", "value", "valueSize", "error"]),
        # 
        'WsGetDictionary': SimTypeFunction([SimTypeInt(signed=False, label="WS_ENCODING"), SimTypePointer(SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["encoding", "dictionary", "error"]),
        # 
        'WsReadEndpointAddressExtension': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_XML_READER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"url": SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "chars": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WS_STRING", pack=False, align=None), "headers": SimTypePointer(SimStruct({}, name="WS_XML_BUFFER", pack=False, align=None), offset=0), "extensions": SimTypePointer(SimStruct({}, name="WS_XML_BUFFER", pack=False, align=None), offset=0), "identity": SimTypePointer(SimStruct({"identityType": SimTypeInt(signed=False, label="WS_ENDPOINT_IDENTITY_TYPE")}, name="WS_ENDPOINT_IDENTITY", pack=False, align=None), offset=0)}, name="WS_ENDPOINT_ADDRESS", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="WS_ENDPOINT_ADDRESS_EXTENSION_TYPE"), SimTypeInt(signed=False, label="WS_READ_OPTION"), SimTypePointer(SimStruct({}, name="WS_HEAP", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["reader", "endpointAddress", "extensionType", "readOption", "heap", "value", "valueSize", "error"]),
        # 
        'WsCreateError': SimTypeFunction([SimTypePointer(SimStruct({"id": SimTypeInt(signed=False, label="WS_ERROR_PROPERTY_ID"), "value": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "valueSize": SimTypeInt(signed=False, label="UInt32")}, name="WS_ERROR_PROPERTY", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["properties", "propertyCount", "error"]),
        # 
        'WsAddErrorString': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "chars": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WS_STRING", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["error", "string"]),
        # 
        'WsGetErrorString': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "chars": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WS_STRING", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["error", "index", "string"]),
        # 
        'WsCopyError': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["source", "destination"]),
        # 
        'WsGetErrorProperty': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="WS_ERROR_PROPERTY_ID"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["error", "id", "buffer", "bufferSize"]),
        # 
        'WsSetErrorProperty': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="WS_ERROR_PROPERTY_ID"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["error", "id", "value", "valueSize"]),
        # 
        'WsResetError': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["error"]),
        # 
        'WsFreeError': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["error"]),
        # 
        'WsGetFaultErrorProperty': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="WS_FAULT_ERROR_PROPERTY_ID"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["error", "id", "buffer", "bufferSize"]),
        # 
        'WsSetFaultErrorProperty': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="WS_FAULT_ERROR_PROPERTY_ID"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["error", "id", "value", "valueSize"]),
        # 
        'WsCreateFaultFromError': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="WS_FAULT_DISCLOSURE"), SimTypePointer(SimStruct({}, name="WS_HEAP", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"code": SimTypePointer(SimStruct({"value": SimStruct({"localName": SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), "ns": SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None)}, name="WS_XML_QNAME", pack=False, align=None), "subCode": SimTypePointer(SimTypeBottom(label="WS_FAULT_CODE"), offset=0)}, name="WS_FAULT_CODE", pack=False, align=None), offset=0), "reasons": SimTypePointer(SimStruct({"text": SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "chars": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WS_STRING", pack=False, align=None), "lang": SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "chars": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WS_STRING", pack=False, align=None)}, name="WS_FAULT_REASON", pack=False, align=None), offset=0), "reasonCount": SimTypeInt(signed=False, label="UInt32"), "actor": SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "chars": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WS_STRING", pack=False, align=None), "node": SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "chars": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WS_STRING", pack=False, align=None), "detail": SimTypePointer(SimStruct({}, name="WS_XML_BUFFER", pack=False, align=None), offset=0)}, name="WS_FAULT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["error", "faultErrorCode", "faultDisclosure", "heap", "fault"]),
        # 
        'WsSetFaultErrorDetail': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"action": SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), "detailElementDescription": SimTypePointer(SimStruct({"elementLocalName": SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), "elementNs": SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), "type": SimTypeInt(signed=False, label="WS_TYPE"), "typeDescription": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="WS_ELEMENT_DESCRIPTION", pack=False, align=None), offset=0)}, name="WS_FAULT_DETAIL_DESCRIPTION", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="WS_WRITE_OPTION"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["error", "faultDetailDescription", "writeOption", "value", "valueSize"]),
        # 
        'WsGetFaultErrorDetail': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"action": SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), "detailElementDescription": SimTypePointer(SimStruct({"elementLocalName": SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), "elementNs": SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), "type": SimTypeInt(signed=False, label="WS_TYPE"), "typeDescription": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="WS_ELEMENT_DESCRIPTION", pack=False, align=None), offset=0)}, name="WS_FAULT_DETAIL_DESCRIPTION", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="WS_READ_OPTION"), SimTypePointer(SimStruct({}, name="WS_HEAP", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["error", "faultDetailDescription", "readOption", "heap", "value", "valueSize"]),
        # 
        'WsCreateHeap': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimStruct({"id": SimTypeInt(signed=False, label="WS_HEAP_PROPERTY_ID"), "value": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "valueSize": SimTypeInt(signed=False, label="UInt32")}, name="WS_HEAP_PROPERTY", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({}, name="WS_HEAP", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["maxSize", "trimSize", "properties", "propertyCount", "heap", "error"]),
        # 
        'WsAlloc': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_HEAP", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["heap", "size", "ptr", "error"]),
        # 
        'WsGetHeapProperty': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_HEAP", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="WS_HEAP_PROPERTY_ID"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["heap", "id", "value", "valueSize", "error"]),
        # 
        'WsResetHeap': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_HEAP", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["heap", "error"]),
        # 
        'WsFreeHeap': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_HEAP", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["heap"]),
        # 
        'WsCreateListener': SimTypeFunction([SimTypeInt(signed=False, label="WS_CHANNEL_TYPE"), SimTypeInt(signed=False, label="WS_CHANNEL_BINDING"), SimTypePointer(SimStruct({"id": SimTypeInt(signed=False, label="WS_LISTENER_PROPERTY_ID"), "value": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "valueSize": SimTypeInt(signed=False, label="UInt32")}, name="WS_LISTENER_PROPERTY", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"securityBindings": SimTypePointer(SimTypePointer(SimStruct({"bindingType": SimTypeInt(signed=False, label="WS_SECURITY_BINDING_TYPE"), "properties": SimTypePointer(SimStruct({"id": SimTypeInt(signed=False, label="WS_SECURITY_BINDING_PROPERTY_ID"), "value": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "valueSize": SimTypeInt(signed=False, label="UInt32")}, name="WS_SECURITY_BINDING_PROPERTY", pack=False, align=None), offset=0), "propertyCount": SimTypeInt(signed=False, label="UInt32")}, name="WS_SECURITY_BINDING", pack=False, align=None), offset=0), offset=0), "securityBindingCount": SimTypeInt(signed=False, label="UInt32"), "properties": SimTypePointer(SimStruct({"id": SimTypeInt(signed=False, label="WS_SECURITY_PROPERTY_ID"), "value": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "valueSize": SimTypeInt(signed=False, label="UInt32")}, name="WS_SECURITY_PROPERTY", pack=False, align=None), offset=0), "propertyCount": SimTypeInt(signed=False, label="UInt32")}, name="WS_SECURITY_DESCRIPTION", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimStruct({}, name="WS_LISTENER", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["channelType", "channelBinding", "properties", "propertyCount", "securityDescription", "listener", "error"]),
        # 
        'WsOpenListener': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_LISTENER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "chars": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WS_STRING", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"callback": SimTypePointer(SimTypeFunction([SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="WS_CALLBACK_MODEL"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["errorCode", "callbackModel", "callbackState"]), offset=0), "callbackState": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="WS_ASYNC_CONTEXT", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["listener", "url", "asyncContext", "error"]),
        # 
        'WsAcceptChannel': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_LISTENER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_CHANNEL", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"callback": SimTypePointer(SimTypeFunction([SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="WS_CALLBACK_MODEL"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["errorCode", "callbackModel", "callbackState"]), offset=0), "callbackState": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="WS_ASYNC_CONTEXT", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["listener", "channel", "asyncContext", "error"]),
        # 
        'WsCloseListener': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_LISTENER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"callback": SimTypePointer(SimTypeFunction([SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="WS_CALLBACK_MODEL"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["errorCode", "callbackModel", "callbackState"]), offset=0), "callbackState": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="WS_ASYNC_CONTEXT", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["listener", "asyncContext", "error"]),
        # 
        'WsAbortListener': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_LISTENER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["listener", "error"]),
        # 
        'WsResetListener': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_LISTENER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["listener", "error"]),
        # 
        'WsFreeListener': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_LISTENER", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["listener"]),
        # 
        'WsGetListenerProperty': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_LISTENER", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="WS_LISTENER_PROPERTY_ID"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["listener", "id", "value", "valueSize", "error"]),
        # 
        'WsSetListenerProperty': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_LISTENER", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="WS_LISTENER_PROPERTY_ID"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["listener", "id", "value", "valueSize", "error"]),
        # 
        'WsCreateChannelForListener': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_LISTENER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"id": SimTypeInt(signed=False, label="WS_CHANNEL_PROPERTY_ID"), "value": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "valueSize": SimTypeInt(signed=False, label="UInt32")}, name="WS_CHANNEL_PROPERTY", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({}, name="WS_CHANNEL", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["listener", "properties", "propertyCount", "channel", "error"]),
        # 
        'WsCreateMessage': SimTypeFunction([SimTypeInt(signed=False, label="WS_ENVELOPE_VERSION"), SimTypeInt(signed=False, label="WS_ADDRESSING_VERSION"), SimTypePointer(SimStruct({"id": SimTypeInt(signed=False, label="WS_MESSAGE_PROPERTY_ID"), "value": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "valueSize": SimTypeInt(signed=False, label="UInt32")}, name="WS_MESSAGE_PROPERTY", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({}, name="WS_MESSAGE", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["envelopeVersion", "addressingVersion", "properties", "propertyCount", "message", "error"]),
        # 
        'WsCreateMessageForChannel': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_CHANNEL", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"id": SimTypeInt(signed=False, label="WS_MESSAGE_PROPERTY_ID"), "value": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "valueSize": SimTypeInt(signed=False, label="UInt32")}, name="WS_MESSAGE_PROPERTY", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({}, name="WS_MESSAGE", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["channel", "properties", "propertyCount", "message", "error"]),
        # 
        'WsInitializeMessage': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_MESSAGE", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="WS_MESSAGE_INITIALIZATION"), SimTypePointer(SimStruct({}, name="WS_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["message", "initialization", "sourceMessage", "error"]),
        # 
        'WsResetMessage': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["message", "error"]),
        # 
        'WsFreeMessage': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_MESSAGE", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["message"]),
        # 
        'WsGetHeaderAttributes': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_XML_READER", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["message", "reader", "headerAttributes", "error"]),
        # 
        'WsGetHeader': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_MESSAGE", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="WS_HEADER_TYPE"), SimTypeInt(signed=False, label="WS_TYPE"), SimTypeInt(signed=False, label="WS_READ_OPTION"), SimTypePointer(SimStruct({}, name="WS_HEAP", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["message", "headerType", "valueType", "readOption", "heap", "value", "valueSize", "error"]),
        # 
        'WsGetCustomHeader': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"elementLocalName": SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), "elementNs": SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), "type": SimTypeInt(signed=False, label="WS_TYPE"), "typeDescription": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="WS_ELEMENT_DESCRIPTION", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="WS_REPEATING_HEADER_OPTION"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="WS_READ_OPTION"), SimTypePointer(SimStruct({}, name="WS_HEAP", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["message", "customHeaderDescription", "repeatingOption", "headerIndex", "readOption", "heap", "value", "valueSize", "headerAttributes", "error"]),
        # 
        'WsRemoveHeader': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_MESSAGE", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="WS_HEADER_TYPE"), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["message", "headerType", "error"]),
        # 
        'WsSetHeader': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_MESSAGE", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="WS_HEADER_TYPE"), SimTypeInt(signed=False, label="WS_TYPE"), SimTypeInt(signed=False, label="WS_WRITE_OPTION"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["message", "headerType", "valueType", "writeOption", "value", "valueSize", "error"]),
        # 
        'WsRemoveCustomHeader': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["message", "headerName", "headerNs", "error"]),
        # 
        'WsAddCustomHeader': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"elementLocalName": SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), "elementNs": SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), "type": SimTypeInt(signed=False, label="WS_TYPE"), "typeDescription": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="WS_ELEMENT_DESCRIPTION", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="WS_WRITE_OPTION"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["message", "headerDescription", "writeOption", "value", "valueSize", "headerAttributes", "error"]),
        # 
        'WsAddMappedHeader': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="WS_TYPE"), SimTypeInt(signed=False, label="WS_WRITE_OPTION"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["message", "headerName", "valueType", "writeOption", "value", "valueSize", "error"]),
        # 
        'WsRemoveMappedHeader': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["message", "headerName", "error"]),
        # 
        'WsGetMappedHeader': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="WS_REPEATING_HEADER_OPTION"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="WS_TYPE"), SimTypeInt(signed=False, label="WS_READ_OPTION"), SimTypePointer(SimStruct({}, name="WS_HEAP", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["message", "headerName", "repeatingOption", "headerIndex", "valueType", "readOption", "heap", "value", "valueSize", "error"]),
        # 
        'WsWriteBody': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"elementLocalName": SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), "elementNs": SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), "type": SimTypeInt(signed=False, label="WS_TYPE"), "typeDescription": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="WS_ELEMENT_DESCRIPTION", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="WS_WRITE_OPTION"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["message", "bodyDescription", "writeOption", "value", "valueSize", "error"]),
        # 
        'WsReadBody': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"elementLocalName": SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), "elementNs": SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), "type": SimTypeInt(signed=False, label="WS_TYPE"), "typeDescription": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="WS_ELEMENT_DESCRIPTION", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="WS_READ_OPTION"), SimTypePointer(SimStruct({}, name="WS_HEAP", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["message", "bodyDescription", "readOption", "heap", "value", "valueSize", "error"]),
        # 
        'WsWriteEnvelopeStart': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_XML_WRITER", pack=False, align=None), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["doneCallbackState"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["message", "writer", "doneCallback", "doneCallbackState", "error"]),
        # 
        'WsWriteEnvelopeEnd': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["message", "error"]),
        # 
        'WsReadEnvelopeStart': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_XML_READER", pack=False, align=None), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["doneCallbackState"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["message", "reader", "doneCallback", "doneCallbackState", "error"]),
        # 
        'WsReadEnvelopeEnd': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["message", "error"]),
        # 
        'WsGetMessageProperty': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_MESSAGE", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="WS_MESSAGE_PROPERTY_ID"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["message", "id", "value", "valueSize", "error"]),
        # 
        'WsSetMessageProperty': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_MESSAGE", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="WS_MESSAGE_PROPERTY_ID"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["message", "id", "value", "valueSize", "error"]),
        # 
        'WsAddressMessage': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"url": SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "chars": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WS_STRING", pack=False, align=None), "headers": SimTypePointer(SimStruct({}, name="WS_XML_BUFFER", pack=False, align=None), offset=0), "extensions": SimTypePointer(SimStruct({}, name="WS_XML_BUFFER", pack=False, align=None), offset=0), "identity": SimTypePointer(SimStruct({"identityType": SimTypeInt(signed=False, label="WS_ENDPOINT_IDENTITY_TYPE")}, name="WS_ENDPOINT_IDENTITY", pack=False, align=None), offset=0)}, name="WS_ENDPOINT_ADDRESS", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["message", "address", "error"]),
        # 
        'WsCheckMustUnderstandHeaders': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["message", "error"]),
        # 
        'WsMarkHeaderAsUnderstood': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"buffer": SimTypePointer(SimStruct({}, name="WS_XML_BUFFER", pack=False, align=None), offset=0), "node": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="WS_XML_NODE_POSITION", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["message", "headerPosition", "error"]),
        # 
        'WsFillBody': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_MESSAGE", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"callback": SimTypePointer(SimTypeFunction([SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="WS_CALLBACK_MODEL"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["errorCode", "callbackModel", "callbackState"]), offset=0), "callbackState": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="WS_ASYNC_CONTEXT", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["message", "minSize", "asyncContext", "error"]),
        # 
        'WsFlushBody': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_MESSAGE", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"callback": SimTypePointer(SimTypeFunction([SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="WS_CALLBACK_MODEL"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["errorCode", "callbackModel", "callbackState"]), offset=0), "callbackState": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="WS_ASYNC_CONTEXT", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["message", "minSize", "asyncContext", "error"]),
        # 
        'WsRequestSecurityToken': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_CHANNEL", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"id": SimTypeInt(signed=False, label="WS_REQUEST_SECURITY_TOKEN_PROPERTY_ID"), "value": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "valueSize": SimTypeInt(signed=False, label="UInt32")}, name="WS_REQUEST_SECURITY_TOKEN_PROPERTY", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({}, name="WS_SECURITY_TOKEN", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimStruct({"callback": SimTypePointer(SimTypeFunction([SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="WS_CALLBACK_MODEL"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["errorCode", "callbackModel", "callbackState"]), offset=0), "callbackState": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="WS_ASYNC_CONTEXT", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["channel", "properties", "propertyCount", "token", "asyncContext", "error"]),
        # 
        'WsGetSecurityTokenProperty': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_SECURITY_TOKEN", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="WS_SECURITY_TOKEN_PROPERTY_ID"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({}, name="WS_HEAP", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["securityToken", "id", "value", "valueSize", "heap", "error"]),
        # 
        'WsCreateXmlSecurityToken': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_XML_BUFFER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"keyHandleType": SimTypeInt(signed=False, label="WS_SECURITY_KEY_HANDLE_TYPE")}, name="WS_SECURITY_KEY_HANDLE", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"id": SimTypeInt(signed=False, label="WS_XML_SECURITY_TOKEN_PROPERTY_ID"), "value": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "valueSize": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_SECURITY_TOKEN_PROPERTY", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({}, name="WS_SECURITY_TOKEN", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["tokenXml", "tokenKey", "properties", "propertyCount", "token", "error"]),
        # 
        'WsFreeSecurityToken': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_SECURITY_TOKEN", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["token"]),
        # 
        'WsRevokeSecurityContext': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_SECURITY_CONTEXT", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["securityContext", "error"]),
        # 
        'WsGetSecurityContextProperty': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_SECURITY_CONTEXT", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="WS_SECURITY_CONTEXT_PROPERTY_ID"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["securityContext", "id", "value", "valueSize", "error"]),
        # 
        'WsReadElement': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_XML_READER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"elementLocalName": SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), "elementNs": SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), "type": SimTypeInt(signed=False, label="WS_TYPE"), "typeDescription": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="WS_ELEMENT_DESCRIPTION", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="WS_READ_OPTION"), SimTypePointer(SimStruct({}, name="WS_HEAP", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["reader", "elementDescription", "readOption", "heap", "value", "valueSize", "error"]),
        # 
        'WsReadAttribute': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_XML_READER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"attributeLocalName": SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), "attributeNs": SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), "type": SimTypeInt(signed=False, label="WS_TYPE"), "typeDescription": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="WS_ATTRIBUTE_DESCRIPTION", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="WS_READ_OPTION"), SimTypePointer(SimStruct({}, name="WS_HEAP", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["reader", "attributeDescription", "readOption", "heap", "value", "valueSize", "error"]),
        # 
        'WsReadType': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_XML_READER", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="WS_TYPE_MAPPING"), SimTypeInt(signed=False, label="WS_TYPE"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="WS_READ_OPTION"), SimTypePointer(SimStruct({}, name="WS_HEAP", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["reader", "typeMapping", "type", "typeDescription", "readOption", "heap", "value", "valueSize", "error"]),
        # 
        'WsWriteElement': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_XML_WRITER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"elementLocalName": SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), "elementNs": SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), "type": SimTypeInt(signed=False, label="WS_TYPE"), "typeDescription": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="WS_ELEMENT_DESCRIPTION", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="WS_WRITE_OPTION"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["writer", "elementDescription", "writeOption", "value", "valueSize", "error"]),
        # 
        'WsWriteAttribute': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_XML_WRITER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"attributeLocalName": SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), "attributeNs": SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), "type": SimTypeInt(signed=False, label="WS_TYPE"), "typeDescription": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="WS_ATTRIBUTE_DESCRIPTION", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="WS_WRITE_OPTION"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["writer", "attributeDescription", "writeOption", "value", "valueSize", "error"]),
        # 
        'WsWriteType': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_XML_WRITER", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="WS_TYPE_MAPPING"), SimTypeInt(signed=False, label="WS_TYPE"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="WS_WRITE_OPTION"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["writer", "typeMapping", "type", "typeDescription", "writeOption", "value", "valueSize", "error"]),
        # 
        'WsRegisterOperationForCancel': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_OPERATION_CONTEXT", pack=False, align=None), offset=0), SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="WS_SERVICE_CANCEL_REASON"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["reason", "state"]), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["state"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["context", "cancelCallback", "freestateCallback", "userState", "error"]),
        # 
        'WsGetServiceHostProperty': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_SERVICE_HOST", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="WS_SERVICE_PROPERTY_ID"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["serviceHost", "id", "value", "valueSize", "error"]),
        # 
        'WsCreateServiceHost': SimTypeFunction([SimTypePointer(SimTypePointer(SimStruct({"address": SimStruct({"url": SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "chars": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WS_STRING", pack=False, align=None), "headers": SimTypePointer(SimStruct({}, name="WS_XML_BUFFER", pack=False, align=None), offset=0), "extensions": SimTypePointer(SimStruct({}, name="WS_XML_BUFFER", pack=False, align=None), offset=0), "identity": SimTypePointer(SimStruct({"identityType": SimTypeInt(signed=False, label="WS_ENDPOINT_IDENTITY_TYPE")}, name="WS_ENDPOINT_IDENTITY", pack=False, align=None), offset=0)}, name="WS_ENDPOINT_ADDRESS", pack=False, align=None), "channelBinding": SimTypeInt(signed=False, label="WS_CHANNEL_BINDING"), "channelType": SimTypeInt(signed=False, label="WS_CHANNEL_TYPE"), "securityDescription": SimTypePointer(SimStruct({"securityBindings": SimTypePointer(SimTypePointer(SimStruct({"bindingType": SimTypeInt(signed=False, label="WS_SECURITY_BINDING_TYPE"), "properties": SimTypePointer(SimStruct({"id": SimTypeInt(signed=False, label="WS_SECURITY_BINDING_PROPERTY_ID"), "value": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "valueSize": SimTypeInt(signed=False, label="UInt32")}, name="WS_SECURITY_BINDING_PROPERTY", pack=False, align=None), offset=0), "propertyCount": SimTypeInt(signed=False, label="UInt32")}, name="WS_SECURITY_BINDING", pack=False, align=None), offset=0), offset=0), "securityBindingCount": SimTypeInt(signed=False, label="UInt32"), "properties": SimTypePointer(SimStruct({"id": SimTypeInt(signed=False, label="WS_SECURITY_PROPERTY_ID"), "value": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "valueSize": SimTypeInt(signed=False, label="UInt32")}, name="WS_SECURITY_PROPERTY", pack=False, align=None), offset=0), "propertyCount": SimTypeInt(signed=False, label="UInt32")}, name="WS_SECURITY_DESCRIPTION", pack=False, align=None), offset=0), "contract": SimTypePointer(SimStruct({"contractDescription": SimTypePointer(SimStruct({"operationCount": SimTypeInt(signed=False, label="UInt32"), "operations": SimTypePointer(SimTypePointer(SimStruct({"versionInfo": SimTypeInt(signed=False, label="UInt32"), "inputMessageDescription": SimTypePointer(SimStruct({"action": SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), "bodyElementDescription": SimTypePointer(SimStruct({"elementLocalName": SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), "elementNs": SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), "type": SimTypeInt(signed=False, label="WS_TYPE"), "typeDescription": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="WS_ELEMENT_DESCRIPTION", pack=False, align=None), offset=0)}, name="WS_MESSAGE_DESCRIPTION", pack=False, align=None), offset=0), "outputMessageDescription": SimTypePointer(SimStruct({"action": SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), "bodyElementDescription": SimTypePointer(SimStruct({"elementLocalName": SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), "elementNs": SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), "type": SimTypeInt(signed=False, label="WS_TYPE"), "typeDescription": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="WS_ELEMENT_DESCRIPTION", pack=False, align=None), offset=0)}, name="WS_MESSAGE_DESCRIPTION", pack=False, align=None), offset=0), "inputMessageOptions": SimTypeInt(signed=False, label="UInt32"), "outputMessageOptions": SimTypeInt(signed=False, label="UInt32"), "parameterCount": SimTypeShort(signed=False, label="UInt16"), "parameterDescription": SimTypePointer(SimStruct({"parameterType": SimTypeInt(signed=False, label="WS_PARAMETER_TYPE"), "inputMessageIndex": SimTypeShort(signed=False, label="UInt16"), "outputMessageIndex": SimTypeShort(signed=False, label="UInt16")}, name="WS_PARAMETER_DESCRIPTION", pack=False, align=None), offset=0), "stubCallback": SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_OPERATION_CONTEXT", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="WS_ASYNC_CONTEXT"), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["context", "frame", "callback", "asyncContext", "error"]), offset=0), "style": SimTypeInt(signed=False, label="WS_OPERATION_STYLE")}, name="WS_OPERATION_DESCRIPTION", pack=False, align=None), offset=0), offset=0)}, name="WS_CONTRACT_DESCRIPTION", pack=False, align=None), offset=0), "defaultMessageHandlerCallback": SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_OPERATION_CONTEXT", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="WS_ASYNC_CONTEXT"), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["context", "asyncContext", "error"]), offset=0), "methodTable": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="WS_SERVICE_CONTRACT", pack=False, align=None), offset=0), "authorizationCallback": SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_OPERATION_CONTEXT", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["context", "authorized", "error"]), offset=0), "properties": SimTypePointer(SimStruct({"id": SimTypeInt(signed=False, label="WS_SERVICE_ENDPOINT_PROPERTY_ID"), "value": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "valueSize": SimTypeInt(signed=False, label="UInt32")}, name="WS_SERVICE_ENDPOINT_PROPERTY", pack=False, align=None), offset=0), "propertyCount": SimTypeInt(signed=False, label="UInt32"), "channelProperties": SimStruct({"properties": SimTypePointer(SimStruct({"id": SimTypeInt(signed=False, label="WS_CHANNEL_PROPERTY_ID"), "value": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "valueSize": SimTypeInt(signed=False, label="UInt32")}, name="WS_CHANNEL_PROPERTY", pack=False, align=None), offset=0), "propertyCount": SimTypeInt(signed=False, label="UInt32")}, name="WS_CHANNEL_PROPERTIES", pack=False, align=None)}, name="WS_SERVICE_ENDPOINT", pack=False, align=None), offset=0), label="LPArray", offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimStruct({"id": SimTypeInt(signed=False, label="WS_SERVICE_PROPERTY_ID"), "value": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "valueSize": SimTypeInt(signed=False, label="UInt32")}, name="WS_SERVICE_PROPERTY", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({}, name="WS_SERVICE_HOST", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["endpoints", "endpointCount", "serviceProperties", "servicePropertyCount", "serviceHost", "error"]),
        # 
        'WsOpenServiceHost': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_SERVICE_HOST", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"callback": SimTypePointer(SimTypeFunction([SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="WS_CALLBACK_MODEL"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["errorCode", "callbackModel", "callbackState"]), offset=0), "callbackState": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="WS_ASYNC_CONTEXT", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["serviceHost", "asyncContext", "error"]),
        # 
        'WsCloseServiceHost': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_SERVICE_HOST", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"callback": SimTypePointer(SimTypeFunction([SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="WS_CALLBACK_MODEL"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["errorCode", "callbackModel", "callbackState"]), offset=0), "callbackState": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="WS_ASYNC_CONTEXT", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["serviceHost", "asyncContext", "error"]),
        # 
        'WsAbortServiceHost': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_SERVICE_HOST", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["serviceHost", "error"]),
        # 
        'WsFreeServiceHost': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_SERVICE_HOST", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["serviceHost"]),
        # 
        'WsResetServiceHost': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_SERVICE_HOST", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["serviceHost", "error"]),
        # 
        'WsGetServiceProxyProperty': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_SERVICE_PROXY", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="WS_PROXY_PROPERTY_ID"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["serviceProxy", "id", "value", "valueSize", "error"]),
        # 
        'WsCreateServiceProxy': SimTypeFunction([SimTypeInt(signed=False, label="WS_CHANNEL_TYPE"), SimTypeInt(signed=False, label="WS_CHANNEL_BINDING"), SimTypePointer(SimStruct({"securityBindings": SimTypePointer(SimTypePointer(SimStruct({"bindingType": SimTypeInt(signed=False, label="WS_SECURITY_BINDING_TYPE"), "properties": SimTypePointer(SimStruct({"id": SimTypeInt(signed=False, label="WS_SECURITY_BINDING_PROPERTY_ID"), "value": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "valueSize": SimTypeInt(signed=False, label="UInt32")}, name="WS_SECURITY_BINDING_PROPERTY", pack=False, align=None), offset=0), "propertyCount": SimTypeInt(signed=False, label="UInt32")}, name="WS_SECURITY_BINDING", pack=False, align=None), offset=0), offset=0), "securityBindingCount": SimTypeInt(signed=False, label="UInt32"), "properties": SimTypePointer(SimStruct({"id": SimTypeInt(signed=False, label="WS_SECURITY_PROPERTY_ID"), "value": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "valueSize": SimTypeInt(signed=False, label="UInt32")}, name="WS_SECURITY_PROPERTY", pack=False, align=None), offset=0), "propertyCount": SimTypeInt(signed=False, label="UInt32")}, name="WS_SECURITY_DESCRIPTION", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"id": SimTypeInt(signed=False, label="WS_PROXY_PROPERTY_ID"), "value": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "valueSize": SimTypeInt(signed=False, label="UInt32")}, name="WS_PROXY_PROPERTY", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"id": SimTypeInt(signed=False, label="WS_CHANNEL_PROPERTY_ID"), "value": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "valueSize": SimTypeInt(signed=False, label="UInt32")}, name="WS_CHANNEL_PROPERTY", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({}, name="WS_SERVICE_PROXY", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["channelType", "channelBinding", "securityDescription", "properties", "propertyCount", "channelProperties", "channelPropertyCount", "serviceProxy", "error"]),
        # 
        'WsOpenServiceProxy': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_SERVICE_PROXY", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"url": SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "chars": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WS_STRING", pack=False, align=None), "headers": SimTypePointer(SimStruct({}, name="WS_XML_BUFFER", pack=False, align=None), offset=0), "extensions": SimTypePointer(SimStruct({}, name="WS_XML_BUFFER", pack=False, align=None), offset=0), "identity": SimTypePointer(SimStruct({"identityType": SimTypeInt(signed=False, label="WS_ENDPOINT_IDENTITY_TYPE")}, name="WS_ENDPOINT_IDENTITY", pack=False, align=None), offset=0)}, name="WS_ENDPOINT_ADDRESS", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"callback": SimTypePointer(SimTypeFunction([SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="WS_CALLBACK_MODEL"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["errorCode", "callbackModel", "callbackState"]), offset=0), "callbackState": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="WS_ASYNC_CONTEXT", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["serviceProxy", "address", "asyncContext", "error"]),
        # 
        'WsCloseServiceProxy': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_SERVICE_PROXY", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"callback": SimTypePointer(SimTypeFunction([SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="WS_CALLBACK_MODEL"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["errorCode", "callbackModel", "callbackState"]), offset=0), "callbackState": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="WS_ASYNC_CONTEXT", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["serviceProxy", "asyncContext", "error"]),
        # 
        'WsAbortServiceProxy': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_SERVICE_PROXY", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["serviceProxy", "error"]),
        # 
        'WsFreeServiceProxy': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_SERVICE_PROXY", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["serviceProxy"]),
        # 
        'WsResetServiceProxy': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_SERVICE_PROXY", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["serviceProxy", "error"]),
        # 
        'WsAbandonCall': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_SERVICE_PROXY", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["serviceProxy", "callId", "error"]),
        # 
        'WsCall': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_SERVICE_PROXY", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"versionInfo": SimTypeInt(signed=False, label="UInt32"), "inputMessageDescription": SimTypePointer(SimStruct({"action": SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), "bodyElementDescription": SimTypePointer(SimStruct({"elementLocalName": SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), "elementNs": SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), "type": SimTypeInt(signed=False, label="WS_TYPE"), "typeDescription": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="WS_ELEMENT_DESCRIPTION", pack=False, align=None), offset=0)}, name="WS_MESSAGE_DESCRIPTION", pack=False, align=None), offset=0), "outputMessageDescription": SimTypePointer(SimStruct({"action": SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), "bodyElementDescription": SimTypePointer(SimStruct({"elementLocalName": SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), "elementNs": SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), "type": SimTypeInt(signed=False, label="WS_TYPE"), "typeDescription": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="WS_ELEMENT_DESCRIPTION", pack=False, align=None), offset=0)}, name="WS_MESSAGE_DESCRIPTION", pack=False, align=None), offset=0), "inputMessageOptions": SimTypeInt(signed=False, label="UInt32"), "outputMessageOptions": SimTypeInt(signed=False, label="UInt32"), "parameterCount": SimTypeShort(signed=False, label="UInt16"), "parameterDescription": SimTypePointer(SimStruct({"parameterType": SimTypeInt(signed=False, label="WS_PARAMETER_TYPE"), "inputMessageIndex": SimTypeShort(signed=False, label="UInt16"), "outputMessageIndex": SimTypeShort(signed=False, label="UInt16")}, name="WS_PARAMETER_DESCRIPTION", pack=False, align=None), offset=0), "stubCallback": SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_OPERATION_CONTEXT", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="WS_ASYNC_CONTEXT"), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["context", "frame", "callback", "asyncContext", "error"]), offset=0), "style": SimTypeInt(signed=False, label="WS_OPERATION_STYLE")}, name="WS_OPERATION_DESCRIPTION", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimStruct({}, name="WS_HEAP", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"id": SimTypeInt(signed=False, label="WS_CALL_PROPERTY_ID"), "value": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "valueSize": SimTypeInt(signed=False, label="UInt32")}, name="WS_CALL_PROPERTY", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"callback": SimTypePointer(SimTypeFunction([SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="WS_CALLBACK_MODEL"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["errorCode", "callbackModel", "callbackState"]), offset=0), "callbackState": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="WS_ASYNC_CONTEXT", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["serviceProxy", "operation", "arguments", "heap", "callProperties", "callPropertyCount", "asyncContext", "error"]),
        # 
        'WsDecodeUrl': SimTypeFunction([SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "chars": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WS_STRING", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({}, name="WS_HEAP", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimStruct({"scheme": SimTypeInt(signed=False, label="WS_URL_SCHEME_TYPE")}, name="WS_URL", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["url", "flags", "heap", "outUrl", "error"]),
        # 
        'WsEncodeUrl': SimTypeFunction([SimTypePointer(SimStruct({"scheme": SimTypeInt(signed=False, label="WS_URL_SCHEME_TYPE")}, name="WS_URL", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({}, name="WS_HEAP", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "chars": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WS_STRING", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["url", "flags", "heap", "outUrl", "error"]),
        # 
        'WsCombineUrl': SimTypeFunction([SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "chars": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WS_STRING", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "chars": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WS_STRING", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({}, name="WS_HEAP", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "chars": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WS_STRING", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["baseUrl", "referenceUrl", "flags", "heap", "resultUrl", "error"]),
        # 
        'WsDateTimeToFileTime': SimTypeFunction([SimTypePointer(SimStruct({"ticks": SimTypeLongLong(signed=False, label="UInt64"), "format": SimTypeInt(signed=False, label="WS_DATETIME_FORMAT")}, name="WS_DATETIME", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dateTime", "fileTime", "error"]),
        # 
        'WsFileTimeToDateTime': SimTypeFunction([SimTypePointer(SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"ticks": SimTypeLongLong(signed=False, label="UInt64"), "format": SimTypeInt(signed=False, label="WS_DATETIME_FORMAT")}, name="WS_DATETIME", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["fileTime", "dateTime", "error"]),
        # 
        'WsCreateMetadata': SimTypeFunction([SimTypePointer(SimStruct({"id": SimTypeInt(signed=False, label="WS_METADATA_PROPERTY_ID"), "value": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "valueSize": SimTypeInt(signed=False, label="UInt32")}, name="WS_METADATA_PROPERTY", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({}, name="WS_METADATA", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["properties", "propertyCount", "metadata", "error"]),
        # 
        'WsReadMetadata': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_METADATA", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_XML_READER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "chars": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WS_STRING", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["metadata", "reader", "url", "error"]),
        # 
        'WsFreeMetadata': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_METADATA", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["metadata"]),
        # 
        'WsResetMetadata': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_METADATA", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["metadata", "error"]),
        # 
        'WsGetMetadataProperty': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_METADATA", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="WS_METADATA_PROPERTY_ID"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["metadata", "id", "value", "valueSize", "error"]),
        # 
        'WsGetMissingMetadataDocumentAddress': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_METADATA", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimStruct({"url": SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "chars": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WS_STRING", pack=False, align=None), "headers": SimTypePointer(SimStruct({}, name="WS_XML_BUFFER", pack=False, align=None), offset=0), "extensions": SimTypePointer(SimStruct({}, name="WS_XML_BUFFER", pack=False, align=None), offset=0), "identity": SimTypePointer(SimStruct({"identityType": SimTypeInt(signed=False, label="WS_ENDPOINT_IDENTITY_TYPE")}, name="WS_ENDPOINT_IDENTITY", pack=False, align=None), offset=0)}, name="WS_ENDPOINT_ADDRESS", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["metadata", "address", "error"]),
        # 
        'WsGetMetadataEndpoints': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_METADATA", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"endpoints": SimTypePointer(SimStruct({"endpointAddress": SimStruct({"url": SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "chars": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WS_STRING", pack=False, align=None), "headers": SimTypePointer(SimStruct({}, name="WS_XML_BUFFER", pack=False, align=None), offset=0), "extensions": SimTypePointer(SimStruct({}, name="WS_XML_BUFFER", pack=False, align=None), offset=0), "identity": SimTypePointer(SimStruct({"identityType": SimTypeInt(signed=False, label="WS_ENDPOINT_IDENTITY_TYPE")}, name="WS_ENDPOINT_IDENTITY", pack=False, align=None), offset=0)}, name="WS_ENDPOINT_ADDRESS", pack=False, align=None), "endpointPolicy": SimTypePointer(SimStruct({}, name="WS_POLICY", pack=False, align=None), offset=0), "portName": SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), "serviceName": SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), "serviceNs": SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), "bindingName": SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), "bindingNs": SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), "portTypeName": SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), "portTypeNs": SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0)}, name="WS_METADATA_ENDPOINT", pack=False, align=None), offset=0), "endpointCount": SimTypeInt(signed=False, label="UInt32")}, name="WS_METADATA_ENDPOINTS", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["metadata", "endpoints", "error"]),
        # 
        'WsMatchPolicyAlternative': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_POLICY", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"channelBinding": SimTypeInt(signed=False, label="WS_CHANNEL_BINDING"), "channelPropertyConstraints": SimTypePointer(SimStruct({"id": SimTypeInt(signed=False, label="WS_CHANNEL_PROPERTY_ID"), "allowedValues": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "allowedValuesSize": SimTypeInt(signed=False, label="UInt32"), "out": SimStruct({"channelProperty": SimStruct({"id": SimTypeInt(signed=False, label="WS_CHANNEL_PROPERTY_ID"), "value": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "valueSize": SimTypeInt(signed=False, label="UInt32")}, name="WS_CHANNEL_PROPERTY", pack=False, align=None)}, name="_out_e__Struct", pack=False, align=None)}, name="WS_CHANNEL_PROPERTY_CONSTRAINT", pack=False, align=None), offset=0), "channelPropertyConstraintCount": SimTypeInt(signed=False, label="UInt32"), "securityConstraints": SimTypePointer(SimStruct({"securityPropertyConstraints": SimTypePointer(SimStruct({"id": SimTypeInt(signed=False, label="WS_SECURITY_PROPERTY_ID"), "allowedValues": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "allowedValuesSize": SimTypeInt(signed=False, label="UInt32"), "out": SimStruct({"securityProperty": SimStruct({"id": SimTypeInt(signed=False, label="WS_SECURITY_PROPERTY_ID"), "value": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "valueSize": SimTypeInt(signed=False, label="UInt32")}, name="WS_SECURITY_PROPERTY", pack=False, align=None)}, name="_out_e__Struct", pack=False, align=None)}, name="WS_SECURITY_PROPERTY_CONSTRAINT", pack=False, align=None), offset=0), "securityPropertyConstraintCount": SimTypeInt(signed=False, label="UInt32"), "securityBindingConstraints": SimTypePointer(SimTypePointer(SimStruct({"type": SimTypeInt(signed=False, label="WS_SECURITY_BINDING_CONSTRAINT_TYPE"), "propertyConstraints": SimTypePointer(SimStruct({"id": SimTypeInt(signed=False, label="WS_SECURITY_BINDING_PROPERTY_ID"), "allowedValues": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "allowedValuesSize": SimTypeInt(signed=False, label="UInt32"), "out": SimStruct({"securityBindingProperty": SimStruct({"id": SimTypeInt(signed=False, label="WS_SECURITY_BINDING_PROPERTY_ID"), "value": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "valueSize": SimTypeInt(signed=False, label="UInt32")}, name="WS_SECURITY_BINDING_PROPERTY", pack=False, align=None)}, name="_out_e__Struct", pack=False, align=None)}, name="WS_SECURITY_BINDING_PROPERTY_CONSTRAINT", pack=False, align=None), offset=0), "propertyConstraintCount": SimTypeInt(signed=False, label="UInt32")}, name="WS_SECURITY_BINDING_CONSTRAINT", pack=False, align=None), offset=0), offset=0), "securityBindingConstraintCount": SimTypeInt(signed=False, label="UInt32")}, name="WS_SECURITY_CONSTRAINTS", pack=False, align=None), offset=0), "policyExtensions": SimTypePointer(SimTypePointer(SimStruct({"type": SimTypeInt(signed=False, label="WS_POLICY_EXTENSION_TYPE")}, name="WS_POLICY_EXTENSION", pack=False, align=None), offset=0), offset=0), "policyExtensionCount": SimTypeInt(signed=False, label="UInt32")}, name="WS_POLICY_CONSTRAINTS", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimStruct({}, name="WS_HEAP", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["policy", "alternativeIndex", "policyConstraints", "matchRequired", "heap", "error"]),
        # 
        'WsGetPolicyProperty': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_POLICY", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="WS_POLICY_PROPERTY_ID"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["policy", "id", "value", "valueSize", "error"]),
        # 
        'WsGetPolicyAlternativeCount': SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_POLICY", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["policy", "count", "error"]),
        # 
        'WsCreateServiceProxyFromTemplate': SimTypeFunction([SimTypeInt(signed=False, label="WS_CHANNEL_TYPE"), SimTypePointer(SimStruct({"id": SimTypeInt(signed=False, label="WS_PROXY_PROPERTY_ID"), "value": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "valueSize": SimTypeInt(signed=False, label="UInt32")}, name="WS_PROXY_PROPERTY", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="WS_BINDING_TEMPLATE_TYPE"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({}, name="WS_SERVICE_PROXY", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["channelType", "properties", "propertyCount", "templateType", "templateValue", "templateSize", "templateDescription", "templateDescriptionSize", "serviceProxy", "error"]),
        # 
        'WsCreateServiceEndpointFromTemplate': SimTypeFunction([SimTypeInt(signed=False, label="WS_CHANNEL_TYPE"), SimTypePointer(SimStruct({"id": SimTypeInt(signed=False, label="WS_SERVICE_ENDPOINT_PROPERTY_ID"), "value": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "valueSize": SimTypeInt(signed=False, label="UInt32")}, name="WS_SERVICE_ENDPOINT_PROPERTY", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "chars": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WS_STRING", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"contractDescription": SimTypePointer(SimStruct({"operationCount": SimTypeInt(signed=False, label="UInt32"), "operations": SimTypePointer(SimTypePointer(SimStruct({"versionInfo": SimTypeInt(signed=False, label="UInt32"), "inputMessageDescription": SimTypePointer(SimStruct({"action": SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), "bodyElementDescription": SimTypePointer(SimStruct({"elementLocalName": SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), "elementNs": SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), "type": SimTypeInt(signed=False, label="WS_TYPE"), "typeDescription": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="WS_ELEMENT_DESCRIPTION", pack=False, align=None), offset=0)}, name="WS_MESSAGE_DESCRIPTION", pack=False, align=None), offset=0), "outputMessageDescription": SimTypePointer(SimStruct({"action": SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), "bodyElementDescription": SimTypePointer(SimStruct({"elementLocalName": SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), "elementNs": SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), "type": SimTypeInt(signed=False, label="WS_TYPE"), "typeDescription": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="WS_ELEMENT_DESCRIPTION", pack=False, align=None), offset=0)}, name="WS_MESSAGE_DESCRIPTION", pack=False, align=None), offset=0), "inputMessageOptions": SimTypeInt(signed=False, label="UInt32"), "outputMessageOptions": SimTypeInt(signed=False, label="UInt32"), "parameterCount": SimTypeShort(signed=False, label="UInt16"), "parameterDescription": SimTypePointer(SimStruct({"parameterType": SimTypeInt(signed=False, label="WS_PARAMETER_TYPE"), "inputMessageIndex": SimTypeShort(signed=False, label="UInt16"), "outputMessageIndex": SimTypeShort(signed=False, label="UInt16")}, name="WS_PARAMETER_DESCRIPTION", pack=False, align=None), offset=0), "stubCallback": SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_OPERATION_CONTEXT", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="WS_ASYNC_CONTEXT"), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["context", "frame", "callback", "asyncContext", "error"]), offset=0), "style": SimTypeInt(signed=False, label="WS_OPERATION_STYLE")}, name="WS_OPERATION_DESCRIPTION", pack=False, align=None), offset=0), offset=0)}, name="WS_CONTRACT_DESCRIPTION", pack=False, align=None), offset=0), "defaultMessageHandlerCallback": SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_OPERATION_CONTEXT", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="WS_ASYNC_CONTEXT"), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["context", "asyncContext", "error"]), offset=0), "methodTable": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="WS_SERVICE_CONTRACT", pack=False, align=None), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_OPERATION_CONTEXT", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["context", "authorized", "error"]), offset=0), SimTypePointer(SimStruct({}, name="WS_HEAP", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="WS_BINDING_TEMPLATE_TYPE"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"address": SimStruct({"url": SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "chars": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WS_STRING", pack=False, align=None), "headers": SimTypePointer(SimStruct({}, name="WS_XML_BUFFER", pack=False, align=None), offset=0), "extensions": SimTypePointer(SimStruct({}, name="WS_XML_BUFFER", pack=False, align=None), offset=0), "identity": SimTypePointer(SimStruct({"identityType": SimTypeInt(signed=False, label="WS_ENDPOINT_IDENTITY_TYPE")}, name="WS_ENDPOINT_IDENTITY", pack=False, align=None), offset=0)}, name="WS_ENDPOINT_ADDRESS", pack=False, align=None), "channelBinding": SimTypeInt(signed=False, label="WS_CHANNEL_BINDING"), "channelType": SimTypeInt(signed=False, label="WS_CHANNEL_TYPE"), "securityDescription": SimTypePointer(SimStruct({"securityBindings": SimTypePointer(SimTypePointer(SimStruct({"bindingType": SimTypeInt(signed=False, label="WS_SECURITY_BINDING_TYPE"), "properties": SimTypePointer(SimStruct({"id": SimTypeInt(signed=False, label="WS_SECURITY_BINDING_PROPERTY_ID"), "value": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "valueSize": SimTypeInt(signed=False, label="UInt32")}, name="WS_SECURITY_BINDING_PROPERTY", pack=False, align=None), offset=0), "propertyCount": SimTypeInt(signed=False, label="UInt32")}, name="WS_SECURITY_BINDING", pack=False, align=None), offset=0), offset=0), "securityBindingCount": SimTypeInt(signed=False, label="UInt32"), "properties": SimTypePointer(SimStruct({"id": SimTypeInt(signed=False, label="WS_SECURITY_PROPERTY_ID"), "value": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "valueSize": SimTypeInt(signed=False, label="UInt32")}, name="WS_SECURITY_PROPERTY", pack=False, align=None), offset=0), "propertyCount": SimTypeInt(signed=False, label="UInt32")}, name="WS_SECURITY_DESCRIPTION", pack=False, align=None), offset=0), "contract": SimTypePointer(SimStruct({"contractDescription": SimTypePointer(SimStruct({"operationCount": SimTypeInt(signed=False, label="UInt32"), "operations": SimTypePointer(SimTypePointer(SimStruct({"versionInfo": SimTypeInt(signed=False, label="UInt32"), "inputMessageDescription": SimTypePointer(SimStruct({"action": SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), "bodyElementDescription": SimTypePointer(SimStruct({"elementLocalName": SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), "elementNs": SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), "type": SimTypeInt(signed=False, label="WS_TYPE"), "typeDescription": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="WS_ELEMENT_DESCRIPTION", pack=False, align=None), offset=0)}, name="WS_MESSAGE_DESCRIPTION", pack=False, align=None), offset=0), "outputMessageDescription": SimTypePointer(SimStruct({"action": SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), "bodyElementDescription": SimTypePointer(SimStruct({"elementLocalName": SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), "elementNs": SimTypePointer(SimStruct({"length": SimTypeInt(signed=False, label="UInt32"), "bytes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dictionary": SimTypePointer(SimStruct({"guid": SimTypeBottom(label="Guid"), "strings": SimTypePointer(SimTypeBottom(label="WS_XML_STRING"), offset=0), "stringCount": SimTypeInt(signed=False, label="UInt32"), "isConst": SimTypeInt(signed=True, label="Int32")}, name="WS_XML_DICTIONARY", pack=False, align=None), offset=0), "id": SimTypeInt(signed=False, label="UInt32")}, name="WS_XML_STRING", pack=False, align=None), offset=0), "type": SimTypeInt(signed=False, label="WS_TYPE"), "typeDescription": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="WS_ELEMENT_DESCRIPTION", pack=False, align=None), offset=0)}, name="WS_MESSAGE_DESCRIPTION", pack=False, align=None), offset=0), "inputMessageOptions": SimTypeInt(signed=False, label="UInt32"), "outputMessageOptions": SimTypeInt(signed=False, label="UInt32"), "parameterCount": SimTypeShort(signed=False, label="UInt16"), "parameterDescription": SimTypePointer(SimStruct({"parameterType": SimTypeInt(signed=False, label="WS_PARAMETER_TYPE"), "inputMessageIndex": SimTypeShort(signed=False, label="UInt16"), "outputMessageIndex": SimTypeShort(signed=False, label="UInt16")}, name="WS_PARAMETER_DESCRIPTION", pack=False, align=None), offset=0), "stubCallback": SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_OPERATION_CONTEXT", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="WS_ASYNC_CONTEXT"), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["context", "frame", "callback", "asyncContext", "error"]), offset=0), "style": SimTypeInt(signed=False, label="WS_OPERATION_STYLE")}, name="WS_OPERATION_DESCRIPTION", pack=False, align=None), offset=0), offset=0)}, name="WS_CONTRACT_DESCRIPTION", pack=False, align=None), offset=0), "defaultMessageHandlerCallback": SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_OPERATION_CONTEXT", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="WS_ASYNC_CONTEXT"), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["context", "asyncContext", "error"]), offset=0), "methodTable": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="WS_SERVICE_CONTRACT", pack=False, align=None), offset=0), "authorizationCallback": SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({}, name="WS_OPERATION_CONTEXT", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["context", "authorized", "error"]), offset=0), "properties": SimTypePointer(SimStruct({"id": SimTypeInt(signed=False, label="WS_SERVICE_ENDPOINT_PROPERTY_ID"), "value": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "valueSize": SimTypeInt(signed=False, label="UInt32")}, name="WS_SERVICE_ENDPOINT_PROPERTY", pack=False, align=None), offset=0), "propertyCount": SimTypeInt(signed=False, label="UInt32"), "channelProperties": SimStruct({"properties": SimTypePointer(SimStruct({"id": SimTypeInt(signed=False, label="WS_CHANNEL_PROPERTY_ID"), "value": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "valueSize": SimTypeInt(signed=False, label="UInt32")}, name="WS_CHANNEL_PROPERTY", pack=False, align=None), offset=0), "propertyCount": SimTypeInt(signed=False, label="UInt32")}, name="WS_CHANNEL_PROPERTIES", pack=False, align=None)}, name="WS_SERVICE_ENDPOINT", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimStruct({}, name="WS_ERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["channelType", "properties", "propertyCount", "addressUrl", "contract", "authorizationCallback", "heap", "templateType", "templateValue", "templateSize", "templateDescription", "templateDescriptionSize", "serviceEndpoint", "error"]),
    }

lib.set_prototypes(prototypes)
