# pylint:disable=line-too-long
import logging

from ...sim_type import SimTypeFunction,     SimTypeShort, SimTypeInt, SimTypeLong, SimTypeLongLong, SimTypeDouble, SimTypeFloat,     SimTypePointer,     SimTypeChar,     SimStruct,     SimTypeFixedSizeArray,     SimTypeBottom,     SimUnion,     SimTypeBool
from ...calling_conventions import SimCCStdcall, SimCCMicrosoftAMD64
from .. import SIM_PROCEDURES as P
from . import SimLibrary


_l = logging.getLogger(name=__name__)


lib = SimLibrary()
lib.set_default_cc('X86', SimCCStdcall)
lib.set_default_cc('AMD64', SimCCMicrosoftAMD64)
lib.set_library_names("wevtapi.dll")
prototypes = \
    {
        # 
        'EvtOpenSession': SimTypeFunction([SimTypeInt(signed=False, label="EVT_LOGIN_CLASS"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["LoginClass", "Login", "Timeout", "Flags"]),
        # 
        'EvtClose': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Object"]),
        # 
        'EvtCancel': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Object"]),
        # 
        'EvtGetExtendedStatus': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["BufferSize", "Buffer", "BufferUsed"]),
        # 
        'EvtQuery': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["Session", "Path", "Query", "Flags"]),
        # 
        'EvtNext': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ResultSet", "EventsSize", "Events", "Timeout", "Flags", "Returned"]),
        # 
        'EvtSeek': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=True, label="Int64"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["ResultSet", "Position", "Bookmark", "Timeout", "Flags"]),
        # 
        'EvtSubscribe': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="EVT_SUBSCRIBE_NOTIFY_ACTION"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["Action", "UserContext", "Event"]), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["Session", "SignalEvent", "ChannelPath", "Query", "Bookmark", "Context", "Callback", "Flags"]),
        # 
        'EvtCreateRenderContext': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["ValuePathsCount", "ValuePaths", "Flags"]),
        # 
        'EvtRender': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Context", "Fragment", "Flags", "BufferSize", "Buffer", "BufferUsed", "PropertyCount"]),
        # 
        'EvtFormatMessage': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Anonymous": SimUnion({"BooleanVal": SimTypeInt(signed=True, label="Int32"), "SByteVal": SimTypeChar(label="SByte"), "Int16Val": SimTypeShort(signed=True, label="Int16"), "Int32Val": SimTypeInt(signed=True, label="Int32"), "Int64Val": SimTypeLongLong(signed=True, label="Int64"), "ByteVal": SimTypeChar(label="Byte"), "UInt16Val": SimTypeShort(signed=False, label="UInt16"), "UInt32Val": SimTypeInt(signed=False, label="UInt32"), "UInt64Val": SimTypeLongLong(signed=False, label="UInt64"), "SingleVal": SimTypeFloat(size=32), "DoubleVal": SimTypeFloat(size=64), "FileTimeVal": SimTypeLongLong(signed=False, label="UInt64"), "SysTimeVal": SimTypePointer(SimStruct({"wYear": SimTypeShort(signed=False, label="UInt16"), "wMonth": SimTypeShort(signed=False, label="UInt16"), "wDayOfWeek": SimTypeShort(signed=False, label="UInt16"), "wDay": SimTypeShort(signed=False, label="UInt16"), "wHour": SimTypeShort(signed=False, label="UInt16"), "wMinute": SimTypeShort(signed=False, label="UInt16"), "wSecond": SimTypeShort(signed=False, label="UInt16"), "wMilliseconds": SimTypeShort(signed=False, label="UInt16")}, name="SYSTEMTIME", pack=False, align=None), offset=0), "GuidVal": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "StringVal": SimTypePointer(SimTypeChar(label="Char"), offset=0), "AnsiStringVal": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BinaryVal": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SidVal": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "SizeTVal": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "BooleanArr": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), "SByteArr": SimTypePointer(SimTypeChar(label="SByte"), offset=0), "Int16Arr": SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), "Int32Arr": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), "Int64Arr": SimTypePointer(SimTypeLongLong(signed=True, label="Int64"), offset=0), "ByteArr": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "UInt16Arr": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "UInt32Arr": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "UInt64Arr": SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0), "SingleArr": SimTypePointer(SimTypeFloat(size=32), offset=0), "DoubleArr": SimTypePointer(SimTypeFloat(size=64), offset=0), "FileTimeArr": SimTypePointer(SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), offset=0), "SysTimeArr": SimTypePointer(SimStruct({"wYear": SimTypeShort(signed=False, label="UInt16"), "wMonth": SimTypeShort(signed=False, label="UInt16"), "wDayOfWeek": SimTypeShort(signed=False, label="UInt16"), "wDay": SimTypeShort(signed=False, label="UInt16"), "wHour": SimTypeShort(signed=False, label="UInt16"), "wMinute": SimTypeShort(signed=False, label="UInt16"), "wSecond": SimTypeShort(signed=False, label="UInt16"), "wMilliseconds": SimTypeShort(signed=False, label="UInt16")}, name="SYSTEMTIME", pack=False, align=None), offset=0), "GuidArr": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "StringArr": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), "AnsiStringArr": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), "SidArr": SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), "SizeTArr": SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0), "EvtHandleVal": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "XmlVal": SimTypePointer(SimTypeChar(label="Char"), offset=0), "XmlValArr": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)}, name="<anon>", label="None"), "Count": SimTypeInt(signed=False, label="UInt32"), "Type": SimTypeInt(signed=False, label="UInt32")}, name="EVT_VARIANT", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["PublisherMetadata", "Event", "MessageId", "ValueCount", "Values", "Flags", "BufferSize", "Buffer", "BufferUsed"]),
        # 
        'EvtOpenLog': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["Session", "Path", "Flags"]),
        # 
        'EvtGetLogInfo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="EVT_LOG_PROPERTY_ID"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Anonymous": SimUnion({"BooleanVal": SimTypeInt(signed=True, label="Int32"), "SByteVal": SimTypeChar(label="SByte"), "Int16Val": SimTypeShort(signed=True, label="Int16"), "Int32Val": SimTypeInt(signed=True, label="Int32"), "Int64Val": SimTypeLongLong(signed=True, label="Int64"), "ByteVal": SimTypeChar(label="Byte"), "UInt16Val": SimTypeShort(signed=False, label="UInt16"), "UInt32Val": SimTypeInt(signed=False, label="UInt32"), "UInt64Val": SimTypeLongLong(signed=False, label="UInt64"), "SingleVal": SimTypeFloat(size=32), "DoubleVal": SimTypeFloat(size=64), "FileTimeVal": SimTypeLongLong(signed=False, label="UInt64"), "SysTimeVal": SimTypePointer(SimStruct({"wYear": SimTypeShort(signed=False, label="UInt16"), "wMonth": SimTypeShort(signed=False, label="UInt16"), "wDayOfWeek": SimTypeShort(signed=False, label="UInt16"), "wDay": SimTypeShort(signed=False, label="UInt16"), "wHour": SimTypeShort(signed=False, label="UInt16"), "wMinute": SimTypeShort(signed=False, label="UInt16"), "wSecond": SimTypeShort(signed=False, label="UInt16"), "wMilliseconds": SimTypeShort(signed=False, label="UInt16")}, name="SYSTEMTIME", pack=False, align=None), offset=0), "GuidVal": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "StringVal": SimTypePointer(SimTypeChar(label="Char"), offset=0), "AnsiStringVal": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BinaryVal": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SidVal": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "SizeTVal": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "BooleanArr": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), "SByteArr": SimTypePointer(SimTypeChar(label="SByte"), offset=0), "Int16Arr": SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), "Int32Arr": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), "Int64Arr": SimTypePointer(SimTypeLongLong(signed=True, label="Int64"), offset=0), "ByteArr": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "UInt16Arr": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "UInt32Arr": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "UInt64Arr": SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0), "SingleArr": SimTypePointer(SimTypeFloat(size=32), offset=0), "DoubleArr": SimTypePointer(SimTypeFloat(size=64), offset=0), "FileTimeArr": SimTypePointer(SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), offset=0), "SysTimeArr": SimTypePointer(SimStruct({"wYear": SimTypeShort(signed=False, label="UInt16"), "wMonth": SimTypeShort(signed=False, label="UInt16"), "wDayOfWeek": SimTypeShort(signed=False, label="UInt16"), "wDay": SimTypeShort(signed=False, label="UInt16"), "wHour": SimTypeShort(signed=False, label="UInt16"), "wMinute": SimTypeShort(signed=False, label="UInt16"), "wSecond": SimTypeShort(signed=False, label="UInt16"), "wMilliseconds": SimTypeShort(signed=False, label="UInt16")}, name="SYSTEMTIME", pack=False, align=None), offset=0), "GuidArr": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "StringArr": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), "AnsiStringArr": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), "SidArr": SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), "SizeTArr": SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0), "EvtHandleVal": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "XmlVal": SimTypePointer(SimTypeChar(label="Char"), offset=0), "XmlValArr": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)}, name="<anon>", label="None"), "Count": SimTypeInt(signed=False, label="UInt32"), "Type": SimTypeInt(signed=False, label="UInt32")}, name="EVT_VARIANT", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Log", "PropertyId", "PropertyValueBufferSize", "PropertyValueBuffer", "PropertyValueBufferUsed"]),
        # 
        'EvtClearLog': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["Session", "ChannelPath", "TargetFilePath", "Flags"]),
        # 
        'EvtExportLog': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["Session", "Path", "Query", "TargetFilePath", "Flags"]),
        # 
        'EvtArchiveExportedLog': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["Session", "LogFilePath", "Locale", "Flags"]),
        # 
        'EvtOpenChannelEnum': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["Session", "Flags"]),
        # 
        'EvtNextChannelPath': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ChannelEnum", "ChannelPathBufferSize", "ChannelPathBuffer", "ChannelPathBufferUsed"]),
        # 
        'EvtOpenChannelConfig': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["Session", "ChannelPath", "Flags"]),
        # 
        'EvtSaveChannelConfig': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["ChannelConfig", "Flags"]),
        # 
        'EvtSetChannelConfigProperty': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="EVT_CHANNEL_CONFIG_PROPERTY_ID"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Anonymous": SimUnion({"BooleanVal": SimTypeInt(signed=True, label="Int32"), "SByteVal": SimTypeChar(label="SByte"), "Int16Val": SimTypeShort(signed=True, label="Int16"), "Int32Val": SimTypeInt(signed=True, label="Int32"), "Int64Val": SimTypeLongLong(signed=True, label="Int64"), "ByteVal": SimTypeChar(label="Byte"), "UInt16Val": SimTypeShort(signed=False, label="UInt16"), "UInt32Val": SimTypeInt(signed=False, label="UInt32"), "UInt64Val": SimTypeLongLong(signed=False, label="UInt64"), "SingleVal": SimTypeFloat(size=32), "DoubleVal": SimTypeFloat(size=64), "FileTimeVal": SimTypeLongLong(signed=False, label="UInt64"), "SysTimeVal": SimTypePointer(SimStruct({"wYear": SimTypeShort(signed=False, label="UInt16"), "wMonth": SimTypeShort(signed=False, label="UInt16"), "wDayOfWeek": SimTypeShort(signed=False, label="UInt16"), "wDay": SimTypeShort(signed=False, label="UInt16"), "wHour": SimTypeShort(signed=False, label="UInt16"), "wMinute": SimTypeShort(signed=False, label="UInt16"), "wSecond": SimTypeShort(signed=False, label="UInt16"), "wMilliseconds": SimTypeShort(signed=False, label="UInt16")}, name="SYSTEMTIME", pack=False, align=None), offset=0), "GuidVal": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "StringVal": SimTypePointer(SimTypeChar(label="Char"), offset=0), "AnsiStringVal": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BinaryVal": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SidVal": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "SizeTVal": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "BooleanArr": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), "SByteArr": SimTypePointer(SimTypeChar(label="SByte"), offset=0), "Int16Arr": SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), "Int32Arr": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), "Int64Arr": SimTypePointer(SimTypeLongLong(signed=True, label="Int64"), offset=0), "ByteArr": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "UInt16Arr": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "UInt32Arr": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "UInt64Arr": SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0), "SingleArr": SimTypePointer(SimTypeFloat(size=32), offset=0), "DoubleArr": SimTypePointer(SimTypeFloat(size=64), offset=0), "FileTimeArr": SimTypePointer(SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), offset=0), "SysTimeArr": SimTypePointer(SimStruct({"wYear": SimTypeShort(signed=False, label="UInt16"), "wMonth": SimTypeShort(signed=False, label="UInt16"), "wDayOfWeek": SimTypeShort(signed=False, label="UInt16"), "wDay": SimTypeShort(signed=False, label="UInt16"), "wHour": SimTypeShort(signed=False, label="UInt16"), "wMinute": SimTypeShort(signed=False, label="UInt16"), "wSecond": SimTypeShort(signed=False, label="UInt16"), "wMilliseconds": SimTypeShort(signed=False, label="UInt16")}, name="SYSTEMTIME", pack=False, align=None), offset=0), "GuidArr": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "StringArr": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), "AnsiStringArr": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), "SidArr": SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), "SizeTArr": SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0), "EvtHandleVal": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "XmlVal": SimTypePointer(SimTypeChar(label="Char"), offset=0), "XmlValArr": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)}, name="<anon>", label="None"), "Count": SimTypeInt(signed=False, label="UInt32"), "Type": SimTypeInt(signed=False, label="UInt32")}, name="EVT_VARIANT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ChannelConfig", "PropertyId", "Flags", "PropertyValue"]),
        # 
        'EvtGetChannelConfigProperty': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="EVT_CHANNEL_CONFIG_PROPERTY_ID"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Anonymous": SimUnion({"BooleanVal": SimTypeInt(signed=True, label="Int32"), "SByteVal": SimTypeChar(label="SByte"), "Int16Val": SimTypeShort(signed=True, label="Int16"), "Int32Val": SimTypeInt(signed=True, label="Int32"), "Int64Val": SimTypeLongLong(signed=True, label="Int64"), "ByteVal": SimTypeChar(label="Byte"), "UInt16Val": SimTypeShort(signed=False, label="UInt16"), "UInt32Val": SimTypeInt(signed=False, label="UInt32"), "UInt64Val": SimTypeLongLong(signed=False, label="UInt64"), "SingleVal": SimTypeFloat(size=32), "DoubleVal": SimTypeFloat(size=64), "FileTimeVal": SimTypeLongLong(signed=False, label="UInt64"), "SysTimeVal": SimTypePointer(SimStruct({"wYear": SimTypeShort(signed=False, label="UInt16"), "wMonth": SimTypeShort(signed=False, label="UInt16"), "wDayOfWeek": SimTypeShort(signed=False, label="UInt16"), "wDay": SimTypeShort(signed=False, label="UInt16"), "wHour": SimTypeShort(signed=False, label="UInt16"), "wMinute": SimTypeShort(signed=False, label="UInt16"), "wSecond": SimTypeShort(signed=False, label="UInt16"), "wMilliseconds": SimTypeShort(signed=False, label="UInt16")}, name="SYSTEMTIME", pack=False, align=None), offset=0), "GuidVal": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "StringVal": SimTypePointer(SimTypeChar(label="Char"), offset=0), "AnsiStringVal": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BinaryVal": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SidVal": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "SizeTVal": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "BooleanArr": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), "SByteArr": SimTypePointer(SimTypeChar(label="SByte"), offset=0), "Int16Arr": SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), "Int32Arr": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), "Int64Arr": SimTypePointer(SimTypeLongLong(signed=True, label="Int64"), offset=0), "ByteArr": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "UInt16Arr": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "UInt32Arr": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "UInt64Arr": SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0), "SingleArr": SimTypePointer(SimTypeFloat(size=32), offset=0), "DoubleArr": SimTypePointer(SimTypeFloat(size=64), offset=0), "FileTimeArr": SimTypePointer(SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), offset=0), "SysTimeArr": SimTypePointer(SimStruct({"wYear": SimTypeShort(signed=False, label="UInt16"), "wMonth": SimTypeShort(signed=False, label="UInt16"), "wDayOfWeek": SimTypeShort(signed=False, label="UInt16"), "wDay": SimTypeShort(signed=False, label="UInt16"), "wHour": SimTypeShort(signed=False, label="UInt16"), "wMinute": SimTypeShort(signed=False, label="UInt16"), "wSecond": SimTypeShort(signed=False, label="UInt16"), "wMilliseconds": SimTypeShort(signed=False, label="UInt16")}, name="SYSTEMTIME", pack=False, align=None), offset=0), "GuidArr": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "StringArr": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), "AnsiStringArr": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), "SidArr": SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), "SizeTArr": SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0), "EvtHandleVal": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "XmlVal": SimTypePointer(SimTypeChar(label="Char"), offset=0), "XmlValArr": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)}, name="<anon>", label="None"), "Count": SimTypeInt(signed=False, label="UInt32"), "Type": SimTypeInt(signed=False, label="UInt32")}, name="EVT_VARIANT", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ChannelConfig", "PropertyId", "Flags", "PropertyValueBufferSize", "PropertyValueBuffer", "PropertyValueBufferUsed"]),
        # 
        'EvtOpenPublisherEnum': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["Session", "Flags"]),
        # 
        'EvtNextPublisherId': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["PublisherEnum", "PublisherIdBufferSize", "PublisherIdBuffer", "PublisherIdBufferUsed"]),
        # 
        'EvtOpenPublisherMetadata': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["Session", "PublisherId", "LogFilePath", "Locale", "Flags"]),
        # 
        'EvtGetPublisherMetadataProperty': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="EVT_PUBLISHER_METADATA_PROPERTY_ID"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Anonymous": SimUnion({"BooleanVal": SimTypeInt(signed=True, label="Int32"), "SByteVal": SimTypeChar(label="SByte"), "Int16Val": SimTypeShort(signed=True, label="Int16"), "Int32Val": SimTypeInt(signed=True, label="Int32"), "Int64Val": SimTypeLongLong(signed=True, label="Int64"), "ByteVal": SimTypeChar(label="Byte"), "UInt16Val": SimTypeShort(signed=False, label="UInt16"), "UInt32Val": SimTypeInt(signed=False, label="UInt32"), "UInt64Val": SimTypeLongLong(signed=False, label="UInt64"), "SingleVal": SimTypeFloat(size=32), "DoubleVal": SimTypeFloat(size=64), "FileTimeVal": SimTypeLongLong(signed=False, label="UInt64"), "SysTimeVal": SimTypePointer(SimStruct({"wYear": SimTypeShort(signed=False, label="UInt16"), "wMonth": SimTypeShort(signed=False, label="UInt16"), "wDayOfWeek": SimTypeShort(signed=False, label="UInt16"), "wDay": SimTypeShort(signed=False, label="UInt16"), "wHour": SimTypeShort(signed=False, label="UInt16"), "wMinute": SimTypeShort(signed=False, label="UInt16"), "wSecond": SimTypeShort(signed=False, label="UInt16"), "wMilliseconds": SimTypeShort(signed=False, label="UInt16")}, name="SYSTEMTIME", pack=False, align=None), offset=0), "GuidVal": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "StringVal": SimTypePointer(SimTypeChar(label="Char"), offset=0), "AnsiStringVal": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BinaryVal": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SidVal": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "SizeTVal": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "BooleanArr": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), "SByteArr": SimTypePointer(SimTypeChar(label="SByte"), offset=0), "Int16Arr": SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), "Int32Arr": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), "Int64Arr": SimTypePointer(SimTypeLongLong(signed=True, label="Int64"), offset=0), "ByteArr": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "UInt16Arr": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "UInt32Arr": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "UInt64Arr": SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0), "SingleArr": SimTypePointer(SimTypeFloat(size=32), offset=0), "DoubleArr": SimTypePointer(SimTypeFloat(size=64), offset=0), "FileTimeArr": SimTypePointer(SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), offset=0), "SysTimeArr": SimTypePointer(SimStruct({"wYear": SimTypeShort(signed=False, label="UInt16"), "wMonth": SimTypeShort(signed=False, label="UInt16"), "wDayOfWeek": SimTypeShort(signed=False, label="UInt16"), "wDay": SimTypeShort(signed=False, label="UInt16"), "wHour": SimTypeShort(signed=False, label="UInt16"), "wMinute": SimTypeShort(signed=False, label="UInt16"), "wSecond": SimTypeShort(signed=False, label="UInt16"), "wMilliseconds": SimTypeShort(signed=False, label="UInt16")}, name="SYSTEMTIME", pack=False, align=None), offset=0), "GuidArr": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "StringArr": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), "AnsiStringArr": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), "SidArr": SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), "SizeTArr": SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0), "EvtHandleVal": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "XmlVal": SimTypePointer(SimTypeChar(label="Char"), offset=0), "XmlValArr": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)}, name="<anon>", label="None"), "Count": SimTypeInt(signed=False, label="UInt32"), "Type": SimTypeInt(signed=False, label="UInt32")}, name="EVT_VARIANT", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["PublisherMetadata", "PropertyId", "Flags", "PublisherMetadataPropertyBufferSize", "PublisherMetadataPropertyBuffer", "PublisherMetadataPropertyBufferUsed"]),
        # 
        'EvtOpenEventMetadataEnum': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["PublisherMetadata", "Flags"]),
        # 
        'EvtNextEventMetadata': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["EventMetadataEnum", "Flags"]),
        # 
        'EvtGetEventMetadataProperty': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="EVT_EVENT_METADATA_PROPERTY_ID"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Anonymous": SimUnion({"BooleanVal": SimTypeInt(signed=True, label="Int32"), "SByteVal": SimTypeChar(label="SByte"), "Int16Val": SimTypeShort(signed=True, label="Int16"), "Int32Val": SimTypeInt(signed=True, label="Int32"), "Int64Val": SimTypeLongLong(signed=True, label="Int64"), "ByteVal": SimTypeChar(label="Byte"), "UInt16Val": SimTypeShort(signed=False, label="UInt16"), "UInt32Val": SimTypeInt(signed=False, label="UInt32"), "UInt64Val": SimTypeLongLong(signed=False, label="UInt64"), "SingleVal": SimTypeFloat(size=32), "DoubleVal": SimTypeFloat(size=64), "FileTimeVal": SimTypeLongLong(signed=False, label="UInt64"), "SysTimeVal": SimTypePointer(SimStruct({"wYear": SimTypeShort(signed=False, label="UInt16"), "wMonth": SimTypeShort(signed=False, label="UInt16"), "wDayOfWeek": SimTypeShort(signed=False, label="UInt16"), "wDay": SimTypeShort(signed=False, label="UInt16"), "wHour": SimTypeShort(signed=False, label="UInt16"), "wMinute": SimTypeShort(signed=False, label="UInt16"), "wSecond": SimTypeShort(signed=False, label="UInt16"), "wMilliseconds": SimTypeShort(signed=False, label="UInt16")}, name="SYSTEMTIME", pack=False, align=None), offset=0), "GuidVal": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "StringVal": SimTypePointer(SimTypeChar(label="Char"), offset=0), "AnsiStringVal": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BinaryVal": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SidVal": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "SizeTVal": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "BooleanArr": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), "SByteArr": SimTypePointer(SimTypeChar(label="SByte"), offset=0), "Int16Arr": SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), "Int32Arr": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), "Int64Arr": SimTypePointer(SimTypeLongLong(signed=True, label="Int64"), offset=0), "ByteArr": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "UInt16Arr": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "UInt32Arr": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "UInt64Arr": SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0), "SingleArr": SimTypePointer(SimTypeFloat(size=32), offset=0), "DoubleArr": SimTypePointer(SimTypeFloat(size=64), offset=0), "FileTimeArr": SimTypePointer(SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), offset=0), "SysTimeArr": SimTypePointer(SimStruct({"wYear": SimTypeShort(signed=False, label="UInt16"), "wMonth": SimTypeShort(signed=False, label="UInt16"), "wDayOfWeek": SimTypeShort(signed=False, label="UInt16"), "wDay": SimTypeShort(signed=False, label="UInt16"), "wHour": SimTypeShort(signed=False, label="UInt16"), "wMinute": SimTypeShort(signed=False, label="UInt16"), "wSecond": SimTypeShort(signed=False, label="UInt16"), "wMilliseconds": SimTypeShort(signed=False, label="UInt16")}, name="SYSTEMTIME", pack=False, align=None), offset=0), "GuidArr": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "StringArr": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), "AnsiStringArr": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), "SidArr": SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), "SizeTArr": SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0), "EvtHandleVal": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "XmlVal": SimTypePointer(SimTypeChar(label="Char"), offset=0), "XmlValArr": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)}, name="<anon>", label="None"), "Count": SimTypeInt(signed=False, label="UInt32"), "Type": SimTypeInt(signed=False, label="UInt32")}, name="EVT_VARIANT", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["EventMetadata", "PropertyId", "Flags", "EventMetadataPropertyBufferSize", "EventMetadataPropertyBuffer", "EventMetadataPropertyBufferUsed"]),
        # 
        'EvtGetObjectArraySize': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ObjectArray", "ObjectArraySize"]),
        # 
        'EvtGetObjectArrayProperty': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Anonymous": SimUnion({"BooleanVal": SimTypeInt(signed=True, label="Int32"), "SByteVal": SimTypeChar(label="SByte"), "Int16Val": SimTypeShort(signed=True, label="Int16"), "Int32Val": SimTypeInt(signed=True, label="Int32"), "Int64Val": SimTypeLongLong(signed=True, label="Int64"), "ByteVal": SimTypeChar(label="Byte"), "UInt16Val": SimTypeShort(signed=False, label="UInt16"), "UInt32Val": SimTypeInt(signed=False, label="UInt32"), "UInt64Val": SimTypeLongLong(signed=False, label="UInt64"), "SingleVal": SimTypeFloat(size=32), "DoubleVal": SimTypeFloat(size=64), "FileTimeVal": SimTypeLongLong(signed=False, label="UInt64"), "SysTimeVal": SimTypePointer(SimStruct({"wYear": SimTypeShort(signed=False, label="UInt16"), "wMonth": SimTypeShort(signed=False, label="UInt16"), "wDayOfWeek": SimTypeShort(signed=False, label="UInt16"), "wDay": SimTypeShort(signed=False, label="UInt16"), "wHour": SimTypeShort(signed=False, label="UInt16"), "wMinute": SimTypeShort(signed=False, label="UInt16"), "wSecond": SimTypeShort(signed=False, label="UInt16"), "wMilliseconds": SimTypeShort(signed=False, label="UInt16")}, name="SYSTEMTIME", pack=False, align=None), offset=0), "GuidVal": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "StringVal": SimTypePointer(SimTypeChar(label="Char"), offset=0), "AnsiStringVal": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BinaryVal": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SidVal": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "SizeTVal": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "BooleanArr": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), "SByteArr": SimTypePointer(SimTypeChar(label="SByte"), offset=0), "Int16Arr": SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), "Int32Arr": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), "Int64Arr": SimTypePointer(SimTypeLongLong(signed=True, label="Int64"), offset=0), "ByteArr": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "UInt16Arr": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "UInt32Arr": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "UInt64Arr": SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0), "SingleArr": SimTypePointer(SimTypeFloat(size=32), offset=0), "DoubleArr": SimTypePointer(SimTypeFloat(size=64), offset=0), "FileTimeArr": SimTypePointer(SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), offset=0), "SysTimeArr": SimTypePointer(SimStruct({"wYear": SimTypeShort(signed=False, label="UInt16"), "wMonth": SimTypeShort(signed=False, label="UInt16"), "wDayOfWeek": SimTypeShort(signed=False, label="UInt16"), "wDay": SimTypeShort(signed=False, label="UInt16"), "wHour": SimTypeShort(signed=False, label="UInt16"), "wMinute": SimTypeShort(signed=False, label="UInt16"), "wSecond": SimTypeShort(signed=False, label="UInt16"), "wMilliseconds": SimTypeShort(signed=False, label="UInt16")}, name="SYSTEMTIME", pack=False, align=None), offset=0), "GuidArr": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "StringArr": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), "AnsiStringArr": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), "SidArr": SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), "SizeTArr": SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0), "EvtHandleVal": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "XmlVal": SimTypePointer(SimTypeChar(label="Char"), offset=0), "XmlValArr": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)}, name="<anon>", label="None"), "Count": SimTypeInt(signed=False, label="UInt32"), "Type": SimTypeInt(signed=False, label="UInt32")}, name="EVT_VARIANT", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ObjectArray", "PropertyId", "ArrayIndex", "Flags", "PropertyValueBufferSize", "PropertyValueBuffer", "PropertyValueBufferUsed"]),
        # 
        'EvtGetQueryInfo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="EVT_QUERY_PROPERTY_ID"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Anonymous": SimUnion({"BooleanVal": SimTypeInt(signed=True, label="Int32"), "SByteVal": SimTypeChar(label="SByte"), "Int16Val": SimTypeShort(signed=True, label="Int16"), "Int32Val": SimTypeInt(signed=True, label="Int32"), "Int64Val": SimTypeLongLong(signed=True, label="Int64"), "ByteVal": SimTypeChar(label="Byte"), "UInt16Val": SimTypeShort(signed=False, label="UInt16"), "UInt32Val": SimTypeInt(signed=False, label="UInt32"), "UInt64Val": SimTypeLongLong(signed=False, label="UInt64"), "SingleVal": SimTypeFloat(size=32), "DoubleVal": SimTypeFloat(size=64), "FileTimeVal": SimTypeLongLong(signed=False, label="UInt64"), "SysTimeVal": SimTypePointer(SimStruct({"wYear": SimTypeShort(signed=False, label="UInt16"), "wMonth": SimTypeShort(signed=False, label="UInt16"), "wDayOfWeek": SimTypeShort(signed=False, label="UInt16"), "wDay": SimTypeShort(signed=False, label="UInt16"), "wHour": SimTypeShort(signed=False, label="UInt16"), "wMinute": SimTypeShort(signed=False, label="UInt16"), "wSecond": SimTypeShort(signed=False, label="UInt16"), "wMilliseconds": SimTypeShort(signed=False, label="UInt16")}, name="SYSTEMTIME", pack=False, align=None), offset=0), "GuidVal": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "StringVal": SimTypePointer(SimTypeChar(label="Char"), offset=0), "AnsiStringVal": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BinaryVal": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SidVal": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "SizeTVal": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "BooleanArr": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), "SByteArr": SimTypePointer(SimTypeChar(label="SByte"), offset=0), "Int16Arr": SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), "Int32Arr": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), "Int64Arr": SimTypePointer(SimTypeLongLong(signed=True, label="Int64"), offset=0), "ByteArr": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "UInt16Arr": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "UInt32Arr": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "UInt64Arr": SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0), "SingleArr": SimTypePointer(SimTypeFloat(size=32), offset=0), "DoubleArr": SimTypePointer(SimTypeFloat(size=64), offset=0), "FileTimeArr": SimTypePointer(SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), offset=0), "SysTimeArr": SimTypePointer(SimStruct({"wYear": SimTypeShort(signed=False, label="UInt16"), "wMonth": SimTypeShort(signed=False, label="UInt16"), "wDayOfWeek": SimTypeShort(signed=False, label="UInt16"), "wDay": SimTypeShort(signed=False, label="UInt16"), "wHour": SimTypeShort(signed=False, label="UInt16"), "wMinute": SimTypeShort(signed=False, label="UInt16"), "wSecond": SimTypeShort(signed=False, label="UInt16"), "wMilliseconds": SimTypeShort(signed=False, label="UInt16")}, name="SYSTEMTIME", pack=False, align=None), offset=0), "GuidArr": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "StringArr": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), "AnsiStringArr": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), "SidArr": SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), "SizeTArr": SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0), "EvtHandleVal": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "XmlVal": SimTypePointer(SimTypeChar(label="Char"), offset=0), "XmlValArr": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)}, name="<anon>", label="None"), "Count": SimTypeInt(signed=False, label="UInt32"), "Type": SimTypeInt(signed=False, label="UInt32")}, name="EVT_VARIANT", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["QueryOrSubscription", "PropertyId", "PropertyValueBufferSize", "PropertyValueBuffer", "PropertyValueBufferUsed"]),
        # 
        'EvtCreateBookmark': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["BookmarkXml"]),
        # 
        'EvtUpdateBookmark': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Bookmark", "Event"]),
        # 
        'EvtGetEventInfo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="EVT_EVENT_PROPERTY_ID"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Anonymous": SimUnion({"BooleanVal": SimTypeInt(signed=True, label="Int32"), "SByteVal": SimTypeChar(label="SByte"), "Int16Val": SimTypeShort(signed=True, label="Int16"), "Int32Val": SimTypeInt(signed=True, label="Int32"), "Int64Val": SimTypeLongLong(signed=True, label="Int64"), "ByteVal": SimTypeChar(label="Byte"), "UInt16Val": SimTypeShort(signed=False, label="UInt16"), "UInt32Val": SimTypeInt(signed=False, label="UInt32"), "UInt64Val": SimTypeLongLong(signed=False, label="UInt64"), "SingleVal": SimTypeFloat(size=32), "DoubleVal": SimTypeFloat(size=64), "FileTimeVal": SimTypeLongLong(signed=False, label="UInt64"), "SysTimeVal": SimTypePointer(SimStruct({"wYear": SimTypeShort(signed=False, label="UInt16"), "wMonth": SimTypeShort(signed=False, label="UInt16"), "wDayOfWeek": SimTypeShort(signed=False, label="UInt16"), "wDay": SimTypeShort(signed=False, label="UInt16"), "wHour": SimTypeShort(signed=False, label="UInt16"), "wMinute": SimTypeShort(signed=False, label="UInt16"), "wSecond": SimTypeShort(signed=False, label="UInt16"), "wMilliseconds": SimTypeShort(signed=False, label="UInt16")}, name="SYSTEMTIME", pack=False, align=None), offset=0), "GuidVal": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "StringVal": SimTypePointer(SimTypeChar(label="Char"), offset=0), "AnsiStringVal": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BinaryVal": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SidVal": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "SizeTVal": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "BooleanArr": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), "SByteArr": SimTypePointer(SimTypeChar(label="SByte"), offset=0), "Int16Arr": SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), "Int32Arr": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), "Int64Arr": SimTypePointer(SimTypeLongLong(signed=True, label="Int64"), offset=0), "ByteArr": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "UInt16Arr": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "UInt32Arr": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "UInt64Arr": SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0), "SingleArr": SimTypePointer(SimTypeFloat(size=32), offset=0), "DoubleArr": SimTypePointer(SimTypeFloat(size=64), offset=0), "FileTimeArr": SimTypePointer(SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), offset=0), "SysTimeArr": SimTypePointer(SimStruct({"wYear": SimTypeShort(signed=False, label="UInt16"), "wMonth": SimTypeShort(signed=False, label="UInt16"), "wDayOfWeek": SimTypeShort(signed=False, label="UInt16"), "wDay": SimTypeShort(signed=False, label="UInt16"), "wHour": SimTypeShort(signed=False, label="UInt16"), "wMinute": SimTypeShort(signed=False, label="UInt16"), "wSecond": SimTypeShort(signed=False, label="UInt16"), "wMilliseconds": SimTypeShort(signed=False, label="UInt16")}, name="SYSTEMTIME", pack=False, align=None), offset=0), "GuidArr": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "StringArr": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), "AnsiStringArr": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), "SidArr": SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), "SizeTArr": SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0), "EvtHandleVal": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "XmlVal": SimTypePointer(SimTypeChar(label="Char"), offset=0), "XmlValArr": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)}, name="<anon>", label="None"), "Count": SimTypeInt(signed=False, label="UInt32"), "Type": SimTypeInt(signed=False, label="UInt32")}, name="EVT_VARIANT", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Event", "PropertyId", "PropertyValueBufferSize", "PropertyValueBuffer", "PropertyValueBufferUsed"]),
    }

lib.set_prototypes(prototypes)
