# pylint:disable=line-too-long
import logging

from ...sim_type import SimTypeFunction,     SimTypeShort, SimTypeInt, SimTypeLong, SimTypeLongLong, SimTypeDouble, SimTypeFloat,     SimTypePointer,     SimTypeChar,     SimStruct,     SimTypeFixedSizeArray,     SimTypeBottom,     SimUnion,     SimTypeBool
from ...calling_conventions import SimCCStdcall, SimCCMicrosoftAMD64
from .. import SIM_PROCEDURES as P
from . import SimLibrary


_l = logging.getLogger(name=__name__)


lib = SimLibrary()
lib.set_default_cc('X86', SimCCStdcall)
lib.set_default_cc('AMD64', SimCCMicrosoftAMD64)
lib.set_library_names("wintrust.dll")
prototypes = \
    {
        # 
        'FindCertsByIssuer': SimTypeFunction([SimTypePointer(SimStruct({"cCerts": SimTypeInt(signed=False, label="UInt32"), "certs": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0), "keyLocatorInfo": SimStruct({"pwszContainerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszProvName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwProvType": SimTypeInt(signed=False, label="UInt32"), "dwFlags": SimTypeInt(signed=False, label="CRYPT_KEY_FLAGS"), "cProvParam": SimTypeInt(signed=False, label="UInt32"), "rgProvParam": SimTypePointer(SimStruct({"dwParam": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbData": SimTypeInt(signed=False, label="UInt32"), "dwFlags": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_KEY_PROV_PARAM", pack=False, align=None), offset=0), "dwKeySpec": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_KEY_PROV_INFO", pack=False, align=None)}, name="CERT_CHAIN", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pCertChains", "pcbCertChains", "pcCertChains", "pbEncodedIssuerName", "cbEncodedIssuerName", "pwszPurpose", "dwKeySpec"]),
        # 
        'CryptSIPGetSignedDataMsg': SimTypeFunction([SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pgSubjectType": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "hFile": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pwsFileName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwsDisplayName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwReserved1": SimTypeInt(signed=False, label="UInt32"), "dwIntVersion": SimTypeInt(signed=False, label="UInt32"), "hProv": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "DigestAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "dwEncodingType": SimTypeInt(signed=False, label="UInt32"), "dwReserved2": SimTypeInt(signed=False, label="UInt32"), "fdwCAPISettings": SimTypeInt(signed=False, label="UInt32"), "fdwSecuritySettings": SimTypeInt(signed=False, label="UInt32"), "dwIndex": SimTypeInt(signed=False, label="UInt32"), "dwUnionChoice": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"psFlat": SimTypePointer(SimTypeBottom(label="MS_ADDINFO_FLAT"), offset=0), "psCatMember": SimTypePointer(SimTypeBottom(label="MS_ADDINFO_CATALOGMEMBER"), offset=0), "psBlob": SimTypePointer(SimTypeBottom(label="MS_ADDINFO_BLOB"), offset=0)}, name="<anon>", label="None"), "pClientData": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="SIP_SUBJECTINFO", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="CERT_QUERY_ENCODING_TYPE"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pSubjectInfo", "pdwEncodingType", "dwIndex", "pcbSignedDataMsg", "pbSignedDataMsg"]),
        # 
        'CryptSIPPutSignedDataMsg': SimTypeFunction([SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pgSubjectType": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "hFile": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pwsFileName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwsDisplayName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwReserved1": SimTypeInt(signed=False, label="UInt32"), "dwIntVersion": SimTypeInt(signed=False, label="UInt32"), "hProv": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "DigestAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "dwEncodingType": SimTypeInt(signed=False, label="UInt32"), "dwReserved2": SimTypeInt(signed=False, label="UInt32"), "fdwCAPISettings": SimTypeInt(signed=False, label="UInt32"), "fdwSecuritySettings": SimTypeInt(signed=False, label="UInt32"), "dwIndex": SimTypeInt(signed=False, label="UInt32"), "dwUnionChoice": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"psFlat": SimTypePointer(SimTypeBottom(label="MS_ADDINFO_FLAT"), offset=0), "psCatMember": SimTypePointer(SimTypeBottom(label="MS_ADDINFO_CATALOGMEMBER"), offset=0), "psBlob": SimTypePointer(SimTypeBottom(label="MS_ADDINFO_BLOB"), offset=0)}, name="<anon>", label="None"), "pClientData": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="SIP_SUBJECTINFO", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="CERT_QUERY_ENCODING_TYPE"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pSubjectInfo", "dwEncodingType", "pdwIndex", "cbSignedDataMsg", "pbSignedDataMsg"]),
        # 
        'CryptSIPCreateIndirectData': SimTypeFunction([SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pgSubjectType": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "hFile": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pwsFileName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwsDisplayName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwReserved1": SimTypeInt(signed=False, label="UInt32"), "dwIntVersion": SimTypeInt(signed=False, label="UInt32"), "hProv": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "DigestAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "dwEncodingType": SimTypeInt(signed=False, label="UInt32"), "dwReserved2": SimTypeInt(signed=False, label="UInt32"), "fdwCAPISettings": SimTypeInt(signed=False, label="UInt32"), "fdwSecuritySettings": SimTypeInt(signed=False, label="UInt32"), "dwIndex": SimTypeInt(signed=False, label="UInt32"), "dwUnionChoice": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"psFlat": SimTypePointer(SimTypeBottom(label="MS_ADDINFO_FLAT"), offset=0), "psCatMember": SimTypePointer(SimTypeBottom(label="MS_ADDINFO_CATALOGMEMBER"), offset=0), "psBlob": SimTypePointer(SimTypeBottom(label="MS_ADDINFO_BLOB"), offset=0)}, name="<anon>", label="None"), "pClientData": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="SIP_SUBJECTINFO", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"Data": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ATTRIBUTE_TYPE_VALUE", pack=False, align=None), "DigestAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Digest": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="SIP_INDIRECT_DATA", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pSubjectInfo", "pcbIndirectData", "pIndirectData"]),
        # 
        'CryptSIPVerifyIndirectData': SimTypeFunction([SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pgSubjectType": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "hFile": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pwsFileName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwsDisplayName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwReserved1": SimTypeInt(signed=False, label="UInt32"), "dwIntVersion": SimTypeInt(signed=False, label="UInt32"), "hProv": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "DigestAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "dwEncodingType": SimTypeInt(signed=False, label="UInt32"), "dwReserved2": SimTypeInt(signed=False, label="UInt32"), "fdwCAPISettings": SimTypeInt(signed=False, label="UInt32"), "fdwSecuritySettings": SimTypeInt(signed=False, label="UInt32"), "dwIndex": SimTypeInt(signed=False, label="UInt32"), "dwUnionChoice": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"psFlat": SimTypePointer(SimTypeBottom(label="MS_ADDINFO_FLAT"), offset=0), "psCatMember": SimTypePointer(SimTypeBottom(label="MS_ADDINFO_CATALOGMEMBER"), offset=0), "psBlob": SimTypePointer(SimTypeBottom(label="MS_ADDINFO_BLOB"), offset=0)}, name="<anon>", label="None"), "pClientData": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="SIP_SUBJECTINFO", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Data": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ATTRIBUTE_TYPE_VALUE", pack=False, align=None), "DigestAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Digest": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="SIP_INDIRECT_DATA", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pSubjectInfo", "pIndirectData"]),
        # 
        'CryptSIPRemoveSignedDataMsg': SimTypeFunction([SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pgSubjectType": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "hFile": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pwsFileName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwsDisplayName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwReserved1": SimTypeInt(signed=False, label="UInt32"), "dwIntVersion": SimTypeInt(signed=False, label="UInt32"), "hProv": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "DigestAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "dwEncodingType": SimTypeInt(signed=False, label="UInt32"), "dwReserved2": SimTypeInt(signed=False, label="UInt32"), "fdwCAPISettings": SimTypeInt(signed=False, label="UInt32"), "fdwSecuritySettings": SimTypeInt(signed=False, label="UInt32"), "dwIndex": SimTypeInt(signed=False, label="UInt32"), "dwUnionChoice": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"psFlat": SimTypePointer(SimTypeBottom(label="MS_ADDINFO_FLAT"), offset=0), "psCatMember": SimTypePointer(SimTypeBottom(label="MS_ADDINFO_CATALOGMEMBER"), offset=0), "psBlob": SimTypePointer(SimTypeBottom(label="MS_ADDINFO_BLOB"), offset=0)}, name="<anon>", label="None"), "pClientData": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="SIP_SUBJECTINFO", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pSubjectInfo", "dwIndex"]),
        # 
        'CryptSIPGetCaps': SimTypeFunction([SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pgSubjectType": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "hFile": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pwsFileName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwsDisplayName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwReserved1": SimTypeInt(signed=False, label="UInt32"), "dwIntVersion": SimTypeInt(signed=False, label="UInt32"), "hProv": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "DigestAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "dwEncodingType": SimTypeInt(signed=False, label="UInt32"), "dwReserved2": SimTypeInt(signed=False, label="UInt32"), "fdwCAPISettings": SimTypeInt(signed=False, label="UInt32"), "fdwSecuritySettings": SimTypeInt(signed=False, label="UInt32"), "dwIndex": SimTypeInt(signed=False, label="UInt32"), "dwUnionChoice": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"psFlat": SimTypePointer(SimTypeBottom(label="MS_ADDINFO_FLAT"), offset=0), "psCatMember": SimTypePointer(SimTypeBottom(label="MS_ADDINFO_CATALOGMEMBER"), offset=0), "psBlob": SimTypePointer(SimTypeBottom(label="MS_ADDINFO_BLOB"), offset=0)}, name="<anon>", label="None"), "pClientData": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="SIP_SUBJECTINFO", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "dwVersion": SimTypeInt(signed=False, label="UInt32"), "isMultiSign": SimTypeInt(signed=True, label="Int32"), "Anonymous": SimUnion({"dwFlags": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SIP_CAP_SET_V3", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pSubjInfo", "pCaps"]),
        # 
        'CryptSIPGetSealedDigest': SimTypeFunction([SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pgSubjectType": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "hFile": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pwsFileName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwsDisplayName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwReserved1": SimTypeInt(signed=False, label="UInt32"), "dwIntVersion": SimTypeInt(signed=False, label="UInt32"), "hProv": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "DigestAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "dwEncodingType": SimTypeInt(signed=False, label="UInt32"), "dwReserved2": SimTypeInt(signed=False, label="UInt32"), "fdwCAPISettings": SimTypeInt(signed=False, label="UInt32"), "fdwSecuritySettings": SimTypeInt(signed=False, label="UInt32"), "dwIndex": SimTypeInt(signed=False, label="UInt32"), "dwUnionChoice": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"psFlat": SimTypePointer(SimTypeBottom(label="MS_ADDINFO_FLAT"), offset=0), "psCatMember": SimTypePointer(SimTypeBottom(label="MS_ADDINFO_CATALOGMEMBER"), offset=0), "psBlob": SimTypePointer(SimTypeBottom(label="MS_ADDINFO_BLOB"), offset=0)}, name="<anon>", label="None"), "pClientData": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="SIP_SUBJECTINFO", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pSubjectInfo", "pSig", "dwSig", "pbDigest", "pcbDigest"]),
        # 
        'CryptCATOpen': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="CRYPTCAT_OPEN_FLAGS"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="CRYPTCAT_VERSION"), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["pwszFileName", "fdwOpenFlags", "hProv", "dwPublicVersion", "dwEncodingType"]),
        # 
        'CryptCATClose': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hCatalog"]),
        # 
        'CryptCATStoreFromHandle': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "dwPublicVersion": SimTypeInt(signed=False, label="UInt32"), "pwszP7File": SimTypePointer(SimTypeChar(label="Char"), offset=0), "hProv": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwEncodingType": SimTypeInt(signed=False, label="UInt32"), "fdwStoreFlags": SimTypeInt(signed=False, label="CRYPTCAT_OPEN_FLAGS"), "hReserved": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hAttrs": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hCryptMsg": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "hSorted": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="CRYPTCATSTORE", pack=False, align=None), offset=0), arg_names=["hCatalog"]),
        # 
        'CryptCATHandleFromStore': SimTypeFunction([SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "dwPublicVersion": SimTypeInt(signed=False, label="UInt32"), "pwszP7File": SimTypePointer(SimTypeChar(label="Char"), offset=0), "hProv": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwEncodingType": SimTypeInt(signed=False, label="UInt32"), "fdwStoreFlags": SimTypeInt(signed=False, label="CRYPTCAT_OPEN_FLAGS"), "hReserved": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hAttrs": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hCryptMsg": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "hSorted": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="CRYPTCATSTORE", pack=False, align=None), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["pCatStore"]),
        # 
        'CryptCATPersistStore': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hCatalog"]),
        # 
        'CryptCATGetCatAttrInfo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "pwszReferenceTag": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwAttrTypeAndAction": SimTypeInt(signed=False, label="UInt32"), "cbValue": SimTypeInt(signed=False, label="UInt32"), "pbValue": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwReserved": SimTypeInt(signed=False, label="UInt32")}, name="CRYPTCATATTRIBUTE", pack=False, align=None), offset=0), arg_names=["hCatalog", "pwszReferenceTag"]),
        # 
        'CryptCATPutCatAttrInfo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "pwszReferenceTag": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwAttrTypeAndAction": SimTypeInt(signed=False, label="UInt32"), "cbValue": SimTypeInt(signed=False, label="UInt32"), "pbValue": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwReserved": SimTypeInt(signed=False, label="UInt32")}, name="CRYPTCATATTRIBUTE", pack=False, align=None), offset=0), arg_names=["hCatalog", "pwszReferenceTag", "dwAttrTypeAndAction", "cbData", "pbData"]),
        # 
        'CryptCATEnumerateCatAttr': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "pwszReferenceTag": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwAttrTypeAndAction": SimTypeInt(signed=False, label="UInt32"), "cbValue": SimTypeInt(signed=False, label="UInt32"), "pbValue": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwReserved": SimTypeInt(signed=False, label="UInt32")}, name="CRYPTCATATTRIBUTE", pack=False, align=None), offset=0)], SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "pwszReferenceTag": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwAttrTypeAndAction": SimTypeInt(signed=False, label="UInt32"), "cbValue": SimTypeInt(signed=False, label="UInt32"), "pbValue": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwReserved": SimTypeInt(signed=False, label="UInt32")}, name="CRYPTCATATTRIBUTE", pack=False, align=None), offset=0), arg_names=["hCatalog", "pPrevAttr"]),
        # 
        'CryptCATGetMemberInfo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "pwszReferenceTag": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszFileName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "gSubjectType": SimTypeBottom(label="Guid"), "fdwMemberFlags": SimTypeInt(signed=False, label="UInt32"), "pIndirectData": SimTypePointer(SimStruct({"Data": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ATTRIBUTE_TYPE_VALUE", pack=False, align=None), "DigestAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Digest": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="SIP_INDIRECT_DATA", pack=False, align=None), offset=0), "dwCertVersion": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeInt(signed=False, label="UInt32"), "hReserved": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "sEncodedIndirectData": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "sEncodedMemberInfo": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPTCATMEMBER", pack=False, align=None), offset=0), arg_names=["hCatalog", "pwszReferenceTag"]),
        # 
        'CryptCATAllocSortedMemberInfo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "pwszReferenceTag": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszFileName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "gSubjectType": SimTypeBottom(label="Guid"), "fdwMemberFlags": SimTypeInt(signed=False, label="UInt32"), "pIndirectData": SimTypePointer(SimStruct({"Data": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ATTRIBUTE_TYPE_VALUE", pack=False, align=None), "DigestAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Digest": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="SIP_INDIRECT_DATA", pack=False, align=None), offset=0), "dwCertVersion": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeInt(signed=False, label="UInt32"), "hReserved": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "sEncodedIndirectData": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "sEncodedMemberInfo": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPTCATMEMBER", pack=False, align=None), offset=0), arg_names=["hCatalog", "pwszReferenceTag"]),
        # 
        'CryptCATFreeSortedMemberInfo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "pwszReferenceTag": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszFileName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "gSubjectType": SimTypeBottom(label="Guid"), "fdwMemberFlags": SimTypeInt(signed=False, label="UInt32"), "pIndirectData": SimTypePointer(SimStruct({"Data": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ATTRIBUTE_TYPE_VALUE", pack=False, align=None), "DigestAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Digest": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="SIP_INDIRECT_DATA", pack=False, align=None), offset=0), "dwCertVersion": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeInt(signed=False, label="UInt32"), "hReserved": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "sEncodedIndirectData": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "sEncodedMemberInfo": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPTCATMEMBER", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["hCatalog", "pCatMember"]),
        # 
        'CryptCATGetAttrInfo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "pwszReferenceTag": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszFileName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "gSubjectType": SimTypeBottom(label="Guid"), "fdwMemberFlags": SimTypeInt(signed=False, label="UInt32"), "pIndirectData": SimTypePointer(SimStruct({"Data": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ATTRIBUTE_TYPE_VALUE", pack=False, align=None), "DigestAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Digest": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="SIP_INDIRECT_DATA", pack=False, align=None), offset=0), "dwCertVersion": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeInt(signed=False, label="UInt32"), "hReserved": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "sEncodedIndirectData": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "sEncodedMemberInfo": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPTCATMEMBER", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "pwszReferenceTag": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwAttrTypeAndAction": SimTypeInt(signed=False, label="UInt32"), "cbValue": SimTypeInt(signed=False, label="UInt32"), "pbValue": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwReserved": SimTypeInt(signed=False, label="UInt32")}, name="CRYPTCATATTRIBUTE", pack=False, align=None), offset=0), arg_names=["hCatalog", "pCatMember", "pwszReferenceTag"]),
        # 
        'CryptCATPutMemberInfo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "pwszReferenceTag": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszFileName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "gSubjectType": SimTypeBottom(label="Guid"), "fdwMemberFlags": SimTypeInt(signed=False, label="UInt32"), "pIndirectData": SimTypePointer(SimStruct({"Data": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ATTRIBUTE_TYPE_VALUE", pack=False, align=None), "DigestAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Digest": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="SIP_INDIRECT_DATA", pack=False, align=None), offset=0), "dwCertVersion": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeInt(signed=False, label="UInt32"), "hReserved": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "sEncodedIndirectData": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "sEncodedMemberInfo": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPTCATMEMBER", pack=False, align=None), offset=0), arg_names=["hCatalog", "pwszFileName", "pwszReferenceTag", "pgSubjectType", "dwCertVersion", "cbSIPIndirectData", "pbSIPIndirectData"]),
        # 
        'CryptCATPutAttrInfo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "pwszReferenceTag": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszFileName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "gSubjectType": SimTypeBottom(label="Guid"), "fdwMemberFlags": SimTypeInt(signed=False, label="UInt32"), "pIndirectData": SimTypePointer(SimStruct({"Data": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ATTRIBUTE_TYPE_VALUE", pack=False, align=None), "DigestAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Digest": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="SIP_INDIRECT_DATA", pack=False, align=None), offset=0), "dwCertVersion": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeInt(signed=False, label="UInt32"), "hReserved": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "sEncodedIndirectData": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "sEncodedMemberInfo": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPTCATMEMBER", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "pwszReferenceTag": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwAttrTypeAndAction": SimTypeInt(signed=False, label="UInt32"), "cbValue": SimTypeInt(signed=False, label="UInt32"), "pbValue": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwReserved": SimTypeInt(signed=False, label="UInt32")}, name="CRYPTCATATTRIBUTE", pack=False, align=None), offset=0), arg_names=["hCatalog", "pCatMember", "pwszReferenceTag", "dwAttrTypeAndAction", "cbData", "pbData"]),
        # 
        'CryptCATEnumerateMember': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "pwszReferenceTag": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszFileName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "gSubjectType": SimTypeBottom(label="Guid"), "fdwMemberFlags": SimTypeInt(signed=False, label="UInt32"), "pIndirectData": SimTypePointer(SimStruct({"Data": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ATTRIBUTE_TYPE_VALUE", pack=False, align=None), "DigestAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Digest": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="SIP_INDIRECT_DATA", pack=False, align=None), offset=0), "dwCertVersion": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeInt(signed=False, label="UInt32"), "hReserved": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "sEncodedIndirectData": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "sEncodedMemberInfo": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPTCATMEMBER", pack=False, align=None), offset=0)], SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "pwszReferenceTag": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszFileName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "gSubjectType": SimTypeBottom(label="Guid"), "fdwMemberFlags": SimTypeInt(signed=False, label="UInt32"), "pIndirectData": SimTypePointer(SimStruct({"Data": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ATTRIBUTE_TYPE_VALUE", pack=False, align=None), "DigestAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Digest": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="SIP_INDIRECT_DATA", pack=False, align=None), offset=0), "dwCertVersion": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeInt(signed=False, label="UInt32"), "hReserved": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "sEncodedIndirectData": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "sEncodedMemberInfo": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPTCATMEMBER", pack=False, align=None), offset=0), arg_names=["hCatalog", "pPrevMember"]),
        # 
        'CryptCATEnumerateAttr': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "pwszReferenceTag": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszFileName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "gSubjectType": SimTypeBottom(label="Guid"), "fdwMemberFlags": SimTypeInt(signed=False, label="UInt32"), "pIndirectData": SimTypePointer(SimStruct({"Data": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ATTRIBUTE_TYPE_VALUE", pack=False, align=None), "DigestAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Digest": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="SIP_INDIRECT_DATA", pack=False, align=None), offset=0), "dwCertVersion": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeInt(signed=False, label="UInt32"), "hReserved": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "sEncodedIndirectData": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "sEncodedMemberInfo": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPTCATMEMBER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "pwszReferenceTag": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwAttrTypeAndAction": SimTypeInt(signed=False, label="UInt32"), "cbValue": SimTypeInt(signed=False, label="UInt32"), "pbValue": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwReserved": SimTypeInt(signed=False, label="UInt32")}, name="CRYPTCATATTRIBUTE", pack=False, align=None), offset=0)], SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "pwszReferenceTag": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwAttrTypeAndAction": SimTypeInt(signed=False, label="UInt32"), "cbValue": SimTypeInt(signed=False, label="UInt32"), "pbValue": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwReserved": SimTypeInt(signed=False, label="UInt32")}, name="CRYPTCATATTRIBUTE", pack=False, align=None), offset=0), arg_names=["hCatalog", "pCatMember", "pPrevAttr"]),
        # 
        'CryptCATCDFOpen': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeBottom(label="Void"), arg_names=["dwErrorArea", "dwLocalError", "pwszLine"]), offset=0)], SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "hFile": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "dwCurFilePos": SimTypeInt(signed=False, label="UInt32"), "dwLastMemberOffset": SimTypeInt(signed=False, label="UInt32"), "fEOF": SimTypeInt(signed=True, label="Int32"), "pwszResultDir": SimTypePointer(SimTypeChar(label="Char"), offset=0), "hCATStore": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="CRYPTCATCDF", pack=False, align=None), offset=0), arg_names=["pwszFilePath", "pfnParseError"]),
        # 
        'CryptCATCDFClose': SimTypeFunction([SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "hFile": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "dwCurFilePos": SimTypeInt(signed=False, label="UInt32"), "dwLastMemberOffset": SimTypeInt(signed=False, label="UInt32"), "fEOF": SimTypeInt(signed=True, label="Int32"), "pwszResultDir": SimTypePointer(SimTypeChar(label="Char"), offset=0), "hCATStore": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="CRYPTCATCDF", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pCDF"]),
        # 
        'CryptCATCDFEnumCatAttributes': SimTypeFunction([SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "hFile": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "dwCurFilePos": SimTypeInt(signed=False, label="UInt32"), "dwLastMemberOffset": SimTypeInt(signed=False, label="UInt32"), "fEOF": SimTypeInt(signed=True, label="Int32"), "pwszResultDir": SimTypePointer(SimTypeChar(label="Char"), offset=0), "hCATStore": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="CRYPTCATCDF", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "pwszReferenceTag": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwAttrTypeAndAction": SimTypeInt(signed=False, label="UInt32"), "cbValue": SimTypeInt(signed=False, label="UInt32"), "pbValue": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwReserved": SimTypeInt(signed=False, label="UInt32")}, name="CRYPTCATATTRIBUTE", pack=False, align=None), offset=0), SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeBottom(label="Void"), arg_names=["dwErrorArea", "dwLocalError", "pwszLine"]), offset=0)], SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "pwszReferenceTag": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwAttrTypeAndAction": SimTypeInt(signed=False, label="UInt32"), "cbValue": SimTypeInt(signed=False, label="UInt32"), "pbValue": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwReserved": SimTypeInt(signed=False, label="UInt32")}, name="CRYPTCATATTRIBUTE", pack=False, align=None), offset=0), arg_names=["pCDF", "pPrevAttr", "pfnParseError"]),
        # 
        'CryptCATCDFEnumMembers': SimTypeFunction([SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "hFile": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "dwCurFilePos": SimTypeInt(signed=False, label="UInt32"), "dwLastMemberOffset": SimTypeInt(signed=False, label="UInt32"), "fEOF": SimTypeInt(signed=True, label="Int32"), "pwszResultDir": SimTypePointer(SimTypeChar(label="Char"), offset=0), "hCATStore": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="CRYPTCATCDF", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "pwszReferenceTag": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszFileName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "gSubjectType": SimTypeBottom(label="Guid"), "fdwMemberFlags": SimTypeInt(signed=False, label="UInt32"), "pIndirectData": SimTypePointer(SimStruct({"Data": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ATTRIBUTE_TYPE_VALUE", pack=False, align=None), "DigestAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Digest": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="SIP_INDIRECT_DATA", pack=False, align=None), offset=0), "dwCertVersion": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeInt(signed=False, label="UInt32"), "hReserved": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "sEncodedIndirectData": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "sEncodedMemberInfo": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPTCATMEMBER", pack=False, align=None), offset=0), SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeBottom(label="Void"), arg_names=["dwErrorArea", "dwLocalError", "pwszLine"]), offset=0)], SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "pwszReferenceTag": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszFileName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "gSubjectType": SimTypeBottom(label="Guid"), "fdwMemberFlags": SimTypeInt(signed=False, label="UInt32"), "pIndirectData": SimTypePointer(SimStruct({"Data": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ATTRIBUTE_TYPE_VALUE", pack=False, align=None), "DigestAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Digest": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="SIP_INDIRECT_DATA", pack=False, align=None), offset=0), "dwCertVersion": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeInt(signed=False, label="UInt32"), "hReserved": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "sEncodedIndirectData": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "sEncodedMemberInfo": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPTCATMEMBER", pack=False, align=None), offset=0), arg_names=["pCDF", "pPrevMember", "pfnParseError"]),
        # 
        'CryptCATCDFEnumAttributes': SimTypeFunction([SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "hFile": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "dwCurFilePos": SimTypeInt(signed=False, label="UInt32"), "dwLastMemberOffset": SimTypeInt(signed=False, label="UInt32"), "fEOF": SimTypeInt(signed=True, label="Int32"), "pwszResultDir": SimTypePointer(SimTypeChar(label="Char"), offset=0), "hCATStore": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="CRYPTCATCDF", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "pwszReferenceTag": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszFileName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "gSubjectType": SimTypeBottom(label="Guid"), "fdwMemberFlags": SimTypeInt(signed=False, label="UInt32"), "pIndirectData": SimTypePointer(SimStruct({"Data": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ATTRIBUTE_TYPE_VALUE", pack=False, align=None), "DigestAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Digest": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="SIP_INDIRECT_DATA", pack=False, align=None), offset=0), "dwCertVersion": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeInt(signed=False, label="UInt32"), "hReserved": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "sEncodedIndirectData": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "sEncodedMemberInfo": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPTCATMEMBER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "pwszReferenceTag": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwAttrTypeAndAction": SimTypeInt(signed=False, label="UInt32"), "cbValue": SimTypeInt(signed=False, label="UInt32"), "pbValue": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwReserved": SimTypeInt(signed=False, label="UInt32")}, name="CRYPTCATATTRIBUTE", pack=False, align=None), offset=0), SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeBottom(label="Void"), arg_names=["dwErrorArea", "dwLocalError", "pwszLine"]), offset=0)], SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "pwszReferenceTag": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwAttrTypeAndAction": SimTypeInt(signed=False, label="UInt32"), "cbValue": SimTypeInt(signed=False, label="UInt32"), "pbValue": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwReserved": SimTypeInt(signed=False, label="UInt32")}, name="CRYPTCATATTRIBUTE", pack=False, align=None), offset=0), arg_names=["pCDF", "pMember", "pPrevAttr", "pfnParseError"]),
        # 
        'IsCatalogFile': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hFile", "pwszFileName"]),
        # 
        'CryptCATAdminAcquireContext': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["phCatAdmin", "pgSubsystem", "dwFlags"]),
        # 
        'CryptCATAdminAcquireContext2': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "dwInfoChoice": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"pvInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pSerializedInfo": SimTypePointer(SimStruct({"dwFlags": SimTypeInt(signed=False, label="CERT_STRONG_SIGN_FLAGS"), "pwszCNGSignHashAlgids": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszCNGPubKeyMinBitLengths": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="CERT_STRONG_SIGN_SERIALIZED_INFO", pack=False, align=None), offset=0), "pszOID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="<anon>", label="None")}, name="CERT_STRONG_SIGN_PARA", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["phCatAdmin", "pgSubsystem", "pwszHashAlgorithm", "pStrongHashPolicy", "dwFlags"]),
        # 
        'CryptCATAdminReleaseContext': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hCatAdmin", "dwFlags"]),
        # 
        'CryptCATAdminReleaseCatalogContext': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hCatAdmin", "hCatInfo", "dwFlags"]),
        # 
        'CryptCATAdminEnumCatalogFromHash': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hCatAdmin", "pbHash", "cbHash", "dwFlags", "phPrevCatInfo"]),
        # 
        'CryptCATAdminCalcHashFromFileHandle': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hFile", "pcbHash", "pbHash", "dwFlags"]),
        # 
        'CryptCATAdminCalcHashFromFileHandle2': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hCatAdmin", "hFile", "pcbHash", "pbHash", "dwFlags"]),
        # 
        'CryptCATAdminAddCatalog': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hCatAdmin", "pwszCatalogFile", "pwszSelectBaseName", "dwFlags"]),
        # 
        'CryptCATAdminRemoveCatalog': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hCatAdmin", "pwszCatalogFile", "dwFlags"]),
        # 
        'CryptCATCatalogInfoFromContext': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "wszCatalogFile": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 260)}, name="CATALOG_INFO", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hCatInfo", "psCatInfo", "dwFlags"]),
        # 
        'CryptCATAdminResolveCatalogPath': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "wszCatalogFile": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 260)}, name="CATALOG_INFO", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hCatAdmin", "pwszCatalogFile", "psCatInfo", "dwFlags"]),
        # 
        'CryptCATAdminPauseServiceForBackup': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["dwFlags", "fResume"]),
        # 
        'WinVerifyTrust': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hwnd", "pgActionID", "pWVTData"]),
        # 
        'WinVerifyTrustEx': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "pPolicyCallbackData": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pSIPClientData": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwUIChoice": SimTypeInt(signed=False, label="WINTRUST_DATA_UICHOICE"), "fdwRevocationChecks": SimTypeInt(signed=False, label="WINTRUST_DATA_REVOCATION_CHECKS"), "dwUnionChoice": SimTypeInt(signed=False, label="WINTRUST_DATA_UNION_CHOICE"), "Anonymous": SimUnion({"pFile": SimTypePointer(SimTypeBottom(label="WINTRUST_FILE_INFO"), offset=0), "pCatalog": SimTypePointer(SimTypeBottom(label="WINTRUST_CATALOG_INFO"), offset=0), "pBlob": SimTypePointer(SimTypeBottom(label="WINTRUST_BLOB_INFO"), offset=0), "pSgnr": SimTypePointer(SimTypeBottom(label="WINTRUST_SGNR_INFO"), offset=0), "pCert": SimTypePointer(SimTypeBottom(label="WINTRUST_CERT_INFO"), offset=0)}, name="<anon>", label="None"), "dwStateAction": SimTypeInt(signed=False, label="WINTRUST_DATA_STATE_ACTION"), "hWVTStateData": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pwszURLReference": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwProvFlags": SimTypeInt(signed=False, label="UInt32"), "dwUIContext": SimTypeInt(signed=False, label="WINTRUST_DATA_UICONTEXT"), "pSignatureSettings": SimTypePointer(SimTypeBottom(label="WINTRUST_SIGNATURE_SETTINGS"), offset=0)}, name="WINTRUST_DATA", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hwnd", "pgActionID", "pWinTrustData"]),
        # 
        'WintrustGetRegPolicyFlags': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="WINTRUST_POLICY_FLAGS"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pdwPolicyFlags"]),
        # 
        'WintrustSetRegPolicyFlags': SimTypeFunction([SimTypeInt(signed=False, label="WINTRUST_POLICY_FLAGS")], SimTypeInt(signed=True, label="Int32"), arg_names=["dwPolicyFlags"]),
        # 
        'WintrustAddActionID': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "sInitProvider": SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "pwszDLLName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszFunctionName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="CRYPT_TRUST_REG_ENTRY", pack=False, align=None), "sObjectProvider": SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "pwszDLLName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszFunctionName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="CRYPT_TRUST_REG_ENTRY", pack=False, align=None), "sSignatureProvider": SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "pwszDLLName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszFunctionName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="CRYPT_TRUST_REG_ENTRY", pack=False, align=None), "sCertificateProvider": SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "pwszDLLName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszFunctionName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="CRYPT_TRUST_REG_ENTRY", pack=False, align=None), "sCertificatePolicyProvider": SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "pwszDLLName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszFunctionName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="CRYPT_TRUST_REG_ENTRY", pack=False, align=None), "sFinalPolicyProvider": SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "pwszDLLName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszFunctionName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="CRYPT_TRUST_REG_ENTRY", pack=False, align=None), "sTestPolicyProvider": SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "pwszDLLName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszFunctionName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="CRYPT_TRUST_REG_ENTRY", pack=False, align=None), "sCleanupProvider": SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "pwszDLLName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszFunctionName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="CRYPT_TRUST_REG_ENTRY", pack=False, align=None)}, name="CRYPT_REGISTER_ACTIONID", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pgActionID", "fdwFlags", "psProvInfo"]),
        # 
        'WintrustRemoveActionID': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pgActionID"]),
        # 
        'WintrustLoadFunctionPointers': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "pfnAlloc": SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["cbSize"]), offset=0), "pfnFree": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pvMem2Free"]), offset=0), "pfnAddStore2Chain": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="CRYPT_PROVIDER_DATA"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pProvData", "hStore2Add"]), offset=0), "pfnAddSgnr2Chain": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="CRYPT_PROVIDER_DATA"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="CRYPT_PROVIDER_SGNR"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pProvData", "fCounterSigner", "idxSigner", "pSgnr2Add"]), offset=0), "pfnAddCert2Chain": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="CRYPT_PROVIDER_DATA"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pProvData", "idxSigner", "fCounterSigner", "idxCounterSigner", "pCert2Add"]), offset=0), "pfnAddPrivData2Chain": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="CRYPT_PROVIDER_DATA"), offset=0), SimTypePointer(SimTypeBottom(label="CRYPT_PROVIDER_PRIVDATA"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pProvData", "pPrivData2Add"]), offset=0), "pfnInitialize": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="CRYPT_PROVIDER_DATA"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pProvData"]), offset=0), "pfnObjectTrust": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="CRYPT_PROVIDER_DATA"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pProvData"]), offset=0), "pfnSignatureTrust": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="CRYPT_PROVIDER_DATA"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pProvData"]), offset=0), "pfnCertificateTrust": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="CRYPT_PROVIDER_DATA"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pProvData"]), offset=0), "pfnFinalPolicy": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="CRYPT_PROVIDER_DATA"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pProvData"]), offset=0), "pfnCertCheckPolicy": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="CRYPT_PROVIDER_DATA"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pProvData", "idxSigner", "fCounterSignerChain", "idxCounterSigner"]), offset=0), "pfnTestFinalPolicy": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="CRYPT_PROVIDER_DATA"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pProvData"]), offset=0), "psUIpfns": SimTypePointer(SimTypeBottom(label="CRYPT_PROVUI_FUNCS"), offset=0), "pfnCleanupPolicy": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="CRYPT_PROVIDER_DATA"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pProvData"]), offset=0)}, name="CRYPT_PROVIDER_FUNCTIONS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pgActionID", "pPfns"]),
        # 
        'WintrustAddDefaultForUsage': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "pgActionID": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "pwszDllName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszLoadCallbackDataFunctionName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pwszFreeCallbackDataFunctionName": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPT_PROVIDER_REGDEFUSAGE", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszUsageOID", "psDefUsage"]),
        # 
        'WintrustGetDefaultForUsage': SimTypeFunction([SimTypeInt(signed=False, label="WINTRUST_GET_DEFAULT_FOR_USAGE_ACTION"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "gActionID": SimTypeBottom(label="Guid"), "pDefPolicyCallbackData": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pDefSIPClientData": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRYPT_PROVIDER_DEFUSAGE", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwAction", "pszUsageOID", "psUsage"]),
        # 
        'WTHelperGetProvSignerFromChain': SimTypeFunction([SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "pWintrustData": SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "pPolicyCallbackData": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pSIPClientData": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwUIChoice": SimTypeInt(signed=False, label="WINTRUST_DATA_UICHOICE"), "fdwRevocationChecks": SimTypeInt(signed=False, label="WINTRUST_DATA_REVOCATION_CHECKS"), "dwUnionChoice": SimTypeInt(signed=False, label="WINTRUST_DATA_UNION_CHOICE"), "Anonymous": SimUnion({"pFile": SimTypePointer(SimTypeBottom(label="WINTRUST_FILE_INFO"), offset=0), "pCatalog": SimTypePointer(SimTypeBottom(label="WINTRUST_CATALOG_INFO"), offset=0), "pBlob": SimTypePointer(SimTypeBottom(label="WINTRUST_BLOB_INFO"), offset=0), "pSgnr": SimTypePointer(SimTypeBottom(label="WINTRUST_SGNR_INFO"), offset=0), "pCert": SimTypePointer(SimTypeBottom(label="WINTRUST_CERT_INFO"), offset=0)}, name="<anon>", label="None"), "dwStateAction": SimTypeInt(signed=False, label="WINTRUST_DATA_STATE_ACTION"), "hWVTStateData": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pwszURLReference": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwProvFlags": SimTypeInt(signed=False, label="UInt32"), "dwUIContext": SimTypeInt(signed=False, label="WINTRUST_DATA_UICONTEXT"), "pSignatureSettings": SimTypePointer(SimTypeBottom(label="WINTRUST_SIGNATURE_SETTINGS"), offset=0)}, name="WINTRUST_DATA", pack=False, align=None), offset=0), "fOpenedFile": SimTypeInt(signed=True, label="Int32"), "hWndParent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pgActionID": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "hProv": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwError": SimTypeInt(signed=False, label="UInt32"), "dwRegSecuritySettings": SimTypeInt(signed=False, label="UInt32"), "dwRegPolicySettings": SimTypeInt(signed=False, label="UInt32"), "psPfns": SimTypePointer(SimTypeBottom(label="CRYPT_PROVIDER_FUNCTIONS"), offset=0), "cdwTrustStepErrors": SimTypeInt(signed=False, label="UInt32"), "padwTrustStepErrors": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "chStores": SimTypeInt(signed=False, label="UInt32"), "pahStores": SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), "dwEncoding": SimTypeInt(signed=False, label="UInt32"), "hMsg": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "csSigners": SimTypeInt(signed=False, label="UInt32"), "pasSigners": SimTypePointer(SimTypeBottom(label="CRYPT_PROVIDER_SGNR"), offset=0), "csProvPrivData": SimTypeInt(signed=False, label="UInt32"), "pasProvPrivData": SimTypePointer(SimTypeBottom(label="CRYPT_PROVIDER_PRIVDATA"), offset=0), "dwSubjectChoice": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"pPDSip": SimTypePointer(SimTypeBottom(label="PROVDATA_SIP"), offset=0)}, name="<anon>", label="None"), "pszUsageOID": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fRecallWithState": SimTypeInt(signed=True, label="Int32"), "sftSystemTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "pszCTLSignerUsageOID": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwProvFlags": SimTypeInt(signed=False, label="UInt32"), "dwFinalError": SimTypeInt(signed=False, label="UInt32"), "pRequestUsage": SimTypePointer(SimStruct({"dwType": SimTypeInt(signed=False, label="UInt32"), "Usage": SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None)}, name="CERT_USAGE_MATCH", pack=False, align=None), offset=0), "dwTrustPubSettings": SimTypeInt(signed=False, label="UInt32"), "dwUIStateFlags": SimTypeInt(signed=False, label="UInt32"), "pSigState": SimTypePointer(SimTypeBottom(label="CRYPT_PROVIDER_SIGSTATE"), offset=0), "pSigSettings": SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "dwIndex": SimTypeInt(signed=False, label="UInt32"), "dwFlags": SimTypeInt(signed=False, label="WINTRUST_SIGNATURE_SETTINGS_FLAGS"), "cSecondarySigs": SimTypeInt(signed=False, label="UInt32"), "dwVerifiedSigIndex": SimTypeInt(signed=False, label="UInt32"), "pCryptoPolicy": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "dwInfoChoice": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"pvInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pSerializedInfo": SimTypePointer(SimStruct({"dwFlags": SimTypeInt(signed=False, label="CERT_STRONG_SIGN_FLAGS"), "pwszCNGSignHashAlgids": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszCNGPubKeyMinBitLengths": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="CERT_STRONG_SIGN_SERIALIZED_INFO", pack=False, align=None), offset=0), "pszOID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="<anon>", label="None")}, name="CERT_STRONG_SIGN_PARA", pack=False, align=None), offset=0)}, name="WINTRUST_SIGNATURE_SETTINGS", pack=False, align=None), offset=0)}, name="CRYPT_PROVIDER_DATA", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "sftVerifyAsOf": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "csCertChain": SimTypeInt(signed=False, label="UInt32"), "pasCertChain": SimTypePointer(SimTypeBottom(label="CRYPT_PROVIDER_CERT"), offset=0), "dwSignerType": SimTypeInt(signed=False, label="UInt32"), "psSigner": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "HashAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "HashEncryptionAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "EncryptedHash": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "AuthAttrs": SimStruct({"cAttr": SimTypeInt(signed=False, label="UInt32"), "rgAttr": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTES", pack=False, align=None), "UnauthAttrs": SimStruct({"cAttr": SimTypeInt(signed=False, label="UInt32"), "rgAttr": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTES", pack=False, align=None)}, name="CMSG_SIGNER_INFO", pack=False, align=None), offset=0), "dwError": SimTypeInt(signed=False, label="UInt32"), "csCounterSigners": SimTypeInt(signed=False, label="UInt32"), "pasCounterSigners": SimTypePointer(SimTypeBottom(label="CRYPT_PROVIDER_SGNR"), offset=0), "pChainContext": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "TrustStatus": SimStruct({"dwErrorStatus": SimTypeInt(signed=False, label="UInt32"), "dwInfoStatus": SimTypeInt(signed=False, label="UInt32")}, name="CERT_TRUST_STATUS", pack=False, align=None), "cChain": SimTypeInt(signed=False, label="UInt32"), "rgpChain": SimTypePointer(SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "TrustStatus": SimStruct({"dwErrorStatus": SimTypeInt(signed=False, label="UInt32"), "dwInfoStatus": SimTypeInt(signed=False, label="UInt32")}, name="CERT_TRUST_STATUS", pack=False, align=None), "cElement": SimTypeInt(signed=False, label="UInt32"), "rgpElement": SimTypePointer(SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pCertContext": SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), "TrustStatus": SimStruct({"dwErrorStatus": SimTypeInt(signed=False, label="UInt32"), "dwInfoStatus": SimTypeInt(signed=False, label="UInt32")}, name="CERT_TRUST_STATUS", pack=False, align=None), "pRevocationInfo": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "dwRevocationResult": SimTypeInt(signed=False, label="UInt32"), "pszRevocationOid": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pvOidSpecificInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "fHasFreshnessTime": SimTypeInt(signed=True, label="Int32"), "dwFreshnessTime": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pBaseCrlContext": SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCrlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCrlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cCRLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCRLEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRL_CONTEXT", pack=False, align=None), offset=0), "pDeltaCrlContext": SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCrlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCrlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cCRLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCRLEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRL_CONTEXT", pack=False, align=None), offset=0), "pCrlEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "fDeltaCrlEntry": SimTypeInt(signed=True, label="Int32")}, name="CERT_REVOCATION_CRL_INFO", pack=False, align=None), offset=0)}, name="CERT_REVOCATION_INFO", pack=False, align=None), offset=0), "pIssuanceUsage": SimTypePointer(SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), offset=0), "pApplicationUsage": SimTypePointer(SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), offset=0), "pwszExtendedErrorInfo": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="CERT_CHAIN_ELEMENT", pack=False, align=None), offset=0), offset=0), "pTrustListInfo": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pCtlEntry": SimTypePointer(SimStruct({"SubjectIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cAttribute": SimTypeInt(signed=False, label="UInt32"), "rgAttribute": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CTL_ENTRY", pack=False, align=None), offset=0), "pCtlContext": SimTypePointer(SimStruct({"dwMsgAndCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCtlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCtlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SubjectUsage": SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), "ListIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SequenceNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "SubjectAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "cCTLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCTLEntry": SimTypePointer(SimStruct({"SubjectIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cAttribute": SimTypeInt(signed=False, label="UInt32"), "rgAttribute": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CTL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CTL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "hCryptMsg": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pbCtlContent": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlContent": SimTypeInt(signed=False, label="UInt32")}, name="CTL_CONTEXT", pack=False, align=None), offset=0)}, name="CERT_TRUST_LIST_INFO", pack=False, align=None), offset=0), "fHasRevocationFreshnessTime": SimTypeInt(signed=True, label="Int32"), "dwRevocationFreshnessTime": SimTypeInt(signed=False, label="UInt32")}, name="CERT_SIMPLE_CHAIN", pack=False, align=None), offset=0), offset=0), "cLowerQualityChainContext": SimTypeInt(signed=False, label="UInt32"), "rgpLowerQualityChainContext": SimTypePointer(SimTypePointer(SimTypeBottom(label="CERT_CHAIN_CONTEXT"), offset=0), offset=0), "fHasRevocationFreshnessTime": SimTypeInt(signed=True, label="Int32"), "dwRevocationFreshnessTime": SimTypeInt(signed=False, label="UInt32"), "dwCreateFlags": SimTypeInt(signed=False, label="UInt32"), "ChainId": SimTypeBottom(label="Guid")}, name="CERT_CHAIN_CONTEXT", pack=False, align=None), offset=0)}, name="CRYPT_PROVIDER_SGNR", pack=False, align=None), offset=0), arg_names=["pProvData", "idxSigner", "fCounterSigner", "idxCounterSigner"]),
        # 
        'WTHelperGetProvCertFromChain': SimTypeFunction([SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "sftVerifyAsOf": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "csCertChain": SimTypeInt(signed=False, label="UInt32"), "pasCertChain": SimTypePointer(SimTypeBottom(label="CRYPT_PROVIDER_CERT"), offset=0), "dwSignerType": SimTypeInt(signed=False, label="UInt32"), "psSigner": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "HashAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "HashEncryptionAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "EncryptedHash": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "AuthAttrs": SimStruct({"cAttr": SimTypeInt(signed=False, label="UInt32"), "rgAttr": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTES", pack=False, align=None), "UnauthAttrs": SimStruct({"cAttr": SimTypeInt(signed=False, label="UInt32"), "rgAttr": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTES", pack=False, align=None)}, name="CMSG_SIGNER_INFO", pack=False, align=None), offset=0), "dwError": SimTypeInt(signed=False, label="UInt32"), "csCounterSigners": SimTypeInt(signed=False, label="UInt32"), "pasCounterSigners": SimTypePointer(SimTypeBottom(label="CRYPT_PROVIDER_SGNR"), offset=0), "pChainContext": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "TrustStatus": SimStruct({"dwErrorStatus": SimTypeInt(signed=False, label="UInt32"), "dwInfoStatus": SimTypeInt(signed=False, label="UInt32")}, name="CERT_TRUST_STATUS", pack=False, align=None), "cChain": SimTypeInt(signed=False, label="UInt32"), "rgpChain": SimTypePointer(SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "TrustStatus": SimStruct({"dwErrorStatus": SimTypeInt(signed=False, label="UInt32"), "dwInfoStatus": SimTypeInt(signed=False, label="UInt32")}, name="CERT_TRUST_STATUS", pack=False, align=None), "cElement": SimTypeInt(signed=False, label="UInt32"), "rgpElement": SimTypePointer(SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pCertContext": SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), "TrustStatus": SimStruct({"dwErrorStatus": SimTypeInt(signed=False, label="UInt32"), "dwInfoStatus": SimTypeInt(signed=False, label="UInt32")}, name="CERT_TRUST_STATUS", pack=False, align=None), "pRevocationInfo": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "dwRevocationResult": SimTypeInt(signed=False, label="UInt32"), "pszRevocationOid": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pvOidSpecificInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "fHasFreshnessTime": SimTypeInt(signed=True, label="Int32"), "dwFreshnessTime": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pBaseCrlContext": SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCrlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCrlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cCRLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCRLEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRL_CONTEXT", pack=False, align=None), offset=0), "pDeltaCrlContext": SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCrlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCrlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cCRLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCRLEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRL_CONTEXT", pack=False, align=None), offset=0), "pCrlEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "fDeltaCrlEntry": SimTypeInt(signed=True, label="Int32")}, name="CERT_REVOCATION_CRL_INFO", pack=False, align=None), offset=0)}, name="CERT_REVOCATION_INFO", pack=False, align=None), offset=0), "pIssuanceUsage": SimTypePointer(SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), offset=0), "pApplicationUsage": SimTypePointer(SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), offset=0), "pwszExtendedErrorInfo": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="CERT_CHAIN_ELEMENT", pack=False, align=None), offset=0), offset=0), "pTrustListInfo": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pCtlEntry": SimTypePointer(SimStruct({"SubjectIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cAttribute": SimTypeInt(signed=False, label="UInt32"), "rgAttribute": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CTL_ENTRY", pack=False, align=None), offset=0), "pCtlContext": SimTypePointer(SimStruct({"dwMsgAndCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCtlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCtlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SubjectUsage": SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), "ListIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SequenceNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "SubjectAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "cCTLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCTLEntry": SimTypePointer(SimStruct({"SubjectIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cAttribute": SimTypeInt(signed=False, label="UInt32"), "rgAttribute": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CTL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CTL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "hCryptMsg": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pbCtlContent": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlContent": SimTypeInt(signed=False, label="UInt32")}, name="CTL_CONTEXT", pack=False, align=None), offset=0)}, name="CERT_TRUST_LIST_INFO", pack=False, align=None), offset=0), "fHasRevocationFreshnessTime": SimTypeInt(signed=True, label="Int32"), "dwRevocationFreshnessTime": SimTypeInt(signed=False, label="UInt32")}, name="CERT_SIMPLE_CHAIN", pack=False, align=None), offset=0), offset=0), "cLowerQualityChainContext": SimTypeInt(signed=False, label="UInt32"), "rgpLowerQualityChainContext": SimTypePointer(SimTypePointer(SimTypeBottom(label="CERT_CHAIN_CONTEXT"), offset=0), offset=0), "fHasRevocationFreshnessTime": SimTypeInt(signed=True, label="Int32"), "dwRevocationFreshnessTime": SimTypeInt(signed=False, label="UInt32"), "dwCreateFlags": SimTypeInt(signed=False, label="UInt32"), "ChainId": SimTypeBottom(label="Guid")}, name="CERT_CHAIN_CONTEXT", pack=False, align=None), offset=0)}, name="CRYPT_PROVIDER_SGNR", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "pCert": SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), "fCommercial": SimTypeInt(signed=True, label="Int32"), "fTrustedRoot": SimTypeInt(signed=True, label="Int32"), "fSelfSigned": SimTypeInt(signed=True, label="Int32"), "fTestCert": SimTypeInt(signed=True, label="Int32"), "dwRevokedReason": SimTypeInt(signed=False, label="UInt32"), "dwConfidence": SimTypeInt(signed=False, label="UInt32"), "dwError": SimTypeInt(signed=False, label="UInt32"), "pTrustListContext": SimTypePointer(SimStruct({"dwMsgAndCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCtlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCtlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SubjectUsage": SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), "ListIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SequenceNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "SubjectAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "cCTLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCTLEntry": SimTypePointer(SimStruct({"SubjectIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cAttribute": SimTypeInt(signed=False, label="UInt32"), "rgAttribute": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CTL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CTL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "hCryptMsg": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pbCtlContent": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlContent": SimTypeInt(signed=False, label="UInt32")}, name="CTL_CONTEXT", pack=False, align=None), offset=0), "fTrustListSignerCert": SimTypeInt(signed=True, label="Int32"), "pCtlContext": SimTypePointer(SimStruct({"dwMsgAndCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCtlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCtlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SubjectUsage": SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), "ListIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SequenceNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "SubjectAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "cCTLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCTLEntry": SimTypePointer(SimStruct({"SubjectIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cAttribute": SimTypeInt(signed=False, label="UInt32"), "rgAttribute": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CTL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CTL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "hCryptMsg": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pbCtlContent": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlContent": SimTypeInt(signed=False, label="UInt32")}, name="CTL_CONTEXT", pack=False, align=None), offset=0), "dwCtlError": SimTypeInt(signed=False, label="UInt32"), "fIsCyclic": SimTypeInt(signed=True, label="Int32"), "pChainElement": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pCertContext": SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), "TrustStatus": SimStruct({"dwErrorStatus": SimTypeInt(signed=False, label="UInt32"), "dwInfoStatus": SimTypeInt(signed=False, label="UInt32")}, name="CERT_TRUST_STATUS", pack=False, align=None), "pRevocationInfo": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "dwRevocationResult": SimTypeInt(signed=False, label="UInt32"), "pszRevocationOid": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pvOidSpecificInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "fHasFreshnessTime": SimTypeInt(signed=True, label="Int32"), "dwFreshnessTime": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pBaseCrlContext": SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCrlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCrlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cCRLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCRLEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRL_CONTEXT", pack=False, align=None), offset=0), "pDeltaCrlContext": SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCrlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCrlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cCRLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCRLEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRL_CONTEXT", pack=False, align=None), offset=0), "pCrlEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "fDeltaCrlEntry": SimTypeInt(signed=True, label="Int32")}, name="CERT_REVOCATION_CRL_INFO", pack=False, align=None), offset=0)}, name="CERT_REVOCATION_INFO", pack=False, align=None), offset=0), "pIssuanceUsage": SimTypePointer(SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), offset=0), "pApplicationUsage": SimTypePointer(SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), offset=0), "pwszExtendedErrorInfo": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="CERT_CHAIN_ELEMENT", pack=False, align=None), offset=0)}, name="CRYPT_PROVIDER_CERT", pack=False, align=None), offset=0), arg_names=["pSgnr", "idxCert"]),
        # 
        'WTHelperProvDataFromStateData': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "pWintrustData": SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "pPolicyCallbackData": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pSIPClientData": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwUIChoice": SimTypeInt(signed=False, label="WINTRUST_DATA_UICHOICE"), "fdwRevocationChecks": SimTypeInt(signed=False, label="WINTRUST_DATA_REVOCATION_CHECKS"), "dwUnionChoice": SimTypeInt(signed=False, label="WINTRUST_DATA_UNION_CHOICE"), "Anonymous": SimUnion({"pFile": SimTypePointer(SimTypeBottom(label="WINTRUST_FILE_INFO"), offset=0), "pCatalog": SimTypePointer(SimTypeBottom(label="WINTRUST_CATALOG_INFO"), offset=0), "pBlob": SimTypePointer(SimTypeBottom(label="WINTRUST_BLOB_INFO"), offset=0), "pSgnr": SimTypePointer(SimTypeBottom(label="WINTRUST_SGNR_INFO"), offset=0), "pCert": SimTypePointer(SimTypeBottom(label="WINTRUST_CERT_INFO"), offset=0)}, name="<anon>", label="None"), "dwStateAction": SimTypeInt(signed=False, label="WINTRUST_DATA_STATE_ACTION"), "hWVTStateData": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pwszURLReference": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwProvFlags": SimTypeInt(signed=False, label="UInt32"), "dwUIContext": SimTypeInt(signed=False, label="WINTRUST_DATA_UICONTEXT"), "pSignatureSettings": SimTypePointer(SimTypeBottom(label="WINTRUST_SIGNATURE_SETTINGS"), offset=0)}, name="WINTRUST_DATA", pack=False, align=None), offset=0), "fOpenedFile": SimTypeInt(signed=True, label="Int32"), "hWndParent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pgActionID": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "hProv": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwError": SimTypeInt(signed=False, label="UInt32"), "dwRegSecuritySettings": SimTypeInt(signed=False, label="UInt32"), "dwRegPolicySettings": SimTypeInt(signed=False, label="UInt32"), "psPfns": SimTypePointer(SimTypeBottom(label="CRYPT_PROVIDER_FUNCTIONS"), offset=0), "cdwTrustStepErrors": SimTypeInt(signed=False, label="UInt32"), "padwTrustStepErrors": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "chStores": SimTypeInt(signed=False, label="UInt32"), "pahStores": SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), "dwEncoding": SimTypeInt(signed=False, label="UInt32"), "hMsg": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "csSigners": SimTypeInt(signed=False, label="UInt32"), "pasSigners": SimTypePointer(SimTypeBottom(label="CRYPT_PROVIDER_SGNR"), offset=0), "csProvPrivData": SimTypeInt(signed=False, label="UInt32"), "pasProvPrivData": SimTypePointer(SimTypeBottom(label="CRYPT_PROVIDER_PRIVDATA"), offset=0), "dwSubjectChoice": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"pPDSip": SimTypePointer(SimTypeBottom(label="PROVDATA_SIP"), offset=0)}, name="<anon>", label="None"), "pszUsageOID": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fRecallWithState": SimTypeInt(signed=True, label="Int32"), "sftSystemTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "pszCTLSignerUsageOID": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwProvFlags": SimTypeInt(signed=False, label="UInt32"), "dwFinalError": SimTypeInt(signed=False, label="UInt32"), "pRequestUsage": SimTypePointer(SimStruct({"dwType": SimTypeInt(signed=False, label="UInt32"), "Usage": SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None)}, name="CERT_USAGE_MATCH", pack=False, align=None), offset=0), "dwTrustPubSettings": SimTypeInt(signed=False, label="UInt32"), "dwUIStateFlags": SimTypeInt(signed=False, label="UInt32"), "pSigState": SimTypePointer(SimTypeBottom(label="CRYPT_PROVIDER_SIGSTATE"), offset=0), "pSigSettings": SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "dwIndex": SimTypeInt(signed=False, label="UInt32"), "dwFlags": SimTypeInt(signed=False, label="WINTRUST_SIGNATURE_SETTINGS_FLAGS"), "cSecondarySigs": SimTypeInt(signed=False, label="UInt32"), "dwVerifiedSigIndex": SimTypeInt(signed=False, label="UInt32"), "pCryptoPolicy": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "dwInfoChoice": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"pvInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pSerializedInfo": SimTypePointer(SimStruct({"dwFlags": SimTypeInt(signed=False, label="CERT_STRONG_SIGN_FLAGS"), "pwszCNGSignHashAlgids": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszCNGPubKeyMinBitLengths": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="CERT_STRONG_SIGN_SERIALIZED_INFO", pack=False, align=None), offset=0), "pszOID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="<anon>", label="None")}, name="CERT_STRONG_SIGN_PARA", pack=False, align=None), offset=0)}, name="WINTRUST_SIGNATURE_SETTINGS", pack=False, align=None), offset=0)}, name="CRYPT_PROVIDER_DATA", pack=False, align=None), offset=0), arg_names=["hStateData"]),
        # 
        'WTHelperGetProvPrivateDataFromChain': SimTypeFunction([SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "pWintrustData": SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "pPolicyCallbackData": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pSIPClientData": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwUIChoice": SimTypeInt(signed=False, label="WINTRUST_DATA_UICHOICE"), "fdwRevocationChecks": SimTypeInt(signed=False, label="WINTRUST_DATA_REVOCATION_CHECKS"), "dwUnionChoice": SimTypeInt(signed=False, label="WINTRUST_DATA_UNION_CHOICE"), "Anonymous": SimUnion({"pFile": SimTypePointer(SimTypeBottom(label="WINTRUST_FILE_INFO"), offset=0), "pCatalog": SimTypePointer(SimTypeBottom(label="WINTRUST_CATALOG_INFO"), offset=0), "pBlob": SimTypePointer(SimTypeBottom(label="WINTRUST_BLOB_INFO"), offset=0), "pSgnr": SimTypePointer(SimTypeBottom(label="WINTRUST_SGNR_INFO"), offset=0), "pCert": SimTypePointer(SimTypeBottom(label="WINTRUST_CERT_INFO"), offset=0)}, name="<anon>", label="None"), "dwStateAction": SimTypeInt(signed=False, label="WINTRUST_DATA_STATE_ACTION"), "hWVTStateData": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pwszURLReference": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwProvFlags": SimTypeInt(signed=False, label="UInt32"), "dwUIContext": SimTypeInt(signed=False, label="WINTRUST_DATA_UICONTEXT"), "pSignatureSettings": SimTypePointer(SimTypeBottom(label="WINTRUST_SIGNATURE_SETTINGS"), offset=0)}, name="WINTRUST_DATA", pack=False, align=None), offset=0), "fOpenedFile": SimTypeInt(signed=True, label="Int32"), "hWndParent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pgActionID": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "hProv": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwError": SimTypeInt(signed=False, label="UInt32"), "dwRegSecuritySettings": SimTypeInt(signed=False, label="UInt32"), "dwRegPolicySettings": SimTypeInt(signed=False, label="UInt32"), "psPfns": SimTypePointer(SimTypeBottom(label="CRYPT_PROVIDER_FUNCTIONS"), offset=0), "cdwTrustStepErrors": SimTypeInt(signed=False, label="UInt32"), "padwTrustStepErrors": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "chStores": SimTypeInt(signed=False, label="UInt32"), "pahStores": SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), "dwEncoding": SimTypeInt(signed=False, label="UInt32"), "hMsg": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "csSigners": SimTypeInt(signed=False, label="UInt32"), "pasSigners": SimTypePointer(SimTypeBottom(label="CRYPT_PROVIDER_SGNR"), offset=0), "csProvPrivData": SimTypeInt(signed=False, label="UInt32"), "pasProvPrivData": SimTypePointer(SimTypeBottom(label="CRYPT_PROVIDER_PRIVDATA"), offset=0), "dwSubjectChoice": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"pPDSip": SimTypePointer(SimTypeBottom(label="PROVDATA_SIP"), offset=0)}, name="<anon>", label="None"), "pszUsageOID": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fRecallWithState": SimTypeInt(signed=True, label="Int32"), "sftSystemTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "pszCTLSignerUsageOID": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwProvFlags": SimTypeInt(signed=False, label="UInt32"), "dwFinalError": SimTypeInt(signed=False, label="UInt32"), "pRequestUsage": SimTypePointer(SimStruct({"dwType": SimTypeInt(signed=False, label="UInt32"), "Usage": SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None)}, name="CERT_USAGE_MATCH", pack=False, align=None), offset=0), "dwTrustPubSettings": SimTypeInt(signed=False, label="UInt32"), "dwUIStateFlags": SimTypeInt(signed=False, label="UInt32"), "pSigState": SimTypePointer(SimTypeBottom(label="CRYPT_PROVIDER_SIGSTATE"), offset=0), "pSigSettings": SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "dwIndex": SimTypeInt(signed=False, label="UInt32"), "dwFlags": SimTypeInt(signed=False, label="WINTRUST_SIGNATURE_SETTINGS_FLAGS"), "cSecondarySigs": SimTypeInt(signed=False, label="UInt32"), "dwVerifiedSigIndex": SimTypeInt(signed=False, label="UInt32"), "pCryptoPolicy": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "dwInfoChoice": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"pvInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pSerializedInfo": SimTypePointer(SimStruct({"dwFlags": SimTypeInt(signed=False, label="CERT_STRONG_SIGN_FLAGS"), "pwszCNGSignHashAlgids": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszCNGPubKeyMinBitLengths": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="CERT_STRONG_SIGN_SERIALIZED_INFO", pack=False, align=None), offset=0), "pszOID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="<anon>", label="None")}, name="CERT_STRONG_SIGN_PARA", pack=False, align=None), offset=0)}, name="WINTRUST_SIGNATURE_SETTINGS", pack=False, align=None), offset=0)}, name="CRYPT_PROVIDER_DATA", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0)], SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "gProviderID": SimTypeBottom(label="Guid"), "cbProvData": SimTypeInt(signed=False, label="UInt32"), "pvProvData": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRYPT_PROVIDER_PRIVDATA", pack=False, align=None), offset=0), arg_names=["pProvData", "pgProviderID"]),
        # 
        'WTHelperCertIsSelfSigned': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwEncoding", "pCert"]),
        # 
        'WTHelperCertCheckValidSignature': SimTypeFunction([SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "pWintrustData": SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "pPolicyCallbackData": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pSIPClientData": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwUIChoice": SimTypeInt(signed=False, label="WINTRUST_DATA_UICHOICE"), "fdwRevocationChecks": SimTypeInt(signed=False, label="WINTRUST_DATA_REVOCATION_CHECKS"), "dwUnionChoice": SimTypeInt(signed=False, label="WINTRUST_DATA_UNION_CHOICE"), "Anonymous": SimUnion({"pFile": SimTypePointer(SimTypeBottom(label="WINTRUST_FILE_INFO"), offset=0), "pCatalog": SimTypePointer(SimTypeBottom(label="WINTRUST_CATALOG_INFO"), offset=0), "pBlob": SimTypePointer(SimTypeBottom(label="WINTRUST_BLOB_INFO"), offset=0), "pSgnr": SimTypePointer(SimTypeBottom(label="WINTRUST_SGNR_INFO"), offset=0), "pCert": SimTypePointer(SimTypeBottom(label="WINTRUST_CERT_INFO"), offset=0)}, name="<anon>", label="None"), "dwStateAction": SimTypeInt(signed=False, label="WINTRUST_DATA_STATE_ACTION"), "hWVTStateData": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pwszURLReference": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwProvFlags": SimTypeInt(signed=False, label="UInt32"), "dwUIContext": SimTypeInt(signed=False, label="WINTRUST_DATA_UICONTEXT"), "pSignatureSettings": SimTypePointer(SimTypeBottom(label="WINTRUST_SIGNATURE_SETTINGS"), offset=0)}, name="WINTRUST_DATA", pack=False, align=None), offset=0), "fOpenedFile": SimTypeInt(signed=True, label="Int32"), "hWndParent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pgActionID": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "hProv": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwError": SimTypeInt(signed=False, label="UInt32"), "dwRegSecuritySettings": SimTypeInt(signed=False, label="UInt32"), "dwRegPolicySettings": SimTypeInt(signed=False, label="UInt32"), "psPfns": SimTypePointer(SimTypeBottom(label="CRYPT_PROVIDER_FUNCTIONS"), offset=0), "cdwTrustStepErrors": SimTypeInt(signed=False, label="UInt32"), "padwTrustStepErrors": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "chStores": SimTypeInt(signed=False, label="UInt32"), "pahStores": SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), "dwEncoding": SimTypeInt(signed=False, label="UInt32"), "hMsg": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "csSigners": SimTypeInt(signed=False, label="UInt32"), "pasSigners": SimTypePointer(SimTypeBottom(label="CRYPT_PROVIDER_SGNR"), offset=0), "csProvPrivData": SimTypeInt(signed=False, label="UInt32"), "pasProvPrivData": SimTypePointer(SimTypeBottom(label="CRYPT_PROVIDER_PRIVDATA"), offset=0), "dwSubjectChoice": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"pPDSip": SimTypePointer(SimTypeBottom(label="PROVDATA_SIP"), offset=0)}, name="<anon>", label="None"), "pszUsageOID": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fRecallWithState": SimTypeInt(signed=True, label="Int32"), "sftSystemTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "pszCTLSignerUsageOID": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwProvFlags": SimTypeInt(signed=False, label="UInt32"), "dwFinalError": SimTypeInt(signed=False, label="UInt32"), "pRequestUsage": SimTypePointer(SimStruct({"dwType": SimTypeInt(signed=False, label="UInt32"), "Usage": SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None)}, name="CERT_USAGE_MATCH", pack=False, align=None), offset=0), "dwTrustPubSettings": SimTypeInt(signed=False, label="UInt32"), "dwUIStateFlags": SimTypeInt(signed=False, label="UInt32"), "pSigState": SimTypePointer(SimTypeBottom(label="CRYPT_PROVIDER_SIGSTATE"), offset=0), "pSigSettings": SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "dwIndex": SimTypeInt(signed=False, label="UInt32"), "dwFlags": SimTypeInt(signed=False, label="WINTRUST_SIGNATURE_SETTINGS_FLAGS"), "cSecondarySigs": SimTypeInt(signed=False, label="UInt32"), "dwVerifiedSigIndex": SimTypeInt(signed=False, label="UInt32"), "pCryptoPolicy": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "dwInfoChoice": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"pvInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pSerializedInfo": SimTypePointer(SimStruct({"dwFlags": SimTypeInt(signed=False, label="CERT_STRONG_SIGN_FLAGS"), "pwszCNGSignHashAlgids": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszCNGPubKeyMinBitLengths": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="CERT_STRONG_SIGN_SERIALIZED_INFO", pack=False, align=None), offset=0), "pszOID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="<anon>", label="None")}, name="CERT_STRONG_SIGN_PARA", pack=False, align=None), offset=0)}, name="WINTRUST_SIGNATURE_SETTINGS", pack=False, align=None), offset=0)}, name="CRYPT_PROVIDER_DATA", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pProvData"]),
        # 
        'OpenPersonalTrustDBDialogEx': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hwndParent", "dwFlags", "pvReserved"]),
        # 
        'OpenPersonalTrustDBDialog': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hwndParent"]),
        # 
        'WintrustSetDefaultIncludePEPageHashes': SimTypeFunction([SimTypeInt(signed=True, label="Int32")], SimTypeBottom(label="Void"), arg_names=["fIncludePEPageHashes"]),
    }

lib.set_prototypes(prototypes)
