# Generated by Django 4.2.8 on 2024-01-03 08:47

from contextlib import suppress

from django.apps import apps
from django.contrib.contenttypes.models import ContentType
from django.db import migrations


def migrate_content_type(apps, schema_editor):
    Report = apps.get_model("wbreport", "Report")

    for model_name in [
        "Classification",
        "Instrument",
        "ClassificationGroup",
        "Deal",
        "Exchange",
        "InstrumentClassificationRelatedInstrument",
        "InstrumentClassificationThroughModel",
        "InstrumentFavoriteGroup",
        "InstrumentList",
        "InstrumentListThroughModel",
        "InstrumentRequest",
        "RelatedInstrumentThroughModel",
        "InstrumentPrice",
    ]:
        with suppress(ContentType.DoesNotExist):
            old_ct = ContentType.objects.get(app_label="wbportfolio", model=model_name.lower())
            new_ct = ContentType.objects.get(app_label="wbfdm", model=model_name.lower())
            Report.objects.filter(content_type_id=old_ct.id).update(content_type_id=new_ct.id)


class Migration(migrations.Migration):
    dependencies = (
        [
            ("wbreport", "0009_alter_report_color_palette"),
            ("wbfdm", "0012_instrumentprice_created_instrumentprice_modified"),
        ]
        if apps.is_installed("wbfdm")
        else [("wbreport", "0009_alter_report_color_palette")]
    )
    operations = [migrations.RunPython(migrate_content_type)]
