# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .us_state import UsState

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class Address(pydantic.BaseModel):
    """
    from metriport import Address, UsState

    Address(
        address_line_1="2261 Market Street",
        address_line_2="#4818",
        city="San Francisco",
        state=UsState.CA,
        zip="94114",
        country="USA",
    )
    """

    address_line_1: str = pydantic.Field(alias="addressLine1", description="The address.")
    address_line_2: typing.Optional[str] = pydantic.Field(
        alias="addressLine2", default=None, description="The address details, for example `#4451`"
    )
    city: str = pydantic.Field(description="The city.")
    state: UsState = pydantic.Field(description="The 2 letter state acronym, for example `CA`")
    zip: str = pydantic.Field(description="Zip must be a string consisting of 5 numbers.")
    country: typing.Optional[str] = pydantic.Field(default=None, description="Defaults to “USA”")

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
