# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .access_policy_ip_access_rule import AccessPolicyIpAccessRule
from .access_policy_resource import AccessPolicyResource
from .code import Code
from .id import Id
from .meta import Meta
from .reference import Reference
from .uri import Uri

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class AccessPolicy(pydantic.BaseModel):
    """
    Access Policy for user or user group that defines how entities can or cannot access resources.
    """

    resource_type: typing.Literal["AccessPolicy"] = pydantic.Field(alias="resourceType")
    id: typing.Optional[Id] = pydantic.Field(
        default=None,
        description="The logical id of the resource, as used in the URL for the resource. Once assigned, this value never changes.",
    )
    meta: typing.Optional[Meta] = pydantic.Field(
        default=None,
        description="The metadata about the resource. This is content that is maintained by the infrastructure. Changes to the content might not always be associated with version changes to the resource.",
    )
    implicit_rules: typing.Optional[Uri] = pydantic.Field(
        alias="implicitRules",
        default=None,
        description="A reference to a set of rules that were followed when the resource was constructed, and which must be understood when processing the content. Often, this is a reference to an implementation guide that defines the special rules along with other profiles etc.",
    )
    language: typing.Optional[Code] = pydantic.Field(
        default=None, description="The base language in which the resource is written."
    )
    name: typing.Optional[str] = pydantic.Field(default=None, description="A name associated with the AccessPolicy.")
    compartment: typing.Optional[Reference] = pydantic.Field(
        default=None,
        description="Optional compartment for newly created resources. If this field is set, any resources created by a user with this access policy will automatically be included in the specified compartment.",
    )
    resource: typing.Optional[typing.List[AccessPolicyResource]] = pydantic.Field(
        default=None, description="Access details for a resource type."
    )
    ip_access_rule: typing.Optional[typing.List[AccessPolicyIpAccessRule]] = pydantic.Field(
        alias="ipAccessRule",
        default=None,
        description="Use IP Access Rules to allowlist, block, and challenge traffic based on the visitor IP address.",
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
