# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class AccountStatus(str, enum.Enum):
    """
    Indicates whether the account is presently used/usable or not.
    """

    ACTIVE = "active"
    INACTIVE = "inactive"
    ENTERED_IN_ERROR = "entered-in-error"
    ON_HOLD = "on-hold"
    UNKNOWN = "unknown"

    def visit(
        self,
        active: typing.Callable[[], T_Result],
        inactive: typing.Callable[[], T_Result],
        entered_in_error: typing.Callable[[], T_Result],
        on_hold: typing.Callable[[], T_Result],
        unknown: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is AccountStatus.ACTIVE:
            return active()
        if self is AccountStatus.INACTIVE:
            return inactive()
        if self is AccountStatus.ENTERED_IN_ERROR:
            return entered_in_error()
        if self is AccountStatus.ON_HOLD:
            return on_hold()
        if self is AccountStatus.UNKNOWN:
            return unknown()
