# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .address_type import AddressType
from .address_use import AddressUse

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class Address(pydantic.BaseModel):
    """
    An address expressed using postal conventions (as opposed to GPS or other location definition formats). This data type may be used to convey addresses for use in delivering mail as well as for visiting locations which might not be valid for mail delivery. There are a variety of postal address formats defined around the world.
    """

    id: typing.Optional[str] = pydantic.Field(
        default=None,
        description="Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.",
    )
    extension: typing.Optional[typing.List[Extension]] = pydantic.Field(
        default=None,
        description="May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.",
    )
    use: typing.Optional[AddressUse] = pydantic.Field(default=None, description="The purpose of this address.")
    type: typing.Optional[AddressType] = pydantic.Field(
        default=None,
        description="Distinguishes between physical addresses (those you can visit) and mailing addresses (e.g. PO Boxes and care-of addresses). Most addresses are both.",
    )
    text: typing.Optional[str] = pydantic.Field(
        default=None,
        description="Specifies the entire address as it should be displayed e.g. on a postal label. This may be provided instead of or as well as the specific parts.",
    )
    line: typing.Optional[typing.List[str]] = pydantic.Field(
        default=None,
        description="This component contains the house number, apartment number, street name, street direction, P.O. Box number, delivery hints, and similar address information.",
    )
    city: typing.Optional[str] = pydantic.Field(
        default=None, description="The name of the city, town, suburb, village or other community or delivery center."
    )
    district: typing.Optional[str] = pydantic.Field(
        default=None, description="The name of the administrative area (county)."
    )
    state: typing.Optional[str] = pydantic.Field(
        default=None,
        description="Sub-unit of a country with limited sovereignty in a federally organized country. A code may be used if codes are in common use (e.g. US 2 letter state codes).",
    )
    postal_code: typing.Optional[str] = pydantic.Field(
        alias="postalCode",
        default=None,
        description="A postal code designating a region defined by the postal service.",
    )
    country: typing.Optional[str] = pydantic.Field(
        default=None, description="Country - a nation as commonly understood or generally accepted."
    )
    period: typing.Optional[Period] = pydantic.Field(
        default=None, description="Time period when address was/is in use."
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}


from .extension import Extension  # noqa: E402
from .period import Period  # noqa: E402

Address.update_forward_refs()
