# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .age_comparator import AgeComparator
from .code import Code
from .decimal import Decimal
from .uri import Uri

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class Age(pydantic.BaseModel):
    """
    A duration of time during which an organism (or a process) has existed.
    """

    id: typing.Optional[str] = pydantic.Field(
        default=None,
        description="Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.",
    )
    extension: typing.Optional[typing.List[Extension]] = pydantic.Field(
        default=None,
        description="May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.",
    )
    value: typing.Optional[Decimal] = pydantic.Field(
        default=None,
        description="The value of the measured amount. The value includes an implicit precision in the presentation of the value.",
    )
    comparator: typing.Optional[AgeComparator] = pydantic.Field(
        default=None,
        description='How the value should be understood and represented - whether the actual value is greater or less than the stated value due to measurement issues; e.g. if the comparator is "<" , then the real value is < stated value.',
    )
    unit: typing.Optional[str] = pydantic.Field(default=None, description="A human-readable form of the unit.")
    system: typing.Optional[Uri] = pydantic.Field(
        default=None, description="The identification of the system that provides the coded form of the unit."
    )
    code: typing.Optional[Code] = pydantic.Field(
        default=None, description="A computer processable form of the unit in some unit representation system."
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        json_encoders = {dt.datetime: serialize_datetime}


from .extension import Extension  # noqa: E402

Age.update_forward_refs()
