# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .reference import Reference
from .url import Url

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class AgentChannel(pydantic.BaseModel):
    """
    Details where to send notifications when resources are received that meet the criteria.
    """

    endpoint: Reference = pydantic.Field(
        description="The channel endpoint definition including protocol and network binding details."
    )
    target_reference: typing.Optional[Reference] = pydantic.Field(
        alias="targetReference",
        default=None,
        description="The target resource where channel messages will be delivered.",
    )
    target_url: typing.Optional[Url] = pydantic.Field(
        alias="targetUrl", default=None, description="The target resource where channel messages will be delivered."
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
