# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class AllergyIntoleranceCriticality(str, enum.Enum):
    """
    Estimate of the potential clinical harm, or seriousness, of the reaction to the identified substance.
    """

    LOW = "low"
    HIGH = "high"
    UNABLE_TO_ASSESS = "unable-to-assess"

    def visit(
        self,
        low: typing.Callable[[], T_Result],
        high: typing.Callable[[], T_Result],
        unable_to_assess: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is AllergyIntoleranceCriticality.LOW:
            return low()
        if self is AllergyIntoleranceCriticality.HIGH:
            return high()
        if self is AllergyIntoleranceCriticality.UNABLE_TO_ASSESS:
            return unable_to_assess()
