# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class AllergyIntoleranceReactionSeverity(str, enum.Enum):
    """
    Clinical assessment of the severity of the reaction event as a whole, potentially considering multiple different manifestations.
    """

    MILD = "mild"
    MODERATE = "moderate"
    SEVERE = "severe"

    def visit(
        self,
        mild: typing.Callable[[], T_Result],
        moderate: typing.Callable[[], T_Result],
        severe: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is AllergyIntoleranceReactionSeverity.MILD:
            return mild()
        if self is AllergyIntoleranceReactionSeverity.MODERATE:
            return moderate()
        if self is AllergyIntoleranceReactionSeverity.SEVERE:
            return severe()
