# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class AsyncJobStatus(str, enum.Enum):
    """
    The status of the request.
    """

    ACCEPTED = "accepted"
    ACTIVE = "active"
    COMPLETED = "completed"
    ERROR = "error"

    def visit(
        self,
        accepted: typing.Callable[[], T_Result],
        active: typing.Callable[[], T_Result],
        completed: typing.Callable[[], T_Result],
        error: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is AsyncJobStatus.ACCEPTED:
            return accepted()
        if self is AsyncJobStatus.ACTIVE:
            return active()
        if self is AsyncJobStatus.COMPLETED:
            return completed()
        if self is AsyncJobStatus.ERROR:
            return error()
