# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .audit_event_detail import AuditEventDetail
from .base_64_binary import Base64Binary
from .coding import Coding
from .extension import Extension
from .reference import Reference

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class AuditEventEntity(pydantic.BaseModel):
    """
    A record of an event made for purposes of maintaining a security log. Typical uses include detection of intrusion attempts and monitoring for inappropriate usage.
    """

    id: typing.Optional[str] = pydantic.Field(
        default=None,
        description="Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.",
    )
    extension: typing.Optional[typing.List[Extension]] = pydantic.Field(
        default=None,
        description="May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.",
    )
    modifier_extension: typing.Optional[typing.List[Extension]] = pydantic.Field(
        alias="modifierExtension",
        default=None,
        description="May be used to represent additional information that is not part of the basic definition of the element and that modifies the understanding of the element in which it is contained and/or the understanding of the containing element's descendants. Usually modifier elements provide negation or qualification. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions. Modifier extensions SHALL NOT change the meaning of any elements on Resource or DomainResource (including cannot change the meaning of modifierExtension itself).",
    )
    what: typing.Optional[Reference] = pydantic.Field(
        default=None,
        description="Identifies a specific instance of the entity. The reference should be version specific.",
    )
    type: typing.Optional[Coding] = pydantic.Field(
        default=None, description="The type of the object that was involved in this audit event."
    )
    role: typing.Optional[Coding] = pydantic.Field(
        default=None, description="Code representing the role the entity played in the event being audited."
    )
    lifecycle: typing.Optional[Coding] = pydantic.Field(
        default=None, description="Identifier for the data life-cycle stage for the entity."
    )
    security_label: typing.Optional[typing.List[Coding]] = pydantic.Field(
        alias="securityLabel", default=None, description="Security labels for the identified entity."
    )
    name: typing.Optional[str] = pydantic.Field(default=None, description="A name of the entity in the audit event.")
    description: typing.Optional[str] = pydantic.Field(
        default=None, description="Text that describes the entity in more detail."
    )
    query: typing.Optional[Base64Binary] = pydantic.Field(
        default=None, description="The query parameters for a query-type entities."
    )
    detail: typing.Optional[typing.List[AuditEventDetail]] = pydantic.Field(
        default=None, description="Tagged value pairs for conveying additional information about the entity."
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
