# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .base_resource import BaseResource
from .codeable_concept import CodeableConcept
from .identifier import Identifier
from .reference import Reference

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class Basic(BaseResource):
    """
    Basic is used for handling concepts not yet defined in FHIR, narrative-only resources that don't map to an existing resource, and custom resources not appropriate for inclusion in the FHIR specification.
    """

    resource_type: typing.Literal["Basic"] = pydantic.Field(alias="resourceType")
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(
        default=None,
        description="Identifier assigned to the resource for business purposes, outside the context of FHIR.",
    )
    code: CodeableConcept = pydantic.Field(
        description="Identifies the 'type' of resource - equivalent to the resource name for other resources."
    )
    subject: typing.Optional[Reference] = pydantic.Field(
        default=None,
        description='Identifies the patient, practitioner, device or any other resource that is the "focus" of this resource.',
    )
    created: typing.Optional[dt.date] = pydantic.Field(
        default=None, description="Identifies when the resource was first created."
    )
    author: typing.Optional[Reference] = pydantic.Field(
        default=None, description="Indicates who was responsible for creating the resource instance."
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
