# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .attachment import Attachment
from .base_resource import BaseResource
from .codeable_concept import CodeableConcept
from .identifier import Identifier
from .reference import Reference

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class BodyStructure(BaseResource):
    """
    Record details about an anatomical structure. This resource may be used when a coded concept does not provide the necessary detail needed for the use case.
    """

    resource_type: typing.Literal["BodyStructure"] = pydantic.Field(alias="resourceType")
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(
        default=None, description="Identifier for this instance of the anatomical structure."
    )
    active: typing.Optional[bool] = pydantic.Field(default=None, description="Whether this body site is in active use.")
    morphology: typing.Optional[CodeableConcept] = pydantic.Field(
        default=None,
        description="The kind of structure being represented by the body structure at `BodyStructure.location`. This can define both normal and abnormal morphologies.",
    )
    location: typing.Optional[CodeableConcept] = pydantic.Field(
        default=None, description="The anatomical location or region of the specimen, lesion, or body structure."
    )
    location_qualifier: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        alias="locationQualifier",
        default=None,
        description="Qualifier to refine the anatomical location. These include qualifiers for laterality, relative location, directionality, number, and plane.",
    )
    description: typing.Optional[str] = pydantic.Field(
        default=None, description="A summary, characterization or explanation of the body structure."
    )
    image: typing.Optional[typing.List[Attachment]] = pydantic.Field(
        default=None, description="Image or images used to identify a location."
    )
    patient: Reference = pydantic.Field(description="The person to which the body site belongs.")

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
