# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .code import Code
from .uri import Uri

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class BulkDataExportOutput(pydantic.BaseModel):
    """
    An array of file items with one entry for each generated file. If no resources are returned from the kick-off request, the server SHOULD return an empty array.
    """

    type: Code = pydantic.Field(description="The FHIR resource type that is contained in the file.")
    url: Uri = pydantic.Field(
        description="The absolute path to the file. The format of the file SHOULD reflect that requested in the \_outputFormat parameter of the initial kick-off request."
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        json_encoders = {dt.datetime: serialize_datetime}
