# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .bundle_entry import BundleEntry
from .bundle_link import BundleLink
from .bundle_type import BundleType
from .code import Code
from .id import Id
from .identifier import Identifier
from .instant import Instant
from .meta import Meta
from .signature import Signature
from .unsigned_int import UnsignedInt
from .uri import Uri

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class Bundle(pydantic.BaseModel):
    """
    A container for a collection of resources.
    """

    resource_type: typing.Literal["Bundle"] = pydantic.Field(alias="resourceType")
    id: typing.Optional[Id] = pydantic.Field(
        default=None,
        description="The logical id of the resource, as used in the URL for the resource. Once assigned, this value never changes.",
    )
    meta: typing.Optional[Meta] = pydantic.Field(
        default=None,
        description="The metadata about the resource. This is content that is maintained by the infrastructure. Changes to the content might not always be associated with version changes to the resource.",
    )
    implicit_rules: typing.Optional[Uri] = pydantic.Field(
        alias="implicitRules",
        default=None,
        description="A reference to a set of rules that were followed when the resource was constructed, and which must be understood when processing the content. Often, this is a reference to an implementation guide that defines the special rules along with other profiles etc.",
    )
    language: typing.Optional[Code] = pydantic.Field(
        default=None, description="The base language in which the resource is written."
    )
    identifier: typing.Optional[Identifier] = pydantic.Field(
        default=None,
        description="A persistent identifier for the bundle that won't change as a bundle is copied from server to server.",
    )
    type: typing.Optional[BundleType] = pydantic.Field(
        default=None, description="Indicates the purpose of this bundle - how it is intended to be used."
    )
    timestamp: typing.Optional[Instant] = pydantic.Field(
        default=None,
        description="The date/time that the bundle was assembled - i.e. when the resources were placed in the bundle.",
    )
    total: typing.Optional[UnsignedInt] = pydantic.Field(
        default=None,
        description="If a set of search matches, this is the total number of entries of type 'match' across all pages in the search. It does not include search.mode = 'include' or 'outcome' entries and it does not provide a count of the number of entries in the Bundle.",
    )
    link: typing.Optional[typing.List[BundleLink]] = pydantic.Field(
        default=None, description="A series of links that provide context to this bundle."
    )
    entry: typing.Optional[typing.List[BundleEntry]] = pydantic.Field(
        default=None,
        description="An entry in a bundle resource - will either contain a resource or information about a resource (transactions and history only).",
    )
    signature: typing.Optional[Signature] = pydantic.Field(
        default=None, description="Digital Signature - base64 encoded. XML-DSig or a JWT."
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
