# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .bundle_request_method import BundleRequestMethod
from .extension import Extension
from .instant import Instant
from .uri import Uri

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class BundleRequest(pydantic.BaseModel):
    """
    A container for a collection of resources.
    """

    id: typing.Optional[str] = pydantic.Field(
        default=None,
        description="Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.",
    )
    extension: typing.Optional[typing.List[Extension]] = pydantic.Field(
        default=None,
        description="May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.",
    )
    modifier_extension: typing.Optional[typing.List[Extension]] = pydantic.Field(
        alias="modifierExtension",
        default=None,
        description="May be used to represent additional information that is not part of the basic definition of the element and that modifies the understanding of the element in which it is contained and/or the understanding of the containing element's descendants. Usually modifier elements provide negation or qualification. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions. Modifier extensions SHALL NOT change the meaning of any elements on Resource or DomainResource (including cannot change the meaning of modifierExtension itself).",
    )
    method: typing.Optional[BundleRequestMethod] = pydantic.Field(
        default=None,
        description="In a transaction or batch, this is the HTTP action to be executed for this entry. In a history bundle, this indicates the HTTP action that occurred.",
    )
    url: typing.Optional[Uri] = pydantic.Field(
        default=None,
        description="The URL for this entry, relative to the root (the address to which the request is posted).",
    )
    if_none_match: typing.Optional[str] = pydantic.Field(
        alias="ifNoneMatch",
        default=None,
        description='If the ETag values match, return a 304 Not Modified status. See the API documentation for ["Conditional Read"](http.html#cread).',
    )
    if_modified_since: typing.Optional[Instant] = pydantic.Field(
        alias="ifModifiedSince",
        default=None,
        description='Only perform the operation if the last updated date matches. See the API documentation for ["Conditional Read"](http.html#cread).',
    )
    if_match: typing.Optional[str] = pydantic.Field(
        alias="ifMatch",
        default=None,
        description='Only perform the operation if the Etag value matches. For more information, see the API section ["Managing Resource Contention"](http.html#concurrency).',
    )
    if_none_exist: typing.Optional[str] = pydantic.Field(
        alias="ifNoneExist",
        default=None,
        description='Instruct the server not to perform the create if a specified resource already exists. For further information, see the API documentation for ["Conditional Create"](http.html#ccreate). This is just the query portion of the URL - what follows the "?" (not including the "?").',
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
