# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class BundleRequestMethod(str, enum.Enum):
    """
    In a transaction or batch, this is the HTTP action to be executed for this entry. In a history bundle, this indicates the HTTP action that occurred.
    """

    GET = "GET"
    HEAD = "HEAD"
    POST = "POST"
    PUT = "PUT"
    DELETE = "DELETE"
    PATCH = "PATCH"

    def visit(
        self,
        get: typing.Callable[[], T_Result],
        head: typing.Callable[[], T_Result],
        post: typing.Callable[[], T_Result],
        put: typing.Callable[[], T_Result],
        delete: typing.Callable[[], T_Result],
        patch: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is BundleRequestMethod.GET:
            return get()
        if self is BundleRequestMethod.HEAD:
            return head()
        if self is BundleRequestMethod.POST:
            return post()
        if self is BundleRequestMethod.PUT:
            return put()
        if self is BundleRequestMethod.DELETE:
            return delete()
        if self is BundleRequestMethod.PATCH:
            return patch()
