# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class BundleType(str, enum.Enum):
    """
    Indicates the purpose of this bundle - how it is intended to be used.
    """

    DOCUMENT = "document"
    MESSAGE = "message"
    TRANSACTION = "transaction"
    TRANSACTION_RESPONSE = "transaction-response"
    BATCH = "batch"
    BATCH_RESPONSE = "batch-response"
    HISTORY = "history"
    SEARCHSET = "searchset"
    COLLECTION = "collection"

    def visit(
        self,
        document: typing.Callable[[], T_Result],
        message: typing.Callable[[], T_Result],
        transaction: typing.Callable[[], T_Result],
        transaction_response: typing.Callable[[], T_Result],
        batch: typing.Callable[[], T_Result],
        batch_response: typing.Callable[[], T_Result],
        history: typing.Callable[[], T_Result],
        searchset: typing.Callable[[], T_Result],
        collection: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is BundleType.DOCUMENT:
            return document()
        if self is BundleType.MESSAGE:
            return message()
        if self is BundleType.TRANSACTION:
            return transaction()
        if self is BundleType.TRANSACTION_RESPONSE:
            return transaction_response()
        if self is BundleType.BATCH:
            return batch()
        if self is BundleType.BATCH_RESPONSE:
            return batch_response()
        if self is BundleType.HISTORY:
            return history()
        if self is BundleType.SEARCHSET:
            return searchset()
        if self is BundleType.COLLECTION:
            return collection()
