# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class CapabilityStatementKind(str, enum.Enum):
    """
    The way that this statement is intended to be used, to describe an actual running instance of software, a particular product (kind, not instance of software) or a class of implementation (e.g. a desired purchase).
    """

    INSTANCE = "instance"
    CAPABILITY = "capability"
    REQUIREMENTS = "requirements"

    def visit(
        self,
        instance: typing.Callable[[], T_Result],
        capability: typing.Callable[[], T_Result],
        requirements: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is CapabilityStatementKind.INSTANCE:
            return instance()
        if self is CapabilityStatementKind.CAPABILITY:
            return capability()
        if self is CapabilityStatementKind.REQUIREMENTS:
            return requirements()
