# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class CapabilityStatementResourceVersioning(str, enum.Enum):
    """
    This field is set to no-version to specify that the system does not support (server) or use (client) versioning for this resource type. If this has some other value, the server must at least correctly track and populate the versionId meta-property on resources. If the value is 'versioned-update', then the server supports all the versioning features, including using e-tags for version integrity in the API.
    """

    NO_VERSION = "no-version"
    VERSIONED = "versioned"
    VERSIONED_UPDATE = "versioned-update"

    def visit(
        self,
        no_version: typing.Callable[[], T_Result],
        versioned: typing.Callable[[], T_Result],
        versioned_update: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is CapabilityStatementResourceVersioning.NO_VERSION:
            return no_version()
        if self is CapabilityStatementResourceVersioning.VERSIONED:
            return versioned()
        if self is CapabilityStatementResourceVersioning.VERSIONED_UPDATE:
            return versioned_update()
