# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .canonical import Canonical
from .capability_statement_interaction_1 import CapabilityStatementInteraction1
from .capability_statement_operation import CapabilityStatementOperation
from .capability_statement_resource import CapabilityStatementResource
from .capability_statement_rest_mode import CapabilityStatementRestMode
from .capability_statement_search_param import CapabilityStatementSearchParam
from .capability_statement_security import CapabilityStatementSecurity
from .extension import Extension
from .markdown import Markdown

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class CapabilityStatementRest(pydantic.BaseModel):
    """
    A Capability Statement documents a set of capabilities (behaviors) of a FHIR Server for a particular version of FHIR that may be used as a statement of actual server functionality or a statement of required or desired server implementation.
    """

    id: typing.Optional[str] = pydantic.Field(
        default=None,
        description="Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.",
    )
    extension: typing.Optional[typing.List[Extension]] = pydantic.Field(
        default=None,
        description="May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.",
    )
    modifier_extension: typing.Optional[typing.List[Extension]] = pydantic.Field(
        alias="modifierExtension",
        default=None,
        description="May be used to represent additional information that is not part of the basic definition of the element and that modifies the understanding of the element in which it is contained and/or the understanding of the containing element's descendants. Usually modifier elements provide negation or qualification. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions. Modifier extensions SHALL NOT change the meaning of any elements on Resource or DomainResource (including cannot change the meaning of modifierExtension itself).",
    )
    mode: typing.Optional[CapabilityStatementRestMode] = pydantic.Field(
        default=None,
        description="Identifies whether this portion of the statement is describing the ability to initiate or receive restful operations.",
    )
    documentation: typing.Optional[Markdown] = pydantic.Field(
        default=None,
        description="Information about the system's restful capabilities that apply across all applications, such as security.",
    )
    security: typing.Optional[CapabilityStatementSecurity] = pydantic.Field(
        default=None,
        description="Information about security implementation from an interface perspective - what a client needs to know.",
    )
    resource: typing.Optional[typing.List[CapabilityStatementResource]] = pydantic.Field(
        default=None,
        description="A specification of the restful capabilities of the solution for a specific resource type.",
    )
    interaction: typing.Optional[typing.List[CapabilityStatementInteraction1]] = pydantic.Field(
        default=None, description="A specification of restful operations supported by the system."
    )
    search_param: typing.Optional[typing.List[CapabilityStatementSearchParam]] = pydantic.Field(
        alias="searchParam",
        default=None,
        description="Search parameters that are supported for searching all resources for implementations to support and/or make use of - either references to ones defined in the specification, or additional ones defined for/by the implementation.",
    )
    operation: typing.Optional[typing.List[CapabilityStatementOperation]] = pydantic.Field(
        default=None,
        description="Definition of an operation or a named query together with its parameters and their meaning and type.",
    )
    compartment: typing.Optional[typing.List[Canonical]] = pydantic.Field(
        default=None,
        description="An absolute URI which is a reference to the definition of a compartment that the system supports. The reference is to a CompartmentDefinition resource by its canonical URL .",
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
