# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class CarePlanDetailStatus(str, enum.Enum):
    """
    Identifies what progress is being made for the specific activity.
    """

    NOT_STARTED = "not-started"
    SCHEDULED = "scheduled"
    IN_PROGRESS = "in-progress"
    ON_HOLD = "on-hold"
    COMPLETED = "completed"
    CANCELLED = "cancelled"
    STOPPED = "stopped"
    UNKNOWN = "unknown"
    ENTERED_IN_ERROR = "entered-in-error"

    def visit(
        self,
        not_started: typing.Callable[[], T_Result],
        scheduled: typing.Callable[[], T_Result],
        in_progress: typing.Callable[[], T_Result],
        on_hold: typing.Callable[[], T_Result],
        completed: typing.Callable[[], T_Result],
        cancelled: typing.Callable[[], T_Result],
        stopped: typing.Callable[[], T_Result],
        unknown: typing.Callable[[], T_Result],
        entered_in_error: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is CarePlanDetailStatus.NOT_STARTED:
            return not_started()
        if self is CarePlanDetailStatus.SCHEDULED:
            return scheduled()
        if self is CarePlanDetailStatus.IN_PROGRESS:
            return in_progress()
        if self is CarePlanDetailStatus.ON_HOLD:
            return on_hold()
        if self is CarePlanDetailStatus.COMPLETED:
            return completed()
        if self is CarePlanDetailStatus.CANCELLED:
            return cancelled()
        if self is CarePlanDetailStatus.STOPPED:
            return stopped()
        if self is CarePlanDetailStatus.UNKNOWN:
            return unknown()
        if self is CarePlanDetailStatus.ENTERED_IN_ERROR:
            return entered_in_error()
