# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .annotation import Annotation
from .base_resource import BaseResource
from .care_team_participant import CareTeamParticipant
from .care_team_status import CareTeamStatus
from .codeable_concept import CodeableConcept
from .contact_point import ContactPoint
from .identifier import Identifier
from .period import Period
from .reference import Reference

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class CareTeam(BaseResource):
    """
    The Care Team includes all the people and organizations who plan to participate in the coordination and delivery of care for a patient.
    """

    resource_type: typing.Literal["CareTeam"] = pydantic.Field(alias="resourceType")
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(
        default=None,
        description="Business identifiers assigned to this care team by the performer or other systems which remain constant as the resource is updated and propagates from server to server.",
    )
    status: typing.Optional[CareTeamStatus] = pydantic.Field(
        default=None, description="Indicates the current state of the care team."
    )
    category: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None,
        description="Identifies what kind of team. This is to support differentiation between multiple co-existing teams, such as care plan team, episode of care team, longitudinal care team.",
    )
    name: typing.Optional[str] = pydantic.Field(
        default=None,
        description='A label for human use intended to distinguish like teams. E.g. the "red" vs. "green" trauma teams.',
    )
    subject: typing.Optional[Reference] = pydantic.Field(
        default=None, description="Identifies the patient or group whose intended care is handled by the team."
    )
    encounter: typing.Optional[Reference] = pydantic.Field(
        default=None,
        description="The Encounter during which this CareTeam was created or to which the creation of this record is tightly associated.",
    )
    period: typing.Optional[Period] = pydantic.Field(
        default=None, description="Indicates when the team did (or is intended to) come into effect and end."
    )
    participant: typing.Optional[typing.List[CareTeamParticipant]] = pydantic.Field(
        default=None,
        description="Identifies all people and organizations who are expected to be involved in the care team.",
    )
    reason_code: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        alias="reasonCode", default=None, description="Describes why the care team exists."
    )
    reason_reference: typing.Optional[typing.List[Reference]] = pydantic.Field(
        alias="reasonReference", default=None, description="Condition(s) that this care team addresses."
    )
    managing_organization: typing.Optional[typing.List[Reference]] = pydantic.Field(
        alias="managingOrganization", default=None, description="The organization responsible for the care team."
    )
    telecom: typing.Optional[typing.List[ContactPoint]] = pydantic.Field(
        default=None, description="A central contact detail for the care team (that applies to all members)."
    )
    note: typing.Optional[typing.List[Annotation]] = pydantic.Field(
        default=None, description="Comments made about the CareTeam."
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
