# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class CareTeamStatus(str, enum.Enum):
    """
    Indicates the current state of the care team.
    """

    PROPOSED = "proposed"
    ACTIVE = "active"
    SUSPENDED = "suspended"
    INACTIVE = "inactive"
    ENTERED_IN_ERROR = "entered-in-error"

    def visit(
        self,
        proposed: typing.Callable[[], T_Result],
        active: typing.Callable[[], T_Result],
        suspended: typing.Callable[[], T_Result],
        inactive: typing.Callable[[], T_Result],
        entered_in_error: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is CareTeamStatus.PROPOSED:
            return proposed()
        if self is CareTeamStatus.ACTIVE:
            return active()
        if self is CareTeamStatus.SUSPENDED:
            return suspended()
        if self is CareTeamStatus.INACTIVE:
            return inactive()
        if self is CareTeamStatus.ENTERED_IN_ERROR:
            return entered_in_error()
