# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class CatalogEntryStatus(str, enum.Enum):
    """
    Used to support catalog exchange even for unsupported products, e.g. getting list of medications even if not prescribable.
    """

    DRAFT = "draft"
    ACTIVE = "active"
    RETIRED = "retired"
    UNKNOWN = "unknown"

    def visit(
        self,
        draft: typing.Callable[[], T_Result],
        active: typing.Callable[[], T_Result],
        retired: typing.Callable[[], T_Result],
        unknown: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is CatalogEntryStatus.DRAFT:
            return draft()
        if self is CatalogEntryStatus.ACTIVE:
            return active()
        if self is CatalogEntryStatus.RETIRED:
            return retired()
        if self is CatalogEntryStatus.UNKNOWN:
            return unknown()
