# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class ChargeItemStatus(str, enum.Enum):
    """
    The current state of the ChargeItem.
    """

    PLANNED = "planned"
    BILLABLE = "billable"
    NOT_BILLABLE = "not-billable"
    ABORTED = "aborted"
    BILLED = "billed"
    ENTERED_IN_ERROR = "entered-in-error"
    UNKNOWN = "unknown"

    def visit(
        self,
        planned: typing.Callable[[], T_Result],
        billable: typing.Callable[[], T_Result],
        not_billable: typing.Callable[[], T_Result],
        aborted: typing.Callable[[], T_Result],
        billed: typing.Callable[[], T_Result],
        entered_in_error: typing.Callable[[], T_Result],
        unknown: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is ChargeItemStatus.PLANNED:
            return planned()
        if self is ChargeItemStatus.BILLABLE:
            return billable()
        if self is ChargeItemStatus.NOT_BILLABLE:
            return not_billable()
        if self is ChargeItemStatus.ABORTED:
            return aborted()
        if self is ChargeItemStatus.BILLED:
            return billed()
        if self is ChargeItemStatus.ENTERED_IN_ERROR:
            return entered_in_error()
        if self is ChargeItemStatus.UNKNOWN:
            return unknown()
