# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .extension import Extension
from .period import Period
from .positive_int import PositiveInt
from .quantity import Quantity
from .reference import Reference

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class ClaimSupportingInfo(pydantic.BaseModel):
    """
    A provider issued list of professional services and products which have been provided, or are to be provided, to a patient which is sent to an insurer for reimbursement.
    """

    id: typing.Optional[str] = pydantic.Field(
        default=None,
        description="Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.",
    )
    extension: typing.Optional[typing.List[Extension]] = pydantic.Field(
        default=None,
        description="May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.",
    )
    modifier_extension: typing.Optional[typing.List[Extension]] = pydantic.Field(
        alias="modifierExtension",
        default=None,
        description="May be used to represent additional information that is not part of the basic definition of the element and that modifies the understanding of the element in which it is contained and/or the understanding of the containing element's descendants. Usually modifier elements provide negation or qualification. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions. Modifier extensions SHALL NOT change the meaning of any elements on Resource or DomainResource (including cannot change the meaning of modifierExtension itself).",
    )
    sequence: typing.Optional[PositiveInt] = pydantic.Field(
        default=None, description="A number to uniquely identify supporting information entries."
    )
    category: CodeableConcept = pydantic.Field(
        description="The general class of the information supplied: information; exception; accident, employment; onset, etc."
    )
    code: typing.Optional[CodeableConcept] = pydantic.Field(
        default=None,
        description="System and code pertaining to the specific information regarding special conditions relating to the setting, treatment or patient for which care is sought.",
    )
    timing_date: typing.Optional[str] = pydantic.Field(
        alias="timingDate", default=None, description="The date when or period to which this information refers."
    )
    timing_period: typing.Optional[Period] = pydantic.Field(
        alias="timingPeriod", default=None, description="The date when or period to which this information refers."
    )
    value_boolean: typing.Optional[bool] = pydantic.Field(
        alias="valueBoolean",
        default=None,
        description="Additional data or information such as resources, documents, images etc. including references to the data or the actual inclusion of the data.",
    )
    value_string: typing.Optional[str] = pydantic.Field(
        alias="valueString",
        default=None,
        description="Additional data or information such as resources, documents, images etc. including references to the data or the actual inclusion of the data.",
    )
    value_quantity: typing.Optional[Quantity] = pydantic.Field(
        alias="valueQuantity",
        default=None,
        description="Additional data or information such as resources, documents, images etc. including references to the data or the actual inclusion of the data.",
    )
    value_attachment: typing.Optional[Attachment] = pydantic.Field(
        alias="valueAttachment",
        default=None,
        description="Additional data or information such as resources, documents, images etc. including references to the data or the actual inclusion of the data.",
    )
    value_reference: typing.Optional[Reference] = pydantic.Field(
        alias="valueReference",
        default=None,
        description="Additional data or information such as resources, documents, images etc. including references to the data or the actual inclusion of the data.",
    )
    reason: typing.Optional[CodeableConcept] = pydantic.Field(
        default=None,
        description="Provides the reason in the situation where a reason code is required in addition to the content.",
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
