# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class ClaimUse(str, enum.Enum):
    """
    A code to indicate whether the nature of the request is: to request adjudication of products and services previously rendered; or requesting authorization and adjudication for provision in the future; or requesting the non-binding adjudication of the listed products and services which could be provided in the future.
    """

    CLAIM = "claim"
    PREAUTHORIZATION = "preauthorization"
    PREDETERMINATION = "predetermination"

    def visit(
        self,
        claim: typing.Callable[[], T_Result],
        preauthorization: typing.Callable[[], T_Result],
        predetermination: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is ClaimUse.CLAIM:
            return claim()
        if self is ClaimUse.PREAUTHORIZATION:
            return preauthorization()
        if self is ClaimUse.PREDETERMINATION:
            return predetermination()
