# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class CompartmentDefinitionCode(str, enum.Enum):
    """
    Which compartment this definition describes.
    """

    PATIENT = "Patient"
    ENCOUNTER = "Encounter"
    RELATED_PERSON = "RelatedPerson"
    PRACTITIONER = "Practitioner"
    DEVICE = "Device"

    def visit(
        self,
        patient: typing.Callable[[], T_Result],
        encounter: typing.Callable[[], T_Result],
        related_person: typing.Callable[[], T_Result],
        practitioner: typing.Callable[[], T_Result],
        device: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is CompartmentDefinitionCode.PATIENT:
            return patient()
        if self is CompartmentDefinitionCode.ENCOUNTER:
            return encounter()
        if self is CompartmentDefinitionCode.RELATED_PERSON:
            return related_person()
        if self is CompartmentDefinitionCode.PRACTITIONER:
            return practitioner()
        if self is CompartmentDefinitionCode.DEVICE:
            return device()
