# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class CompositionAttesterMode(str, enum.Enum):
    """
    The type of attestation the authenticator offers.
    """

    PERSONAL = "personal"
    PROFESSIONAL = "professional"
    LEGAL = "legal"
    OFFICIAL = "official"

    def visit(
        self,
        personal: typing.Callable[[], T_Result],
        professional: typing.Callable[[], T_Result],
        legal: typing.Callable[[], T_Result],
        official: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is CompositionAttesterMode.PERSONAL:
            return personal()
        if self is CompositionAttesterMode.PROFESSIONAL:
            return professional()
        if self is CompositionAttesterMode.LEGAL:
            return legal()
        if self is CompositionAttesterMode.OFFICIAL:
            return official()
