# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class CompositionStatus(str, enum.Enum):
    """
    The workflow/clinical status of this composition. The status is a marker for the clinical standing of the document.
    """

    PRELIMINARY = "preliminary"
    FINAL = "final"
    AMENDED = "amended"
    ENTERED_IN_ERROR = "entered-in-error"

    def visit(
        self,
        preliminary: typing.Callable[[], T_Result],
        final: typing.Callable[[], T_Result],
        amended: typing.Callable[[], T_Result],
        entered_in_error: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is CompositionStatus.PRELIMINARY:
            return preliminary()
        if self is CompositionStatus.FINAL:
            return final()
        if self is CompositionStatus.AMENDED:
            return amended()
        if self is CompositionStatus.ENTERED_IN_ERROR:
            return entered_in_error()
