# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class ConceptMapTargetEquivalence(str, enum.Enum):
    """
    The equivalence between the source and target concepts (counting for the dependencies and products). The equivalence is read from target to source (e.g. the target is 'wider' than the source).
    """

    RELATEDTO = "relatedto"
    EQUIVALENT = "equivalent"
    EQUAL = "equal"
    WIDER = "wider"
    SUBSUMES = "subsumes"
    NARROWER = "narrower"
    SPECIALIZES = "specializes"
    INEXACT = "inexact"
    UNMATCHED = "unmatched"
    DISJOINT = "disjoint"

    def visit(
        self,
        relatedto: typing.Callable[[], T_Result],
        equivalent: typing.Callable[[], T_Result],
        equal: typing.Callable[[], T_Result],
        wider: typing.Callable[[], T_Result],
        subsumes: typing.Callable[[], T_Result],
        narrower: typing.Callable[[], T_Result],
        specializes: typing.Callable[[], T_Result],
        inexact: typing.Callable[[], T_Result],
        unmatched: typing.Callable[[], T_Result],
        disjoint: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is ConceptMapTargetEquivalence.RELATEDTO:
            return relatedto()
        if self is ConceptMapTargetEquivalence.EQUIVALENT:
            return equivalent()
        if self is ConceptMapTargetEquivalence.EQUAL:
            return equal()
        if self is ConceptMapTargetEquivalence.WIDER:
            return wider()
        if self is ConceptMapTargetEquivalence.SUBSUMES:
            return subsumes()
        if self is ConceptMapTargetEquivalence.NARROWER:
            return narrower()
        if self is ConceptMapTargetEquivalence.SPECIALIZES:
            return specializes()
        if self is ConceptMapTargetEquivalence.INEXACT:
            return inexact()
        if self is ConceptMapTargetEquivalence.UNMATCHED:
            return unmatched()
        if self is ConceptMapTargetEquivalence.DISJOINT:
            return disjoint()
