# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class ConceptMapUnmappedMode(str, enum.Enum):
    """
    Defines which action to take if there is no match for the source concept in the target system designated for the group. One of 3 actions are possible: use the unmapped code (this is useful when doing a mapping between versions, and only a few codes have changed), use a fixed code (a default code), or alternatively, a reference to a different concept map can be provided (by canonical URL).
    """

    PROVIDED = "provided"
    FIXED = "fixed"
    OTHER_MAP = "other-map"

    def visit(
        self,
        provided: typing.Callable[[], T_Result],
        fixed: typing.Callable[[], T_Result],
        other_map: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is ConceptMapUnmappedMode.PROVIDED:
            return provided()
        if self is ConceptMapUnmappedMode.FIXED:
            return fixed()
        if self is ConceptMapUnmappedMode.OTHER_MAP:
            return other_map()
