# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class ConsentStatus(str, enum.Enum):
    """
    Indicates the current state of this consent.
    """

    DRAFT = "draft"
    PROPOSED = "proposed"
    ACTIVE = "active"
    REJECTED = "rejected"
    INACTIVE = "inactive"
    ENTERED_IN_ERROR = "entered-in-error"

    def visit(
        self,
        draft: typing.Callable[[], T_Result],
        proposed: typing.Callable[[], T_Result],
        active: typing.Callable[[], T_Result],
        rejected: typing.Callable[[], T_Result],
        inactive: typing.Callable[[], T_Result],
        entered_in_error: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is ConsentStatus.DRAFT:
            return draft()
        if self is ConsentStatus.PROPOSED:
            return proposed()
        if self is ConsentStatus.ACTIVE:
            return active()
        if self is ConsentStatus.REJECTED:
            return rejected()
        if self is ConsentStatus.INACTIVE:
            return inactive()
        if self is ConsentStatus.ENTERED_IN_ERROR:
            return entered_in_error()
