# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .contact_point_system import ContactPointSystem
from .contact_point_use import ContactPointUse
from .positive_int import PositiveInt

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class ContactPoint(pydantic.BaseModel):
    """
    Details for all kinds of technology mediated contact points for a person or organization, including telephone, email, etc.
    """

    id: typing.Optional[str] = pydantic.Field(
        default=None,
        description="Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.",
    )
    extension: typing.Optional[typing.List[Extension]] = pydantic.Field(
        default=None,
        description="May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.",
    )
    system: typing.Optional[ContactPointSystem] = pydantic.Field(
        default=None,
        description="Telecommunications form for contact point - what communications system is required to make use of the contact.",
    )
    value: typing.Optional[str] = pydantic.Field(
        default=None,
        description="The actual contact point details, in a form that is meaningful to the designated communication system (i.e. phone number or email address).",
    )
    use: typing.Optional[ContactPointUse] = pydantic.Field(
        default=None, description="Identifies the purpose for the contact point."
    )
    rank: typing.Optional[PositiveInt] = pydantic.Field(
        default=None,
        description="Specifies a preferred order in which to use a set of contacts. ContactPoints with lower rank values are more preferred than those with higher rank values.",
    )
    period: typing.Optional[Period] = pydantic.Field(
        default=None, description="Time period when the contact point was/is in use."
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        json_encoders = {dt.datetime: serialize_datetime}


from .extension import Extension  # noqa: E402
from .period import Period  # noqa: E402

ContactPoint.update_forward_refs()
