# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .annotation import Annotation
from .codeable_concept import CodeableConcept
from .contract_subject import ContractSubject
from .extension import Extension
from .period import Period
from .reference import Reference
from .timing import Timing
from .unsigned_int import UnsignedInt

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class ContractAction(pydantic.BaseModel):
    """
    Legally enforceable, formally recorded unilateral or bilateral directive i.e., a policy or agreement.
    """

    id: typing.Optional[str] = pydantic.Field(
        default=None,
        description="Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.",
    )
    extension: typing.Optional[typing.List[Extension]] = pydantic.Field(
        default=None,
        description="May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.",
    )
    modifier_extension: typing.Optional[typing.List[Extension]] = pydantic.Field(
        alias="modifierExtension",
        default=None,
        description="May be used to represent additional information that is not part of the basic definition of the element and that modifies the understanding of the element in which it is contained and/or the understanding of the containing element's descendants. Usually modifier elements provide negation or qualification. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions. Modifier extensions SHALL NOT change the meaning of any elements on Resource or DomainResource (including cannot change the meaning of modifierExtension itself).",
    )
    do_not_perform: typing.Optional[bool] = pydantic.Field(
        alias="doNotPerform", default=None, description="True if the term prohibits the action."
    )
    type: CodeableConcept = pydantic.Field(
        description="Activity or service obligation to be done or not done, performed or not performed, effectuated or not by this Contract term."
    )
    subject: typing.Optional[typing.List[ContractSubject]] = pydantic.Field(
        default=None, description="Entity of the action."
    )
    intent: CodeableConcept = pydantic.Field(
        description="Reason or purpose for the action stipulated by this Contract Provision."
    )
    link_id: typing.Optional[typing.List[str]] = pydantic.Field(
        alias="linkId",
        default=None,
        description="Id [identifier??] of the clause or question text related to this action in the referenced form or QuestionnaireResponse.",
    )
    status: CodeableConcept = pydantic.Field(description="Current state of the term action.")
    context: typing.Optional[Reference] = pydantic.Field(
        default=None, description="Encounter or Episode with primary association to specified term activity."
    )
    context_link_id: typing.Optional[typing.List[str]] = pydantic.Field(
        alias="contextLinkId",
        default=None,
        description="Id [identifier??] of the clause or question text related to the requester of this action in the referenced form or QuestionnaireResponse.",
    )
    occurrence_date_time: typing.Optional[str] = pydantic.Field(
        alias="occurrenceDateTime", default=None, description="When action happens."
    )
    occurrence_period: typing.Optional[Period] = pydantic.Field(
        alias="occurrencePeriod", default=None, description="When action happens."
    )
    occurrence_timing: typing.Optional[Timing] = pydantic.Field(
        alias="occurrenceTiming", default=None, description="When action happens."
    )
    requester: typing.Optional[typing.List[Reference]] = pydantic.Field(
        default=None, description="Who or what initiated the action and has responsibility for its activation."
    )
    requester_link_id: typing.Optional[typing.List[str]] = pydantic.Field(
        alias="requesterLinkId",
        default=None,
        description="Id [identifier??] of the clause or question text related to the requester of this action in the referenced form or QuestionnaireResponse.",
    )
    performer_type: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        alias="performerType",
        default=None,
        description="The type of individual that is desired or required to perform or not perform the action.",
    )
    performer_role: typing.Optional[CodeableConcept] = pydantic.Field(
        alias="performerRole",
        default=None,
        description="The type of role or competency of an individual desired or required to perform or not perform the action.",
    )
    performer: typing.Optional[Reference] = pydantic.Field(
        default=None, description="Indicates who or what is being asked to perform (or not perform) the ction."
    )
    performer_link_id: typing.Optional[typing.List[str]] = pydantic.Field(
        alias="performerLinkId",
        default=None,
        description="Id [identifier??] of the clause or question text related to the reason type or reference of this action in the referenced form or QuestionnaireResponse.",
    )
    reason_code: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        alias="reasonCode",
        default=None,
        description="Rationale for the action to be performed or not performed. Describes why the action is permitted or prohibited.",
    )
    reason_reference: typing.Optional[typing.List[Reference]] = pydantic.Field(
        alias="reasonReference",
        default=None,
        description="Indicates another resource whose existence justifies permitting or not permitting this action.",
    )
    reason: typing.Optional[typing.List[str]] = pydantic.Field(
        default=None, description="Describes why the action is to be performed or not performed in textual form."
    )
    reason_link_id: typing.Optional[typing.List[str]] = pydantic.Field(
        alias="reasonLinkId",
        default=None,
        description="Id [identifier??] of the clause or question text related to the reason type or reference of this action in the referenced form or QuestionnaireResponse.",
    )
    note: typing.Optional[typing.List[Annotation]] = pydantic.Field(
        default=None,
        description="Comments made about the term action made by the requester, performer, subject or other participants.",
    )
    security_label_number: typing.Optional[typing.List[UnsignedInt]] = pydantic.Field(
        alias="securityLabelNumber", default=None, description="Security labels that protects the action."
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
