# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .codeable_concept import CodeableConcept
from .contract_answer import ContractAnswer
from .contract_party import ContractParty
from .extension import Extension
from .identifier import Identifier
from .reference import Reference
from .unsigned_int import UnsignedInt

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class ContractOffer(pydantic.BaseModel):
    """
    Legally enforceable, formally recorded unilateral or bilateral directive i.e., a policy or agreement.
    """

    id: typing.Optional[str] = pydantic.Field(
        default=None,
        description="Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.",
    )
    extension: typing.Optional[typing.List[Extension]] = pydantic.Field(
        default=None,
        description="May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.",
    )
    modifier_extension: typing.Optional[typing.List[Extension]] = pydantic.Field(
        alias="modifierExtension",
        default=None,
        description="May be used to represent additional information that is not part of the basic definition of the element and that modifies the understanding of the element in which it is contained and/or the understanding of the containing element's descendants. Usually modifier elements provide negation or qualification. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions. Modifier extensions SHALL NOT change the meaning of any elements on Resource or DomainResource (including cannot change the meaning of modifierExtension itself).",
    )
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(
        default=None, description="Unique identifier for this particular Contract Provision."
    )
    party: typing.Optional[typing.List[ContractParty]] = pydantic.Field(default=None, description="Offer Recipient.")
    topic: typing.Optional[Reference] = pydantic.Field(
        default=None,
        description="The owner of an asset has the residual control rights over the asset: the right to decide all usages of the asset in any way not inconsistent with a prior contract, custom, or law (Hart, 1995, p. 30).",
    )
    type: typing.Optional[CodeableConcept] = pydantic.Field(
        default=None,
        description="Type of Contract Provision such as specific requirements, purposes for actions, obligations, prohibitions, e.g. life time maximum benefit.",
    )
    decision: typing.Optional[CodeableConcept] = pydantic.Field(
        default=None,
        description="Type of choice made by accepting party with respect to an offer made by an offeror/ grantee.",
    )
    decision_mode: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        alias="decisionMode", default=None, description="How the decision about a Contract was conveyed."
    )
    answer: typing.Optional[typing.List[ContractAnswer]] = pydantic.Field(
        default=None, description="Response to offer text."
    )
    text: typing.Optional[str] = pydantic.Field(default=None, description="Human readable form of this Contract Offer.")
    link_id: typing.Optional[typing.List[str]] = pydantic.Field(
        alias="linkId",
        default=None,
        description="The id of the clause or question text of the offer in the referenced questionnaire/response.",
    )
    security_label_number: typing.Optional[typing.List[UnsignedInt]] = pydantic.Field(
        alias="securityLabelNumber", default=None, description="Security labels that protects the offer."
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
