# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class ContributorType(str, enum.Enum):
    """
    The type of contributor.
    """

    AUTHOR = "author"
    EDITOR = "editor"
    REVIEWER = "reviewer"
    ENDORSER = "endorser"

    def visit(
        self,
        author: typing.Callable[[], T_Result],
        editor: typing.Callable[[], T_Result],
        reviewer: typing.Callable[[], T_Result],
        endorser: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is ContributorType.AUTHOR:
            return author()
        if self is ContributorType.EDITOR:
            return editor()
        if self is ContributorType.REVIEWER:
            return reviewer()
        if self is ContributorType.ENDORSER:
            return endorser()
