# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .codeable_concept import CodeableConcept
from .coverage_eligibility_request_diagnosis import CoverageEligibilityRequestDiagnosis
from .extension import Extension
from .money import Money
from .positive_int import PositiveInt
from .quantity import Quantity
from .reference import Reference

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class CoverageEligibilityRequestItem(pydantic.BaseModel):
    """
    The CoverageEligibilityRequest provides patient and insurance coverage information to an insurer for them to respond, in the form of an CoverageEligibilityResponse, with information regarding whether the stated coverage is valid and in-force and optionally to provide the insurance details of the policy.
    """

    id: typing.Optional[str] = pydantic.Field(
        default=None,
        description="Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.",
    )
    extension: typing.Optional[typing.List[Extension]] = pydantic.Field(
        default=None,
        description="May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.",
    )
    modifier_extension: typing.Optional[typing.List[Extension]] = pydantic.Field(
        alias="modifierExtension",
        default=None,
        description="May be used to represent additional information that is not part of the basic definition of the element and that modifies the understanding of the element in which it is contained and/or the understanding of the containing element's descendants. Usually modifier elements provide negation or qualification. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions. Modifier extensions SHALL NOT change the meaning of any elements on Resource or DomainResource (including cannot change the meaning of modifierExtension itself).",
    )
    supporting_info_sequence: typing.Optional[typing.List[PositiveInt]] = pydantic.Field(
        alias="supportingInfoSequence",
        default=None,
        description="Exceptions, special conditions and supporting information applicable for this service or product line.",
    )
    category: typing.Optional[CodeableConcept] = pydantic.Field(
        default=None,
        description="Code to identify the general type of benefits under which products and services are provided.",
    )
    product_or_service: typing.Optional[CodeableConcept] = pydantic.Field(
        alias="productOrService",
        default=None,
        description="This contains the product, service, drug or other billing code for the item.",
    )
    modifier: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None,
        description="Item typification or modifiers codes to convey additional context for the product or service.",
    )
    provider: typing.Optional[Reference] = pydantic.Field(
        default=None,
        description="The practitioner who is responsible for the product or service to be rendered to the patient.",
    )
    quantity: typing.Optional[Quantity] = pydantic.Field(
        default=None, description="The number of repetitions of a service or product."
    )
    unit_price: typing.Optional[Money] = pydantic.Field(
        alias="unitPrice",
        default=None,
        description="The amount charged to the patient by the provider for a single unit.",
    )
    facility: typing.Optional[Reference] = pydantic.Field(
        default=None, description="Facility where the services will be provided."
    )
    diagnosis: typing.Optional[typing.List[CoverageEligibilityRequestDiagnosis]] = pydantic.Field(
        default=None, description="Patient diagnosis for which care is sought."
    )
    detail: typing.Optional[typing.List[Reference]] = pydantic.Field(
        default=None, description="The plan/proposal/order describing the proposed service in detail."
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
